/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configured;
import net.librec.data.DataAppender;
import net.librec.data.DataContext;
import net.librec.data.DataConvertor;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.data.FeatureAppender;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.math.structure.DataSet;
import net.librec.util.DriverClassUtil;
import net.librec.util.ReflectionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataModel
extends Configured
implements DataModel {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected DataContext context;
    protected DataSet trainDataSet;
    protected DataSet testDataSet;
    protected DataSet validDataSet;
    protected DataConvertor dataConvertor;
    public DataSplitter dataSplitter;
    public DataAppender dataAppender;
    public FeatureAppender featureAppender;

    protected abstract void buildConvert() throws LibrecException;

    protected void buildSplitter() throws LibrecException {
        String splitter = this.conf.get("data.model.splitter");
        try {
            if (this.dataSplitter == null) {
                this.dataSplitter = (DataSplitter)ReflectionUtil.newInstance(DriverClassUtil.getClass(splitter), this.conf);
            }
            if (this.dataSplitter != null) {
                this.dataSplitter.setDataConvertor(this.dataConvertor);
                if (this.dataSplitter instanceof KCVDataSplitter) {
                    ((KCVDataSplitter)this.dataSplitter).splitFolds();
                }
                this.dataSplitter.splitData();
                this.trainDataSet = this.dataSplitter.getTrainData();
                this.testDataSet = this.dataSplitter.getTestData();
            }
        }
        catch (ClassNotFoundException e) {
            throw new LibrecException(e);
        }
    }

    protected void buildDataAppender() throws LibrecException {
        String dataAppenderClass = this.conf.get("data.appender.class");
        if (StringUtils.isNotBlank(dataAppenderClass)) {
            try {
                this.dataAppender = (DataAppender)ReflectionUtil.newInstance(DriverClassUtil.getClass(dataAppenderClass), this.conf);
                this.dataAppender.setUserMappingData(this.getUserMappingData());
                this.dataAppender.setItemMappingData(this.getItemMappingData());
                this.dataAppender.processData();
            }
            catch (ClassNotFoundException e) {
                throw new LibrecException(e);
            }
            catch (IOException e) {
                throw new LibrecException(e);
            }
        }
    }

    protected void buildFeatureAppender() throws LibrecException {
        String featureAppenderClass = this.conf.get("feature.appender.class");
        if (StringUtils.isNotBlank(featureAppenderClass)) {
            try {
                this.featureAppender = (FeatureAppender)ReflectionUtil.newInstance(DriverClassUtil.getClass(featureAppenderClass), this.conf);
                this.featureAppender.setUserMappingData(this.getUserMappingData());
                this.featureAppender.setItemMappingData(this.getItemMappingData());
                this.featureAppender.processData();
            }
            catch (ClassNotFoundException e) {
                throw new LibrecException(e);
            }
            catch (IOException e) {
                throw new LibrecException(e);
            }
        }
    }

    @Override
    public void buildDataModel() throws LibrecException {
        this.context = new DataContext(this.conf);
        if (!this.conf.getBoolean("data.convert.read.ready")) {
            this.buildConvert();
            this.LOG.info("Transform data to Convertor successfully!");
            this.conf.setBoolean("data.convert.read.ready", true);
        }
        this.buildSplitter();
        this.LOG.info("Split data to train Set and test Set successfully!");
        if (this.trainDataSet != null && this.trainDataSet.size() > 0 && this.testDataSet != null && this.testDataSet.size() > 0) {
            this.LOG.info("Data size of training is " + this.trainDataSet.size());
            this.LOG.info("Data size of testing is " + this.testDataSet.size());
        }
        if (StringUtils.isNotBlank(this.conf.get("data.appender.class")) && !this.conf.getBoolean("data.appender.read.ready")) {
            this.buildDataAppender();
            this.LOG.info("Data appender loaded successfully!");
            this.conf.setBoolean("data.appender.read.ready", true);
        }
        if (StringUtils.isNotBlank(this.conf.get("feature.appender.class")) && !this.conf.getBoolean("feature.appender.read.ready")) {
            this.buildFeatureAppender();
            this.LOG.info("Feature appender loaded successfully!");
            this.conf.setBoolean("feature.appender.read.ready", true);
        }
    }

    @Override
    public void loadDataModel() throws LibrecException {
    }

    @Override
    public void saveDataModel() throws LibrecException {
    }

    @Override
    public DataSet getTrainDataSet() {
        return this.trainDataSet;
    }

    @Override
    public DataSet getTestDataSet() {
        return this.testDataSet;
    }

    @Override
    public DataSet getValidDataSet() {
        return this.validDataSet;
    }

    @Override
    public DataSplitter getDataSplitter() {
        return this.dataSplitter;
    }

    @Override
    public DataAppender getDataAppender() {
        return this.dataAppender;
    }

    @Override
    public FeatureAppender getFeatureAppender() {
        return this.featureAppender;
    }

    @Override
    public DataContext getContext() {
        return this.context;
    }
}

