/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor.appender;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.librec.conf.Configuration;
import net.librec.conf.Configured;
import net.librec.data.FeatureAppender;
import net.librec.math.structure.SparseMatrix;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ItemFeatureAppender
extends Configured
implements FeatureAppender {
    private static final int BSIZE = 0x100000;
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected SparseMatrix m_itemFeatureMatrix;
    protected String m_inputDataPath;
    protected BiMap<String, Integer> m_featureIdMap;
    protected BiMap<String, Integer> m_itemIdMap;

    public ItemFeatureAppender() {
        this(null);
    }

    public ItemFeatureAppender(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void processData() throws IOException {
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.itemfeature.path"))) {
            this.m_inputDataPath = this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.itemfeature.path");
            this.readData(this.m_inputDataPath);
        }
    }

    private void readData(String inputDataPath) throws IOException {
        HashBasedTable<Integer, Integer, Integer> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        this.m_featureIdMap = HashBiMap.create();
        final ArrayList files = new ArrayList();
        final ArrayList fileSizeList = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileSizeList.add(file.toFile().length());
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        Files.walkFileTree(Paths.get(inputDataPath, new String[0]), (FileVisitor<? super Path>)finder);
        long allFileSize = 0L;
        for (Long everyFileSize : fileSizeList) {
            allFileSize += everyFileSize.longValue();
        }
        for (File dataFile : files) {
            int len;
            FileInputStream fis = new FileInputStream(dataFile);
            FileChannel fileRead = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            String bufferLine = new String();
            byte[] bytes = new byte[0x100000];
            while ((len = fileRead.read(buffer)) != -1) {
                buffer.flip();
                buffer.get(bytes, 0, len);
                bufferLine = bufferLine.concat(new String(bytes, 0, len)).replaceAll("\r", "\n");
                String[] bufferData = bufferLine.split("(\n)+");
                boolean isComplete = bufferLine.endsWith("\n");
                int loopLength = isComplete ? bufferData.length : bufferData.length - 1;
                for (int i = 0; i < loopLength; ++i) {
                    int innerFeature;
                    int value;
                    String line = new String(bufferData[i]);
                    String[] data = line.trim().split("[ \t,]+");
                    String outerItem = data[0];
                    String outerFeature = data[1];
                    int n = value = data.length >= 3 ? Integer.valueOf(data[2]) : 1;
                    if (this.m_featureIdMap.containsKey(outerFeature)) {
                        innerFeature = (Integer)this.m_featureIdMap.get(outerFeature);
                    } else {
                        innerFeature = this.m_featureIdMap.size();
                        this.m_featureIdMap.put(outerFeature, innerFeature);
                    }
                    if (this.m_itemIdMap.containsKey(outerItem)) {
                        int row = (Integer)this.m_itemIdMap.get(outerItem);
                        int col = innerFeature;
                        dataTable.put(row, col, value);
                        colMap.put(col, row);
                        continue;
                    }
                    this.LOG.info("In ItemFeatureAppender, no such item" + outerItem);
                }
                if (!isComplete) {
                    bufferLine = bufferData[bufferData.length - 1];
                }
                buffer.clear();
            }
            fileRead.close();
            fis.close();
        }
        int numRows = this.m_itemIdMap.size();
        int numCols = this.m_featureIdMap.size();
        this.m_itemFeatureMatrix = new SparseMatrix(numRows, numCols, dataTable, colMap);
        dataTable = null;
    }

    @Override
    public SparseMatrix getItemFeatures() {
        return this.m_itemFeatureMatrix;
    }

    @Override
    public SparseMatrix getUserFeatures() {
        return null;
    }

    @Override
    public int getItemFeatureId(String outerFeatureId) {
        return (Integer)this.m_featureIdMap.get(outerFeatureId);
    }

    @Override
    public int getUserFeatureId(String outerFeatureId) {
        return -1;
    }

    @Override
    public void setUserMappingData(BiMap<String, Integer> userMappingData) {
    }

    @Override
    public void setItemMappingData(BiMap<String, Integer> itemMappingData) {
        this.m_itemIdMap = itemMappingData;
    }

    @Override
    public BiMap<String, Integer> getUserFeatureMap() {
        return null;
    }

    @Override
    public BiMap<String, Integer> getItemFeatureMap() {
        return this.m_featureIdMap;
    }
}

