/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.librec.data.convertor.AbstractDataConvertor;
import net.librec.data.model.ArffAttribute;
import net.librec.data.model.ArffInstance;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseTensor;

public class ArffDataConvertor
extends AbstractDataConvertor {
    private String dataPath;
    private String relationName;
    private ArrayList<ArffInstance> instances;
    private ArrayList<ArffAttribute> attributes;
    private ArrayList<String> attrTypes;
    private ArrayList<BiMap<String, Integer>> columnIds;
    private int userCol;
    private int itemCol;
    private int ratingCol;
    public SparseMatrix oneHotFeatureMatrix;
    public DenseVector oneHotRatingVector;
    private ArrayList<BiMap<String, Integer>> featuresInnerMapping;

    public ArffDataConvertor(String path) {
        this.dataPath = path;
        this.instances = new ArrayList();
        this.attributes = new ArrayList();
        this.columnIds = new ArrayList();
        this.attrTypes = new ArrayList();
        this.userCol = -1;
        this.itemCol = -1;
        this.ratingCol = -1;
    }

    public ArffDataConvertor(String path, ArrayList<BiMap<String, Integer>> featureMapping) {
        this(path);
        this.featuresInnerMapping = featureMapping;
    }

    public void readData() throws IOException {
        int i;
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        Files.walkFileTree(Paths.get(this.dataPath, new String[0]), (FileVisitor<? super Path>)finder);
        for (i = 0; i < files.size(); ++i) {
            boolean dataFlag;
            BufferedReader br;
            if (0 == i) {
                br = new BufferedReader(new FileReader((File)files.get(i)));
                dataFlag = false;
                int attrIdx = 0;
                String attrName = null;
                String attrType = null;
                String line = null;
                while (true) {
                    if (dataFlag) {
                        for (ArffAttribute attr : this.attributes) {
                            this.attrTypes.add(attr.getType());
                        }
                        this.dataReader(br);
                    }
                    if ((line = br.readLine()) == null) break;
                    if (line.isEmpty() || line.startsWith("%")) continue;
                    String[] data = line.trim().split("[ \t]");
                    if (data[0].toUpperCase().equals("@RELATION")) {
                        this.relationName = data[1];
                        continue;
                    }
                    if (data[0].toUpperCase().equals("@ATTRIBUTE")) {
                        attrName = data[1];
                        attrType = data[2];
                        boolean isNominal = false;
                        if (attrName.equals("user")) {
                            this.userCol = attrIdx;
                        }
                        if (attrName.equals("item")) {
                            this.itemCol = attrIdx;
                        }
                        if (attrName.equals("rating")) {
                            this.ratingCol = attrIdx;
                        }
                        if (attrType.startsWith("{") && attrType.endsWith("}")) {
                            isNominal = true;
                        }
                        HashBiMap<String, Integer> colId = HashBiMap.create();
                        if (isNominal) {
                            String nominalAttrs = attrType.substring(1, attrType.length() - 1);
                            int val = 0;
                            for (String attr : nominalAttrs.split(",")) {
                                colId.put(attr.trim(), val++);
                            }
                            attrType = "NOMINAL";
                        }
                        this.columnIds.add(colId);
                        this.attributes.add(new ArffAttribute(attrName, attrType.toUpperCase(), attrIdx++));
                        continue;
                    }
                    if (!data[0].toUpperCase().equals("@DATA")) continue;
                    dataFlag = true;
                }
                br.close();
                continue;
            }
            br = new BufferedReader(new FileReader((File)files.get(i)));
            dataFlag = false;
            String line = null;
            while (true) {
                String[] data;
                if (dataFlag) {
                    this.dataReader(br);
                }
                if ((line = br.readLine()) == null) break;
                if (line.isEmpty() || line.startsWith("%") || (data = line.trim().split("[ \t]"))[0].toUpperCase().equals("@RELATION") || data[0].toUpperCase().equals("@ATTRIBUTE") || !data[0].toUpperCase().equals("@DATA")) continue;
                dataFlag = true;
            }
            br.close();
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).setColumnSet(this.columnIds.get(i).keySet());
        }
        ArffInstance.attrs = this.attributes;
        this.sparseTensor = this.generateFeatureTensor();
        this.sparseTensor.setUserDimension(this.userCol);
        this.sparseTensor.setItemDimension(this.itemCol);
        this.preferenceMatrix = this.sparseTensor.rateMatrix();
    }

    private void dataReader(Reader rd) throws IOException {
        ArrayList<String> dataLine = new ArrayList<String>();
        StringBuilder subString = new StringBuilder();
        boolean isInQuote = false;
        boolean isInBracket = false;
        int c = 0;
        while ((c = rd.read()) != -1) {
            char ch = (char)c;
            if (ch == '\n') {
                if (dataLine.size() == 0 || ((String)dataLine.get(0)).startsWith("%")) continue;
                dataLine.add(subString.toString());
                if (dataLine.size() != this.attrTypes.size()) {
                    throw new IOException("Read data error, inconsistent attribute number!");
                }
                for (int i = 0; i < dataLine.size(); ++i) {
                    String col = ((String)dataLine.get(i)).trim();
                    String type = this.attrTypes.get(i);
                    BiMap<String, Integer> colId = this.columnIds.get(i);
                    switch (type) {
                        case "NUMERIC": 
                        case "REAL": 
                        case "INTEGER": {
                            break;
                        }
                        case "STRING": {
                            int val = colId.containsKey(col) ? ((Integer)colId.get(col)).intValue() : colId.size();
                            colId.put(col, val);
                            break;
                        }
                        case "NOMINAL": {
                            StringBuilder sb = new StringBuilder();
                            String[] ss = col.split(",");
                            for (int ns = 0; ns < ss.length; ++ns) {
                                String _s = ss[ns].trim();
                                if (!colId.containsKey(_s)) {
                                    throw new IOException("Read data error, inconsistent nominal value!");
                                }
                                sb.append(_s);
                                if (ns == ss.length - 1) continue;
                                sb.append(",");
                            }
                            col = sb.toString();
                        }
                    }
                    dataLine.set(i, col);
                }
                this.instances.add(new ArffInstance(dataLine));
                subString = new StringBuilder();
                dataLine = new ArrayList();
                continue;
            }
            if (ch == '[' || ch == ']') {
                isInBracket = !isInBracket;
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\"') {
                isInQuote = !isInQuote;
                continue;
            }
            if (ch == ',' && !isInQuote && !isInBracket) {
                dataLine.add(subString.toString());
                subString = new StringBuilder();
                continue;
            }
            subString.append(ch);
        }
    }

    @Override
    public void processData() throws IOException {
        this.readData();
    }

    @Override
    public void progress() {
    }

    public void oneHotEncoding() {
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int numRows = this.instances.size();
        int numCols = 0;
        int numAttrs = this.attributes.size();
        double[] ratings = new double[numRows];
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i == this.ratingCol) continue;
            ArffAttribute attr = this.attributes.get(i);
            numCols += attr.getColumnSet().size() == 0 ? 1 : attr.getColumnSet().size();
        }
        for (int row = 0; row < numRows; ++row) {
            ArffInstance instance = this.instances.get(row);
            int colPrefix = 0;
            int col = 0;
            block14: for (int i = 0; i < numAttrs; ++i) {
                String type = this.attrTypes.get(i);
                Object val = instance.getValueByIndex(i);
                if (i == this.ratingCol) {
                    ratings[row] = (Double)val;
                    continue;
                }
                switch (type) {
                    case "NUMERIC": 
                    case "REAL": 
                    case "INTEGER": {
                        col = colPrefix++;
                        dataTable.put(row, col, (Double)val);
                        colMap.put(col, row);
                        continue block14;
                    }
                    case "STRING": {
                        col = colPrefix + (Integer)this.columnIds.get(i).get(val);
                        dataTable.put(row, col, 1.0);
                        colMap.put(col, row);
                        colPrefix += this.columnIds.get(i).size();
                        continue block14;
                    }
                    case "NOMINAL": {
                        for (String v : (ArrayList)val) {
                            col = colPrefix + (Integer)this.columnIds.get(i).get(v);
                            colMap.put(col, row);
                            dataTable.put(row, col, 1.0);
                        }
                        colPrefix += this.columnIds.get(i).size();
                    }
                }
            }
        }
        this.oneHotFeatureMatrix = new SparseMatrix(numRows, numCols, dataTable, colMap);
        this.oneHotRatingVector = new DenseVector(ratings);
        dataTable = null;
        colMap = null;
    }

    private SparseTensor generateFeatureTensor() {
        int i;
        int numRows = this.instances.size();
        int numAttrs = this.attributes.size();
        ArrayList<Double> ratings = new ArrayList<Double>();
        List[] nDKeys = new List[numAttrs];
        for (int d = 0; d < numAttrs; ++d) {
            nDKeys[d] = new ArrayList();
        }
        ArrayList setOfAttrs = new ArrayList();
        for (i = 0; i < numAttrs - 1; ++i) {
            setOfAttrs.add(new HashSet());
        }
        if (this.featuresInnerMapping == null) {
            this.featuresInnerMapping = new ArrayList();
            for (i = 0; i < numAttrs - 1; ++i) {
                HashBiMap featureInnerId = HashBiMap.create();
                this.featuresInnerMapping.add(featureInnerId);
            }
        }
        for (int row = 0; row < numRows; ++row) {
            ArffInstance instance = this.instances.get(row);
            for (int i2 = 0; i2 < numAttrs; ++i2) {
                if (i2 == this.userCol) {
                    int j = i2 > this.ratingCol ? i2 - 1 : i2;
                    double userId = (Double)instance.getValueByIndex(this.userCol);
                    String strUserId = String.valueOf((int)userId);
                    int userInnerId = this.featuresInnerMapping.get(j).containsKey(strUserId) ? ((Integer)this.featuresInnerMapping.get(j).get(strUserId)).intValue() : this.featuresInnerMapping.get(j).size();
                    this.featuresInnerMapping.get(j).put(strUserId, userInnerId);
                    nDKeys[j].add(userInnerId);
                    ((HashSet)setOfAttrs.get(j)).add(userInnerId);
                    continue;
                }
                if (i2 == this.itemCol) {
                    int j = i2 > this.ratingCol ? i2 - 1 : i2;
                    double itemId = (Double)instance.getValueByIndex(this.itemCol);
                    String strItemId = String.valueOf((int)itemId);
                    int itemInnerId = this.featuresInnerMapping.get(j).containsKey(strItemId) ? ((Integer)this.featuresInnerMapping.get(j).get(strItemId)).intValue() : this.featuresInnerMapping.get(j).size();
                    this.featuresInnerMapping.get(j).put(strItemId, itemInnerId);
                    nDKeys[j].add(itemInnerId);
                    ((HashSet)setOfAttrs.get(j)).add(itemInnerId);
                    continue;
                }
                if (i2 == this.ratingCol) {
                    double rating = (Double)instance.getValueByIndex(this.ratingCol);
                    ratings.add(rating);
                    continue;
                }
                int j = i2 > this.ratingCol ? i2 - 1 : i2;
                String attrType = this.attrTypes.get(i2);
                if (attrType.equals("STRING")) {
                    String strAttr = (String)instance.getValueByIndex(i2);
                    int featureInnerId = this.featuresInnerMapping.get(j).containsKey(strAttr) ? ((Integer)this.featuresInnerMapping.get(j).get(strAttr)).intValue() : this.featuresInnerMapping.get(j).size();
                    this.featuresInnerMapping.get(j).put(strAttr, featureInnerId);
                    nDKeys[j].add(featureInnerId);
                    ((HashSet)setOfAttrs.get(j)).add(featureInnerId);
                    continue;
                }
                double val = (Double)instance.getValueByIndex(i2);
                String strFeatureId = String.valueOf((int)val);
                int featureInnerId = this.featuresInnerMapping.get(j).containsKey(strFeatureId) ? ((Integer)this.featuresInnerMapping.get(j).get(strFeatureId)).intValue() : this.featuresInnerMapping.get(j).size();
                this.featuresInnerMapping.get(j).put(strFeatureId, featureInnerId);
                nDKeys[j].add(featureInnerId);
                ((HashSet)setOfAttrs.get(j)).add(featureInnerId);
            }
        }
        int[] dims = new int[numAttrs - 1];
        for (int i3 = 0; i3 < numAttrs - 1; ++i3) {
            dims[i3] = ((HashSet)setOfAttrs.get(i3)).size();
        }
        return new SparseTensor(dims, nDKeys, ratings);
    }

    public String getRelationName() {
        return this.relationName;
    }

    public ArrayList<ArffInstance> getInstances() {
        return this.instances;
    }

    public ArrayList<ArffAttribute> getAttributes() {
        return this.attributes;
    }

    public BiMap<String, Integer> getUserIds() {
        return this.featuresInnerMapping.get(this.userCol);
    }

    public BiMap<String, Integer> getItemIds() {
        return this.featuresInnerMapping.get(this.itemCol);
    }

    public ArrayList<BiMap<String, Integer>> getAllFeatureIds() {
        return this.featuresInnerMapping;
    }
}

