/*
 * Decompiled with CFR 0.152.
 */
package net.librec.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.librec.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration
implements Iterable<Map.Entry<String, String>> {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private static final ConcurrentMap<ClassLoader, Map<String, Class<?>>> CACHE_CLASSES = new ConcurrentHashMap();
    private Properties properties;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean loadDefaults;
    private ArrayList<Resource> resources;
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();

    public Configuration() {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = true;
        this.resources = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultResource(String name) {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (defaultResources.contains(name)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            defaultResources.add(name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    public synchronized void addResource(Resource resource) {
        this.loadProperty(this.getProps(), resource);
        this.resources.add(resource);
    }

    private void overlay(Properties to, Properties from) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    public void set(String name, String value) {
        this.getProps().setProperty(name, value);
    }

    public String get(String name) {
        return this.getProps().getProperty(name);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtil.arrayToString(values));
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtil.getStrings(valueString);
    }

    public Float getFloat(String name, Float defaultValue) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Float.valueOf(value);
        }
        return defaultValue;
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public Float getFloat(String name) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Float.valueOf(value);
        }
        return null;
    }

    public void setDouble(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public Double getDouble(String name, Double defaultValue) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Double.valueOf(value);
        }
        return defaultValue;
    }

    public Double getDouble(String name) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Double.valueOf(value);
        }
        return null;
    }

    public String get(String name, String defaultValue) {
        String value = this.get(name);
        return StringUtils.isNotBlank(value) ? value : defaultValue;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public Long getLong(String name, Long defaultValue) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Long.valueOf(value);
        }
        return defaultValue;
    }

    public Long getLong(String name) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Long.valueOf(value);
        }
        return null;
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public Integer getInt(String name, Integer defaultValue) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public Integer getInt(String name) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public void setInts(String name, int[] values) {
        this.set(name, StringUtil.arrayToString(values));
    }

    public int[] getInts(String name) {
        String[] strings = this.getTrimmedStrings(name);
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtil.getTrimmedStrings(valueString);
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public boolean getBoolean(String name) {
        String value = this.get(name);
        return StringUtils.isNotBlank(value) ? Boolean.valueOf(value) : false;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (StringUtils.isNotBlank(value)) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources);
        }
        return this.properties;
    }

    private void loadResources(Properties properties, ArrayList<Resource> resources) {
        if (this.loadDefaults) {
            for (String string : defaultResources) {
                this.loadProperty(properties, new Resource(string));
            }
        }
        for (Resource resource : resources) {
            this.loadProperty(properties, resource);
        }
    }

    private void loadProperty(Properties properties, Resource wrapper) {
        Object resource = wrapper.getResource();
        try {
            if (resource instanceof URL) {
                InputStream fis = ((URL)resource).openStream();
                properties.load(fis);
            } else if (resource instanceof String) {
                URL url = this.getResource((String)resource);
                if (url != null) {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        connection.setUseCaches(false);
                    }
                    InputStream fis = connection.getInputStream();
                    properties.load(fis);
                }
            } else if (resource instanceof Path) {
                FileInputStream fis = new FileInputStream(new File(((Path)resource).toUri().getPath()));
                properties.load(fis);
            } else if (resource instanceof InputStream) {
                InputStream fis = (InputStream)resource;
                properties.load(fis);
            } else if (resource instanceof Properties) {
                this.overlay(properties, (Properties)resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        ConcurrentHashMap newMap;
        ConcurrentHashMap map = (ConcurrentHashMap)CACHE_CLASSES.get(this.classLoader);
        if (map == null && (map = (Map)CACHE_CLASSES.putIfAbsent(this.classLoader, newMap = new ConcurrentHashMap())) == null) {
            map = newMap;
        }
        if ((clazz = (Class<?>)map.get(name)) == null && (clazz = Class.forName(name, true, this.classLoader)) != null) {
            map.put(name, clazz);
        }
        return clazz;
    }

    public Class<?> getClassByName(String name, String defaultName) throws ClassNotFoundException {
        try {
            return this.getClassByName(name);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e);
            return this.getClassByName(defaultName);
        }
    }

    static {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        if (cL.getResource("librec-default.properties") != null) {
            Configuration.addDefaultResource("librec-default.properties");
        }
        if (cL.getResource("librec.properties") != null) {
            Configuration.addDefaultResource("librec.properties");
        }
    }

    public static class Resource {
        private final Object resource;
        private final String name;

        public Resource(Object resource) {
            this(resource, resource.toString());
        }

        public Resource(Object resource, String name) {
            this.resource = resource;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getResource() {
            return this.resource;
        }

        public String toString() {
            return this.name;
        }
    }
}

