<!--
MIT License

Copyright (c) 2021 Bootcamp contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
-->
<a href="https://bootcamp-project.com/" target="_blank"><img src="https://bootcamp-project.com/tbcp.svg" align="right" height="200" /></a>

# GitPy - Working with Git in Python

## ready-2-use user-friendly Python module

<img src="https://img.shields.io/badge/License-MIT-lightgrey?style=for-the-badge" />
<img src="https://img.shields.io/badge/Bootcamp-Project-blue?style=for-the-badge" />

## 🦄 About 🦄

**Minimum Viable Product**: *What is what we want?*

> *Provide a user-friendly Python module for the use of Git.*

- **What are the goals?**
  - [ ] **Work with Git Config**
  - [ ] **Work with Git Repositories**
    - [ ] Check if Git is installed
    - [ ] Check if CWD is a Git Repo
    - [X] Load Git Repo by Path
    - [X] Get Infos from Git Repo
    - [ ] Init new Git Repo
  - [ ] **Work with Git Files**
  - [ ] **Work with Git Commits**
  - [ ] **Work with Git Trees**
  - [ ] **Work with Git Tags**
    - [X] List Tags
    - [X] Create Tag
    - [ ] Delete Tag
  - [ ] **Work with Git Branches**
    - [X] List local branches of a repo
    - [ ] Create new local branch
      - [ ] optionally push to remote
    - [ ] Remove local branch
      - [ ] optionally remove from remote
    - [ ] Checkout specific branch
      - [ ] Checkout `main` branch
    - [ ] Rename `master` to `main`
  - [ ] **Work with Git Remotes**
  - [ ] **Work with Git Hooks**
  - [ ] **Work with Git Flows**

## 🚀 Getting Started 🚀

**Project Links**

- [Homepage][Project_Homepage]
- [Documentation][Project_Docs]
- [Repository][Repo_URL]
- [Issues][Repo_Issues]

### ✋ Prerequisites ✋

### 💪 Installation 💪

### 😏 Development 😏

### 🤓 Linting 🤓

### 🧐 Testing 🧐

### 🤩 Building 🤩

### 🥳 Publishing 🥳

### 😅 Support 😅

*Don't be shy!* You are also welcome to open a [post in the issue registar][Repo_Issues] for simple questions.

## ⭐️ Features ⭐️

- [**Smoke** and **Unit-tested**][Repo_Tests] modules
- Security-first production-ready [**configurations**][TBCP_Configurations] by default
- Extensive [**documentation**][Project_Docs]

### 😎 Built With 😎

<table>
<tr>
<td><a href="https://www.python.org/" target="_blank"><img src="https://cdr.bootcamp-project.com/logos/programming/python.svg" alt="Python" width="200"/></a></td>
<td><a href="https://bootcamp-project.com/" target="_blank"><img src="https://bootcamp-project.com/tbcp.svg" alt="tbcp" width="200"/></a></td>
</tr>
</table>

### 🏆 Acknowledgements 🏆

Thanks for these awesome resources that were used during the development of the **Bootcamp: ESLint & Prettier Configuration**:

- Library: [GitPython][URL_GitPython]
- How to: [RTFM.page - GitPython][RTFM_GitwithPython]

## 📑 Changelog 📑

See [CHANGELOG][Repo_Changelog] for more information.

## 📋 Roadmap 📋

- [ ] In the Initialization section
  - [ ] Create Nodejs and Python Projects
  - [ ] Automatic creation of Gitlab Projects
- [ ] Automate Versioning
  - [ ] in Python Projects
  - [ ] in Node.js Projects
    - [ ] with NPM
    - [ ] with Yarn
- [ ] Secret Management
- [ ] Log Messenger
- [ ] Parse Error messages and search on SE
  - [ ] Bash History

See the [open issues][Repo_Issues] for a list of proposed features (and known issues).

## 🤝 Contribute 🤝

Contributions are what make the open source community such an amazing place to be learn, inspire, and create. Any contributions you make are **greatly appreciated**.

Please read the [contribution guidelines][TBCP_Contribution] first.

0. [Give us a star][Repo_Stars], it's really important! 😅
1. Fork the Project: (`git clone https://gitlab.com/the-bootcamp-project/packages/gitpy.git`)
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## 📜 License 📜

See [LICENSE][Repo_License] for more information.

## 💌 Contact 💌

[Bootcamp contributors][TBCP_Homepage] - `contributors` @ `bootcamp-project` .com

<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
[Project_Homepage]: https://packages.bootcamp-project.com
[Project_Docs]: https://packages.bootcamp-project.com
[Project_Install_Docs]: https://packages.bootcamp-project.com/#/install
[Project_Develop_Docs]: https://packages.bootcamp-project.com/#/develop
[Project_Linting_Docs]: https://packages.bootcamp-project.com/#/linting
[Project_esting_Docs]: https://packages.bootcamp-project.com/#/testing
[Project_Building_Docs]: https://packages.bootcamp-project.com/#/building
[Project_Publishing_Docs]: https://packages.bootcamp-project.com/#/publishing
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
[Repo_URL]: https://gitlab.com/the-bootcamp-project/packages/gitpy
[Repo_Issues]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/issues
[Repo_Forks]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/forks
[Repo_Stars]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/starrers
[Repo_Tests]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/tree/main/tests
[Repo_License]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/blob/main/LICENSE
[Repo_Changelog]: https://gitlab.com/the-bootcamp-project/packages/gitpy/-/blob/main/CHANGELOG
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
[TBCP_Homepage]: https://bootcamp-project.com
[TBCP_Configurations]: https://configurations.bootcamp-project.com
[TBCP_Contribution]: https://bootcamp-project.com/#code_of_conduct
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
[RTFM_GitwithPython]: https://dev.rtfm.page/#/working_with/git/interaction/with_python
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
[URL_Python]: https://wiki.python.org/moin/BeginnersGuide/Download
[URL_GitPython]: https://pypi.org/project/GitPython
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
<!-- ---------------------------------------------------------------------------------------------------------------------------------- -->
