
#include <Eigen/Core>
#include <cmath>
#include <goofit/detail/Complex.h>

namespace GooFit {

template <int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int,
          int>
__device__ auto compute_inverse5(const Eigen::Array<fpcomplex, 5, 5> &m) -> Eigen::Array<fpcomplex, 5, 5>;
template <>
__device__ inline auto
compute_inverse5<-1, -1, 0, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1>(
    const Eigen::Array<fpcomplex, 5, 5> &M) -> Eigen::Array<fpcomplex, 5, 5> {
    Eigen::Array<fpcomplex, 5, 5> O;

    O(0, 0) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(0, 1) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(0, 2) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(0, 3) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(0, 4) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(1, 0) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(1, 1) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(1, 2) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(1, 3) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(1, 4) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(2, 0) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(2, 1) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(2, 2) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(2, 3) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(2, 4) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(3, 0) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(3, 1) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(3, 2) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(3, 3) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(3, 4) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(4, 0) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(4, 1) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(4, 2) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(4, 3) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    O(4, 4) = (M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
               - M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
               + M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
               + M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
               - M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
               + M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
               - M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
               + M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
               - M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1))
              / (M(0, 0) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 4) - M(0, 0) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 3)
                 - M(0, 0) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 4) + M(0, 0) * M(1, 1) * M(2, 3) * M(3, 4) * M(4, 2)
                 + M(0, 0) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 3) - M(0, 0) * M(1, 1) * M(2, 4) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 4) - M(0, 0) * M(1, 3) * M(2, 1) * M(3, 4) * M(4, 2)
                 - M(0, 0) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 4) + M(0, 0) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 1)
                 + M(0, 0) * M(1, 3) * M(2, 4) * M(3, 1) * M(4, 2) - M(0, 0) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 3) + M(0, 0) * M(1, 4) * M(2, 1) * M(3, 3) * M(4, 2)
                 + M(0, 0) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 3) - M(0, 0) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 1)
                 - M(0, 0) * M(1, 4) * M(2, 3) * M(3, 1) * M(4, 2) + M(0, 0) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 1) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 4) + M(0, 1) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 3)
                 + M(0, 1) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 4) - M(0, 1) * M(1, 0) * M(2, 3) * M(3, 4) * M(4, 2)
                 - M(0, 1) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 3) + M(0, 1) * M(1, 0) * M(2, 4) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 4) + M(0, 1) * M(1, 3) * M(2, 0) * M(3, 4) * M(4, 2)
                 + M(0, 1) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 4) - M(0, 1) * M(1, 3) * M(2, 2) * M(3, 4) * M(4, 0)
                 - M(0, 1) * M(1, 3) * M(2, 4) * M(3, 0) * M(4, 2) + M(0, 1) * M(1, 3) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 3) - M(0, 1) * M(1, 4) * M(2, 0) * M(3, 3) * M(4, 2)
                 - M(0, 1) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 3) + M(0, 1) * M(1, 4) * M(2, 2) * M(3, 3) * M(4, 0)
                 + M(0, 1) * M(1, 4) * M(2, 3) * M(3, 0) * M(4, 2) - M(0, 1) * M(1, 4) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 3) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 4) + M(0, 3) * M(1, 0) * M(2, 1) * M(3, 4) * M(4, 2)
                 + M(0, 3) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 4) - M(0, 3) * M(1, 0) * M(2, 2) * M(3, 4) * M(4, 1)
                 - M(0, 3) * M(1, 0) * M(2, 4) * M(3, 1) * M(4, 2) + M(0, 3) * M(1, 0) * M(2, 4) * M(3, 2) * M(4, 1)
                 + M(0, 3) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 4) - M(0, 3) * M(1, 1) * M(2, 0) * M(3, 4) * M(4, 2)
                 - M(0, 3) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 4) + M(0, 3) * M(1, 1) * M(2, 2) * M(3, 4) * M(4, 0)
                 + M(0, 3) * M(1, 1) * M(2, 4) * M(3, 0) * M(4, 2) - M(0, 3) * M(1, 1) * M(2, 4) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 0) * M(3, 1) * M(4, 2) - M(0, 3) * M(1, 4) * M(2, 0) * M(3, 2) * M(4, 1)
                 - M(0, 3) * M(1, 4) * M(2, 1) * M(3, 0) * M(4, 2) + M(0, 3) * M(1, 4) * M(2, 1) * M(3, 2) * M(4, 0)
                 + M(0, 3) * M(1, 4) * M(2, 2) * M(3, 0) * M(4, 1) - M(0, 3) * M(1, 4) * M(2, 2) * M(3, 1) * M(4, 0)
                 + M(0, 4) * M(1, 0) * M(2, 1) * M(3, 2) * M(4, 3) - M(0, 4) * M(1, 0) * M(2, 1) * M(3, 3) * M(4, 2)
                 - M(0, 4) * M(1, 0) * M(2, 2) * M(3, 1) * M(4, 3) + M(0, 4) * M(1, 0) * M(2, 2) * M(3, 3) * M(4, 1)
                 + M(0, 4) * M(1, 0) * M(2, 3) * M(3, 1) * M(4, 2) - M(0, 4) * M(1, 0) * M(2, 3) * M(3, 2) * M(4, 1)
                 - M(0, 4) * M(1, 1) * M(2, 0) * M(3, 2) * M(4, 3) + M(0, 4) * M(1, 1) * M(2, 0) * M(3, 3) * M(4, 2)
                 + M(0, 4) * M(1, 1) * M(2, 2) * M(3, 0) * M(4, 3) - M(0, 4) * M(1, 1) * M(2, 2) * M(3, 3) * M(4, 0)
                 - M(0, 4) * M(1, 1) * M(2, 3) * M(3, 0) * M(4, 2) + M(0, 4) * M(1, 1) * M(2, 3) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 0) * M(3, 1) * M(4, 2) + M(0, 4) * M(1, 3) * M(2, 0) * M(3, 2) * M(4, 1)
                 + M(0, 4) * M(1, 3) * M(2, 1) * M(3, 0) * M(4, 2) - M(0, 4) * M(1, 3) * M(2, 1) * M(3, 2) * M(4, 0)
                 - M(0, 4) * M(1, 3) * M(2, 2) * M(3, 0) * M(4, 1) + M(0, 4) * M(1, 3) * M(2, 2) * M(3, 1) * M(4, 0));

    return O;
};
} // namespace GooFit
