# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pixelmatch', 'pixelmatch.contrib']

package_data = \
{'': ['*']}

modules = \
['py']
setup_kwargs = {
    'name': 'pixelmatch',
    'version': '0.2.4',
    'description': 'A pixel-level image comparison library.',
    'long_description': '# pixelmatch-py\n\nA fast pixel-level image comparison library, originally created to compare screenshots in tests.\nNow with additional support of PIL.Image instances\nPython port of https://github.com/mapbox/pixelmatch.\n\nFeatures accurate **anti-aliased pixels detection**\nand **perceptual color difference metrics**.\n\n```python\nfrom pixelmatch import pixelmatch\n\nnum_diff_pixels = pixelmatch(img1, img2, 800, 600, diff, threshold=0.1)\n```\n\nImplements ideas from the following papers:\n\n- [Measuring perceived color difference using YIQ NTSC transmission color space in mobile applications](https://pdfs.semanticscholar.org/cb71/56034b6e427ddc9b5da1a4f5fcb10831c9fd.pdf) (2010, Yuriy Kotsarenko, Fernando Ramos)\n- [Anti-aliased pixel and intensity slope detector](https://www.researchgate.net/publication/234126755_Anti-aliased_Pixel_and_Intensity_Slope_Detector) (2009, Vytautas Vyšniauskas)\n\n## Install\n\n```bash\npython -m pip install pixelmatch\n```\n\n## Example usage\n\n### PIL.Image comparison\n\n```python\nfrom PIL import Image\n\nfrom pixelmatch.contrib.PIL import pixelmatch\n\nimg_a = Image.open("a.png")\nimg_b = Image.open("b.png")\nimg_diff = Image.new("RGBA", img_a.size)\n\n# note how there is no need to specify dimensions\nmismatch = pixelmatch(img_a, img_b, img_diff, includeAA=True)\n\nimg_diff.save("diff.png")\n```\n\n### Raw Image Data Comparison\n\n```python\nfrom pixelmatch import pixelmatch\n\nwidth, height = 1920, 1080\nimg_a = [R1, G1, B1, A1, R2, B2, G2, A2, ...]\nimg_b = [R1, G1, B1, A1, R2, B2, G2, A2, ...]\n\ndata_diff = [0] * len(img_a)\n\nmismatch = pixelmatch(img_a, img_b, width, height, data_diff, includeAA=True)\n```\n\n## API\n\n### pixelmatch(img1, img2, width, height, output, threshold, includeAA, alpha, aa_color, diff_color, diff_mask)\n\n- `img1`, `img2` — RGBA Image data of the images to compare. **Note:** image dimensions must be equal.\n- `width`, `height` — Width and height of the images.\n- `output` — Image data to write the diff to, or `None` if don\'t need a diff image. Note that _all three images_ need to have the same dimensions.\n- `threshold` — Matching threshold, ranges from `0` to `1`. Smaller values make the comparison more sensitive. `0.1` by default.\n- `includeAA` — If `true`, disables detecting and ignoring anti-aliased pixels. `false` by default.\n- `alpha` — Blending factor of unchanged pixels in the diff output. Ranges from `0` for pure white to `1` for original brightness. `0.1` by default.\n- `aa_color` — The color of anti-aliased pixels in the diff output in `[R, G, B]` format. `[255, 255, 0]` by default.\n- `diff_color` — The color of differing pixels in the diff output in `[R, G, B]` format. `[255, 0, 0]` by default.\n- `diff_mask` — Draw the diff over a transparent background (a mask), rather than over the original image. Will not draw anti-aliased pixels (if detected).\n\nCompares two images, writes the output diff and returns the number of mismatched pixels.\n\n### contrib.PIL.pixelmatch\n\nCompares two images, writes the output diff and returns the number of mismatched pixels. Exact same API as `pixelmatch.pixelmatch` except for the important fact that it takes instances of PIL.Image for image parameters (`img1`, `img2`, and `output`) and the width/size need not be specified.\n\n## Example output\n\n| expected                                                                                                                                  | actual                                                                                                                                    | diff                                                                            |\n| ----------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------- |\n| ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/4a.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/4a.png) | ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/4b.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/4b.png) | ![1diff](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/4diff.png) |\n| ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/3a.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/3a.png) | ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/3b.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/3b.png) | ![1diff](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/3diff.png) |\n| ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/6a.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/6a.png) | ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/6b.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/6b.png) | ![1diff](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/6diff.png) |\n| ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/7a.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/7a.png) | ![https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/7b.png](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/7b.png) | ![1diff](https://github.com/whtsky/pixelmatch-py/raw/master/fixtures/7diff.png) |\n\n## Changelog\n\n### v0.2.4\n\n- type: fix typing issues\n- chore: test Python 3.10\n\n### v0.2.3\n\n- feat: make package comply with PEP-561\n\n### v0.2.2\n\n- typing: use `Sequence` instead of `List` for `RGBTuple`\n- build: switch to `poetry_core` [#81](https://github.com/whtsky/pixelmatch-py/pull/81)\n\n### v0.2.1\n\n- feat: add function to compare PIL.Image instances through contrib.PIL.pixelmatch [#42](https://github.com/whtsky/pixelmatch-py/pull/42)\n\n### v0.2.0\n\n- BREAKING CHANGE: remove `options` parameter [#38](https://github.com/whtsky/pixelmatch-py/pull/38)\n- docs: use absolute url for images in README\n\n### v0.1.1\n\n- fix: fix bug in fast path [#18](https://github.com/whtsky/pixelmatch-py/pull/18)\n\n### v0.1.0\n\n- Initial release\n',
    'author': 'Wu Haotian',
    'author_email': 'whtsky@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/whtsky/pixelmatch-py',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
