/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.LocalEntityIdStore;
import com.raphtory.arrowcore.implementation.SchemaFieldAccessor;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedProperty;
import com.raphtory.arrowcore.implementation.VertexArrowStore;
import com.raphtory.arrowcore.implementation.VertexEdgeIndexPartition;
import com.raphtory.arrowcore.implementation.VertexHistoryPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import com.raphtory.arrowcore.implementation.VertexPropertyPartition;
import com.raphtory.arrowcore.model.Vertex;
import com.raphtory.arrowcore.util.LRUListItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexPartition
implements LRUListItem<VertexPartition> {
    protected final int _partitionId;
    protected final VertexPartitionManager _apm;
    protected final LocalEntityIdStore _localIdStore;
    private VectorSchemaRoot _rootRO;
    private VertexArrowStore _store;
    private ArrowFileReader _reader;
    private int _currentSize = 0;
    private boolean _modified = false;
    private boolean _loaded = false;
    protected final VertexHistoryPartition _history;
    protected final VertexEdgeIndexPartition _edgeIndex;
    protected SchemaFieldAccessor[] _fieldAccessors;
    protected int _nProperties;
    protected VersionedProperty[] _propertyFields;
    protected VertexPropertyPartition[] _propertyStores;
    protected IntVector[] _propertyPrevPtrVector;
    private VertexPartition _prev = null;
    private VertexPartition _next = null;

    public VertexPartition(VertexPartitionManager vertexPartitionManager, int n) {
        this._apm = vertexPartitionManager;
        this._partitionId = n;
        this._localIdStore = this._apm._raphtoryPartition.getLocalEntityIdStore();
        this._rootRO = null;
        this._store = new VertexArrowStore();
        this._history = new VertexHistoryPartition(this._partitionId, this);
        this._edgeIndex = new VertexEdgeIndexPartition(this._partitionId, this);
        ArrayList<VersionedProperty> arrayList = this._apm._raphtoryPartition._propertySchema.versionedVertexProperties();
        int n2 = this._nProperties = arrayList == null ? 0 : arrayList.size();
        if (this._nProperties > 0) {
            this._propertyFields = this._apm._raphtoryPartition._propertySchema.versionedVertexProperties().toArray(new VersionedProperty[this._nProperties]);
            this._propertyStores = new VertexPropertyPartition[this._nProperties];
            this._propertyPrevPtrVector = new IntVector[this._nProperties];
            for (int i = 0; i < this._nProperties; ++i) {
                this._propertyStores[i] = new VertexPropertyPartition(this._apm, this._partitionId, i, this._propertyFields[i]);
            }
        }
    }

    private void initialize() {
        Schema schema = this._apm._raphtoryPartition._arrowVertexSchema;
        this._rootRO = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this._apm.getAllocator());
        this._rootRO.setRowCount(this._apm.PARTITION_SIZE);
        this._fieldAccessors = this._apm._raphtoryPartition.createSchemaFieldAccessors(this._rootRO, this._apm._raphtoryPartition._propertySchema.nonversionedVertexProperties());
        this._store.init(this._partitionId, this._rootRO, this._fieldAccessors);
        this._history.initialize();
        this._edgeIndex.initialize();
        if (this._nProperties > 0) {
            for (int i = 0; i < this._nProperties; ++i) {
                this._propertyPrevPtrVector[i] = (IntVector)this._rootRO.getVector(this._propertyFields[i]._prevPtrFieldIndexInEntitySchema);
                this._propertyStores[i].initialize();
            }
        }
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public synchronized int getVerticesCount() {
        return this._currentSize;
    }

    public synchronized int getHistoryCount() {
        return this._history.getHistoryStore()._maxRow;
    }

    public synchronized long getNextFreeVertexId() {
        if (this._currentSize < this._apm.PARTITION_SIZE) {
            return (long)this._partitionId * (long)this._apm.PARTITION_SIZE + (long)this._currentSize;
        }
        return -1L;
    }

    public boolean addVertex(Vertex vertex) {
        boolean bl = this.internalAddVertex(vertex);
        if (bl) {
            long l = this._getGlobalVertexIdByRow(this._apm.getRowId(vertex.getLocalId()));
            this._localIdStore.setMapping(l, vertex.getLocalId());
        }
        return bl;
    }

    private synchronized boolean internalAddVertex(Vertex vertex) {
        int n = this._apm.getRowId(vertex.getLocalId());
        boolean bl = this._store.addVertex(n, vertex);
        this._modified = true;
        for (int i = 0; i < this._nProperties; ++i) {
            int n2;
            VersionedEntityPropertyAccessor versionedEntityPropertyAccessor = vertex.getProperty(i);
            if (versionedEntityPropertyAccessor == null || !versionedEntityPropertyAccessor.isSet()) continue;
            VersionedEntityPropertyAccessor versionedEntityPropertyAccessor2 = vertex.getProperty(i);
            IntVector intVector = this._propertyPrevPtrVector[i];
            VertexPropertyPartition vertexPropertyPartition = this._propertyStores[i];
            int n3 = intVector.isSet(n) == 0 ? -1 : intVector.get(n);
            long l = versionedEntityPropertyAccessor2.getCreationTime();
            if (n3 == -1 || l >= vertexPropertyPartition.getCreationTime(n3)) {
                n2 = vertexPropertyPartition.addProperty(n3, versionedEntityPropertyAccessor2);
                intVector.set(n, n2);
                continue;
            }
            n2 = vertexPropertyPartition.insertProperty(n3, l, versionedEntityPropertyAccessor2);
        }
        if (n >= this._currentSize) {
            this._currentSize = n + 1;
        }
        return bl;
    }

    public synchronized int addProperty(long l, int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        if (versionedEntityPropertyAccessor.isSet()) {
            int n2;
            this._modified = true;
            int n3 = this._apm.getRowId(l);
            IntVector intVector = this._propertyPrevPtrVector[versionedEntityPropertyAccessor.getEntityPrevPtrFieldId()];
            VertexPropertyPartition vertexPropertyPartition = this._propertyStores[n];
            int n4 = intVector.isSet(n3) == 0 ? -1 : intVector.get(n3);
            long l2 = versionedEntityPropertyAccessor.getCreationTime();
            if (n4 == -1 || l2 >= vertexPropertyPartition.getCreationTime(n4)) {
                n2 = vertexPropertyPartition.addProperty(n4, versionedEntityPropertyAccessor);
                intVector.set(n3, n2);
            } else {
                n2 = vertexPropertyPartition.insertProperty(n4, l2, versionedEntityPropertyAccessor);
            }
            return n2;
        }
        return -1;
    }

    public synchronized int addHistory(long l, long l2, boolean bl, boolean bl2, long l3, boolean bl3) {
        long l4;
        int n = this._apm.getRowId(l);
        int n2 = this._store.getHistoryPtr(n);
        int n3 = this._history.addHistory(n, l2, bl, bl2, n2, l3, bl3);
        this._store.setHistoryPtr(n, n3);
        if (this._store._oldestPoints.isSet(n) == 0) {
            this._store._oldestPoints.set(n, l2);
        } else {
            l4 = this._store._oldestPoints.get(n);
            if (l4 == -1L || l4 > l2) {
                this._store._oldestPoints.set(n, l2);
            }
        }
        if (bl && (l4 = this._store._creationTimes.get(n)) > l2) {
            this._store._creationTimes.set(n, l2);
        }
        this._modified = true;
        return n3;
    }

    public synchronized Vertex getVertex(long l) {
        if (this._rootRO == null) {
            return null;
        }
        int n = this._apm.getRowId(l);
        if (this.isValidRow(n)) {
            Vertex vertex = this._apm._raphtoryPartition.getVertex();
            this._store.retrieveVertex(n, vertex);
            vertex.incRefCount();
            for (int i = 0; i < this._nProperties; ++i) {
                IntVector intVector = this._propertyPrevPtrVector[i];
                if (intVector.isSet(n) == 0) continue;
                int n2 = intVector.get(n);
                this._propertyStores[i].retrieveProperty(n2, vertex.getProperty(i));
            }
            return vertex;
        }
        return null;
    }

    public synchronized void close() {
        this.clearReader();
        this._history.close();
        this.closeProperties();
        this._edgeIndex.close();
    }

    protected VersionedEntityPropertyAccessor getPropertyByPropertyRow(int n, int n2, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        this._propertyStores[n].retrieveProperty(n2, versionedEntityPropertyAccessor);
        return versionedEntityPropertyAccessor;
    }

    protected EntityFieldAccessor getFieldByVertexRow(int n, int n2, EntityFieldAccessor entityFieldAccessor) {
        this._fieldAccessors[n].load(entityFieldAccessor, n2);
        return entityFieldAccessor;
    }

    protected long _getLocalVertexIdByRow(int n) {
        return this._store._localIds.get(n);
    }

    protected long _getGlobalVertexIdByRow(int n) {
        return this._store._globalIds.get(n);
    }

    protected int _getNIncomingEdgesByRow(int n) {
        return this._store._nIncomingEdges.get(n);
    }

    private void dumpRow(int n) {
        System.out.println("HERE WITH: partId=" + this._partitionId + ", row=" + n);
        System.out.println("gid=" + this._store._globalIds.isSet(n));
        System.out.println("lid=" + this._store._localIds.isSet(n));
    }

    protected long _getIncomingEdgePtrByRow(int n) {
        return this._store._incomingEdges.get(n);
    }

    protected long _getOutgoingEdgePtrByRow(int n) {
        return this._store._outgoingEdges.get(n);
    }

    protected int _getNOutgoingEdgesByRow(int n) {
        return this._store._nOutgoingEdges.get(n);
    }

    protected boolean isValidRow(int n) {
        return n < this._currentSize && this._store._localIds.isSet(n) != 0;
    }

    public synchronized long addOutgoingEdgeToList(long l, long l2, long l3, boolean bl) {
        int n = this._apm.getRowId(l);
        long l4 = this._store._outgoingEdges.get(n);
        this._store._outgoingEdges.set(n, l2);
        this._store._nOutgoingEdges.set(n, this._store._nOutgoingEdges.get(n) + 1);
        this._edgeIndex.addEdgeIndexRecord(n, l3, l2, bl);
        this._modified = true;
        return l4;
    }

    public synchronized long addIncomingEdgeToList(long l, long l2) {
        int n = this._apm.getRowId(l);
        long l3 = this._store._incomingEdges.get(n);
        this._store._incomingEdges.set(n, l2);
        this._store._nIncomingEdges.set(n, this._store._nIncomingEdges.get(n) + 1);
        this._modified = true;
        return l3;
    }

    protected long getCreationTimeByRow(int n) {
        return this._store._creationTimes.get(n);
    }

    public synchronized void saveToFile() {
        try {
            if (this._modified) {
                this._rootRO.syncSchema();
                this._rootRO.setRowCount(this._currentSize);
                File file = this._apm.getVertexFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._rootRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._history.saveToFile();
            this.saveProperties();
            this._edgeIndex.saveToFile();
            this._modified = false;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void saveProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            if (this._propertyStores[i] == null) continue;
            this._propertyStores[i].saveToFile();
        }
    }

    private void loadProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            this._propertyPrevPtrVector[i] = (IntVector)this._rootRO.getVector(this._propertyFields[i]._prevPtrFieldIndexInEntitySchema);
            if (this._propertyStores[i] == null || this._propertyStores[i].loadFromFile()) continue;
            this._propertyStores[i].initialize();
        }
    }

    private void closeProperties() {
        if (this._propertyStores == null || this._propertyStores.length == 0) {
            return;
        }
        for (int i = 0; i < this._propertyStores.length; ++i) {
            if (this._propertyStores[i] == null) continue;
            this._propertyStores[i].close();
        }
    }

    public void loadFromFile() {
        this.loadFromFile(false);
    }

    public synchronized void ensureLoaded() {
        while (!this._loaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void loadFromFile(boolean bl) {
        if (!bl && this._rootRO != null && this._loaded) {
            return;
        }
        File file = this._apm.getVertexFile(this._partitionId);
        if (!file.exists()) {
            this.initialize();
            this.notifyAll();
            return;
        }
        try {
            this.clearReader();
            this._reader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._apm.getAllocator(), this._apm.getCompressionFactory());
            this._reader.loadNextBatch();
            this._rootRO = this._reader.getVectorSchemaRoot();
            this._rootRO.syncSchema();
            this._fieldAccessors = this._apm._raphtoryPartition.createSchemaFieldAccessors(this._rootRO, this._apm._raphtoryPartition._propertySchema.nonversionedVertexProperties());
            this._store.init(this._partitionId, this._rootRO, this._fieldAccessors);
            this._modified = false;
            this._currentSize = this._rootRO.getRowCount();
            if (this._currentSize != this._apm.PARTITION_SIZE) {
                this._rootRO.setRowCount(this._apm.PARTITION_SIZE);
            }
            if (!this._history.loadFromFile()) {
                this._history.initialize();
            }
            if (this._apm._raphtoryPartition._syncIDMap) {
                LocalEntityIdStore localEntityIdStore = this._apm._raphtoryPartition.getLocalEntityIdStore();
                for (int i = 0; i < this._currentSize; ++i) {
                    localEntityIdStore.setMapping(this._getGlobalVertexIdByRow(i), this._getLocalVertexIdByRow(i));
                }
            }
            this.loadProperties();
            if (!this._edgeIndex.loadFromFile()) {
                this._edgeIndex.initialize();
            }
            this._loaded = true;
            this.notifyAll();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void clearReader() {
        try {
            this._loaded = false;
            if (this._store != null) {
                this._store.init(-1, null, null);
            }
            if (this._rootRO != null) {
                this._rootRO.clear();
                this._rootRO.close();
                this._rootRO = null;
                this._fieldAccessors = null;
            }
            if (this._reader != null) {
                this._reader.close();
                this._reader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    protected int getPropertyPrevPtrByRow(int n, int n2) {
        int n3 = this._propertyPrevPtrVector[n].get(n2);
        return n3;
    }

    @Override
    public void setNext(VertexPartition vertexPartition) {
        this._next = vertexPartition;
    }

    @Override
    public void setPrev(VertexPartition vertexPartition) {
        this._prev = vertexPartition;
    }

    @Override
    public VertexPartition getNext() {
        return this._next;
    }

    @Override
    public VertexPartition getPrev() {
        return this._prev;
    }

    public long getVertexMaxHistoryTime(long l) {
        int n = this._apm.getRowId(l);
        return this._history.getVertexMaxHistoryTime(n);
    }

    public long getVertexMinHistoryTime(long l) {
        int n = this._apm.getRowId(l);
        return this._history.getVertexMinHistoryTime(n);
    }
}

