/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexHistoryStore {
    protected static Schema HISTORY_SCHEMA = new Schema(VertexHistoryStore.createHistoryFields());
    protected IntVector _vertexRowIds;
    protected BigIntVector _times;
    protected BitVector _states;
    protected BitVector _updates;
    protected IntVector _prevPtrs;
    protected IntVector _sortedTimeIndices;
    protected IntVector _sortedVertexTimeIndices;
    protected BigIntVector _edgeIds;
    protected BitVector _isOutgoings;
    protected IntVector _snapshots;
    protected VectorSchemaRoot _root;
    protected int _maxRow = 0;

    protected static List<Field> createHistoryFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("vertex_row", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("active", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("update", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("prev_ptr", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("sorted_time_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("edge_id", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("is_outgoing", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("sorted_vertex_time_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    public void init(VectorSchemaRoot vectorSchemaRoot) {
        this._root = vectorSchemaRoot;
        if (this._root != null) {
            this._vertexRowIds = (IntVector)this._root.getVector("vertex_row");
            this._times = (BigIntVector)this._root.getVector("time");
            this._states = (BitVector)this._root.getVector("active");
            this._updates = (BitVector)this._root.getVector("update");
            this._prevPtrs = (IntVector)this._root.getVector("prev_ptr");
            this._sortedVertexTimeIndices = (IntVector)this._root.getVector("sorted_vertex_time_index");
            this._sortedTimeIndices = (IntVector)this._root.getVector("sorted_time_index");
            this._edgeIds = (BigIntVector)this._root.getVector("edge_id");
            this._isOutgoings = (BitVector)this._root.getVector("is_outgoing");
            this._snapshots = null;
        } else {
            this._vertexRowIds = null;
            this._times = null;
            this._states = null;
            this._updates = null;
            this._prevPtrs = null;
            this._sortedTimeIndices = null;
            this._sortedVertexTimeIndices = null;
            this._edgeIds = null;
            this._isOutgoings = null;
            this._snapshots = null;
        }
    }

    public int addHistory(int n, long l, boolean bl, boolean bl2, int n2, long l2, boolean bl3, int n3) {
        int n4 = this._maxRow++;
        this._vertexRowIds.setSafe(n4, n);
        this._times.setSafe(n4, l);
        this._states.setSafe(n4, bl ? 1 : 0);
        this._updates.setSafe(n4, bl2 ? 1 : 0);
        this._prevPtrs.setSafe(n4, n2);
        this._edgeIds.setSafe(n4, l2);
        this._isOutgoings.setSafe(n4, bl3 ? 1 : 0);
        return n4;
    }

    public long getPrevPtr(int n) {
        return this._prevPtrs.get(n);
    }
}

