/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.PropertyStore;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedProperty;
import com.raphtory.arrowcore.implementation.VersionedPropertyStore;
import com.raphtory.arrowcore.util.LRUListItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class EdgePropertyPartition
implements LRUListItem<EdgePropertyPartition> {
    protected final int _partitionId;
    protected final EdgePartitionManager _aepm;
    protected final int _propertyId;
    protected VectorSchemaRoot _rootRO;
    protected VersionedPropertyStore _accessor;
    protected ArrowFileReader _reader;
    protected boolean _modified = false;
    protected PropertyStore _store;
    protected VersionedProperty _property;
    private EdgePropertyPartition _prev = null;
    private EdgePropertyPartition _next = null;

    public EdgePropertyPartition(EdgePartitionManager edgePartitionManager, int n, int n2, VersionedProperty versionedProperty) {
        this._aepm = edgePartitionManager;
        this._partitionId = n;
        this._propertyId = n2;
        this._property = versionedProperty;
        this._rootRO = null;
        this._store = new PropertyStore();
        this._accessor = this._aepm._raphtoryPartition.createSchemaPropertyAccessor(this._rootRO, this._property);
    }

    public void initialize() {
        Schema schema = this._aepm._raphtoryPartition.getEdgePropertySchema(this._propertyId);
        this._rootRO = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this._aepm.getAllocator());
        this._rootRO.setRowCount(this._aepm.PARTITION_SIZE);
        this._store.init(this._partitionId, this._rootRO, this._accessor);
    }

    public PropertyStore getSchema() {
        return this._store;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public int addProperty(int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        this._modified = true;
        int n2 = this._store.addProperty(versionedEntityPropertyAccessor.getLocalId(), versionedEntityPropertyAccessor.getInitialValue(), versionedEntityPropertyAccessor.getCreationTime(), n, versionedEntityPropertyAccessor);
        return n2;
    }

    public int insertProperty(int n, long l, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        int n2 = -1;
        int n3 = n;
        while (n3 != -1 && this.getCreationTime(n3) > l) {
            n2 = n3;
            n3 = this.getNextRowInList(n3);
        }
        int n4 = this.addProperty(n3, versionedEntityPropertyAccessor);
        if (n2 != -1) {
            this._store._prevPtrs.set(n2, n4);
        }
        return n4;
    }

    public void retrieveProperty(int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        if (this._rootRO == null) {
            return;
        }
        this._store.loadProperty(n, versionedEntityPropertyAccessor);
    }

    protected long getCreationTime(int n) {
        return this._store._creationTimes.get(n);
    }

    protected int getNextRowInList(int n) {
        return this._store._prevPtrs.get(n);
    }

    @Override
    public void setNext(EdgePropertyPartition edgePropertyPartition) {
        this._next = edgePropertyPartition;
    }

    @Override
    public void setPrev(EdgePropertyPartition edgePropertyPartition) {
        this._prev = edgePropertyPartition;
    }

    @Override
    public EdgePropertyPartition getNext() {
        return this._next;
    }

    @Override
    public EdgePropertyPartition getPrev() {
        return this._prev;
    }

    public void close() {
        this.clearReader();
    }

    public boolean saveToFile() {
        try {
            if (this._modified) {
                this._rootRO.syncSchema();
                this._rootRO.setRowCount(this._store._maxRow);
                File file = this._aepm.getEdgePropertyFile(this._partitionId, this._propertyId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._rootRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean loadFromFile() {
        File file = this._aepm.getEdgePropertyFile(this._partitionId, this._propertyId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._reader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._aepm.getAllocator(), this._aepm.getCompressionFactory());
            this._reader.loadNextBatch();
            this._rootRO = this._reader.getVectorSchemaRoot();
            this._rootRO.syncSchema();
            this._store.init(this._partitionId, this._rootRO, this._accessor);
            this._modified = false;
            this._store._maxRow = this._rootRO.getRowCount();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._store != null) {
                this._store.init(this._partitionId, null, this._accessor);
            }
            if (this._rootRO != null) {
                this._rootRO.clear();
                this._rootRO.close();
                this._rootRO = null;
            }
            if (this._reader != null) {
                this._reader.close();
                this._reader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }
}

