/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.time;

import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.NullInterval$;
import com.raphtory.api.time.TimeInterval;
import com.raphtory.internals.time.TimeConverters$;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q:aAC\u0006\t\u0002=\u0019bAB\u000b\f\u0011\u0003ya\u0003C\u0003\u001e\u0003\u0011\u0005qD\u0002\u0003!\u0003\u0005\t\u0003\u0002\u0003\u0007\u0004\u0005\u000b\u0007I\u0011\u0001\u0012\t\u0011\u0019\u001a!\u0011!Q\u0001\n\rBQ!H\u0002\u0005\u0002\u001dBQaK\u0002\u0005\u00021BQAN\u0002\u0005\u0002]Bq!O\u0001\u0002\u0002\u0013\r!(\u0001\bUS6,7i\u001c8wKJ$XM]:\u000b\u00051i\u0011\u0001\u0002;j[\u0016T!AD\b\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\t\u0012\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\n\u0002\u0007\r|W\u000e\u0005\u0002\u0015\u00035\t1B\u0001\bUS6,7i\u001c8wKJ$XM]:\u0014\u0005\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\"A\u0003+j[\u0016Du\u000e\u001c3feN\u00111aF\u000b\u0002GA\u0011\u0001\u0004J\u0005\u0003Ke\u0011A\u0001T8oO\u0006)A/[7fAQ\u0011\u0001F\u000b\t\u0003S\ri\u0011!\u0001\u0005\u0006\u0019\u0019\u0001\raI\u0001\u0007I5Lg.^:\u0015\u0005\rj\u0003\"\u0002\u0018\b\u0001\u0004y\u0013\u0001C5oi\u0016\u0014h/\u00197\u0011\u0005A\"T\"A\u0019\u000b\u00051\u0011$BA\u001a\u0010\u0003\r\t\u0007/[\u0005\u0003kE\u0012\u0001\"\u00138uKJ4\u0018\r\\\u0001\u0006IAdWo\u001d\u000b\u0003GaBQA\f\u0005A\u0002=\n!\u0002V5nK\"{G\u000eZ3s)\tA3\bC\u0003\r\u0013\u0001\u00071\u0005")
public final class TimeConverters {
    public static TimeHolder TimeHolder(long time) {
        return TimeConverters$.MODULE$.TimeHolder(time);
    }

    public static class TimeHolder {
        private final long time;

        public long time() {
            return this.time;
        }

        public long $minus(Interval interval) {
            long l;
            Interval interval2 = interval;
            if (NullInterval$.MODULE$.equals(interval2)) {
                l = this.time();
            } else if (interval2 instanceof DiscreteInterval) {
                DiscreteInterval discreteInterval = (DiscreteInterval)interval2;
                long size = discreteInterval.size();
                l = this.time() - size;
            } else if (interval2 instanceof TimeInterval) {
                TimeInterval timeInterval = (TimeInterval)interval2;
                TemporalAmount size = timeInterval.size();
                l = Instant.ofEpochMilli(this.time()).atZone(ZoneOffset.UTC).minus(size).toInstant().toEpochMilli();
            } else {
                throw new MatchError((Object)interval2);
            }
            return l;
        }

        public long $plus(Interval interval) {
            long l;
            Interval interval2 = interval;
            if (NullInterval$.MODULE$.equals(interval2)) {
                l = this.time();
            } else if (interval2 instanceof DiscreteInterval) {
                DiscreteInterval discreteInterval = (DiscreteInterval)interval2;
                long size = discreteInterval.size();
                l = this.time() + size;
            } else if (interval2 instanceof TimeInterval) {
                TimeInterval timeInterval = (TimeInterval)interval2;
                TemporalAmount size = timeInterval.size();
                l = Instant.ofEpochMilli(this.time()).atZone(ZoneOffset.UTC).plus(size).toInstant().toEpochMilli();
            } else {
                throw new MatchError((Object)interval2);
            }
            return l;
        }

        public TimeHolder(long time) {
            this.time = time;
        }
    }
}

