/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.formats;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.Perspective;
import com.raphtory.formats.CsvFormat$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A `Format` that writes a `Table` in comma-separated value (CSV) format\n  *\n  * This format outputs one CSV line per row.\n  * The first two values are the timestamp used to create the perspective corresponding to that row\n  * and the size of the window applied over the perspective.\n  * If no window was applied over the perspective, the window size is omitted.\n  * The following values are the values composing the row.\n  *\n  * For a table with just one perspective created from timestamp 10 with a window size 5 and 3 rows\n  * the output might look as follows:\n  *\n  * {{{\n  * 10,5,id1,12\n  * 10,5,id2,13\n  * 10,5,id3,24\n  * }}}\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001\u000eB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000b\")a\n\u0001C\u0001\u001f\")1\u000b\u0001C!\t\")A\u000b\u0001C!\t\")Q\u000b\u0001C!-\"9!\u000fAA\u0001\n\u0003\u0019\bbB;\u0001#\u0003%\tA\u001e\u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005e\u0001!!A\u0005\u0002\u0005m\u0001\"CA\u0014\u0001\u0005\u0005I\u0011IA\u0015\u0011%\t9\u0004AA\u0001\n\u0003\tI\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0011\u0002F!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131\n\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001fB\u0011\"!\u0015\u0001\u0003\u0003%\t%a\u0015\b\u0013\u0005MD$!A\t\u0002\u0005Ud\u0001C\u000e\u001d\u0003\u0003E\t!a\u001e\t\r9\u001bB\u0011AAH\u0011%\tieEA\u0001\n\u000b\ny\u0005C\u0005\u0002\u0012N\t\t\u0011\"!\u0002\u0014\"A\u0011qS\n\u0012\u0002\u0013\u0005a\u000fC\u0005\u0002\u001aN\t\t\u0011\"!\u0002\u001c\"A\u0011qU\n\u0012\u0002\u0013\u0005a\u000fC\u0005\u0002*N\t\t\u0011\"\u0003\u0002,\nI1i\u001d<G_Jl\u0017\r\u001e\u0006\u0003;y\tqAZ8s[\u0006$8O\u0003\u0002 A\u0005A!/\u00199ii>\u0014\u0018PC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001AE\u000b\u001b8!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111FM\u0007\u0002Y)\u0011QFL\u0001\u0007M>\u0014X.\u0019;\u000b\u0005=\u0002\u0014AB8viB,HO\u0003\u00022=\u0005\u0019\u0011\r]5\n\u0005Mb#A\u0002$pe6\fG\u000f\u0005\u0002&k%\u0011aG\n\u0002\b!J|G-^2u!\tA\u0004I\u0004\u0002:}9\u0011!(P\u0007\u0002w)\u0011AHI\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ!a\u0010\u0014\u0002\u000fA\f7m[1hK&\u0011\u0011I\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u007f\u0019\n\u0011\u0002Z3mS6LG/\u001a:\u0016\u0003\u0015\u0003\"A\u0012&\u000f\u0005\u001dC\u0005C\u0001\u001e'\u0013\tIe%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%'\u0003)!W\r\\5nSR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0013\u0006CA)\u0001\u001b\u0005a\u0002bB\"\u0004!\u0003\u0005\r!R\u0001\u0011I\u00164\u0017-\u001e7u\t\u0016d\u0017.\\5uKJ\f\u0001\u0003Z3gCVdG/\u0012=uK:\u001c\u0018n\u001c8\u0002\u0011\u0015DXmY;u_J$RaV/cI&\u0004\"\u0001W.\u000e\u0003eS!A\u0017\u0018\u0002\tMLgn[\u0005\u00039f\u0013AbU5oW\u0016CXmY;u_JDQA\u0018\u0004A\u0002}\u000b\u0011bY8o]\u0016\u001cGo\u001c:\u0011\u0005a\u0003\u0017BA1Z\u00055\u0019\u0016N\\6D_:tWm\u0019;pe\")1M\u0002a\u0001\u000b\u0006)!n\u001c2J\t\")QM\u0002a\u0001M\u0006Y\u0001/\u0019:uSRLwN\\%E!\t)s-\u0003\u0002iM\t\u0019\u0011J\u001c;\t\u000b)4\u0001\u0019A6\u0002\r\r|gNZ5h!\ta\u0007/D\u0001n\u0015\tQgN\u0003\u0002pA\u0005AA/\u001f9fg\u00064W-\u0003\u0002r[\n11i\u001c8gS\u001e\fAaY8qsR\u0011\u0001\u000b\u001e\u0005\b\u0007\u001e\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001e\u0016\u0003\u000bb\\\u0013!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005y4\u0013AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003mC:<'BAA\t\u0003\u0011Q\u0017M^1\n\u0007-\u000bY!\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001g\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\b\u0002$A\u0019Q%a\b\n\u0007\u0005\u0005bEA\u0002B]fD\u0001\"!\n\f\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0002CBA\u0017\u0003g\ti\"\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00026\u0005=\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u000f\u0002BA\u0019Q%!\u0010\n\u0007\u0005}bEA\u0004C_>dW-\u00198\t\u0013\u0005\u0015R\"!AA\u0002\u0005u\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0002\u0002H!A\u0011Q\u0005\b\u0002\u0002\u0003\u0007a-\u0001\u0005iCND7i\u001c3f)\u00051\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002<\u0005U\u0003\"CA\u0013#\u0005\u0005\t\u0019AA\u000fQ\u001d\u0001\u0011\u0011LA7\u0003_\u0002B!a\u0017\u0002j5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\t\u0019'!\u001a\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011q\r\u0011\u0002\r\u001dLG\u000f[;c\u0013\u0011\tY'!\u0018\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\u001d\u0002\t{|#F\u000b\u0011BA\u00014uN]7bi\u0002\u0004C\u000f[1uA]\u0014\u0018\u000e^3tA\u0005\u0004\u0003\rV1cY\u0016\u0004\u0007%\u001b8!G>lW.Y\u0017tKB\f'/\u0019;fI\u00022\u0018\r\\;fA!\u001a5KV\u0015!M>\u0014X.\u0019;\u000bA\u0001R#\u0002\t\u0011+AQC\u0017n\u001d\u0011g_Jl\u0017\r\u001e\u0011pkR\u0004X\u000f^:!_:,\u0007eQ*WA1Lg.\u001a\u0011qKJ\u0004#o\\</\u0015\u0001\u0002#\u0006\t+iK\u00022\u0017N]:uAQ<x\u000e\t<bYV,7\u000fI1sK\u0002\"\b.\u001a\u0011uS6,7\u000f^1na\u0002*8/\u001a3!i>\u00043M]3bi\u0016\u0004C\u000f[3!a\u0016\u00148\u000f]3di&4X\rI2peJ,7\u000f]8oI&tw\r\t;pAQD\u0017\r\u001e\u0011s_^T\u0001\u0005\t\u0016!C:$\u0007\u0005\u001e5fAML'0\u001a\u0011pM\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0011baBd\u0017.\u001a3!_Z,'\u000f\t;iK\u0002\u0002XM]:qK\u000e$\u0018N^3/\u0015\u0001\u0002#\u0006I%gA9|\u0007e^5oI><\be^1tA\u0005\u0004\b\u000f\\5fI\u0002zg/\u001a:!i\",\u0007\u0005]3sgB,7\r^5wK2\u0002C\u000f[3!o&tGm\\<!g&TX\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005\t\u0016!)\",\u0007EZ8mY><\u0018N\\4!m\u0006dW/Z:!CJ,\u0007\u0005\u001e5fAY\fG.^3tA\r|W\u000e]8tS:<\u0007\u0005\u001e5fAI|wO\f\u0006!A)R\u0001\u0005\t\u0016!\r>\u0014\b%\u0019\u0011uC\ndW\rI<ji\"\u0004#.^:uA=tW\r\t9feN\u0004Xm\u0019;jm\u0016\u00043M]3bi\u0016$\u0007E\u001a:p[\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI\u00191A]LG\u000f\u001b\u0011bA]Lg\u000eZ8xAML'0\u001a\u00116A\u0005tG\rI\u001a!e><8O\u0003\u0011!U\u0001\"\b.\u001a\u0011pkR\u0004X\u000f\u001e\u0011nS\u001eDG\u000f\t7p_.\u0004\u0013m\u001d\u0011g_2dwn^:;\u0015\u0001\u0002#F\u0003\u0011!U\u0001Z8p\u001f\u0006!A)\u0002\u0013\u0007\r\u00176Y%$\u0017\u0007L\u00193\u0015\u0001\u0002#\u0006I\u00191YUb\u0013\u000e\u001a\u001a-cMR\u0001\u0005\t\u0016!cAbS\u0007L5eg1\u0012DG\u0003\u0011!U\u0001jX0 \u0006!A)z\u0013!C\"tm\u001a{'/\\1u!\t\t6cE\u0003\u0014\u0003s\n)\t\u0005\u0004\u0002|\u0005\u0005U\tU\u0007\u0003\u0003{R1!a '\u0003\u001d\u0011XO\u001c;j[\u0016LA!a!\u0002~\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013SA!a#\u0002\u0010\u0005\u0011\u0011n\\\u0005\u0004\u0003\u0006%ECAA;\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0001\u0016Q\u0013\u0005\b\u0007Z\u0001\n\u00111\u0001F\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003;\u000b\u0019\u000b\u0005\u0003&\u0003?+\u0015bAAQM\t1q\n\u001d;j_:D\u0001\"!*\u0019\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B!\u0011\u0011BAX\u0013\u0011\t\t,a\u0003\u0003\r=\u0013'.Z2u\u0001")
public class CsvFormat
implements Format,
Product,
Serializable {
    private final String delimiter;

    public static String $lessinit$greater$default$1() {
        return CsvFormat$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<String> unapply(CsvFormat x$0) {
        return CsvFormat$.MODULE$.unapply(x$0);
    }

    public static String apply$default$1() {
        return CsvFormat$.MODULE$.apply$default$1();
    }

    public static CsvFormat apply(String delimiter) {
        return CsvFormat$.MODULE$.apply(delimiter);
    }

    public static <A> Function1<String, A> andThen(Function1<CsvFormat, A> g) {
        return CsvFormat$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, CsvFormat> compose(Function1<A, String> g) {
        return CsvFormat$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String delimiter() {
        return this.delimiter;
    }

    @Override
    public String defaultDelimiter() {
        return "\n";
    }

    @Override
    public String defaultExtension() {
        return "csv";
    }

    @Override
    public SinkExecutor executor(SinkConnector connector, String jobID, int partitionID, Config config) {
        return new SinkExecutor(this, connector){
            private Perspective currentPerspective;
            private final JsonMapper mapper;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ CsvFormat $outer;
            private final SinkConnector connector$1;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private Perspective currentPerspective() {
                return this.currentPerspective;
            }

            private void currentPerspective_$eq(Perspective x$1) {
                this.currentPerspective = x$1;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private String ensureQuoted(String str) {
                return str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'") || !str.contains(this.$outer.delimiter()) ? str : new StringBuilder(2).append("\"").append(str).append("\"").toString();
            }

            private String csvValue(Object obj) {
                String string;
                Object object = obj;
                if (object instanceof String) {
                    String string2 = (String)object;
                    string = this.ensureQuoted(string2);
                } else {
                    string = this.ensureQuoted(this.mapper().writeValueAsString(object));
                }
                return string;
            }

            public void setupPerspective(Perspective perspective) {
                this.currentPerspective_$eq(perspective);
            }

            public void writeRow(Row row) {
                String string;
                Option<Interval> option = this.currentPerspective().window();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Interval w = (Interval)some.value();
                    string = new StringBuilder(0).append(this.currentPerspective().timestamp()).append(this.$outer.delimiter()).append(w).append(this.$outer.delimiter()).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)row.getValues()), (Function1 & Serializable)obj -> this.csvValue(obj), ClassTag$.MODULE$.apply(String.class))).mkString(this.$outer.delimiter())).toString();
                } else if (None$.MODULE$.equals(option)) {
                    string = new StringBuilder(0).append(this.currentPerspective().timestamp()).append(this.$outer.delimiter()).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)row.getValues()), (Function1 & Serializable)obj -> this.csvValue(obj), ClassTag$.MODULE$.apply(String.class))).mkString(this.$outer.delimiter())).toString();
                } else {
                    throw new MatchError(option);
                }
                String value = string;
                this.connector$1.write(value);
                this.connector$1.closeItem();
            }

            public void closePerspective() {
            }

            public void close() {
                this.connector$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$1 = connector$1;
                SinkExecutor.$init$(this);
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$writeRow$1(com.raphtory.formats.CsvFormat$$anon$1 java.lang.Object ), $anonfun$writeRow$2(com.raphtory.formats.CsvFormat$$anon$1 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public CsvFormat copy(String delimiter) {
        return new CsvFormat(delimiter);
    }

    public String copy$default$1() {
        return this.delimiter();
    }

    public String productPrefix() {
        return "CsvFormat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.delimiter();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvFormat;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "delimiter";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvFormat)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvFormat csvFormat = (CsvFormat)x$1;
        String string = this.delimiter();
        String string2 = csvFormat.delimiter();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!csvFormat.canEqual(this)) return false;
        return true;
    }

    public CsvFormat(String delimiter) {
        this.delimiter = delimiter;
        Product.$init$((Product)this);
    }
}

