/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.input;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.NoType$;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import io.prometheus.client.Counter;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Scaladoc(value="/** trait for creating a Graph by adding and deleting vertices and edges.\n  *\n  * An implementation of `GraphBuilder` needs to override `parseTuple(tuple: T)` to define parsing of input data.\n  * The input data is generated using a [[com.raphtory.api.input.Spout Spout]] and passed to the\n  * `parseTuple` method which is responsible for turning the raw data into a list of graph updates. Inside the\n  * `parseTuple` implementation, use methods `addVertex` and `addEdge`\n  * for adding vertices and edges. The resulting graph updates are send to the partitions responsible for\n  * handling the vertices and edges.\n  *\n  * @example\n  * {{{\n  * class TwitterGraphBuilder() extends GraphBuilder[String] {\n  *   override def parseTuple(fileLine: String): Unit = {\n  *     val sourceNode = fileLine(0)\n  *     val srcID      = sourceNode.toLong\n  *     val targetNode = fileLine(1)\n  *     val tarID      = targetNode.toLong\n  *     val timeStamp  = fileLine(2).toLong\n  *\n  *     addVertex(timeStamp, srcID, Properties(ImmutableProperty(\"name\", sourceNode)), Type(\"User\"))\n  *     addVertex(timeStamp, tarID, Properties(ImmutableProperty(\"name\", targetNode)), Type(\"User\"))\n  *     addEdge(timeStamp, srcID, tarID, Type(\"Follows\"))\n  *   }\n  * }\n  * }}}\n  * @see [[Properties]] [[Spout]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005MfaB\r\u001b!\u0003\r\ta\t\u0005\u0006U\u0001!\ta\u000b\u0005\u0006_\u00011\t\u0001\r\u0005\u0006i\u00011\t\"\u000e\u0005\u0006\u001d\u00021\t\u0002\r\u0005\u0006\u001f\u00021\t\u0001\u0015\u0005\u0006)\u00021\t!\u0016\u0005\u0006=\u0002!Ia\u0018\u0005\u0006Y\u0002!Ia\u0018\u0005\u0006[\u0002!\tA\u001c\u0005\u0007[\u0002!\t!a\u0004\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\u0007\u0001\u0005\u0002\u00055\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\t\u0003W\u0002A\u0011\u0001\u0010\u0002n!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0001\u0003\u001bC\u0011\"!%\u0001#\u0003%\t!a%\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005U\u0004\"CAM\u0001E\u0005I\u0011AAG\u0011%\tY\nAI\u0001\n\u0003\t\u0019jB\u0004\u0002$jA\t!!*\u0007\reQ\u0002\u0012AAT\u0011\u001d\tIK\u0006C\u0001\u0003WCq!!\u0018\u0017\t\u0003\tiKA\u0003He\u0006\u0004\bN\u0003\u0002\u001c9\u0005)\u0011N\u001c9vi*\u0011QDH\u0001\u0004CBL'BA\u0010!\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002YA\u0011Q%L\u0005\u0003]\u0019\u0012A!\u00168ji\u0006yAo\u001c;bYB\u000b'\u000f^5uS>t7/F\u00012!\t)#'\u0003\u00024M\t\u0019\u0011J\u001c;\u0002#!\fg\u000e\u001a7f\u000fJ\f\u0007\u000f[+qI\u0006$X\r\u0006\u0002-m!)qg\u0001a\u0001q\u00051Q\u000f\u001d3bi\u0016\u0004\"!O&\u000f\u0005iBeBA\u001eF\u001d\ta4I\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001II\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\b\u0011\n\u0005\u0011s\u0012!C5oi\u0016\u0014h.\u00197t\u0013\t1u)A\u0003he\u0006\u0004\bN\u0003\u0002E=%\u0011\u0011JS\u0001\u0010\u000fJ\f\u0007\u000f[!mi\u0016\u0014\u0018\r^5p]*\u0011aiR\u0005\u0003\u00196\u00131b\u0012:ba\",\u0006\u000fZ1uK*\u0011\u0011JS\u0001\tg>,(oY3J\t\u0006)\u0011N\u001c3fqV\t\u0011\u000b\u0005\u0002&%&\u00111K\n\u0002\u0005\u0019>tw-A\u0004he\u0006\u0004\b.\u0013#\u0016\u0003Y\u0003\"aV.\u000f\u0005aK\u0006C\u0001 '\u0013\tQf%\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.'\u0003A1XM\u001d;fq\u0006#GmQ8v]R,'/F\u0001a!\t\t'.D\u0001c\u0015\t\u0019G-A\u0004D_VtG/\u001a:\u000b\u0005\u00154\u0017AB2mS\u0016tGO\u0003\u0002hQ\u0006Q\u0001O]8nKRDW-^:\u000b\u0003%\f!![8\n\u0005-\u0014'!B\"iS2$\u0017AD3eO\u0016\fE\rZ\"pk:$XM]\u0001\nC\u0012$g+\u001a:uKb$B\u0001L8rg\")\u0001/\u0003a\u0001#\u0006QQ\u000f\u001d3bi\u0016$\u0016.\\3\t\u000bIL\u0001\u0019A)\u0002\u000bM\u00148-\u00133\t\u000bQL\u0001\u0019A;\u0002\u0015A|7\u000fV=qK\u0006\u0013x\r\u0005\u0002wo6\t!$\u0003\u0002y5\t!A+\u001f9fQ\u0019I!0!\u0003\u0002\fA\u001910!\u0002\u000e\u0003qT!! @\u0002\u0011M\u001c\u0017\r\\1e_\u000eT1a`A\u0001\u0003\u001d!\u0018m[3{_\u0016T1!a\u0001!\u0003\u00199\u0017\u000e\u001e5vE&\u0019\u0011q\u0001?\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\u0004\u0002\u0003O|#F\u000b\u0011BI\u0012\u001c\b%\u0019\u0011oK^\u0004c/\u001a:uKb\u0004Co\u001c\u0011uQ\u0016\u0004sM]1qQ\u0002z'\u000fI;qI\u0006$Xm\u001d\u0011b]\u0002*\u00070[:uS:<\u0007E^3si\u0016D(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*\b\u000fZ1uKRKW.\u001a\u0011uS6,7\u000f^1na\u00022wN\u001d\u0011wKJ$X\r\u001f\u0011va\u0012\fG/\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI:sG&#\u0007\u0005\t\u0011!A\u0001JE\tI8gAY,'\u000f^3yAQ|\u0007%\u00193e_U\u0004H-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!a>\u001cH+\u001f9f\u0003J<\u0007e\u001d9fG&4\u0017\u0010I1!7n#\u0016\u0010]3!)f\u0004X-X/!M>\u0014\b\u0005\u001e5fAY,'\u000f^3y\u0015\u0001\u0002\u0003\u0005\t\u00160)-a\u0013\u0011CA\n\u0003+\ty\"!\u000b\t\u000bAT\u0001\u0019A)\t\u000bIT\u0001\u0019A)\t\u0013\u0005]!\u0002%AA\u0002\u0005e\u0011A\u00039s_B,'\u000f^5fgB\u0019a/a\u0007\n\u0007\u0005u!D\u0001\u0006Qe>\u0004XM\u001d;jKND\u0011\"!\t\u000b!\u0003\u0005\r!a\t\u0002\u0015Y,'\u000f^3y)f\u0004X\rE\u0002w\u0003KI1!a\n\u001b\u0005%i\u0015-\u001f2f)f\u0004X\r\u0003\u0005\u0002,)\u0001\n\u00111\u0001R\u00039\u0019XmY8oI\u0006\u0014\u00180\u00138eKbDcA\u0003>\u0002\n\u0005=\u0012EAA\u0019\u0003\u0011-uF\u000b\u0016!\u0003\u0012$7\u000fI1!]\u0016<\bE^3si\u0016D\b\u0005^8!i\",\u0007e\u001a:ba\"\u0004sN\u001d\u0011va\u0012\fG/Z:!C:\u0004S\r_5ti&tw\r\t<feR,\u0007P\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S\u000f\u001d3bi\u0016$\u0016.\\3!i&lWm\u001d;b[B\u0004cm\u001c:!m\u0016\u0014H/\u001a=!kB$\u0017\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011te\u000eLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u00022XM\u001d;fq\u0002\"x\u000eI1eI>*\b\u000fZ1uK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAA\u0014x\u000e]3si&,7\u000fI(qi&|g.\u00197ms\u0002\u001a\b/Z2jMf\u0004c/\u001a:uKb\u0004\u0003O]8qKJ$\u0018.Z:!M>\u0014\b\u0005\u001e5fAU\u0004H-\u0019;fA!\u001aX-\u001a\u0011\\7\u000e|WN\f:ba\"$xN]=/CBLg&\u001b8qkRt\u0003K]8qKJ$\u0018.Z:!!J|\u0007/\u001a:uS\u0016\u001cX,\u0018\u0011g_J\u0004C\u000f[3\u000bA\u0001\u0002\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M^1jY\u0006\u0014G.\u001a\u0011qe>\u0004XM\u001d;zAQL\b/Z:*\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!m\u0016\u0014H/\u001a=UsB,\u0007e\u00149uS>t\u0017\r\u001c7zAM\u0004XmY5gs\u0002\n\u0007eW.UsB,\u0007\u0005V=qKvk\u0006EZ8sAQDW\r\t<feR,\u0007P\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e]3d_:$\u0017M]=J]\u0012,\u0007\u0010I(qi&|g.\u00197ms\u0002\u001a\b/Z2jMf\u0004\u0013\rI:fG>tG-\u0019:zA%tG-\u001a=!i\"\fG\u000fI5tAU\u001cX\r\u001a\u0011u_\u0002\"W\r^3s[&tW\r\t;iK\u0002z'\u000fZ3sA=4\u0007%\u001e9eCR,7\u000fI<ji\"\u0004C\u000f[3!g\u0006lW\r\t1va\u0012\fG/\u001a+j[\u0016\u0004'\u0002\t\u0011!A)z\u0013aB1eI\u0016#w-\u001a\u000b\u000eY\u0005]\u0012\u0011HA\u001e\u0003\u007f\t\t%!\u0012\t\u000bA\\\u0001\u0019A)\t\u000bI\\\u0001\u0019A)\t\r\u0005u2\u00021\u0001R\u0003\u0015!7\u000f^%e\u0011%\t9b\u0003I\u0001\u0002\u0004\tI\u0002C\u0005\u0002D-\u0001\n\u00111\u0001\u0002$\u0005AQ\rZ4f)f\u0004X\r\u0003\u0005\u0002,-\u0001\n\u00111\u0001RQ\u0019Y!0!\u0003\u0002J\u0005\u0012\u00111J\u0001\u0005@>R#\u0006I!eIN\u0004\u0013\r\t8fo\u0002*GmZ3!i>\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011pe\u0002*\b\u000fZ1uKN\u0004\u0013M\u001c\u0011fq&\u001cH/\u001b8hA\u0015$w-\u001a\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001e9eCR,G+[7fAQLW.Z:uC6\u0004\bEZ8sA\u0015$w-\u001a\u0011va\u0012\fG/\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI:sG&#\u0007\u0005\t\u0011!A\u0001JE\tI8gAM|WO]2fAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t3ti&#\u0007\u0005\t\u0011!A\u0001JE\tI8gA\u0011,7\u000f^5oCRLwN\u001c\u0011wKJ$X\r\u001f\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0003O]8qKJ$\u0018.Z:!K\u0012<W\r\t9s_B,'\u000f^5fg\u00022wN\u001d\u0011uQ\u0016\u0004S\u000f\u001d3bi\u0016\u0004\u0003f]3fAm[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018j]B,HO\f)s_B,'\u000f^5fg\u0002\u0002&o\u001c9feRLWm]/^A\u0019|'\u000f\t;iK*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1wC&d\u0017M\u00197fAA\u0014x\u000e]3sif\u0004C/\u001f9fg&R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*GmZ3UsB,\u0007\u0005\t\u0011ta\u0016\u001c\u0017NZ=!C\u0002Z6\fV=qK\u0002\"\u0016\u0010]3^;\u00022wN\u001d\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!g\u0016\u001cwN\u001c3befLe\u000eZ3yA=\u0003H/[8oC2d\u0017\u0010I:qK\u000eLg-\u001f\u0011bAM,7m\u001c8eCJL\b%\u001b8eKb\u0004C\u000f[1uA%\u001c\b%^:fI\u0002\"x\u000e\t3fi\u0016\u0014X.\u001b8fAQDW\rI8sI\u0016\u0014\be\u001c4!kB$\u0017\r^3tA]LG\u000f\u001b\u0011uQ\u0016\u00043/Y7fA\u0001,\b\u000fZ1uKRKW.\u001a1\u000bA\u0001\u0002\u0003EK\u0018\u0015\u00131\ny%!\u0015\u0002T\u0005U\u0003\"\u00029\r\u0001\u0004\t\u0006\"\u0002:\r\u0001\u0004\t\u0006BBA\u001f\u0019\u0001\u0007\u0011\u000bC\u0003u\u0019\u0001\u0007Q\u000f\u000b\u0004\ru\u0006%\u0011\u0011L\u0011\u0003\u00037\n!qL\u0018+U\u0001\nE\rZ:!C\u0002rWm\u001e\u0011fI\u001e,\u0007\u0005^8!i\",\u0007e\u001a:ba\"\u0004sN\u001d\u0011va\u0012\fG/Z:!C:\u0004S\r_5ti&tw\rI3eO\u0016T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAU\u0004H-\u0019;f)&lW\r\t;j[\u0016\u001cH/Y7qA\u0019|'\u000fI3eO\u0016\u0004S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a(oY%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\rI:pkJ\u001cW\r\t<feR,\u0007\u0010I8gAQDW\rI3eO\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"7\u000f^%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\r\t3fgRLg.\u0019;j_:\u0004c/\u001a:uKb\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!a>\u001cH+\u001f9f\u0003J<\u0007\u0005\t\u0011ta\u0016\u001c\u0017NZ=!C\u0002Z6\fV=qK\u0002\"\u0016\u0010]3^;\u00022wN\u001d\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003!\t7o]5h]&#EcA)\u0002b!1\u00111M\u0007A\u0002Y\u000b1\"\u001e8jcV,7\t[1sg\"2QB_A\u0005\u0003O\n#!!\u001b\u0002\u00057z#F\u000b\u0011D_:4XM\\5f]\u000e,\u0007%\\3uQ>$\u0007EZ8sA\u001d,g.\u001a:bi&tw\rI;oSF,X\rI%Eg\u0002\u0012\u0017m]3eA=t\u0007E^3si\u0016D\bE\\1nKNT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+AU\u001bX\rI8gAQD\u0017n\u001d\u0011nKRDw\u000e\u001a\u0011jg\u0002z\u0007\u000f^5p]\u0006dg\u0006I!!A\u001e\u0013\u0018\r\u001d5Ck&dG-\u001a:aA%\u001c\bE\u001a:fK\u0002\"x\u000eI1tg&<g\u000e\t<feR,\u0007\u0010I%Eg\u0002Jg\u000e\t3jM\u001a,'/\u001a8uA]\f\u0017p\u001d\u0017!aJ|g/\u001b3fI*\u0001\u0003\u0005\t\u0011+AQD\u0017\r\u001e\u0011fC\u000eD\u0007E^3si\u0016D\b%[:!CN\u001c\u0018n\u001a8fI\u0002\n\u0007%\u001e8jcV,\u0007%\u0013#!_\u001a\u0004C/\u001f9fA\u0001duN\\4a])\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!k:L\u0017/^3DQ\u0006\u00148\u000f\t,feR,\u0007\u0010\t8b[\u0016T\u0001\u0005\t\u0011!U=\n\u0011cZ3u!\u0006\u0014H/\u001b;j_:4uN]%e)\r\t\u0014q\u000e\u0005\u0007\u0003cr\u0001\u0019A)\u0002\u0005%$\u0017aE1eIZ+'\u000f^3yI\u0011,g-Y;mi\u0012\u001aTCAA<U\u0011\tI\"!\u001f,\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\"'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\u000byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1#\u00193e-\u0016\u0014H/\u001a=%I\u00164\u0017-\u001e7uIQ*\"!a$+\t\u0005\r\u0012\u0011P\u0001\u0014C\u0012$g+\u001a:uKb$C-\u001a4bk2$H%N\u000b\u0003\u0003+S3!UA=\u0003E\tG\rZ#eO\u0016$C-\u001a4bk2$H\u0005N\u0001\u0012C\u0012$W\tZ4fI\u0011,g-Y;mi\u0012*\u0014!E1eI\u0016#w-\u001a\u0013eK\u001a\fW\u000f\u001c;%m!2\u0001A_A\u0005\u0003?\u000b#!!)\u0002\u0015#y#F\u000b\u0011ue\u0006LG\u000f\t4pe\u0002\u001a'/Z1uS:<\u0007%\u0019\u0011He\u0006\u0004\b\u000e\t2zA\u0005$G-\u001b8hA\u0005tG\r\t3fY\u0016$\u0018N\\4!m\u0016\u0014H/[2fg\u0002\ng\u000e\u001a\u0011fI\u001e,7O\f\u0006!A)R\u0001\u0005\t\u0016!\u0003:\u0004\u0013.\u001c9mK6,g\u000e^1uS>t\u0007e\u001c4!A\u001e\u0013\u0018\r\u001d5Ck&dG-\u001a:aA9,W\rZ:!i>\u0004sN^3se&$W\r\t1qCJ\u001cX\rV;qY\u0016DC/\u001e9mKj\u0002C+\u000b1!i>\u0004C-\u001a4j]\u0016\u0004\u0003/\u0019:tS:<\u0007e\u001c4!S:\u0004X\u000f\u001e\u0011eCR\fgF\u0003\u0011!U\u0001\"\u0006.\u001a\u0011j]B,H\u000f\t3bi\u0006\u0004\u0013n\u001d\u0011hK:,'/\u0019;fI\u0002*8/\u001b8hA\u0005\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]%t\u0007/\u001e;/'B|W\u000f\u001e\u0011Ta>,H/X/!C:$\u0007\u0005]1tg\u0016$\u0007\u0005^8!i\",'\u0002\t\u0011+A\u0001\u0004\u0018M]:f)V\u0004H.\u001a1![\u0016$\bn\u001c3!o\"L7\r\u001b\u0011jg\u0002\u0012Xm\u001d9p]NL'\r\\3!M>\u0014\b\u0005^;s]&tw\r\t;iK\u0002\u0012\u0018m\u001e\u0011eCR\f\u0007%\u001b8u_\u0002\n\u0007\u0005\\5ti\u0002zg\rI4sCBD\u0007%\u001e9eCR,7O\f\u0011J]NLG-\u001a\u0011uQ\u0016T\u0001\u0005\t\u0016!AB\f'o]3UkBdW\r\u0019\u0011j[BdW-\\3oi\u0006$\u0018n\u001c8-AU\u001cX\rI7fi\"|Gm\u001d\u0011aC\u0012$g+\u001a:uKb\u0004\u0007%\u00198eA\u0001\fG\rZ#eO\u0016\u0004'\u0002\t\u0011+A\u0019|'\u000fI1eI&tw\r\t<feRL7-Z:!C:$\u0007%\u001a3hKNt\u0003\u0005\u00165fAI,7/\u001e7uS:<\u0007e\u001a:ba\"\u0004S\u000f\u001d3bi\u0016\u001c\b%\u0019:fAM,g\u000e\u001a\u0011u_\u0002\"\b.\u001a\u0011qCJ$\u0018\u000e^5p]N\u0004#/Z:q_:\u001c\u0018N\u00197fA\u0019|'O\u0003\u0011!U\u0001B\u0017M\u001c3mS:<\u0007\u0005\u001e5fAY,'\u000f^5dKN\u0004\u0013M\u001c3!K\u0012<Wm\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001+\u00070Y7qY\u0016T\u0001\u0005\t\u0016!wn\\(\u0002\t\u0011+A\rd\u0017m]:!)^LG\u000f^3s\u000fJ\f\u0007\u000f\u001b\"vS2$WM\u001d\u0015*A\u0015DH/\u001a8eg\u0002:%/\u00199i\u0005VLG\u000eZ3s7N#(/\u001b8h;\u0002Z(\u0002\t\u0011+A\u0001\u0002sN^3se&$W\r\t3fM\u0002\u0002\u0018M]:f)V\u0004H.\u001a\u0015gS2,G*\u001b8fu\u0001\u001aFO]5oO&R\u0004%\u00168ji\u0002j\u0004e\u001f\u0006!A)\u0002\u0003\u0005\t\u0011!m\u0006d\u0007e]8ve\u000e,gj\u001c3fAu\u0002c-\u001b7f\u0019&tW\r\u000b\u0019*\u0015\u0001\u0002#\u0006\t\u0011!A\u00012\u0018\r\u001c\u0011te\u000eLE\t\t\u0011!A\u0001\u0002S\bI:pkJ\u001cWMT8eK:\"x\u000eT8oO*\u0001\u0003E\u000b\u0011!A\u0001\u0002c/\u00197!i\u0006\u0014x-\u001a;O_\u0012,\u0007%\u0010\u0011gS2,G*\u001b8fQEJ#\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t<bY\u0002\"\u0018M]%EA\u0001\u0002\u0003\u0005\t\u0011>AQ\f'oZ3u\u001d>$WM\f;p\u0019>twM\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011wC2\u0004C/[7f'R\fW\u000e\u001d\u0011!{\u00012\u0017\u000e\\3MS:,\u0007FM\u0015/i>duN\\4\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002\u0003\u0005I1eIZ+'\u000f^3yQQLW.Z*uC6\u0004H\u0006I:sG&#E\u0006\t)s_B,'\u000f^5fg\"JU.\\;uC\ndW\r\u0015:pa\u0016\u0014H/\u001f\u0015#]\u0006lWM\t\u0017!g>,(oY3O_\u0012,\u0017&\u000b\u0017!)f\u0004X\r\u000b\u0012Vg\u0016\u0014(%K\u0015\u000bA\u0001R\u0003\u0005\t\u0011!A\u0005$GMV3si\u0016D\b\u0006^5nKN#\u0018-\u001c9-AQ\f'/\u0013#-AA\u0013x\u000e]3si&,7\u000fK%n[V$\u0018M\u00197f!J|\u0007/\u001a:us\"\u0012c.Y7fE1\u0002C/\u0019:hKRtu\u000eZ3*S1\u0002C+\u001f9fQ\t*6/\u001a:#S%R\u0001\u0005\t\u0016!A\u0001\u0002\u0003%\u00193e\u000b\u0012<W\r\u000b;j[\u0016\u001cF/Y7qY\u0001\u001a(oY%EY\u0001\"\u0018M]%EY\u0001\"\u0016\u0010]3)E\u0019{G\u000e\\8xg\nJ\u0013F\u0003\u0011!U\u0001\u0002\u0003% \u0006!A)\u0002SP\u0003\u0011!U\u0001jX0 \u0006!A)\u0002\u0003i]3fAm[\u0006K]8qKJ$\u0018.Z:^;\u0002Z6l\u00159pkRlVL\u0003\u0011!U=\nQa\u0012:ba\"\u0004\"A\u001e\f\u0014\u0005Y!\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002&R\u0019\u0011+a,\t\r\u0005\r\u0004\u00041\u0001WQ\u0019A\"0!\u0003\u0002h\u0001")
public interface Graph {
    public int totalPartitions();

    public void handleGraphUpdate(GraphAlteration.GraphUpdate var1);

    public int sourceID();

    public long index();

    public String graphID();

    private Counter.Child vertexAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.vertexAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    private Counter.Child edgeAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.edgeAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Type posTypeArg) {
        $this.addVertex(updateTime, srcId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    default public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        Type x$3 = posTypeArg;
        Properties x$4 = this.addVertex$default$3();
        long x$5 = this.addVertex$default$5();
        this.addVertex(x$1, x$2, x$4, x$3, x$5);
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        $this.addVertex(updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        GraphAlteration.VertexAdd update = new GraphAlteration.VertexAdd(this.sourceID(), updateTime, secondaryIndex, srcId, properties, vertexType.toOption(), SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.vertexAddCounter().inc();
    }

    public static /* synthetic */ Properties addVertex$default$3$(Graph $this) {
        return $this.addVertex$default$3();
    }

    default public Properties addVertex$default$3() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addVertex$default$4$(Graph $this) {
        return $this.addVertex$default$4();
    }

    default public MaybeType addVertex$default$4() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addVertex$default$5$(Graph $this) {
        return $this.addVertex$default$5();
    }

    default public long addVertex$default$5() {
        return this.index();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        $this.addEdge(updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        GraphAlteration.EdgeAdd update = new GraphAlteration.EdgeAdd(this.sourceID(), updateTime, secondaryIndex, srcId, dstId, properties, edgeType.toOption(), SchemaProviderInstances$.MODULE$.edgeAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.edgeAddCounter().inc();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Type posTypeArg) {
        $this.addEdge(updateTime, srcId, dstId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        long x$3 = dstId;
        Type x$4 = posTypeArg;
        Properties x$5 = this.addEdge$default$4();
        long x$6 = this.addEdge$default$6();
        this.addEdge(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public static /* synthetic */ Properties addEdge$default$4$(Graph $this) {
        return $this.addEdge$default$4();
    }

    default public Properties addEdge$default$4() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addEdge$default$5$(Graph $this) {
        return $this.addEdge$default$5();
    }

    default public MaybeType addEdge$default$5() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addEdge$default$6$(Graph $this) {
        return $this.addEdge$default$6();
    }

    default public long addEdge$default$6() {
        return this.index();
    }

    public static /* synthetic */ long assignID$(Graph $this, String uniqueChars) {
        return $this.assignID(uniqueChars);
    }

    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    default public long assignID(String uniqueChars) {
        return Graph$.MODULE$.assignID(uniqueChars);
    }

    public static /* synthetic */ int getPartitionForId$(Graph $this, long id) {
        return $this.getPartitionForId(id);
    }

    default public int getPartitionForId(long id) {
        return (int)(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(id)) % (long)this.totalPartitions());
    }

    public static void $init$(Graph $this) {
    }
}

