/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Edge;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyMergeStrategy$;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/** Public interface for graph operations\n  *\n  * The `GraphPerspective` is the interface for defining algorithms in Raphtory and records all operations to be\n  * applied to a graph as a sequence of steps to execute.\n  *\n  * Most operations on a `GraphPerspective` return a graph or multilayer\n  * graph as a result. To support returning the\n  * correct graph type, the `GraphPerspective` has abstract type members\n  *\n  *  - `Graph`: Current graph type (can be multilayer or reduced)\n  *  - `MultilayerGraph`: The type of the [[MultilayerGraphPerspective]] corresponding to the current graph\n  *  - `ReducedGraph`: The type of the [[ReducedGraphPerspective]] corresponding to the current graph\n  */")
@ScalaSignature(bytes="\u0006\u0005\r-da\u0002\u0013&!\u0003\r\t\u0001\r\u0003\u0006o\u0001\u0011\t\u0001\u000f\u0003\u0006\u0003\u0002\u0011\tA\u0011\u0003\u0006\u0017\u0002\u0011\t\u0001\u0014\u0003\u0006#\u0002\u0011\tA\u0015\u0005\u0006-\u00021\ta\u0016\u0005\u0006M\u00021\ta\u001a\u0005\u0006s\u00021\tA\u001f\u0005\u0007s\u00021\t!a\u0002\t\u000f\u0005]\u0001A\"\u0001\u0002\u001a!9\u0011q\u0003\u0001\u0007\u0002\u0005=\u0002bBA\u001f\u0001\u0019\u0005\u0011q\b\u0005\b\u0003{\u0001a\u0011AA$\u0011\u001d\t\u0019\b\u0001D\u0001\u0003kBq!a\u001d\u0001\r\u0003\ti\bC\u0004\u0002t\u00011\t!a,\t\u000f\u0005M\u0004A\"\u0001\u0002b\"9!\u0011\u0003\u0001\u0007\u0002\tM\u0001B\u0002B!\u0001\u0019\u0005q\u000b\u0003\u0004\u0003J\u00011\ta\u0016\u0005\u0007\u0005#\u0002a\u0011A,\t\u000f\te\u0003A\"\u0001\u0003\\!9!\u0011\f\u0001\u0007\u0002\t\u001d\u0004b\u0002B:\u0001\u0019\u0005!Q\u000f\u0005\b\u0005g\u0002a\u0011\u0001BA\u0011\u001d\u0011i\t\u0001D\u0001\u0005\u001fCqA!$\u0001\r\u0003\u00119\u000bC\u0004\u00036\u00021\tAa.\t\u000f\tU\u0006A\"\u0001\u0003V\"9!\u0011\u001d\u0001\u0007\u0002\t\r\bb\u0002Bx\u0001\u0019\u0005!\u0011\u001f\u0005\b\u0005_\u0004a\u0011AB\u0002\u0011\u001d\u0019y\u0001\u0001D\u0001\u0007#A\u0011b!\u0007\u0001#\u0003%\taa\u0007\t\u0013\rE\u0002!%A\u0005\u0002\rM\u0002\"CB)\u0001E\u0005I\u0011AB*\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4XM\u0003\u0002'O\u0005IqM]1qQZLWm\u001e\u0006\u0003Q%\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003U-\n1!\u00199j\u0015\taS&\u0001\u0005sCBDGo\u001c:z\u0015\u0005q\u0013aA2p[\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\n1a+\u001a:uKb\f\"!\u000f\u001f\u0011\u0005IR\u0014BA\u001e4\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u0010!\u000e\u0003yR!aP\u0014\u0002\u000fYL7/\u001b;pe&\u0011qG\u0010\u0002\u0006\u000fJ\f\u0007\u000f[\t\u0003s\r\u0003b\u0001R#H\u0013*\u0003V\"A\u0013\n\u0005\u0019+#\u0001G\"p]\u000e\u0014X\r^3He\u0006\u0004\b\u000eU3sgB,7\r^5wKB\u0011\u0001*A\u0007\u0002\u0001A\u0011\u0001J\u0001\t\u0003\u0011\u000e\u0011ABU3ek\u000e,Gm\u0012:ba\"\f\"!O'\u0011\t\u0011s%\nU\u0005\u0003\u001f\u0016\u0012qdQ8oGJ,G/\u001a*fIV\u001cW\rZ$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f!\tAEAA\bNk2$\u0018\u000e\\1zKJ<%/\u00199i#\tI4\u000b\u0005\u0003E)BS\u0015BA+&\u0005\t\u001auN\\2sKR,W*\u001e7uS2\f\u00170\u001a:He\u0006\u0004\b\u000eU3sgB,7\r^5wK\u0006A\u0011\u000eZ3oi&$\u00180F\u0001JQ\u0011)\u0011l\u00193\u0011\u0005i\u000bW\"A.\u000b\u0005qk\u0016\u0001C:dC2\fGm\\2\u000b\u0005y{\u0016a\u0002;bW\u0016Tx.\u001a\u0006\u0003A6\naaZ5uQV\u0014\u0017B\u00012\\\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A3\u0002\u0003#y#F\u000b\u0006!A\u0001\u0002#\u0006\t*fiV\u0014h\u000e\t;iK\u0002:'/\u00199iAUt7\r[1oO\u0016$'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\"\u0006.[:!SN\u0004So]3eAQ|\u0007e\u001c2uC&t\u0007\u0005\u001e5fA\r|'O]3di\u0002\u0012X\r^;s]\u0002\"\u0018\u0010]3!o&$\bn\\;uAA,'OZ8s[&tw\rI1os\u0002z\u0007/\u001a:bi&|gn\u001d\u0006!A\u0001\u0002#fL\u0001\u000fg\u0016$x\t\\8cC2\u001cF/\u0019;f)\tI\u0005\u000eC\u0003j\r\u0001\u0007!.A\u0001g!\u0011\u00114.\\:\n\u00051\u001c$!\u0003$v]\u000e$\u0018n\u001c82!\tq\u0017/D\u0001p\u0015\t\u0001x%\u0001\u0006he\u0006\u0004\bn\u001d;bi\u0016L!A]8\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006$X\r\u0005\u00023i&\u0011Qo\r\u0002\u0005+:LG\u000f\u000b\u0003\u00073\u000e<\u0018%\u0001=\u0002\u0003\u001b{#F\u000b\u0011BI\u0012\u0004\u0013\r\t4v]\u000e$\u0018n\u001c8!i>\u0004S.\u00198jaVd\u0017\r^3!O2|'-\u00197!OJ\f\u0007\u000f\u001b\u0011ti\u0006$X\r\f\u0011nC&tG.\u001f\u0011vg\u0016$\u0007\u0005^8!S:LG/[1mSN,\u0007%Y2dk6,H.\u0019;peN\u0004#-\u001a4pe\u0016\u0004C\u000f[3!]\u0016DH\u000fI1mO>\u0014\u0018\u000e\u001e5nAM$X\r\u001d\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011gk:\u001cG/[8oAQ|\u0007e]3uA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0011)eVt7\u000fI3yC\u000e$H.\u001f\u0011p]\u000e,\u0017F\u0003\u0011!A\u0001Rs&\u0001\u0007wKJ$X\r\u001f$jYR,'\u000f\u0006\u0002Jw\")\u0011n\u0002a\u0001yB!!g[$~!\t\u0011d0\u0003\u0002\u0000g\t9!i\\8mK\u0006t\u0007&B\u0004ZG\u0006\r\u0011EAA\u0003\u0003\u0005}tF\u000b\u0016!\r&dG/\u001a:!m\u0016\u0014H/[2fg\u0002zg\r\t;iK\u0002:'/\u00199i\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011gA\u0019LG\u000e^3sA\u0019,hn\u0019;j_:\u0004\u0003f\u001c8ms\u00022XM\u001d;jG\u0016\u001c\bEZ8sA]D\u0017n\u00195!A\u001a\u0004\u0007E]3ukJt7\u000f\t1ueV,\u0007\rI1sK\u0002ZW\r\u001d;*]\u0001\nE\u000e\u001c\u0011bgN|7-[1uK\u0012\u0004S\rZ4fg\u0002zg\r\t4jYR,'/\u001a3!m\u0016\u0014H/[2fg\u0002\n'/\u001a\u0011bYN|\u0007E]3n_Z,GM\f\u0006!A\u0001\u0002#f\f\u000b\u0004\u0013\u0006%\u0001BB5\t\u0001\u0004\tY\u0001\u0005\u00043\u0003\u001b9U.`\u0005\u0004\u0003\u001f\u0019$!\u0003$v]\u000e$\u0018n\u001c83Q\u0015A\u0011lYA\nC\t\t)\"AAs_)R\u0003ER5mi\u0016\u0014\bE^3si&\u001cWm\u001d\u0011pM\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000eI<ji\"\u0004s\r\\8cC2\u0004sM]1qQ\u0002\u001aH/\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011gA\u0019LG\u000e^3sA\u0019,hn\u0019;j_:\u0004s/\u001b;iA\u0005\u001c7-Z:tAQ|\u0007e\u001a:ba\"\u00043\u000f^1uK\u0002BsN\u001c7zAY,'\u000f^5dKN\u0004cm\u001c:!o\"L7\r\u001b\u0011aM\u0002\u0004#/\u001a;ve:\u001c\b\u0005\u0019;sk\u0016\u0004\u0007%\u0019:fA-,\u0007\u000f^\u0015/A\u0005cG\u000eI1tg>\u001c\u0017.\u0019;fI\u0002*GmZ3tA=4\u0007EZ5mi\u0016\u0014X\r\u001a\u0011wKJ$\u0018nY3tA\u0005\u0014X\rI1mg>\u0004#/Z7pm\u0016$gF\u0003\u0011!A\u0001Rs&\u0001\u0006fI\u001e,g)\u001b7uKJ$R!SA\u000e\u0003KAa![\u0005A\u0002\u0005u\u0001#\u0002\u001al\u0003?i\bcA\u001f\u0002\"%\u0019\u00111\u0005 \u0003\t\u0015#w-\u001a\u0005\u0007\u0003OI\u0001\u0019A?\u0002\u0015A\u0014XO\\3O_\u0012,7\u000fK\u0003\n3\u000e\fY#\t\u0002\u0002.\u0005\u0011Ig\f\u0016+A\u0019KG\u000e^3sA\u0015$w-Z:!_\u001a\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011gS2$XM\u001d\u0011gk:\u001cG/[8oA!zg\u000e\\=!K\u0012<Wm\u001d\u0011g_J\u0004s\u000f[5dQ\u0002\u0002g\r\u0019\u0011sKR,(O\\:!AR\u0014X/\u001a1!CJ,\u0007e[3qi&R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAA\u0014XO\\3O_\u0012,7\u000fI5gAQD\u0017n\u001d\u0011jg\u0002\u0002GO];fA\u0002\"\b.\u001a8!m\u0016\u0014H/[2fg\u0002:\b.[2iA\t,7m\\7fA%\u001cx\u000e\\1uK\u0012\u0004\u0003\u0006[1wK\u0002rw\u000eI5oG>l\u0017N\\4!_J\u0004s.\u001e;h_&tw\rI3eO\u0016\u001c\u0018F\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00054G/\u001a:!i\"L7\u000f\t4jYR,'/\u001b8hA\u0005\u0014X\rI1mg>\u0004#/Z7pm\u0016$gF\u0003\u0011!A\u0001Rs\u0006F\u0003J\u0003c\t)\u0004\u0003\u0004j\u0015\u0001\u0007\u00111\u0007\t\be\u00055\u0011qD7~\u0011\u0019\t9C\u0003a\u0001{\"*!\"W2\u0002:\u0005\u0012\u00111H\u0001\u0003P>R#\u0006\t$jYR,'\u000fI3eO\u0016\u001c\be\u001c4!i\",\u0007e\u001a:ba\"\u0004s/\u001b;iA\u001ddwNY1mA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011gS2$XM\u001d\u0011gk:\u001cG/[8oA]LG\u000f\u001b\u0011bG\u000e,7o\u001d\u0011u_\u0002:'/\u00199iAM$\u0018\r^3!Q=tG.\u001f\u0011fI\u001e,7\u000f\t4pe\u0002:\b.[2iA\u00014\u0007\r\t:fiV\u0014hn\u001d\u0011aiJ,X\r\u0019\u0011be\u0016\u00043.\u001a9uS)\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!aJ,h.\u001a(pI\u0016\u001c\b%\u001b4!i\"L7\u000fI5tA\u0001$(/^3aAQDWM\u001c\u0011wKJ$\u0018nY3tA]D\u0017n\u00195!E\u0016\u001cw.\\3!SN|G.\u0019;fI\u0002B\u0003.\u0019<fA9|\u0007%\u001b8d_6Lgn\u001a\u0011pe\u0002zW\u000f^4pS:<\u0007%\u001a3hKNL#\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C\u001a$XM\u001d\u0011uQ&\u001c\bEZ5mi\u0016\u0014\u0018N\\4!CJ,\u0007%\u00197t_\u0002\u0012X-\\8wK\u0012t#\u0002\t\u0011!A)z\u0013AD7vYRLG.Y=feZKWm^\u000b\u0002!\"*1\"W2\u0002D\u0005\u0012\u0011QI\u0001\u00046>R#\u0006I*xSR\u001c\u0007\u000e\t;pA5,H\u000e^5mCf,'\u000f\t<jK^T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u00053G/\u001a:!G\u0006dG.\u001b8hA\u0001lW\u000f\u001c;jY\u0006LXM\u001d,jK^\u0004G\u0006I:vEN,\u0017/^3oi\u0002jW\r\u001e5pIN\u0004C\u000f[1uA5\fg.\u001b9vY\u0006$X\r\t<feRL7-Z:!C\u000e$\be\u001c8\u000bA\u0001\u0002\u0003E\u000b\u0011\\7ZL7/\u001b;pe:*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKb\u0004S\t\u001f9m_\u0012,GMV3si&\u001cWm]/^A%t7\u000f^3bI:\u0002\u0013J\u001a\u0011\\7ZL7/\u001b;pe:*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKb\u0004S\t\u001f9m_\u0012,GMV3si\u0016DX,\u0018\u0006!A\u0001\u0002#\u0006I5ogR\fgnY3tA],'/\u001a\u0011bYJ,\u0017\rZ=!GJ,\u0017\r^3eA\tL\b%\u0019\u0011qe\u00164\u0018n\\;tA\r\fG\u000e\u001c\u0011u_\u0002\u0002W.\u001e7uS2\f\u00170\u001a:WS\u0016<\b\r\f\u0011uQ\u0016L\b%\u0019:fAA\u0014Xm]3sm\u0016$g\u0006I(uQ\u0016\u0014x/[:fY\u0001\"\b.[:\u000bA\u0001\u0002\u0003E\u000b\u0011nKRDw\u000e\u001a\u0011de\u0016\fG/Z:!C:\u00043l\u0017<jg&$xN\u001d\u0018FqBdw\u000eZ3e-\u0016\u0014H/\u001a=!\u000bb\u0004Hn\u001c3fIZ+'\u000f^3y;v\u0003\u0013N\\:uC:\u001cW\r\t4pe\u0002*\u0017m\u00195\u000bA\u0001\u0002\u0003E\u000b\u0011uS6,\u0007\u0005]8j]R\u0004C\u000f[1uA\u0005\u0004c/\u001a:uKb\u0004\u0013n\u001d\u0011bGRLg/\u001a\u0018\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0007A\u000bI\u0005C\u0005\u0002L1\u0001\n\u00111\u0001\u0002N\u0005)\u0012N\u001c;fe2\f\u00170\u001a:FI\u001e,')^5mI\u0016\u0014\b#\u0002\u001aly\u0005=\u0003CBA)\u0003C\n9G\u0004\u0003\u0002T\u0005uc\u0002BA+\u00037j!!a\u0016\u000b\u0007\u0005es&\u0001\u0004=e>|GOP\u0005\u0002i%\u0019\u0011qL\u001a\u0002\u000fA\f7m[1hK&!\u00111MA3\u0005\r\u0019V-\u001d\u0006\u0004\u0003?\u001a\u0004cA\u001f\u0002j%\u0019\u00111\u000e \u0003\u001d%sG/\u001a:mCf,'/\u00123hK\"*A\"W2\u0002p\u0005\u0012\u0011\u0011O\u0001\u0004*>R#\u0006I*xSR\u001c\u0007\u000e\t;pA5,H\u000e^5mCf,'\u000f\t<jK^\u0004\u0013M\u001c3!C\u0012$\u0007%\u001b8uKJd\u0017-_3sA\u0015$w-Z:/\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011j]R,'\u000f\\1zKJ,EmZ3Ck&dG-\u001a:!\u0013:$XM\u001d7bs\u0016\u0014\b%\u001a3hK\u0002\u0012W/\u001b7eKJ\u0004Co\u001c\u0011de\u0016\fG/\u001a\u0011j]R,'\u000f\\1zKJ\u0004S\rZ4fg\u00022wN\u001d\u0011fC\u000eD\u0007E^3si\u0016Dh\u0006I*fK*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Z6L^5tSR|'OL%oi\u0016\u0014H.Y=fe\u0016#w-\u001a\"vS2$WM]:!\u0013:$XM\u001d7bs\u0016\u0014X\tZ4f\u0005VLG\u000eZ3sgvk\u0006EZ8sAA\u0014X\rZ3gS:,G\rI8qi&|gn\u001d\u0018\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006I#ySN$\u0018N\\4!7n3\u0018n]5u_JtS\t\u001f9m_\u0012,GMV3si\u0016D\b%\u0012=qY>$W\r\u001a,feR,\u00070X/!S:\u001cH/\u00198dKN\u0004\u0013M]3!aJ,7/\u001a:wK\u0012\u0004#-\u001e;!C2d\u0007%\u001b8uKJd\u0017-_3sA\u0015$w-Z:!CJ,\u0007E]3de\u0016\fG/\u001a3!kNLgn\u001a\u0011uQ\u0016\u00043/\u001e9qY&,GM\u0003\u0011!A\u0001R\u0003\u0005Y5oi\u0016\u0014H.Y=fe\u0016#w-\u001a\"vS2$WM\u001d1/\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003-\u0011X\rZ;dK\u00124\u0016.Z<\u0016\u0003)CS!D-d\u0003s\n#!a\u001f\u0002\tC|#F\u000b\u0011To&$8\r\u001b\u0011d_6\u0004X\u000f^1uS>t\u0007\u0005^8!C\u000e$\be\u001c8!7n3\u0018n]5u_Jtc+\u001a:uKb\u0004c+\u001a:uKblV\f\f\u0011j]Z,'o]3!_\u001a\u0004\u0003-\\;mi&d\u0017-_3s-&,w\u000f\u0019\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00165jg\u0002z\u0007/\u001a:bi&|g\u000e\t3pKN\u0004cn\u001c;iS:<\u0007%\u001b4!i\",\u0007E^5fo\u0002J7\u000fI1me\u0016\fG-\u001f\u0011sK\u0012,8-\u001a3/A=#\b.\u001a:xSN,\u0007%\u001b;!g^LGo\u00195fg\u0002\u0012\u0017mY6!i>\u0004#/\u001e8oS:<\u0007eY8naV$\u0018\r^5p]NT\u0001\u0005\t\u0011!U\u0001zg\u000e\t<feRL7-Z:!EV$\b\u0005\u001d:fg\u0016\u0014h/Z:!C:L\b%\u001a=jgRLgn\u001a\u0011\\7ZL7/\u001b;pe:*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKb\u0004S\t\u001f9m_\u0012,GMV3si\u0016DX,\u0018\u0011j]N$\u0018M\\2fg*\u0001\u0003\u0005\t\u0011+A\r\u0014X-\u0019;fI\u0002\u0012\u0017\u0010\t9sKZLw.^:!G\u0006dGn\u001d\u0011u_\u0002\u0002W.\u001e7uS2\f\u00170\u001a:WS\u0016<\b\r\t;pA\u0005dGn\\<!g^LGo\u00195j]\u001e\u0004#-Y2l[\u0005tG-\f4peRD\u0007EY3uo\u0016,g\u000e\t<jK^\u001c\be\u001e5jY\u0016T\u0001\u0005\t\u0011!U\u0001\u0002(/Z:feZLgn\u001a\u0011d_6\u0004X\u000f^1uS>t\u0017\r\u001c\u0011ti\u0006$XM\f\u0011D_6\u0004X\u000f^1uS>t\u0017\r\u001c\u0011ti\u0006$X\rI8oAm[f/[:ji>\u0014h&\u0012=qY>$W\r\u001a,feR,\u0007\u0010I#ya2|G-\u001a3WKJ$X\r_/^\u0015\u0001\u0002\u0003\u0005\t\u0016!S:\u001cH/\u00198dKN\u0004\u0013n\u001d\u0011o_R\u0004\u0013mY2fgNL'\r\\3!MJ|W\u000e\t;iK\u0002\u0002g+\u001a:uKb\u0004\u0007%\u001e8mKN\u001c\b%\u0019\u0011nKJ<W\rI:ue\u0006$XmZ=!SN\u00043/\u001e9qY&,G\r\t\u0015tK\u0016\u0004#-\u001a7po&r#\u0002\t\u0011!A)zCc\u0001&\u0002\u0000!9\u0011\u0011\u0011\bA\u0002\u0005\r\u0015!D7fe\u001e,7\u000b\u001e:bi\u0016<\u0017\u0010\r\u0004\u0002\u0006\u0006]\u0015Q\u0015\t\t\u0003\u000f\u000bi)a%\u0002$:\u0019Q(!#\n\u0007\u0005-e(A\u000bQe>\u0004XM\u001d;z\u001b\u0016\u0014x-Z*ue\u0006$XmZ=\n\t\u0005=\u0015\u0011\u0013\u0002\u000e!J|\u0007/\u001a:us6+'oZ3\u000b\u0007\u0005-e\b\u0005\u0003\u0002\u0016\u0006]E\u0002\u0001\u0003\r\u00033\u000by(!A\u0001\u0002\u000b\u0005\u00111\u0014\u0002\u0004?\u0012\n\u0014cA\u001d\u0002\u001eB\u0019!'a(\n\u0007\u0005\u00056GA\u0002B]f\u0004B!!&\u0002&\u0012a\u0011qUA@\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\n\u0019q\f\n\u001a)\u000b9I6-a+\"\u0005\u00055\u0016A!\r0U)\u0002#+\u001a3vG\u0016\u0004c/[3xA\u0005tG\rI1qa2L\b\u0005\u001e5fAM\fW.\u001a\u0011nKJ<W\rI:ue\u0006$XmZ=!i>\u00043m\u001c8wKJ$\b%Z1dQ\u0002*\u0007\u0010\u001d7pI\u0016$\u0007e\u001d;bi\u0016\u0004Co\u001c\u0011wKJ$X\r\u001f\u0011ti\u0006$XM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S.\u001a:hKN#(/Y4fOf\u0004c)\u001e8di&|g\u000e\t;pA\r|gN^3si\u0002\n\u0007\u0005[5ti>\u0014\u0018\u0010I8gAY\fG.^3tA=4\u0007\u0005^=qK\u0002\"x\u000eI1!g&tw\r\\3!m\u0006dW/\u001a\u0011pM\u0002\"\u0018\u0010]3!QM,WM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011\\7B\u0013x\u000e]3siflUM]4f'R\u0014\u0018\r^3hsvk\u0006EZ8sAA\u0014X\rZ3gS:,G\rI8qi&|gn]\u0015\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0007)\u000b\t\fC\u0004\u00024>\u0001\r!!.\u0002!5,'oZ3TiJ\fG/Z4z\u001b\u0006\u0004\b\u0003CA\\\u0003\u007f\u000b)-a3\u000f\t\u0005e\u00161\u0018\t\u0004\u0003+\u001a\u0014bAA_g\u00051\u0001K]3eK\u001aLA!!1\u0002D\n\u0019Q*\u00199\u000b\u0007\u0005u6\u0007\u0005\u0003\u00028\u0006\u001d\u0017\u0002BAe\u0003\u0007\u0014aa\u0015;sS:<\u0007GBAg\u0003#\f9\u000e\u0005\u0005\u0002\b\u00065\u0015qZAk!\u0011\t)*!5\u0005\u0019\u0005M\u0017\u0011WA\u0001\u0002\u0003\u0015\t!a'\u0003\u0007}#3\u0007\u0005\u0003\u0002\u0016\u0006]G\u0001DAm\u0003c\u000b\t\u0011!A\u0003\u0002\u0005m%aA0%i!*q\"W2\u0002^\u0006\u0012\u0011q\\\u0001\u0003V=R#\u0006\t*fIV\u001cW\r\t<jK^\u0004\u0013M\u001c3![\u0016\u0014x-\u001a\u0011tK2,7\r^3eA\u0015D\b\u000f\\8eK\u0012\u00043\u000f^1uK\u0002\"x\u000e\t<feR,\u0007\u0010I:uCR,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002jWM]4f'R\u0014\u0018\r^3hs6\u000b\u0007\u000fI'ba\u00022'o\\7!gR\fG/\u001a\u0011lKf\u0004Co\u001c\u0011nKJ<W\rI:ue\u0006$XmZ=/A=sG.\u001f\u0011ti\u0006$X\rI5oG2,H-\u001a3!S:T\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t1nKJ<Wm\u0015;sCR,w-_'ba\u0002\u0004s/\u001b7mA\t,\u0007E]3ek\u000e,G\rI1oI*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\\1eK\u0002\ng/Y5mC\ndW\rI8oAQDW\r\t,feR,\u0007P\f\u0006!A\u0001\u0002#f\f\u000b\u0006\u0015\u0006\r\u0018q\u001f\u0005\b\u0003K\u0004\u0002\u0019AAt\u0003Q!WMZ1vYRlUM]4f'R\u0014\u0018\r^3hsB2\u0011\u0011^Aw\u0003g\u0004\u0002\"a\"\u0002\u000e\u0006-\u0018\u0011\u001f\t\u0005\u0003+\u000bi\u000f\u0002\u0007\u0002p\u0006\r\u0018\u0011!A\u0001\u0006\u0003\tYJA\u0002`IU\u0002B!!&\u0002t\u0012a\u0011Q_Ar\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\n\u0019q\f\n\u001c\t\u000f\u0005M\u0006\u00031\u0001\u0002zBA\u0011qWA`\u0003\u000b\fY\u0010\r\u0004\u0002~\n\u0005!q\u0001\t\t\u0003\u000f\u000bi)a@\u0003\u0006A!\u0011Q\u0013B\u0001\t1\u0011\u0019!a>\u0002\u0002\u0003\u0005)\u0011AAN\u0005\ryFe\u000e\t\u0005\u0003+\u00139\u0001\u0002\u0007\u0003\n\u0005]\u0018\u0011!A\u0001\u0006\u0003\tYJA\u0002`IaBS\u0001E-d\u0005\u001b\t#Aa\u0004\u0002\u0005Ky#F\u000b\u0011SK\u0012,8-\u001a\u0011wS\u0016<\b%\u00198eA5,'oZ3!C2d\u0007%\u001a=qY>$W\r\u001a\u0011wKJ$X\r\u001f\u0011ti\u0006$XM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004C-\u001a4bk2$X*\u001a:hKN#(/\u0019;fOf\u0004S*\u001a:hK\u0002\u001aHO]1uK\u001eL\bEZ8sAM$\u0018\r^3!]>$\b%\u001b8dYV$W\r\u001a\u0011j]\u0002\u0002W.\u001a:hKN#(/\u0019;fOfl\u0015\r\u001d1\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI7fe\u001e,7\u000b\u001e:bi\u0016<\u00170T1qA5\u000b\u0007\u000f\t4s_6\u00043\u000f^1uK\u0002ZW-\u001f\u0011u_\u0002jWM]4fAM$(/\u0019;fOf\u0004\u0003&^:fI\u0002\"x\u000eI8wKJ\u0014\u0018\u000eZ3!A\u0012,g-Y;mi6+'oZ3TiJ\fG/Z4zA&r#\u0002\t\u0011!A)z\u0013!C1hOJ,w-\u0019;f)\u0015Q%Q\u0003B\u0014\u0011%\t)/\u0005I\u0001\u0002\u0004\u00119\u0002\r\u0004\u0003\u001a\tu!1\u0005\t\t\u0003\u000f\u000biIa\u0007\u0003\"A!\u0011Q\u0013B\u000f\t1\u0011yB!\u0006\u0002\u0002\u0003\u0005)\u0011AAN\u0005\ryF%\u000f\t\u0005\u0003+\u0013\u0019\u0003\u0002\u0007\u0003&\tU\u0011\u0011!A\u0001\u0006\u0003\tYJ\u0001\u0003`IE\u0002\u0004\"CAZ#A\u0005\t\u0019\u0001B\u0015!!\t9,a0\u0002F\n-\u0002G\u0002B\u0017\u0005c\u00119\u0004\u0005\u0005\u0002\b\u00065%q\u0006B\u001b!\u0011\t)J!\r\u0005\u0019\tM\"qEA\u0001\u0002\u0003\u0015\t!a'\u0003\t}#\u0013'\r\t\u0005\u0003+\u00139\u0004\u0002\u0007\u0003:\t\u001d\u0012\u0011!A\u0001\u0006\u0003\tYJ\u0001\u0003`IE\u0012\u0004&B\tZG\nu\u0012E\u0001B \u0003\rmuF\u000b\u0016!%\u0016$WoY3!m&,w\u000fI1oI\u0002\"W\r\\3uK\u0002*\u0007\u0010\u001d7pI\u0016$\u0007E^3si&\u001cWm\u001d\u0011qKJl\u0017M\\3oi2L(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\"\u0006.[:!MVt7\r^5p]\u0002B\u0017m\u001d\u0011uQ\u0016\u00043/Y7fA\u00154g-Z2uA\u0005\u001c\b\u0005\u0019:fIV\u001cW\r\u001a,jK^\u0004G\u0006I3yG\u0016\u0004H\u000f\t;iCR\u0004C\u000f[3!Kb\u0004Hn\u001c3fI\u00022XM\u001d;jG\u0016\u001c\b%\u0019:fA\u0011,G.\u001a;fI\u0002\ng\u000e\u001a\u0011o_\u0002bwN\\4fe*\u0001\u0003\u0005\t\u0011+A\u00054\u0018-\u001b7bE2,\u0007EZ8sAM,(m]3rk\u0016tG\u000fI2bY2\u001c\be\u001c4!A6,H\u000e^5mCf,'OV5fo\u0002t#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"WMZ1vYRlUM]4f'R\u0014\u0018\r^3hs\u0002jUM]4fAM$(/\u0019;fOf\u0004cm\u001c:!gR\fG/\u001a\u0011o_R\u0004\u0013N\\2mk\u0012,G\rI5oA\u0001lWM]4f'R\u0014\u0018\r^3hs6\u000b\u0007\u000f\u0019\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\\3sO\u0016\u001cFO]1uK\u001eLX*\u00199!\u001b\u0006\u0004\bE\u001a:p[\u0002\u001aH/\u0019;fA-,\u0017\u0010\t;pA5,'oZ3!gR\u0014\u0018\r^3hs\u0002BSo]3eAQ|\u0007e\u001c<feJLG-\u001a\u0011aI\u00164\u0017-\u001e7u\u001b\u0016\u0014x-Z*ue\u0006$XmZ=aS9R\u0001\u0005\t\u0011!U=\na\"\u001e8eSJ,7\r^3e-&,w\u000fK\u0003\u00133\u000e\u0014)%\t\u0002\u0003H\u0005\t\u0019f\f\u0016+\u0015\u0001\u0002\u0003\u0005\t\u0016!-&,w\u000f\t;iK\u0002:'/\u00199iA\u0005\u001c\b%\u00198!k:$\u0017N]3di\u0016$\u0007E\\3uo>\u00148\u000e\t\u0015fI\u001e,7\u000f\t;iCR\u0004S\r_5ti\u0002zg\u000e\\=!S:\u0004sN\\3!I&\u0014Xm\u0019;j_:\u0004\u0013M]3!IV\u0004H.[2bi\u0016$\u0007%\u00198eA\u0015$w-Z:!i\"\fG\u000fI3ySN$(\u0002\t\u0011!A)\u0002\u0013N\u001c\u0011c_RD\u0007\u0005Z5sK\u000e$\u0018n\u001c8tA\u0005\u0014X\rI7fe\u001e,G-\u000b\u0006!A\u0001\u0002#fL\u0001\rI&\u0014Xm\u0019;fIZKWm\u001e\u0015\u0006'e\u001b'QJ\u0011\u0003\u0005\u001f\n\u0011\u0011L\u0018+U)\u0001\u0003\u0005\t\u0011+AYKWm\u001e\u0011uQ\u0016\u0004sM]1qQ\u0002\n7\u000fI1!I&\u0014Xm\u0019;fI\u0002rW\r^<pe.\u0004\u0003\u0006Z;qY&\u001c\u0017\r^3eA\u0015$w-Z:!GJ,\u0017\r^3eA\tL\b%\u0019\u0011qe\u00164\u0018n\\;tA\r\fG\u000e\u001c\u0011u_\u0002\u0002WO\u001c3je\u0016\u001cG/\u001a3WS\u0016<\b\rI1sK\u0002\u0012X-\\8wK\u0012T\u0001\u0005\t\u0011!U\u0001\ng\u000e\u001a\u0011cS6\"\u0017N]3di&|g.\u00197!K\u0012<Wm\u001d\u0011v]6jWM]4fI&R\u0001\u0005\t\u0011!U=\nAB]3wKJ\u001cX\r\u001a,jK^DS\u0001F-d\u0005+\n#Aa\u0016\u0002\u0003g|#F\u000b\u0006!A\u0001\u0002#\u0006\t*fm\u0016\u00148/\u001a\u0011uQ\u0016\u0004C-\u001b:fGRLwN\u001c\u0011pM\u0002*\u0017m\u00195!K\u0012<W\rI5oAQDW\rI4sCBDgF\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002cj\u001c;fAQD\u0017\r\u001e\u0011jM\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000eI5tA\r,(O]3oi2L\bE^5fo\u0016$\u0007%Y:!k:$\u0017N]3di\u0016$G\u0006\t;iSN\u0004S.\u001a;i_\u0012\u0004\u0003.Y:!]>\u0004\u0013.\\7fI&\fG/\u001a\u0011fM\u001a,7\r\u001e\u0017!Q><XM^3sY)\u0001\u0003\u0005\t\u0011+A\u0015$w-Z:!o&dG\u000e\t2fAI,g/\u001a:tK\u0012\u0004sN\u001c\u0011bAM,(m]3rk\u0016tG\u000fI2bY2\u0004Co\u001c\u0011aI&\u0014Xm\u0019;fIZKWm\u001e1\u000bA\u0001\u0002\u0003EK\u0018\u0002\tM$X\r\u001d\u000b\u0004\u0013\nu\u0003BB5\u0016\u0001\u0004\u0011y\u0006\u0005\u00033W\u001e\u001b\b&B\u000bZG\n\r\u0014E\u0001B3\u0003\u0001|#F\u000b\u0011Fq\u0016\u001cW\u000f^3!C2<wN]5uQ6\u00043\u000f^3q\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011gA\u0005dwm\u001c:ji\"l\u0007e\u001d;fa\u0002B#/\u001e8!_:\u001cW\r\t4pe\u0002*\u0017m\u00195!m\u0016\u0014H/\u001a=*\u0015\u0001\u0002\u0003\u0005\t\u00160)\rI%\u0011\u000e\u0005\u0007SZ\u0001\rAa\u001b\u0011\rI\niaR7tQ\u00151\u0012l\u0019B8C\t\u0011\t(AA__)R\u0003%\u0012=fGV$X\rI1mO>\u0014\u0018\u000e\u001e5nAM$X\r\u001d\u0011xSRD\u0007e\u001a7pE\u0006d\u0007e\u001a:ba\"\u00043\u000f^1uK\u0002B\u0003.Y:!C\u000e\u001cWm]:!i>\u0004\u0013mY2v[Vd\u0017\r^3eAM$\u0018\r^3!MJ|WN\u0003\u0011!A\u0001R\u0003\u0005\u001d:fm&|Wo\u001d\u0011ti\u0016\u00048\u000fI1oI\u0002\nG\u000e\\8xg\u00022wN\u001d\u0011bG\u000e,X.\u001e7bi&|g\u000eI8gA9,w\u000f\t<bYV,7/\u000b\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9!QI,h\u000eI8oG\u0016\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t<feR,\u00070\u000b\u0006!A\u0001\u0002#fL\u0001\tK\u0012<Wm\u0015;faR\u0019\u0011Ja\u001e\t\r%<\u0002\u0019\u0001B=!\u0015\u00114.a\btQ\u00159\u0012l\u0019B?C\t\u0011y(\u0001-0U)\u0002S\t_3dkR,\u0007%\u00197h_JLG\u000f[7!gR,\u0007O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c\rI1mO>\u0014\u0018\u000e\u001e5nAM$X\r\u001d\u0011)eVt\u0007e\u001c8!K\u0006\u001c\u0007\u000eI3eO\u0016L#\u0002\t\u0011!A)zCcA%\u0003\u0004\"1\u0011\u000e\u0007a\u0001\u0005\u000b\u0003rAMA\u0007\u0003?i7\u000fK\u0003\u00193\u000e\u0014I)\t\u0002\u0003\f\u0006\tik\f\u0016+A\u0015CXmY;uK\u0002\nGnZ8sSRDW\u000eI:uKB\u0004s/\u001b;iA\u001ddwNY1mA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0011)Q\u0006\u001c\b%Y2dKN\u001c\b\u0005^8!C\u000e\u001cW/\\;mCR,G\rI:uCR,\u0007E\u001a:p[*\u0001\u0003\u0005\t\u0011+AA\u0014XM^5pkN\u00043\u000f^3qg\u0002\ng\u000e\u001a\u0011bY2|wo\u001d\u0011g_J\u0004\u0013mY2v[Vd\u0017\r^5p]\u0002zg\r\t8fo\u00022\u0018\r\\;fg&R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0019\u0004\u0013\r\\4pe&$\b.\u001c\u0011ti\u0016\u0004\b\u0005\u000b:v]\u0002zg\u000eI3bG\"\u0004S\rZ4fS)\u0001\u0003\u0005\t\u0011+_\u00059\u0011\u000e^3sCR,GcB%\u0003\u0012\nM%Q\u0014\u0005\u0007Sf\u0001\rAa\u0018\t\u000f\tU\u0015\u00041\u0001\u0003\u0018\u0006Q\u0011\u000e^3sCRLwN\\:\u0011\u0007I\u0012I*C\u0002\u0003\u001cN\u00121!\u00138u\u0011\u0019\u0011y*\u0007a\u0001{\u0006\u0019R\r_3dkR,W*Z:tC\u001e,Gm\u00148ms\"*\u0011$W2\u0003$\u0006\u0012!QU\u0001\u0003R>R#\u0006I#yK\u000e,H/\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9!e\u0016\u0004X-\u0019;fI2L\bEZ8sA\u001dLg/\u001a8!]Vl'-\u001a:!_\u001a\u0004\u0013\u000e^3sCRLwN\\:!_J\u0004SO\u001c;jY\u0002\nG\u000e\u001c\u0011wKJ$\u0018nY3tA!\fg/\u001a\u0011w_R,G\r\t;pA!\fG\u000e\u001e\u0018\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!C2<wN]5uQ6\u00043\u000f^3qA!\u0012XO\u001c\u0011p]\u000e,\u0007EZ8sA\u0015\f7\r\u001b\u0011wKJ$X\r\u001f\u0011qKJ\u0004\u0013\u000e^3sCRLwN\\\u0015D +\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!SR,'/\u0019;j_:\u001c\b%\\1yS6,X\u000e\t8v[\n,'\u000fI8gA%$XM]1uS>t7O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S\r_3dkR,W*Z:tC\u001e,Gm\u00148ms\u0002Je\r\t1ueV,\u0007\r\f\u0011p]2L\bE];oAM$X\r\u001d\u0011g_J\u0004c/\u001a:uS\u000e,7\u000fI<iS\u000eD\u0007E]3dK&4X\r\u001a\u0011oK^\u0004S.Z:tC\u001e,7O\u0003\u0011!A\u0001Rs\u0006F\u0004J\u0005S\u0013YK!,\t\r%T\u0002\u0019\u0001B6\u0011\u001d\u0011)J\u0007a\u0001\u0005/CaAa(\u001b\u0001\u0004i\b&\u0002\u000eZG\nE\u0016E\u0001BZ\u0003\r%qF\u000b\u0016!\u000bb,7-\u001e;fA\u0005dwm\u001c:ji\"l\u0007e\u001d;fa\u0002:\u0018\u000e\u001e5!O2|'-\u00197!OJ\f\u0007\u000f\u001b\u0011ti\u0006$X\r\t:fa\u0016\fG/\u001a3ms\u00022wN\u001d\u0011hSZ,g\u000e\t8v[\n,'\u000fI8gA%$XM]1uS>t7\u000fI8s\u0015\u0001\u0002\u0003\u0005\t\u0016!k:$\u0018\u000e\u001c\u0011bY2\u0004c/\u001a:uS\u000e,7\u000f\t5bm\u0016\u0004co\u001c;fI\u0002\"x\u000e\t5bYRt#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u00022\u0007%\u00197h_JLG\u000f[7!gR,\u0007\u000f\t\u0015sk:\u0004sN\\2fA\u0019|'\u000fI3bG\"\u0004c/\u001a:uKb\u0004\u0003/\u001a:!SR,'/\u0019;j_:L#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002JG/\u001a:bi&|gn\u001d\u0011nCbLW.^7!]Vl'-\u001a:!_\u001a\u0004\u0013\u000e^3sCRLwN\\:\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI3yK\u000e,H/Z'fgN\fw-\u001a3P]2L\b%\u00134!AR\u0014X/\u001a1-A=tG.\u001f\u0011sk:\u00043\u000f^3qA\u0019|'\u000f\t<feRL7-Z:!o\"L7\r\u001b\u0011sK\u000e,\u0017N^3eA9,w\u000fI7fgN\fw-Z:\u000bA\u0001\u0002\u0003EK\u0018\u0002\rM,G.Z2u)\u0011\u0011IL!2\u0011\t\tm&\u0011Y\u0007\u0003\u0005{S1Aa0(\u0003\u0015!\u0018M\u00197f\u0013\u0011\u0011\u0019M!0\u0003\u000bQ\u000b'\r\\3\t\r%\\\u0002\u0019\u0001Bd!\u0015\u00114n\u0012Be!\u0011\u0011YLa3\n\t\t5'Q\u0018\u0002\u0004%><\b&B\u000eZG\nE\u0017E\u0001Bj\u0003\u0005mqF\u000b\u0016!/JLG/\u001a\u0011pkR\u0004X\u000f\u001e\u0011u_\u0002\"\u0018M\u00197fA]LG\u000f\u001b\u0011p]\u0016\u0004#o\\<!a\u0016\u0014\bE^3si\u0016D(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u00022\u0007EZ;oGRLwN\u001c\u0011u_\u0002*\u0007\u0010\u001e:bGR\u0004C-\u0019;bA\u0019\u0014x.\u001c\u0011wKJ$X\r\u001f\u0011)eVt\u0007e\u001c8dK\u00022wN\u001d\u0011fC\u000eD\u0007E^3si\u0016D\u0018F\u0003\u0011!A\u0001Rs\u0006\u0006\u0003\u0003:\n]\u0007BB5\u001d\u0001\u0004\u0011I\u000eE\u00043\u0003\u001b9UN!3)\u000bqI6M!8\"\u0005\t}\u0017!a\u00140U)\u0002sK]5uK\u0002zW\u000f\u001e9vi\u0002\"x\u000e\t;bE2,\u0007e^5uQ\u0002\n7mY3tg\u0002\"x\u000eI4m_\n\fG\u000eI4sCBD\u0007e\u001d;bi\u0016T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0019\u0004c-\u001e8di&|g\u000e\t;pA\u0015DHO]1di\u0002\"\u0017\r^1!MJ|W\u000e\t<feR,\u0007\u0010I1oI\u0002:'/\u00199iAM$\u0018\r^3!QI,h\u000eI8oG\u0016\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t<feR,\u00070\u000b\u0006!A\u0001\u0002#fL\u0001\rO2|'-\u00197TK2,7\r\u001e\u000b\u0005\u0005s\u0013)\u000f\u0003\u0004j;\u0001\u0007!q\u001d\t\u0006e-l'\u0011\u001a\u0015\u0006;e\u001b'1^\u0011\u0003\u0005[\f\u00111J\u0018+U\u0001:&/\u001b;fA\u001ddwNY1mA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0011u_\u0002\"\u0018M\u00197fA!\"\b.[:!GJ,\u0017\r^3tA\u0005\u0004C/\u00192mK\u0002:\u0018\u000e\u001e5!C\u0002\u001a\u0018N\\4mK\u0002\u0012xn^\u0015\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!MVt7\r^5p]\u0002\"x\u000eI3yiJ\f7\r\u001e\u0011eCR\f\u0007E\u001a:p[\u0002:'/\u00199iAM$\u0018\r^3!QI,hn\u001d\u0011p]2L\be\u001c8dK&R\u0001\u0005\t\u0011!U=\nQ\"\u001a=qY>$WmU3mK\u000e$H\u0003\u0002B]\u0005gDa!\u001b\u0010A\u0002\tU\b#\u0002\u001al\u000f\n]\bCBA)\u0005s\u0014I-\u0003\u0003\u0003|\u0006\u0015$\u0001D%uKJ\f'\r\\3P]\u000e,\u0007&\u0002\u0010ZG\n}\u0018EAB\u0001\u0003a|#F\u000b\u0011Xe&$X\rI8viB,H\u000f\t;pAQ\f'\r\\3!o&$\b\u000eI7vYRL\u0007\u000f\\3!e><8\u000f\t9fe\u00022XM\u001d;fq*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!M\u00022WO\\2uS>t\u0007\u0005^8!Kb$(/Y2uA\u0011\fG/\u0019\u0011ge>l\u0007E^3si\u0016D(\u0002\t\u0011!A)zC\u0003\u0002B]\u0007\u000bAa![\u0010A\u0002\r\u001d\u0001c\u0002\u001a\u0002\u000e\u001dk'q\u001f\u0015\u0006?e\u001b71B\u0011\u0003\u0007\u001b\t\u0011qJ\u0018+U\u0001:&/\u001b;fA=,H\u000f];uAQ|\u0007\u0005^1cY\u0016\u0004s/\u001b;iA5,H\u000e^5qY\u0016\u0004#o\\<tAA,'\u000f\t<feR,\u0007P\u0003\u0011!A\u0001R\u0003%^:j]\u001e\u0004s\r\\8cC2\u0004sM]1qQ\u0002\u001aH/\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011gA\u0019,hn\u0019;j_:\u0004Co\u001c\u0011fqR\u0014\u0018m\u0019;!I\u0006$\u0018\r\t4s_6\u0004c/\u001a:uKb\u0004\u0013M\u001c3!OJ\f\u0007\u000f\u001b\u0011ti\u0006$XM\u0003\u0011!A\u0001Rs&A\u0007dY\u0016\f'/T3tg\u0006<Wm\u001d\u000b\u0002\u0013\"*\u0001%W2\u0004\u0016\u0005\u00121qC\u0001\u0002R=R#\u0006I\"mK\u0006\u0014\b%\\3tg\u0006<Wm\u001d\u0011ge>l\u0007\u0005\u001d:fm&|Wo\u001d\u0011pa\u0016\u0014\u0018\r^5p]Nt\u0003\u0005\u00165jg\u00022WO\\2uS>t\u0007%[:!aJ,Gm\\7j]\u0006tG\u000f\\=!kN,G\rI5oi\u0016\u0014h.\u00197ms\u0002\ng\u000e\u001a\u0011tQ>,H\u000e\u001a8(i\u0002\u0012W\rI2bY2,G\r\t2zAQDW\rI;tKJ\u0004SO\u001c7fgN\u0004C\u000f[3zA-twn\u001e\u0011xQ\u0006$\b\u0005\u001e5fs\u0002\n'/\u001a\u0011e_&twM\f\u0011+_\u0005AR.\u001e7uS2\f\u00170\u001a:WS\u0016<H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\ru!\u0006BA'\u0007?Y#a!\t\u0011\t\r\r2QF\u0007\u0003\u0007KQAaa\n\u0004*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007W\u0019\u0014AC1o]>$\u0018\r^5p]&!1qFB\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014C\u001e<'/Z4bi\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0007k\u0001Daa\u000e\u0004P)\"1\u0011HB\u0010!\u0019\u00114na\u000f\u0002\u001eB11QHB\"\u0007\u000fj!aa\u0010\u000b\u0007\r\u00053'\u0001\u0006d_2dWm\u0019;j_:LAa!\u0012\u0004@\tA\u0011\n^3sC\ndW\rE\u0003>\u0007\u0013\u001ai%C\u0002\u0004Ly\u0012Q\u0002\u0015:pa\u0016\u0014H/\u001f,bYV,\u0007\u0003BAK\u0007\u001f\"1Ba\b#\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\u0006\u0019\u0012mZ4sK\u001e\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u000b\u0016\u0005\u0007/\u001ay\u0002\u0005\u0005\u00028\u0006}\u0016QYB-a\u0019\u0019Yfa\u0018\u0004dAA\u0011qQAG\u0007;\u001a\t\u0007\u0005\u0003\u0002\u0016\u000e}Ca\u0003B\u001aG\u0005\u0005\t\u0011!B\u0001\u00037\u0003B!!&\u0004d\u0011Y!\u0011H\u0012\u0002\u0002\u0003\u0005)\u0011AANQ\u0015\u0001\u0011lYB4C\t\u0019I'AC<_)R\u0003\u0005U;cY&\u001c\u0007%\u001b8uKJ4\u0017mY3!M>\u0014\be\u001a:ba\"\u0004s\u000e]3sCRLwN\\:\u000bA\u0001R#\u0002\t\u0011+AQCW\r\t1He\u0006\u0004\b\u000eU3sgB,7\r^5wK\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004\u0013N\u001c;fe\u001a\f7-\u001a\u0011g_J\u0004C-\u001a4j]&tw\rI1mO>\u0014\u0018\u000e\u001e5ng\u0002Jg\u000e\t*ba\"$xN]=!C:$\u0007E]3d_J$7\u000fI1mY\u0002z\u0007/\u001a:bi&|gn\u001d\u0011u_\u0002\u0012WM\u0003\u0011!U\u0001\n\u0007\u000f\u001d7jK\u0012\u0004Co\u001c\u0011bA\u001d\u0014\u0018\r\u001d5!CN\u0004\u0013\rI:fcV,gnY3!_\u001a\u00043\u000f^3qg\u0002\"x\u000eI3yK\u000e,H/\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A5{7\u000f\u001e\u0011pa\u0016\u0014\u0018\r^5p]N\u0004sN\u001c\u0011bA\u0001<%/\u00199i!\u0016\u00148\u000f]3di&4X\r\u0019\u0011sKR,(O\u001c\u0011bA\u001d\u0014\u0018\r\u001d5!_J\u0004S.\u001e7uS2\f\u00170\u001a:\u000bA\u0001R\u0003e\u001a:ba\"\u0004\u0013m\u001d\u0011bAI,7/\u001e7u]\u0001\"v\u000eI:vaB|'\u000f\u001e\u0011sKR,(O\\5oO\u0002\"\b.\u001a\u0006!A)\u00023m\u001c:sK\u000e$\be\u001a:ba\"\u0004C/\u001f9fY\u0001\"\b.\u001a\u0011a\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\u0004\u0007\u0005[1tA\u0005\u00147\u000f\u001e:bGR\u0004C/\u001f9fA5,WNY3sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003%\f\u0011a\u000fJ\f\u0007\u000f\u001b1;A\r+(O]3oi\u0002:'/\u00199iAQL\b/\u001a\u0011)G\u0006t\u0007EY3![VdG/\u001b7bs\u0016\u0014\be\u001c:!e\u0016$WoY3eS)\u0001\u0003E\u000b\u0011![\u0001\u0002W*\u001e7uS2\f\u00170\u001a:He\u0006\u0004\b\u000e\u0019\u001e!)\",\u0007\u0005^=qK\u0002zg\r\t;iK\u0002Z6,T;mi&d\u0017-_3s\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016lV\fI2peJ,7\u000f]8oI&tw\r\t;pAQDW\rI2veJ,g\u000e\u001e\u0011he\u0006\u0004\bN\u0003\u0011!U\u0001\u0002S\u0006\t1SK\u0012,8-\u001a3He\u0006\u0004\b\u000e\u0019\u001e!)\",\u0007\u0005^=qK\u0002zg\r\t;iK\u0002Z6LU3ek\u000e,Gm\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3^;\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002\"x\u000e\t;iK\u0002\u001aWO\u001d:f]R\u0004sM]1qQ*\u0001\u0003EK\u0018")
public interface GraphPerspective {
    @Scaladoc(value="/**\n    * Return the graph unchanged\n    *\n    * This is used to obtain the correct return type without performing any operations\n    */")
    public ConcreteGraphPerspective identity();

    @Scaladoc(value="/** Add a function to manipulate global graph state, mainly used to initialise accumulators before the next algorithm step\n    *\n    * @param f function to set graph state (runs exactly once)\n    */")
    public ConcreteGraphPerspective setGlobalState(Function1<GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Filter vertices of the graph\n    *\n    * @param f filter function (only vertices for which `f` returns `true` are kept). All associated edges of filtered vertices are also removed.\n    */")
    public ConcreteGraphPerspective vertexFilter(Function1<Vertex, Object> var1);

    @Scaladoc(value="/** Filter vertices of the graph with global graph state\n    *\n    * @param f filter function with access to graph state (only vertices for which `f` returns `true` are kept). All associated edges of filtered vertices are also removed.\n    */")
    public ConcreteGraphPerspective vertexFilter(Function2<Vertex, GraphState, Object> var1);

    @Scaladoc(value="/** Filter edges of the graph\n    *\n    * @param f filter function (only edges for which `f` returns `true` are kept)\n    *\n    * @param pruneNodes if this is `true` then vertices which become isolated (have no incoming or outgoing edges)\n    *                   after this filtering are also removed.\n    */")
    public ConcreteGraphPerspective edgeFilter(Function1<Edge, Object> var1, boolean var2);

    @Scaladoc(value="/** Filter edges of the graph with global graph state\n    *\n    * @param f filter function with access to graph state (only edges for which `f` returns `true` are kept)\n    *\n    * @param pruneNodes if this is `true` then vertices which become isolated (have no incoming or outgoing edges)\n    *                   after this filtering are also removed.\n    */")
    public ConcreteGraphPerspective edgeFilter(Function2<Edge, GraphState, Object> var1, boolean var2);

    @Scaladoc(value="/** Switch to multilayer view\n    *\n    * After calling `multilayerView`, subsequent methods that manipulate vertices act on\n    * [[visitor.ExplodedVertex ExplodedVertices]] instead. If [[visitor.ExplodedVertex ExplodedVertex]]\n    * instances were already created by a previous call to `multilayerView`, they are preserved. Otherwise, this\n    * method creates an [[visitor.ExplodedVertex ExplodedVertex]] instance for each\n    * time point that a vertex is active.\n    */")
    public ConcreteMultilayerGraphPerspective multilayerView();

    @Scaladoc(value="/** Switch to multilayer view and add interlayer edges.\n    *\n    * @param interlayerEdgeBuilder Interlayer edge builder to create interlayer edges for each vertex. See\n    *                              [[visitor.InterlayerEdgeBuilders InterlayerEdgeBuilders]] for predefined options.\n    *\n    * Existing [[visitor.ExplodedVertex ExplodedVertex]] instances are preserved but all interlayer edges are recreated using the supplied\n    * `interlayerEdgeBuilder`.\n    */")
    public ConcreteMultilayerGraphPerspective multilayerView(Function1<Vertex, Seq<InterlayerEdge>> var1);

    public static /* synthetic */ Function1 multilayerView$default$1$(GraphPerspective $this) {
        return $this.multilayerView$default$1();
    }

    default public Function1<Vertex, Seq<InterlayerEdge>> multilayerView$default$1() {
        return (Function1 & Serializable)x$1 -> (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
    }

    @Scaladoc(value="/** Switch computation to act on [[visitor.Vertex Vertex]], inverse of `multilayerView`\n    *\n    * This operation does nothing if the view is already reduced. Otherwise it switches back to running computations\n    * on vertices but preserves any existing [[visitor.ExplodedVertex ExplodedVertex]] instances\n    * created by previous calls to `multilayerView` to allow switching back-and-forth between views while\n    * preserving computational state. Computational state on [[visitor.ExplodedVertex ExplodedVertex]]\n    * instances is not accessible from the `Vertex` unless a merge strategy is supplied (see below).\n    */")
    public ConcreteReducedGraphPerspective reducedView();

    @Scaladoc(value="/** Reduce view and apply the same merge strategy to convert each exploded state to vertex state\n    *\n    * @param mergeStragegy Function to convert a history of values of type to a single value of type (see\n    *          [[PropertyMergeStrategy]] for predefined options)\n    */")
    public ConcreteReducedGraphPerspective reducedView(Function1<Iterable<PropertyValue<Object>>, Object> var1);

    @Scaladoc(value="/** Reduce view and merge selected exploded state to vertex state\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy. Only state included in\n    *                         `mergeStrategyMap` will be reduced and\n    *                         made available on the Vertex.\n    */")
    public ConcreteReducedGraphPerspective reducedView(Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var1);

    @Scaladoc(value="/** Reduce view and merge all exploded vertex state\n    *\n    * @param defaultMergeStrategy Merge strategy for state not included in `mergeStrategyMap`\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy (used to override `defaultMergeStrategy`).\n    */")
    public ConcreteReducedGraphPerspective reducedView(Function1<Iterable<PropertyValue<Object>>, Object> var1, Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var2);

    @Scaladoc(value="/** Reduce view and delete exploded vertices permanently\n    *\n    * This function has the same effect as `reducedView`, except that the exploded vertices are deleted and no longer\n    * available for subsequent calls of `multilayerView`.\n    *\n    * @param defaultMergeStrategy Merge strategy for state not included in `mergeStrategyMap`\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy (used to override `defaultMergeStrategy`).\n    */")
    public ConcreteReducedGraphPerspective aggregate(Function1<Iterable<PropertyValue<Object>>, Object> var1, Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var2);

    public static /* synthetic */ Function1 aggregate$default$1$(GraphPerspective $this) {
        return $this.aggregate$default$1();
    }

    default public Function1<Iterable<PropertyValue<Object>>, Object> aggregate$default$1() {
        return PropertyMergeStrategy$.MODULE$.sequence();
    }

    public static /* synthetic */ Map aggregate$default$2$(GraphPerspective $this) {
        return $this.aggregate$default$2();
    }

    default public Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> aggregate$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    @Scaladoc(value="/**\n    * View the graph as an undirected network (edges that exist only in one direction are duplicated and edges that exist\n    * in both directions are merged)\n    */")
    public ConcreteGraphPerspective undirectedView();

    @Scaladoc(value="/**\n    * View the graph as a directed network (duplicated edges created by a previous call to `undirectedView` are removed\n    * and bi-directional edges un-merged)\n    */")
    public ConcreteGraphPerspective directedView();

    @Scaladoc(value="/**\n    * Reverse the direction of each edge in the graph.\n    *\n    * Note that if the graph is currently viewed as undirected, this method has no immediate effect, however,\n    * edges will be reversed on a subsequent call to `directedView`\n    */")
    public ConcreteGraphPerspective reversedView();

    @Scaladoc(value="/** Execute algorithm step\n    *\n    * @param f algorithm step (run once for each vertex)\n    */")
    public ConcreteGraphPerspective step(Function1<Vertex, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step with global graph state (has access to accumulated state from\n    * previous steps and allows for accumulation of new values)\n    *\n    * @param f algorithm step (run once for each vertex)\n    */")
    public ConcreteGraphPerspective step(Function2<Vertex, GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step\n    *\n    * @param f algorithm step (run on each edge)\n    */")
    public ConcreteGraphPerspective edgeStep(Function1<Edge, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step with global graph state (has access to accumulated state from\n    * previous steps and allows for accumulation of new values)\n    *\n    * @param f algorithm step (run on each edge)\n    */")
    public ConcreteGraphPerspective edgeStep(Function2<Edge, GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step repeatedly for given number of iterations or until all vertices have voted to halt.\n    *\n    * @param f algorithm step (run once for each vertex per iteration)\u00cf\n    *\n    * @param iterations maximum number of iterations\n    *\n    * @param executeMessagedOnly If `true`, only run step for vertices which received new messages\n    */")
    public ConcreteGraphPerspective iterate(Function1<Vertex, BoxedUnit> var1, int var2, boolean var3);

    @Scaladoc(value="/** Execute algorithm step with global graph state repeatedly for given number of iterations or\n    * until all vertices have voted to halt.\n    *\n    * @param f algorithm step (run once for each vertex per iteration)\n    *\n    * @param iterations maximum number of iterations\n    *\n    * @param executeMessagedOnly If `true`, only run step for vertices which received new messages\n    */")
    public ConcreteGraphPerspective iterate(Function2<Vertex, GraphState, BoxedUnit> var1, int var2, boolean var3);

    @Scaladoc(value="/** Write output to table with one row per vertex\n    *\n    * @param f function to extract data from vertex (run once for each vertex)\n    */")
    public Table select(Function1<Vertex, Row> var1);

    @Scaladoc(value="/** Write output to table with access to global graph state\n    *\n    * @param f function to extract data from vertex and graph state (run once for each vertex)\n    */")
    public Table select(Function2<Vertex, GraphState, Row> var1);

    @Scaladoc(value="/** Write global graph state to table (this creates a table with a single row)\n    *\n    * @param f function to extract data from graph state (runs only once)\n    */")
    public Table globalSelect(Function1<GraphState, Row> var1);

    @Scaladoc(value="/** Write output to table with multiple rows per vertex\n    *\n    * @param f function to extract data from vertex\n    */")
    public Table explodeSelect(Function1<Vertex, IterableOnce<Row>> var1);

    @Scaladoc(value="/** Write output to table with multiple rows per vertex\n    * using global graph state\n    *\n    * @param f function to extract data from vertex and graph state\n    */")
    public Table explodeSelect(Function2<Vertex, GraphState, IterableOnce<Row>> var1);

    @Scaladoc(value="/** Clear messages from previous operations. This function is predominantly used internally and shouldn't be called by the user unless they know what they are doing. */")
    public ConcreteGraphPerspective clearMessages();
}

