/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.algorithm;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base class for writing graph algorithms that map multilayer views to reduced views.\n  *\n  * A `MultilayerReduction` maps a multilayer view to a reduced graph view and requires the\n  * input graph to be multilayer.\n  *\n  * @define chainBody The new algorithm's `apply` method first applies this algorithm and then the `other`,\n  *                   clearing all messages in-between. The `tabularise` method of the chained algorithm calls only\n  *                   the `tabularise` method of `other`.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00194q\u0001C\u0005\u0011\u0002\u0007\u0005A\u0003C\u0003 \u0001\u0011\u0005\u0001%\u0002\u0003%\u0001\u0001*S\u0001B\u0016\u0001A1BQa\f\u0001\u0005\u0002ABQA\u000f\u0001\u0005BmBQA\u000f\u0001\u0005\u0002ACQA\u000f\u0001\u0005\u0002a\u00131#T;mi&d\u0017-_3s%\u0016$Wo\u0019;j_:T!AC\u0006\u0002\u0013\u0005dwm\u001c:ji\"l'B\u0001\u0007\u000e\u0003!\tg.\u00197zg&\u001c(B\u0001\b\u0010\u0003\r\t\u0007/\u001b\u0006\u0003!E\t\u0001B]1qQR|'/\u001f\u0006\u0002%\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\n\u0013\tq\u0012BA\u0007CCN,\u0017\t\\4pe&$\b.\\\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0005\u0002\"A\u0006\u0012\n\u0005\r:\"\u0001B+oSR\u0014!!\u00138\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!Z\u0011!C4sCBDg/[3x\u0013\tQsE\u0001\u000eNk2$\u0018\u000e\\1zKJ<%/\u00199i!\u0016\u00148\u000f]3di&4XMA\u0002PkR\u0004\"AJ\u0017\n\u00059:#a\u0006*fIV\u001cW\rZ$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0003\u0015\t\u0007\u000f\u001d7z)\t\tD\u0007\u0005\u00023m9\u00111\u0007\u000e\u0007\u0001\u0011\u0015)D\u00011\u0001&\u0003\u00159'/\u00199i\u0013\t9\u0004H\u0001\u0007SK\u0012,8-\u001a3He\u0006\u0004\b.\u0003\u0002:O\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0001\u000fI5Lg.^:%OJ,\u0017\r^3s)\taT\b\u0005\u0002\u001d\u0001!)a(\u0002a\u0001\u007f\u0005)q\u000e\u001e5feB\u0011A\u0004Q\u0005\u0003\u0003&\u0011qaR3oKJL7\r\u000b\u0003\u0006\u00076s\u0005C\u0001#L\u001b\u0005)%B\u0001$H\u0003!\u00198-\u00197bI>\u001c'B\u0001%J\u0003\u001d!\u0018m[3{_\u0016T!AS\t\u0002\r\u001dLG\u000f[;c\u0013\taUI\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005y\u0015!!\u00050U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005\u00043lW$f]\u0016\u0014\u0018nY/^A\u0005dwm\u001c:ji\"l'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\"3\r[1j]\n{G-\u001f\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI8uQ\u0016\u0014\b%\u00117h_JLG\u000f[7!i>\u0004\u0013\r\u001d9ms\u0002\ng\r^3sAQD\u0017n\u001d\u0011p]\u0016T\u0001\u0005\t\u0011!U=\"\"\u0001P)\t\u000by2\u0001\u0019\u0001*\u0011\u0005q\u0019\u0016B\u0001+\n\u0005A9UM\\3sS\u000e\u0014V\rZ;di&|g\u000e\u000b\u0003\u0007\u000763\u0016%A,\u0002\u0003Gy#F\u000b\u0011DQ\u0006Lg\u000e\t;iSN\u0004\u0013\r\\4pe&$\b.\u001c\u0011xSRD\u0007%\u0019\u0011\\7\u001e+g.\u001a:jGJ+G-^2uS>tW,\u0018\u0011bY\u001e|'/\u001b;i[*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!I\rD\u0017-\u001b8C_\u0012L(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004s\u000e\u001e5fe\u0002\nEnZ8sSRDW\u000e\t;pA\u0005\u0004\b\u000f\\=!C\u001a$XM\u001d\u0011uQ&\u001c\be\u001c8f\u0015\u0001\u0002\u0003\u0005\t\u00160)\tIF\f\u0005\u0002\u001d5&\u00111,\u0003\u0002\u000b\u001bVdG/\u001b7bs\u0016\u0014\b\"\u0002 \b\u0001\u0004i\u0006C\u0001\u000f_\u0013\ty\u0016B\u0001\u000bNk2$\u0018\u000e\\1zKJ\u0004&o\u001c6fGRLwN\u001c\u0015\u0005\u000f\rk\u0015-I\u0001c\u0003\u0005-rF\u000b\u0016!\u0007\"\f\u0017N\u001c\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!o&$\b\u000eI1!7nkU\u000f\u001c;jY\u0006LXM\u001d)s_*,7\r^5p]vk\u0006%\u00197h_JLG\u000f[7\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t\u0013dQ\u0006LgNQ8es*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA=$\b.\u001a:!\u00032<wN]5uQ6\u0004Co\u001c\u0011baBd\u0017\u0010I1gi\u0016\u0014\b\u0005\u001e5jg\u0002zg.\u001a\u0006!A\u0001\u0002#f\f\u0015\u0005\u0001\rkE-I\u0001f\u0003\rexF\u000b\u0016!\u0005\u0006\u001cX\rI2mCN\u001c\bEZ8sA]\u0014\u0018\u000e^5oO\u0002:'/\u00199iA\u0005dwm\u001c:ji\"l7\u000f\t;iCR\u0004S.\u00199![VdG/\u001b7bs\u0016\u0014\bE^5foN\u0004Co\u001c\u0011sK\u0012,8-\u001a3!m&,wo\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0005\u0003\u0003-T;mi&d\u0017-_3s%\u0016$Wo\u0019;j_:\u0004\u0007%\\1qg\u0002\n\u0007%\\;mi&d\u0017-_3sAYLWm\u001e\u0011u_\u0002\n\u0007E]3ek\u000e,G\rI4sCBD\u0007E^5fo\u0002\ng\u000e\u001a\u0011sKF,\u0018N]3tAQDWM\u0003\u0011!U\u0001Jg\u000e];uA\u001d\u0014\u0018\r\u001d5!i>\u0004#-\u001a\u0011nk2$\u0018\u000e\\1zKJt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!eK\u001aLg.\u001a\u0011dQ\u0006LgNQ8es\u0002\"\u0006.\u001a\u0011oK^\u0004\u0013\r\\4pe&$\b.\\\u0014tA\u0001\f\u0007\u000f\u001d7zA\u0002jW\r\u001e5pI\u00022\u0017N]:uA\u0005\u0004\b\u000f\\5fg\u0002\"\b.[:!C2<wN]5uQ6\u0004\u0013M\u001c3!i\",g\u000e\t;iK\u0002\u0002w\u000e\u001e5fe\u0002d#\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I2mK\u0006\u0014\u0018N\\4!C2d\u0007%\\3tg\u0006<Wm\u001d\u0011j]6\u0012W\r^<fK:t\u0003\u0005\u00165fA\u0001$\u0018MY;mCJL7/\u001a1![\u0016$\bn\u001c3!_\u001a\u0004C\u000f[3!G\"\f\u0017N\\3eA\u0005dwm\u001c:ji\"l\u0007eY1mYN\u0004sN\u001c7z\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011ai\u0006\u0014W\u000f\\1sSN,\u0007\rI7fi\"|G\rI8gA\u0001|G\u000f[3sA:R\u0001\u0005\t\u00160\u0001")
public interface MultilayerReduction
extends BaseAlgorithm {
    public static /* synthetic */ ConcreteReducedGraphPerspective apply$(MultilayerReduction $this, MultilayerGraphPerspective graph) {
        return $this.apply(graph);
    }

    default public ConcreteReducedGraphPerspective apply(MultilayerGraphPerspective graph) {
        return graph.reducedView();
    }

    public static /* synthetic */ MultilayerReduction $minus$greater$(MultilayerReduction $this, Generic other) {
        return $this.$minus$greater(other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerReduction $minus$greater(Generic other) {
        return new MultilayerReduction(this, other){

            public ConcreteReducedGraphPerspective apply(MultilayerGraphPerspective graph) {
                return MultilayerReduction.apply$(this, graph);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(Generic other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }
            {
                MultilayerReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerReduction $minus$greater$(MultilayerReduction $this, GenericReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerReduction $minus$greater(GenericReduction other) {
        return new MultilayerReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(Generic other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return MultilayerReduction.$minus$greater$((MultilayerReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((GenericReduction)this.second()).apply(((MultilayerReduction)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ Multilayer $minus$greater$(MultilayerReduction $this, MultilayerProjection other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public Multilayer $minus$greater(MultilayerProjection other) {
        return new Multilayer(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Generic other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(GenericReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerReduction $minus$greater(MultilayerReduction other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(MultilayerProjection other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with another Multilayer algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Multilayer $minus$greater(Multilayer other) {
                return Multilayer.$minus$greater$((Multilayer)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(MultilayerGraphPerspective graph) {
                return ((MultilayerProjection)this.second()).apply(((MultilayerReduction)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                Multilayer.$init$(this);
            }
        };
    }

    public static void $init$(MultilayerReduction $this) {
    }
}

