/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.TemporalNodeList$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * {s}`TemporalNodeList(properties: String*) = new TemporalNodeList(properties)`\n  *  : Write out timestamped nodes with selected properties to table\n  *\n  * {s}`TemporalNodeLisst(defaults: Map[String, Any], properties: String*)`\n  *  : Specify default values for missing properties\n  *\n  * {s}`TemporalNodeList(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  *  : Specify property names as sequence\n  *\n  * Property names are looked up on a node's computational state first and then in a node's property. Property values\n  * are looked up using creation timestamps explicitly. Computational state is expanded if it is a sequence\n  * with the same size as the vertex's distinct creation timestamps and assuming that state maps to a vertex's\n  * distinct, sorted timestamps. This means that this algorithm can be used as the last step in an algorithm\n  * chain to include output of intermediate results.\n  *\n  * ## Params\n  *\n  *  {s}`properties: Seq[String]`\n  *    : Sequence of property names\n  *\n  *  {s}`defaults: Map[String, Any]`\n  *    : Map from property names to default values (if a property name is not found on a node,\n  *      it is first looked up in defaults, and if not found there, set to {s}`None`)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | time stamp      | property 1      | ... |\n  *  | ----------------- | --------------- | --------------- | --- |\n  *  | {s}`name: String` | {s}`time: Long` | {s}`value: Any` | ... |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\t\u0012\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\")q\t\u0001C\u0001\u0011\")Q\n\u0001C!\u001d\u001e)1.\u0005E\u0001Y\u001a)\u0001#\u0005E\u0001[\")qI\u0002C\u0001m\")qO\u0002C\u0001q\"91PBI\u0001\n\u0003a\b\"CA\b\rE\u0005I\u0011AA\t\u0011\u00199h\u0001\"\u0001\u0002\u0016!1qO\u0002C\u0001\u0003?A\u0001\"!\n\u0007#\u0003%\t\u0001 \u0005\n\u0003O1\u0011\u0013!C\u0001\u0003#A\u0011\"!\u000b\u0007\u0003\u0003%I!a\u000b\u0003!Q+W\u000e]8sC2tu\u000eZ3MSN$(B\u0001\n\u0014\u0003!!X-\u001c9pe\u0006d'B\u0001\u000b\u0016\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003-]\t\u0001B]1qQR|'/\u001f\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011\u0013&D\u0001$\u0015\t!S%A\u0005bY\u001e|'/\u001b;i[*\u0011aeJ\u0001\tC:\fG._:jg*\u0011\u0001&F\u0001\u0004CBL\u0017B\u0001\u0016$\u0005\u001d9UM\\3sS\u000e\f!\u0002\u001d:pa\u0016\u0014H/[3t!\riS\u0007\u000f\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!M\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u001b\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u0007M+\u0017O\u0003\u00025;A\u0011\u0011(\u0010\b\u0003um\u0002\"aL\u000f\n\u0005qj\u0012A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u000f\u0002\u0011\u0011,g-Y;miN\u0004B!\u000f\"9\t&\u00111i\u0010\u0002\u0004\u001b\u0006\u0004\bC\u0001\u000fF\u0013\t1UDA\u0002B]f\fa\u0001P5oSRtDcA%L\u0019B\u0011!\nA\u0007\u0002#!91f\u0001I\u0001\u0002\u0004a\u0003b\u0002!\u0004!\u0003\u0005\r!Q\u0001\u000bi\u0006\u0014W\u000f\\1sSN,GCA(V!\t\u00016+D\u0001R\u0015\t\u0011V%A\u0003uC\ndW-\u0003\u0002U#\n)A+\u00192mK\")a\u000b\u0002a\u0001/\u0006)qM]1qQB\u0011\u0001lW\u0007\u00023*\u0011!,J\u0001\nOJ\f\u0007\u000f\u001b<jK^L!\u0001X-\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0007\u0006\u0002\u0001_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!a\u00193\u0002\u000fQ\f7.\u001a>pK*\u0011QmF\u0001\u0007O&$\b.\u001e2\n\u0005\u001d\u0004'\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003)\f12Z\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004G+Z7q_J\fGNT8eK2K7\u000f\u001e\u0015qe>\u0004XM\u001d;jKNT\u0004e\u0015;sS:<'&\u000b\u0011>A9,w\u000f\t+f[B|'/\u00197O_\u0012,G*[:uQA\u0014x\u000e]3si&,7/\u000b1\u000bA\u0001R\u0003\u0005\t\u001e!/JLG/\u001a\u0011pkR\u0004C/[7fgR\fW\u000e]3eA9|G-Z:!o&$\b\u000eI:fY\u0016\u001cG/\u001a3!aJ|\u0007/\u001a:uS\u0016\u001c\b\u0005^8!i\u0006\u0014G.\u001a\u0006!A)R\u0001\u0005\t\u0016!wNl\b\rV3na>\u0014\u0018\r\u001c(pI\u0016d\u0015n]:uQ\u0011,g-Y;miNT\u0004%T1q7N#(/\u001b8hY\u0001\ne._/-AA\u0014x\u000e]3si&,7O\u000f\u0011TiJLgn\u001a\u0016*A*\u0001\u0003E\u000b\u0011!u\u0001\u001a\u0006/Z2jMf\u0004C-\u001a4bk2$\bE^1mk\u0016\u001c\bEZ8sA5L7o]5oO\u0002\u0002(o\u001c9feRLWm\u001d\u0006!A)R\u0001\u0005\t\u0016!wNl\b\rV3na>\u0014\u0018\r\u001c(pI\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*fcn\u001bFO]5oOv\u0003S\bI*fc:*W\u000e\u001d;z7N#(/\u001b8h;2\u0002C-\u001a4bk2$8O\u000f\u0011NCB\\6\u000b\u001e:j]\u001ed\u0003%\u00118z;\u0002j\u0004%T1q]\u0015l\u0007\u000f^=\\'R\u0014\u0018N\\4-A\u0005s\u00170X\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AM\u0003XmY5gs\u0002\u0002(o\u001c9feRL\bE\\1nKN\u0004\u0013m\u001d\u0011tKF,XM\\2f\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002&o\u001c9feRL\bE\\1nKN\u0004\u0013M]3!Y>|7.\u001a3!kB\u0004sN\u001c\u0011bA9|G-Z\u0014tA\r|W\u000e];uCRLwN\\1mAM$\u0018\r^3!M&\u00148\u000f\u001e\u0011b]\u0012\u0004C\u000f[3oA%t\u0007%\u0019\u0011o_\u0012,we\u001d\u0011qe>\u0004XM\u001d;z]\u0001\u0002&o\u001c9feRL\bE^1mk\u0016\u001c(\u0002\t\u0011+A\u0005\u0014X\r\t7p_.,G\rI;qAU\u001c\u0018N\\4!GJ,\u0017\r^5p]\u0002\"\u0018.\\3ti\u0006l\u0007o\u001d\u0011fqBd\u0017nY5uYft\u0003eQ8naV$\u0018\r^5p]\u0006d\u0007e\u001d;bi\u0016\u0004\u0013n\u001d\u0011fqB\fg\u000eZ3eA%4\u0007%\u001b;!SN\u0004\u0013\rI:fcV,gnY3\u000bA\u0001R\u0003e^5uQ\u0002\"\b.\u001a\u0011tC6,\u0007e]5{K\u0002\n7\u000f\t;iK\u00022XM\u001d;fq\u001e\u001a\b\u0005Z5ti&t7\r\u001e\u0011de\u0016\fG/[8oAQLW.Z:uC6\u00048\u000fI1oI\u0002\n7o];nS:<\u0007\u0005\u001e5bi\u0002\u001aH/\u0019;fA5\f\u0007o\u001d\u0011u_\u0002\n\u0007E^3si\u0016Dxe\u001d\u0006!A)\u0002C-[:uS:\u001cG\u000f\f\u0011t_J$X\r\u001a\u0011uS6,7\u000f^1naNt\u0003\u0005\u00165jg\u0002jW-\u00198tAQD\u0017\r\u001e\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!G\u0006t\u0007EY3!kN,G\rI1tAQDW\r\t7bgR\u00043\u000f^3qA%t\u0007%\u00198!C2<wN]5uQ6T\u0001\u0005\t\u0016!G\"\f\u0017N\u001c\u0011u_\u0002Jgn\u00197vI\u0016\u0004s.\u001e;qkR\u0004sN\u001a\u0011j]R,'/\\3eS\u0006$X\r\t:fgVdGo\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004\u0007O]8qKJ$\u0018.Z:;AM+\u0017oW*ue&tw-\u00181\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u001aV-];f]\u000e,\u0007e\u001c4!aJ|\u0007/\u001a:us\u0002r\u0017-\\3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aI\u00164\u0017-\u001e7ugj\u0002S*\u00199\\'R\u0014\u0018N\\4-A\u0005s\u00170\u00181\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001j\u0015\r\u001d\u0011ge>l\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000f\t;pA\u0011,g-Y;mi\u00022\u0018\r\\;fg\u0002B\u0013N\u001a\u0011bAA\u0014x\u000e]3sif\u0004c.Y7fA%\u001c\bE\\8uA\u0019|WO\u001c3!_:\u0004\u0013\r\t8pI\u0016d#\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011ji\u0002J7\u000f\t4jeN$\b\u0005\\8pW\u0016$\u0007%\u001e9!S:\u0004C-\u001a4bk2$8\u000f\f\u0011b]\u0012\u0004\u0013N\u001a\u0011o_R\u0004cm\\;oI\u0002\"\b.\u001a:fY\u0001\u001aX\r\u001e\u0011u_\u0002Z8/ 1O_:,\u0007-\u000b\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002#+\u001a;ve:\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011}AY,'\u000f^3yA9\fW.\u001a\u0011!A\u0001\u0002\u0003\u0005\t?!i&lW\rI:uC6\u0004\b\u0005\t\u0011!A\u0001b\b\u0005\u001d:pa\u0016\u0014H/\u001f\u00112A\u0001\u0002\u0003\u0005\t\u0011}A9rc\u0006\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002$\u0018.\\3;A1{gn\u001a1!y\u0002Z8/ 1wC2,XM\u000f\u0011B]f\u0004\u0007\u0005 \u0011/]9\u0002CP\u0003\u0011!U=\n\u0001\u0003V3na>\u0014\u0018\r\u001c(pI\u0016d\u0015n\u001d;\u0011\u0005)31c\u0001\u0004\u001c]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0003S>T\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002va\na1+\u001a:jC2L'0\u00192mKR\tA.A\u0003baBd\u0017\u0010F\u0002JsjDqa\u000b\u0005\u0011\u0002\u0003\u0007A\u0006C\u0004A\u0011A\u0005\t\u0019A!\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*\u0012! \u0016\u0003Yy\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nu\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019B\u000b\u0002B}R\u0019\u0011*a\u0006\t\r-Z\u0001\u0019AA\r!\u0011a\u00121\u0004\u001d\n\u0007\u0005uQD\u0001\u0006=e\u0016\u0004X-\u0019;fIz\"R!SA\u0011\u0003GAQ\u0001\u0011\u0007A\u0002\u0005Caa\u000b\u0007A\u0002\u0005e\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g\u0011\u0018\u0001\u00027b]\u001eLA!a\u000e\u00022\t1qJ\u00196fGR\u0004")
public class TemporalNodeList
implements Generic {
    private final Seq<String> properties;
    private final Map<String, Object> defaults;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Map<String, Object> $lessinit$greater$default$2() {
        return TemporalNodeList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return TemporalNodeList$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return TemporalNodeList$.MODULE$.apply$default$2();
    }

    public static Seq<String> apply$default$1() {
        return TemporalNodeList$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return Generic.apply$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.multilayerView().select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> {
            String string = vertex.baseName();
            long l = vertex.timestamp();
            return Row$.MODULE$.apply((Seq<Object>)((Seq)((SeqOps)((SeqOps)$this.properties.map((Function1 & Serializable)key -> ((EntityVisitor)((Object)vertex)).getStateOrElse((String)key, $this.defaults.getOrElse(key, (Function0 & Serializable)() -> None$.MODULE$), true))).$plus$colon((Object)BoxesRunTime.boxToLong((long)l))).$plus$colon((Object)string)));
        });
    }

    public TemporalNodeList(Seq<String> properties, Map<String, Object> defaults) {
        this.properties = properties;
        this.defaults = defaults;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

