/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.centrality.WeightedPageRank$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`WeightedPageRank(dampingFactor:Double = 0.85, iterateSteps:Int = 100, weightProperty = \"weight\")`\n  *  : Compute PageRank for all nodes, treating the network as weighted\n  *\n  * Page Rank algorithm ranks nodes depending on their connections to determine how important\n  * the node is. This assumes a node is more important if it receives more connections from others.\n  * Each vertex begins with an initial state. If it has any neighbours, it sends them a message\n  * which is the inital label / the number of neighbours.\n  * Each vertex, checks its messages and computes a new label based on: the total value of\n  * messages received and the damping factor. This new value is propogated to all outgoing neighbours.\n  * A vertex will stop propogating messages if its value becomes stagnant (i.e. has a change of less\n  * than 0.00001) This process is repeated for a number of iterate step times. Most algorithms should\n  * converge after approx. 20 iterations.\n  *\n  * ## Parameters\n  *\n  *  {s}`dampingFactor: Double = 0.85`\n  *    : Probability that a node will be randomly selected by a user traversing the graph, defaults to 0.85.\n  *\n  *  {s}`iterateSteps: Int = 100`\n  *    : Maximum number of iterations for the algorithm to run.\n  *\n  *  {s}`weightProperty: String = \"weight\"`\n  *    : the property (if any) containing a numerical weight value for each edge, defaults to \"weight\".\n  *\n  *  ```{note}\n  *  If the weight property is not found, weight is treated as the number of edge occurrences.\n  *  ```\n  *\n  * ## States\n  *\n  *  {s}`prlabel: Double`\n  *    : PageRank of the node\n  *\n  * ## Returns\n  *\n  *  | vertex name       | PageRank             |\n  *  | ----------------- | -------------------- |\n  *  | {s}`name: String` | {s}`prlabel: Double` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.centrality.PageRank)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001yA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005<\u0001\t\u0005\t\u0015a\u0003=\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015I\u0006\u0001\"\u0011[\u000f\u0015I8\u0003#\u0001{\r\u0015\u00112\u0003#\u0001|\u0011\u0019\u0001\u0006\u0002\"\u0001\u0002\u0010!1\u0011\f\u0003C\u0001\u0003#A\u0011\"!\u000b\t#\u0003%\t!a\u000b\t\u0013\u0005\u0015\u0003\"%A\u0005\u0002\u0005\u001d\u0003\"CA(\u0011E\u0005I\u0011AA)\u0011%\tI\u0006CI\u0001\n\u0003\tY\u0006C\u0005\u0002`!\t\n\u0011\"\u0001\u0002b!I\u0011Q\r\u0005\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003WB\u0011\u0011!C\u0005\u0003[\u0012\u0001cV3jO\"$X\r\u001a)bO\u0016\u0014\u0016M\\6\u000b\u0005Q)\u0012AC2f]R\u0014\u0018\r\\5us*\u0011acF\u0001\bO\u0016tWM]5d\u0015\tA\u0012$\u0001\u0006bY\u001e|'/\u001b;i[NT!AG\u000e\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001H\u0001\u0004G>l7\u0001A\u000b\u0003?\u001d\u001b\"\u0001\u0001\u0011\u0011\u0005\u0005\u0012S\"A\u000b\n\u0005\r*\"\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\u001b\u0011\fW\u000e]5oO\u001a\u000b7\r^8s!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u00151En\\1u\u00031IG/\u001a:bi\u0016\u001cF/\u001a9t!\t1S&\u0003\u0002/O\t\u0019\u0011J\u001c;\u0002\u001d],\u0017n\u001a5u!J|\u0007/\u001a:usB\u0011\u0011\u0007\u000f\b\u0003eY\u0002\"aM\u0014\u000e\u0003QR!!N\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9t%\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c(\u0003\u001dqW/\\3sS\u000e\u00042!\u0010\"F\u001d\tq\u0004I\u0004\u00024\u007f%\t\u0001&\u0003\u0002BO\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\u001dqU/\\3sS\u000eT!!Q\u0014\u0011\u0005\u0019;E\u0002\u0001\u0003\u0006\u0011\u0002\u0011\r!\u0013\u0002\u0002)F\u0011!*\u0014\t\u0003M-K!\u0001T\u0014\u0003\u000f9{G\u000f[5oOB\u0011aET\u0005\u0003\u001f\u001e\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q!!KV,Y)\t\u0019V\u000bE\u0002U\u0001\u0015k\u0011a\u0005\u0005\u0006w\u0015\u0001\u001d\u0001\u0010\u0005\bI\u0015\u0001\n\u00111\u0001&\u0011\u001dYS\u0001%AA\u00021BqaL\u0003\u0011\u0002\u0003\u0007\u0001'A\u0003baBd\u0017\u0010\u0006\u0002\\;B\u0011A,\u001b\b\u0003\rvCQA\u0018\u0004A\u0002}\u000bQa\u001a:ba\"\u0004\"\u0001Y4\u000e\u0003\u0005T!AY2\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<(B\u00013f\u0003!\tg.\u00197zg&\u001c(B\u00014\u001a\u0003\r\t\u0007/[\u0005\u0003Q\u0006\u0014\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005)<'!B$sCBD\u0007\u0006\u0002\u0001mm^\u0004\"!\u001c;\u000e\u00039T!a\u001c9\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!!\u001d:\u0002\u000fQ\f7.\u001a>pK*\u00111oG\u0001\u0007O&$\b.\u001e2\n\u0005Ut'\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003a\fa\u0012T\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004w+Z5hQR,G\rU1hKJ\u000bgn\u001b\u0015eC6\u0004\u0018N\\4GC\u000e$xN\u001d\u001eE_V\u0014G.\u001a\u0011>AAr\u0003(\u000e\u0017!SR,'/\u0019;f'R,\u0007o\u001d\u001eJ]R\u0004S\bI\u00191a1\u0002s/Z5hQR\u0004&o\u001c9feRL\b%\u0010\u0011#o\u0016Lw\r\u001b;#S\u0001T\u0001\u0005\t\u0016!Ai\u00023i\\7qkR,\u0007\u0005U1hKJ\u000bgn\u001b\u0011g_J\u0004\u0013\r\u001c7!]>$Wm\u001d\u0017!iJ,\u0017\r^5oO\u0002\"\b.\u001a\u0011oKR<xN]6!CN\u0004s/Z5hQR,GM\u0003\u0011!U)\u0001\u0003E\u000b\u0011QC\u001e,\u0007EU1oW\u0002\nGnZ8sSRDW\u000e\t:b].\u001c\bE\\8eKN\u0004C-\u001a9f]\u0012Lgn\u001a\u0011p]\u0002\"\b.Z5sA\r|gN\\3di&|gn\u001d\u0011u_\u0002\"W\r^3s[&tW\r\t5po\u0002JW\u000e]8si\u0006tGO\u0003\u0011!U\u0001\"\b.\u001a\u0011o_\u0012,\u0007%[:/AQC\u0017n\u001d\u0011bgN,X.Z:!C\u0002rw\u000eZ3!SN\u0004Sn\u001c:fA%l\u0007o\u001c:uC:$\b%\u001b4!SR\u0004#/Z2fSZ,7\u000fI7pe\u0016\u00043m\u001c8oK\u000e$\u0018n\u001c8tA\u0019\u0014x.\u001c\u0011pi\",'o\u001d\u0018\u000bA\u0001R\u0003%R1dQ\u00022XM\u001d;fq\u0002\u0012WmZ5og\u0002:\u0018\u000e\u001e5!C:\u0004\u0013N\\5uS\u0006d\u0007e\u001d;bi\u0016t\u0003%\u00134!SR\u0004\u0003.Y:!C:L\bE\\3jO\"\u0014w.\u001e:tY\u0001JG\u000fI:f]\u0012\u001c\b\u0005\u001e5f[\u0002\n\u0007%\\3tg\u0006<WM\u0003\u0011!U\u0001:\b.[2iA%\u001c\b\u0005\u001e5fA%t\u0017\u000e^1mA1\f'-\u001a7!_\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002rW-[4iE>,(o\u001d\u0018\u000bA\u0001R\u0003%R1dQ\u00022XM\u001d;fq2\u00023\r[3dWN\u0004\u0013\u000e^:![\u0016\u001c8/Y4fg\u0002\ng\u000e\u001a\u0011d_6\u0004X\u000f^3tA\u0005\u0004c.Z<!Y\u0006\u0014W\r\u001c\u0011cCN,G\rI8ou\u0001\"\b.\u001a\u0011u_R\fG\u000e\t<bYV,\u0007e\u001c4\u000bA\u0001R\u0003%\\3tg\u0006<Wm\u001d\u0011sK\u000e,\u0017N^3eA\u0005tG\r\t;iK\u0002\"\u0017-\u001c9j]\u001e\u0004c-Y2u_Jt\u0003\u0005\u00165jg\u0002rWm\u001e\u0011wC2,X\rI5tAA\u0014x\u000e]8hCR,G\r\t;pA\u0005dG\u000eI8vi\u001e|\u0017N\\4!]\u0016Lw\r\u001b2pkJ\u001chF\u0003\u0011!U\u0001\n\u0005E^3si\u0016D\be^5mY\u0002\u001aHo\u001c9!aJ|\u0007o\\4bi&tw\rI7fgN\fw-Z:!S\u001a\u0004\u0013\u000e^:!m\u0006dW/\u001a\u0011cK\u000e|W.Z:!gR\fwM\\1oi\u0002B\u0013NL3/A!\f7\u000fI1!G\"\fgnZ3!_\u001a\u0004C.Z:t\u0015\u0001\u0002#\u0006\t;iC:\u0004\u0003G\f\u00191aA\n\u0014\u0006\t+iSN\u0004\u0003O]8dKN\u001c\b%[:!e\u0016\u0004X-\u0019;fI\u00022wN\u001d\u0011bA9,XNY3sA=4\u0007%\u001b;fe\u0006$X\rI:uKB\u0004C/[7fg:\u0002Sj\\:uA\u0005dwm\u001c:ji\"l7\u000fI:i_VdGM\u0003\u0011!U\u0001\u001awN\u001c<fe\u001e,\u0007%\u00194uKJ\u0004\u0013\r\u001d9s_bt\u0003E\r\u0019!SR,'/\u0019;j_:\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00193b[BLgn\u001a$bGR|'O\u000f\u0011E_V\u0014G.\u001a\u0011>AAr\u0003(\u000e1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u0002&o\u001c2bE&d\u0017\u000e^=!i\"\fG\u000fI1!]>$W\rI<jY2\u0004#-\u001a\u0011sC:$w.\u001c7zAM,G.Z2uK\u0012\u0004#-\u001f\u0011bAU\u001cXM\u001d\u0011ue\u00064XM]:j]\u001e\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0017!I\u00164\u0017-\u001e7ug\u0002\"x\u000e\t\u0019/qUr#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004\u0017\u000e^3sCR,7\u000b^3qgj\u0002\u0013J\u001c;!{\u0001\n\u0004\u0007\r1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001j\u0015\r_5nk6\u0004c.^7cKJ\u0004sN\u001a\u0011ji\u0016\u0014\u0018\r^5p]N\u0004cm\u001c:!i\",\u0007%\u00197h_JLG\u000f[7!i>\u0004#/\u001e8/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ao\u0016Lw\r\u001b;Qe>\u0004XM\u001d;zu\u0001\u001aFO]5oO\u0002j\u0004EI<fS\u001eDGO\t1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"\b.\u001a\u0011qe>\u0004XM\u001d;zA!Jg\rI1os&\u00023m\u001c8uC&t\u0017N\\4!C\u0002rW/\\3sS\u000e\fG\u000eI<fS\u001eDG\u000f\t<bYV,\u0007EZ8sA\u0015\f7\r\u001b\u0011fI\u001e,G\u0006\t3fM\u0006,H\u000e^:!i>\u0004#e^3jO\"$(E\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001\u0004\u0007m\u001f8pi\u0016l(\u0002\t\u0011+A\u0001Je\r\t;iK\u0002:X-[4ii\u0002\u0002(o\u001c9feRL\b%[:!]>$\bEZ8v]\u0012d\u0003e^3jO\"$\b%[:!iJ,\u0017\r^3eA\u0005\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007%\u001a3hK\u0002z7mY;se\u0016t7-Z:/\u0015\u0001\u0002#\u0006\t\u0011aA\u0002T\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1qe2\f'-\u001a7;A\u0011{WO\u00197fA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005U1hKJ\u000bgn\u001b\u0011pM\u0002\"\b.\u001a\u0011o_\u0012,'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010\t)bO\u0016\u0014\u0016M\\6!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b\r\u001d:mC\n,GN\u000f\u0011E_V\u0014G.\u001a1!y*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7OL4f]\u0016\u0014\u0018n\u0019\u0018dK:$(/\u00197jift\u0003+Y4f%\u0006t7.\u000b\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001Rs&\u0001\tXK&<\u0007\u000e^3e!\u0006<WMU1oWB\u0011A\u000bC\n\u0004\u0011q|\bC\u0001\u0014~\u0013\tqxE\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\tIwN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003i,B!a\u0005\u0002\u001cQA\u0011QCA\u0012\u0003K\t9\u0003\u0006\u0003\u0002\u0018\u0005u\u0001\u0003\u0002+\u0001\u00033\u00012ARA\u000e\t\u0015A%B1\u0001J\u0011%\tyBCA\u0001\u0002\b\t\t#\u0001\u0006fm&$WM\\2fIE\u0002B!\u0010\"\u0002\u001a!9AE\u0003I\u0001\u0002\u0004)\u0003bB\u0016\u000b!\u0003\u0005\r\u0001\f\u0005\b_)\u0001\n\u00111\u00011\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nT\u0003BA\u0017\u0003\u0007*\"!a\f+\u0007\u0015\n\td\u000b\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C;oG\",7m[3e\u0015\r\tidJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA!\u0003o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015A5B1\u0001J\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T\u0003BA%\u0003\u001b*\"!a\u0013+\u00071\n\t\u0004B\u0003I\u0019\t\u0007\u0011*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t\u0019&a\u0016\u0016\u0005\u0005U#f\u0001\u0019\u00022\u0011)\u0001*\u0004b\u0001\u0013\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*B!!\f\u0002^\u0011)\u0001J\u0004b\u0001\u0013\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*B!!\u0013\u0002d\u0011)\u0001j\u0004b\u0001\u0013\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!a\u0015\u0002j\u0011)\u0001\n\u0005b\u0001\u0013\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA\u0004\u0003\u0011a\u0017M\\4\n\t\u0005e\u00141\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class WeightedPageRank<T>
extends NodeList {
    private final float dampingFactor;
    private final int iterateSteps;
    private final String weightProperty;
    private final Numeric<T> numeric;

    public static <T> String $lessinit$greater$default$3() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> int $lessinit$greater$default$2() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> float $lessinit$greater$default$1() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> String apply$default$3() {
        return WeightedPageRank$.MODULE$.apply$default$3();
    }

    public static <T> int apply$default$2() {
        return WeightedPageRank$.MODULE$.apply$default$2();
    }

    public static <T> float apply$default$1() {
        return WeightedPageRank$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            WeightedPageRank.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            WeightedPageRank.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        }, this.iterateSteps, false);
    }

    public static final /* synthetic */ void $anonfun$apply$1(WeightedPageRank $this, Vertex vertex) {
        float initLabel = 1.0f;
        ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToFloat((float)initLabel));
        double outWeight = $this.numeric.toDouble(vertex.weightedOutDegree($this.numeric));
        vertex.outEdges().foreach((Function1 & Serializable)e -> {
            vertex.messageVertex(e.ID(), BoxesRunTime.boxToDouble((double)($this.numeric.toDouble(e.weight($this.weightProperty, $this.numeric)) / outWeight)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$3(WeightedPageRank $this, Vertex vertex) {
        block0: {
            String vname = vertex.name(vertex.name$default$1());
            float currentLabel = BoxesRunTime.unboxToFloat(((EntityVisitor)((Object)vertex)).getState("prlabel", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            Seq queue = vertex.messageQueue();
            float newLabel = 1.0f - $this.dampingFactor + $this.dampingFactor * BoxesRunTime.unboxToFloat((Object)queue.sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToFloat((float)newLabel));
            double outWeight = $this.numeric.toDouble(vertex.weightedOutDegree($this.weightProperty, $this.numeric));
            vertex.outEdges().foreach((Function1 & Serializable)e -> {
                vertex.messageVertex(e.ID(), BoxesRunTime.boxToDouble((double)((double)newLabel * $this.numeric.toDouble(e.weight($this.weightProperty, $this.numeric)) / outWeight)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
                return BoxedUnit.UNIT;
            });
            if (!((double)(Math.abs(newLabel - currentLabel) / currentLabel) < 1.0E-5)) break block0;
            vertex.voteToHalt();
        }
    }

    public WeightedPageRank(float dampingFactor, int iterateSteps, String weightProperty, Numeric<T> numeric) {
        this.dampingFactor = dampingFactor;
        this.iterateSteps = iterateSteps;
        this.weightProperty = weightProperty;
        this.numeric = numeric;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"prlabel"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

