/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`AverageNeighbourDegree()`\n  *  : Compute the average degree of a vertex's neighbours\n  *\n  *  ```{note}\n  *  This algorithm treats the network as undirected.\n  *  ```\n  *\n  * ## States\n  *\n  *  {s}`avgNeighbourDegree: Double`\n  *    : Average degree of the vertex's neighbours\n  *\n  * ## Returns\n  *\n  *  | vertex name       | average neighbour degree     |\n  *  | ----------------- | ---------------------------- |\n  *  | {s}`name: String` | `avgNeighbourDegree: Double` |\n  */")
public final class AverageNeighbourDegree$
extends NodeList {
    public static final AverageNeighbourDegree$ MODULE$ = new AverageNeighbourDegree$();

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)vertex.degree()), SchemaProviderInstances$.MODULE$.intSchemaProvider());
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            AverageNeighbourDegree$.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AverageNeighbourDegree$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        Seq degrees = vertex.messageQueue();
        ((EntityVisitor)((Object)vertex)).setState("avgNeighbourDegree", vertex.degree() > 0 ? (Number)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToInt((Object)degrees.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (float)vertex.degree())) : (Number)BoxesRunTime.boxToDouble((double)0.0));
    }

    private AverageNeighbourDegree$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"avgNeighbourDegree"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

