/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.Coreness$;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n* {s}`Coreness(1, 6)`\n* : Identify the maximal k for each vertex (the coreness, or k-core number) for which the vertex is in a k-core, here trying values of k from 1 to 6.\n*\n* https://en.wikipedia.org/wiki/Degeneracy_(graph_theory)\n*\n* ## Parameters\n*\n*  {s}`start: Int`\n*    : The value of k to start trying values from (inclusive).\n*\n*  {s}`end: Int`\n*    : The value of k to end at (inclusive).\n*\n* ## States\n*\n* {s}`CORENESS: Int`\n* : Stores the k value of maximum k-core the vertex is in out of the k values that have been tried.\n*\n* ## Returns\n*\n* | vertex name       | coreness           |\n* | ----------------- | ------------------ |\n* | {s}`name: String` | {s}`CORENESS: Int` |\n*\n* ## Implementation\n*\n* The algorithm repeats KCore for start to end values of k, using the resetStates = false flag on KCore so it only runs on the nodes in the previous (as the KCores with k = 3 is a subgraph of the KCores with k = 2 etc).\n* It updates the CORENESS state for all the nodes still alive in that KCore run, so the CORENESS state contains the highest value of k run of which that vertex was in the k-cores.\n*/")
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\b\u0011\u0001eA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!)q\u0006\u0001C\u0001a!9Q\u0007\u0001b\u0001\n\u000b1\u0004BB\u001d\u0001A\u00035q\u0007C\u0003;\u0001\u0011\u00053\bC\u0003J\u0001\u0011\u0005#jB\u0003a!!\u0005\u0011MB\u0003\u0010!!\u0005!\rC\u00030\u0013\u0011\u00051\u000eC\u0003;\u0013\u0011\u0005A\u000eC\u0004p\u0013E\u0005I\u0011\u00019\t\u000fmL\u0011\u0013!C\u0001a\"9A0CA\u0001\n\u0013i(\u0001C\"pe\u0016tWm]:\u000b\u0005E\u0011\u0012aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003'Q\t!\"\u00197h_JLG\u000f[7t\u0015\t)b#\u0001\u0005sCBDGo\u001c:z\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0015\u000e\u0003\tR!a\t\u0013\u0002\u0013\u0005dwm\u001c:ji\"l'BA\u0013'\u0003!\tg.\u00197zg&\u001c(BA\u0014\u0015\u0003\r\t\u0007/[\u0005\u0003S\t\u0012qaR3oKJL7-A\u0003ti\u0006\u0014H\u000f\u0005\u0002\u001cY%\u0011Q\u0006\b\u0002\u0004\u0013:$\u0018aA3oI\u00061A(\u001b8jiz\"2!M\u001a5!\t\u0011\u0004!D\u0001\u0011\u0011\u0015Q3\u00011\u0001,\u0011\u0015q3\u00011\u0001,\u0003!\u0019uJU#O\u000bN\u001bV#A\u001c\u0010\u0003a\n\u0013!N\u0001\n\u0007>\u0013VIT#T'\u0002\nQ!\u00199qYf$\"\u0001P \u0011\u0005u:eB\u0001 @\u0019\u0001AQ\u0001\u0011\u0004A\u0002\u0005\u000bQa\u001a:ba\"\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0013\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018B\u0001$D\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002I\u000b\n)qI]1qQ\u0006QA/\u00192vY\u0006\u0014\u0018n]3\u0015\u0005-\u000b\u0006C\u0001'P\u001b\u0005i%B\u0001(%\u0003\u0015!\u0018M\u00197f\u0013\t\u0001VJA\u0003UC\ndW\rC\u0003A\u000f\u0001\u0007\u0011\t\u000b\u0003\u0001'vs\u0006C\u0001+\\\u001b\u0005)&B\u0001,X\u0003!\u00198-\u00197bI>\u001c'B\u0001-Z\u0003\u001d!\u0018m[3{_\u0016T!A\u0017\f\u0002\r\u001dLG\u000f[;c\u0013\taVK\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005y\u0016\u0001c/0U)R!\u0006I>t{\u0002\u001cuN]3oKN\u001c\b&\r\u0017!m%\u0002'B\u000b\u0011;A%#WM\u001c;jMf\u0004C\u000f[3![\u0006D\u0018.\\1mA-\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010\t\u0015uQ\u0016\u00043m\u001c:f]\u0016\u001c8\u000f\f\u0011pe\u0002ZWfY8sK\u0002rW/\u001c2fe&\u0002cm\u001c:!o\"L7\r\u001b\u0011uQ\u0016\u0004c/\u001a:uKb\u0004\u0013n\u001d\u0011j]\u0002\n\u0007e[\u0017d_J,G\u0006\t5fe\u0016\u0004CO]=j]\u001e\u0004c/\u00197vKN\u0004sN\u001a\u0011lA\u0019\u0014x.\u001c\u00112AQ|\u0007E\u000e\u0018\u000bU)Q\u0003\u0005\u001b;uaNTtfL3o]]L7.\u001b9fI&\fgf\u001c:h_]L7.[\u0018EK\u001e,g.\u001a:bGf|\u0006f\u001a:ba\"|F\u000f[3pefL#B\u000b\u0006+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015)R!\u0006\t\u0011|gv\u00047\u000f^1sij\u0002\u0013J\u001c;a\u0015)\u0002\u0003\u0005\t\u0011;AQCW\r\t<bYV,\u0007e\u001c4!W\u0002\"x\u000eI:uCJ$\b\u0005\u001e:zS:<\u0007E^1mk\u0016\u001c\bE\u001a:p[\u0002B\u0013N\\2mkNLg/Z\u0015/\u0015)R!\u0006\t\u0011|gv\u0004WM\u001c3;A%sG\u000f\u0019\u0006+A\u0001\u0002\u0003E\u000f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\rI6!i>\u0004SM\u001c3!CR\u0004\u0003&\u001b8dYV\u001c\u0018N^3*])Q#B\u000b\u0011$G\u0001\u001aF/\u0019;fg*Q#B\u000b\u0011|gv\u00047i\u0014*F\u001d\u0016\u001b6K\u000f\u0011J]R\u0004'B\u000b\u0011;AM#xN]3tAQDW\rI6!m\u0006dW/\u001a\u0011pM\u0002j\u0017\r_5nk6\u00043.L2pe\u0016\u0004C\u000f[3!m\u0016\u0014H/\u001a=!SN\u0004\u0013N\u001c\u0011pkR\u0004sN\u001a\u0011uQ\u0016\u00043\u000e\t<bYV,7\u000f\t;iCR\u0004\u0003.\u0019<fA\t,WM\u001c\u0011ue&,GM\f\u0006+\u0015)\u00023e\t\u0011SKR,(O\\:\u000bU)Q\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010I2pe\u0016tWm]:!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002CP\u0003\u0016!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015)\u0002C\u0010I>t{\u0002t\u0017-\\3;AM#(/\u001b8hA\u0002b\be_:~A\u000e{%+\u0012(F'NS\u0004%\u00138uA\u0002b(B\u000b\u0006+A\r\u001a\u0003%S7qY\u0016lWM\u001c;bi&|gN\u0003\u0016\u000bU\u0001\"\u0006.\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u0012X\r]3biN\u00043jQ8sK\u00022wN\u001d\u0011ti\u0006\u0014H\u000f\t;pA\u0015tG\r\t<bYV,7\u000fI8gA-d\u0003%^:j]\u001e\u0004C\u000f[3!e\u0016\u001cX\r^*uCR,7\u000fI\u001f!M\u0006d7/\u001a\u0011gY\u0006<\u0007e\u001c8!\u0017\u000e{'/\u001a\u0011t_\u0002JG\u000fI8oYf\u0004#/\u001e8tA=t\u0007\u0005\u001e5fA9|G-Z:!S:\u0004C\u000f[3!aJ,g/[8vg\u0002B\u0013m\u001d\u0011uQ\u0016\u00043jQ8sKN\u0004s/\u001b;iA-\u0004S\bI\u001a!SN\u0004\u0013\rI:vE\u001e\u0014\u0018\r\u001d5!_\u001a\u0004C\u000f[3!\u0017\u000e{'/Z:!o&$\b\u000eI6!{\u0001\u0012\u0004%\u001a;dS9R!\u0006I%uAU\u0004H-\u0019;fg\u0002\"\b.\u001a\u0011D\u001fJ+e*R*TAM$\u0018\r^3!M>\u0014\b%\u00197mAQDW\r\t8pI\u0016\u001c\be\u001d;jY2\u0004\u0013\r\\5wK\u0002Jg\u000e\t;iCR\u00043jQ8sK\u0002\u0012XO\u001c\u0017!g>\u0004C\u000f[3!\u0007>\u0013VIT#T'\u0002\u001aH/\u0019;fA\r|g\u000e^1j]N\u0004C\u000f[3!Q&<\u0007.Z:uAY\fG.^3!_\u001a\u00043\u000e\t:v]\u0002zg\rI<iS\u000eD\u0007\u0005\u001e5bi\u00022XM\u001d;fq\u0002:\u0018m\u001d\u0011j]\u0002\"\b.\u001a\u0011l[\r|'/Z:/\u0015)z\u0013\u0001C\"pe\u0016tWm]:\u0011\u0005IJ1cA\u0005\u001bGB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0003S>T\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\na1+\u001a:jC2L'0\u00192mKR\t\u0011\rF\u00022[:DqAK\u0006\u0011\u0002\u0003\u00071\u0006C\u0004/\u0017A\u0005\t\u0019A\u0016\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*\u0012!\u001d\u0016\u0003WI\\\u0013a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005ad\u0012AC1o]>$\u0018\r^5p]&\u0011!0\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u001d\fA\u0001\\1oO&!\u0011qAA\u0001\u0005\u0019y%M[3di\u0002")
public class Coreness
implements Generic {
    private final int start;
    private final int end;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static int apply$default$2() {
        return Coreness$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return Coreness$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public final String CORENESS() {
        return "CORENESS";
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ObjectRef g = ObjectRef.create((Object)graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Coreness.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.start), this.end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            g$1.elem = KCore$.MODULE$.apply(k, false).apply((ConcreteGraphPerspective)g$1.elem).step((Function1 & Serializable)vertex -> {
                Coreness.$anonfun$apply$3(k, vertex);
                return BoxedUnit.UNIT;
            });
        });
        return (ConcreteGraphPerspective)g.elem;
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(), ((EntityVisitor)((Object)vertex)).getStateOrElse("CORENESS", BoxesRunTime.boxToInteger((int)-1), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3())})));
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("CORENESS", BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ void $anonfun$apply$3(int k$1, Vertex vertex) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("effectiveDegree", ((EntityVisitor)((Object)vertex)).getState$default$2())) < k$1) break block0;
            ((EntityVisitor)((Object)vertex)).setState("CORENESS", BoxesRunTime.boxToInteger((int)k$1));
        }
    }

    public Coreness(int start, int end) {
        this.start = start;
        this.end = end;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
        if (start > end | start < 0) {
            throw new IllegalArgumentException(new StringBuilder(90).append("start and end parameters must be non-negative and start <= end. You inputted start=").append(start).append(", end=").append(end).append(".").toString());
        }
    }
}

