# tracktrace

tracktrace allows you to track shipping containers across all major shipping lines as well as [Class 1 North American railways](https://en.wikipedia.org/wiki/Railroad_classes#Class_I).

Major steamship lines all have container tracking on their websites and/or apps.

### Ocean


| Steamship Line   |SCAC | Supported     | Container Tracking Website | iOS App | Android App |
| -------------    | :---------: | :-------------: | :---------------: | :----: | :---------: |
| Alianca          | ANRM | :heavy_check_mark: | [Link](https://www.alianca.com.br/alianca/en/alianca/ecommerce_alianca/track_trace_alianca/index.html)  | No | No |
| APL              | APLU | :heavy_check_mark: | [Link](https://www.apl.com/ebusiness/tracking)  | [Yes](https://apps.apple.com/us/app/apl-shipping/id1316352566?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.apl.mobile)
| Arkas Container Transport |ARKU | :white_check_mark: | [Link](https://webtracking.arkasline.com.tr/shipmenttracking) | No | No |
| CMA CGM          | CMDU | :heavy_check_mark: | [Link](https://www.cma-cgm.com/ebusiness/tracking)  | [Yes](https://apps.apple.com/us/app/cma-cgm/id976582997?ign-mpt=uo%3D4) | No | 
| Cosco            | COSU | :white_check_mark: | [Link](https://elines.coscoshipping.com/ebusiness/cargoTracking)  | [Yes](https://apps.apple.com/us/app/cosco-shipping-lines/id998446230?ign-mpt=uo%3D4) | No |
| Emirates Shipping Line | ESPU |:white_check_mark: | [Link](https://www.emiratesline.com/cargo-tracking/) | [Yes](https://apps.apple.com/us/app/esl-mobile/id1106834658?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.emiratesline.android) |
| Evergreen        | EGLV |:white_check_mark: | [Link](https://www.shipmentlink.com/servlet/TDB1_CargoTracking.do)  | No | [Yes](https://play.google.com/store/apps/details?id=com.shipmentlink.mobile) |
| Hamburg SUD      | SUDU | :heavy_check_mark: | [Link](https://www.hamburgsud-line.com/liner/en/liner_services/ecommerce/track_trace/index.html) | No | No |
| Hapag Lloyd      | HLCU | :heavy_check_mark: | [Link](https://www.hapag-lloyd.com/en/online-business/tracing/tracing-by-container.html)  | [Yes](https://apps.apple.com/us/app/hapag-lloyd/id935668102?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.hlag.fit) |
| Hyundai Merchant Marine (HMM) |HDMU | :white_check_mark:| [Link](https://www.hmm21.com/cms/business/ebiz/trackTrace/trackTrace/index.jsp) | [Yes](https://apps.apple.com/us/app/hmm-shiptrack/id590402800?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.hmm.mobileapp) |
| Maersk           | MAEU |:white_check_mark:| [Link](https://www.maersk.com/tracking/)  | [Yes](https://apps.apple.com/us/app/maersk-shipment/id1163233195?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.maersk.trackandtrace.maerskline) | 
| Matson           | MATS   |:white_check_mark:| [Link](https://www.matson.com/shipment-tracking.html) | [Yes](https://apps.apple.com/us/app/track-my-container/id1299640687?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.matson.containertrack) | 
| Mediterranean Shipping Company (MSC) |MSCU |:heavy_check_mark:| [Link](https://www.msc.com/track-a-shipment?agencyPath=mwi) | [Yes](https://apps.apple.com/us/app/mymsc/id1454791941?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.MSC.myMSCApp) |
| ONE Line         | ONEY |:heavy_check_mark:| [Link](https://ecomm.one-line.com/ecom/CUP_HOM_3301.do)  | No | No |
| Orient Overseas Container Line (OOCL) | OOLU |:white_check_mark:| [Link](https://www.oocl.com/eng/ourservices/eservices/cargotracking/Pages/cargotracking.aspx) | [Yes](https://apps.apple.com/us/app/oocl-lite/id420862192?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.oocl.oocllite)
| Pacific International Lines (PIL) | PCIU |:white_check_mark:| [Link](https://www.pilship.com/en--/120.html)| No | No | 
| Wan Hai Lines | WHLC |:white_check_mark:| [Link](https://www.wanhai.com/views/cargoTrack/CargoTrack.xhtml) | [Yes](https://apps.apple.com/us/app/%E8%90%AC%E6%B5%B7%E8%88%AA%E9%81%8B-wan-hai-lines-ltd/id858445572?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.sdt.wanhai) |
| Yang Ming        |YMLU |:white_check_mark:| [Link](https://www.yangming.com/e-service/Track_Trace/track_trace_cargo_tracking.aspx) | [Yes](https://apps.apple.com/us/app/yang-ming/id573468171?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=tw.com.mobimedia.yangming) |
| Zim Integrated Shipping Services (ZIM) |ZIMU |:white_check_mark:| [Link](https://www.zim.com/tools/track-a-shipment)| [Yes](https://apps.apple.com/us/app/zim-shipping/id1084970104?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.zim) |


### Rail

Railroads often require an account to track containers. At certain railroads, you also need to be a Notify Party to access tracking information. 

For example, BNSF doesn't show any tracking information if your company is not a Notify Party. UP, on the other hand, shows partial tracking information. 


[//]: #| Railroad | Supported | Need Account | Need to be a Notify Party |
[//]: #| ---- | :--: | :-------: | :---------: | 
[//]: #| BNSF Railway (BNSF) | :white_check_mark:| Yes | Yes |
[//]: #| Canadian National Railway (CN) | :white_check_mark: | Yes | Don't know | 
[//]: #| Canadian Pacific Railway (CPR) | :white_check_mark:| Yes | Don't know |
[//]: #| CSX Transportation (CSX) | :heavy_check_mark: | No | No | 
[//]: #| Ferromex | :white_check_mark: | Yes | Don't know | 
[//]: #| Kansas City Southern Railway (KCS)| :white_check_mark: | Yes | Don't know | 
[//]: #| Norfolk Southern Railway (NS) | :heavy_check_mark: | Yes | No |
[//]: #| Union Pacific Railway (UP) | :white_check_mark: | Yes | No | 



## Installation


```sh
pip install tracktrace 
```

## Usage example


```python
>>> from tracktrace import ocean
>>>
>>> container = "MEDU3288655"
>>> scac = "MSCU"
>>> 
>>> shipment = ocean.container.create(scac=scac, container=container)
>>>
>>> shipment.updates

[{'location': 'USSTL',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Empty container returned',
  'mode': 'TR',
  'date': DateTime(2020, 12, 11, 15, 44, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USESL',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Rail last free day',
  'mode': '',
  'date': DateTime(2020, 12, 8, 23, 59, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USSTL',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Full import container out gated',
  'mode': 'TR',
  'date': DateTime(2020, 12, 8, 19, 27, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USESL',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Notified',
  'mode': '',
  'date': DateTime(2020, 12, 5, 0, 39, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USSTL',
  'vessel': 'RAIL_CARRIER',
  'voyage': '',
  'movement': 'Rail arrived',
  'mode': '',
  'date': DateTime(2020, 12, 5, 0, 36, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USESL',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Unloaded from rail',
  'mode': '',
  'date': DateTime(2020, 12, 5, 0, 33, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USESL',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Rail arrived',
  'mode': '',
  'date': DateTime(2020, 12, 4, 15, 14, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USVAO',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Departed from in transit location',
  'mode': '',
  'date': DateTime(2020, 12, 4, 11, 32, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USVAO',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Arrived at in-transit location',
  'mode': '',
  'date': DateTime(2020, 12, 4, 10, 28, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USEZA',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Rail departed',
  'mode': '',
  'date': DateTime(2020, 12, 2, 23, 59, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': 'RAIL_CARRIER',
  'voyage': '',
  'movement': 'Rail departed',
  'mode': '',
  'date': DateTime(2020, 12, 2, 23, 59, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USEZA',
  'vessel': 'CSX TRANSPORTATION',
  'voyage': '',
  'movement': 'Loaded on rail',
  'mode': '',
  'date': DateTime(2020, 12, 2, 20, 52, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Full import container in gated',
  'mode': 'TR',
  'date': DateTime(2020, 11, 13, 18, 24, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Full import container out gated',
  'mode': 'TR',
  'date': DateTime(2020, 11, 13, 18, 15, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': 'NORTHERN MAJESTIC',
  'voyage': '41N',
  'movement': 'Discharged from vessel',
  'mode': 'VE',
  'date': DateTime(2020, 11, 3, 8, 31, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': '',
  'voyage': '',
  'movement': 'Vessel arrived',
  'mode': '',
  'date': DateTime(2020, 11, 3, 3, 45, 0, tzinfo=Timezone('UTC'))},
 {'location': 'USNYC',
  'vessel': '',
  'voyage': '',
  'movement': 'In-bond movement authorized ',
  'mode': '',
  'date': DateTime(2020, 10, 29, 8, 25, 0, tzinfo=Timezone('UTC'))},
 {'location': 'BRPEC',
  'vessel': '',
  'voyage': '',
  'movement': 'Vessel departed',
  'mode': '',
  'date': DateTime(2020, 10, 26, 1, 7, 0, tzinfo=Timezone('UTC'))},
 {'location': 'BRPEC',
  'vessel': 'NORTHERN MAJESTIC',
  'voyage': '41N',
  'movement': 'Loaded on vessel',
  'mode': 'VE',
  'date': DateTime(2020, 10, 25, 17, 43, 0, tzinfo=Timezone('UTC'))},
 {'location': '',
  'vessel': '',
  'voyage': '',
  'movement': 'VGM received',
  'mode': '',
  'date': DateTime(2020, 10, 20, 21, 24, 0, tzinfo=Timezone('UTC'))},
 {'location': 'BRPEC',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Full export container in gated',
  'mode': 'TR',
  'date': DateTime(2020, 10, 20, 18, 54, 0, tzinfo=Timezone('UTC'))},
 {'location': 'BRFOR',
  'vessel': 'TRUCK',
  'voyage': '',
  'movement': 'Empty out for booking',
  'mode': 'TR',
  'date': DateTime(2020, 10, 19, 9, 37, 0, tzinfo=Timezone('UTC'))}]

```


## Release History

* 0.0.1
    * Work in progress

## Meta

Dhruv Kar – [dhruvkar](https://twitter.com/dhruvkar) – dhruv@wints.org

Distributed under the MIT license. See ``LICENSE`` for more information.

[https://github.com/dhruvkar/](https://github.com/dhruvkar/)

## Contributing

1. Fork it (<https://github.com/dhruvkar/tracktrace/fork>)
2. Create your feature branch (`git checkout -b feature/fooBar`)
3. Commit your changes (`git commit -am 'Add some fooBar'`)
4. Push to the branch (`git push origin feature/fooBar`)
5. Create a new Pull Request

