# Generated manually - Add org-level user references and update creator fields

import django.db.models.deletion
from django.db import migrations, models


def migrate_created_by_to_user(apps, schema_editor):
    """Copy created_by to created_by_user for backward compatibility."""
    Automation = apps.get_model('constec_db', 'Automation')
    NotificationTemplate = apps.get_model('constec_db', 'NotificationTemplate')
    
    for automation in Automation.objects.filter(created_by__isnull=False):
        automation.created_by_user = automation.created_by
        automation.save(update_fields=['created_by_user'])
    
    for template in NotificationTemplate.objects.filter(created_by__isnull=False):
        template.created_by_user = template.created_by
        template.save(update_fields=['created_by_user'])


def reverse_migrate_created_by(apps, schema_editor):
    """Copy created_by_user back to created_by."""
    Automation = apps.get_model('constec_db', 'Automation')
    NotificationTemplate = apps.get_model('constec_db', 'NotificationTemplate')
    
    for automation in Automation.objects.filter(created_by_user__isnull=False):
        automation.created_by = automation.created_by_user
        automation.save(update_fields=['created_by'])
    
    for template in NotificationTemplate.objects.filter(created_by_user__isnull=False):
        template.created_by = template.created_by_user
        template.save(update_fields=['created_by'])


class Migration(migrations.Migration):

    dependencies = [
        ('constec_db', '0010_rename_webhook_to_http_request'),
    ]

    operations = [
        # Add new creator fields
        migrations.AddField(
            model_name='automation',
            name='created_by_user',
            field=models.ForeignKey(
                blank=True,
                help_text='User creator (company-level)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='created_automations',
                to='constec_db.companyuser'
            ),
        ),
        migrations.AddField(
            model_name='automation',
            name='created_by_org_user',
            field=models.ForeignKey(
                blank=True,
                help_text='OrganizationUser creator (org-level)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='created_automations',
                to='constec_db.organizationuser'
            ),
        ),
        migrations.AddField(
            model_name='notificationtemplate',
            name='created_by_user',
            field=models.ForeignKey(
                blank=True,
                help_text='User creator (company-level)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='created_notification_templates',
                to='constec_db.companyuser'
            ),
        ),
        migrations.AddField(
            model_name='notificationtemplate',
            name='created_by_org_user',
            field=models.ForeignKey(
                blank=True,
                help_text='OrganizationUser creator (org-level)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='created_notification_templates_org',
                to='constec_db.organizationuser'
            ),
        ),
        # Add organization field if not present
        migrations.AddField(
            model_name='automation',
            name='organization',
            field=models.ForeignKey(
                blank=True,
                help_text='Organization para automations compartidas (opcional si se define company)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='constec_db.organization'
            ),
        ),
        migrations.AddField(
            model_name='notificationtemplate',
            name='organization',
            field=models.ForeignKey(
                blank=True,
                help_text='Organization para templates compartidos (opcional si se define company)',
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='constec_db.organization'
            ),
        ),
        migrations.AddField(
            model_name='executionlog',
            name='triggered_by_org_user',
            field=models.ForeignKey(
                blank=True,
                help_text='OrganizationUser who triggered execution (org-level)',
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='triggered_executions',
                to='constec_db.organizationuser'
            ),
        ),
        # Migrate data
        migrations.RunPython(migrate_created_by_to_user, reverse_migrate_created_by),
        
        # Add indexes
        migrations.AddIndex(
            model_name='automation',
            index=models.Index(fields=['organization', 'status'], name='automations_organiz_cf01b6_idx'),
        ),
        migrations.AddIndex(
            model_name='notificationtemplate',
            index=models.Index(fields=['organization', 'channel', 'is_active'], name='notificatio_organiz_90d7b8_idx'),
        ),
    ]
