"""Rename action_type 'webhook' to 'http_request'."""

from django.db import migrations


def rename_webhook_to_http_request(apps, schema_editor):
    """Rename existing 'webhook' action_type to 'http_request'."""
    Action = apps.get_model('constec_db', 'Action')
    Action.objects.filter(action_type='webhook').update(action_type='http_request')


def rename_http_request_to_webhook(apps, schema_editor):
    """Reverse migration: rename 'http_request' back to 'webhook'."""
    Action = apps.get_model('constec_db', 'Action')
    Action.objects.filter(action_type='http_request').update(action_type='webhook')


class Migration(migrations.Migration):

    dependencies = [
        ('constec_db', '0009_fix_action_nullable_fields'),
    ]

    operations = [
        migrations.RunPython(
            rename_webhook_to_http_request,
            reverse_code=rename_http_request_to_webhook,
        ),
    ]
