# Generated manually on 2026-02-03 for automations redesign (Fase 1)

import uuid
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('constec_db', '0004_rename_entities_company_cuit_idx_entities_company_e2c50f_idx_and_more'),
    ]

    operations = [
        # Create Automation model
        migrations.CreateModel(
            name='Automation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('status', models.CharField(
                    choices=[('active', 'Active'), ('paused', 'Paused'), ('archived', 'Archived'), ('draft', 'Draft')],
                    default='draft',
                    max_length=20
                )),
                ('execution_mode', models.CharField(
                    choices=[('sequential', 'Sequential'), ('parallel', 'Parallel')],
                    default='sequential',
                    max_length=20
                )),
                ('max_executions', models.IntegerField(
                    blank=True,
                    help_text='Máximo número de ejecuciones (null = ilimitado)',
                    null=True
                )),
                ('execution_count', models.IntegerField(default=0)),
                ('on_error', models.CharField(
                    choices=[('stop', 'Stop'), ('continue', 'Continue'), ('retry', 'Retry')],
                    default='stop',
                    max_length=20
                )),
                ('retry_count', models.IntegerField(default=3)),
                ('retry_delay_seconds', models.IntegerField(default=60)),
                ('last_executed_at', models.DateTimeField(blank=True, null=True)),
                ('next_execution_at', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('tags', models.JSONField(blank=True, default=list)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='constec_db.company')),
                ('created_by', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='created_automations',
                    to=settings.AUTH_USER_MODEL
                )),
            ],
            options={
                'db_table': '"automations"."automations"',
                'ordering': ['-created_at'],
                'indexes': [
                    models.Index(fields=['company', 'status'], name='automations_auto_company_status_idx'),
                    models.Index(fields=['status', 'next_execution_at'], name='automations_auto_status_next_idx'),
                ],
            },
            bases=(models.Model,),
        ),

        # Create Trigger model
        migrations.CreateModel(
            name='Trigger',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('trigger_type', models.CharField(
                    choices=[('schedule', 'Schedule'), ('webhook', 'Webhook'), ('manual', 'Manual'), ('event', 'Event')],
                    max_length=20
                )),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('is_enabled', models.BooleanField(default=True)),
                ('config', models.JSONField(
                    default=dict,
                    help_text='Configuración específica del tipo de trigger (schedule, webhook, etc.)'
                )),
                ('last_triggered_at', models.DateTimeField(blank=True, null=True)),
                ('trigger_count', models.IntegerField(default=0)),
                ('priority', models.IntegerField(default=50, help_text='0-100, mayor = más prioridad')),
                ('automation', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='triggers',
                    to='constec_db.automation'
                )),
            ],
            options={
                'db_table': '"automations"."triggers"',
                'ordering': ['-priority', 'created_at'],
                'indexes': [
                    models.Index(fields=['automation', 'is_enabled'], name='automations_trig_automation_enabled_idx'),
                    models.Index(fields=['trigger_type', 'is_enabled'], name='automations_trig_type_enabled_idx'),
                ],
            },
            bases=(models.Model,),
        ),

        # Create Action model
        migrations.CreateModel(
            name='Action',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('action_type', models.CharField(
                    choices=[('notification', 'Notification'), ('webhook', 'Webhook'), ('batch_task', 'Batch Task'), ('flow_execution', 'Flow Execution')],
                    max_length=20
                )),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('is_enabled', models.BooleanField(default=True)),
                ('order', models.IntegerField(default=0, help_text='Orden de ejecución')),
                ('config', models.JSONField(
                    default=dict,
                    help_text='Configuración específica del tipo de acción'
                )),
                ('on_error', models.CharField(
                    blank=True,
                    choices=[('stop', 'Stop'), ('continue', 'Continue'), ('retry', 'Retry')],
                    help_text='Override del on_error de la automation',
                    max_length=20,
                    null=True
                )),
                ('retry_count', models.IntegerField(
                    blank=True,
                    help_text='Override del retry_count de la automation',
                    null=True
                )),
                ('condition', models.JSONField(
                    blank=True,
                    help_text='Condición JSONLogic para ejecutar esta acción',
                    null=True
                )),
                ('last_executed_at', models.DateTimeField(blank=True, null=True)),
                ('execution_count', models.IntegerField(default=0)),
                ('success_count', models.IntegerField(default=0)),
                ('failure_count', models.IntegerField(default=0)),
                ('automation', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='actions',
                    to='constec_db.automation'
                )),
            ],
            options={
                'db_table': '"automations"."actions"',
                'ordering': ['order', 'created_at'],
                'indexes': [
                    models.Index(fields=['automation', 'order'], name='automations_act_automation_order_idx'),
                    models.Index(fields=['action_type', 'is_enabled'], name='automations_act_type_enabled_idx'),
                ],
            },
            bases=(models.Model,),
        ),

        # Create ExecutionLog model
        migrations.CreateModel(
            name='ExecutionLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(
                    choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('partial', 'Partial')],
                    default='pending',
                    max_length=20
                )),
                ('triggered_by', models.CharField(
                    choices=[('schedule', 'Schedule'), ('webhook', 'Webhook'), ('manual', 'Manual'), ('system', 'System')],
                    max_length=20
                )),
                ('started_at', models.DateTimeField(auto_now_add=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('duration_seconds', models.IntegerField(blank=True, null=True)),
                ('execution_context', models.JSONField(
                    default=dict,
                    help_text='Variables y contexto disponible durante la ejecución'
                )),
                ('actions_total', models.IntegerField(default=0)),
                ('actions_succeeded', models.IntegerField(default=0)),
                ('actions_failed', models.IntegerField(default=0)),
                ('actions_skipped', models.IntegerField(default=0)),
                ('action_logs', models.JSONField(
                    default=list,
                    help_text='Array de logs detallados de cada acción ejecutada'
                )),
                ('error_message', models.TextField(blank=True)),
                ('error_traceback', models.TextField(blank=True)),
                ('automation', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='execution_logs',
                    to='constec_db.automation'
                )),
                ('trigger', models.ForeignKey(
                    blank=True,
                    null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='execution_logs',
                    to='constec_db.trigger'
                )),
                ('triggered_by_user', models.ForeignKey(
                    blank=True,
                    null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='triggered_executions',
                    to=settings.AUTH_USER_MODEL
                )),
            ],
            options={
                'db_table': '"automations"."execution_logs"',
                'ordering': ['-started_at'],
                'indexes': [
                    models.Index(fields=['automation', 'started_at'], name='automations_exec_automation_started_idx'),
                    models.Index(fields=['status', 'started_at'], name='automations_exec_status_started_idx'),
                    models.Index(fields=['triggered_by', 'started_at'], name='automations_exec_triggered_started_idx'),
                ],
            },
            bases=(models.Model,),
        ),

        # Create NotificationTemplate model
        migrations.CreateModel(
            name='NotificationTemplate',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('channel', models.CharField(
                    choices=[('email', 'Email'), ('whatsapp', 'WhatsApp'), ('sms', 'SMS'), ('push', 'Push Notification')],
                    max_length=20
                )),
                ('subject', models.CharField(
                    blank=True,
                    help_text='Asunto (solo para email)',
                    max_length=255
                )),
                ('body', models.TextField(help_text='Cuerpo del mensaje con variables {{variable}}')),
                ('variables', models.JSONField(
                    default=list,
                    help_text="Array de nombres de variables esperadas ['customer_name', 'amount']"
                )),
                # is_active inherited from UUIDModel
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='constec_db.company')),
                ('created_by', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='created_templates',
                    to=settings.AUTH_USER_MODEL
                )),
            ],
            options={
                'db_table': '"automations"."notification_templates"',
                'ordering': ['name'],
                'indexes': [
                    models.Index(fields=['company', 'channel', 'is_active'], name='automations_tmpl_company_channel_idx'),
                ],
            },
            bases=(models.Model,),
        ),
    ]
