# Generated by Django 6.0.1 on 2026-01-26 20:41

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ContactType',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'core"."contact_types',
            },
        ),
        migrations.CreateModel(
            name='Entity',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('external_id', models.CharField(help_text='Entity ID in external ERP system (e.g., cli_Cod, pro_Cod)', max_length=255)),
                ('cuit', models.CharField(blank=True, default='', help_text='CUIT without dashes (for authentication lookup)', max_length=13)),
                ('metadata', models.JSONField(blank=True, default=dict)),
            ],
            options={
                'db_table': 'erp"."entities',
                'verbose_name_plural': 'Entities',
            },
        ),
        migrations.CreateModel(
            name='FlowTemplate',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('category', models.CharField(choices=[('finance', 'Finance & Accounting'), ('customer_service', 'Customer Service'), ('sales', 'Sales & CRM'), ('general', 'General Purpose'), ('custom', 'Custom')], max_length=50)),
                ('graph_definition', models.JSONField(help_text='Graph structure in JSON format with nodes and edges')),
                ('default_config', models.JSONField(default=dict, help_text='Default configuration for this template (LLM, tools, prompts)')),
                ('is_global', models.BooleanField(default=False, help_text='If true, all organizations can use this template')),
                ('is_active', models.BooleanField(default=True)),
                ('version', models.CharField(default='1.0.0', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'constancia"."flow_templates',
            },
        ),
        migrations.CreateModel(
            name='Module',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(max_length=100, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('version', models.CharField(max_length=20)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'core"."modules',
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'core"."organizations',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'erp"."roles',
            },
        ),
        migrations.CreateModel(
            name='System',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('api_endpoint', models.URLField(blank=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'erp"."systems',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('legal_name', models.CharField(max_length=255)),
                ('slug', models.SlugField(max_length=100, unique=True)),
                ('website', models.URLField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('parent_company', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='constec_db.company')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='companies', to='constec_db.organization')),
            ],
            options={
                'db_table': 'core"."companies',
                'verbose_name_plural': 'Companies',
            },
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('label', models.CharField(blank=True, help_text="Optional label (e.g. 'Personal', 'Work')", max_length=100)),
                ('value', models.CharField(max_length=255)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='constec_db.contacttype')),
            ],
            options={
                'db_table': 'core"."contacts',
            },
        ),
        migrations.CreateModel(
            name='EntityAuth',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('password_hash', models.CharField(help_text='Bcrypt hashed password', max_length=255)),
                ('is_active', models.BooleanField(default=True, help_text='Whether this account can authenticate')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('last_login', models.DateTimeField(blank=True, help_text='Last successful login timestamp', null=True)),
                ('entity', models.OneToOneField(help_text='The ERP entity these credentials belong to', on_delete=django.db.models.deletion.CASCADE, related_name='auth', to='constec_db.entity')),
            ],
            options={
                'verbose_name': 'Entity Authentication',
                'verbose_name_plural': 'Entity Authentications',
                'db_table': 'erp"."entity_auth',
            },
        ),
        migrations.CreateModel(
            name='Flow',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField(blank=True, null=True)),
                ('graph_definition', models.JSONField(blank=True, help_text='Custom graph structure (only if not using template)', null=True)),
                ('config', models.JSONField(default=dict, help_text='Configuration that merges with template.default_config')),
                ('is_active', models.BooleanField(default=True)),
                ('is_default', models.BooleanField(default=False, help_text='Whether this is the default flow for the company')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flows', to='constec_db.company')),
                ('template', models.ForeignKey(blank=True, help_text="If set, uses template's graph. config overrides template defaults.", null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='flows', to='constec_db.flowtemplate')),
            ],
            options={
                'db_table': 'constancia"."flows',
            },
        ),
        migrations.CreateModel(
            name='CompanyModule',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_enabled', models.BooleanField(default=True)),
                ('settings', models.JSONField(blank=True, default=dict)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company_modules', to='constec_db.company')),
                ('module', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company_modules', to='constec_db.module')),
            ],
            options={
                'db_table': 'core"."company_modules',
            },
        ),
        migrations.AddField(
            model_name='flowtemplate',
            name='organization',
            field=models.ForeignKey(blank=True, help_text='Organization that owns this template (null for global)', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='flow_templates', to='constec_db.organization'),
        ),
        migrations.CreateModel(
            name='OrganizationRole',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField(blank=True, null=True)),
                ('permissions', models.JSONField(default=dict)),
                ('is_system_role', models.BooleanField(default=False)),
                ('organization', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='organization_roles', to='constec_db.organization')),
            ],
            options={
                'db_table': 'core"."organization_roles',
            },
        ),
        migrations.CreateModel(
            name='OrganizationUser',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('password_hash', models.CharField(max_length=255)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='users', to='constec_db.organization')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='constec_db.organizationrole')),
            ],
            options={
                'db_table': 'core"."organization_users',
            },
        ),
        migrations.AddField(
            model_name='flowtemplate',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_templates', to='constec_db.organizationuser'),
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('full_name', models.CharField(max_length=255)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='persons', to='constec_db.company')),
            ],
            options={
                'db_table': 'core"."persons',
            },
        ),
        migrations.AddField(
            model_name='entity',
            name='company',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='erp_entities', to='constec_db.company'),
        ),
        migrations.AddField(
            model_name='entity',
            name='person',
            field=models.ForeignKey(blank=True, help_text='Optional link to Core person', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='erp_entities', to='constec_db.person'),
        ),
        migrations.CreateModel(
            name='PersonContact',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_primary', models.BooleanField(default=False)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_contacts', to='constec_db.contact')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_contacts', to='constec_db.person')),
            ],
            options={
                'db_table': 'core"."person_contacts',
            },
        ),
        migrations.CreateModel(
            name='PersonTag',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50)),
                ('color', models.CharField(blank=True, max_length=7, null=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_tags', to='constec_db.company')),
            ],
            options={
                'db_table': 'core"."person_tags',
            },
        ),
        migrations.CreateModel(
            name='PersonTagged',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='constec_db.person')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_persons', to='constec_db.persontag')),
            ],
            options={
                'db_table': 'core"."person_tagged',
            },
        ),
        migrations.AddField(
            model_name='entity',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='entities', to='constec_db.role'),
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('metadata', models.JSONField(default=dict, help_text='Session context (connection, role, etc.)')),
                ('is_active', models.BooleanField(default=True)),
                ('ended_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('company', models.ForeignKey(help_text='The company this session belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to='constec_db.company')),
                ('flow', models.ForeignKey(help_text='AI flow configuration to use', on_delete=django.db.models.deletion.PROTECT, related_name='sessions', to='constec_db.flow')),
                ('user', models.ForeignKey(help_text='The person chatting (can be employee or client)', on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to='constec_db.person')),
            ],
            options={
                'db_table': 'constancia"."sessions',
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('role', models.CharField(choices=[('user', 'User'), ('assistant', 'Assistant')], max_length=20)),
                ('content', models.TextField()),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Additional message data: tool calls, errors, context, etc.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='constec_db.session')),
            ],
            options={
                'db_table': 'constancia"."messages',
                'ordering': ['created_at'],
            },
        ),
        migrations.AddField(
            model_name='role',
            name='system',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='constec_db.system'),
        ),
        migrations.AddField(
            model_name='entity',
            name='system',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entities', to='constec_db.system'),
        ),
        migrations.CreateModel(
            name='Connection',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, default='', help_text='Descriptive name for this connection', max_length=100)),
                ('slug', models.CharField(max_length=50)),
                ('db_type', models.CharField(choices=[('mssql', 'SQL Server'), ('postgresql', 'PostgreSQL'), ('mysql', 'MySQL')], default='mssql', max_length=20)),
                ('host', models.CharField(max_length=255)),
                ('port', models.IntegerField()),
                ('database', models.CharField(max_length=100)),
                ('username', models.CharField(max_length=100)),
                ('encrypted_password', models.TextField()),
                ('is_active', models.BooleanField(default=True)),
                ('last_tested_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='erp_connections', to='constec_db.company')),
                ('system', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='connections', to='constec_db.system')),
            ],
            options={
                'db_table': 'erp"."connections',
            },
        ),
        migrations.CreateModel(
            name='CompanySystem',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_primary', models.BooleanField(default=False, help_text='Whether this is the primary ERP system for the company')),
                ('is_active', models.BooleanField(default=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='erp_systems', to='constec_db.company')),
                ('system', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company_assignments', to='constec_db.system')),
            ],
            options={
                'db_table': 'erp"."company_systems',
            },
        ),
        migrations.CreateModel(
            name='TagCategory',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True, null=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tag_categories', to='constec_db.company')),
            ],
            options={
                'db_table': 'core"."tag_categories',
                'verbose_name': 'Tag category',
                'verbose_name_plural': 'Tag categories',
            },
        ),
        migrations.AddField(
            model_name='persontag',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_tags', to='constec_db.tagcategory'),
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('password_hash', models.CharField(max_length=255)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='users', to='constec_db.company')),
            ],
            options={
                'db_table': 'core"."users',
            },
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField(blank=True, null=True)),
                ('company', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='user_groups', to='constec_db.company')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='sub_groups', to='constec_db.usergroup')),
                ('users', models.ManyToManyField(related_name='groups', to='constec_db.user')),
            ],
            options={
                'db_table': 'core"."user_groups',
            },
        ),
        migrations.CreateModel(
            name='UserRole',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField(blank=True, null=True)),
                ('permissions', models.JSONField(default=dict)),
                ('is_system_role', models.BooleanField(default=False)),
                ('company', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='user_roles', to='constec_db.company')),
            ],
            options={
                'db_table': 'core"."user_roles',
            },
        ),
        migrations.CreateModel(
            name='UserCompanyAccess',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_accesses', to='constec_db.company')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company_accesses', to='constec_db.user')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='user_accesses', to='constec_db.userrole')),
            ],
            options={
                'db_table': 'core"."user_company_access',
                'verbose_name': 'User company access',
                'verbose_name_plural': 'User company access',
            },
        ),
        migrations.AddIndex(
            model_name='flow',
            index=models.Index(fields=['company', 'is_default'], name='flows_company_982968_idx'),
        ),
        migrations.AddIndex(
            model_name='flow',
            index=models.Index(fields=['template', 'is_active'], name='flows_templat_638f1d_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='flow',
            unique_together={('company', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='companymodule',
            unique_together={('company', 'module')},
        ),
        migrations.AlterUniqueTogether(
            name='organizationrole',
            unique_together={('organization', 'name')},
        ),
        migrations.AddIndex(
            model_name='flowtemplate',
            index=models.Index(fields=['organization', 'is_global'], name='flow_templa_organiz_abebc3_idx'),
        ),
        migrations.AddIndex(
            model_name='flowtemplate',
            index=models.Index(fields=['category', 'is_active'], name='flow_templa_categor_976487_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='flowtemplate',
            unique_together={('organization', 'name', 'version')},
        ),
        migrations.AlterUniqueTogether(
            name='personcontact',
            unique_together={('person', 'contact')},
        ),
        migrations.AlterUniqueTogether(
            name='persontagged',
            unique_together={('person', 'tag')},
        ),
        migrations.AddIndex(
            model_name='session',
            index=models.Index(fields=['company', 'is_active'], name='sessions_company_30036a_idx'),
        ),
        migrations.AddIndex(
            model_name='session',
            index=models.Index(fields=['user', 'is_active'], name='sessions_user_id_85103c_idx'),
        ),
        migrations.AddIndex(
            model_name='session',
            index=models.Index(fields=['-created_at'], name='sessions_created_eb29b2_idx'),
        ),
        migrations.AddIndex(
            model_name='message',
            index=models.Index(fields=['session', 'created_at'], name='messages_session_1b3070_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='role',
            unique_together={('system', 'name')},
        ),
        migrations.AddIndex(
            model_name='entity',
            index=models.Index(fields=['cuit'], name='entities_cuit_ad5bc3_idx'),
        ),
        migrations.AddIndex(
            model_name='entity',
            index=models.Index(fields=['company', 'cuit'], name='entities_company_cuit_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='entity',
            unique_together={('company', 'role', 'external_id')},
        ),
        migrations.AlterUniqueTogether(
            name='connection',
            unique_together={('system', 'slug')},
        ),
        migrations.AddIndex(
            model_name='companysystem',
            index=models.Index(fields=['company', 'is_primary'], name='company_sys_company_e5ff34_idx'),
        ),
        migrations.AddIndex(
            model_name='companysystem',
            index=models.Index(fields=['system', 'is_active'], name='company_sys_system__aeef9f_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='companysystem',
            unique_together={('company', 'system')},
        ),
        migrations.AlterUniqueTogether(
            name='persontag',
            unique_together={('company', 'category', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='usergroup',
            unique_together={('company', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='userrole',
            unique_together={('company', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='usercompanyaccess',
            unique_together={('user', 'company')},
        ),
    ]
