from unittest.mock import patch

from skoolkittest import SkoolKitTestCase
from skoolkit import components
from skoolkit.z80 import Assembler

OPERATIONS = (
    ('ADC A,244', (206, 244)),
    ('ADC A,B', (136,)),
    ('ADC A,C', (137,)),
    ('ADC A,D', (138,)),
    ('ADC A,E', (139,)),
    ('ADC A,H', (140,)),
    ('ADC A,L', (141,)),
    ('ADC A,(HL)', (142,)),
    ('ADC A,A', (143,)),
    ('ADC A,IXh', (221, 140)),
    ('ADC A,IXl', (221, 141)),
    ('ADC A,(IX+60)', (221, 142, 60)),
    ('ADC A,(IX-77)', (221, 142, 179)),
    ('ADC A,IYh', (253, 140)),
    ('ADC A,IYl', (253, 141)),
    ('ADC A,(IY+46)', (253, 142, 46)),
    ('ADC A,(IY-45)', (253, 142, 211)),
    ('ADC HL,BC', (237, 74)),
    ('ADC HL,DE', (237, 90)),
    ('ADC HL,HL', (237, 106)),
    ('ADC HL,SP', (237, 122)),
    ('ADD A,237', (198, 237)),
    ('ADD A,B', (128,)),
    ('ADD A,C', (129,)),
    ('ADD A,D', (130,)),
    ('ADD A,E', (131,)),
    ('ADD A,H', (132,)),
    ('ADD A,L', (133,)),
    ('ADD A,(HL)', (134,)),
    ('ADD A,A', (135,)),
    ('ADD A,IXh', (221, 132)),
    ('ADD A,IXl', (221, 133)),
    ('ADD A,(IX+93)', (221, 134, 93)),
    ('ADD A,(IX-95)', (221, 134, 161)),
    ('ADD A,IYh', (253, 132)),
    ('ADD A,IYl', (253, 133)),
    ('ADD A,(IY+1)', (253, 134, 1)),
    ('ADD A,(IY-72)', (253, 134, 184)),
    ('ADD HL,BC', (9,)),
    ('ADD HL,DE', (25,)),
    ('ADD HL,HL', (41,)),
    ('ADD HL,SP', (57,)),
    ('ADD IX,BC', (221, 9)),
    ('ADD IX,DE', (221, 25)),
    ('ADD IX,IX', (221, 41)),
    ('ADD IX,SP', (221, 57)),
    ('ADD IY,BC', (253, 9)),
    ('ADD IY,DE', (253, 25)),
    ('ADD IY,IY', (253, 41)),
    ('ADD IY,SP', (253, 57)),
    ('AND 122', (230, 122)),
    ('AND B', (160,)),
    ('AND C', (161,)),
    ('AND D', (162,)),
    ('AND E', (163,)),
    ('AND H', (164,)),
    ('AND L', (165,)),
    ('AND (HL)', (166,)),
    ('AND A', (167,)),
    ('AND IXh', (221, 164)),
    ('AND IXl', (221, 165)),
    ('AND (IX+18)', (221, 166, 18)),
    ('AND (IX-41)', (221, 166, 215)),
    ('AND IYh', (253, 164)),
    ('AND IYl', (253, 165)),
    ('AND (IY+24)', (253, 166, 24)),
    ('AND (IY-53)', (253, 166, 203)),
    ('BIT 0,B', (203, 64)),
    ('BIT 0,C', (203, 65)),
    ('BIT 0,D', (203, 66)),
    ('BIT 0,E', (203, 67)),
    ('BIT 0,H', (203, 68)),
    ('BIT 0,L', (203, 69)),
    ('BIT 0,(HL)', (203, 70)),
    ('BIT 0,A', (203, 71)),
    ('BIT 0,(IX+113)', (221, 203, 113, 70)),
    ('BIT 0,(IX-99)', (221, 203, 157, 70)),
    ('BIT 0,(IY+44)', (253, 203, 44, 70)),
    ('BIT 0,(IY-74)', (253, 203, 182, 70)),
    ('BIT 1,B', (203, 72)),
    ('BIT 1,C', (203, 73)),
    ('BIT 1,D', (203, 74)),
    ('BIT 1,E', (203, 75)),
    ('BIT 1,H', (203, 76)),
    ('BIT 1,L', (203, 77)),
    ('BIT 1,(HL)', (203, 78)),
    ('BIT 1,A', (203, 79)),
    ('BIT 1,(IX+120)', (221, 203, 120, 78)),
    ('BIT 1,(IX-69)', (221, 203, 187, 78)),
    ('BIT 1,(IY+14)', (253, 203, 14, 78)),
    ('BIT 1,(IY-9)', (253, 203, 247, 78)),
    ('BIT 2,B', (203, 80)),
    ('BIT 2,C', (203, 81)),
    ('BIT 2,D', (203, 82)),
    ('BIT 2,E', (203, 83)),
    ('BIT 2,H', (203, 84)),
    ('BIT 2,L', (203, 85)),
    ('BIT 2,(HL)', (203, 86)),
    ('BIT 2,A', (203, 87)),
    ('BIT 2,(IX+86)', (221, 203, 86, 86)),
    ('BIT 2,(IX-128)', (221, 203, 128, 86)),
    ('BIT 2,(IY+90)', (253, 203, 90, 86)),
    ('BIT 2,(IY-54)', (253, 203, 202, 86)),
    ('BIT 3,B', (203, 88)),
    ('BIT 3,C', (203, 89)),
    ('BIT 3,D', (203, 90)),
    ('BIT 3,E', (203, 91)),
    ('BIT 3,H', (203, 92)),
    ('BIT 3,L', (203, 93)),
    ('BIT 3,(HL)', (203, 94)),
    ('BIT 3,A', (203, 95)),
    ('BIT 3,(IX+122)', (221, 203, 122, 94)),
    ('BIT 3,(IX-63)', (221, 203, 193, 94)),
    ('BIT 3,(IY+50)', (253, 203, 50, 94)),
    ('BIT 3,(IY-96)', (253, 203, 160, 94)),
    ('BIT 4,B', (203, 96)),
    ('BIT 4,C', (203, 97)),
    ('BIT 4,D', (203, 98)),
    ('BIT 4,E', (203, 99)),
    ('BIT 4,H', (203, 100)),
    ('BIT 4,L', (203, 101)),
    ('BIT 4,(HL)', (203, 102)),
    ('BIT 4,A', (203, 103)),
    ('BIT 4,(IX+29)', (221, 203, 29, 102)),
    ('BIT 4,(IX-96)', (221, 203, 160, 102)),
    ('BIT 4,(IY+105)', (253, 203, 105, 102)),
    ('BIT 4,(IY-53)', (253, 203, 203, 102)),
    ('BIT 5,B', (203, 104)),
    ('BIT 5,C', (203, 105)),
    ('BIT 5,D', (203, 106)),
    ('BIT 5,E', (203, 107)),
    ('BIT 5,H', (203, 108)),
    ('BIT 5,L', (203, 109)),
    ('BIT 5,(HL)', (203, 110)),
    ('BIT 5,A', (203, 111)),
    ('BIT 5,(IX+70)', (221, 203, 70, 110)),
    ('BIT 5,(IX-80)', (221, 203, 176, 110)),
    ('BIT 5,(IY+90)', (253, 203, 90, 110)),
    ('BIT 5,(IY-95)', (253, 203, 161, 110)),
    ('BIT 6,B', (203, 112)),
    ('BIT 6,C', (203, 113)),
    ('BIT 6,D', (203, 114)),
    ('BIT 6,E', (203, 115)),
    ('BIT 6,H', (203, 116)),
    ('BIT 6,L', (203, 117)),
    ('BIT 6,(HL)', (203, 118)),
    ('BIT 6,A', (203, 119)),
    ('BIT 6,(IX+42)', (221, 203, 42, 118)),
    ('BIT 6,(IX-79)', (221, 203, 177, 118)),
    ('BIT 6,(IY+97)', (253, 203, 97, 118)),
    ('BIT 6,(IY-57)', (253, 203, 199, 118)),
    ('BIT 7,B', (203, 120)),
    ('BIT 7,C', (203, 121)),
    ('BIT 7,D', (203, 122)),
    ('BIT 7,E', (203, 123)),
    ('BIT 7,H', (203, 124)),
    ('BIT 7,L', (203, 125)),
    ('BIT 7,(HL)', (203, 126)),
    ('BIT 7,A', (203, 127)),
    ('BIT 7,(IX+40)', (221, 203, 40, 126)),
    ('BIT 7,(IX-99)', (221, 203, 157, 126)),
    ('BIT 7,(IY+71)', (253, 203, 71, 126)),
    ('BIT 7,(IY-126)', (253, 203, 130, 126)),
    ('CALL 1', (205, 1, 0)),
    ('CALL NZ,12', (196, 12, 0)),
    ('CALL Z,123', (204, 123, 0)),
    ('CALL NC,321', (212, 65, 1)),
    ('CALL C,1234', (220, 210, 4)),
    ('CALL PO,64222', (228, 222, 250)),
    ('CALL PE,65535', (236, 255, 255)),
    ('CALL P,32769', (244, 1, 128)),
    ('CALL M,49152', (252, 0, 192)),
    ('CCF', (63,)),
    ('CP 115', (254, 115)),
    ('CP B', (184,)),
    ('CP C', (185,)),
    ('CP D', (186,)),
    ('CP E', (187,)),
    ('CP H', (188,)),
    ('CP L', (189,)),
    ('CP (HL)', (190,)),
    ('CP A', (191,)),
    ('CP IXh', (221, 188)),
    ('CP IXl', (221, 189)),
    ('CP (IX+116)', (221, 190, 116)),
    ('CP (IX-105)', (221, 190, 151)),
    ('CP IYh', (253, 188)),
    ('CP IYl', (253, 189)),
    ('CP (IY+118)', (253, 190, 118)),
    ('CP (IY-119)', (253, 190, 137)),
    ('CPD', (237, 169)),
    ('CPDR', (237, 185)),
    ('CPI', (237, 161)),
    ('CPIR', (237, 177)),
    ('CPL', (47,)),
    ('DAA', (39,)),
    ('DEC B', (5,)),
    ('DEC C', (13,)),
    ('DEC D', (21,)),
    ('DEC E', (29,)),
    ('DEC H', (37,)),
    ('DEC L', (45,)),
    ('DEC (HL)', (53,)),
    ('DEC A', (61,)),
    ('DEC IXh', (221, 37)),
    ('DEC IXl', (221, 45)),
    ('DEC (IX+50)', (221, 53, 50)),
    ('DEC (IX-26)', (221, 53, 230)),
    ('DEC IYh', (253, 37)),
    ('DEC IYl', (253, 45)),
    ('DEC (IY+25)', (253, 53, 25)),
    ('DEC (IY-79)', (253, 53, 177)),
    ('DEC BC', (11,)),
    ('DEC DE', (27,)),
    ('DEC HL', (43,)),
    ('DEC SP', (59,)),
    ('DEC IX', (221, 43)),
    ('DEC IY', (253, 43)),
    ('DI', (243,)),
    ('DJNZ 16388', (16, 2)),
    ('EI', (251,)),
    ("EX AF,AF'", (8,)),
    ('EX DE,HL', (235,)),
    ('EX (SP),HL', (227,)),
    ('EX (SP),IX', (221, 227)),
    ('EX (SP),IY', (253, 227)),
    ('EXX', (217,)),
    ('HALT', (118,)),
    ('IM 0', (237, 70)),
    ('IM 1', (237, 86)),
    ('IM 2', (237, 94)),
    ('IN A,(0)', (219, 0)),
    ('IN B,(C)', (237, 64)),
    ('IN C,(C)', (237, 72)),
    ('IN D,(C)', (237, 80)),
    ('IN E,(C)', (237, 88)),
    ('IN H,(C)', (237, 96)),
    ('IN L,(C)', (237, 104)),
    ('IN A,(C)', (237, 120)),
    ('INC B', (4,)),
    ('INC C', (12,)),
    ('INC D', (20,)),
    ('INC E', (28,)),
    ('INC H', (36,)),
    ('INC L', (44,)),
    ('INC (HL)', (52,)),
    ('INC A', (60,)),
    ('INC IXh', (221, 36)),
    ('INC IXl', (221, 44)),
    ('INC (IX+66)', (221, 52, 66)),
    ('INC (IX-61)', (221, 52, 195)),
    ('INC IYh', (253, 36)),
    ('INC IYl', (253, 44)),
    ('INC (IY+29)', (253, 52, 29)),
    ('INC (IY-30)', (253, 52, 226)),
    ('INC BC', (3,)),
    ('INC DE', (19,)),
    ('INC HL', (35,)),
    ('INC SP', (51,)),
    ('INC IX', (221, 35)),
    ('INC IY', (253, 35)),
    ('IND', (237, 170)),
    ('INDR', (237, 186)),
    ('INI', (237, 162)),
    ('INIR', (237, 178)),
    ('JP 11', (195, 11, 0)),
    ('JP NZ,4352', (194, 0, 17)),
    ('JP Z,23755', (202, 203, 92)),
    ('JP NC,272', (210, 16, 1)),
    ('JP C,24576', (218, 0, 96)),
    ('JP PO,33178', (226, 154, 129)),
    ('JP PE,62686', (234, 222, 244)),
    ('JP P,60849', (242, 177, 237)),
    ('JP M,8', (250, 8, 0)),
    ('JP (HL)', (233,)),
    ('JP (IX)', (221, 233)),
    ('JP (IY)', (253, 233)),
    ('JR 16386', (24, 0)),
    ('JR NZ,16384', (32, 254)),
    ('JR Z,16388', (40, 2)),
    ('JR NC,16382', (48, 252)),
    ('JR C,16390', (56, 4)),
    ('LD (16384),A', (50, 0, 64)),
    ('LD (16384),BC', (237, 67, 0, 64)),
    ('LD (32768),DE', (237, 83, 0, 128)),
    ('LD (32768),HL', (34, 0, 128)),
    ('LD (23295),SP', (237, 115, 255, 90)),
    ('LD (48875),IX', (221, 34, 235, 190)),
    ('LD (12345),IY', (253, 34, 57, 48)),
    ('LD A,(12345)', (58, 57, 48)),
    ('LD BC,(48875)', (237, 75, 235, 190)),
    ('LD DE,(23295)', (237, 91, 255, 90)),
    ('LD HL,(32768)', (42, 0, 128)),
    ('LD SP,(32768)', (237, 123, 0, 128)),
    ('LD IX,(16384)', (221, 42, 0, 64)),
    ('LD IY,(16384)', (253, 42, 0, 64)),
    ('LD BC,1', (1, 1, 0)),
    ('LD DE,12', (17, 12, 0)),
    ('LD HL,123', (33, 123, 0)),
    ('LD SP,1234', (49, 210, 4)),
    ('LD SP,HL', (249,)),
    ('LD SP,IX', (221, 249)),
    ('LD SP,IY', (253, 249)),
    ('LD IX,12345', (221, 33, 57, 48)),
    ('LD IY,23456', (253, 33, 160, 91)),
    ('LD (BC),A', (2,)),
    ('LD A,(BC)', (10,)),
    ('LD (DE),A', (18,)),
    ('LD A,(DE)', (26,)),
    ('LD I,A', (237, 71)),
    ('LD A,I', (237, 87)),
    ('LD R,A', (237, 79)),
    ('LD A,R', (237, 95)),
    ('LD B,28', (6, 28)),
    ('LD B,B', (64,)),
    ('LD B,C', (65,)),
    ('LD B,D', (66,)),
    ('LD B,E', (67,)),
    ('LD B,H', (68,)),
    ('LD B,L', (69,)),
    ('LD B,(HL)', (70,)),
    ('LD B,A', (71,)),
    ('LD B,IXh', (221, 68)),
    ('LD B,IXl', (221, 69)),
    ('LD B,(IX+34)', (221, 70, 34)),
    ('LD B,(IX-94)', (221, 70, 162)),
    ('LD B,IYh', (253, 68)),
    ('LD B,IYl', (253, 69)),
    ('LD B,(IY+51)', (253, 70, 51)),
    ('LD B,(IY-116)', (253, 70, 140)),
    ('LD C,67', (14, 67)),
    ('LD C,B', (72,)),
    ('LD C,C', (73,)),
    ('LD C,D', (74,)),
    ('LD C,E', (75,)),
    ('LD C,H', (76,)),
    ('LD C,L', (77,)),
    ('LD C,(HL)', (78,)),
    ('LD C,A', (79,)),
    ('LD C,IXh', (221, 76)),
    ('LD C,IXl', (221, 77)),
    ('LD C,(IX+89)', (221, 78, 89)),
    ('LD C,(IX-68)', (221, 78, 188)),
    ('LD C,IYh', (253, 76)),
    ('LD C,IYl', (253, 77)),
    ('LD C,(IY+51)', (253, 78, 51)),
    ('LD C,(IY-122)', (253, 78, 134)),
    ('LD D,207', (22, 207)),
    ('LD D,B', (80,)),
    ('LD D,C', (81,)),
    ('LD D,D', (82,)),
    ('LD D,E', (83,)),
    ('LD D,H', (84,)),
    ('LD D,L', (85,)),
    ('LD D,(HL)', (86,)),
    ('LD D,A', (87,)),
    ('LD D,IXh', (221, 84)),
    ('LD D,IXl', (221, 85)),
    ('LD D,(IX+60)', (221, 86, 60)),
    ('LD D,(IX-96)', (221, 86, 160)),
    ('LD D,IYh', (253, 84)),
    ('LD D,IYl', (253, 85)),
    ('LD D,(IY+53)', (253, 86, 53)),
    ('LD D,(IY-15)', (253, 86, 241)),
    ('LD E,240', (30, 240)),
    ('LD E,B', (88,)),
    ('LD E,C', (89,)),
    ('LD E,D', (90,)),
    ('LD E,E', (91,)),
    ('LD E,H', (92,)),
    ('LD E,L', (93,)),
    ('LD E,(HL)', (94,)),
    ('LD E,A', (95,)),
    ('LD E,IXh', (221, 92)),
    ('LD E,IXl', (221, 93)),
    ('LD E,(IX+123)', (221, 94, 123)),
    ('LD E,(IX-20)', (221, 94, 236)),
    ('LD E,IYh', (253, 92)),
    ('LD E,IYl', (253, 93)),
    ('LD E,(IY+42)', (253, 94, 42)),
    ('LD E,(IY-105)', (253, 94, 151)),
    ('LD H,0', (38, 0)),
    ('LD H,B', (96,)),
    ('LD H,C', (97,)),
    ('LD H,D', (98,)),
    ('LD H,E', (99,)),
    ('LD H,H', (100,)),
    ('LD H,L', (101,)),
    ('LD H,(HL)', (102,)),
    ('LD H,A', (103,)),
    ('LD H,(IX+114)', (221, 102, 114)),
    ('LD H,(IX-17)', (221, 102, 239)),
    ('LD H,(IY+33)', (253, 102, 33)),
    ('LD H,(IY-46)', (253, 102, 210)),
    ('LD L,246', (46, 246)),
    ('LD L,B', (104,)),
    ('LD L,C', (105,)),
    ('LD L,D', (106,)),
    ('LD L,E', (107,)),
    ('LD L,H', (108,)),
    ('LD L,L', (109,)),
    ('LD L,(HL)', (110,)),
    ('LD L,A', (111,)),
    ('LD L,(IX+4)', (221, 110, 4)),
    ('LD L,(IX-101)', (221, 110, 155)),
    ('LD L,(IY+125)', (253, 110, 125)),
    ('LD L,(IY-125)', (253, 110, 131)),
    ('LD (HL),52', (54, 52)),
    ('LD (HL),B', (112,)),
    ('LD (HL),C', (113,)),
    ('LD (HL),D', (114,)),
    ('LD (HL),E', (115,)),
    ('LD (HL),H', (116,)),
    ('LD (HL),L', (117,)),
    ('LD (HL),A', (119,)),
    ('LD A,175', (62, 175)),
    ('LD A,B', (120,)),
    ('LD A,C', (121,)),
    ('LD A,D', (122,)),
    ('LD A,E', (123,)),
    ('LD A,H', (124,)),
    ('LD A,L', (125,)),
    ('LD A,(HL)', (126,)),
    ('LD A,A', (127,)),
    ('LD A,IXh', (221, 124)),
    ('LD A,IXl', (221, 125)),
    ('LD A,(IX+87)', (221, 126, 87)),
    ('LD A,(IX-111)', (221, 126, 145)),
    ('LD A,IYh', (253, 124)),
    ('LD A,IYl', (253, 125)),
    ('LD A,(IY+96)', (253, 126, 96)),
    ('LD A,(IY-42)', (253, 126, 214)),
    ('LD (IX+10),20', (221, 54, 10, 20)),
    ('LD (IX+68),B', (221, 112, 68)),
    ('LD (IX-43),B', (221, 112, 213)),
    ('LD (IX+62),C', (221, 113, 62)),
    ('LD (IX-11),C', (221, 113, 245)),
    ('LD (IX+59),D', (221, 114, 59)),
    ('LD (IX-5),D', (221, 114, 251)),
    ('LD (IX+69),E', (221, 115, 69)),
    ('LD (IX-87),E', (221, 115, 169)),
    ('LD (IX+87),H', (221, 116, 87)),
    ('LD (IX-10),H', (221, 116, 246)),
    ('LD (IX+114),L', (221, 117, 114)),
    ('LD (IX-38),L', (221, 117, 218)),
    ('LD (IX+17),A', (221, 119, 17)),
    ('LD (IX-71),A', (221, 119, 185)),
    ('LD IXh,8', (221, 38, 8)),
    ('LD IXh,B', (221, 96)),
    ('LD IXh,C', (221, 97)),
    ('LD IXh,D', (221, 98)),
    ('LD IXh,E', (221, 99)),
    ('LD IXh,IXh', (221, 100)),
    ('LD IXh,IXl', (221, 101)),
    ('LD IXh,A', (221, 103)),
    ('LD IXl,0', (221, 46, 0)),
    ('LD IXl,B', (221, 104)),
    ('LD IXl,C', (221, 105)),
    ('LD IXl,D', (221, 106)),
    ('LD IXl,E', (221, 107)),
    ('LD IXl,IXh', (221, 108)),
    ('LD IXl,IXl', (221, 109)),
    ('LD IXl,A', (221, 111)),
    ('LD (IY+10),17', (253, 54, 10, 17)),
    ('LD (IY+88),B', (253, 112, 88)),
    ('LD (IY-62),B', (253, 112, 194)),
    ('LD (IY+84),C', (253, 113, 84)),
    ('LD (IY-117),C', (253, 113, 139)),
    ('LD (IY+124),D', (253, 114, 124)),
    ('LD (IY-55),D', (253, 114, 201)),
    ('LD (IY+75),E', (253, 115, 75)),
    ('LD (IY-89),E', (253, 115, 167)),
    ('LD (IY+7),H', (253, 116, 7)),
    ('LD (IY-72),H', (253, 116, 184)),
    ('LD (IY+20),L', (253, 117, 20)),
    ('LD (IY-65),L', (253, 117, 191)),
    ('LD (IY+68),A', (253, 119, 68)),
    ('LD (IY-105),A', (253, 119, 151)),
    ('LD IYh,200', (253, 38, 200)),
    ('LD IYh,B', (253, 96)),
    ('LD IYh,C', (253, 97)),
    ('LD IYh,D', (253, 98)),
    ('LD IYh,E', (253, 99)),
    ('LD IYh,IYh', (253, 100)),
    ('LD IYh,IYl', (253, 101)),
    ('LD IYh,A', (253, 103)),
    ('LD IYl,10', (253, 46, 10)),
    ('LD IYl,B', (253, 104)),
    ('LD IYl,C', (253, 105)),
    ('LD IYl,D', (253, 106)),
    ('LD IYl,E', (253, 107)),
    ('LD IYl,IYh', (253, 108)),
    ('LD IYl,IYl', (253, 109)),
    ('LD IYl,A', (253, 111)),
    ('LDD', (237, 168)),
    ('LDDR', (237, 184)),
    ('LDI', (237, 160)),
    ('LDIR', (237, 176)),
    ('NEG', (237, 68)),
    ('NOP', (0,)),
    ('OR 110', (246, 110)),
    ('OR B', (176,)),
    ('OR C', (177,)),
    ('OR D', (178,)),
    ('OR E', (179,)),
    ('OR H', (180,)),
    ('OR L', (181,)),
    ('OR (HL)', (182,)),
    ('OR A', (183,)),
    ('OR IXh', (221, 180)),
    ('OR IXl', (221, 181)),
    ('OR (IX+34)', (221, 182, 34)),
    ('OR (IX-53)', (221, 182, 203)),
    ('OR IYh', (253, 180)),
    ('OR IYl', (253, 181)),
    ('OR (IY+6)', (253, 182, 6)),
    ('OR (IY-6)', (253, 182, 250)),
    ('OTDR', (237, 187)),
    ('OTIR', (237, 179)),
    ('OUT (11),A', (211, 11)),
    ('OUT (C),B', (237, 65)),
    ('OUT (C),C', (237, 73)),
    ('OUT (C),D', (237, 81)),
    ('OUT (C),E', (237, 89)),
    ('OUT (C),H', (237, 97)),
    ('OUT (C),L', (237, 105)),
    ('OUT (C),A', (237, 121)),
    ('OUTD', (237, 171)),
    ('OUTI', (237, 163)),
    ('POP BC', (193,)),
    ('POP DE', (209,)),
    ('POP HL', (225,)),
    ('POP AF', (241,)),
    ('POP IX', (221, 225)),
    ('POP IY', (253, 225)),
    ('PUSH BC', (197,)),
    ('PUSH DE', (213,)),
    ('PUSH HL', (229,)),
    ('PUSH AF', (245,)),
    ('PUSH IX', (221, 229)),
    ('PUSH IY', (253, 229)),
    ('RES 0,B', (203, 128)),
    ('RES 0,C', (203, 129)),
    ('RES 0,D', (203, 130)),
    ('RES 0,E', (203, 131)),
    ('RES 0,H', (203, 132)),
    ('RES 0,L', (203, 133)),
    ('RES 0,(HL)', (203, 134)),
    ('RES 0,A', (203, 135)),
    ('RES 0,(IX+5)', (221, 203, 5, 134)),
    ('RES 0,(IX-19)', (221, 203, 237, 134)),
    ('RES 0,(IY+33)', (253, 203, 33, 134)),
    ('RES 0,(IY-54)', (253, 203, 202, 134)),
    ('RES 1,B', (203, 136)),
    ('RES 1,C', (203, 137)),
    ('RES 1,D', (203, 138)),
    ('RES 1,E', (203, 139)),
    ('RES 1,H', (203, 140)),
    ('RES 1,L', (203, 141)),
    ('RES 1,(HL)', (203, 142)),
    ('RES 1,A', (203, 143)),
    ('RES 1,(IX+122)', (221, 203, 122, 142)),
    ('RES 1,(IX-67)', (221, 203, 189, 142)),
    ('RES 1,(IY+45)', (253, 203, 45, 142)),
    ('RES 1,(IY-106)', (253, 203, 150, 142)),
    ('RES 2,B', (203, 144)),
    ('RES 2,C', (203, 145)),
    ('RES 2,D', (203, 146)),
    ('RES 2,E', (203, 147)),
    ('RES 2,H', (203, 148)),
    ('RES 2,L', (203, 149)),
    ('RES 2,(HL)', (203, 150)),
    ('RES 2,A', (203, 151)),
    ('RES 2,(IX+3)', (221, 203, 3, 150)),
    ('RES 2,(IX-58)', (221, 203, 198, 150)),
    ('RES 2,(IY+4)', (253, 203, 4, 150)),
    ('RES 2,(IY-119)', (253, 203, 137, 150)),
    ('RES 3,B', (203, 152)),
    ('RES 3,C', (203, 153)),
    ('RES 3,D', (203, 154)),
    ('RES 3,E', (203, 155)),
    ('RES 3,H', (203, 156)),
    ('RES 3,L', (203, 157)),
    ('RES 3,(HL)', (203, 158)),
    ('RES 3,A', (203, 159)),
    ('RES 3,(IX+2)', (221, 203, 2, 158)),
    ('RES 3,(IX-87)', (221, 203, 169, 158)),
    ('RES 3,(IY+94)', (253, 203, 94, 158)),
    ('RES 3,(IY-119)', (253, 203, 137, 158)),
    ('RES 4,B', (203, 160)),
    ('RES 4,C', (203, 161)),
    ('RES 4,D', (203, 162)),
    ('RES 4,E', (203, 163)),
    ('RES 4,H', (203, 164)),
    ('RES 4,L', (203, 165)),
    ('RES 4,(HL)', (203, 166)),
    ('RES 4,A', (203, 167)),
    ('RES 4,(IX+110)', (221, 203, 110, 166)),
    ('RES 4,(IX-78)', (221, 203, 178, 166)),
    ('RES 4,(IY+58)', (253, 203, 58, 166)),
    ('RES 4,(IY-19)', (253, 203, 237, 166)),
    ('RES 5,B', (203, 168)),
    ('RES 5,C', (203, 169)),
    ('RES 5,D', (203, 170)),
    ('RES 5,E', (203, 171)),
    ('RES 5,H', (203, 172)),
    ('RES 5,L', (203, 173)),
    ('RES 5,(HL)', (203, 174)),
    ('RES 5,A', (203, 175)),
    ('RES 5,(IX+112)', (221, 203, 112, 174)),
    ('RES 5,(IX-63)', (221, 203, 193, 174)),
    ('RES 5,(IY+59)', (253, 203, 59, 174)),
    ('RES 5,(IY-14)', (253, 203, 242, 174)),
    ('RES 6,B', (203, 176)),
    ('RES 6,C', (203, 177)),
    ('RES 6,D', (203, 178)),
    ('RES 6,E', (203, 179)),
    ('RES 6,H', (203, 180)),
    ('RES 6,L', (203, 181)),
    ('RES 6,(HL)', (203, 182)),
    ('RES 6,A', (203, 183)),
    ('RES 6,(IX+85)', (221, 203, 85, 182)),
    ('RES 6,(IX-2)', (221, 203, 254, 182)),
    ('RES 6,(IY+57)', (253, 203, 57, 182)),
    ('RES 6,(IY-13)', (253, 203, 243, 182)),
    ('RES 7,B', (203, 184)),
    ('RES 7,C', (203, 185)),
    ('RES 7,D', (203, 186)),
    ('RES 7,E', (203, 187)),
    ('RES 7,H', (203, 188)),
    ('RES 7,L', (203, 189)),
    ('RES 7,(HL)', (203, 190)),
    ('RES 7,A', (203, 191)),
    ('RES 7,(IX+48)', (221, 203, 48, 190)),
    ('RES 7,(IX-103)', (221, 203, 153, 190)),
    ('RES 7,(IY+44)', (253, 203, 44, 190)),
    ('RES 7,(IY-81)', (253, 203, 175, 190)),
    ('RET', (201,)),
    ('RET NZ', (192,)),
    ('RET Z', (200,)),
    ('RET NC', (208,)),
    ('RET C', (216,)),
    ('RET PO', (224,)),
    ('RET PE', (232,)),
    ('RET P', (240,)),
    ('RET M', (248,)),
    ('RETI', (237, 77)),
    ('RETN', (237, 69)),
    ('RL B', (203, 16)),
    ('RL C', (203, 17)),
    ('RL D', (203, 18)),
    ('RL E', (203, 19)),
    ('RL H', (203, 20)),
    ('RL L', (203, 21)),
    ('RL (HL)', (203, 22)),
    ('RL A', (203, 23)),
    ('RL (IX+16)', (221, 203, 16, 22)),
    ('RL (IX-76)', (221, 203, 180, 22)),
    ('RL (IY+84)', (253, 203, 84, 22)),
    ('RL (IY-36)', (253, 203, 220, 22)),
    ('RLA', (23,)),
    ('RLC B', (203, 0)),
    ('RLC C', (203, 1)),
    ('RLC D', (203, 2)),
    ('RLC E', (203, 3)),
    ('RLC H', (203, 4)),
    ('RLC L', (203, 5)),
    ('RLC (HL)', (203, 6)),
    ('RLC A', (203, 7)),
    ('RLC (IX+38)', (221, 203, 38, 6)),
    ('RLC (IX-3)', (221, 203, 253, 6)),
    ('RLC (IY+79)', (253, 203, 79, 6)),
    ('RLC (IY-12)', (253, 203, 244, 6)),
    ('RLCA', (7,)),
    ('RLD', (237, 111)),
    ('RR B', (203, 24)),
    ('RR C', (203, 25)),
    ('RR D', (203, 26)),
    ('RR E', (203, 27)),
    ('RR H', (203, 28)),
    ('RR L', (203, 29)),
    ('RR (HL)', (203, 30)),
    ('RR A', (203, 31)),
    ('RR (IX+62)', (221, 203, 62, 30)),
    ('RR (IX-37)', (221, 203, 219, 30)),
    ('RR (IY+85)', (253, 203, 85, 30)),
    ('RR (IY-30)', (253, 203, 226, 30)),
    ('RRA', (31,)),
    ('RRC B', (203, 8)),
    ('RRC C', (203, 9)),
    ('RRC D', (203, 10)),
    ('RRC E', (203, 11)),
    ('RRC H', (203, 12)),
    ('RRC L', (203, 13)),
    ('RRC (HL)', (203, 14)),
    ('RRC A', (203, 15)),
    ('RRC (IX+99)', (221, 203, 99, 14)),
    ('RRC (IX-15)', (221, 203, 241, 14)),
    ('RRC (IY+112)', (253, 203, 112, 14)),
    ('RRC (IY-48)', (253, 203, 208, 14)),
    ('RRCA', (15,)),
    ('RRD', (237, 103)),
    ('RST 0', (199,)),
    ('RST 8', (207,)),
    ('RST 16', (215,)),
    ('RST 24', (223,)),
    ('RST 32', (231,)),
    ('RST 40', (239,)),
    ('RST 48', (247,)),
    ('RST 56', (255,)),
    ('SBC A,156', (222, 156)),
    ('SBC A,B', (152,)),
    ('SBC A,C', (153,)),
    ('SBC A,D', (154,)),
    ('SBC A,E', (155,)),
    ('SBC A,H', (156,)),
    ('SBC A,L', (157,)),
    ('SBC A,(HL)', (158,)),
    ('SBC A,A', (159,)),
    ('SBC A,IXh', (221, 156)),
    ('SBC A,IXl', (221, 157)),
    ('SBC A,(IX+34)', (221, 158, 34)),
    ('SBC A,(IX-127)', (221, 158, 129)),
    ('SBC A,IYh', (253, 156)),
    ('SBC A,IYl', (253, 157)),
    ('SBC A,(IY+115)', (253, 158, 115)),
    ('SBC A,(IY-124)', (253, 158, 132)),
    ('SBC HL,BC', (237, 66)),
    ('SBC HL,DE', (237, 82)),
    ('SBC HL,HL', (237, 98)),
    ('SBC HL,SP', (237, 114)),
    ('SCF', (55,)),
    ('SET 0,B', (203, 192)),
    ('SET 0,C', (203, 193)),
    ('SET 0,D', (203, 194)),
    ('SET 0,E', (203, 195)),
    ('SET 0,H', (203, 196)),
    ('SET 0,L', (203, 197)),
    ('SET 0,(HL)', (203, 198)),
    ('SET 0,A', (203, 199)),
    ('SET 0,(IX+85)', (221, 203, 85, 198)),
    ('SET 0,(IX-51)', (221, 203, 205, 198)),
    ('SET 0,(IY+113)', (253, 203, 113, 198)),
    ('SET 0,(IY-85)', (253, 203, 171, 198)),
    ('SET 1,B', (203, 200)),
    ('SET 1,C', (203, 201)),
    ('SET 1,D', (203, 202)),
    ('SET 1,E', (203, 203)),
    ('SET 1,H', (203, 204)),
    ('SET 1,L', (203, 205)),
    ('SET 1,(HL)', (203, 206)),
    ('SET 1,A', (203, 207)),
    ('SET 1,(IX+71)', (221, 203, 71, 206)),
    ('SET 1,(IX-27)', (221, 203, 229, 206)),
    ('SET 1,(IY+40)', (253, 203, 40, 206)),
    ('SET 1,(IY-1)', (253, 203, 255, 206)),
    ('SET 2,B', (203, 208)),
    ('SET 2,C', (203, 209)),
    ('SET 2,D', (203, 210)),
    ('SET 2,E', (203, 211)),
    ('SET 2,H', (203, 212)),
    ('SET 2,L', (203, 213)),
    ('SET 2,(HL)', (203, 214)),
    ('SET 2,A', (203, 215)),
    ('SET 2,(IX+33)', (221, 203, 33, 214)),
    ('SET 2,(IX-109)', (221, 203, 147, 214)),
    ('SET 2,(IY+103)', (253, 203, 103, 214)),
    ('SET 2,(IY-4)', (253, 203, 252, 214)),
    ('SET 3,B', (203, 216)),
    ('SET 3,C', (203, 217)),
    ('SET 3,D', (203, 218)),
    ('SET 3,E', (203, 219)),
    ('SET 3,H', (203, 220)),
    ('SET 3,L', (203, 221)),
    ('SET 3,(HL)', (203, 222)),
    ('SET 3,A', (203, 223)),
    ('SET 3,(IX+34)', (221, 203, 34, 222)),
    ('SET 3,(IX-5)', (221, 203, 251, 222)),
    ('SET 3,(IY+110)', (253, 203, 110, 222)),
    ('SET 3,(IY-96)', (253, 203, 160, 222)),
    ('SET 4,B', (203, 224)),
    ('SET 4,C', (203, 225)),
    ('SET 4,D', (203, 226)),
    ('SET 4,E', (203, 227)),
    ('SET 4,H', (203, 228)),
    ('SET 4,L', (203, 229)),
    ('SET 4,(HL)', (203, 230)),
    ('SET 4,A', (203, 231)),
    ('SET 4,(IX+100)', (221, 203, 100, 230)),
    ('SET 4,(IX-4)', (221, 203, 252, 230)),
    ('SET 4,(IY+126)', (253, 203, 126, 230)),
    ('SET 4,(IY-122)', (253, 203, 134, 230)),
    ('SET 5,B', (203, 232)),
    ('SET 5,C', (203, 233)),
    ('SET 5,D', (203, 234)),
    ('SET 5,E', (203, 235)),
    ('SET 5,H', (203, 236)),
    ('SET 5,L', (203, 237)),
    ('SET 5,(HL)', (203, 238)),
    ('SET 5,A', (203, 239)),
    ('SET 5,(IX+111)', (221, 203, 111, 238)),
    ('SET 5,(IX-48)', (221, 203, 208, 238)),
    ('SET 5,(IY+101)', (253, 203, 101, 238)),
    ('SET 5,(IY-96)', (253, 203, 160, 238)),
    ('SET 6,B', (203, 240)),
    ('SET 6,C', (203, 241)),
    ('SET 6,D', (203, 242)),
    ('SET 6,E', (203, 243)),
    ('SET 6,H', (203, 244)),
    ('SET 6,L', (203, 245)),
    ('SET 6,(HL)', (203, 246)),
    ('SET 6,A', (203, 247)),
    ('SET 6,(IX+48)', (221, 203, 48, 246)),
    ('SET 6,(IX-111)', (221, 203, 145, 246)),
    ('SET 6,(IY+55)', (253, 203, 55, 246)),
    ('SET 6,(IY-108)', (253, 203, 148, 246)),
    ('SET 7,B', (203, 248)),
    ('SET 7,C', (203, 249)),
    ('SET 7,D', (203, 250)),
    ('SET 7,E', (203, 251)),
    ('SET 7,H', (203, 252)),
    ('SET 7,L', (203, 253)),
    ('SET 7,(HL)', (203, 254)),
    ('SET 7,A', (203, 255)),
    ('SET 7,(IX+51)', (221, 203, 51, 254)),
    ('SET 7,(IX-34)', (221, 203, 222, 254)),
    ('SET 7,(IY+15)', (253, 203, 15, 254)),
    ('SET 7,(IY-120)', (253, 203, 136, 254)),
    ('SLA B', (203, 32)),
    ('SLA C', (203, 33)),
    ('SLA D', (203, 34)),
    ('SLA E', (203, 35)),
    ('SLA H', (203, 36)),
    ('SLA L', (203, 37)),
    ('SLA (HL)', (203, 38)),
    ('SLA A', (203, 39)),
    ('SLA (IX+66)', (221, 203, 66, 38)),
    ('SLA (IX-27)', (221, 203, 229, 38)),
    ('SLA (IY+81)', (253, 203, 81, 38)),
    ('SLA (IY-17)', (253, 203, 239, 38)),
    ('SLL B', (203, 48)),
    ('SLL C', (203, 49)),
    ('SLL D', (203, 50)),
    ('SLL E', (203, 51)),
    ('SLL H', (203, 52)),
    ('SLL L', (203, 53)),
    ('SLL (HL)', (203, 54)),
    ('SLL A', (203, 55)),
    ('SLL (IX+117)', (221, 203, 117, 54)),
    ('SLL (IX-13)', (221, 203, 243, 54)),
    ('SLL (IY+86)', (253, 203, 86, 54)),
    ('SLL (IY-87)', (253, 203, 169, 54)),
    ('SRA B', (203, 40)),
    ('SRA C', (203, 41)),
    ('SRA D', (203, 42)),
    ('SRA E', (203, 43)),
    ('SRA H', (203, 44)),
    ('SRA L', (203, 45)),
    ('SRA (HL)', (203, 46)),
    ('SRA A', (203, 47)),
    ('SRA (IX+118)', (221, 203, 118, 46)),
    ('SRA (IX-44)', (221, 203, 212, 46)),
    ('SRA (IY+13)', (253, 203, 13, 46)),
    ('SRA (IY-33)', (253, 203, 223, 46)),
    ('SRL B', (203, 56)),
    ('SRL C', (203, 57)),
    ('SRL D', (203, 58)),
    ('SRL E', (203, 59)),
    ('SRL H', (203, 60)),
    ('SRL L', (203, 61)),
    ('SRL (HL)', (203, 62)),
    ('SRL A', (203, 63)),
    ('SRL (IX+53)', (221, 203, 53, 62)),
    ('SRL (IX-101)', (221, 203, 155, 62)),
    ('SRL (IY+4)', (253, 203, 4, 62)),
    ('SRL (IY-23)', (253, 203, 233, 62)),
    ('SUB 85', (214, 85)),
    ('SUB B', (144,)),
    ('SUB C', (145,)),
    ('SUB D', (146,)),
    ('SUB E', (147,)),
    ('SUB H', (148,)),
    ('SUB L', (149,)),
    ('SUB (HL)', (150,)),
    ('SUB A', (151,)),
    ('SUB IXh', (221, 148)),
    ('SUB IXl', (221, 149)),
    ('SUB (IX+2)', (221, 150, 2)),
    ('SUB (IX-51)', (221, 150, 205)),
    ('SUB IYh', (253, 148)),
    ('SUB IYl', (253, 149)),
    ('SUB (IY+80)', (253, 150, 80)),
    ('SUB (IY-65)', (253, 150, 191)),
    ('XOR 207', (238, 207)),
    ('XOR B', (168,)),
    ('XOR C', (169,)),
    ('XOR D', (170,)),
    ('XOR E', (171,)),
    ('XOR H', (172,)),
    ('XOR L', (173,)),
    ('XOR (HL)', (174,)),
    ('XOR A', (175,)),
    ('XOR IXh', (221, 172)),
    ('XOR IXl', (221, 173)),
    ('XOR (IX+96)', (221, 174, 96)),
    ('XOR (IX-42)', (221, 174, 214)),
    ('XOR IYh', (253, 172)),
    ('XOR IYl', (253, 173)),
    ('XOR (IY+50)', (253, 174, 50)),
    ('XOR (IY-79)', (253, 174, 177))
)

HEXADECIMAL_OPERANDS = (
    ('ADC A,$00', (206, 0)),
    ('ADC A,(IX+$43)', (221, 142, 67)),
    ('ADC A,(IX-$35)', (221, 142, 203)),
    ('ADC A,(IY+$67)', (253, 142, 103)),
    ('ADC A,(IY-$51)', (253, 142, 175)),
    ('ADD A,$C3', (198, 195)),
    ('ADD A,(IX+$1E)', (221, 134, 30)),
    ('ADD A,(IX-$5F)', (221, 134, 161)),
    ('ADD A,(IY+$15)', (253, 134, 21)),
    ('ADD A,(IY-$0C)', (253, 134, 244)),
    ('AND $70', (230, 112)),
    ('AND (IX+$0D)', (221, 166, 13)),
    ('AND (IX-$5A)', (221, 166, 166)),
    ('AND (IY+$1F)', (253, 166, 31)),
    ('AND (IY-$22)', (253, 166, 222)),
    ('BIT 0,(IX+$67)', (221, 203, 103, 70)),
    ('BIT 0,(IX-$18)', (221, 203, 232, 70)),
    ('BIT 0,(IY+$39)', (253, 203, 57, 70)),
    ('BIT 0,(IY-$40)', (253, 203, 192, 70)),
    ('BIT 1,(IX+$2A)', (221, 203, 42, 78)),
    ('BIT 1,(IX-$04)', (221, 203, 252, 78)),
    ('BIT 1,(IY+$2C)', (253, 203, 44, 78)),
    ('BIT 1,(IY-$75)', (253, 203, 139, 78)),
    ('BIT 2,(IX+$12)', (221, 203, 18, 86)),
    ('BIT 2,(IX-$60)', (221, 203, 160, 86)),
    ('BIT 2,(IY+$52)', (253, 203, 82, 86)),
    ('BIT 2,(IY-$31)', (253, 203, 207, 86)),
    ('BIT 3,(IX+$77)', (221, 203, 119, 94)),
    ('BIT 3,(IX-$61)', (221, 203, 159, 94)),
    ('BIT 3,(IY+$12)', (253, 203, 18, 94)),
    ('BIT 3,(IY-$25)', (253, 203, 219, 94)),
    ('BIT 4,(IX+$63)', (221, 203, 99, 102)),
    ('BIT 4,(IX-$48)', (221, 203, 184, 102)),
    ('BIT 4,(IY+$77)', (253, 203, 119, 102)),
    ('BIT 4,(IY-$54)', (253, 203, 172, 102)),
    ('BIT 5,(IX+$3C)', (221, 203, 60, 110)),
    ('BIT 5,(IX-$37)', (221, 203, 201, 110)),
    ('BIT 5,(IY+$5A)', (253, 203, 90, 110)),
    ('BIT 5,(IY-$4D)', (253, 203, 179, 110)),
    ('BIT 6,(IX+$68)', (221, 203, 104, 118)),
    ('BIT 6,(IX-$2E)', (221, 203, 210, 118)),
    ('BIT 6,(IY+$5A)', (253, 203, 90, 118)),
    ('BIT 6,(IY-$6B)', (253, 203, 149, 118)),
    ('BIT 7,(IX+$4A)', (221, 203, 74, 126)),
    ('BIT 7,(IX-$7B)', (221, 203, 133, 126)),
    ('BIT 7,(IY+$70)', (253, 203, 112, 126)),
    ('BIT 7,(IY-$6D)', (253, 203, 147, 126)),
    ('CALL NZ,$0123', (196, 35, 1)),
    ('CALL Z,$0123', (204, 35, 1)),
    ('CALL NC,$1000', (212, 0, 16)),
    ('CALL C,$1000', (220, 0, 16)),
    ('CALL PO,$FADE', (228, 222, 250)),
    ('CALL PE,$FADE', (236, 222, 250)),
    ('CALL P,$8001', (244, 1, 128)),
    ('CALL M,$8001', (252, 1, 128)),
    ('CP $7F', (254, 127)),
    ('CP (IX+$21)', (221, 190, 33)),
    ('CP (IX-$74)', (221, 190, 140)),
    ('CP (IY+$27)', (253, 190, 39)),
    ('CP (IY-$80)', (253, 190, 128)),
    ('DEC (IX+$25)', (221, 53, 37)),
    ('DEC (IX-$0D)', (221, 53, 243)),
    ('DEC (IY+$77)', (253, 53, 119)),
    ('DEC (IY-$0F)', (253, 53, 241)),
    ('DJNZ $4000', (16, 254)),
    ('IN A,($FE)', (219, 254)),
    ('INC (IX+$7D)', (221, 52, 125)),
    ('INC (IX-$7D)', (221, 52, 131)),
    ('INC (IY+$3E)', (253, 52, 62)),
    ('INC (IY-$36)', (253, 52, 202)),
    ('JP NZ,$1100', (194, 0, 17)),
    ('JP Z,$1100', (202, 0, 17)),
    ('JP NC,$0110', (210, 16, 1)),
    ('JP C,$0110', (218, 16, 1)),
    ('JP PO,$819A', (226, 154, 129)),
    ('JP PE,$819A', (234, 154, 129)),
    ('JP P,$EDB1', (242, 177, 237)),
    ('JP M,$EDB1', (250, 177, 237)),
    ('JR NZ,$4004', (32, 2)),
    ('JR Z,$4004', (40, 2)),
    ('JR NC,$4006', (48, 4)),
    ('JR C,$4006', (56, 4)),
    ('LD ($C000),A', (50, 0, 192)),
    ('LD ($4000),BC', (237, 67, 0, 64)),
    ('LD ($4000),DE', (237, 83, 0, 64)),
    ('LD ($8000),HL', (34, 0, 128)),
    ('LD ($BEEB),SP', (237, 115, 235, 190)),
    ('LD ($BEEB),IX', (221, 34, 235, 190)),
    ('LD ($BEEB),IY', (253, 34, 235, 190)),
    ('LD A,($C000)', (58, 0, 192)),
    ('LD BC,($BEEB)', (237, 75, 235, 190)),
    ('LD DE,($BEEB)', (237, 91, 235, 190)),
    ('LD HL,($8000)', (42, 0, 128)),
    ('LD SP,($BEEB)', (237, 123, 235, 190)),
    ('LD IX,($4000)', (221, 42, 0, 64)),
    ('LD IY,($4000)', (253, 42, 0, 64)),
    ('LD BC,$BEEB', (1, 235, 190)),
    ('LD DE,$BEEB', (17, 235, 190)),
    ('LD HL,$8000', (33, 0, 128)),
    ('LD SP,$BEEB', (49, 235, 190)),
    ('LD IX,$4000', (221, 33, 0, 64)),
    ('LD IY,$4000', (253, 33, 0, 64)),
    ('LD B,$65', (6, 101)),
    ('LD B,(IX+$44)', (221, 70, 68)),
    ('LD B,(IX-$5A)', (221, 70, 166)),
    ('LD B,(IY+$45)', (253, 70, 69)),
    ('LD B,(IY-$67)', (253, 70, 153)),
    ('LD C,$D7', (14, 215)),
    ('LD C,(IX+$1B)', (221, 78, 27)),
    ('LD C,(IX-$7A)', (221, 78, 134)),
    ('LD C,(IY+$18)', (253, 78, 24)),
    ('LD C,(IY-$37)', (253, 78, 201)),
    ('LD C,(IY-$01)', (253, 78, 255)),
    ('LD D,$D3', (22, 211)),
    ('LD D,(IX+$61)', (221, 86, 97)),
    ('LD D,(IX-$0E)', (221, 86, 242)),
    ('LD D,(IY+$26)', (253, 86, 38)),
    ('LD D,(IY-$7A)', (253, 86, 134)),
    ('LD E,$30', (30, 48)),
    ('LD E,(IX+$24)', (221, 94, 36)),
    ('LD E,(IX-$50)', (221, 94, 176)),
    ('LD E,(IY+$39)', (253, 94, 57)),
    ('LD E,(IY-$2E)', (253, 94, 210)),
    ('LD H,$15', (38, 21)),
    ('LD H,(IX+$60)', (221, 102, 96)),
    ('LD H,(IX-$60)', (221, 102, 160)),
    ('LD H,(IY+$5B)', (253, 102, 91)),
    ('LD H,(IY-$50)', (253, 102, 176)),
    ('LD L,$70', (46, 112)),
    ('LD L,(IX+$60)', (221, 110, 96)),
    ('LD L,(IX-$1B)', (221, 110, 229)),
    ('LD L,(IY+$5D)', (253, 110, 93)),
    ('LD L,(IY-$7A)', (253, 110, 134)),
    ('LD (HL),$5E', (54, 94)),
    ('LD A,$FA', (62, 250)),
    ('LD A,(IX+$5E)', (221, 126, 94)),
    ('LD A,(IX-$80)', (221, 126, 128)),
    ('LD A,(IY+$29)', (253, 126, 41)),
    ('LD A,(IY-$28)', (253, 126, 216)),
    ('LD (IX+$0A),$20', (221, 54, 10, 32)),
    ('LD (IX+$69),B', (221, 112, 105)),
    ('LD (IX-$03),B', (221, 112, 253)),
    ('LD (IX+$77),C', (221, 113, 119)),
    ('LD (IX-$09),C', (221, 113, 247)),
    ('LD (IX+$39),D', (221, 114, 57)),
    ('LD (IX-$04),D', (221, 114, 252)),
    ('LD (IX+$17),E', (221, 115, 23)),
    ('LD (IX-$4B),E', (221, 115, 181)),
    ('LD (IX+$58),H', (221, 116, 88)),
    ('LD (IX-$11),H', (221, 116, 239)),
    ('LD (IX+$75),L', (221, 117, 117)),
    ('LD (IX-$32),L', (221, 117, 206)),
    ('LD (IX+$4B),A', (221, 119, 75)),
    ('LD (IX-$70),A', (221, 119, 144)),
    ('LD IXh,$09', (221, 38, 9)),
    ('LD IXl,$01', (221, 46, 1)),
    ('LD (IY+$0A),$11', (253, 54, 10, 17)),
    ('LD (IY+$6B),B', (253, 112, 107)),
    ('LD (IY-$1F),B', (253, 112, 225)),
    ('LD (IY+$65),C', (253, 113, 101)),
    ('LD (IY-$7F),C', (253, 113, 129)),
    ('LD (IY+$22),D', (253, 114, 34)),
    ('LD (IY-$2D),D', (253, 114, 211)),
    ('LD (IY+$6C),E', (253, 115, 108)),
    ('LD (IY-$55),E', (253, 115, 171)),
    ('LD (IY+$62),H', (253, 116, 98)),
    ('LD (IY-$43),H', (253, 116, 189)),
    ('LD (IY+$3E),L', (253, 117, 62)),
    ('LD (IY-$5D),L', (253, 117, 163)),
    ('LD (IY+$23),A', (253, 119, 35)),
    ('LD (IY-$1A),A', (253, 119, 230)),
    ('LD IYh,$21', (253, 38, 33)),
    ('LD IYl,$14', (253, 46, 20)),
    ('OR $11', (246, 17)),
    ('OR (IX+$07)', (221, 182, 7)),
    ('OR (IX-$64)', (221, 182, 156)),
    ('OR (IY+$09)', (253, 182, 9)),
    ('OR (IY-$74)', (253, 182, 140)),
    ('OUT ($11),A', (211, 17)),
    ('RES 0,(IX+$69)', (221, 203, 105, 134)),
    ('RES 0,(IX-$3B)', (221, 203, 197, 134)),
    ('RES 0,(IY+$63)', (253, 203, 99, 134)),
    ('RES 0,(IY-$31)', (253, 203, 207, 134)),
    ('RES 0,(IY-$02)', (253, 203, 254, 134)),
    ('RES 1,(IX+$1C)', (221, 203, 28, 142)),
    ('RES 1,(IX-$54)', (221, 203, 172, 142)),
    ('RES 1,(IY+$6F)', (253, 203, 111, 142)),
    ('RES 1,(IY-$1A)', (253, 203, 230, 142)),
    ('RES 2,(IX+$70)', (221, 203, 112, 150)),
    ('RES 2,(IX-$02)', (221, 203, 254, 150)),
    ('RES 2,(IY+$6E)', (253, 203, 110, 150)),
    ('RES 2,(IY-$7B)', (253, 203, 133, 150)),
    ('RES 3,(IX+$5F)', (221, 203, 95, 158)),
    ('RES 3,(IX-$5F)', (221, 203, 161, 158)),
    ('RES 3,(IY+$1D)', (253, 203, 29, 158)),
    ('RES 3,(IY-$56)', (253, 203, 170, 158)),
    ('RES 4,(IX+$7E)', (221, 203, 126, 166)),
    ('RES 4,(IX-$5F)', (221, 203, 161, 166)),
    ('RES 4,(IY+$45)', (253, 203, 69, 166)),
    ('RES 4,(IY-$2D)', (253, 203, 211, 166)),
    ('RES 5,(IX+$0E)', (221, 203, 14, 174)),
    ('RES 5,(IX-$51)', (221, 203, 175, 174)),
    ('RES 5,(IY+$14)', (253, 203, 20, 174)),
    ('RES 5,(IY-$63)', (253, 203, 157, 174)),
    ('RES 6,(IX+$3F)', (221, 203, 63, 182)),
    ('RES 6,(IX-$7A)', (221, 203, 134, 182)),
    ('RES 6,(IY+$10)', (253, 203, 16, 182)),
    ('RES 6,(IY-$57)', (253, 203, 169, 182)),
    ('RES 7,(IX+$30)', (221, 203, 48, 190)),
    ('RES 7,(IX-$5A)', (221, 203, 166, 190)),
    ('RES 7,(IY+$12)', (253, 203, 18, 190)),
    ('RES 7,(IY-$63)', (253, 203, 157, 190)),
    ('RL (IX+$1B)', (221, 203, 27, 22)),
    ('RL (IX-$18)', (221, 203, 232, 22)),
    ('RL (IY+$7D)', (253, 203, 125, 22)),
    ('RL (IY-$15)', (253, 203, 235, 22)),
    ('RLC (IX+$2C)', (221, 203, 44, 6)),
    ('RLC (IX-$46)', (221, 203, 186, 6)),
    ('RLC (IY+$4C)', (253, 203, 76, 6)),
    ('RLC (IY-$56)', (253, 203, 170, 6)),
    ('RR (IX+$7B)', (221, 203, 123, 30)),
    ('RR (IX-$4A)', (221, 203, 182, 30)),
    ('RR (IY+$3D)', (253, 203, 61, 30)),
    ('RR (IY-$37)', (253, 203, 201, 30)),
    ('RRC (IX+$44)', (221, 203, 68, 14)),
    ('RRC (IX-$75)', (221, 203, 139, 14)),
    ('RRC (IX+$03)', (221, 203, 3, 14)),
    ('RRC (IY+$6F)', (253, 203, 111, 14)),
    ('RRC (IY-$35)', (253, 203, 203, 14)),
    ('RST $00', (199,)),
    ('RST $08', (207,)),
    ('RST $10', (215,)),
    ('RST $18', (223,)),
    ('RST $20', (231,)),
    ('RST $28', (239,)),
    ('RST $30', (247,)),
    ('RST $38', (255,)),
    ('SBC A,$71', (222, 113)),
    ('SBC A,(IX+$66)', (221, 158, 102)),
    ('SBC A,(IX-$64)', (221, 158, 156)),
    ('SBC A,(IY+$3F)', (253, 158, 63)),
    ('SBC A,(IY-$3E)', (253, 158, 194)),
    ('SET 0,(IX+$57)', (221, 203, 87, 198)),
    ('SET 0,(IX-$36)', (221, 203, 202, 198)),
    ('SET 0,(IY+$45)', (253, 203, 69, 198)),
    ('SET 0,(IY-$33)', (253, 203, 205, 198)),
    ('SET 1,(IX+$7C)', (221, 203, 124, 206)),
    ('SET 1,(IX-$71)', (221, 203, 143, 206)),
    ('SET 1,(IY+$34)', (253, 203, 52, 206)),
    ('SET 1,(IY-$33)', (253, 203, 205, 206)),
    ('SET 2,(IX+$5F)', (221, 203, 95, 214)),
    ('SET 2,(IX-$03)', (221, 203, 253, 214)),
    ('SET 2,(IY+$09)', (253, 203, 9, 214)),
    ('SET 2,(IY-$0D)', (253, 203, 243, 214)),
    ('SET 3,(IX+$0E)', (221, 203, 14, 222)),
    ('SET 3,(IX-$67)', (221, 203, 153, 222)),
    ('SET 3,(IY+$52)', (253, 203, 82, 222)),
    ('SET 3,(IY-$0D)', (253, 203, 243, 222)),
    ('SET 4,(IX+$03)', (221, 203, 3, 230)),
    ('SET 4,(IX-$19)', (221, 203, 231, 230)),
    ('SET 4,(IY+$0B)', (253, 203, 11, 230)),
    ('SET 4,(IY-$40)', (253, 203, 192, 230)),
    ('SET 5,(IX+$0B)', (221, 203, 11, 238)),
    ('SET 5,(IX-$25)', (221, 203, 219, 238)),
    ('SET 5,(IY+$5B)', (253, 203, 91, 238)),
    ('SET 5,(IY-$15)', (253, 203, 235, 238)),
    ('SET 6,(IX+$56)', (221, 203, 86, 246)),
    ('SET 6,(IX-$43)', (221, 203, 189, 246)),
    ('SET 6,(IY+$2C)', (253, 203, 44, 246)),
    ('SET 6,(IY-$37)', (253, 203, 201, 246)),
    ('SET 7,(IX+$47)', (221, 203, 71, 254)),
    ('SET 7,(IX-$09)', (221, 203, 247, 254)),
    ('SET 7,(IY+$23)', (253, 203, 35, 254)),
    ('SET 7,(IY-$53)', (253, 203, 173, 254)),
    ('SLA (IX+$3D)', (221, 203, 61, 38)),
    ('SLA (IX-$3A)', (221, 203, 198, 38)),
    ('SLA (IY+$6E)', (253, 203, 110, 38)),
    ('SLA (IY-$7C)', (253, 203, 132, 38)),
    ('SLL (IX+$0F)', (221, 203, 15, 54)),
    ('SLL (IX-$51)', (221, 203, 175, 54)),
    ('SLL (IY+$48)', (253, 203, 72, 54)),
    ('SLL (IY-$36)', (253, 203, 202, 54)),
    ('SRA (IX+$46)', (221, 203, 70, 46)),
    ('SRA (IX-$5B)', (221, 203, 165, 46)),
    ('SRA (IY+$15)', (253, 203, 21, 46)),
    ('SRA (IY-$47)', (253, 203, 185, 46)),
    ('SRL (IX+$6E)', (221, 203, 110, 62)),
    ('SRL (IX-$0D)', (221, 203, 243, 62)),
    ('SRL (IY+$2F)', (253, 203, 47, 62)),
    ('SRL (IY-$3B)', (253, 203, 197, 62)),
    ('SUB $A7', (214, 167)),
    ('SUB (IX+$65)', (221, 150, 101)),
    ('SUB (IX-$3F)', (221, 150, 193)),
    ('SUB (IY+$57)', (253, 150, 87)),
    ('SUB (IY-$17)', (253, 150, 233)),
    ('XOR $64', (238, 100)),
    ('XOR (IX+$77)', (221, 174, 119)),
    ('XOR (IX-$78)', (221, 174, 136)),
    ('XOR (IY+$6C)', (253, 174, 108)),
    ('XOR (IY-$5B)', (253, 174, 165))
)

BINARY_OPERANDS = (
    ('ADC A,%10110111', (206, 183)),
    ('ADD A,%11010110', (198, 214)),
    ('AND %00110101', (230, 53)),
    ('CP %00001001', (254, 9)),
    ('LD B,%11011111', (6, 223)),
    ('LD C,%01010010', (14, 82)),
    ('LD D,%01101110', (22, 110)),
    ('LD E,%11001011', (30, 203)),
    ('LD H,%01011111', (38, 95)),
    ('LD L,%10000011', (46, 131)),
    ('LD (HL),%11010111', (54, 215)),
    ('LD A,%11110100', (62, 244)),
    ('LD IXh,%1010', (221, 38, 10)),
    ('LD IXl,%00000010', (221, 46, 2)),
    ('LD (IX+0),%01010101', (221, 54, 0, 85)),
    ('LD IYh,%11001100', (253, 38, 204)),
    ('LD IYl,%00011110', (253, 46, 30)),
    ('LD (IY+0),%10101010', (253, 54, 0, 170)),
    ('OR %10101010', (246, 170)),
    ('SBC A,%01010111', (222, 87)),
    ('SUB %11101001', (214, 233)),
    ('XOR %00001101', (238, 13))
)

NEGATIVE_OPERANDS = (
    ('LD A,-1', (62, 255)),
    ('LD B,-$02', (6, 254)),
    ('LD C,-%01010101', (14, 171)),
    ('LD BC,-1', (1, 255, 255)),
    ('LD DE,-$0002', (17, 254, 255)),
    ('LD HL,-%1000000000000001', (33, 255, 127))
)

CHARACTER_OPERANDS = (
    ('ADC A,"/"', (206, 47)),
    ('ADD A,"2"', (198, 50)),
    ('AND "7"', (230, 55)),
    ('CP "9"', (254, 57)),
    ('LD B,"&"', (6, 38)),
    ('LD C,"1"', (14, 49)),
    ('LD D,"Z"', (22, 90)),
    ('LD E,"C"', (30, 67)),
    ('LD H,"V"', (38, 86)),
    ('LD L,"K"', (46, 75)),
    ('LD (HL),"["', (54, 91)),
    ('LD A,"6"', (62, 54)),
    ('LD IXh,">"', (221, 38, 62)),
    ('LD IXl,";"', (221, 46, 59)),
    ('LD (IX+0),":"', (221, 54, 0, 58)),
    ('LD IYh,"!"', (253, 38, 33)),
    ('LD IYl,"("', (253, 46, 40)),
    ('LD (IY+0),"="', (253, 54, 0, 61)),
    ('OR "5"', (246, 53)),
    ('SBC A,"/"', (222, 47)),
    ('SUB ","', (214, 44)),
    ('XOR "?"', (238, 63))
)

ZERO_PADDED_OPERANDS = (
    ('LD A,01', (62, 1)),
    ('LD B,002', (6, 2)),
    ('LD BC,003', (1, 3, 0)),
    ('LD (0004),DE', (237, 83, 4, 0)),
    ('LD HL,(00005)', (42, 5, 0)),
    ('DEFB 1,02,003', (1, 2, 3)),
    ('DEFW 1,02,003,0004,00005', (1, 0, 2, 0, 3, 0, 4, 0, 5, 0))
)

ARITHMETIC_EXPRESSION_OPERANDS = (
    ('ADC A,"/"+1', (206, 48)),
    ('ADD A,$5A-"2"', (198, 40)),
    ('AND 64/8', (230, 8)),
    ('CP (5+1)*6', (254, 36)),
    ('CP 1+"\\""', (254, 35)),
    ('LD B,3-$80', (6, 131)),
    ('LD C,3+%11', (14, 6)),
    ('LD D,(19-2)%10', (22, 7)),
    ('LD E,(19-2) %10', (30, 7)),
    ('LD H,32769/256', (38, 128)),
    ('LD L,32769%256', (46, 1)),
    ('LD (HL),"1"+2', (54, 51)),
    ('LD A,1+"2"', (62, 51)),
    ('LD IXh,140-$07', (221, 38, 133)),
    ('LD IXl,(1+2)*3', (221, 46, 9)),
    ('LD (IX+1+3),49153/256', (221, 54, 4, 192)),
    ('LD IYh,%1111%100', (253, 38, 15)),
    ('LD IYl,64/$08', (253, 46, 8)),
    ('LD (IY+5-2),%11%%10', (253, 54, 3, 1)),
    ('LD BC,12345+6', (1, 63, 48)),
    ('LD DE,+(23456-8)/2', (17, 204, 45)),
    ('LD HL,34567+(8*9)', (33, 79, 135)),
    ('LD SP,$01+$100*$80', (49, 1, 128)),
    ('LD IX,-(100*%100000000)', (221, 33, 0, 156)),
    ('LD IY,45678%256+32768', (253, 33, 110, 128)),
    ('LD BC,(56789+1)', (237, 75, 214, 221)),
    ('LD DE,(33333+2*(8+3))', (237, 91, 75, 130)),
    ('LD HL,(44444-2)', (42, 154, 173)),
    ('LD SP,($abcd+$ef)', (237, 123, 188, 172)),
    ('LD IX,(17+$a0*256)', (221, 42, 17, 160)),
    ('LD IY,(100000/10)', (253, 42, 16, 39)),
    ('LD (49152-13),BC', (237, 67, 243, 191)),
    ('LD ($8000+$0F),DE', (237, 83, 15, 128)),
    ('LD (30000+12/4),HL', (34, 51, 117)),
    ('LD (40000+12*4),SP', (237, 115, 112, 156)),
    ('LD ((5+17)*319),IX', (221, 34, 106, 27)),
    ('LD (43*(108+56)),IY', (253, 34, 140, 27)),
    ('OR "5"+5', (246, 58)),
    ('OR 01+"1"', (246, 50)),
    ('SBC A,16/4', (222, 4)),
    ('SUB 13%5', (214, 3)),
    ('XOR (1+2)/3', (238, 1))
)

TRICKY_CHARACTER_OPERANDS = (
    ('ADC A,","', (206, 44)),
    ('ADD A,"\\""', (198, 34)),
    ('AND "\\\\"', (230, 92))
)

RELATIVE_JUMPS = (
    (65534, 'JR 2', (24, 2)),
    (0, 'DJNZ 65534', (16, 252)),
    (65407, 'JR Z,0', (40, 127)),
    (125, 'DJNZ 65535', (16, 128))
)

UNUSUAL_WHITESPACE = (
    ('LD ( HL ), 5', (54, 5)),
    ('LD B, ( HL )', (70,)),
    ('LD\tA, " "', (62, 32)),
    ('LD  A, ( 16384 )', (58, 0, 64)),
    ('LD C, ( IX + 0 )', (221, 78, 0)),
    ('LD\t( IX + 0 ), D', (221, 114, 0)),
    ('XOR\tE', (171,)),
    ('SUB (7+8)\t%10', (214, 5)),
    ('DEFB 5, "AB", 6,(3*4)\t%11', (5, 65, 66, 6, 1)),
    ('DEFW 1 , "," , 2', (1, 0, 44, 0, 2, 0)),
    ('DEFS 3, ","', (44, 44, 44))
)

DEFB_DEFM = (
    ('1,2', (1, 2)),
    ('"ABC"', (65, 66, 67)),
    ('"A",1', (65, 1)),
    (r'0,"\"A,\""', (0, 34, 65, 44, 34)),
    (r'"C:\\",12', (67, 58, 92, 12)),
    ('"",5,"a",""', (5, 97)),
    ('"1"+1,2+"2","3"+4+"5",3*$04', (50, 52, 108, 12)),
    ('%11/3,44444%256,(1+2) %10', (1, 156, 3)),
    ('256,1,1000,2,"23"+1,""+1', (0, 1, 0, 2, 0, 0)),
    ('1,x,2', (1, 0, 2)),
    ('-1,-$02,-%00000011', (255, 254, 253))
)

DEFW = (
    ('1,256,65535', (1, 0, 0, 1, 255, 255)),
    ('$01,$100,$ffff', (1, 0, 0, 1, 255, 255)),
    ('%101,%111111111', (5, 0, 255, 1)),
    ('"a",1', (97, 0, 1, 0)),
    (r'"\\",1', (92, 0, 1, 0)),
    ('120+5,"0"+$1000,23+45*256', (125, 0, 48, 16, 23, 45)),
    ('1,65536,2', (1, 0, 0, 0, 2, 0)),
    ('?,45', (0, 0, 45, 0)),
    ('-1,-$0002,-%1010101010101010', (255, 255, 254, 255, 86, 85))
)

DEFS = (
    ('3', (0, 0, 0)),
    ('3,1', (1, 1, 1)),
    ('$02,$02', (2, 2)),
    ('3,%01010101', (85, 85, 85)),
    ('2,"b"', (98, 98)),
    ('2*2,"0"+$80', (176, 176, 176, 176)),
    ('2,257', (0, 0)),
    ('65536,1', ()),
    ('$,4', ()),
    ('2,-1', (255, 255)),
    ('3,-$02', (254, 254, 254)),
    ('2,-%10011001', (103, 103))
)

class Z80Test(SkoolKitTestCase):
    def setUp(self):
        SkoolKitTestCase.setUp(self)
        self.longMessage = True

    def _test_operation(self, operation, exp_data, address):
        assembler = Assembler()
        data = assembler.assemble(operation, address)
        self.assertEqual(data, exp_data, "assemble('{}', {}) failed".format(operation, address))
        exp_length = len(data)
        length = assembler.get_size(operation, address)
        self.assertEqual(length, exp_length, "get_size('{}', {}) failed".format(operation, address))

    def _test_assembly(self, operation, exp_data=(), address=0, test_lower=False):
        self._test_operation(operation, exp_data, address)
        if test_lower:
            self._test_operation(operation.lower(), exp_data, address)

    def test_all_instructions(self):
        for operation, exp_data in OPERATIONS:
            self._test_assembly(operation, exp_data, 16384, True)

    def test_hexadecimal_operands(self):
        for operation, exp_data in HEXADECIMAL_OPERANDS:
            self._test_assembly(operation, exp_data, 16384, True)

    def test_binary_operands(self):
        for operation, exp_data in BINARY_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_negative_operands(self):
        for operation, exp_data in NEGATIVE_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_character_operands(self):
        for operation, exp_data in CHARACTER_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_zero_padded_operands(self):
        for operation, exp_data in ZERO_PADDED_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_arithmetic_expression_operands(self):
        for operation, exp_data in ARITHMETIC_EXPRESSION_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_tricky_character_operands(self):
        for operation, exp_data in TRICKY_CHARACTER_OPERANDS:
            self._test_assembly(operation, exp_data)

    def test_relative_jumps_across_64k_boundary(self):
        for address, operation, exp_data in RELATIVE_JUMPS:
            self._test_assembly(operation, exp_data, address)

    def test_unusual_whitespace(self):
        for operation, exp_data in UNUSUAL_WHITESPACE:
            self._test_assembly(operation, exp_data)

    def test_defb(self):
        for items, exp_data in DEFB_DEFM:
            self._test_assembly('DEFB {}'.format(items), exp_data)
            self._test_assembly('defb {}'.format(items), exp_data)

    def test_defm(self):
        for items, exp_data in DEFB_DEFM:
            self._test_assembly('DEFM {}'.format(items), exp_data)
            self._test_assembly('defm {}'.format(items), exp_data)

    def test_defw(self):
        for items, exp_data in DEFW:
            self._test_assembly('DEFW {}'.format(items), exp_data)
            self._test_assembly('defw {}'.format(items), exp_data)

    def test_defs(self):
        for items, exp_data in DEFS:
            self._test_assembly('DEFS {}'.format(items), exp_data)
            self._test_assembly('defs {}'.format(items), exp_data)

    def test_invalid_instructions(self):
        invalid_operations = (
            'IN A,0',
            'LD A,256',
            'JP 65536',
            'LD A,(IX*0)',
            'JR 130',
            'NEG A',
            'LD B,"12"',
            'IM -2',
            'BIT -4,C',
            'RES -3,D',
            'SET -2,E',
            'IN A,(-53)',
            'OUT (1-2),A',
            'RST -56',
            'XOR %21'
        )
        for operation in invalid_operations:
            self._test_assembly(operation)

    @patch.object(components, 'SK_CONFIG', None)
    def test_custom_operand_evaluator(self):
        custom_evaluator = """
            def eval_int(text):
                try:
                    return eval_string(text)[0]
                except ValueError:
                    return int(text[1:], 8)
            def eval_string(text):
                if text.startswith("'") and text.endswith("'"):
                    return [ord(c) for c in text[1:-1]]
                raise ValueError
            def split_operands(text):
                return text.split(',')
        """
        self.write_component_config('OperandEvaluator', '*', custom_evaluator)

        exp_values = (
            ('LD A,@10', (62, 8)),
            ("LD B,'B'", (6, 66)),
            ("DEFB @10,'AB'", (8, 65, 66))
        )
        for operation, exp_bytes in exp_values:
            self._test_assembly(operation, exp_bytes)
