# Copyright 2018, 2019 Richard Dymond (rjdymond@gmail.com)
#
# This file is part of SkoolKit.
#
# SkoolKit is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# SkoolKit is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# SkoolKit. If not, see <http://www.gnu.org/licenses/>.

# Maximum allowed instruction sequence lengths
C_ANY = 0 # Any length
C_INV = 1 # Disallowed (LD r,r)
C_ONE = 2 # Only one (e.g. LD r,n)
C_DEF = 5 # Up to 4 (default)
C_SAR = 8 # Up to 7 (shifts; rotates; ADD A,A; ADD HL,HL; 16-bit INCs/DECs)

END = 0x00C9
LD_R_R = 0x0040
LD_B = 0x0006
LD_C = 0x000E
LD_D = 0x0016
LD_E = 0x001E
LD_H = 0x0026
LD_L = 0x002E
LD__HL = 0x0036
LD_A = 0x003E
LD_BC = 0x0001
LD_DE = 0x0011
LD_HL = 0x0021
LD_SP = 0x0031
LD_IX = 0xDD21
LD_IY = 0xFD21
LD_XH = 0xDD26
LD_XL = 0xDD2E
LD_YH = 0xFD26
LD_YL = 0xFD2E
CP = 0x00FE
BIT = 0xCB40
JP_NZ = 0x0020
JP_Z = 0x0028
JP_NC = 0x0030
JP_C = 0x0038
IN_A = 0x00DB

OPCODES = {
    0x00: (1, C_DEF, 0x0000, 'NOP'),
    0x01: (3, C_ONE, LD_BC, 'LD BC,nn'),
    0x02: (1, C_ONE, 0x0002, 'LD (BC),A'),
    0x03: (1, C_SAR, 0x0003, 'INC BC'),
    0x04: (1, C_DEF, 0x0004, 'INC B'),
    0x05: (1, C_DEF, 0x0005, 'DEC B'),
    0x06: (2, C_ONE, LD_B, 'LD B,n'),
    0x07: (1, C_SAR, 0x0007, 'RLCA'),
    0x08: (1, C_ONE, 0x0008, "EX AF,AF'"),
    0x09: (1, C_DEF, 0x0009, 'ADD HL,BC'),
    0x0A: (1, C_ONE, LD_A, 'LD A,(BC)'),
    0x0B: (1, C_SAR, 0x000B, 'DEC BC'),
    0x0C: (1, C_DEF, 0x000C, 'INC C'),
    0x0D: (1, C_DEF, 0x000D, 'DEC C'),
    0x0E: (2, C_ONE, LD_C, 'LD C,n'),
    0x0F: (1, C_SAR, 0x000F, 'RRCA'),
    0x10: (2, C_ONE, 0x0010, 'DJNZ nn'),
    0x11: (3, C_ONE, LD_DE, 'LD DE,nn'),
    0x12: (1, C_ONE, 0x0012, 'LD (DE),A'),
    0x13: (1, C_SAR, 0x0013, 'INC DE'),
    0x14: (1, C_DEF, 0x0014, 'INC D'),
    0x15: (1, C_DEF, 0x0015, 'DEC D'),
    0x16: (2, C_ONE, LD_D, 'LD D,n'),
    0x17: (1, C_SAR, 0x0017, 'RLA'),
    0x18: (2, C_ONE, END, 'JR nn'),
    0x19: (1, C_DEF, 0x0019, 'ADD HL,DE'),
    0x1A: (1, C_ONE, LD_A, 'LD A,(DE)'),
    0x1B: (1, C_SAR, 0x001B, 'DEC DE'),
    0x1C: (1, C_DEF, 0x001C, 'INC E'),
    0x1D: (1, C_DEF, 0x001D, 'DEC E'),
    0x1E: (2, C_ONE, LD_E, 'LD E,n'),
    0x1F: (1, C_SAR, 0x001F, 'RRA'),
    0x20: (2, C_ONE, JP_NZ, 'JR NZ,nn'),
    0x21: (3, C_ONE, LD_HL, 'LD HL,nn'),
    0x22: (3, C_ANY, 0x0022, 'LD (nn),HL'),
    0x23: (1, C_SAR, 0x0023, 'INC HL'),
    0x24: (1, C_DEF, 0x0024, 'INC H'),
    0x25: (1, C_DEF, 0x0025, 'DEC H'),
    0x26: (2, C_ONE, LD_H, 'LD H,n'),
    0x27: (1, C_ONE, 0x0027, 'DAA'),
    0x28: (2, C_ONE, JP_Z, 'JR Z,nn'),
    0x29: (1, C_SAR, 0x0029, 'ADD HL,HL'),
    0x2A: (3, C_ONE, LD_HL, 'LD HL,(nn)'),
    0x2B: (1, C_SAR, 0x002B, 'DEC HL'),
    0x2C: (1, C_DEF, 0x002C, 'INC L'),
    0x2D: (1, C_DEF, 0x002D, 'DEC L'),
    0x2E: (2, C_ONE, LD_L, 'LD L,n'),
    0x2F: (1, C_ONE, 0x002F, 'CPL'),
    0x30: (2, C_ONE, JP_NC, 'JR NC,nn'),
    0x31: (3, C_ONE, LD_SP, 'LD SP,nn'),
    0x32: (3, C_ANY, 0x0032, 'LD (nn),A'),
    0x33: (1, C_SAR, 0x0033, 'INC SP'),
    0x34: (1, C_DEF, 0x0034, 'INC (HL)'),
    0x35: (1, C_DEF, 0x0035, 'DEC (HL)'),
    0x36: (2, C_ONE, LD__HL, 'LD (HL),n'),
    0x37: (1, C_ONE, 0x0037, 'SCF'),
    0x38: (2, C_ONE, JP_C, 'JR C,nn'),
    0x39: (1, C_DEF, 0x0039, 'ADD HL,SP'),
    0x3A: (3, C_ONE, LD_A, 'LD A,(nn)'),
    0x3B: (1, C_SAR, 0x003B, 'DEC SP'),
    0x3C: (1, C_DEF, 0x003C, 'INC A'),
    0x3D: (1, C_DEF, 0x003D, 'DEC A'),
    0x3E: (2, C_ONE, LD_A, 'LD A,n'),
    0x3F: (1, C_ONE, 0x003F, 'CCF'),
    0x40: (1, C_INV, LD_R_R, 'LD B,B'),
    0x41: (1, C_ONE, LD_B, 'LD B,C'),
    0x42: (1, C_ONE, LD_B, 'LD B,D'),
    0x43: (1, C_ONE, LD_B, 'LD B,E'),
    0x44: (1, C_ONE, LD_B, 'LD B,H'),
    0x45: (1, C_ONE, LD_B, 'LD B,L'),
    0x46: (1, C_ONE, LD_B, 'LD B,(HL)'),
    0x47: (1, C_ONE, LD_B, 'LD B,A'),
    0x48: (1, C_ONE, LD_C, 'LD C,B'),
    0x49: (1, C_INV, LD_R_R, 'LD C,C'),
    0x4A: (1, C_ONE, LD_C, 'LD C,D'),
    0x4B: (1, C_ONE, LD_C, 'LD C,E'),
    0x4C: (1, C_ONE, LD_C, 'LD C,H'),
    0x4D: (1, C_ONE, LD_C, 'LD C,L'),
    0x4E: (1, C_ONE, LD_C, 'LD C,(HL)'),
    0x4F: (1, C_ONE, LD_C, 'LD C,A'),
    0x50: (1, C_ONE, LD_D, 'LD D,B'),
    0x51: (1, C_ONE, LD_D, 'LD D,C'),
    0x52: (1, C_INV, LD_R_R, 'LD D,D'),
    0x53: (1, C_ONE, LD_D, 'LD D,E'),
    0x54: (1, C_ONE, LD_D, 'LD D,H'),
    0x55: (1, C_ONE, LD_D, 'LD D,L'),
    0x56: (1, C_ONE, LD_D, 'LD D,(HL)'),
    0x57: (1, C_ONE, LD_D, 'LD D,A'),
    0x58: (1, C_ONE, LD_E, 'LD E,B'),
    0x59: (1, C_ONE, LD_E, 'LD E,C'),
    0x5A: (1, C_ONE, LD_E, 'LD E,D'),
    0x5B: (1, C_INV, LD_R_R, 'LD E,E'),
    0x5C: (1, C_ONE, LD_E, 'LD E,H'),
    0x5D: (1, C_ONE, LD_E, 'LD E,L'),
    0x5E: (1, C_ONE, LD_E, 'LD E,(HL)'),
    0x5F: (1, C_ONE, LD_E, 'LD E,A'),
    0x60: (1, C_ONE, LD_H, 'LD H,B'),
    0x61: (1, C_ONE, LD_H, 'LD H,C'),
    0x62: (1, C_ONE, LD_H, 'LD H,D'),
    0x63: (1, C_ONE, LD_H, 'LD H,E'),
    0x64: (1, C_INV, LD_R_R, 'LD H,H'),
    0x65: (1, C_ONE, LD_H, 'LD H,L'),
    0x66: (1, C_ONE, LD_H, 'LD H,(HL)'),
    0x67: (1, C_ONE, LD_H, 'LD H,A'),
    0x68: (1, C_ONE, LD_L, 'LD L,B'),
    0x69: (1, C_ONE, LD_L, 'LD L,C'),
    0x6A: (1, C_ONE, LD_L, 'LD L,D'),
    0x6B: (1, C_ONE, LD_L, 'LD L,E'),
    0x6C: (1, C_ONE, LD_L, 'LD L,H'),
    0x6D: (1, C_INV, LD_R_R, 'LD L,L'),
    0x6E: (1, C_ONE, LD_L, 'LD L,(HL)'),
    0x6F: (1, C_ONE, LD_L, 'LD L,A'),
    0x70: (1, C_ONE, LD__HL, 'LD (HL),B'),
    0x71: (1, C_ONE, LD__HL, 'LD (HL),C'),
    0x72: (1, C_ONE, LD__HL, 'LD (HL),D'),
    0x73: (1, C_ONE, LD__HL, 'LD (HL),E'),
    0x74: (1, C_ONE, LD__HL, 'LD (HL),H'),
    0x75: (1, C_ONE, LD__HL, 'LD (HL),L'),
    0x76: (1, C_DEF, 0x0076, 'HALT'),
    0x77: (1, C_ONE, LD__HL, 'LD (HL),A'),
    0x78: (1, C_ONE, LD_A, 'LD A,B'),
    0x79: (1, C_ONE, LD_A, 'LD A,C'),
    0x7A: (1, C_ONE, LD_A, 'LD A,D'),
    0x7B: (1, C_ONE, LD_A, 'LD A,E'),
    0x7C: (1, C_ONE, LD_A, 'LD A,H'),
    0x7D: (1, C_ONE, LD_A, 'LD A,L'),
    0x7E: (1, C_ONE, LD_A, 'LD A,(HL)'),
    0x7F: (1, C_INV, LD_R_R, 'LD A,A'),
    0x80: (1, C_DEF, 0x0080, 'ADD A,B'),
    0x81: (1, C_DEF, 0x0081, 'ADD A,C'),
    0x82: (1, C_DEF, 0x0082, 'ADD A,D'),
    0x83: (1, C_DEF, 0x0083, 'ADD A,E'),
    0x84: (1, C_DEF, 0x0084, 'ADD A,H'),
    0x85: (1, C_DEF, 0x0085, 'ADD A,L'),
    0x86: (1, C_DEF, 0x0086, 'ADD A,(HL)'),
    0x87: (1, C_SAR, 0x0087, 'ADD A,A'),
    0x88: (1, C_DEF, 0x0088, 'ADC A,B'),
    0x89: (1, C_DEF, 0x0089, 'ADC A,C'),
    0x8A: (1, C_DEF, 0x008A, 'ADC A,D'),
    0x8B: (1, C_DEF, 0x008B, 'ADC A,E'),
    0x8C: (1, C_DEF, 0x008C, 'ADC A,H'),
    0x8D: (1, C_DEF, 0x008D, 'ADC A,L'),
    0x8E: (1, C_DEF, 0x008E, 'ADC A,(HL)'),
    0x8F: (1, C_DEF, 0x008F, 'ADC A,A'),
    0x90: (1, C_DEF, 0x0090, 'SUB B'),
    0x91: (1, C_DEF, 0x0091, 'SUB C'),
    0x92: (1, C_DEF, 0x0092, 'SUB D'),
    0x93: (1, C_DEF, 0x0093, 'SUB E'),
    0x94: (1, C_DEF, 0x0094, 'SUB H'),
    0x95: (1, C_DEF, 0x0095, 'SUB L'),
    0x96: (1, C_DEF, 0x0096, 'SUB (HL)'),
    0x97: (1, C_ONE, 0x0097, 'SUB A'),
    0x98: (1, C_DEF, 0x0098, 'SBC A,B'),
    0x99: (1, C_DEF, 0x0099, 'SBC A,C'),
    0x9A: (1, C_DEF, 0x009A, 'SBC A,D'),
    0x9B: (1, C_DEF, 0x009B, 'SBC A,E'),
    0x9C: (1, C_DEF, 0x009C, 'SBC A,H'),
    0x9D: (1, C_DEF, 0x009D, 'SBC A,L'),
    0x9E: (1, C_DEF, 0x009E, 'SBC A,(HL)'),
    0x9F: (1, C_ONE, 0x009F, 'SBC A,A'),
    0xA0: (1, C_ONE, 0x00A0, 'AND B'),
    0xA1: (1, C_ONE, 0x00A1, 'AND C'),
    0xA2: (1, C_ONE, 0x00A2, 'AND D'),
    0xA3: (1, C_ONE, 0x00A3, 'AND E'),
    0xA4: (1, C_ONE, 0x00A4, 'AND H'),
    0xA5: (1, C_ONE, 0x00A5, 'AND L'),
    0xA6: (1, C_ONE, 0x00A6, 'AND (HL)'),
    0xA7: (1, C_ONE, 0x00A7, 'AND A'),
    0xA8: (1, C_ONE, 0x00A8, 'XOR B'),
    0xA9: (1, C_ONE, 0x00A9, 'XOR C'),
    0xAA: (1, C_ONE, 0x00AA, 'XOR D'),
    0xAB: (1, C_ONE, 0x00AB, 'XOR E'),
    0xAC: (1, C_ONE, 0x00AC, 'XOR H'),
    0xAD: (1, C_ONE, 0x00AD, 'XOR L'),
    0xAE: (1, C_ONE, 0x00AE, 'XOR (HL)'),
    0xAF: (1, C_ONE, 0x00AF, 'XOR A'),
    0xB0: (1, C_ONE, 0x00B0, 'OR B'),
    0xB1: (1, C_ONE, 0x00B1, 'OR C'),
    0xB2: (1, C_ONE, 0x00B2, 'OR D'),
    0xB3: (1, C_ONE, 0x00B3, 'OR E'),
    0xB4: (1, C_ONE, 0x00B4, 'OR H'),
    0xB5: (1, C_ONE, 0x00B5, 'OR L'),
    0xB6: (1, C_ONE, 0x00B6, 'OR (HL)'),
    0xB7: (1, C_ONE, 0x00B7, 'OR A'),
    0xB8: (1, C_ONE, CP, 'CP B'),
    0xB9: (1, C_ONE, CP, 'CP C'),
    0xBA: (1, C_ONE, CP, 'CP D'),
    0xBB: (1, C_ONE, CP, 'CP E'),
    0xBC: (1, C_ONE, CP, 'CP H'),
    0xBD: (1, C_ONE, CP, 'CP L'),
    0xBE: (1, C_ONE, CP, 'CP (HL)'),
    0xBF: (1, C_ONE, CP, 'CP A'),
    0xC0: (1, C_ONE, 0x00C0, 'RET NZ'),
    0xC1: (1, C_DEF, 0x00C1, 'POP BC'),
    0xC2: (3, C_ONE, JP_NZ, 'JP NZ,nn'),
    0xC3: (3, C_ONE, END, 'JP nn'),
    0xC4: (3, C_ANY, 0x00C4, 'CALL NZ,nn'),
    0xC5: (1, C_DEF, 0x00C5, 'PUSH BC'),
    0xC6: (2, C_ONE, 0x00C6, 'ADD A,n'),
    0xC7: (1, C_DEF, 0x00C7, 'RST 0'),
    0xC8: (1, C_ONE, 0x00C8, 'RET Z'),
    0xC9: (1, C_ONE, END, 'RET'),
    0xCA: (3, C_ONE, JP_Z, 'JP Z,nn'),
    0xCC: (3, C_ANY, 0x00CC, 'CALL Z,nn'),
    0xCD: (3, C_ANY, 0x00CD, 'CALL nn'),
    0xCE: (2, C_ONE, 0x00CE, 'ADC A,n'),
    0xCF: (1, C_DEF, 0x00CF, 'RST 8'),
    0xD0: (1, C_ONE, 0x00D0, 'RET NC'),
    0xD1: (1, C_DEF, 0x00D1, 'POP DE'),
    0xD2: (3, C_ONE, JP_NC, 'JP NC,nn'),
    0xD3: (2, C_ANY, 0x00D3, 'OUT (n),A'),
    0xD4: (3, C_ANY, 0x00D4, 'CALL NC,nn'),
    0xD5: (1, C_DEF, 0x00D5, 'PUSH DE'),
    0xD6: (2, C_ONE, 0x00D6, 'SUB n'),
    0xD7: (1, C_DEF, 0x00D7, 'RST 16'),
    0xD8: (1, C_ONE, 0x00D8, 'RET C'),
    0xD9: (1, C_ONE, 0x00D9, 'EXX'),
    0xDA: (3, C_ONE, JP_C, 'JP C,nn'),
    0xDB: (2, C_ONE, IN_A, 'IN A,(n)'),
    0xDC: (3, C_ANY, 0x00DC, 'CALL C,nn'),
    0xDE: (2, C_ONE, 0x00DE, 'SBC A,n'),
    0xDF: (1, C_DEF, 0x00DF, 'RST 24'),
    0xE0: (1, C_ONE, 0x00E0, 'RET PO'),
    0xE1: (1, C_DEF, 0x00E1, 'POP HL'),
    0xE2: (3, C_ONE, 0x00E2, 'JP PO,nn'),
    0xE3: (1, C_ONE, 0x00E3, 'EX (SP),HL'),
    0xE4: (3, C_ANY, 0x00E4, 'CALL PO,nn'),
    0xE5: (1, C_DEF, 0x00E5, 'PUSH HL'),
    0xE6: (2, C_ONE, 0x00E6, 'AND n'),
    0xE7: (1, C_DEF, 0x00E7, 'RST 32'),
    0xE8: (1, C_ONE, 0x00E8, 'RET PE'),
    0xE9: (1, C_ONE, END, 'JP (HL)'),
    0xEA: (3, C_ONE, 0x00EA, 'JP PE,nn'),
    0xEB: (1, C_ONE, 0x00EB, 'EX DE,HL'),
    0xEC: (3, C_ANY, 0x00EC, 'CALL PE,nn'),
    0xEE: (2, C_ONE, 0x00EE, 'XOR n'),
    0xEF: (1, C_DEF, 0x00EF, 'RST 40'),
    0xF0: (1, C_ONE, 0x00F0, 'RET P'),
    0xF1: (1, C_DEF, 0x00F1, 'POP AF'),
    0xF2: (3, C_ONE, 0x00F2, 'JP P,n'),
    0xF3: (1, C_ONE, 0x00F3, 'DI'),
    0xF4: (3, C_ANY, 0x00F4, 'CALL P,n'),
    0xF5: (1, C_DEF, 0x00F5, 'PUSH AF'),
    0xF6: (2, C_ONE, 0x00F6, 'OR n'),
    0xF7: (1, C_DEF, 0x00F7, 'RST 48'),
    0xF8: (1, C_ONE, 0x00F8, 'RET M'),
    0xF9: (1, C_ONE, LD_SP, 'LD SP,HL'),
    0xFA: (3, C_ONE, 0x00FA, 'JP M,nn'),
    0xFB: (1, C_ONE, 0x00FB, 'EI'),
    0xFC: (3, C_ANY, 0x00FC, 'CALL M,nn'),
    0xFE: (2, C_ONE, CP, 'CP n'),
    0xFF: (1, C_DEF, 0x00FF, 'RST 56')
}

AFTER_CB = {
    0x00: (2, C_SAR, 0xCB00, 'RLC B'),
    0x01: (2, C_SAR, 0xCB01, 'RLC C'),
    0x02: (2, C_SAR, 0xCB02, 'RLC D'),
    0x03: (2, C_SAR, 0xCB03, 'RLC E'),
    0x04: (2, C_SAR, 0xCB04, 'RLC H'),
    0x05: (2, C_SAR, 0xCB05, 'RLC L'),
    0x06: (2, C_SAR, 0xCB06, 'RLC (HL)'),
    0x07: (2, C_SAR, 0xCB07, 'RLC A'),
    0x08: (2, C_SAR, 0xCB08, 'RRC B'),
    0x09: (2, C_SAR, 0xCB09, 'RRC C'),
    0x0A: (2, C_SAR, 0xCB0A, 'RRC D'),
    0x0B: (2, C_SAR, 0xCB0B, 'RRC E'),
    0x0C: (2, C_SAR, 0xCB0C, 'RRC H'),
    0x0D: (2, C_SAR, 0xCB0D, 'RRC L'),
    0x0E: (2, C_SAR, 0xCB0E, 'RRC (HL)'),
    0x0F: (2, C_SAR, 0xCB0F, 'RRC A'),
    0x10: (2, C_SAR, 0xCB10, 'RL B'),
    0x11: (2, C_SAR, 0xCB11, 'RL C'),
    0x12: (2, C_SAR, 0xCB12, 'RL D'),
    0x13: (2, C_SAR, 0xCB13, 'RL E'),
    0x14: (2, C_SAR, 0xCB14, 'RL H'),
    0x15: (2, C_SAR, 0xCB15, 'RL L'),
    0x16: (2, C_SAR, 0xCB16, 'RL (HL)'),
    0x17: (2, C_SAR, 0xCB17, 'RL A'),
    0x18: (2, C_SAR, 0xCB18, 'RR B'),
    0x19: (2, C_SAR, 0xCB19, 'RR C'),
    0x1A: (2, C_SAR, 0xCB1A, 'RR D'),
    0x1B: (2, C_SAR, 0xCB1B, 'RR E'),
    0x1C: (2, C_SAR, 0xCB1C, 'RR H'),
    0x1D: (2, C_SAR, 0xCB1D, 'RR L'),
    0x1E: (2, C_SAR, 0xCB1E, 'RR (HL)'),
    0x1F: (2, C_SAR, 0xCB1F, 'RR A'),
    0x20: (2, C_SAR, 0xCB20, 'SLA B'),
    0x21: (2, C_SAR, 0xCB21, 'SLA C'),
    0x22: (2, C_SAR, 0xCB22, 'SLA D'),
    0x23: (2, C_SAR, 0xCB23, 'SLA E'),
    0x24: (2, C_SAR, 0xCB24, 'SLA H'),
    0x25: (2, C_SAR, 0xCB25, 'SLA L'),
    0x26: (2, C_SAR, 0xCB26, 'SLA (HL)'),
    0x27: (2, C_SAR, 0xCB27, 'SLA A'),
    0x28: (2, C_SAR, 0xCB28, 'SRA B'),
    0x29: (2, C_SAR, 0xCB29, 'SRA C'),
    0x2A: (2, C_SAR, 0xCB2A, 'SRA D'),
    0x2B: (2, C_SAR, 0xCB2B, 'SRA E'),
    0x2C: (2, C_SAR, 0xCB2C, 'SRA H'),
    0x2D: (2, C_SAR, 0xCB2D, 'SRA L'),
    0x2E: (2, C_SAR, 0xCB2E, 'SRA (HL)'),
    0x2F: (2, C_SAR, 0xCB2F, 'SRA A'),
    0x30: (2, C_SAR, 0xCB30, 'SLL B'),
    0x31: (2, C_SAR, 0xCB31, 'SLL C'),
    0x32: (2, C_SAR, 0xCB32, 'SLL D'),
    0x33: (2, C_SAR, 0xCB33, 'SLL E'),
    0x34: (2, C_SAR, 0xCB34, 'SLL H'),
    0x35: (2, C_SAR, 0xCB35, 'SLL L'),
    0x36: (2, C_SAR, 0xCB36, 'SLL (HL)'),
    0x37: (2, C_SAR, 0xCB37, 'SLL A'),
    0x38: (2, C_SAR, 0xCB38, 'SRL B'),
    0x39: (2, C_SAR, 0xCB39, 'SRL C'),
    0x3A: (2, C_SAR, 0xCB3A, 'SRL D'),
    0x3B: (2, C_SAR, 0xCB3B, 'SRL E'),
    0x3C: (2, C_SAR, 0xCB3C, 'SRL H'),
    0x3D: (2, C_SAR, 0xCB3D, 'SRL L'),
    0x3E: (2, C_SAR, 0xCB3E, 'SRL (HL)'),
    0x3F: (2, C_SAR, 0xCB3F, 'SRL A'),
    0x40: (2, C_ONE, BIT, 'BIT 0,B'),
    0x41: (2, C_ONE, BIT, 'BIT 0,C'),
    0x42: (2, C_ONE, BIT, 'BIT 0,D'),
    0x43: (2, C_ONE, BIT, 'BIT 0,E'),
    0x44: (2, C_ONE, BIT, 'BIT 0,H'),
    0x45: (2, C_ONE, BIT, 'BIT 0,L'),
    0x46: (2, C_ONE, BIT, 'BIT 0,(HL)'),
    0x47: (2, C_ONE, BIT, 'BIT 0,A'),
    0x48: (2, C_ONE, BIT, 'BIT 1,B'),
    0x49: (2, C_ONE, BIT, 'BIT 1,C'),
    0x4A: (2, C_ONE, BIT, 'BIT 1,D'),
    0x4B: (2, C_ONE, BIT, 'BIT 1,E'),
    0x4C: (2, C_ONE, BIT, 'BIT 1,H'),
    0x4D: (2, C_ONE, BIT, 'BIT 1,L'),
    0x4E: (2, C_ONE, BIT, 'BIT 1,(HL)'),
    0x4F: (2, C_ONE, BIT, 'BIT 1,A'),
    0x50: (2, C_ONE, BIT, 'BIT 2,B'),
    0x51: (2, C_ONE, BIT, 'BIT 2,C'),
    0x52: (2, C_ONE, BIT, 'BIT 2,D'),
    0x53: (2, C_ONE, BIT, 'BIT 2,E'),
    0x54: (2, C_ONE, BIT, 'BIT 2,H'),
    0x55: (2, C_ONE, BIT, 'BIT 2,L'),
    0x56: (2, C_ONE, BIT, 'BIT 2,(HL)'),
    0x57: (2, C_ONE, BIT, 'BIT 2,A'),
    0x58: (2, C_ONE, BIT, 'BIT 3,B'),
    0x59: (2, C_ONE, BIT, 'BIT 3,C'),
    0x5A: (2, C_ONE, BIT, 'BIT 3,D'),
    0x5B: (2, C_ONE, BIT, 'BIT 3,E'),
    0x5C: (2, C_ONE, BIT, 'BIT 3,H'),
    0x5D: (2, C_ONE, BIT, 'BIT 3,L'),
    0x5E: (2, C_ONE, BIT, 'BIT 3,(HL)'),
    0x5F: (2, C_ONE, BIT, 'BIT 3,A'),
    0x60: (2, C_ONE, BIT, 'BIT 4,B'),
    0x61: (2, C_ONE, BIT, 'BIT 4,C'),
    0x62: (2, C_ONE, BIT, 'BIT 4,D'),
    0x63: (2, C_ONE, BIT, 'BIT 4,E'),
    0x64: (2, C_ONE, BIT, 'BIT 4,H'),
    0x65: (2, C_ONE, BIT, 'BIT 4,L'),
    0x66: (2, C_ONE, BIT, 'BIT 4,(HL)'),
    0x67: (2, C_ONE, BIT, 'BIT 4,A'),
    0x68: (2, C_ONE, BIT, 'BIT 5,B'),
    0x69: (2, C_ONE, BIT, 'BIT 5,C'),
    0x6A: (2, C_ONE, BIT, 'BIT 5,D'),
    0x6B: (2, C_ONE, BIT, 'BIT 5,E'),
    0x6C: (2, C_ONE, BIT, 'BIT 5,H'),
    0x6D: (2, C_ONE, BIT, 'BIT 5,L'),
    0x6E: (2, C_ONE, BIT, 'BIT 5,(HL)'),
    0x6F: (2, C_ONE, BIT, 'BIT 5,A'),
    0x70: (2, C_ONE, BIT, 'BIT 6,B'),
    0x71: (2, C_ONE, BIT, 'BIT 6,C'),
    0x72: (2, C_ONE, BIT, 'BIT 6,D'),
    0x73: (2, C_ONE, BIT, 'BIT 6,E'),
    0x74: (2, C_ONE, BIT, 'BIT 6,H'),
    0x75: (2, C_ONE, BIT, 'BIT 6,L'),
    0x76: (2, C_ONE, BIT, 'BIT 6,(HL)'),
    0x77: (2, C_ONE, BIT, 'BIT 6,A'),
    0x78: (2, C_ONE, BIT, 'BIT 7,B'),
    0x79: (2, C_ONE, BIT, 'BIT 7,C'),
    0x7A: (2, C_ONE, BIT, 'BIT 7,D'),
    0x7B: (2, C_ONE, BIT, 'BIT 7,E'),
    0x7C: (2, C_ONE, BIT, 'BIT 7,H'),
    0x7D: (2, C_ONE, BIT, 'BIT 7,L'),
    0x7E: (2, C_ONE, BIT, 'BIT 7,(HL)'),
    0x7F: (2, C_ONE, BIT, 'BIT 7,A'),
    0x80: (2, C_ONE, 0xCB80, 'RES 0,B'),
    0x81: (2, C_ONE, 0xCB81, 'RES 0,C'),
    0x82: (2, C_ONE, 0xCB82, 'RES 0,D'),
    0x83: (2, C_ONE, 0xCB83, 'RES 0,E'),
    0x84: (2, C_ONE, 0xCB84, 'RES 0,H'),
    0x85: (2, C_ONE, 0xCB85, 'RES 0,L'),
    0x86: (2, C_ONE, 0xCB86, 'RES 0,(HL)'),
    0x87: (2, C_ONE, 0xCB87, 'RES 0,A'),
    0x88: (2, C_ONE, 0xCB88, 'RES 1,B'),
    0x89: (2, C_ONE, 0xCB89, 'RES 1,C'),
    0x8A: (2, C_ONE, 0xCB8A, 'RES 1,D'),
    0x8B: (2, C_ONE, 0xCB8B, 'RES 1,E'),
    0x8C: (2, C_ONE, 0xCB8C, 'RES 1,H'),
    0x8D: (2, C_ONE, 0xCB8D, 'RES 1,L'),
    0x8E: (2, C_ONE, 0xCB8E, 'RES 1,(HL)'),
    0x8F: (2, C_ONE, 0xCB8F, 'RES 1,A'),
    0x90: (2, C_ONE, 0xCB90, 'RES 2,B'),
    0x91: (2, C_ONE, 0xCB91, 'RES 2,C'),
    0x92: (2, C_ONE, 0xCB92, 'RES 2,D'),
    0x93: (2, C_ONE, 0xCB93, 'RES 2,E'),
    0x94: (2, C_ONE, 0xCB94, 'RES 2,H'),
    0x95: (2, C_ONE, 0xCB95, 'RES 2,L'),
    0x96: (2, C_ONE, 0xCB96, 'RES 2,(HL)'),
    0x97: (2, C_ONE, 0xCB97, 'RES 2,A'),
    0x98: (2, C_ONE, 0xCB98, 'RES 3,B'),
    0x99: (2, C_ONE, 0xCB99, 'RES 3,C'),
    0x9A: (2, C_ONE, 0xCB9A, 'RES 3,D'),
    0x9B: (2, C_ONE, 0xCB9B, 'RES 3,E'),
    0x9C: (2, C_ONE, 0xCB9C, 'RES 3,H'),
    0x9D: (2, C_ONE, 0xCB9D, 'RES 3,L'),
    0x9E: (2, C_ONE, 0xCB9E, 'RES 3,(HL)'),
    0x9F: (2, C_ONE, 0xCB9F, 'RES 3,A'),
    0xA0: (2, C_ONE, 0xCBA0, 'RES 4,B'),
    0xA1: (2, C_ONE, 0xCBA1, 'RES 4,C'),
    0xA2: (2, C_ONE, 0xCBA2, 'RES 4,D'),
    0xA3: (2, C_ONE, 0xCBA3, 'RES 4,E'),
    0xA4: (2, C_ONE, 0xCBA4, 'RES 4,H'),
    0xA5: (2, C_ONE, 0xCBA5, 'RES 4,L'),
    0xA6: (2, C_ONE, 0xCBA6, 'RES 4,(HL)'),
    0xA7: (2, C_ONE, 0xCBA7, 'RES 4,A'),
    0xA8: (2, C_ONE, 0xCBA8, 'RES 5,B'),
    0xA9: (2, C_ONE, 0xCBA9, 'RES 5,C'),
    0xAA: (2, C_ONE, 0xCBAA, 'RES 5,D'),
    0xAB: (2, C_ONE, 0xCBAB, 'RES 5,E'),
    0xAC: (2, C_ONE, 0xCBAC, 'RES 5,H'),
    0xAD: (2, C_ONE, 0xCBAD, 'RES 5,L'),
    0xAE: (2, C_ONE, 0xCBAE, 'RES 5,(HL)'),
    0xAF: (2, C_ONE, 0xCBAF, 'RES 5,A'),
    0xB0: (2, C_ONE, 0xCBB0, 'RES 6,B'),
    0xB1: (2, C_ONE, 0xCBB1, 'RES 6,C'),
    0xB2: (2, C_ONE, 0xCBB2, 'RES 6,D'),
    0xB3: (2, C_ONE, 0xCBB3, 'RES 6,E'),
    0xB4: (2, C_ONE, 0xCBB4, 'RES 6,H'),
    0xB5: (2, C_ONE, 0xCBB5, 'RES 6,L'),
    0xB6: (2, C_ONE, 0xCBB6, 'RES 6,(HL)'),
    0xB7: (2, C_ONE, 0xCBB7, 'RES 6,A'),
    0xB8: (2, C_ONE, 0xCBB8, 'RES 7,B'),
    0xB9: (2, C_ONE, 0xCBB9, 'RES 7,C'),
    0xBA: (2, C_ONE, 0xCBBA, 'RES 7,D'),
    0xBB: (2, C_ONE, 0xCBBB, 'RES 7,E'),
    0xBC: (2, C_ONE, 0xCBBC, 'RES 7,H'),
    0xBD: (2, C_ONE, 0xCBBD, 'RES 7,L'),
    0xBE: (2, C_ONE, 0xCBBE, 'RES 7,(HL)'),
    0xBF: (2, C_ONE, 0xCBBF, 'RES 7,A'),
    0xC0: (2, C_ONE, 0xCBC0, 'SET 0,B'),
    0xC1: (2, C_ONE, 0xCBC1, 'SET 0,C'),
    0xC2: (2, C_ONE, 0xCBC2, 'SET 0,D'),
    0xC3: (2, C_ONE, 0xCBC3, 'SET 0,E'),
    0xC4: (2, C_ONE, 0xCBC4, 'SET 0,H'),
    0xC5: (2, C_ONE, 0xCBC5, 'SET 0,L'),
    0xC6: (2, C_ONE, 0xCBC6, 'SET 0,(HL)'),
    0xC7: (2, C_ONE, 0xCBC7, 'SET 0,A'),
    0xC8: (2, C_ONE, 0xCBC8, 'SET 1,B'),
    0xC9: (2, C_ONE, 0xCBC9, 'SET 1,C'),
    0xCA: (2, C_ONE, 0xCBCA, 'SET 1,D'),
    0xCB: (2, C_ONE, 0xCBCB, 'SET 1,E'),
    0xCC: (2, C_ONE, 0xCBCC, 'SET 1,H'),
    0xCD: (2, C_ONE, 0xCBCD, 'SET 1,L'),
    0xCE: (2, C_ONE, 0xCBCE, 'SET 1,(HL)'),
    0xCF: (2, C_ONE, 0xCBCF, 'SET 1,A'),
    0xD0: (2, C_ONE, 0xCBD0, 'SET 2,B'),
    0xD1: (2, C_ONE, 0xCBD1, 'SET 2,C'),
    0xD2: (2, C_ONE, 0xCBD2, 'SET 2,D'),
    0xD3: (2, C_ONE, 0xCBD3, 'SET 2,E'),
    0xD4: (2, C_ONE, 0xCBD4, 'SET 2,H'),
    0xD5: (2, C_ONE, 0xCBD5, 'SET 2,L'),
    0xD6: (2, C_ONE, 0xCBD6, 'SET 2,(HL)'),
    0xD7: (2, C_ONE, 0xCBD7, 'SET 2,A'),
    0xD8: (2, C_ONE, 0xCBD8, 'SET 3,B'),
    0xD9: (2, C_ONE, 0xCBD9, 'SET 3,C'),
    0xDA: (2, C_ONE, 0xCBDA, 'SET 3,D'),
    0xDB: (2, C_ONE, 0xCBDB, 'SET 3,E'),
    0xDC: (2, C_ONE, 0xCBDC, 'SET 3,H'),
    0xDD: (2, C_ONE, 0xCBDD, 'SET 3,L'),
    0xDE: (2, C_ONE, 0xCBDE, 'SET 3,(HL)'),
    0xDF: (2, C_ONE, 0xCBDF, 'SET 3,A'),
    0xE0: (2, C_ONE, 0xCBE0, 'SET 4,B'),
    0xE1: (2, C_ONE, 0xCBE1, 'SET 4,C'),
    0xE2: (2, C_ONE, 0xCBE2, 'SET 4,D'),
    0xE3: (2, C_ONE, 0xCBE3, 'SET 4,E'),
    0xE4: (2, C_ONE, 0xCBE4, 'SET 4,H'),
    0xE5: (2, C_ONE, 0xCBE5, 'SET 4,L'),
    0xE6: (2, C_ONE, 0xCBE6, 'SET 4,(HL)'),
    0xE7: (2, C_ONE, 0xCBE7, 'SET 4,A'),
    0xE8: (2, C_ONE, 0xCBE8, 'SET 5,B'),
    0xE9: (2, C_ONE, 0xCBE9, 'SET 5,C'),
    0xEA: (2, C_ONE, 0xCBEA, 'SET 5,D'),
    0xEB: (2, C_ONE, 0xCBEB, 'SET 5,E'),
    0xEC: (2, C_ONE, 0xCBEC, 'SET 5,H'),
    0xED: (2, C_ONE, 0xCBED, 'SET 5,L'),
    0xEE: (2, C_ONE, 0xCBEE, 'SET 5,(HL)'),
    0xEF: (2, C_ONE, 0xCBEF, 'SET 5,A'),
    0xF0: (2, C_ONE, 0xCBF0, 'SET 6,B'),
    0xF1: (2, C_ONE, 0xCBF1, 'SET 6,C'),
    0xF2: (2, C_ONE, 0xCBF2, 'SET 6,D'),
    0xF3: (2, C_ONE, 0xCBF3, 'SET 6,E'),
    0xF4: (2, C_ONE, 0xCBF4, 'SET 6,H'),
    0xF5: (2, C_ONE, 0xCBF5, 'SET 6,L'),
    0xF6: (2, C_ONE, 0xCBF6, 'SET 6,(HL)'),
    0xF7: (2, C_ONE, 0xCBF7, 'SET 6,A'),
    0xF8: (2, C_ONE, 0xCBF8, 'SET 7,B'),
    0xF9: (2, C_ONE, 0xCBF9, 'SET 7,C'),
    0xFA: (2, C_ONE, 0xCBFA, 'SET 7,D'),
    0xFB: (2, C_ONE, 0xCBFB, 'SET 7,E'),
    0xFC: (2, C_ONE, 0xCBFC, 'SET 7,H'),
    0xFD: (2, C_ONE, 0xCBFD, 'SET 7,L'),
    0xFE: (2, C_ONE, 0xCBFE, 'SET 7,(HL)'),
    0xFF: (2, C_ONE, 0xCBFF, 'SET 7,A')
}

AFTER_DD = {
    0x09: (2, C_DEF, 0xDD09, 'ADD IX,BC'),
    0x19: (2, C_DEF, 0xDD19, 'ADD IX,DE'),
    0x21: (4, C_ONE, LD_IX, 'LD IX,nn'),
    0x22: (4, C_ANY, 0xDD22, 'LD (nn),IX'),
    0x23: (2, C_SAR, 0xDD23, 'INC IX'),
    0x24: (2, C_DEF, 0xDD24, 'INC IXh'),
    0x25: (2, C_DEF, 0xDD25, 'DEC IXh'),
    0x26: (3, C_ONE, LD_XH, 'LD IXh,n'),
    0x29: (2, C_DEF, 0xDD29, 'ADD IX,IX'),
    0x2A: (4, C_ONE, LD_IX, 'LD IX,(nn)'),
    0x2B: (2, C_SAR, 0xDD2B, 'DEC IX'),
    0x2C: (2, C_DEF, 0xDD2C, 'INC IXl'),
    0x2D: (2, C_DEF, 0xDD2D, 'DEC IXl'),
    0x2E: (3, C_ONE, LD_XL, 'LD IXl,n'),
    0x34: (3, C_DEF, 0xDD34, 'INC (IX+d)'),
    0x35: (3, C_DEF, 0xDD35, 'DEC (IX+d)'),
    0x36: (4, C_ANY, 0xDD36, 'LD (IX+d),n'),
    0x39: (2, C_DEF, 0xDD39, 'ADD IX,SP'),
    0x44: (2, C_ONE, LD_B, 'LD B,IXh'),
    0x45: (2, C_ONE, LD_B, 'LD B,IXl'),
    0x46: (3, C_ONE, LD_B, 'LD B,(IX+d)'),
    0x4C: (2, C_ONE, LD_C, 'LD C,IXh'),
    0x4D: (2, C_ONE, LD_C, 'LD C,IXl'),
    0x4E: (3, C_ONE, LD_C, 'LD C,(IX+d)'),
    0x54: (2, C_ONE, LD_D, 'LD D,IXh'),
    0x55: (2, C_ONE, LD_D, 'LD D,IXl'),
    0x56: (3, C_ONE, LD_D, 'LD D,(IX+d)'),
    0x5C: (2, C_ONE, LD_E, 'LD E,IXh'),
    0x5D: (2, C_ONE, LD_E, 'LD E,IXl'),
    0x5E: (3, C_ONE, LD_E, 'LD E,(IX+d)'),
    0x60: (2, C_ONE, LD_XH, 'LD IXh,B'),
    0x61: (2, C_ONE, LD_XH, 'LD IXh,C'),
    0x62: (2, C_ONE, LD_XH, 'LD IXh,D'),
    0x63: (2, C_ONE, LD_XH, 'LD IXh,E'),
    0x64: (2, C_INV, LD_R_R, 'LD IXh,IXh'),
    0x65: (2, C_ONE, LD_XH, 'LD IXh,IXl'),
    0x66: (3, C_ONE, LD_H, 'LD H,(IX+d)'),
    0x67: (2, C_ONE, LD_XH, 'LD IXh,A'),
    0x68: (2, C_ONE, LD_XL, 'LD IXl,B'),
    0x69: (2, C_ONE, LD_XL, 'LD IXl,C'),
    0x6A: (2, C_ONE, LD_XL, 'LD IXl,D'),
    0x6B: (2, C_ONE, LD_XL, 'LD IXl,E'),
    0x6C: (2, C_ONE, LD_XL, 'LD IXl,IXh'),
    0x6D: (2, C_INV, LD_R_R, 'LD IXl,IXl'),
    0x6E: (3, C_ONE, LD_L, 'LD L,(IX+d)'),
    0x6F: (2, C_ONE, LD_XL, 'LD IXl,A'),
    0x70: (3, C_ANY, 0xDD70, 'LD (IX+d),B'),
    0x71: (3, C_ANY, 0xDD71, 'LD (IX+d),C'),
    0x72: (3, C_ANY, 0xDD72, 'LD (IX+d),D'),
    0x73: (3, C_ANY, 0xDD73, 'LD (IX+d),E'),
    0x74: (3, C_ANY, 0xDD74, 'LD (IX+d),H'),
    0x75: (3, C_ANY, 0xDD75, 'LD (IX+d),L'),
    0x77: (3, C_ANY, 0xDD77, 'LD (IX+d),A'),
    0x7C: (2, C_ONE, LD_A, 'LD A,IXh'),
    0x7D: (2, C_ONE, LD_A, 'LD A,IXl'),
    0x7E: (3, C_ONE, LD_A, 'LD A,(IX+d)'),
    0x84: (2, C_DEF, 0xDD84, 'ADD A,IXh'),
    0x85: (2, C_DEF, 0xDD85, 'ADD A,IXl'),
    0x86: (3, C_DEF, 0xDD86, 'ADD A,(IX+d)'),
    0x8C: (2, C_DEF, 0xDD8C, 'ADC A,IXh'),
    0x8D: (2, C_DEF, 0xDD8D, 'ADC A,IXl'),
    0x8E: (3, C_ANY, 0xDD8E, 'ADC A,(IX+d)'),
    0x94: (2, C_DEF, 0xDD94, 'SUB IXh'),
    0x95: (2, C_DEF, 0xDD95, 'SUB IXl'),
    0x96: (3, C_ANY, 0xDD96, 'SUB (IX+d)'),
    0x9C: (2, C_DEF, 0xDD9C, 'SBC A,IXh'),
    0x9D: (2, C_DEF, 0xDD9D, 'SBC A,IXl'),
    0x9E: (3, C_ANY, 0xDD9E, 'SBC A,(IX+d)'),
    0xA4: (2, C_ONE, 0xDDA4, 'AND IXh'),
    0xA5: (2, C_ONE, 0xDDA5, 'AND IXl'),
    0xA6: (3, C_DEF, 0xDDA6, 'AND (IX+d)'),
    0xAC: (2, C_ONE, 0xDDAC, 'XOR IXh'),
    0xAD: (2, C_ONE, 0xDDAD, 'XOR IXl'),
    0xAE: (3, C_DEF, 0xDDAE, 'XOR (IX+d)'),
    0xB4: (2, C_ONE, 0xDDB4, 'OR IXh'),
    0xB5: (2, C_ONE, 0xDDB5, 'OR IXl'),
    0xB6: (3, C_DEF, 0xDDB6, 'OR (IX+d)'),
    0xBC: (2, C_ONE, CP, 'CP IXh'),
    0xBD: (2, C_ONE, CP, 'CP IXl'),
    0xBE: (3, C_ONE, CP, 'CP (IX+d)'),
    0xE1: (2, C_DEF, 0xDDE1, 'POP IX'),
    0xE3: (2, C_ONE, 0xDDE3, 'EX (SP),IX'),
    0xE5: (2, C_DEF, 0xDDE5, 'PUSH IX'),
    0xE9: (2, C_ONE, END, 'JP (IX)'),
    0xF9: (2, C_ONE, LD_SP, 'LD SP,IX')
}

AFTER_DDCB = {
    0x06: (4, C_ANY, 0xFE06, 'RLC (IX+d)'),
    0x0E: (4, C_ANY, 0xFE0E, 'RRC (IX+d)'),
    0x16: (4, C_ANY, 0xFE16, 'RL (IX+d)'),
    0x1E: (4, C_ANY, 0xFE1E, 'RR (IX+d)'),
    0x26: (4, C_ANY, 0xFE26, 'SLA (IX+d)'),
    0x2E: (4, C_ANY, 0xFE2E, 'SRA (IX+d)'),
    0x36: (4, C_ANY, 0xFE36, 'SLL (IX+d)'),
    0x3E: (4, C_ANY, 0xFE3E, 'SRL (IX+d)'),
    0x46: (4, C_ONE, BIT, 'BIT 0,(IX+d)'),
    0x4E: (4, C_ONE, BIT, 'BIT 1,(IX+d)'),
    0x56: (4, C_ONE, BIT, 'BIT 2,(IX+d)'),
    0x5E: (4, C_ONE, BIT, 'BIT 3,(IX+d)'),
    0x66: (4, C_ONE, BIT, 'BIT 4,(IX+d)'),
    0x6E: (4, C_ONE, BIT, 'BIT 5,(IX+d)'),
    0x76: (4, C_ONE, BIT, 'BIT 6,(IX+d)'),
    0x7E: (4, C_ONE, BIT, 'BIT 7,(IX+d)'),
    0x86: (4, C_ANY, 0xFE86, 'RES 0,(IX+d)'),
    0x8E: (4, C_ANY, 0xFE8E, 'RES 1,(IX+d)'),
    0x96: (4, C_ANY, 0xFE96, 'RES 2,(IX+d)'),
    0x9E: (4, C_ANY, 0xFE9E, 'RES 3,(IX+d)'),
    0xA6: (4, C_ANY, 0xFEA6, 'RES 4,(IX+d)'),
    0xAE: (4, C_ANY, 0xFEAE, 'RES 5,(IX+d)'),
    0xB6: (4, C_ANY, 0xFEB6, 'RES 6,(IX+d)'),
    0xBE: (4, C_ANY, 0xFEBE, 'RES 7,(IX+d)'),
    0xC6: (4, C_ANY, 0xFEC6, 'SET 0,(IX+d)'),
    0xCE: (4, C_ANY, 0xFECE, 'SET 1,(IX+d)'),
    0xD6: (4, C_ANY, 0xFED6, 'SET 2,(IX+d)'),
    0xDE: (4, C_ANY, 0xFEDE, 'SET 3,(IX+d)'),
    0xE6: (4, C_ANY, 0xFEE6, 'SET 4,(IX+d)'),
    0xEE: (4, C_ANY, 0xFEEE, 'SET 5,(IX+d)'),
    0xF6: (4, C_ANY, 0xFEF6, 'SET 6,(IX+d)'),
    0xFE: (4, C_ANY, 0xFEFE, 'SET 7,(IX+d)')
}

AFTER_ED = {
    0x40: (2, C_ONE, 0xED40, 'IN B,(C)'),
    0x41: (2, C_ONE, 0xED41, 'OUT (C),B'),
    0x42: (2, C_DEF, 0xED42, 'SBC HL,BC'),
    0x43: (4, C_ANY, 0xED43, 'LD (nn),BC'),
    0x44: (2, C_ONE, 0xED44, 'NEG'),
    0x45: (2, C_ONE, END, 'RETN'),
    0x46: (2, C_ONE, 0xED46, 'IM 0'),
    0x47: (2, C_ONE, 0xED47, 'LD I,A'),
    0x48: (2, C_ONE, 0xED48, 'IN C,(C)'),
    0x49: (2, C_ONE, 0xED49, 'OUT (C),C'),
    0x4A: (2, C_DEF, 0xED4A, 'ADC HL,BC'),
    0x4B: (4, C_ONE, LD_BC, 'LD BC,(nn)'),
    0x4D: (2, C_ONE, END, 'RETI'),
    0x4F: (2, C_ONE, 0xED4F, 'LD R,A'),
    0x50: (2, C_ONE, 0xED50, 'IN D,(C)'),
    0x51: (2, C_ONE, 0xED51, 'OUT (C),D'),
    0x52: (2, C_DEF, 0xED52, 'SBC HL,DE'),
    0x53: (4, C_ANY, 0xED53, 'LD (nn),DE'),
    0x56: (2, C_ONE, 0xED56, 'IM 1'),
    0x57: (2, C_ONE, LD_A, 'LD A,I'),
    0x58: (2, C_ONE, 0xED58, 'IN E,(C)'),
    0x59: (2, C_ONE, 0xED59, 'OUT (C),E'),
    0x5A: (2, C_DEF, 0xED5A, 'ADC HL,DE'),
    0x5B: (4, C_ONE, LD_DE, 'LD DE,(nn)'),
    0x5E: (2, C_ONE, 0xED5E, 'IM 2'),
    0x5F: (2, C_ONE, LD_A, 'LD A,R'),
    0x60: (2, C_ONE, 0xED60, 'IN H,(C)'),
    0x61: (2, C_ONE, 0xED61, 'OUT (C),H'),
    0x62: (2, C_DEF, 0xED62, 'SBC HL,HL'),
    0x63: (4, C_ANY, 0xED63, 'LD (nn),HL'),
    0x67: (2, C_DEF, 0xED67, 'RRD'),
    0x68: (2, C_ONE, 0xED68, 'IN L,(C)'),
    0x69: (2, C_ONE, 0xED69, 'OUT (C),L'),
    0x6A: (2, C_DEF, 0xED6A, 'ADC HL,HL'),
    0x6B: (4, C_ONE, LD_HL, 'LD HL,(nn)'),
    0x6F: (2, C_DEF, 0xED6F, 'RLD'),
    0x72: (2, C_DEF, 0xED72, 'SBC HL,SP'),
    0x73: (4, C_ANY, 0xED73, 'LD (nn),SP'),
    0x78: (2, C_ONE, IN_A, 'IN A,(C)'),
    0x79: (2, C_ONE, 0xED79, 'OUT (C),A'),
    0x7A: (2, C_DEF, 0xED7A, 'ADC HL,SP'),
    0x7B: (4, C_ONE, LD_SP, 'LD SP,(nn)'),
    0xA0: (2, C_ANY, 0xEDA0, 'LDI'),
    0xA1: (2, C_ONE, 0xEDA1, 'CPI'),
    0xA2: (2, C_ONE, 0xEDA2, 'INI'),
    0xA3: (2, C_ANY, 0xEDA3, 'OUTI'),
    0xA8: (2, C_ANY, 0xEDA8, 'LDD'),
    0xA9: (2, C_ONE, 0xEDA9, 'CPD'),
    0xAA: (2, C_ONE, 0xEDAA, 'IND'),
    0xAB: (2, C_ANY, 0xEDAB, 'OUTD'),
    0xB0: (2, C_ONE, 0xEDB0, 'LDIR'),
    0xB1: (2, C_ONE, 0xEDB1, 'CPIR'),
    0xB2: (2, C_ONE, 0xEDB2, 'INIR'),
    0xB3: (2, C_ONE, 0xEDB3, 'OTIR'),
    0xB8: (2, C_ONE, 0xEDB8, 'LDDR'),
    0xB9: (2, C_ONE, 0xEDB9, 'CPDR'),
    0xBA: (2, C_ONE, 0xEDBA, 'INDR'),
    0xBB: (2, C_ONE, 0xEDBB, 'OTDR')
}

AFTER_FD = {
    0x09: (2, C_DEF, 0xFD09, 'ADD IY,BC'),
    0x19: (2, C_DEF, 0xFD19, 'ADD IY,DE'),
    0x21: (4, C_ONE, LD_IY, 'LD IY,nn'),
    0x22: (4, C_ANY, 0xFD22, 'LD (nn),IY'),
    0x23: (2, C_SAR, 0xFD23, 'INC IY'),
    0x24: (2, C_DEF, 0xFD24, 'INC IYh'),
    0x25: (2, C_DEF, 0xFD25, 'DEC IYh'),
    0x26: (3, C_ONE, LD_YH, 'LD IYh,n'),
    0x29: (2, C_DEF, 0xFD29, 'ADD IY,IY'),
    0x2A: (4, C_ONE, LD_IY, 'LD IY,(nn)'),
    0x2B: (2, C_SAR, 0xFD2B, 'DEC IY'),
    0x2C: (2, C_DEF, 0xFD2C, 'INC IYl'),
    0x2D: (2, C_DEF, 0xFD2D, 'DEC IYl'),
    0x2E: (3, C_ONE, LD_YL, 'LD IYl,n'),
    0x34: (3, C_DEF, 0xFD34, 'INC (IY+d)'),
    0x35: (3, C_DEF, 0xFD35, 'DEC (IY+d)'),
    0x36: (4, C_ANY, 0xFD36, 'LD (IY+d),n'),
    0x39: (2, C_DEF, 0xFD39, 'ADD IY,SP'),
    0x44: (2, C_ONE, LD_B, 'LD B,IYh'),
    0x45: (2, C_ONE, LD_B, 'LD B,IYl'),
    0x46: (3, C_ONE, LD_B, 'LD B,(IY+d)'),
    0x4C: (2, C_ONE, LD_C, 'LD C,IYh'),
    0x4D: (2, C_ONE, LD_C, 'LD C,IYl'),
    0x4E: (3, C_ONE, LD_C, 'LD C,(IY+d)'),
    0x54: (2, C_ONE, LD_D, 'LD D,IYh'),
    0x55: (2, C_ONE, LD_D, 'LD D,IYl'),
    0x56: (3, C_ONE, LD_D, 'LD D,(IY+d)'),
    0x5C: (2, C_ONE, LD_E, 'LD E,IYh'),
    0x5D: (2, C_ONE, LD_E, 'LD E,IYl'),
    0x5E: (3, C_ONE, LD_E, 'LD E,(IY+d)'),
    0x60: (2, C_ONE, LD_YH, 'LD IYh,B'),
    0x61: (2, C_ONE, LD_YH, 'LD IYh,C'),
    0x62: (2, C_ONE, LD_YH, 'LD IYh,D'),
    0x63: (2, C_ONE, LD_YH, 'LD IYh,E'),
    0x64: (2, C_INV, LD_R_R, 'LD IYh,IYh'),
    0x65: (2, C_ONE, LD_YH, 'LD IYh,IYl'),
    0x66: (3, C_ONE, LD_H, 'LD H,(IY+d)'),
    0x67: (2, C_ONE, LD_YH, 'LD IYh,A'),
    0x68: (2, C_ONE, LD_YL, 'LD IYl,B'),
    0x69: (2, C_ONE, LD_YL, 'LD IYl,C'),
    0x6A: (2, C_ONE, LD_YL, 'LD IYl,D'),
    0x6B: (2, C_ONE, LD_YL, 'LD IYl,E'),
    0x6C: (2, C_ONE, LD_YL, 'LD IYl,IYh'),
    0x6D: (2, C_INV, LD_R_R, 'LD IYl,IYl'),
    0x6E: (3, C_ONE, LD_L, 'LD L,(IY+d)'),
    0x6F: (2, C_ONE, LD_YL, 'LD IYl,A'),
    0x70: (3, C_ANY, 0xFD70, 'LD (IY+d),B'),
    0x71: (3, C_ANY, 0xFD71, 'LD (IY+d),C'),
    0x72: (3, C_ANY, 0xFD72, 'LD (IY+d),D'),
    0x73: (3, C_ANY, 0xFD73, 'LD (IY+d),E'),
    0x74: (3, C_ANY, 0xFD74, 'LD (IY+d),H'),
    0x75: (3, C_ANY, 0xFD75, 'LD (IY+d),L'),
    0x77: (3, C_ANY, 0xFD77, 'LD (IY+d),A'),
    0x7C: (2, C_ONE, LD_A, 'LD A,IYh'),
    0x7D: (2, C_ONE, LD_A, 'LD A,IYl'),
    0x7E: (3, C_ONE, LD_A, 'LD A,(IY+d)'),
    0x84: (2, C_DEF, 0xFD84, 'ADD A,IYh'),
    0x85: (2, C_DEF, 0xFD85, 'ADD A,IYl'),
    0x86: (3, C_DEF, 0xFD86, 'ADD A,(IY+d)'),
    0x8C: (2, C_DEF, 0xFD8C, 'ADC A,IYh'),
    0x8D: (2, C_DEF, 0xFD8D, 'ADC A,IYl'),
    0x8E: (3, C_ANY, 0xFD8E, 'ADC A,(IY+d)'),
    0x94: (2, C_DEF, 0xFD94, 'SUB IYh'),
    0x95: (2, C_DEF, 0xFD95, 'SUB IYl'),
    0x96: (3, C_ANY, 0xFD96, 'SUB (IY+d)'),
    0x9C: (2, C_DEF, 0xFD9C, 'SBC A,IYh'),
    0x9D: (2, C_DEF, 0xFD9D, 'SBC A,IYl'),
    0x9E: (3, C_ANY, 0xFD9E, 'SBC A,(IY+d)'),
    0xA4: (2, C_ONE, 0xFDA4, 'AND IYh'),
    0xA5: (2, C_ONE, 0xFDA5, 'AND IYl'),
    0xA6: (3, C_DEF, 0xFDA6, 'AND (IY+d)'),
    0xAC: (2, C_ONE, 0xFDAC, 'XOR IYh'),
    0xAD: (2, C_ONE, 0xFDAD, 'XOR IYl'),
    0xAE: (3, C_DEF, 0xFDAE, 'XOR (IY+d)'),
    0xB4: (2, C_ONE, 0xFDB4, 'OR IYh'),
    0xB5: (2, C_ONE, 0xFDB5, 'OR IYl'),
    0xB6: (3, C_DEF, 0xFDB6, 'OR (IY+d)'),
    0xBC: (2, C_ONE, CP, 'CP IYh'),
    0xBD: (2, C_ONE, CP, 'CP IYl'),
    0xBE: (3, C_ONE, CP, 'CP (IY+d)'),
    0xE1: (2, C_DEF, 0xFDE1, 'POP IY'),
    0xE3: (2, C_ONE, 0xFDE3, 'EX (SP),IY'),
    0xE5: (2, C_DEF, 0xFDE5, 'PUSH IY'),
    0xE9: (2, C_ONE, END, 'JP (IY)'),
    0xF9: (2, C_ONE, LD_SP, 'LD SP,IY')
}

AFTER_FDCB = {
    0x06: (4, C_ANY, 0xFF06, 'RLC (IY+d)'),
    0x0E: (4, C_ANY, 0xFF0E, 'RRC (IY+d)'),
    0x16: (4, C_ANY, 0xFF16, 'RL (IY+d)'),
    0x1E: (4, C_ANY, 0xFF1E, 'RR (IY+d)'),
    0x26: (4, C_ANY, 0xFF26, 'SLA (IY+d)'),
    0x2E: (4, C_ANY, 0xFF2E, 'SRA (IY+d)'),
    0x36: (4, C_ANY, 0xFF36, 'SLL (IY+d)'),
    0x3E: (4, C_ANY, 0xFF3E, 'SRL (IY+d)'),
    0x46: (4, C_ONE, BIT, 'BIT 0,(IY+d)'),
    0x4E: (4, C_ONE, BIT, 'BIT 1,(IY+d)'),
    0x56: (4, C_ONE, BIT, 'BIT 2,(IY+d)'),
    0x5E: (4, C_ONE, BIT, 'BIT 3,(IY+d)'),
    0x66: (4, C_ONE, BIT, 'BIT 4,(IY+d)'),
    0x6E: (4, C_ONE, BIT, 'BIT 5,(IY+d)'),
    0x76: (4, C_ONE, BIT, 'BIT 6,(IY+d)'),
    0x7E: (4, C_ONE, BIT, 'BIT 7,(IY+d)'),
    0x86: (4, C_ANY, 0xFF86, 'RES 0,(IY+d)'),
    0x8E: (4, C_ANY, 0xFF8E, 'RES 1,(IY+d)'),
    0x96: (4, C_ANY, 0xFF96, 'RES 2,(IY+d)'),
    0x9E: (4, C_ANY, 0xFF9E, 'RES 3,(IY+d)'),
    0xA6: (4, C_ANY, 0xFFA6, 'RES 4,(IY+d)'),
    0xAE: (4, C_ANY, 0xFFAE, 'RES 5,(IY+d)'),
    0xB6: (4, C_ANY, 0xFFB6, 'RES 6,(IY+d)'),
    0xBE: (4, C_ANY, 0xFFBE, 'RES 7,(IY+d)'),
    0xC6: (4, C_ANY, 0xFFC6, 'SET 0,(IY+d)'),
    0xCE: (4, C_ANY, 0xFFCE, 'SET 1,(IY+d)'),
    0xD6: (4, C_ANY, 0xFFD6, 'SET 2,(IY+d)'),
    0xDE: (4, C_ANY, 0xFFDE, 'SET 3,(IY+d)'),
    0xE6: (4, C_ANY, 0xFFE6, 'SET 4,(IY+d)'),
    0xEE: (4, C_ANY, 0xFFEE, 'SET 5,(IY+d)'),
    0xF6: (4, C_ANY, 0xFFF6, 'SET 6,(IY+d)'),
    0xFE: (4, C_ANY, 0xFFFE, 'SET 7,(IY+d)')
}

def _defb(snapshot, addr, size):
    op_id = 0
    for i in range(addr, addr + size):
        op_id = 256 * op_id + snapshot[i]
    operation = 'DEFB ' + ','.join(str(v) for v in snapshot[addr:addr + size])
    return size, 0, op_id, operation

def _after_cb(snapshot, addr):
    if addr < 65536:
        return AFTER_CB[snapshot[addr]]
    return _defb(snapshot, addr - 1, 1)

def _after_ddcb(snapshot, addr, value):
    if addr < 65535:
        try:
            if value == 0xDD:
                return AFTER_DDCB[snapshot[addr + 1]]
            return AFTER_FDCB[snapshot[addr + 1]]
        except KeyError:
            return _defb(snapshot, addr - 2, 4)
    return _defb(snapshot, addr - 2, 65538 - addr)

def _after_dd(snapshot, addr, value):
    if addr < 65536:
        value2 = snapshot[addr]
        try:
            if value2 == 0xCB:
                size, max_count, op_id, operation = _after_ddcb(snapshot, addr + 1, value)
            elif value == 0xDD:
                size, max_count, op_id, operation = AFTER_DD[value2]
            else:
                size, max_count, op_id, operation = AFTER_FD[value2]
        except KeyError:
            return _defb(snapshot, addr - 1, 2)
        if addr + size < 65538:
            return size, max_count, op_id, operation
    return _defb(snapshot, addr - 1, 65537 - addr)

def _after_ed(snapshot, addr):
    if addr < 65536:
        try:
            size, max_count, op_id, operation = AFTER_ED[snapshot[addr]]
            if addr + size < 65538:
                return size, max_count, op_id, operation
        except KeyError:
            return _defb(snapshot, addr - 1, 2)
    return _defb(snapshot, addr - 1, 65537 - addr)

def _opcode(snapshot, addr, value):
    size, max_count, op_id, operation = OPCODES[value]
    if addr + size < 65537:
        return size, max_count, op_id, operation
    return _defb(snapshot, addr, 65536 - addr)

def decode(snapshot, start, end):
    addr = start
    while addr < end:
        value = snapshot[addr]
        if value == 0xCB:
            size, max_count, op_id, operation = _after_cb(snapshot, addr + 1)
        elif value == 0xED:
            size, max_count, op_id, operation = _after_ed(snapshot, addr + 1)
        elif value in (0xDD, 0xFD):
            size, max_count, op_id, operation = _after_dd(snapshot, addr + 1, value)
        else:
            size, max_count, op_id, operation = _opcode(snapshot, addr, value)
        yield (addr, size, max_count, op_id, operation)
        addr += size
