"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'demo-stack');
// create the cloudfront distribution with extension(s)
const ext = new extensions.ModifyResponseHeader(stack, 'ModifyResp');
// create the cloudfront distribution with extension(s)
const dist = new cf.Distribution(stack, 'dist', {
    defaultBehavior: {
        origin: new origins.HttpOrigin('aws.amazon.com'),
        edgeLambdas: [ext],
    },
});
new cdk.CfnOutput(stack, 'distributionDomainName', {
    value: dist.distributionDomainName,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZGVtby9tb2RpZnktcmVzcG9uc2UtaGVhZGVyL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQThDO0FBQzlDLDJEQUEyRDtBQUMzRCxxQ0FBcUM7QUFDckMsK0NBQStDO0FBRS9DLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFFL0MsdURBQXVEO0FBQ3ZELE1BQU0sR0FBRyxHQUFHLElBQUksVUFBVSxDQUFDLG9CQUFvQixDQUFDLEtBQUssRUFBRSxZQUFZLENBQUMsQ0FBQztBQUVyRSx1REFBdUQ7QUFDdkQsTUFBTSxJQUFJLEdBQUcsSUFBSSxFQUFFLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7SUFDOUMsZUFBZSxFQUFFO1FBQ2YsTUFBTSxFQUFFLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUNoRCxXQUFXLEVBQUUsQ0FBQyxHQUFHLENBQUM7S0FDbkI7Q0FDRixDQUFDLENBQUM7QUFFSCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFO0lBQ2pELEtBQUssRUFBRSxJQUFJLENBQUMsc0JBQXNCO0NBQ25DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNmIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCAqIGFzIG9yaWdpbnMgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQtb3JpZ2lucyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBleHRlbnNpb25zIGZyb20gJy4uLy4uL2V4dGVuc2lvbnMnO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2RlbW8tc3RhY2snKTtcblxuLy8gY3JlYXRlIHRoZSBjbG91ZGZyb250IGRpc3RyaWJ1dGlvbiB3aXRoIGV4dGVuc2lvbihzKVxuY29uc3QgZXh0ID0gbmV3IGV4dGVuc2lvbnMuTW9kaWZ5UmVzcG9uc2VIZWFkZXIoc3RhY2ssICdNb2RpZnlSZXNwJyk7XG5cbi8vIGNyZWF0ZSB0aGUgY2xvdWRmcm9udCBkaXN0cmlidXRpb24gd2l0aCBleHRlbnNpb24ocylcbmNvbnN0IGRpc3QgPSBuZXcgY2YuRGlzdHJpYnV0aW9uKHN0YWNrLCAnZGlzdCcsIHtcbiAgZGVmYXVsdEJlaGF2aW9yOiB7XG4gICAgb3JpZ2luOiBuZXcgb3JpZ2lucy5IdHRwT3JpZ2luKCdhd3MuYW1hem9uLmNvbScpLFxuICAgIGVkZ2VMYW1iZGFzOiBbZXh0XSxcbiAgfSxcbn0pO1xuXG5uZXcgY2RrLkNmbk91dHB1dChzdGFjaywgJ2Rpc3RyaWJ1dGlvbkRvbWFpbk5hbWUnLCB7XG4gIHZhbHVlOiBkaXN0LmRpc3RyaWJ1dGlvbkRvbWFpbk5hbWUsXG59KTtcbiJdfQ==