"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalDataIngestion = exports.OAuth2AuthorizationCodeGrant = exports.SimpleLambdaEdge = exports.RedirectByGeolocation = exports.AccessOriginByGeolocation = exports.CustomErrorPage = exports.DefaultDirIndex = exports.ConvertQueryString = exports.NormalizeQueryString = exports.MultipleOriginIpRetry = exports.SecurtyHeaders = exports.AntiHotlinking = exports.HTTP302FromOrigin = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const custom_1 = require("./custom");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.3.9" };
// export class HTTP302FromOrigin extends ServerlessApp implements IExtensions {
//   readonly functionArn: string;
//   readonly functionVersion: lambda.Version;
//   readonly eventType: cf.LambdaEdgeEventType;
//   readonly lambdaFunction: lambda.Version;
//   constructor(scope: cdk.Construct, id: string) {
//     super(scope, id, {
//       applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin',
//       semanticVersion: '1.0.2',
//     });
//     const stack = cdk.Stack.of(scope);
//     this.functionArn = this.resource.getAtt('Outputs.Http302Function').toString();
//     this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
//     this.lambdaFunction = this.functionVersion;
//     this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
//   }
// };
/**
 * The HTTP[302] from origin extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin
 * @stability stable
 */
class HTTP302FromOrigin extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'HTTP302FromOriginFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-http302-from-origin/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8103',
            templateDescription: 'Cloudfront extension with AWS CDK - HTTP 302 from Origin',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.HTTP302FromOrigin = HTTP302FromOrigin;
_b = JSII_RTTI_SYMBOL_1;
HTTP302FromOrigin[_b] = { fqn: "cdk-cloudfront-plus.HTTP302FromOrigin", version: "0.3.9" };
;
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_c = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_c] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.3.9" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_d = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_d] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.3.9" };
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
class MultipleOriginIpRetry extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/multiple-origin-IP-retry',
            semanticVersion: '1.0.1',
            parameters: {
                OriginIPList: props.originIp.join(';'),
                OriginProtocol: props.originProtocol,
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.MultipleOriginIPRetry').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_REQUEST;
    }
}
exports.MultipleOriginIpRetry = MultipleOriginIpRetry;
_e = JSII_RTTI_SYMBOL_1;
MultipleOriginIpRetry[_e] = { fqn: "cdk-cloudfront-plus.MultipleOriginIpRetry", version: "0.3.9" };
/**
 * Normalize Query String extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/normalize-query-string
 * @stability stable
 */
class NormalizeQueryString extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/normalize-query-string',
            semanticVersion: '1.0.1',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.NormalizeQueryStringFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.NormalizeQueryString = NormalizeQueryString;
_f = JSII_RTTI_SYMBOL_1;
NormalizeQueryString[_f] = { fqn: "cdk-cloudfront-plus.NormalizeQueryString", version: "0.3.9" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Convert a query string to key-value pairs and add them into header.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-examples.html#lambda-examples-header-based-on-query-string
 * @stability stable
 */
class ConvertQueryString extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'ConvertQueryStringFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-convert-query-string/index.ts`,
            handler: 'lambdaHandler',
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    NEEDED_KEYS: JSON.stringify(props.args),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8113',
            templateDescription: 'Cloudfront extension with AWS CDK - Convert Query String.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.ConvertQueryString = ConvertQueryString;
_g = JSII_RTTI_SYMBOL_1;
ConvertQueryString[_g] = { fqn: "cdk-cloudfront-plus.ConvertQueryString", version: "0.3.9" };
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_h = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_h] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.3.9" };
;
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
class CustomErrorPage extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            runtime: lambda.Runtime.PYTHON_3_7,
            handler: 'index.handler',
            code: lambda.AssetCode.fromAsset(`${EXTENSION_ASSETS_PATH}/cf-custom-error-page`),
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8136',
            templateDescription: 'Cloudfront extension with AWS CDK - Custom Error Page',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.CustomErrorPage = CustomErrorPage;
_j = JSII_RTTI_SYMBOL_1;
CustomErrorPage[_j] = { fqn: "cdk-cloudfront-plus.CustomErrorPage", version: "0.3.9" };
;
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
class AccessOriginByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'AccessOriginByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-access-origin-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'S08118',
            templateDescription: 'Cloudfront extension with AWS CDK - Access Origin by Geolocation',
        });
    }
}
exports.AccessOriginByGeolocation = AccessOriginByGeolocation;
_k = JSII_RTTI_SYMBOL_1;
AccessOriginByGeolocation[_k] = { fqn: "cdk-cloudfront-plus.AccessOriginByGeolocation", version: "0.3.9" };
;
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
class RedirectByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'RedirectByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-redirect-by-geolocation/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8135',
            templateDescription: 'Cloudfront extension with AWS CDK - Redirect by Geolocation',
        });
    }
}
exports.RedirectByGeolocation = RedirectByGeolocation;
_l = JSII_RTTI_SYMBOL_1;
RedirectByGeolocation[_l] = { fqn: "cdk-cloudfront-plus.RedirectByGeolocation", version: "0.3.9" };
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_m = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_m] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.3.9" };
;
/**
 * OAuth2 Authentication - Authorization Code Grant.
 *
 * @stability stable
 */
class OAuth2AuthorizationCodeGrant extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'OAuth2AuthorizationCodeGrantFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-authentication-by-oauth2/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.CLIENT_ID': JSON.stringify(props.clientId),
                    'process.env.CLIENT_SECRET': JSON.stringify(props.clientSecret),
                    'process.env.CLIENT_DOMAIN': JSON.stringify(props.clientDomain),
                    'process.env.CLIENT_PUBLIC_KEY': JSON.stringify(props.clientPublicKey),
                    'process.env.CALLBACK_PATH': JSON.stringify(props.callbackPath),
                    'process.env.JWT_ARGORITHM': JSON.stringify(props.jwtArgorithm),
                    'process.env.AUTHORIZE_URL': JSON.stringify(props.authorizeUrl),
                    'process.env.AUTHORIZE_PARAMS': JSON.stringify(props.authorizeParams),
                    'process.env.DEBUG_ENABLE': JSON.stringify(props.debugEnable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: 'SO8131',
            templateDescription: 'Cloudfront extension with AWS CDK - OAuth2 Authentication - Authorization Code Grant.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.OAuth2AuthorizationCodeGrant = OAuth2AuthorizationCodeGrant;
_o = JSII_RTTI_SYMBOL_1;
OAuth2AuthorizationCodeGrant[_o] = { fqn: "cdk-cloudfront-plus.OAuth2AuthorizationCodeGrant", version: "0.3.9" };
;
;
/**
 * Ingest data to Kinesis Firehose by nearest cloudfront edge.
 *
 * @see https://aws.amazon.com/blogs/networking-and-content-delivery/global-data-ingestion-with-amazon-cloudfront-and-lambdaedge/
 * @stability stable
 */
class GlobalDataIngestion extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _q;
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'GlobalDataIngestionFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-global-data-ingestion/index.ts`,
            // L@E does not support NODE14 so use NODE12 instead.
            runtime: lambda.Runtime.NODEJS_12_X,
            bundling: {
                define: {
                    'process.env.DELIVERY_STREAM_NAME': JSON.stringify(props.firehoseStreamName),
                },
            },
        });
        (_q = func.role) === null || _q === void 0 ? void 0 : _q.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonKinesisFirehoseFullAccess'));
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            includeBody: true,
            solutionId: 'SO8133',
            templateDescription: 'Cloudfront extension with AWS CDK - Global Data Ingestion',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.GlobalDataIngestion = GlobalDataIngestion;
_p = JSII_RTTI_SYMBOL_1;
GlobalDataIngestion[_p] = { fqn: "cdk-cloudfront-plus.GlobalDataIngestion", version: "0.3.9" };
//# sourceMappingURL=data:application/json;base64,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