# - Locate gperftools library
# Defines:
#
#  GPERFTOOLS_FOUND
#  GPERFTOOLS_INCLUDE_DIR
#  GPERFTOOLS_INCLUDE_DIRS (not cached)
#  GPERFTOOLS_TCMALLOC_LIBRARY
#  GPERFTOOLS_TCMALLOC_DEBUG_LIBRARY
#  GPERFTOOLS_TCMALLOC_MINIMALLIBRARY
#  GPERFTOOLS_TCMALLOC_AND_PROFILER_LIBRARY
#  GPERFTOOLS_PROFILER_LIBRARY
#  GPERFTOOLS_LIBRARIES (not cached)
#  GPERFTOOLS_LIBRARY_DIRS (not cached)
#  GPERFTOOLS_PPROF_EXECUTABLE
# 
#  All blame goes to
#  Sami Kama<sami_dot_kama_at_cern_dot_ch> Apr 2016
#

find_path(GPERFTOOLS_INCLUDE_DIR tcmalloc.h  HINTS ${GPERFTOOLS_INSTALL_DIR} PATH_SUFFIXES  "include/gperftools" "include/google" NO_DEFAULT_PATH ) #override with commandline define
find_path(GPERFTOOLS_INCLUDE_DIR tcmalloc.h  HINTS ${GPERFTOOLS_INSTALL_DIR} PATH_SUFFIXES  "gperftools" "google" ) #If fails look a system installation
foreach(component tcmalloc tcmalloc_debug tcmalloc_and_profiler tcmalloc_minimal profiler)
string(TOUPPER ${component} COMPONENT)
find_library(GPERFTOOLS_${COMPONENT}_LIBRARY NAMES ${component} HINTS ${GPERFTOOLS_INSTALL_DIR}/lib NO_DEFAULT_PATH )
find_library(GPERFTOOLS_${COMPONENT}_LIBRARY NAMES ${component} HINTS ${GPERFTOOLS_INSTALL_DIR}/lib  )
mark_as_advanced(GPERFTOOLS_${COMPONENT}_LIBRARY)
endforeach()
get_filename_component(GPERFTOOLS_INCLUDE_BASE "${GPERFTOOLS_INCLUDE_DIR}" DIRECTORY)
#message(STATUS "GPERFTOOLS_INCLUDE_DIR=${GPERFTOOLS_INCLUDE_DIR}")
find_program(GPERFTOOLS_PPROF_EXECUTABLE NAMES pprof
             HINTS ${GPERFTOOLS_INSTALL_DIR}/bin NO_DEFAULT_PATH)
find_program(GPERFTOOLS_PPROF_EXECUTABLE NAMES pprof
             HINTS ${GPERFTOOLS_INSTALL_DIR}/bin)

set(GPERFTOOLS_INCLUDE_DIRS ${GPERFTOOLS_INCLUDE_BASE})
set(GPERFTOOLS_LIBRARIES ${GPERFTOOLS_TCMALLOC_LIBRARY} ${GPERFTOOLS_PROFILER_LIBRARY})

#find GPERFTOOLS version
if( GPERFTOOLS_INCLUDE_DIR )
   FILE(STRINGS "${GPERFTOOLS_INCLUDE_DIR}/tcmalloc.h" TCMVERSION REGEX ".define TC_VERSION_[MP].*")
endif()
#message(STATUS "TCMVERSION = ${TCMVERSION}")
if(TCMVERSION)
  LIST(GET TCMVERSION 0 VERMAJ)
  string(REGEX MATCH ".* ([0-9]+)$" MAJ ${VERMAJ})
  if(CMAKE_MATCH_1)
    set(GPERFTOOLS_VERSION_MAJOR ${CMAKE_MATCH_1})
  else()
    set(GPERFTOOLS_VERSION_MAJOR 0)
  endif()
  LIST(GET TCMVERSION 1 VERMIN)
  string(REGEX MATCH ".* ([0-9]+)$" MIN ${VERMIN})
  if(CMAKE_MATCH_1)
    set(GPERFTOOLS_VERSION_MINOR ${CMAKE_MATCH_1})
  else()
    set(GPERFTOOLS_VERSION_MINOR 0)
  endif()
  LIST(GET TCMVERSION 2 VERPATCH)
  string(REGEX MATCH ".* ([0-9]+)$" PAT ${VERPATCH})
  if(CMAKE_MATCH_1)
    set(GPERFTOOLS_VERSION_PATCH ${CMAKE_MATCH_1})
  else()
    set(GPERFTOOLS_VERSION_PATCH 0)
  endif()
  set(GPERFTOOLS_VERSION ${GPERFTOOLS_VERSION_MAJOR}.${GPERFTOOLS_VERSION_MINOR}.${GPERFTOOLS_VERSION_PATCH})
#  message(STATUS "GPERFTOOLS_VERSION = ${GPERFTOOLS_VERSION}")
endif()
# handle the QUIETLY and REQUIRED arguments and set GPERFTOOLS_FOUND to TRUE if
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(gperftools FOUND_VAR GPERFTOOLS_FOUND 
  REQUIRED_VARS GPERFTOOLS_INCLUDE_DIRS GPERFTOOLS_LIBRARIES
  VERSION_VAR GPERFTOOLS_VERSION)

mark_as_advanced(GPERFTOOLS_FOUND GPERFTOOLS_INCLUDE_DIR GPERFTOOLS_PPROF_EXECUTABLE GPERFTOOLS_VERSION )

if(GPERFTOOLS_TCMALLOC_LIBRARY)
  get_filename_component(GPERFTOOLS_LIBRARY_DIRS ${GPERFTOOLS_TCMALLOC_LIBRARY} PATH)
elseif(GPERFTOOLS_PROFILER_LIBRARY)
  get_filename_component(GPERFTOOLS_LIBRARY_DIRS ${GPERFTOOLS_PROFILER_LIBRARY} PATH)
endif()
