#!/usr/bin/env python
# -*- coding: utf8 -*-

DEFAULT_LIMIT = 10000
DEFAULT_CSTOP = 1000

"""
Default LIMITs and CSTOPs for key types so that caching is not too fast or too slow. Numbers initially generated from 442 (over RPC) and then from 668, 663 and the final
refinement is from a complete (less 68, 64.1) cache of WWW (687).

Used by Cacher to override the default limit and cstops. Can be overridden again in any run.

Note: will evolve based on Cache Health Reports so optimal tradeoff of reply size and time is reached.

Defined for FMQL V10
"""
EXPLICIT_LIMITs = {
    "_401": 4886,
    "_9": 16667,
    "1_5212": 25000,
    "1_5215": 25000,
    "1_5216": 25000,
    "1_5217": 20000,
    "1_5218": 33333,
    "1_5219": 33333,
    "2": 85,
    "3_05": 25000,
    "3_075": 1235,
    "3_081": 11380,
    "3_7": 2500,
    "3_9": 75,
    "4": 8800,
    "4_2997": 20628,
    "4_2999": 324,
    "5_11": 50000,
    "5_12": 33333,
    "9_4": 1606,
    "9_6": 1883,
    "9_7": 1687,
    "9_8": 20000,
    "15_4": 2982,
    "19": 12949,
    "19_081": 14380,
    "20": 27854,
    "26_13": 15138,
    "26_14": 13756,
    "26_15": 10000,
    "26_17": 29808,
    "26_19": 17078,
    "26_21": 30858,
    "27_11": 6629,
    "27_12": 16667,
    "27_14": 7812,
    "28_11": 14286,
    "29_11": 18600,
    "38_1": 10,
    "39_4": 25000,
    "40_1": 2000,
    "40_8": 195,
    "41_41": 28648,
    "41_43": 25000,
    "41_9": 3448,
    "44": 11,
    "45": 2381,
    "45_83": 2000,
    "45_85": 25000,
    "45_9": 7692,
    "50": 2583,
    "50_416": 10265,
    "50_6": 20000,
    "50_621": 1000,
    "50_622": 700,
    "50_623": 100000,
    "50_624": 100000,
    "50_627": 50000,
    "50_67": 15103,
    "50_68": 4777,
    "50_8": 1864,
    "50_9": 84,
    "52": 938,
    "52_41": 4348,
    "52_43": 20000,
    "52_49": 2174,
    "52_5": 20000,
    "52_51": 12500,
    "53_1": 7692,
    "53_5": 1522,
    "53_69": 12035,
    "53_77": 19796,
    "53_78": 13836,
    "53_79": 6815,
    "55": 40,
    "56": 25000,
    "57_6": 500,
    "58_1": 7692,
    "58_42": 625,
    "58_5": 200,
    "58_8": 314,
    "58_81": 16305,
    "58_811": 167,
    "59_1": 2000,
    "59_12": 667,
    "60": 5636,
    "61": 13998,
    "61_2": 7730,
    "62_49": 7143,
    "62_8": 4594,
    "62_85": 16667,
    "63": 25,
    "64": 20000,
    "64_7": 625,
    "67_9": 3,
    "69": 132,
    "74": 3100,
    "74_4": 18000,
    "75_1": 4762,
    "80": 899,
    "80_1": 4323,
    "80_2": 2682,
    "81": 7143,
    "81_3": 1961,
    "82_13": 2000,
    "83_5": 12500,
    "83_51": 33333,
    "83_6": 8333,
    "95_3": 5464,
    "95_31": 33333,
    "100": 2000,
    "100_05": 4931,
    "100_2": 4348,
    "101_41": 5223,
    "101_52": 7143,
    "102_4": 50000,
    "103": 182,
    "111_1": 7774,
    "112": 6250,
    "115": 1031,
    "119_8": 21129,
    "120_5": 15625,
    "120_8": 5620,
    "120_85": 3108,
    "120_86": 26740,
    "121": 6667,
    "123": 1333,
    "123_5": 9218,
    "125_8": 19522,
    "129_1": 6250,
    "129_11": 33333,
    "129_12": 43768,
    "129_2": 25000,
    "129_21": 25000,
    "129_22": 33333,
    "129_23": 50000,
    "130": 3333,
    "137": 100000,
    "160": 4152,
    "161": 741,
    "162": 53,
    "162_2": 8333,
    "162_4": 4762,
    "162_5": 4762,
    "162_7": 2857,
    "162_96": 3125,
    "162_97": 2041,
    "162_98": 4234,
    "163_5": 3846,
    "165_5": 700,
    "190": 8333,
    "190_3": 11556,
    "194_2": 12500,
    "195_9": 33333,
    "200": 4496,
    "213_4": 20000,
    "214": 25000,
    "214_6": 16685,
    "214_7": 20000,
    "220": 12000,
    "221": 13202,
    "228_1": 10522,
    "228_2": 6337,
    "228_25": 20000,
    "230": 2600,
    "230_1": 17602,
    "301_5": 1326,
    "301_6": 14236,
    "301_62": 12122,
    "301_7": 8840,
    "340": 25000,
    "341": 13122,
    "344": 1667,
    "344_1": 20000,
    "344_31": 8333,
    "344_4": 2273,
    "344_49": 2857,
    "344_71": 25000,
    "344_72": 25000,
    "344_73": 25000,
    "350": 6654,
    "351": 14286,
    "351_71": 702,
    "354": 25000,
    "354_1": 16000,
    "354_7": 1515,
    "354_71": 7950,
    "355_3": 5537,
    "355_32": 14286,
    "355_33": 14286,
    "355_36": 25000,
    "356": 11482,
    "356_1": 7286,
    "356_399": 50000,
    "357_1": 158,
    "357_2": 5570,
    "357_3": 14414,
    "357_4": 99674,
    "357_95": 175,
    "357_96": 2326,
    "359_2": 4000,
    "361": 8750,
    "361_1": 2667,
    "362_1": 25000,
    "362_3": 45066,
    "362_4": 20000,
    "362_5": 25000,
    "363_2": 24380,
    "364": 25000,
    "364_2": 7782,
    "365": 518,
    "365_1": 7692,
    "365_18": 20000,
    "366_03": 7692,
    "366_14": 5,
    "366_15": 33333,
    "390": 16667,
    "391_31": 6152,
    "391_71": 15702,
    "391_91": 20000,
    "392": 6250,
    "392_51": 33333,
    "394_61": 4762,
    "394_62": 16667,
    "394_87": 6667,
    "395_5": 4167,
    "395_7": 16667,
    "396_17": 68,
    "396_18": 147,
    "396_3": 2000,
    "396_4": 476,
    "396_95": 15348,
    "399": 1745,
    "403_5": 14286,
    "404_41": 12500,
    "404_42": 12500,
    "404_43": 12500,
    "404_54": 25000,
    "405": 8333,
    "408_12": 7143,
    "408_13": 20000,
    "408_21": 10712,
    "408_22": 20000,
    "408_31": 8800,
    "408_41": 16000,
    "409_3": 6250,
    "409_42": 33333,
    "409_43": 33333,
    "409_44": 25000,
    "409_48": 14286,
    "409_5": 5556,
    "409_6": 2033,
    "409_65": 20000,
    "409_68": 6352,
    "409_73": 12245,
    "409_74": 21130,
    "409_77": 9754,
    "409_84": 8333,
    "409_85": 5263,
    "409_91": 7062,
    "410": 4000,
    "417": 12500,
    "420": 1264,
    "420_18": 33333,
    "421": 8333,
    "424": 16667,
    "424_1": 20000,
    "430": 4480,
    "430_7": 1429,
    "433": 10171,
    "440": 7692,
    "440_6": 5556,
    "440_7": 3346,
    "441": 5882,
    "442": 1600,
    "443_5": 2838,
    "445": 3846,
    "445_1": 0,
    "445_2": 12500,
    "450": 1200,
    "458": 68,
    "458_1": 11877,
    "459": 222,
    "550_2": 263,
    "579_3": 284,
    "601": 8948,
    "601_2": 48444,
    "601_751": 50000,
    "601_84": 10212,
    "601_85": 34380,
    "601_88": 33333,
    "601_89": 50000,
    "601_92": 33333,
    "601_94": 16667,
    "604": 901,
    "627_8": 16667,
    "632": 7143,
    "650": 6646,
    "660": 5410,
    "661_1": 9292,
    "661_2": 16667,
    "661_6": 16667,
    "661_63": 14286,
    "661_9": 33333,
    "664": 4762,
    "665": 8333,
    "665_4": 5556,
    "665_72": 424,
    "668": 4000,
    "691_5": 14286,
    "702": 6000,
    "712": 1418,
    "712_5": 16667,
    "712_6": 100000,
    "713_1": 33333,
    "721": 6175,
    "727": 8630,
    "727_81": 5000,
    "727_813": 8333,
    "727_826": 5000,
    "727_827": 5000,
    "740_5": 16667,
    "741": 5046,
    "743_1": 25000,
    "743_2": 20000,
    "757": 33716,
    "757_001": 28208,
    "757_01": 11090,
    "757_02": 9186,
    "757_033": 6904,
    "757_07": 20000,
    "757_1": 20857,
    "757_21": 31612,
    "757_33": 13116,
    "772": 3226,
    "773": 6667,
    "777": 5099,
    "779_5": 4500,
    "790": 8882,
    "798": 7692,
    "798_3": 33333,
    "798_4": 16667,
    "801_41": 10620,
    "802_2": 1323,
    "810_3": 114,
    "810_5": 72,
    "811_2": 6336,
    "811_8": 39,
    "910_1": 7556,
    "912": 2637,
    "916": 1639,
    "2005": 3356,
    "2005_1": 3704,
    "2006_041": 33333,
    "2006_18": 1700,
    "2006_5": 2354,
    "2006_5839": 30992,
    "2006_5849": 7143,
    "2006_81": 11632,
    "2006_82": 2857,
    "2006_941": 6680,
    "2006_95": 11628,
    "2006_961": 847,
    "2100_1": 16667,
    "2260": 3692,
    "6914": 2381,
    "6918": 16667,
    "6920": 6667,
    "6930": 33333,
    "8925": 3600,
    "8925_1": 10000,
    "8925_5": 17166,
    "8925_7": 16054,
    "8925_91": 30830,
    "8926_1": 9262,
    "8927": 8360,
    "8927_1": 16667,
    "8930_3": 25000,
    "8971_1": 12468,
    "8973_1": 5050,
    "8973_2": 20000,
    "8980_2": 2564,
    "8989_5": 32460,
    "8992": 800,
    "8992_1": 3030,
    "8994": 6116,
    "15050_11": 1418,
    "19000_0035": 9400,
    "19000_0036": 6160,
    "19000_0037": 4066,
    "19000_0039": 6314,
    "19000_0041": 8882,
    "19601_13": 3571,
    "19605_2": 685,
    "19610_1": 361,
    "19610_4": 6000,
    "19610_5": 2987,
    "19610_61": 29838,
    "19610_7": 12500,
    "19610_8": 4000,
    "19620": 2381,
    "19620_1": 12072,
    "19620_12": 20000,
    "19620_13": 50000,
    "19620_91": 20000,
    "19620_92": 20000,
    "19620_98": 50000,
    "19625": 3475,
    "19625_1": 526,
    "19630_13": 25000,
    "19632": 33333,
    "19633": 20000,
    "19640_1": 25000,
    "19640_19": 20000,
    "19640_31": 17143,
    "19640_32": 15146,
    "19640_33": 11619,
    "19640_35": 6884,
    "19640_39": 40000,
    "19665_9": 17887,
    "19670_01": 8110,
    "19671": 11564,
    "19908_5": 1000,
    "19925_1": 50000,
    "100100_022": 50000,
    "100207": 50000,
    "177100_13": 25000,
    "190002_1": 20000,
    "437053": 6982,
    "442080": 9444,
    "442093": 1944,
    "442104": 7948,
    "442127": 6398,
    "442170": 3044,
    "503331": 20000,
    "509850_2": 16667,
    "509850_6": 4762,
    "509850_9": 4348,
    "537000": 16667,
    "537002": 5348,
    "537010": 18750,
    "552038": 315,
    "612418_2": 12500,
    "612418_3": 91,
    "626140": 12192,
    "648233": 14286,
    "687065": 20000,
    "688653": 33333,
    "695065": 20000,
    "695065_8": 16667,
    "791810": 1737,
    "800003": 2941,
    "1200035": 8562,
    "6411215": 4470,
    "9000001": 33333,
    "9000010": 6138,
    "9000010_06": 15205,
    "9000010_07": 11864,
    "9000010_11": 10978,
    "9000010_12": 23996,
    "9000010_13": 15370,
    "9000010_16": 16640,
    "9000010_23": 13848,
    "9000011": 6222,
    "9002313_02": 2439,
    "9002313_03": 4545,
    "9002313_12": 1408,
    "9002313_511": 33333,
    "9002313_57": 3125,
    "9002313_59": 3226,
    "9002313_78": 6250,
    "9002313_92": 889,
    "9009032_4": 14286,
    "9999999_06": 100000,
    "9999999_27": 40550,
    "9999999_64": 33248,
    "19000161": 20000,
    "50000000": 935
}

EXPLICIT_CSTOPs = {

        "2": 20000,
        "9_6": 1500,
        "9_7": 1500,
        "19": 1500,
        "38_1": 60000,
        "200": 20000,
        "2006_82": 10000,
        "80": 6000,
        "68": 0,
        "3_7": 100,
        "40": 0,
        "40_1": 50,
        "50_9": 0,
        "69": 0,
        "69_9": 100,
        "445": 0,
        "445_11": 0,
        "458": 0,
        "459": 0,
        "665_72": 100,
        "44": 100000,
        "63": 1000

}

"""
EXPLICIT_OTHER_KNOWNs captures for FORCOUNT the types that have been cached safely before but are not in the explicit limits or cstops
"""
EXPLICIT_OTHER_KNOWNs = ["_11", "_31", "_4", "_402", "_403", "_404", "_44", "_5", "_6", "_7", "_81", "_84", "_85", "_86", "_87", "1", "1_1", "1_12", "1_2", "1_5", "1_521", "1_5211", "1_5213", "1_5214", "1_52191", "1_52192", "1_62", "1_71", "1_72", "3_07", "3_076", "3_077", "3_084", "3_1", "3_2", "3_22", "3_4", "3_5", "3_51", "3_519", "3_54", "3_6", "3_73", "3_8", "4_001", "4_005", "4_009", "4_05", "4_1", "4_11", "4_2", "4_2996", "4_3", "4_4", "4_6", "5", "5_1", "5_13", "7", "8", "8_1", "8_2", "9_2", "9_9", "9_95", "10", "10_2", "10_3", "10_99", "11", "11_99", "12", "13", "13_99", "14_4", "14_5", "14_7", "14_71", "14_8", "15", "15_1", "15_2", "15_3", "18_01", "18_02", "18_03", "18_05", "18_12", "18_13", "19_1", "19_2", "19_8", "20_11", "21", "22", "23", "24", "25", "25_11", "26", "26_11", "26_12", "26_16", "26_18", "26_22", "27_15", "27_16", "27_17", "27_18", "30", "31", "32", "33", "34", "35", "36", "37", "38_5", "38_6", "39_1", "39_2", "39_3", "40_5", "40_6", "40_7", "40_9", "41_1", "41_42", "42", "42_4", "42_5", "42_55", "42_6", "42_7", "42_8", "43", "43_1", "43_11", "43_4", "43_5", "43_61", "43_7", "44_3", "45_1", "45_2", "45_3", "45_4", "45_6", "45_61", "45_64", "45_68", "45_7", "45_81", "45_82", "45_84", "45_86", "45_87", "45_88", "45_89", "45_91", "46", "46_1", "46_11", "46_14", "47", "47_75", "47_76", "47_761", "48", "48_5", "49", "50_073", "50_0732", "50_2", "50_3", "50_35", "50_4", "50_605", "50_606", "50_60699", "50_607", "50_608", "50_609", "50_612", "50_625", "50_626", "50_64", "50_7", "51", "51_1", "51_2", "51_23", "51_24", "51_25", "51_5", "51_7", "52_09", "52_11", "52_45", "52_46", "52_47", "52_48", "52_52", "52_54", "52_6", "52_7", "52_85", "52_86", "52_9", "52_91", "52_92", "53", "53_2", "53_3", "53_4", "53_41", "53_42", "53_44", "53_45", "53_46", "53_68", "53_71", "54", "55_95", "57", "57_1", "57_23", "57_5", "57_7", "57_8", "58", "58_16", "58_17", "58_19", "58_2", "58_3", "58_4", "58_41", "58_812", "58_82", "58_83", "58_84", "58_85", "58_86", "58_88", "59", "59_2", "59_3", "59_4", "59_5", "59_6", "59_7", "59_73", "59_74", "59_8", "59_9", "61_1", "61_3", "61_38", "61_39", "61_4", "61_5", "61_6", "62", "62_05", "62_06", "62_07", "62_1", "62_2", "62_3", "62_4", "62_47", "62_48", "62_485", "62_5", "62_55", "62_6", "62_9", "62_91", "62_92", "62_93", "64_05", "64_061", "64_062", "64_2", "64_21", "64_22", "64_3", "64_5", "64_6", "64_81", "64_9178", "65", "65_4", "65_9", "66", "66_2", "66_3", "66_4", "67_2", "67_3", "68_2", "69_1", "69_2", "69_4", "69_5", "69_51", "69_71", "69_73", "69_91", "70", "70_2", "71", "71_1", "71_11", "71_2", "71_3", "71_4", "71_5", "71_6", "71_7", "71_98", "71_99", "72", "73_1", "73_2", "74_1", "74_2", "74_3", "75_2", "78_1", "78_2", "78_3", "78_4", "78_6", "78_7", "79", "79_1", "79_2", "79_3", "79_7", "80_3", "80_4", "80_5", "80_6", "81_1", "81_2", "82", "82_1", "82_11", "82_12", "83", "83_1", "83_11", "83_2", "83_3", "83_61", "83_7", "83_71", "90", "95", "99", "100_01", "100_02", "100_03", "100_1", "100_21", "100_22", "100_23", "100_24", "100_4", "100_5", "100_6", "100_7", "100_8", "100_9", "100_98", "100_99", "101", "101_13", "101_15", "101_24", "101_3", "101_42", "101_43", "101_44", "102_21", "102_22", "102_23", "102_24", "102_3", "104", "104_2", "107_1", "108", "111", "112_2", "112_6", "113", "113_1", "113_2", "114", "114_1", "114_2", "114_3", "114_4", "115_2", "115_3", "115_4", "115_5", "115_6", "115_7", "116", "116_1", "116_2", "116_3", "117", "117_0241", "117_0243", "117_1", "117_2", "117_3", "117_4", "118", "118_1", "118_2", "118_3", "119", "119_1", "119_4", "119_5", "119_6", "119_71", "119_72", "119_73", "119_74", "119_9", "120_51", "120_52", "120_53", "120_55", "120_57", "120_82", "120_83", "120_84", "120_87", "121_1", "121_2", "121_3", "121_99", "123_1", "123_3", "123_6", "123_9", "124_1", "124_2", "124_25", "124_3", "125", "125_11", "125_12", "125_99", "126", "126_56", "126_58", "126_6", "126_7", "126_72", "126_74", "126_76", "126_8", "126_9", "126_95", "129_13", "129_14", "129_24", "130_4", "131", "131_01", "131_25", "131_4", "131_6", "131_7", "131_8", "131_9", "132", "132_05", "132_4", "132_8", "132_9", "132_95", "133", "133_2", "133_4", "133_6", "133_7", "133_8", "134", "135", "135_1", "135_2", "135_3", "135_4", "136", "136_5", "137_45", "138", "139_2", "142", "142_1", "142_5", "142_98", "142_99", "150_1", "150_2", "150_9", "160_1", "160_12", "160_14", "160_15", "160_16", "160_17", "160_19", "160_2", "160_3", "160_4", "160_6", "161_2", "161_21", "161_22", "161_23", "161_25", "161_26", "161_27", "161_3", "161_35", "161_4", "161_43", "161_45", "161_5", "161_6", "161_7", "161_8", "161_81", "161_82", "161_83", "161_91", "161_92", "161_93", "161_94", "161_99", "162_1", "162_3", "162_6", "162_8", "162_91", "162_92", "162_93", "162_94", "162_95", "162_99", "163_85", "163_98", "163_99", "164", "164_08", "164_1", "164_14", "164_15", "164_17", "164_18", "164_2", "164_3", "164_33", "164_4", "164_42", "164_43", "164_45", "164_46", "164_5", "164_52", "164_6", "164_7", "164_8", "164_9", "165", "165_1", "165_2", "165_3", "165_55", "165_59", "165_7", "166", "166_12", "166_13", "166_3", "167", "168", "169", "169_3", "169_99", "183_2", "190_1", "190_2", "194_3", "194_4", "194_5", "195_1", "195_2", "195_3", "195_4", "195_6", "201", "210", "211_1", "211_2", "211_3", "211_4", "211_5", "211_6", "211_7", "211_8", "211_9", "212_1", "212_2", "212_3", "212_4", "212_42", "212_6", "212_7", "212_8", "213_2", "213_3", "213_5", "213_9", "216_8", "217_1", "217_2", "217_3", "219_7", "220_1", "220_2", "220_3", "220_4", "220_5", "220_51", "220_52", "220_6", "222", "223", "224", "225", "226", "227", "228", "228_3", "228_4", "228_42", "228_5", "228_6", "228_7", "228_8", "228_9", "231_8", "231_9", "232_11", "232_5", "232_6", "232_71", "232_72", "232_73", "232_74", "233_1", "233_2", "301_61", "301_63", "301_9", "301_91", "301_92", "301_93", "301_94", "341_1", "342", "342_1", "342_2", "342_3", "343", "344_3", "344_5", "344_6", "344_61", "344_62", "344_7", "344_9", "344_91", "345", "345_1", "346", "347", "347_1", "347_3", "347_4", "348", "348_1", "348_2", "348_4", "348_5", "348_6", "348_7", "349", "349_1", "349_2", "349_3", "349_4", "349_7", "349_8", "349_9", "350_1", "350_2", "350_21", "350_3", "350_5", "350_7", "350_8", "350_9", "351_2", "351_51", "351_53", "351_62", "351_7", "351_701", "351_73", "351_81", "351_82", "351_9", "351_91", "352_1", "352_3", "352_4", "352_5", "353", "353_1", "353_2", "353_3", "353_4", "353_5", "354_2", "354_3", "354_5", "354_6", "354_75", "355_1", "355_12", "355_13", "355_2", "355_31", "355_34", "355_35", "355_351", "355_4", "355_5", "355_6", "355_7", "355_8", "355_81", "355_82", "355_9", "355_91", "355_92", "355_93", "355_97", "355_98", "355_99", "356_001", "356_002", "356_003", "356_004", "356_005", "356_006", "356_007", "356_008", "356_009", "356_01", "356_011", "356_012", "356_013", "356_014", "356_015", "356_016", "356_017", "356_018", "356_019", "356_02", "356_021", "356_022", "356_023", "356_11", "356_19", "356_2", "356_21", "356_25", "356_26", "356_3", "356_4", "356_5", "356_6", "356_7", "356_8", "356_85", "356_9", "356_91", "356_93", "356_94", "357", "357_08", "357_09", "357_5", "357_6", "357_69", "357_7", "357_8", "357_91", "357_92", "357_93", "357_94", "357_97", "357_98", "357_99", "358_6", "358_91", "358_98", "358_99", "359", "359_1", "359_94", "361_2", "361_3", "363", "363_1", "363_21", "363_3", "363_31", "363_32", "363_33", "363_34", "364_1", "364_3", "364_5", "364_6", "364_7", "365_011", "365_012", "365_013", "365_014", "365_015", "365_016", "365_017", "365_018", "365_021", "365_022", "365_023", "365_024", "365_025", "365_026", "365_027", "365_028", "365_029", "365_031", "365_032", "365_033", "365_034", "365_035", "365_036", "365_037", "365_038", "365_039", "365_041", "365_042", "365_043", "365_044", "365_045", "365_046", "365_11", "365_12", "365_13", "365_14", "365_15", "366_01", "366_02", "366_11", "366_12", "366_13", "366_17", "366_2", "367", "367_1", "367_11", "368_001", "368_002", "372", "389_9", "390_01", "390_02", "390_03", "390_04", "391", "391_1", "391_23", "391_72", "391_984", "392_2", "392_3", "392_4", "392_41", "392_42", "392_43", "392_5", "392_6", "392_7", "392_8", "392_9", "393", "393_1", "393_2", "393_3", "393_41", "394_71", "394_72", "394_73", "394_81", "394_82", "394_83", "394_84", "394_85", "394_86", "394_88", "395", "395_1", "395_2", "395_3", "395_4", "396", "396_1", "396_15", "396_195", "396_2", "396_25", "396_27", "396_33", "396_45", "396_5", "396_55", "396_6", "396_7", "396_9", "396_918", "396_94", "399_1", "399_2", "399_3", "399_4", "399_5", "399_6", "403_35", "403_43", "403_44", "403_46", "403_47", "403_51", "403_52", "403_53", "403_54", "403_55", "403_56", "404_44", "404_45", "404_46", "404_472", "404_51", "404_52", "404_57", "404_58", "404_59", "404_61", "404_91", "404_92", "404_93", "404_94", "404_95", "405_1", "405_2", "405_3", "405_4", "405_5", "405_6", "406_41", "407_5", "407_6", "407_7", "408", "408_11", "408_32", "408_33", "408_34", "408_42", "409_1", "409_2", "409_31", "409_32", "409_41", "409_45", "409_61", "409_62", "409_63", "409_64", "409_66", "409_67", "409_75", "409_76", "409_823", "409_831", "409_832", "409_833", "409_845", "409_86", "409_92", "409_95", "409_96", "409_97", "410_1", "410_2", "410_3", "410_4", "410_5", "410_6", "410_7", "410_8", "410_9", "411", "411_2", "411_3", "411_5", "412", "413_1", "413_4", "413_5", "413_7", "414_06", "414_07", "417_1", "420_1", "420_13", "420_131", "420_132", "420_133", "420_135", "420_137", "420_138", "420_14", "420_141", "420_15", "420_16", "420_17", "420_19", "420_1999", "420_2", "420_3", "420_4", "420_5", "420_51", "420_52", "420_53", "420_54", "420_55", "420_6", "420_7", "420_8", "420_92", "420_97", "420_98", "420_99", "421_2", "421_3", "421_4", "421_5", "421_6", "421_7", "421_9", "422", "422_2", "423", "423_4", "423_5", "423_6", "423_9", "430_2", "430_3", "430_5", "430_6", "430_9", "431", "434", "435", "440_2", "440_3", "440_45", "440_5", "440_8", "441_2", "441_3", "441_4", "441_6", "442_2", "442_3", "442_4", "442_5", "442_6", "442_7", "442_8", "443", "443_2", "443_4", "443_6", "443_75", "443_76", "443_8", "444", "444_1", "444_2", "444_21", "444_3", "444_4", "445_3", "445_4", "445_5", "445_6", "446", "446_4", "446_5", "446_6", "446_7", "447", "451", "451_1", "451_4", "451_5", "451_6", "452", "452_1", "452_2", "452_3", "452_4", "452_5", "452_51", "452_6", "452_7", "452_8", "452_9", "453", "454", "454_1", "455_1", "455_5", "456", "457_1", "457_2", "457_3", "457_4", "457_5", "457_6", "458_2", "458_3", "458_5", "458_6", "458_7", "470", "470_1", "470_2", "470_3", "470_5", "470_6", "538", "550", "560", "577", "577_4", "579_1", "579_2", "579_5", "579_6", "600_7", "601_3", "601_4", "601_6", "601_71", "601_72", "601_73", "601_74", "601_75", "601_76", "601_79", "601_81", "601_82", "601_83", "601_86", "601_87", "601_91", "601_93", "601_95", "601_96", "601_97", "603_01", "603_02", "603_03", "603_04", "604_26", "604_3", "604_4", "604_45", "604_48", "604_5", "604_55", "604_66", "604_68", "604_77", "604_8", "615", "615_5", "615_6", "615_7", "615_8", "615_9", "620", "625", "627", "627_5", "627_7", "627_9", "631", "631_1", "631_2", "631_3", "631_4", "631_5", "631_6", "631_7", "631_8", "631_9", "633", "633_1", "634", "634_2", "634_4", "634_6", "650_1", "651", "653", "655", "655_2", "655_201", "655_202", "655_203", "656", "660_1", "661", "661_11", "661_3", "661_4", "661_41", "661_5", "661_69", "661_7", "662", "663", "663_2", "663_3", "663_4", "664_1", "664_2", "664_3", "665_1", "665_2", "667", "667_1", "667_2", "667_3", "669_1", "669_9", "690", "690_1", "690_2", "690_5", "690_7", "691", "691_1", "691_6", "691_7", "693", "693_2", "693_3", "693_5", "693_6", "694_1", "694_8", "695", "695_1", "695_3", "695_4", "695_5", "695_6", "695_8", "695_9", "696", "696_1", "696_2", "696_3", "696_4", "696_5", "696_7", "696_9", "697", "697_2", "697_3", "697_5", "698_4", "698_6", "698_9", "699_55", "699_57", "699_6", "699_81", "699_82", "699_83", "699_84", "699_85", "699_86", "699_88", "700_1", "700_2", "702_001", "702_01", "702_09", "703_1", "704_001", "704_101", "704_102", "704_103", "704_104", "704_105", "704_106", "704_108", "704_109", "711", "713", "713_2", "713_3", "714_1", "720_1", "720_3", "720_4", "720_5", "723", "724", "725", "726", "727_1", "727_2", "727_29", "727_3", "727_4", "727_5", "727_7", "727_802", "727_808", "727_809", "727_814", "727_815", "727_817", "727_824", "727_831", "727_833", "728", "728_44", "728_441", "728_442", "728_45", "728_46", "728_904", "729", "730", "731", "735", "735_1", "736", "738", "738_1", "740", "740_1", "741_1", "741_2", "741_3", "741_4", "741_5", "741_6", "741_7", "741_8", "741_9", "741_93", "741_97", "741_99", "742", "742_1", "742_13", "742_14", "742_4", "742_5", "742_6", "743", "743_3", "743_4", "743_5", "743_6", "743_91", "743_92", "745_1", "745_2", "745_3", "745_4", "745_5", "745_55", "745_6", "748", "748_2", "748_25", "748_3", "757_011", "757_014", "757_018", "757_03", "757_04", "757_05", "757_071", "757_11", "757_12", "757_13", "757_14", "757_2", "757_3", "757_31", "757_32", "757_4", "757_41", "757_5", "770", "771", "771_1", "771_2", "771_3", "771_4", "771_5", "771_6", "771_7", "771_8", "771_9", "774", "776", "776_1", "776_2", "776_3", "776_4", "776_999", "778", "779_001", "779_002", "779_003", "779_004", "779_005", "779_1", "779_2", "779_3", "779_4", "783", "783_9", "785", "785_1", "785_2", "785_5", "786", "787_5", "789_5", "790_01", "790_02", "790_03", "790_04", "790_05", "790_07", "790_08", "790_1", "790_2", "790_3", "790_31", "790_4", "790_403", "790_404", "790_405", "790_5", "790_51", "790_6", "790_72", "798_1", "798_2", "798_5", "798_6", "798_7", "798_8", "798_9", "799_1", "799_2", "799_31", "799_33", "799_34", "799_4", "799_49", "799_51", "799_6", "800", "801", "801_1", "801_42", "801_43", "801_45", "801_5", "801_55", "801_9", "801_95", "802_1", "802_3", "802_4", "810_1", "810_2", "810_4", "810_7", "810_8", "810_9", "811_1", "811_4", "811_5", "811_6", "811_7", "811_9", "815", "839_01", "839_7", "853_1", "853_3", "853_7", "860_2", "860_3", "860_4", "860_5", "860_6", "860_7", "860_8", "860_9", "861", "863", "863_1", "863_2", "863_3", "863_4", "863_6", "863_7", "863_8", "863_9", "864_1", "869_1", "869_2", "869_3", "870", "910", "910_2", "910_7", "911", "911_2", "912_3", "912_4", "912_5", "912_7", "912_8", "912_9", "913", "914", "915", "920", "920_1", "920_2", "920_3", "920_4", "920_5", "920_6", "940", "984_1", "984_5", "984_8", "984_9", "987_5", "987_6", "990_8", "991_1", "991_11", "991_8", "995", "995_2", "996", "999_2", "999_22", "1927_2", "1927_23", "1927_24", "1927_3", "1927_4011", "1927_41", "2000", "2001", "2005_001", "2005_002", "2005_02", "2005_021", "2005_03", "2005_2", "2005_4", "2005_41", "2005_42", "2005_6361", "2005_6362", "2005_6366", "2005_66", "2005_71", "2005_81", "2005_82", "2005_83", "2005_84", "2005_85", "2005_86", "2005_87", "2005_872", "2005_88", "2005_99", "2006_03", "2006_031", "2006_034", "2006_04", "2006_1", "2006_13", "2006_15", "2006_17", "2006_171", "2006_19", "2006_532", "2006_539", "2006_5641", "2006_5715", "2006_575", "2006_5759", "2006_5762", "2006_5831", "2006_5838", "2006_5841", "2006_5842", "2006_5843", "2006_587", "2006_599", "2006_621", "2006_63", "2006_631", "2006_65", "2006_67", "2006_671", "2006_672", "2006_68", "2006_69", "2006_8", "2006_911", "2006_912", "2006_914", "2006_915", "2006_917", "2006_9191", "2006_9192", "2006_9193", "2006_923", "2006_924", "2006_927", "2006_928", "2006_93", "2006_931", "2006_9412", "2006_9413", "2006_9414", "2006_9421", "2006_9422", "2040", "2041", "2041_5", "2041_6", "2041_7", "2042", "2042_5", "2043", "2043_5", "2044", "2048_1", "2056", "2056_2", "2056_31", "2100", "2101_1", "2101_2", "2101_3", "2101_5", "2101_6", "2101_7", "2261", "2261_1", "2261_2", "2261_21", "2261_22", "2261_24", "2261_3", "2261_4", "2261_5", "2261_6", "2261_7", "2261_8", "2261_9", "2262", "2262_1", "2262_2", "2262_3", "2262_4", "2262_5", "2262_6", "2262_7", "2262_8", "2263", "2263_1", "2263_2", "2263_3", "2263_5", "2263_6", "2263_7", "2263_8", "2275_3", "2275_4", "3001", "6002_04", "6003", "6007", "6009", "6910", "6910_2", "6910_5", "6910_9", "6911", "6912", "6913", "6914_1", "6914_2", "6914_3", "6914_4", "6914_6", "6914_7", "6914_8", "6914_9", "6915_1", "6915_11", "6915_2", "6915_3", "6915_4", "6915_5", "6915_6", "6915_9", "6916", "6916_2", "6916_3", "6917", "6918_1", "6920_1", "6920_5", "6921", "6922", "6924", "6924_1", "6924_2", "6924_3", "6925", "6925_2", "6925_3", "6926", "6927", "6928", "6928_1", "6928_2", "6928_3", "6929", "7100", "7100_1", "7100_2", "7100_3", "7100_4", "7100_5", "7100_6", "7101_1", "7101_2", "7101_3", "7103_3", "7103_5", "7105_1", "7105_2", "7105_3", "7105_4", "7105_5", "7105_7", "7105_8", "7105_9", "7106_1", "7106_2", "7106_3", "7106_4", "7106_5", "7106_6", "7106_7", "7106_8", "7107_1", "7107_2", "7107_4", "7107_6", "7107_7", "7109", "7115_1", "7115_3", "7115_5", "7115_6", "7118_21", "7118_25", "7118_29", "7335_7", "7336_3", "7336_6", "7336_8", "7336_9", "8925_2", "8925_3", "8925_4", "8925_6", "8925_8", "8925_9", "8925_93", "8925_94", "8925_95", "8925_97", "8925_98", "8925_99", "8926", "8926_2", "8926_3", "8926_4", "8926_5", "8926_6", "8926_72", "8926_73", "8926_74", "8926_75", "8926_76", "8927_9", "8930", "8930_1", "8930_2", "8930_4", "8930_6", "8930_8", "8932_1", "8932_2", "8935_91", "8969", "8969_02", "8969_03", "8970_1", "8972_3", "8973", "8973_3", "8980", "8984_1", "8984_3", "8984_4", "8985_1", "8987_1", "8987_2", "8989_2", "8989_3", "8989_51", "8989_518", "8989_52", "8991", "8991_6", "8992_2", "8992_3", "8993", "8993_1", "8994_1", "8994_5", "11200", "11500_1", "11500_3", "11500_5", "14197", "14197_5", "14199_999", "15050_12", "15050_14", "15050_19", "16200", "16201", "16202", "16203", "16204", "16205", "16206", "16207", "16209", "18000", "18000_1", "19080_1", "19081_3", "19081_4", "19200_113", "19200_114", "19222_1", "19222_2", "19222_25", "19222_35", "19222_4", "19222_41", "19222_42", "19222_43", "19222_5", "19222_61", "19222_63", "19222_64", "19222_71", "19222_76", "19233", "19233_1", "19233_8", "19235", "19235_1", "19601_11", "19601_12", "19601_14", "19601_16", "19601_17", "19601_18", "19601_19", "19601_22", "19601_23", "19605_21", "19605_22", "19605_24", "19605_25", "19605_26", "19605_27", "19605_3", "19605_5", "19610", "19610_6", "19610_71", "19610_82", "19619_1", "19619_2", "19619_51", "19619_9", "19620_14", "19620_15", "19620_16", "19620_2", "19620_21", "19620_29", "19620_3", "19620_31", "19620_4", "19620_41", "19620_51", "19620_61", "19620_701", "19620_702", "19620_71", "19620_87", "19620_871", "19620_95", "19620_96", "19625_2", "19625_3", "19625_4", "19630_12", "19631", "19634", "19640_11", "19640_12", "19640_14", "19640_15", "19640_151", "19640_16", "19640_17", "19640_18", "19640_3", "19640_36", "19640_38", "19640_59", "19640_68", "19640_7", "19640_71", "19640_73", "19640_75", "19640_76", "19640_79", "19655", "19665", "19665_3", "19665_8", "19665_91", "19685_01", "19685_31", "19685_41", "19685_5", "19685_6", "19685_62", "19685_63", "19685_9001", "19900", "19905", "19905_2", "19908", "19908_1", "19908_2", "19908_3", "19908_4", "19908_6", "19908_61", "19908_7", "19908_71", "19908_72", "19908_8", "19909", "19909_1", "19920", "19925", "19925_2", "25002_1", "100100_0021", "100100_00299", "100100_003", "100100_006", "100100_007", "100100_0074", "100100_012", "100100_0301", "100100_0302", "100100_045", "100150_002", "100150_002001", "100150_004", "100150_0043", "100199_001", "100199_0011", "100220", "100220_1", "100220_2", "100222", "100222_1", "100222_2", "120750_1", "120750_2", "120750_3", "120750_9", "120751", "177100_12", "190004", "190012", "190013", "190050_9", "190060", "190077", "501004", "501013", "503330", "503330_2", "503332", "503333", "503334", "503335", "503336", "503337", "503338", "503338_1", "503339", "503339_1", "503339_2", "503339_3", "503339_5", "503339_9", "503340", "503341", "503342", "503344", "503346_1", "503347", "504025", "504026", "509850", "509850_1", "509850_3", "509850_4", "509850_5", "509850_7", "509850_8", "521550", "528053", "528064", "528327", "528329", "531179", "537015", "537025", "539390_1", "539394_45", "546243", "550011_3", "550011_4", "580950_1", "580950_2", "580950_3", "580950_5", "580950_6", "580950_7", "580950_8", "612418", "612418_1", "612418_4", "612418_5", "612418_6", "612418_91", "623036", "623336", "653000", "653000_1", "653000_2", "653015", "653204", "654008", "654009_01", "654009_1", "654009_2", "654009_3", "657000", "662915", "662915_1", "662915_99", "663424", "663991_1", "663991_2", "673722", "677080", "677082", "677082_07", "677082_08", "677082_09", "678037", "687000", "687001", "687002", "687003", "687004", "687005", "687006", "687007", "687008", "687009", "687010", "687011", "687012", "687013", "687014", "687015", "687016", "687017", "687018", "687019", "687020", "687021", "687022", "687024", "687025", "687026", "687027", "687028", "687029", "687030", "687031", "687032", "687033", "687034", "687035", "687036", "687037", "687038", "687039", "687040", "687041", "687042", "687043", "687044", "687045", "687046", "687047", "687048", "687049", "687050", "687051", "687052", "687053", "687056", "687057", "687058", "687060", "687061", "687062", "687066", "687067", "687068", "687070", "687073", "687100", "687101", "687102", "687103", "687105", "687177_1", "687500", "687915", "688652", "689072", "689072_1", "691787", "692900", "692901", "692902", "791810_1", "791810_2", "791810_3", "791810_4", "791810_5", "791810_6", "791811", "791811_1", "791811_2", "791811_3", "791811_4", "791812", "791813", "791814", "800000", "800000_21", "800000_22", "1200036", "6411400", "6411401", "6411402", "6411403", "6411404", "6411405", "6411406", "6411408", "6411409", "6411410", "6411411", "6411412", "6411413", "6411414", "6411415", "6411417", "6411418", "6411421", "6411423", "6411424", "6680890", "9000010_15", "9000010_18", "9000080_11", "9002313_15", "9002313_19", "9002313_2", "9002313_21", "9002313_22", "9002313_23", "9002313_24", "9002313_25", "9002313_26", "9002313_27", "9002313_28", "9002313_29", "9002313_34", "9002313_35", "9002313_36", "9002313_37", "9002313_38", "9002313_56", "9002313_58", "9002313_77", "9002313_83", "9002313_89", "9002313_9", "9002313_91", "9002313_93", "9002313_99", "9009032_3", "9009032_5", "9999999_04", "9999999_09", "9999999_14", "9999999_15", "9999999_17", "9999999_28", "19000161_1"]

# TMP HERE
FLIPs = ["2", "3_9", "38_1", "53_41", "53_51", "55", "58_601", "63", "67_9", "68", "357_1", "396_4", "2006_82", "19908_5"]

