from skoolkittest import SkoolKitTestCase
from skoolkit.traceutils import disassemble

OPCODES_HEX = {
    '00000000': ("NOP", 1),
    '01010101': ("LD BC,$0101", 3),
    '02020202': ("LD (BC),A", 1),
    '03030303': ("INC BC", 1),
    '04040404': ("INC B", 1),
    '05050505': ("DEC B", 1),
    '06060606': ("LD B,$06", 2),
    '07070707': ("RLCA", 1),
    '08080808': ("EX AF,AF'", 1),
    '09090909': ("ADD HL,BC", 1),
    '0A0A0A0A': ("LD A,(BC)", 1),
    '0B0B0B0B': ("DEC BC", 1),
    '0C0C0C0C': ("INC C", 1),
    '0D0D0D0D': ("DEC C", 1),
    '0E0E0E0E': ("LD C,$0E", 2),
    '0F0F0F0F': ("RRCA", 1),
    '10FE1010': ("DJNZ $0000", 2),
    '11111111': ("LD DE,$1111", 3),
    '12121212': ("LD (DE),A", 1),
    '13131313': ("INC DE", 1),
    '14141414': ("INC D", 1),
    '15151515': ("DEC D", 1),
    '16161616': ("LD D,$16", 2),
    '17171717': ("RLA", 1),
    '18181818': ("JR $001A", 2),
    '19191919': ("ADD HL,DE", 1),
    '1A1A1A1A': ("LD A,(DE)", 1),
    '1B1B1B1B': ("DEC DE", 1),
    '1C1C1C1C': ("INC E", 1),
    '1D1D1D1D': ("DEC E", 1),
    '1E1E1E1E': ("LD E,$1E", 2),
    '1F1F1F1F': ("RRA", 1),
    '20202020': ("JR NZ,$0022", 2),
    '21212121': ("LD HL,$2121", 3),
    '22222222': ("LD ($2222),HL", 3),
    '23232323': ("INC HL", 1),
    '24242424': ("INC H", 1),
    '25252525': ("DEC H", 1),
    '26262626': ("LD H,$26", 2),
    '27272727': ("DAA", 1),
    '28282828': ("JR Z,$002A", 2),
    '29292929': ("ADD HL,HL", 1),
    '2A2A2A2A': ("LD HL,($2A2A)", 3),
    '2B2B2B2B': ("DEC HL", 1),
    '2C2C2C2C': ("INC L", 1),
    '2D2D2D2D': ("DEC L", 1),
    '2E2E2E2E': ("LD L,$2E", 2),
    '2F2F2F2F': ("CPL", 1),
    '30303030': ("JR NC,$0032", 2),
    '31313131': ("LD SP,$3131", 3),
    '32323232': ("LD ($3232),A", 3),
    '33333333': ("INC SP", 1),
    '34343434': ("INC (HL)", 1),
    '35353535': ("DEC (HL)", 1),
    '36363636': ("LD (HL),$36", 2),
    '37373737': ("SCF", 1),
    '38383838': ("JR C,$003A", 2),
    '39393939': ("ADD HL,SP", 1),
    '3A3A3A3A': ("LD A,($3A3A)", 3),
    '3B3B3B3B': ("DEC SP", 1),
    '3C3C3C3C': ("INC A", 1),
    '3D3D3D3D': ("DEC A", 1),
    '3E3E3E3E': ("LD A,$3E", 2),
    '3F3F3F3F': ("CCF", 1),
    '40404040': ("LD B,B", 1),
    '41414141': ("LD B,C", 1),
    '42424242': ("LD B,D", 1),
    '43434343': ("LD B,E", 1),
    '44444444': ("LD B,H", 1),
    '45454545': ("LD B,L", 1),
    '46464646': ("LD B,(HL)", 1),
    '47474747': ("LD B,A", 1),
    '48484848': ("LD C,B", 1),
    '49494949': ("LD C,C", 1),
    '4A4A4A4A': ("LD C,D", 1),
    '4B4B4B4B': ("LD C,E", 1),
    '4C4C4C4C': ("LD C,H", 1),
    '4D4D4D4D': ("LD C,L", 1),
    '4E4E4E4E': ("LD C,(HL)", 1),
    '4F4F4F4F': ("LD C,A", 1),
    '50505050': ("LD D,B", 1),
    '51515151': ("LD D,C", 1),
    '52525252': ("LD D,D", 1),
    '53535353': ("LD D,E", 1),
    '54545454': ("LD D,H", 1),
    '55555555': ("LD D,L", 1),
    '56565656': ("LD D,(HL)", 1),
    '57575757': ("LD D,A", 1),
    '58585858': ("LD E,B", 1),
    '59595959': ("LD E,C", 1),
    '5A5A5A5A': ("LD E,D", 1),
    '5B5B5B5B': ("LD E,E", 1),
    '5C5C5C5C': ("LD E,H", 1),
    '5D5D5D5D': ("LD E,L", 1),
    '5E5E5E5E': ("LD E,(HL)", 1),
    '5F5F5F5F': ("LD E,A", 1),
    '60606060': ("LD H,B", 1),
    '61616161': ("LD H,C", 1),
    '62626262': ("LD H,D", 1),
    '63636363': ("LD H,E", 1),
    '64646464': ("LD H,H", 1),
    '65656565': ("LD H,L", 1),
    '66666666': ("LD H,(HL)", 1),
    '67676767': ("LD H,A", 1),
    '68686868': ("LD L,B", 1),
    '69696969': ("LD L,C", 1),
    '6A6A6A6A': ("LD L,D", 1),
    '6B6B6B6B': ("LD L,E", 1),
    '6C6C6C6C': ("LD L,H", 1),
    '6D6D6D6D': ("LD L,L", 1),
    '6E6E6E6E': ("LD L,(HL)", 1),
    '6F6F6F6F': ("LD L,A", 1),
    '70707070': ("LD (HL),B", 1),
    '71717171': ("LD (HL),C", 1),
    '72727272': ("LD (HL),D", 1),
    '73737373': ("LD (HL),E", 1),
    '74747474': ("LD (HL),H", 1),
    '75757575': ("LD (HL),L", 1),
    '76767676': ("HALT", 1),
    '77777777': ("LD (HL),A", 1),
    '78787878': ("LD A,B", 1),
    '79797979': ("LD A,C", 1),
    '7A7A7A7A': ("LD A,D", 1),
    '7B7B7B7B': ("LD A,E", 1),
    '7C7C7C7C': ("LD A,H", 1),
    '7D7D7D7D': ("LD A,L", 1),
    '7E7E7E7E': ("LD A,(HL)", 1),
    '7F7F7F7F': ("LD A,A", 1),
    '80808080': ("ADD A,B", 1),
    '81818181': ("ADD A,C", 1),
    '82828282': ("ADD A,D", 1),
    '83838383': ("ADD A,E", 1),
    '84848484': ("ADD A,H", 1),
    '85858585': ("ADD A,L", 1),
    '86868686': ("ADD A,(HL)", 1),
    '87878787': ("ADD A,A", 1),
    '88888888': ("ADC A,B", 1),
    '89898989': ("ADC A,C", 1),
    '8A8A8A8A': ("ADC A,D", 1),
    '8B8B8B8B': ("ADC A,E", 1),
    '8C8C8C8C': ("ADC A,H", 1),
    '8D8D8D8D': ("ADC A,L", 1),
    '8E8E8E8E': ("ADC A,(HL)", 1),
    '8F8F8F8F': ("ADC A,A", 1),
    '90909090': ("SUB B", 1),
    '91919191': ("SUB C", 1),
    '92929292': ("SUB D", 1),
    '93939393': ("SUB E", 1),
    '94949494': ("SUB H", 1),
    '95959595': ("SUB L", 1),
    '96969696': ("SUB (HL)", 1),
    '97979797': ("SUB A", 1),
    '98989898': ("SBC A,B", 1),
    '99999999': ("SBC A,C", 1),
    '9A9A9A9A': ("SBC A,D", 1),
    '9B9B9B9B': ("SBC A,E", 1),
    '9C9C9C9C': ("SBC A,H", 1),
    '9D9D9D9D': ("SBC A,L", 1),
    '9E9E9E9E': ("SBC A,(HL)", 1),
    '9F9F9F9F': ("SBC A,A", 1),
    'A0A0A0A0': ("AND B", 1),
    'A1A1A1A1': ("AND C", 1),
    'A2A2A2A2': ("AND D", 1),
    'A3A3A3A3': ("AND E", 1),
    'A4A4A4A4': ("AND H", 1),
    'A5A5A5A5': ("AND L", 1),
    'A6A6A6A6': ("AND (HL)", 1),
    'A7A7A7A7': ("AND A", 1),
    'A8A8A8A8': ("XOR B", 1),
    'A9A9A9A9': ("XOR C", 1),
    'AAAAAAAA': ("XOR D", 1),
    'ABABABAB': ("XOR E", 1),
    'ACACACAC': ("XOR H", 1),
    'ADADADAD': ("XOR L", 1),
    'AEAEAEAE': ("XOR (HL)", 1),
    'AFAFAFAF': ("XOR A", 1),
    'B0B0B0B0': ("OR B", 1),
    'B1B1B1B1': ("OR C", 1),
    'B2B2B2B2': ("OR D", 1),
    'B3B3B3B3': ("OR E", 1),
    'B4B4B4B4': ("OR H", 1),
    'B5B5B5B5': ("OR L", 1),
    'B6B6B6B6': ("OR (HL)", 1),
    'B7B7B7B7': ("OR A", 1),
    'B8B8B8B8': ("CP B", 1),
    'B9B9B9B9': ("CP C", 1),
    'BABABABA': ("CP D", 1),
    'BBBBBBBB': ("CP E", 1),
    'BCBCBCBC': ("CP H", 1),
    'BDBDBDBD': ("CP L", 1),
    'BEBEBEBE': ("CP (HL)", 1),
    'BFBFBFBF': ("CP A", 1),
    'C0C0C0C0': ("RET NZ", 1),
    'C1C1C1C1': ("POP BC", 1),
    'C2C2C2C2': ("JP NZ,$C2C2", 3),
    'C3C3C3C3': ("JP $C3C3", 3),
    'C4C4C4C4': ("CALL NZ,$C4C4", 3),
    'C5C5C5C5': ("PUSH BC", 1),
    'C6C6C6C6': ("ADD A,$C6", 2),
    'C7C7C7C7': ("RST $00", 1),
    'C8C8C8C8': ("RET Z", 1),
    'C9C9C9C9': ("RET", 1),
    'CACACACA': ("JP Z,$CACA", 3),
    'CBCBCBCB': ("SET 1,E", 0),
    'CCCCCCCC': ("CALL Z,$CCCC", 3),
    'CDCDCDCD': ("CALL $CDCD", 3),
    'CECECECE': ("ADC A,$CE", 2),
    'CFCFCFCF': ("RST $08", 1),
    'D0D0D0D0': ("RET NC", 1),
    'D1D1D1D1': ("POP DE", 1),
    'D2D2D2D2': ("JP NC,$D2D2", 3),
    'D3D3D3D3': ("OUT ($D3),A", 2),
    'D4D4D4D4': ("CALL NC,$D4D4", 3),
    'D5D5D5D5': ("PUSH DE", 1),
    'D6D6D6D6': ("SUB $D6", 2),
    'D7D7D7D7': ("RST $10", 1),
    'D8D8D8D8': ("RET C", 1),
    'D9D9D9D9': ("EXX", 1),
    'DADADADA': ("JP C,$DADA", 3),
    'DBDBDBDB': ("IN A,($DB)", 2),
    'DCDCDCDC': ("CALL C,$DCDC", 3),
    'DDDDDDDD': ("DEFB $DD", 0),
    'DEDEDEDE': ("SBC A,$DE", 2),
    'DFDFDFDF': ("RST $18", 1),
    'E0E0E0E0': ("RET PO", 1),
    'E1E1E1E1': ("POP HL", 1),
    'E2E2E2E2': ("JP PO,$E2E2", 3),
    'E3E3E3E3': ("EX (SP),HL", 1),
    'E4E4E4E4': ("CALL PO,$E4E4", 3),
    'E5E5E5E5': ("PUSH HL", 1),
    'E6E6E6E6': ("AND $E6", 2),
    'E7E7E7E7': ("RST $20", 1),
    'E8E8E8E8': ("RET PE", 1),
    'E9E9E9E9': ("JP (HL)", 1),
    'EAEAEAEA': ("JP PE,$EAEA", 3),
    'EBEBEBEB': ("EX DE,HL", 1),
    'ECECECEC': ("CALL PE,$ECEC", 3),
    'EDEDEDED': ("DEFB $ED,$ED", 0),
    'EEEEEEEE': ("XOR $EE", 2),
    'EFEFEFEF': ("RST $28", 1),
    'F0F0F0F0': ("RET P", 1),
    'F1F1F1F1': ("POP AF", 1),
    'F2F2F2F2': ("JP P,$F2F2", 3),
    'F3F3F3F3': ("DI", 1),
    'F4F4F4F4': ("CALL P,$F4F4", 3),
    'F5F5F5F5': ("PUSH AF", 1),
    'F6F6F6F6': ("OR $F6", 2),
    'F7F7F7F7': ("RST $30", 1),
    'F8F8F8F8': ("RET M", 1),
    'F9F9F9F9': ("LD SP,HL", 1),
    'FAFAFAFA': ("JP M,$FAFA", 3),
    'FBFBFBFB': ("EI", 1),
    'FCFCFCFC': ("CALL M,$FCFC", 3),
    'FDFDFDFD': ("DEFB $FD", 0),
    'FEFEFEFE': ("CP $FE", 2),
    'FFFFFFFF': ("RST $38", 1),
    'CB000000': ("RLC B", 2),
    'CB010101': ("RLC C", 2),
    'CB020202': ("RLC D", 2),
    'CB030303': ("RLC E", 2),
    'CB040404': ("RLC H", 2),
    'CB050505': ("RLC L", 2),
    'CB060606': ("RLC (HL)", 2),
    'CB070707': ("RLC A", 2),
    'CB080808': ("RRC B", 2),
    'CB090909': ("RRC C", 2),
    'CB0A0A0A': ("RRC D", 2),
    'CB0B0B0B': ("RRC E", 2),
    'CB0C0C0C': ("RRC H", 2),
    'CB0D0D0D': ("RRC L", 2),
    'CB0E0E0E': ("RRC (HL)", 2),
    'CB0F0F0F': ("RRC A", 2),
    'CB101010': ("RL B", 2),
    'CB111111': ("RL C", 2),
    'CB121212': ("RL D", 2),
    'CB131313': ("RL E", 2),
    'CB141414': ("RL H", 2),
    'CB151515': ("RL L", 2),
    'CB161616': ("RL (HL)", 2),
    'CB171717': ("RL A", 2),
    'CB181818': ("RR B", 2),
    'CB191919': ("RR C", 2),
    'CB1A1A1A': ("RR D", 2),
    'CB1B1B1B': ("RR E", 2),
    'CB1C1C1C': ("RR H", 2),
    'CB1D1D1D': ("RR L", 2),
    'CB1E1E1E': ("RR (HL)", 2),
    'CB1F1F1F': ("RR A", 2),
    'CB202020': ("SLA B", 2),
    'CB212121': ("SLA C", 2),
    'CB222222': ("SLA D", 2),
    'CB232323': ("SLA E", 2),
    'CB242424': ("SLA H", 2),
    'CB252525': ("SLA L", 2),
    'CB262626': ("SLA (HL)", 2),
    'CB272727': ("SLA A", 2),
    'CB282828': ("SRA B", 2),
    'CB292929': ("SRA C", 2),
    'CB2A2A2A': ("SRA D", 2),
    'CB2B2B2B': ("SRA E", 2),
    'CB2C2C2C': ("SRA H", 2),
    'CB2D2D2D': ("SRA L", 2),
    'CB2E2E2E': ("SRA (HL)", 2),
    'CB2F2F2F': ("SRA A", 2),
    'CB303030': ("SLL B", 2),
    'CB313131': ("SLL C", 2),
    'CB323232': ("SLL D", 2),
    'CB333333': ("SLL E", 2),
    'CB343434': ("SLL H", 2),
    'CB353535': ("SLL L", 2),
    'CB363636': ("SLL (HL)", 2),
    'CB373737': ("SLL A", 2),
    'CB383838': ("SRL B", 2),
    'CB393939': ("SRL C", 2),
    'CB3A3A3A': ("SRL D", 2),
    'CB3B3B3B': ("SRL E", 2),
    'CB3C3C3C': ("SRL H", 2),
    'CB3D3D3D': ("SRL L", 2),
    'CB3E3E3E': ("SRL (HL)", 2),
    'CB3F3F3F': ("SRL A", 2),
    'CB404040': ("BIT 0,B", 2),
    'CB414141': ("BIT 0,C", 2),
    'CB424242': ("BIT 0,D", 2),
    'CB434343': ("BIT 0,E", 2),
    'CB444444': ("BIT 0,H", 2),
    'CB454545': ("BIT 0,L", 2),
    'CB464646': ("BIT 0,(HL)", 2),
    'CB474747': ("BIT 0,A", 2),
    'CB484848': ("BIT 1,B", 2),
    'CB494949': ("BIT 1,C", 2),
    'CB4A4A4A': ("BIT 1,D", 2),
    'CB4B4B4B': ("BIT 1,E", 2),
    'CB4C4C4C': ("BIT 1,H", 2),
    'CB4D4D4D': ("BIT 1,L", 2),
    'CB4E4E4E': ("BIT 1,(HL)", 2),
    'CB4F4F4F': ("BIT 1,A", 2),
    'CB505050': ("BIT 2,B", 2),
    'CB515151': ("BIT 2,C", 2),
    'CB525252': ("BIT 2,D", 2),
    'CB535353': ("BIT 2,E", 2),
    'CB545454': ("BIT 2,H", 2),
    'CB555555': ("BIT 2,L", 2),
    'CB565656': ("BIT 2,(HL)", 2),
    'CB575757': ("BIT 2,A", 2),
    'CB585858': ("BIT 3,B", 2),
    'CB595959': ("BIT 3,C", 2),
    'CB5A5A5A': ("BIT 3,D", 2),
    'CB5B5B5B': ("BIT 3,E", 2),
    'CB5C5C5C': ("BIT 3,H", 2),
    'CB5D5D5D': ("BIT 3,L", 2),
    'CB5E5E5E': ("BIT 3,(HL)", 2),
    'CB5F5F5F': ("BIT 3,A", 2),
    'CB606060': ("BIT 4,B", 2),
    'CB616161': ("BIT 4,C", 2),
    'CB626262': ("BIT 4,D", 2),
    'CB636363': ("BIT 4,E", 2),
    'CB646464': ("BIT 4,H", 2),
    'CB656565': ("BIT 4,L", 2),
    'CB666666': ("BIT 4,(HL)", 2),
    'CB676767': ("BIT 4,A", 2),
    'CB686868': ("BIT 5,B", 2),
    'CB696969': ("BIT 5,C", 2),
    'CB6A6A6A': ("BIT 5,D", 2),
    'CB6B6B6B': ("BIT 5,E", 2),
    'CB6C6C6C': ("BIT 5,H", 2),
    'CB6D6D6D': ("BIT 5,L", 2),
    'CB6E6E6E': ("BIT 5,(HL)", 2),
    'CB6F6F6F': ("BIT 5,A", 2),
    'CB707070': ("BIT 6,B", 2),
    'CB717171': ("BIT 6,C", 2),
    'CB727272': ("BIT 6,D", 2),
    'CB737373': ("BIT 6,E", 2),
    'CB747474': ("BIT 6,H", 2),
    'CB757575': ("BIT 6,L", 2),
    'CB767676': ("BIT 6,(HL)", 2),
    'CB777777': ("BIT 6,A", 2),
    'CB787878': ("BIT 7,B", 2),
    'CB797979': ("BIT 7,C", 2),
    'CB7A7A7A': ("BIT 7,D", 2),
    'CB7B7B7B': ("BIT 7,E", 2),
    'CB7C7C7C': ("BIT 7,H", 2),
    'CB7D7D7D': ("BIT 7,L", 2),
    'CB7E7E7E': ("BIT 7,(HL)", 2),
    'CB7F7F7F': ("BIT 7,A", 2),
    'CB808080': ("RES 0,B", 2),
    'CB818181': ("RES 0,C", 2),
    'CB828282': ("RES 0,D", 2),
    'CB838383': ("RES 0,E", 2),
    'CB848484': ("RES 0,H", 2),
    'CB858585': ("RES 0,L", 2),
    'CB868686': ("RES 0,(HL)", 2),
    'CB878787': ("RES 0,A", 2),
    'CB888888': ("RES 1,B", 2),
    'CB898989': ("RES 1,C", 2),
    'CB8A8A8A': ("RES 1,D", 2),
    'CB8B8B8B': ("RES 1,E", 2),
    'CB8C8C8C': ("RES 1,H", 2),
    'CB8D8D8D': ("RES 1,L", 2),
    'CB8E8E8E': ("RES 1,(HL)", 2),
    'CB8F8F8F': ("RES 1,A", 2),
    'CB909090': ("RES 2,B", 2),
    'CB919191': ("RES 2,C", 2),
    'CB929292': ("RES 2,D", 2),
    'CB939393': ("RES 2,E", 2),
    'CB949494': ("RES 2,H", 2),
    'CB959595': ("RES 2,L", 2),
    'CB969696': ("RES 2,(HL)", 2),
    'CB979797': ("RES 2,A", 2),
    'CB989898': ("RES 3,B", 2),
    'CB999999': ("RES 3,C", 2),
    'CB9A9A9A': ("RES 3,D", 2),
    'CB9B9B9B': ("RES 3,E", 2),
    'CB9C9C9C': ("RES 3,H", 2),
    'CB9D9D9D': ("RES 3,L", 2),
    'CB9E9E9E': ("RES 3,(HL)", 2),
    'CB9F9F9F': ("RES 3,A", 2),
    'CBA0A0A0': ("RES 4,B", 2),
    'CBA1A1A1': ("RES 4,C", 2),
    'CBA2A2A2': ("RES 4,D", 2),
    'CBA3A3A3': ("RES 4,E", 2),
    'CBA4A4A4': ("RES 4,H", 2),
    'CBA5A5A5': ("RES 4,L", 2),
    'CBA6A6A6': ("RES 4,(HL)", 2),
    'CBA7A7A7': ("RES 4,A", 2),
    'CBA8A8A8': ("RES 5,B", 2),
    'CBA9A9A9': ("RES 5,C", 2),
    'CBAAAAAA': ("RES 5,D", 2),
    'CBABABAB': ("RES 5,E", 2),
    'CBACACAC': ("RES 5,H", 2),
    'CBADADAD': ("RES 5,L", 2),
    'CBAEAEAE': ("RES 5,(HL)", 2),
    'CBAFAFAF': ("RES 5,A", 2),
    'CBB0B0B0': ("RES 6,B", 2),
    'CBB1B1B1': ("RES 6,C", 2),
    'CBB2B2B2': ("RES 6,D", 2),
    'CBB3B3B3': ("RES 6,E", 2),
    'CBB4B4B4': ("RES 6,H", 2),
    'CBB5B5B5': ("RES 6,L", 2),
    'CBB6B6B6': ("RES 6,(HL)", 2),
    'CBB7B7B7': ("RES 6,A", 2),
    'CBB8B8B8': ("RES 7,B", 2),
    'CBB9B9B9': ("RES 7,C", 2),
    'CBBABABA': ("RES 7,D", 2),
    'CBBBBBBB': ("RES 7,E", 2),
    'CBBCBCBC': ("RES 7,H", 2),
    'CBBDBDBD': ("RES 7,L", 2),
    'CBBEBEBE': ("RES 7,(HL)", 2),
    'CBBFBFBF': ("RES 7,A", 2),
    'CBC0C0C0': ("SET 0,B", 2),
    'CBC1C1C1': ("SET 0,C", 2),
    'CBC2C2C2': ("SET 0,D", 2),
    'CBC3C3C3': ("SET 0,E", 2),
    'CBC4C4C4': ("SET 0,H", 2),
    'CBC5C5C5': ("SET 0,L", 2),
    'CBC6C6C6': ("SET 0,(HL)", 2),
    'CBC7C7C7': ("SET 0,A", 2),
    'CBC8C8C8': ("SET 1,B", 2),
    'CBC9C9C9': ("SET 1,C", 2),
    'CBCACACA': ("SET 1,D", 2),
    'CBCBCBCB': ("SET 1,E", 2),
    'CBCCCCCC': ("SET 1,H", 2),
    'CBCDCDCD': ("SET 1,L", 2),
    'CBCECECE': ("SET 1,(HL)", 2),
    'CBCFCFCF': ("SET 1,A", 2),
    'CBD0D0D0': ("SET 2,B", 2),
    'CBD1D1D1': ("SET 2,C", 2),
    'CBD2D2D2': ("SET 2,D", 2),
    'CBD3D3D3': ("SET 2,E", 2),
    'CBD4D4D4': ("SET 2,H", 2),
    'CBD5D5D5': ("SET 2,L", 2),
    'CBD6D6D6': ("SET 2,(HL)", 2),
    'CBD7D7D7': ("SET 2,A", 2),
    'CBD8D8D8': ("SET 3,B", 2),
    'CBD9D9D9': ("SET 3,C", 2),
    'CBDADADA': ("SET 3,D", 2),
    'CBDBDBDB': ("SET 3,E", 2),
    'CBDCDCDC': ("SET 3,H", 2),
    'CBDDDDDD': ("SET 3,L", 2),
    'CBDEDEDE': ("SET 3,(HL)", 2),
    'CBDFDFDF': ("SET 3,A", 2),
    'CBE0E0E0': ("SET 4,B", 2),
    'CBE1E1E1': ("SET 4,C", 2),
    'CBE2E2E2': ("SET 4,D", 2),
    'CBE3E3E3': ("SET 4,E", 2),
    'CBE4E4E4': ("SET 4,H", 2),
    'CBE5E5E5': ("SET 4,L", 2),
    'CBE6E6E6': ("SET 4,(HL)", 2),
    'CBE7E7E7': ("SET 4,A", 2),
    'CBE8E8E8': ("SET 5,B", 2),
    'CBE9E9E9': ("SET 5,C", 2),
    'CBEAEAEA': ("SET 5,D", 2),
    'CBEBEBEB': ("SET 5,E", 2),
    'CBECECEC': ("SET 5,H", 2),
    'CBEDEDED': ("SET 5,L", 2),
    'CBEEEEEE': ("SET 5,(HL)", 2),
    'CBEFEFEF': ("SET 5,A", 2),
    'CBF0F0F0': ("SET 6,B", 2),
    'CBF1F1F1': ("SET 6,C", 2),
    'CBF2F2F2': ("SET 6,D", 2),
    'CBF3F3F3': ("SET 6,E", 2),
    'CBF4F4F4': ("SET 6,H", 2),
    'CBF5F5F5': ("SET 6,L", 2),
    'CBF6F6F6': ("SET 6,(HL)", 2),
    'CBF7F7F7': ("SET 6,A", 2),
    'CBF8F8F8': ("SET 7,B", 2),
    'CBF9F9F9': ("SET 7,C", 2),
    'CBFAFAFA': ("SET 7,D", 2),
    'CBFBFBFB': ("SET 7,E", 2),
    'CBFCFCFC': ("SET 7,H", 2),
    'CBFDFDFD': ("SET 7,L", 2),
    'CBFEFEFE': ("SET 7,(HL)", 2),
    'CBFFFFFF': ("SET 7,A", 2),
    'DD000000': ("DEFB $DD", 1),
    'DD010101': ("DEFB $DD", 1),
    'DD020202': ("DEFB $DD", 1),
    'DD030303': ("DEFB $DD", 1),
    'DD040404': ("DEFB $DD", 1),
    'DD050505': ("DEFB $DD", 1),
    'DD060606': ("DEFB $DD", 1),
    'DD070707': ("DEFB $DD", 1),
    'DD080808': ("DEFB $DD", 1),
    'DD090909': ("ADD IX,BC", 2),
    'DD0A0A0A': ("DEFB $DD", 1),
    'DD0B0B0B': ("DEFB $DD", 1),
    'DD0C0C0C': ("DEFB $DD", 1),
    'DD0D0D0D': ("DEFB $DD", 1),
    'DD0E0E0E': ("DEFB $DD", 1),
    'DD0F0F0F': ("DEFB $DD", 1),
    'DD101010': ("DEFB $DD", 1),
    'DD111111': ("DEFB $DD", 1),
    'DD121212': ("DEFB $DD", 1),
    'DD131313': ("DEFB $DD", 1),
    'DD141414': ("DEFB $DD", 1),
    'DD151515': ("DEFB $DD", 1),
    'DD161616': ("DEFB $DD", 1),
    'DD171717': ("DEFB $DD", 1),
    'DD181818': ("DEFB $DD", 1),
    'DD191919': ("ADD IX,DE", 2),
    'DD1A1A1A': ("DEFB $DD", 1),
    'DD1B1B1B': ("DEFB $DD", 1),
    'DD1C1C1C': ("DEFB $DD", 1),
    'DD1D1D1D': ("DEFB $DD", 1),
    'DD1E1E1E': ("DEFB $DD", 1),
    'DD1F1F1F': ("DEFB $DD", 1),
    'DD202020': ("DEFB $DD", 1),
    'DD212121': ("LD IX,$2121", 4),
    'DD222222': ("LD ($2222),IX", 4),
    'DD232323': ("INC IX", 2),
    'DD242424': ("INC IXh", 2),
    'DD252525': ("DEC IXh", 2),
    'DD262626': ("LD IXh,$26", 3),
    'DD272727': ("DEFB $DD", 1),
    'DD282828': ("DEFB $DD", 1),
    'DD292929': ("ADD IX,IX", 2),
    'DD2A2A2A': ("LD IX,($2A2A)", 4),
    'DD2B2B2B': ("DEC IX", 2),
    'DD2C2C2C': ("INC IXl", 2),
    'DD2D2D2D': ("DEC IXl", 2),
    'DD2E2E2E': ("LD IXl,$2E", 3),
    'DD2F2F2F': ("DEFB $DD", 1),
    'DD303030': ("DEFB $DD", 1),
    'DD313131': ("DEFB $DD", 1),
    'DD323232': ("DEFB $DD", 1),
    'DD333333': ("DEFB $DD", 1),
    'DD343434': ("INC (IX+$34)", 3),
    'DD353535': ("DEC (IX+$35)", 3),
    'DD36FF36': ("LD (IX-$01),$36", 4),
    'DD373737': ("DEFB $DD", 1),
    'DD383838': ("DEFB $DD", 1),
    'DD393939': ("ADD IX,SP", 2),
    'DD3A3A3A': ("DEFB $DD", 1),
    'DD3B3B3B': ("DEFB $DD", 1),
    'DD3C3C3C': ("DEFB $DD", 1),
    'DD3D3D3D': ("DEFB $DD", 1),
    'DD3E3E3E': ("DEFB $DD", 1),
    'DD3F3F3F': ("DEFB $DD", 1),
    'DD404040': ("DEFB $DD", 1),
    'DD414141': ("DEFB $DD", 1),
    'DD424242': ("DEFB $DD", 1),
    'DD434343': ("DEFB $DD", 1),
    'DD444444': ("LD B,IXh", 2),
    'DD454545': ("LD B,IXl", 2),
    'DD464646': ("LD B,(IX+$46)", 3),
    'DD474747': ("DEFB $DD", 1),
    'DD484848': ("DEFB $DD", 1),
    'DD494949': ("DEFB $DD", 1),
    'DD4A4A4A': ("DEFB $DD", 1),
    'DD4B4B4B': ("DEFB $DD", 1),
    'DD4C4C4C': ("LD C,IXh", 2),
    'DD4D4D4D': ("LD C,IXl", 2),
    'DD4E4E4E': ("LD C,(IX+$4E)", 3),
    'DD4F4F4F': ("DEFB $DD", 1),
    'DD505050': ("DEFB $DD", 1),
    'DD515151': ("DEFB $DD", 1),
    'DD525252': ("DEFB $DD", 1),
    'DD535353': ("DEFB $DD", 1),
    'DD545454': ("LD D,IXh", 2),
    'DD555555': ("LD D,IXl", 2),
    'DD565656': ("LD D,(IX+$56)", 3),
    'DD575757': ("DEFB $DD", 1),
    'DD585858': ("DEFB $DD", 1),
    'DD595959': ("DEFB $DD", 1),
    'DD5A5A5A': ("DEFB $DD", 1),
    'DD5B5B5B': ("DEFB $DD", 1),
    'DD5C5C5C': ("LD E,IXh", 2),
    'DD5D5D5D': ("LD E,IXl", 2),
    'DD5E5E5E': ("LD E,(IX+$5E)", 3),
    'DD5F5F5F': ("DEFB $DD", 1),
    'DD606060': ("LD IXh,B", 2),
    'DD616161': ("LD IXh,C", 2),
    'DD626262': ("LD IXh,D", 2),
    'DD636363': ("LD IXh,E", 2),
    'DD646464': ("LD IXh,IXh", 2),
    'DD656565': ("LD IXh,IXl", 2),
    'DD666666': ("LD H,(IX+$66)", 3),
    'DD676767': ("LD IXh,A", 2),
    'DD686868': ("LD IXl,B", 2),
    'DD696969': ("LD IXl,C", 2),
    'DD6A6A6A': ("LD IXl,D", 2),
    'DD6B6B6B': ("LD IXl,E", 2),
    'DD6C6C6C': ("LD IXl,IXh", 2),
    'DD6D6D6D': ("LD IXl,IXl", 2),
    'DD6E6E6E': ("LD L,(IX+$6E)", 3),
    'DD6F6F6F': ("LD IXl,A", 2),
    'DD707070': ("LD (IX+$70),B", 3),
    'DD717171': ("LD (IX+$71),C", 3),
    'DD727272': ("LD (IX+$72),D", 3),
    'DD737373': ("LD (IX+$73),E", 3),
    'DD747474': ("LD (IX+$74),H", 3),
    'DD757575': ("LD (IX+$75),L", 3),
    'DD767676': ("DEFB $DD", 1),
    'DD777777': ("LD (IX+$77),A", 3),
    'DD787878': ("DEFB $DD", 1),
    'DD797979': ("DEFB $DD", 1),
    'DD7A7A7A': ("DEFB $DD", 1),
    'DD7B7B7B': ("DEFB $DD", 1),
    'DD7C7C7C': ("LD A,IXh", 2),
    'DD7D7D7D': ("LD A,IXl", 2),
    'DD7E7E7E': ("LD A,(IX+$7E)", 3),
    'DD7F7F7F': ("DEFB $DD", 1),
    'DD808080': ("DEFB $DD", 1),
    'DD818181': ("DEFB $DD", 1),
    'DD828282': ("DEFB $DD", 1),
    'DD838383': ("DEFB $DD", 1),
    'DD848484': ("ADD A,IXh", 2),
    'DD858585': ("ADD A,IXl", 2),
    'DD868686': ("ADD A,(IX-$7A)", 3),
    'DD878787': ("DEFB $DD", 1),
    'DD888888': ("DEFB $DD", 1),
    'DD898989': ("DEFB $DD", 1),
    'DD8A8A8A': ("DEFB $DD", 1),
    'DD8B8B8B': ("DEFB $DD", 1),
    'DD8C8C8C': ("ADC A,IXh", 2),
    'DD8D8D8D': ("ADC A,IXl", 2),
    'DD8E8E8E': ("ADC A,(IX-$72)", 3),
    'DD8F8F8F': ("DEFB $DD", 1),
    'DD909090': ("DEFB $DD", 1),
    'DD919191': ("DEFB $DD", 1),
    'DD929292': ("DEFB $DD", 1),
    'DD939393': ("DEFB $DD", 1),
    'DD949494': ("SUB IXh", 2),
    'DD959595': ("SUB IXl", 2),
    'DD969696': ("SUB (IX-$6A)", 3),
    'DD979797': ("DEFB $DD", 1),
    'DD989898': ("DEFB $DD", 1),
    'DD999999': ("DEFB $DD", 1),
    'DD9A9A9A': ("DEFB $DD", 1),
    'DD9B9B9B': ("DEFB $DD", 1),
    'DD9C9C9C': ("SBC A,IXh", 2),
    'DD9D9D9D': ("SBC A,IXl", 2),
    'DD9E9E9E': ("SBC A,(IX-$62)", 3),
    'DD9F9F9F': ("DEFB $DD", 1),
    'DDA0A0A0': ("DEFB $DD", 1),
    'DDA1A1A1': ("DEFB $DD", 1),
    'DDA2A2A2': ("DEFB $DD", 1),
    'DDA3A3A3': ("DEFB $DD", 1),
    'DDA4A4A4': ("AND IXh", 2),
    'DDA5A5A5': ("AND IXl", 2),
    'DDA6A6A6': ("AND (IX-$5A)", 3),
    'DDA7A7A7': ("DEFB $DD", 1),
    'DDA8A8A8': ("DEFB $DD", 1),
    'DDA9A9A9': ("DEFB $DD", 1),
    'DDAAAAAA': ("DEFB $DD", 1),
    'DDABABAB': ("DEFB $DD", 1),
    'DDACACAC': ("XOR IXh", 2),
    'DDADADAD': ("XOR IXl", 2),
    'DDAEAEAE': ("XOR (IX-$52)", 3),
    'DDAFAFAF': ("DEFB $DD", 1),
    'DDB0B0B0': ("DEFB $DD", 1),
    'DDB1B1B1': ("DEFB $DD", 1),
    'DDB2B2B2': ("DEFB $DD", 1),
    'DDB3B3B3': ("DEFB $DD", 1),
    'DDB4B4B4': ("OR IXh", 2),
    'DDB5B5B5': ("OR IXl", 2),
    'DDB6B6B6': ("OR (IX-$4A)", 3),
    'DDB7B7B7': ("DEFB $DD", 1),
    'DDB8B8B8': ("DEFB $DD", 1),
    'DDB9B9B9': ("DEFB $DD", 1),
    'DDBABABA': ("DEFB $DD", 1),
    'DDBBBBBB': ("DEFB $DD", 1),
    'DDBCBCBC': ("CP IXh", 2),
    'DDBDBDBD': ("CP IXl", 2),
    'DDBEBEBE': ("CP (IX-$42)", 3),
    'DDBFBFBF': ("DEFB $DD", 1),
    'DDC0C0C0': ("DEFB $DD", 1),
    'DDC1C1C1': ("DEFB $DD", 1),
    'DDC2C2C2': ("DEFB $DD", 1),
    'DDC3C3C3': ("DEFB $DD", 1),
    'DDC4C4C4': ("DEFB $DD", 1),
    'DDC5C5C5': ("DEFB $DD", 1),
    'DDC6C6C6': ("DEFB $DD", 1),
    'DDC7C7C7': ("DEFB $DD", 1),
    'DDC8C8C8': ("DEFB $DD", 1),
    'DDC9C9C9': ("DEFB $DD", 1),
    'DDCACACA': ("DEFB $DD", 1),
    'DDCBCBCB': ("SET 1,(IX-$35),E", 0),
    'DDCCCCCC': ("DEFB $DD", 1),
    'DDCDCDCD': ("DEFB $DD", 1),
    'DDCECECE': ("DEFB $DD", 1),
    'DDCFCFCF': ("DEFB $DD", 1),
    'DDD0D0D0': ("DEFB $DD", 1),
    'DDD1D1D1': ("DEFB $DD", 1),
    'DDD2D2D2': ("DEFB $DD", 1),
    'DDD3D3D3': ("DEFB $DD", 1),
    'DDD4D4D4': ("DEFB $DD", 1),
    'DDD5D5D5': ("DEFB $DD", 1),
    'DDD6D6D6': ("DEFB $DD", 1),
    'DDD7D7D7': ("DEFB $DD", 1),
    'DDD8D8D8': ("DEFB $DD", 1),
    'DDD9D9D9': ("DEFB $DD", 1),
    'DDDADADA': ("DEFB $DD", 1),
    'DDDBDBDB': ("DEFB $DD", 1),
    'DDDCDCDC': ("DEFB $DD", 1),
    'DDDDDDDD': ("DEFB $DD", 1),
    'DDDEDEDE': ("DEFB $DD", 1),
    'DDDFDFDF': ("DEFB $DD", 1),
    'DDE0E0E0': ("DEFB $DD", 1),
    'DDE1E1E1': ("POP IX", 2),
    'DDE2E2E2': ("DEFB $DD", 1),
    'DDE3E3E3': ("EX (SP),IX", 2),
    'DDE4E4E4': ("DEFB $DD", 1),
    'DDE5E5E5': ("PUSH IX", 2),
    'DDE6E6E6': ("DEFB $DD", 1),
    'DDE7E7E7': ("DEFB $DD", 1),
    'DDE8E8E8': ("DEFB $DD", 1),
    'DDE9E9E9': ("JP (IX)", 2),
    'DDEAEAEA': ("DEFB $DD", 1),
    'DDEBEBEB': ("DEFB $DD", 1),
    'DDECECEC': ("DEFB $DD", 1),
    'DDEDEDED': ("DEFB $DD", 1),
    'DDEEEEEE': ("DEFB $DD", 1),
    'DDEFEFEF': ("DEFB $DD", 1),
    'DDF0F0F0': ("DEFB $DD", 1),
    'DDF1F1F1': ("DEFB $DD", 1),
    'DDF2F2F2': ("DEFB $DD", 1),
    'DDF3F3F3': ("DEFB $DD", 1),
    'DDF4F4F4': ("DEFB $DD", 1),
    'DDF5F5F5': ("DEFB $DD", 1),
    'DDF6F6F6': ("DEFB $DD", 1),
    'DDF7F7F7': ("DEFB $DD", 1),
    'DDF8F8F8': ("DEFB $DD", 1),
    'DDF9F9F9': ("LD SP,IX", 2),
    'DDFAFAFA': ("DEFB $DD", 1),
    'DDFBFBFB': ("DEFB $DD", 1),
    'DDFCFCFC': ("DEFB $DD", 1),
    'DDFDFDFD': ("DEFB $DD", 1),
    'DDFEFEFE': ("DEFB $DD", 1),
    'DDFFFFFF': ("DEFB $DD", 1),
    'ED000000': ("DEFB $ED,$00", 2),
    'ED010101': ("DEFB $ED,$01", 2),
    'ED020202': ("DEFB $ED,$02", 2),
    'ED030303': ("DEFB $ED,$03", 2),
    'ED040404': ("DEFB $ED,$04", 2),
    'ED050505': ("DEFB $ED,$05", 2),
    'ED060606': ("DEFB $ED,$06", 2),
    'ED070707': ("DEFB $ED,$07", 2),
    'ED080808': ("DEFB $ED,$08", 2),
    'ED090909': ("DEFB $ED,$09", 2),
    'ED0A0A0A': ("DEFB $ED,$0A", 2),
    'ED0B0B0B': ("DEFB $ED,$0B", 2),
    'ED0C0C0C': ("DEFB $ED,$0C", 2),
    'ED0D0D0D': ("DEFB $ED,$0D", 2),
    'ED0E0E0E': ("DEFB $ED,$0E", 2),
    'ED0F0F0F': ("DEFB $ED,$0F", 2),
    'ED101010': ("DEFB $ED,$10", 2),
    'ED111111': ("DEFB $ED,$11", 2),
    'ED121212': ("DEFB $ED,$12", 2),
    'ED131313': ("DEFB $ED,$13", 2),
    'ED141414': ("DEFB $ED,$14", 2),
    'ED151515': ("DEFB $ED,$15", 2),
    'ED161616': ("DEFB $ED,$16", 2),
    'ED171717': ("DEFB $ED,$17", 2),
    'ED181818': ("DEFB $ED,$18", 2),
    'ED191919': ("DEFB $ED,$19", 2),
    'ED1A1A1A': ("DEFB $ED,$1A", 2),
    'ED1B1B1B': ("DEFB $ED,$1B", 2),
    'ED1C1C1C': ("DEFB $ED,$1C", 2),
    'ED1D1D1D': ("DEFB $ED,$1D", 2),
    'ED1E1E1E': ("DEFB $ED,$1E", 2),
    'ED1F1F1F': ("DEFB $ED,$1F", 2),
    'ED202020': ("DEFB $ED,$20", 2),
    'ED212121': ("DEFB $ED,$21", 2),
    'ED222222': ("DEFB $ED,$22", 2),
    'ED232323': ("DEFB $ED,$23", 2),
    'ED242424': ("DEFB $ED,$24", 2),
    'ED252525': ("DEFB $ED,$25", 2),
    'ED262626': ("DEFB $ED,$26", 2),
    'ED272727': ("DEFB $ED,$27", 2),
    'ED282828': ("DEFB $ED,$28", 2),
    'ED292929': ("DEFB $ED,$29", 2),
    'ED2A2A2A': ("DEFB $ED,$2A", 2),
    'ED2B2B2B': ("DEFB $ED,$2B", 2),
    'ED2C2C2C': ("DEFB $ED,$2C", 2),
    'ED2D2D2D': ("DEFB $ED,$2D", 2),
    'ED2E2E2E': ("DEFB $ED,$2E", 2),
    'ED2F2F2F': ("DEFB $ED,$2F", 2),
    'ED303030': ("DEFB $ED,$30", 2),
    'ED313131': ("DEFB $ED,$31", 2),
    'ED323232': ("DEFB $ED,$32", 2),
    'ED333333': ("DEFB $ED,$33", 2),
    'ED343434': ("DEFB $ED,$34", 2),
    'ED353535': ("DEFB $ED,$35", 2),
    'ED363636': ("DEFB $ED,$36", 2),
    'ED373737': ("DEFB $ED,$37", 2),
    'ED383838': ("DEFB $ED,$38", 2),
    'ED393939': ("DEFB $ED,$39", 2),
    'ED3A3A3A': ("DEFB $ED,$3A", 2),
    'ED3B3B3B': ("DEFB $ED,$3B", 2),
    'ED3C3C3C': ("DEFB $ED,$3C", 2),
    'ED3D3D3D': ("DEFB $ED,$3D", 2),
    'ED3E3E3E': ("DEFB $ED,$3E", 2),
    'ED3F3F3F': ("DEFB $ED,$3F", 2),
    'ED404040': ("IN B,(C)", 2),
    'ED414141': ("OUT (C),B", 2),
    'ED424242': ("SBC HL,BC", 2),
    'ED434343': ("LD ($4343),BC", 4),
    'ED444444': ("NEG", 2),
    'ED454545': ("RETN", 2),
    'ED464646': ("IM 0", 2),
    'ED474747': ("LD I,A", 2),
    'ED484848': ("IN C,(C)", 2),
    'ED494949': ("OUT (C),C", 2),
    'ED4A4A4A': ("ADC HL,BC", 2),
    'ED4B4B4B': ("LD BC,($4B4B)", 4),
    'ED4C4C4C': ("NEG", 2),
    'ED4D4D4D': ("RETI", 2),
    'ED4E4E4E': ("IM 0", 2),
    'ED4F4F4F': ("LD R,A", 2),
    'ED505050': ("IN D,(C)", 2),
    'ED515151': ("OUT (C),D", 2),
    'ED525252': ("SBC HL,DE", 2),
    'ED535353': ("LD ($5353),DE", 4),
    'ED545454': ("NEG", 2),
    'ED555555': ("RETN", 2),
    'ED565656': ("IM 1", 2),
    'ED575757': ("LD A,I", 2),
    'ED585858': ("IN E,(C)", 2),
    'ED595959': ("OUT (C),E", 2),
    'ED5A5A5A': ("ADC HL,DE", 2),
    'ED5B5B5B': ("LD DE,($5B5B)", 4),
    'ED5C5C5C': ("NEG", 2),
    'ED5D5D5D': ("RETN", 2),
    'ED5E5E5E': ("IM 2", 2),
    'ED5F5F5F': ("LD A,R", 2),
    'ED606060': ("IN H,(C)", 2),
    'ED616161': ("OUT (C),H", 2),
    'ED626262': ("SBC HL,HL", 2),
    'ED636363': ("LD ($6363),HL", 4),
    'ED646464': ("NEG", 2),
    'ED656565': ("RETN", 2),
    'ED666666': ("IM 0", 2),
    'ED676767': ("RRD", 2),
    'ED686868': ("IN L,(C)", 2),
    'ED696969': ("OUT (C),L", 2),
    'ED6A6A6A': ("ADC HL,HL", 2),
    'ED6B6B6B': ("LD HL,($6B6B)", 4),
    'ED6C6C6C': ("NEG", 2),
    'ED6D6D6D': ("RETN", 2),
    'ED6E6E6E': ("IM 0", 2),
    'ED6F6F6F': ("RLD", 2),
    'ED707070': ("IN F,(C)", 2),
    'ED717171': ("OUT (C),0", 2),
    'ED727272': ("SBC HL,SP", 2),
    'ED737373': ("LD ($7373),SP", 4),
    'ED747474': ("NEG", 2),
    'ED757575': ("RETN", 2),
    'ED767676': ("IM 1", 2),
    'ED777777': ("DEFB $ED,$77", 2),
    'ED787878': ("IN A,(C)", 2),
    'ED797979': ("OUT (C),A", 2),
    'ED7A7A7A': ("ADC HL,SP", 2),
    'ED7B7B7B': ("LD SP,($7B7B)", 4),
    'ED7C7C7C': ("NEG", 2),
    'ED7D7D7D': ("RETN", 2),
    'ED7E7E7E': ("IM 2", 2),
    'ED7F7F7F': ("DEFB $ED,$7F", 2),
    'ED808080': ("DEFB $ED,$80", 2),
    'ED818181': ("DEFB $ED,$81", 2),
    'ED828282': ("DEFB $ED,$82", 2),
    'ED838383': ("DEFB $ED,$83", 2),
    'ED848484': ("DEFB $ED,$84", 2),
    'ED858585': ("DEFB $ED,$85", 2),
    'ED868686': ("DEFB $ED,$86", 2),
    'ED878787': ("DEFB $ED,$87", 2),
    'ED888888': ("DEFB $ED,$88", 2),
    'ED898989': ("DEFB $ED,$89", 2),
    'ED8A8A8A': ("DEFB $ED,$8A", 2),
    'ED8B8B8B': ("DEFB $ED,$8B", 2),
    'ED8C8C8C': ("DEFB $ED,$8C", 2),
    'ED8D8D8D': ("DEFB $ED,$8D", 2),
    'ED8E8E8E': ("DEFB $ED,$8E", 2),
    'ED8F8F8F': ("DEFB $ED,$8F", 2),
    'ED909090': ("DEFB $ED,$90", 2),
    'ED919191': ("DEFB $ED,$91", 2),
    'ED929292': ("DEFB $ED,$92", 2),
    'ED939393': ("DEFB $ED,$93", 2),
    'ED949494': ("DEFB $ED,$94", 2),
    'ED959595': ("DEFB $ED,$95", 2),
    'ED969696': ("DEFB $ED,$96", 2),
    'ED979797': ("DEFB $ED,$97", 2),
    'ED989898': ("DEFB $ED,$98", 2),
    'ED999999': ("DEFB $ED,$99", 2),
    'ED9A9A9A': ("DEFB $ED,$9A", 2),
    'ED9B9B9B': ("DEFB $ED,$9B", 2),
    'ED9C9C9C': ("DEFB $ED,$9C", 2),
    'ED9D9D9D': ("DEFB $ED,$9D", 2),
    'ED9E9E9E': ("DEFB $ED,$9E", 2),
    'ED9F9F9F': ("DEFB $ED,$9F", 2),
    'EDA0A0A0': ("LDI", 2),
    'EDA1A1A1': ("CPI", 2),
    'EDA2A2A2': ("INI", 2),
    'EDA3A3A3': ("OUTI", 2),
    'EDA4A4A4': ("DEFB $ED,$A4", 2),
    'EDA5A5A5': ("DEFB $ED,$A5", 2),
    'EDA6A6A6': ("DEFB $ED,$A6", 2),
    'EDA7A7A7': ("DEFB $ED,$A7", 2),
    'EDA8A8A8': ("LDD", 2),
    'EDA9A9A9': ("CPD", 2),
    'EDAAAAAA': ("IND", 2),
    'EDABABAB': ("OUTD", 2),
    'EDACACAC': ("DEFB $ED,$AC", 2),
    'EDADADAD': ("DEFB $ED,$AD", 2),
    'EDAEAEAE': ("DEFB $ED,$AE", 2),
    'EDAFAFAF': ("DEFB $ED,$AF", 2),
    'EDB0B0B0': ("LDIR", 2),
    'EDB1B1B1': ("CPIR", 2),
    'EDB2B2B2': ("INIR", 2),
    'EDB3B3B3': ("OTIR", 2),
    'EDB4B4B4': ("DEFB $ED,$B4", 2),
    'EDB5B5B5': ("DEFB $ED,$B5", 2),
    'EDB6B6B6': ("DEFB $ED,$B6", 2),
    'EDB7B7B7': ("DEFB $ED,$B7", 2),
    'EDB8B8B8': ("LDDR", 2),
    'EDB9B9B9': ("CPDR", 2),
    'EDBABABA': ("INDR", 2),
    'EDBBBBBB': ("OTDR", 2),
    'EDBCBCBC': ("DEFB $ED,$BC", 2),
    'EDBDBDBD': ("DEFB $ED,$BD", 2),
    'EDBEBEBE': ("DEFB $ED,$BE", 2),
    'EDBFBFBF': ("DEFB $ED,$BF", 2),
    'EDC0C0C0': ("DEFB $ED,$C0", 2),
    'EDC1C1C1': ("DEFB $ED,$C1", 2),
    'EDC2C2C2': ("DEFB $ED,$C2", 2),
    'EDC3C3C3': ("DEFB $ED,$C3", 2),
    'EDC4C4C4': ("DEFB $ED,$C4", 2),
    'EDC5C5C5': ("DEFB $ED,$C5", 2),
    'EDC6C6C6': ("DEFB $ED,$C6", 2),
    'EDC7C7C7': ("DEFB $ED,$C7", 2),
    'EDC8C8C8': ("DEFB $ED,$C8", 2),
    'EDC9C9C9': ("DEFB $ED,$C9", 2),
    'EDCACACA': ("DEFB $ED,$CA", 2),
    'EDCBCBCB': ("DEFB $ED,$CB", 2),
    'EDCCCCCC': ("DEFB $ED,$CC", 2),
    'EDCDCDCD': ("DEFB $ED,$CD", 2),
    'EDCECECE': ("DEFB $ED,$CE", 2),
    'EDCFCFCF': ("DEFB $ED,$CF", 2),
    'EDD0D0D0': ("DEFB $ED,$D0", 2),
    'EDD1D1D1': ("DEFB $ED,$D1", 2),
    'EDD2D2D2': ("DEFB $ED,$D2", 2),
    'EDD3D3D3': ("DEFB $ED,$D3", 2),
    'EDD4D4D4': ("DEFB $ED,$D4", 2),
    'EDD5D5D5': ("DEFB $ED,$D5", 2),
    'EDD6D6D6': ("DEFB $ED,$D6", 2),
    'EDD7D7D7': ("DEFB $ED,$D7", 2),
    'EDD8D8D8': ("DEFB $ED,$D8", 2),
    'EDD9D9D9': ("DEFB $ED,$D9", 2),
    'EDDADADA': ("DEFB $ED,$DA", 2),
    'EDDBDBDB': ("DEFB $ED,$DB", 2),
    'EDDCDCDC': ("DEFB $ED,$DC", 2),
    'EDDDDDDD': ("DEFB $ED,$DD", 2),
    'EDDEDEDE': ("DEFB $ED,$DE", 2),
    'EDDFDFDF': ("DEFB $ED,$DF", 2),
    'EDE0E0E0': ("DEFB $ED,$E0", 2),
    'EDE1E1E1': ("DEFB $ED,$E1", 2),
    'EDE2E2E2': ("DEFB $ED,$E2", 2),
    'EDE3E3E3': ("DEFB $ED,$E3", 2),
    'EDE4E4E4': ("DEFB $ED,$E4", 2),
    'EDE5E5E5': ("DEFB $ED,$E5", 2),
    'EDE6E6E6': ("DEFB $ED,$E6", 2),
    'EDE7E7E7': ("DEFB $ED,$E7", 2),
    'EDE8E8E8': ("DEFB $ED,$E8", 2),
    'EDE9E9E9': ("DEFB $ED,$E9", 2),
    'EDEAEAEA': ("DEFB $ED,$EA", 2),
    'EDEBEBEB': ("DEFB $ED,$EB", 2),
    'EDECECEC': ("DEFB $ED,$EC", 2),
    'EDEDEDED': ("DEFB $ED,$ED", 2),
    'EDEEEEEE': ("DEFB $ED,$EE", 2),
    'EDEFEFEF': ("DEFB $ED,$EF", 2),
    'EDF0F0F0': ("DEFB $ED,$F0", 2),
    'EDF1F1F1': ("DEFB $ED,$F1", 2),
    'EDF2F2F2': ("DEFB $ED,$F2", 2),
    'EDF3F3F3': ("DEFB $ED,$F3", 2),
    'EDF4F4F4': ("DEFB $ED,$F4", 2),
    'EDF5F5F5': ("DEFB $ED,$F5", 2),
    'EDF6F6F6': ("DEFB $ED,$F6", 2),
    'EDF7F7F7': ("DEFB $ED,$F7", 2),
    'EDF8F8F8': ("DEFB $ED,$F8", 2),
    'EDF9F9F9': ("DEFB $ED,$F9", 2),
    'EDFAFAFA': ("DEFB $ED,$FA", 2),
    'EDFBFBFB': ("DEFB $ED,$FB", 2),
    'EDFCFCFC': ("DEFB $ED,$FC", 2),
    'EDFDFDFD': ("DEFB $ED,$FD", 2),
    'EDFEFEFE': ("DEFB $ED,$FE", 2),
    'EDFFFFFF': ("DEFB $ED,$FF", 2),
    'FD000000': ("DEFB $FD", 1),
    'FD010101': ("DEFB $FD", 1),
    'FD020202': ("DEFB $FD", 1),
    'FD030303': ("DEFB $FD", 1),
    'FD040404': ("DEFB $FD", 1),
    'FD050505': ("DEFB $FD", 1),
    'FD060606': ("DEFB $FD", 1),
    'FD070707': ("DEFB $FD", 1),
    'FD080808': ("DEFB $FD", 1),
    'FD090909': ("ADD IY,BC", 2),
    'FD0A0A0A': ("DEFB $FD", 1),
    'FD0B0B0B': ("DEFB $FD", 1),
    'FD0C0C0C': ("DEFB $FD", 1),
    'FD0D0D0D': ("DEFB $FD", 1),
    'FD0E0E0E': ("DEFB $FD", 1),
    'FD0F0F0F': ("DEFB $FD", 1),
    'FD101010': ("DEFB $FD", 1),
    'FD111111': ("DEFB $FD", 1),
    'FD121212': ("DEFB $FD", 1),
    'FD131313': ("DEFB $FD", 1),
    'FD141414': ("DEFB $FD", 1),
    'FD151515': ("DEFB $FD", 1),
    'FD161616': ("DEFB $FD", 1),
    'FD171717': ("DEFB $FD", 1),
    'FD181818': ("DEFB $FD", 1),
    'FD191919': ("ADD IY,DE", 2),
    'FD1A1A1A': ("DEFB $FD", 1),
    'FD1B1B1B': ("DEFB $FD", 1),
    'FD1C1C1C': ("DEFB $FD", 1),
    'FD1D1D1D': ("DEFB $FD", 1),
    'FD1E1E1E': ("DEFB $FD", 1),
    'FD1F1F1F': ("DEFB $FD", 1),
    'FD202020': ("DEFB $FD", 1),
    'FD212121': ("LD IY,$2121", 4),
    'FD222222': ("LD ($2222),IY", 4),
    'FD232323': ("INC IY", 2),
    'FD242424': ("INC IYh", 2),
    'FD252525': ("DEC IYh", 2),
    'FD262626': ("LD IYh,$26", 3),
    'FD272727': ("DEFB $FD", 1),
    'FD282828': ("DEFB $FD", 1),
    'FD292929': ("ADD IY,IY", 2),
    'FD2A2A2A': ("LD IY,($2A2A)", 4),
    'FD2B2B2B': ("DEC IY", 2),
    'FD2C2C2C': ("INC IYl", 2),
    'FD2D2D2D': ("DEC IYl", 2),
    'FD2E2E2E': ("LD IYl,$2E", 3),
    'FD2F2F2F': ("DEFB $FD", 1),
    'FD303030': ("DEFB $FD", 1),
    'FD313131': ("DEFB $FD", 1),
    'FD323232': ("DEFB $FD", 1),
    'FD333333': ("DEFB $FD", 1),
    'FD343434': ("INC (IY+$34)", 3),
    'FD353535': ("DEC (IY+$35)", 3),
    'FD363636': ("LD (IY+$36),$36", 4),
    'FD373737': ("DEFB $FD", 1),
    'FD383838': ("DEFB $FD", 1),
    'FD393939': ("ADD IY,SP", 2),
    'FD3A3A3A': ("DEFB $FD", 1),
    'FD3B3B3B': ("DEFB $FD", 1),
    'FD3C3C3C': ("DEFB $FD", 1),
    'FD3D3D3D': ("DEFB $FD", 1),
    'FD3E3E3E': ("DEFB $FD", 1),
    'FD3F3F3F': ("DEFB $FD", 1),
    'FD404040': ("DEFB $FD", 1),
    'FD414141': ("DEFB $FD", 1),
    'FD424242': ("DEFB $FD", 1),
    'FD434343': ("DEFB $FD", 1),
    'FD444444': ("LD B,IYh", 2),
    'FD454545': ("LD B,IYl", 2),
    'FD464646': ("LD B,(IY+$46)", 3),
    'FD474747': ("DEFB $FD", 1),
    'FD484848': ("DEFB $FD", 1),
    'FD494949': ("DEFB $FD", 1),
    'FD4A4A4A': ("DEFB $FD", 1),
    'FD4B4B4B': ("DEFB $FD", 1),
    'FD4C4C4C': ("LD C,IYh", 2),
    'FD4D4D4D': ("LD C,IYl", 2),
    'FD4E4E4E': ("LD C,(IY+$4E)", 3),
    'FD4F4F4F': ("DEFB $FD", 1),
    'FD505050': ("DEFB $FD", 1),
    'FD515151': ("DEFB $FD", 1),
    'FD525252': ("DEFB $FD", 1),
    'FD535353': ("DEFB $FD", 1),
    'FD545454': ("LD D,IYh", 2),
    'FD555555': ("LD D,IYl", 2),
    'FD565656': ("LD D,(IY+$56)", 3),
    'FD575757': ("DEFB $FD", 1),
    'FD585858': ("DEFB $FD", 1),
    'FD595959': ("DEFB $FD", 1),
    'FD5A5A5A': ("DEFB $FD", 1),
    'FD5B5B5B': ("DEFB $FD", 1),
    'FD5C5C5C': ("LD E,IYh", 2),
    'FD5D5D5D': ("LD E,IYl", 2),
    'FD5E5E5E': ("LD E,(IY+$5E)", 3),
    'FD5F5F5F': ("DEFB $FD", 1),
    'FD606060': ("LD IYh,B", 2),
    'FD616161': ("LD IYh,C", 2),
    'FD626262': ("LD IYh,D", 2),
    'FD636363': ("LD IYh,E", 2),
    'FD646464': ("LD IYh,IYh", 2),
    'FD656565': ("LD IYh,IYl", 2),
    'FD666666': ("LD H,(IY+$66)", 3),
    'FD676767': ("LD IYh,A", 2),
    'FD686868': ("LD IYl,B", 2),
    'FD696969': ("LD IYl,C", 2),
    'FD6A6A6A': ("LD IYl,D", 2),
    'FD6B6B6B': ("LD IYl,E", 2),
    'FD6C6C6C': ("LD IYl,IYh", 2),
    'FD6D6D6D': ("LD IYl,IYl", 2),
    'FD6E6E6E': ("LD L,(IY+$6E)", 3),
    'FD6F6F6F': ("LD IYl,A", 2),
    'FD707070': ("LD (IY+$70),B", 3),
    'FD717171': ("LD (IY+$71),C", 3),
    'FD727272': ("LD (IY+$72),D", 3),
    'FD737373': ("LD (IY+$73),E", 3),
    'FD747474': ("LD (IY+$74),H", 3),
    'FD757575': ("LD (IY+$75),L", 3),
    'FD767676': ("DEFB $FD", 1),
    'FD777777': ("LD (IY+$77),A", 3),
    'FD787878': ("DEFB $FD", 1),
    'FD797979': ("DEFB $FD", 1),
    'FD7A7A7A': ("DEFB $FD", 1),
    'FD7B7B7B': ("DEFB $FD", 1),
    'FD7C7C7C': ("LD A,IYh", 2),
    'FD7D7D7D': ("LD A,IYl", 2),
    'FD7E7E7E': ("LD A,(IY+$7E)", 3),
    'FD7F7F7F': ("DEFB $FD", 1),
    'FD808080': ("DEFB $FD", 1),
    'FD818181': ("DEFB $FD", 1),
    'FD828282': ("DEFB $FD", 1),
    'FD838383': ("DEFB $FD", 1),
    'FD848484': ("ADD A,IYh", 2),
    'FD858585': ("ADD A,IYl", 2),
    'FD868686': ("ADD A,(IY-$7A)", 3),
    'FD878787': ("DEFB $FD", 1),
    'FD888888': ("DEFB $FD", 1),
    'FD898989': ("DEFB $FD", 1),
    'FD8A8A8A': ("DEFB $FD", 1),
    'FD8B8B8B': ("DEFB $FD", 1),
    'FD8C8C8C': ("ADC A,IYh", 2),
    'FD8D8D8D': ("ADC A,IYl", 2),
    'FD8E8E8E': ("ADC A,(IY-$72)", 3),
    'FD8F8F8F': ("DEFB $FD", 1),
    'FD909090': ("DEFB $FD", 1),
    'FD919191': ("DEFB $FD", 1),
    'FD929292': ("DEFB $FD", 1),
    'FD939393': ("DEFB $FD", 1),
    'FD949494': ("SUB IYh", 2),
    'FD959595': ("SUB IYl", 2),
    'FD969696': ("SUB (IY-$6A)", 3),
    'FD979797': ("DEFB $FD", 1),
    'FD989898': ("DEFB $FD", 1),
    'FD999999': ("DEFB $FD", 1),
    'FD9A9A9A': ("DEFB $FD", 1),
    'FD9B9B9B': ("DEFB $FD", 1),
    'FD9C9C9C': ("SBC A,IYh", 2),
    'FD9D9D9D': ("SBC A,IYl", 2),
    'FD9E9E9E': ("SBC A,(IY-$62)", 3),
    'FD9F9F9F': ("DEFB $FD", 1),
    'FDA0A0A0': ("DEFB $FD", 1),
    'FDA1A1A1': ("DEFB $FD", 1),
    'FDA2A2A2': ("DEFB $FD", 1),
    'FDA3A3A3': ("DEFB $FD", 1),
    'FDA4A4A4': ("AND IYh", 2),
    'FDA5A5A5': ("AND IYl", 2),
    'FDA6A6A6': ("AND (IY-$5A)", 3),
    'FDA7A7A7': ("DEFB $FD", 1),
    'FDA8A8A8': ("DEFB $FD", 1),
    'FDA9A9A9': ("DEFB $FD", 1),
    'FDAAAAAA': ("DEFB $FD", 1),
    'FDABABAB': ("DEFB $FD", 1),
    'FDACACAC': ("XOR IYh", 2),
    'FDADADAD': ("XOR IYl", 2),
    'FDAEAEAE': ("XOR (IY-$52)", 3),
    'FDAFAFAF': ("DEFB $FD", 1),
    'FDB0B0B0': ("DEFB $FD", 1),
    'FDB1B1B1': ("DEFB $FD", 1),
    'FDB2B2B2': ("DEFB $FD", 1),
    'FDB3B3B3': ("DEFB $FD", 1),
    'FDB4B4B4': ("OR IYh", 2),
    'FDB5B5B5': ("OR IYl", 2),
    'FDB6B6B6': ("OR (IY-$4A)", 3),
    'FDB7B7B7': ("DEFB $FD", 1),
    'FDB8B8B8': ("DEFB $FD", 1),
    'FDB9B9B9': ("DEFB $FD", 1),
    'FDBABABA': ("DEFB $FD", 1),
    'FDBBBBBB': ("DEFB $FD", 1),
    'FDBCBCBC': ("CP IYh", 2),
    'FDBDBDBD': ("CP IYl", 2),
    'FDBEBEBE': ("CP (IY-$42)", 3),
    'FDBFBFBF': ("DEFB $FD", 1),
    'FDC0C0C0': ("DEFB $FD", 1),
    'FDC1C1C1': ("DEFB $FD", 1),
    'FDC2C2C2': ("DEFB $FD", 1),
    'FDC3C3C3': ("DEFB $FD", 1),
    'FDC4C4C4': ("DEFB $FD", 1),
    'FDC5C5C5': ("DEFB $FD", 1),
    'FDC6C6C6': ("DEFB $FD", 1),
    'FDC7C7C7': ("DEFB $FD", 1),
    'FDC8C8C8': ("DEFB $FD", 1),
    'FDC9C9C9': ("DEFB $FD", 1),
    'FDCACACA': ("DEFB $FD", 1),
    'FDCBCBCB': ("SET 1,(IY-$35),E", 0),
    'FDCCCCCC': ("DEFB $FD", 1),
    'FDCDCDCD': ("DEFB $FD", 1),
    'FDCECECE': ("DEFB $FD", 1),
    'FDCFCFCF': ("DEFB $FD", 1),
    'FDD0D0D0': ("DEFB $FD", 1),
    'FDD1D1D1': ("DEFB $FD", 1),
    'FDD2D2D2': ("DEFB $FD", 1),
    'FDD3D3D3': ("DEFB $FD", 1),
    'FDD4D4D4': ("DEFB $FD", 1),
    'FDD5D5D5': ("DEFB $FD", 1),
    'FDD6D6D6': ("DEFB $FD", 1),
    'FDD7D7D7': ("DEFB $FD", 1),
    'FDD8D8D8': ("DEFB $FD", 1),
    'FDD9D9D9': ("DEFB $FD", 1),
    'FDDADADA': ("DEFB $FD", 1),
    'FDDBDBDB': ("DEFB $FD", 1),
    'FDDCDCDC': ("DEFB $FD", 1),
    'FDDDDDDD': ("DEFB $FD", 1),
    'FDDEDEDE': ("DEFB $FD", 1),
    'FDDFDFDF': ("DEFB $FD", 1),
    'FDE0E0E0': ("DEFB $FD", 1),
    'FDE1E1E1': ("POP IY", 2),
    'FDE2E2E2': ("DEFB $FD", 1),
    'FDE3E3E3': ("EX (SP),IY", 2),
    'FDE4E4E4': ("DEFB $FD", 1),
    'FDE5E5E5': ("PUSH IY", 2),
    'FDE6E6E6': ("DEFB $FD", 1),
    'FDE7E7E7': ("DEFB $FD", 1),
    'FDE8E8E8': ("DEFB $FD", 1),
    'FDE9E9E9': ("JP (IY)", 2),
    'FDEAEAEA': ("DEFB $FD", 1),
    'FDEBEBEB': ("DEFB $FD", 1),
    'FDECECEC': ("DEFB $FD", 1),
    'FDEDEDED': ("DEFB $FD", 1),
    'FDEEEEEE': ("DEFB $FD", 1),
    'FDEFEFEF': ("DEFB $FD", 1),
    'FDF0F0F0': ("DEFB $FD", 1),
    'FDF1F1F1': ("DEFB $FD", 1),
    'FDF2F2F2': ("DEFB $FD", 1),
    'FDF3F3F3': ("DEFB $FD", 1),
    'FDF4F4F4': ("DEFB $FD", 1),
    'FDF5F5F5': ("DEFB $FD", 1),
    'FDF6F6F6': ("DEFB $FD", 1),
    'FDF7F7F7': ("DEFB $FD", 1),
    'FDF8F8F8': ("DEFB $FD", 1),
    'FDF9F9F9': ("LD SP,IY", 2),
    'FDFAFAFA': ("DEFB $FD", 1),
    'FDFBFBFB': ("DEFB $FD", 1),
    'FDFCFCFC': ("DEFB $FD", 1),
    'FDFDFDFD': ("DEFB $FD", 1),
    'FDFEFEFE': ("DEFB $FD", 1),
    'FDFFFFFF': ("DEFB $FD", 1),
    'DDCB0000': ("RLC (IX+$00),B", 4),
    'DDCB0101': ("RLC (IX+$01),C", 4),
    'DDCB0202': ("RLC (IX+$02),D", 4),
    'DDCB0303': ("RLC (IX+$03),E", 4),
    'DDCB0404': ("RLC (IX+$04),H", 4),
    'DDCB0505': ("RLC (IX+$05),L", 4),
    'DDCB0606': ("RLC (IX+$06)", 4),
    'DDCB0707': ("RLC (IX+$07),A", 4),
    'DDCB0808': ("RRC (IX+$08),B", 4),
    'DDCB0909': ("RRC (IX+$09),C", 4),
    'DDCB0A0A': ("RRC (IX+$0A),D", 4),
    'DDCB0B0B': ("RRC (IX+$0B),E", 4),
    'DDCB0C0C': ("RRC (IX+$0C),H", 4),
    'DDCB0D0D': ("RRC (IX+$0D),L", 4),
    'DDCB0E0E': ("RRC (IX+$0E)", 4),
    'DDCB0F0F': ("RRC (IX+$0F),A", 4),
    'DDCB1010': ("RL (IX+$10),B", 4),
    'DDCB1111': ("RL (IX+$11),C", 4),
    'DDCB1212': ("RL (IX+$12),D", 4),
    'DDCB1313': ("RL (IX+$13),E", 4),
    'DDCB1414': ("RL (IX+$14),H", 4),
    'DDCB1515': ("RL (IX+$15),L", 4),
    'DDCB1616': ("RL (IX+$16)", 4),
    'DDCB1717': ("RL (IX+$17),A", 4),
    'DDCB1818': ("RR (IX+$18),B", 4),
    'DDCB1919': ("RR (IX+$19),C", 4),
    'DDCB1A1A': ("RR (IX+$1A),D", 4),
    'DDCB1B1B': ("RR (IX+$1B),E", 4),
    'DDCB1C1C': ("RR (IX+$1C),H", 4),
    'DDCB1D1D': ("RR (IX+$1D),L", 4),
    'DDCB1E1E': ("RR (IX+$1E)", 4),
    'DDCB1F1F': ("RR (IX+$1F),A", 4),
    'DDCB2020': ("SLA (IX+$20),B", 4),
    'DDCB2121': ("SLA (IX+$21),C", 4),
    'DDCB2222': ("SLA (IX+$22),D", 4),
    'DDCB2323': ("SLA (IX+$23),E", 4),
    'DDCB2424': ("SLA (IX+$24),H", 4),
    'DDCB2525': ("SLA (IX+$25),L", 4),
    'DDCB2626': ("SLA (IX+$26)", 4),
    'DDCB2727': ("SLA (IX+$27),A", 4),
    'DDCB2828': ("SRA (IX+$28),B", 4),
    'DDCB2929': ("SRA (IX+$29),C", 4),
    'DDCB2A2A': ("SRA (IX+$2A),D", 4),
    'DDCB2B2B': ("SRA (IX+$2B),E", 4),
    'DDCB2C2C': ("SRA (IX+$2C),H", 4),
    'DDCB2D2D': ("SRA (IX+$2D),L", 4),
    'DDCB2E2E': ("SRA (IX+$2E)", 4),
    'DDCB2F2F': ("SRA (IX+$2F),A", 4),
    'DDCB3030': ("SLL (IX+$30),B", 4),
    'DDCB3131': ("SLL (IX+$31),C", 4),
    'DDCB3232': ("SLL (IX+$32),D", 4),
    'DDCB3333': ("SLL (IX+$33),E", 4),
    'DDCB3434': ("SLL (IX+$34),H", 4),
    'DDCB3535': ("SLL (IX+$35),L", 4),
    'DDCB3636': ("SLL (IX+$36)", 4),
    'DDCB3737': ("SLL (IX+$37),A", 4),
    'DDCB3838': ("SRL (IX+$38),B", 4),
    'DDCB3939': ("SRL (IX+$39),C", 4),
    'DDCB3A3A': ("SRL (IX+$3A),D", 4),
    'DDCB3B3B': ("SRL (IX+$3B),E", 4),
    'DDCB3C3C': ("SRL (IX+$3C),H", 4),
    'DDCB3D3D': ("SRL (IX+$3D),L", 4),
    'DDCB3E3E': ("SRL (IX+$3E)", 4),
    'DDCB3F3F': ("SRL (IX+$3F),A", 4),
    'DDCB4040': ("BIT 0,(IX+$40)", 4),
    'DDCB4141': ("BIT 0,(IX+$41)", 4),
    'DDCB4242': ("BIT 0,(IX+$42)", 4),
    'DDCB4343': ("BIT 0,(IX+$43)", 4),
    'DDCB4444': ("BIT 0,(IX+$44)", 4),
    'DDCB4545': ("BIT 0,(IX+$45)", 4),
    'DDCB4646': ("BIT 0,(IX+$46)", 4),
    'DDCB4747': ("BIT 0,(IX+$47)", 4),
    'DDCB4848': ("BIT 1,(IX+$48)", 4),
    'DDCB4949': ("BIT 1,(IX+$49)", 4),
    'DDCB4A4A': ("BIT 1,(IX+$4A)", 4),
    'DDCB4B4B': ("BIT 1,(IX+$4B)", 4),
    'DDCB4C4C': ("BIT 1,(IX+$4C)", 4),
    'DDCB4D4D': ("BIT 1,(IX+$4D)", 4),
    'DDCB4E4E': ("BIT 1,(IX+$4E)", 4),
    'DDCB4F4F': ("BIT 1,(IX+$4F)", 4),
    'DDCB5050': ("BIT 2,(IX+$50)", 4),
    'DDCB5151': ("BIT 2,(IX+$51)", 4),
    'DDCB5252': ("BIT 2,(IX+$52)", 4),
    'DDCB5353': ("BIT 2,(IX+$53)", 4),
    'DDCB5454': ("BIT 2,(IX+$54)", 4),
    'DDCB5555': ("BIT 2,(IX+$55)", 4),
    'DDCB5656': ("BIT 2,(IX+$56)", 4),
    'DDCB5757': ("BIT 2,(IX+$57)", 4),
    'DDCB5858': ("BIT 3,(IX+$58)", 4),
    'DDCB5959': ("BIT 3,(IX+$59)", 4),
    'DDCB5A5A': ("BIT 3,(IX+$5A)", 4),
    'DDCB5B5B': ("BIT 3,(IX+$5B)", 4),
    'DDCB5C5C': ("BIT 3,(IX+$5C)", 4),
    'DDCB5D5D': ("BIT 3,(IX+$5D)", 4),
    'DDCB5E5E': ("BIT 3,(IX+$5E)", 4),
    'DDCB5F5F': ("BIT 3,(IX+$5F)", 4),
    'DDCB6060': ("BIT 4,(IX+$60)", 4),
    'DDCB6161': ("BIT 4,(IX+$61)", 4),
    'DDCB6262': ("BIT 4,(IX+$62)", 4),
    'DDCB6363': ("BIT 4,(IX+$63)", 4),
    'DDCB6464': ("BIT 4,(IX+$64)", 4),
    'DDCB6565': ("BIT 4,(IX+$65)", 4),
    'DDCB6666': ("BIT 4,(IX+$66)", 4),
    'DDCB6767': ("BIT 4,(IX+$67)", 4),
    'DDCB6868': ("BIT 5,(IX+$68)", 4),
    'DDCB6969': ("BIT 5,(IX+$69)", 4),
    'DDCB6A6A': ("BIT 5,(IX+$6A)", 4),
    'DDCB6B6B': ("BIT 5,(IX+$6B)", 4),
    'DDCB6C6C': ("BIT 5,(IX+$6C)", 4),
    'DDCB6D6D': ("BIT 5,(IX+$6D)", 4),
    'DDCB6E6E': ("BIT 5,(IX+$6E)", 4),
    'DDCB6F6F': ("BIT 5,(IX+$6F)", 4),
    'DDCB7070': ("BIT 6,(IX+$70)", 4),
    'DDCB7171': ("BIT 6,(IX+$71)", 4),
    'DDCB7272': ("BIT 6,(IX+$72)", 4),
    'DDCB7373': ("BIT 6,(IX+$73)", 4),
    'DDCB7474': ("BIT 6,(IX+$74)", 4),
    'DDCB7575': ("BIT 6,(IX+$75)", 4),
    'DDCB7676': ("BIT 6,(IX+$76)", 4),
    'DDCB7777': ("BIT 6,(IX+$77)", 4),
    'DDCB7878': ("BIT 7,(IX+$78)", 4),
    'DDCB7979': ("BIT 7,(IX+$79)", 4),
    'DDCB7A7A': ("BIT 7,(IX+$7A)", 4),
    'DDCB7B7B': ("BIT 7,(IX+$7B)", 4),
    'DDCB7C7C': ("BIT 7,(IX+$7C)", 4),
    'DDCB7D7D': ("BIT 7,(IX+$7D)", 4),
    'DDCB7E7E': ("BIT 7,(IX+$7E)", 4),
    'DDCB7F7F': ("BIT 7,(IX+$7F)", 4),
    'DDCB8080': ("RES 0,(IX-$80),B", 4),
    'DDCB8181': ("RES 0,(IX-$7F),C", 4),
    'DDCB8282': ("RES 0,(IX-$7E),D", 4),
    'DDCB8383': ("RES 0,(IX-$7D),E", 4),
    'DDCB8484': ("RES 0,(IX-$7C),H", 4),
    'DDCB8585': ("RES 0,(IX-$7B),L", 4),
    'DDCB8686': ("RES 0,(IX-$7A)", 4),
    'DDCB8787': ("RES 0,(IX-$79),A", 4),
    'DDCB8888': ("RES 1,(IX-$78),B", 4),
    'DDCB8989': ("RES 1,(IX-$77),C", 4),
    'DDCB8A8A': ("RES 1,(IX-$76),D", 4),
    'DDCB8B8B': ("RES 1,(IX-$75),E", 4),
    'DDCB8C8C': ("RES 1,(IX-$74),H", 4),
    'DDCB8D8D': ("RES 1,(IX-$73),L", 4),
    'DDCB8E8E': ("RES 1,(IX-$72)", 4),
    'DDCB8F8F': ("RES 1,(IX-$71),A", 4),
    'DDCB9090': ("RES 2,(IX-$70),B", 4),
    'DDCB9191': ("RES 2,(IX-$6F),C", 4),
    'DDCB9292': ("RES 2,(IX-$6E),D", 4),
    'DDCB9393': ("RES 2,(IX-$6D),E", 4),
    'DDCB9494': ("RES 2,(IX-$6C),H", 4),
    'DDCB9595': ("RES 2,(IX-$6B),L", 4),
    'DDCB9696': ("RES 2,(IX-$6A)", 4),
    'DDCB9797': ("RES 2,(IX-$69),A", 4),
    'DDCB9898': ("RES 3,(IX-$68),B", 4),
    'DDCB9999': ("RES 3,(IX-$67),C", 4),
    'DDCB9A9A': ("RES 3,(IX-$66),D", 4),
    'DDCB9B9B': ("RES 3,(IX-$65),E", 4),
    'DDCB9C9C': ("RES 3,(IX-$64),H", 4),
    'DDCB9D9D': ("RES 3,(IX-$63),L", 4),
    'DDCB9E9E': ("RES 3,(IX-$62)", 4),
    'DDCB9F9F': ("RES 3,(IX-$61),A", 4),
    'DDCBA0A0': ("RES 4,(IX-$60),B", 4),
    'DDCBA1A1': ("RES 4,(IX-$5F),C", 4),
    'DDCBA2A2': ("RES 4,(IX-$5E),D", 4),
    'DDCBA3A3': ("RES 4,(IX-$5D),E", 4),
    'DDCBA4A4': ("RES 4,(IX-$5C),H", 4),
    'DDCBA5A5': ("RES 4,(IX-$5B),L", 4),
    'DDCBA6A6': ("RES 4,(IX-$5A)", 4),
    'DDCBA7A7': ("RES 4,(IX-$59),A", 4),
    'DDCBA8A8': ("RES 5,(IX-$58),B", 4),
    'DDCBA9A9': ("RES 5,(IX-$57),C", 4),
    'DDCBAAAA': ("RES 5,(IX-$56),D", 4),
    'DDCBABAB': ("RES 5,(IX-$55),E", 4),
    'DDCBACAC': ("RES 5,(IX-$54),H", 4),
    'DDCBADAD': ("RES 5,(IX-$53),L", 4),
    'DDCBAEAE': ("RES 5,(IX-$52)", 4),
    'DDCBAFAF': ("RES 5,(IX-$51),A", 4),
    'DDCBB0B0': ("RES 6,(IX-$50),B", 4),
    'DDCBB1B1': ("RES 6,(IX-$4F),C", 4),
    'DDCBB2B2': ("RES 6,(IX-$4E),D", 4),
    'DDCBB3B3': ("RES 6,(IX-$4D),E", 4),
    'DDCBB4B4': ("RES 6,(IX-$4C),H", 4),
    'DDCBB5B5': ("RES 6,(IX-$4B),L", 4),
    'DDCBB6B6': ("RES 6,(IX-$4A)", 4),
    'DDCBB7B7': ("RES 6,(IX-$49),A", 4),
    'DDCBB8B8': ("RES 7,(IX-$48),B", 4),
    'DDCBB9B9': ("RES 7,(IX-$47),C", 4),
    'DDCBBABA': ("RES 7,(IX-$46),D", 4),
    'DDCBBBBB': ("RES 7,(IX-$45),E", 4),
    'DDCBBCBC': ("RES 7,(IX-$44),H", 4),
    'DDCBBDBD': ("RES 7,(IX-$43),L", 4),
    'DDCBBEBE': ("RES 7,(IX-$42)", 4),
    'DDCBBFBF': ("RES 7,(IX-$41),A", 4),
    'DDCBC0C0': ("SET 0,(IX-$40),B", 4),
    'DDCBC1C1': ("SET 0,(IX-$3F),C", 4),
    'DDCBC2C2': ("SET 0,(IX-$3E),D", 4),
    'DDCBC3C3': ("SET 0,(IX-$3D),E", 4),
    'DDCBC4C4': ("SET 0,(IX-$3C),H", 4),
    'DDCBC5C5': ("SET 0,(IX-$3B),L", 4),
    'DDCBC6C6': ("SET 0,(IX-$3A)", 4),
    'DDCBC7C7': ("SET 0,(IX-$39),A", 4),
    'DDCBC8C8': ("SET 1,(IX-$38),B", 4),
    'DDCBC9C9': ("SET 1,(IX-$37),C", 4),
    'DDCBCACA': ("SET 1,(IX-$36),D", 4),
    'DDCBCBCB': ("SET 1,(IX-$35),E", 4),
    'DDCBCCCC': ("SET 1,(IX-$34),H", 4),
    'DDCBCDCD': ("SET 1,(IX-$33),L", 4),
    'DDCBCECE': ("SET 1,(IX-$32)", 4),
    'DDCBCFCF': ("SET 1,(IX-$31),A", 4),
    'DDCBD0D0': ("SET 2,(IX-$30),B", 4),
    'DDCBD1D1': ("SET 2,(IX-$2F),C", 4),
    'DDCBD2D2': ("SET 2,(IX-$2E),D", 4),
    'DDCBD3D3': ("SET 2,(IX-$2D),E", 4),
    'DDCBD4D4': ("SET 2,(IX-$2C),H", 4),
    'DDCBD5D5': ("SET 2,(IX-$2B),L", 4),
    'DDCBD6D6': ("SET 2,(IX-$2A)", 4),
    'DDCBD7D7': ("SET 2,(IX-$29),A", 4),
    'DDCBD8D8': ("SET 3,(IX-$28),B", 4),
    'DDCBD9D9': ("SET 3,(IX-$27),C", 4),
    'DDCBDADA': ("SET 3,(IX-$26),D", 4),
    'DDCBDBDB': ("SET 3,(IX-$25),E", 4),
    'DDCBDCDC': ("SET 3,(IX-$24),H", 4),
    'DDCBDDDD': ("SET 3,(IX-$23),L", 4),
    'DDCBDEDE': ("SET 3,(IX-$22)", 4),
    'DDCBDFDF': ("SET 3,(IX-$21),A", 4),
    'DDCBE0E0': ("SET 4,(IX-$20),B", 4),
    'DDCBE1E1': ("SET 4,(IX-$1F),C", 4),
    'DDCBE2E2': ("SET 4,(IX-$1E),D", 4),
    'DDCBE3E3': ("SET 4,(IX-$1D),E", 4),
    'DDCBE4E4': ("SET 4,(IX-$1C),H", 4),
    'DDCBE5E5': ("SET 4,(IX-$1B),L", 4),
    'DDCBE6E6': ("SET 4,(IX-$1A)", 4),
    'DDCBE7E7': ("SET 4,(IX-$19),A", 4),
    'DDCBE8E8': ("SET 5,(IX-$18),B", 4),
    'DDCBE9E9': ("SET 5,(IX-$17),C", 4),
    'DDCBEAEA': ("SET 5,(IX-$16),D", 4),
    'DDCBEBEB': ("SET 5,(IX-$15),E", 4),
    'DDCBECEC': ("SET 5,(IX-$14),H", 4),
    'DDCBEDED': ("SET 5,(IX-$13),L", 4),
    'DDCBEEEE': ("SET 5,(IX-$12)", 4),
    'DDCBEFEF': ("SET 5,(IX-$11),A", 4),
    'DDCBF0F0': ("SET 6,(IX-$10),B", 4),
    'DDCBF1F1': ("SET 6,(IX-$0F),C", 4),
    'DDCBF2F2': ("SET 6,(IX-$0E),D", 4),
    'DDCBF3F3': ("SET 6,(IX-$0D),E", 4),
    'DDCBF4F4': ("SET 6,(IX-$0C),H", 4),
    'DDCBF5F5': ("SET 6,(IX-$0B),L", 4),
    'DDCBF6F6': ("SET 6,(IX-$0A)", 4),
    'DDCBF7F7': ("SET 6,(IX-$09),A", 4),
    'DDCBF8F8': ("SET 7,(IX-$08),B", 4),
    'DDCBF9F9': ("SET 7,(IX-$07),C", 4),
    'DDCBFAFA': ("SET 7,(IX-$06),D", 4),
    'DDCBFBFB': ("SET 7,(IX-$05),E", 4),
    'DDCBFCFC': ("SET 7,(IX-$04),H", 4),
    'DDCBFDFD': ("SET 7,(IX-$03),L", 4),
    'DDCBFEFE': ("SET 7,(IX-$02)", 4),
    'DDCBFFFF': ("SET 7,(IX-$01),A", 4),
    'FDCB0000': ("RLC (IY+$00),B", 4),
    'FDCB0101': ("RLC (IY+$01),C", 4),
    'FDCB0202': ("RLC (IY+$02),D", 4),
    'FDCB0303': ("RLC (IY+$03),E", 4),
    'FDCB0404': ("RLC (IY+$04),H", 4),
    'FDCB0505': ("RLC (IY+$05),L", 4),
    'FDCB0606': ("RLC (IY+$06)", 4),
    'FDCB0707': ("RLC (IY+$07),A", 4),
    'FDCB0808': ("RRC (IY+$08),B", 4),
    'FDCB0909': ("RRC (IY+$09),C", 4),
    'FDCB0A0A': ("RRC (IY+$0A),D", 4),
    'FDCB0B0B': ("RRC (IY+$0B),E", 4),
    'FDCB0C0C': ("RRC (IY+$0C),H", 4),
    'FDCB0D0D': ("RRC (IY+$0D),L", 4),
    'FDCB0E0E': ("RRC (IY+$0E)", 4),
    'FDCB0F0F': ("RRC (IY+$0F),A", 4),
    'FDCB1010': ("RL (IY+$10),B", 4),
    'FDCB1111': ("RL (IY+$11),C", 4),
    'FDCB1212': ("RL (IY+$12),D", 4),
    'FDCB1313': ("RL (IY+$13),E", 4),
    'FDCB1414': ("RL (IY+$14),H", 4),
    'FDCB1515': ("RL (IY+$15),L", 4),
    'FDCB1616': ("RL (IY+$16)", 4),
    'FDCB1717': ("RL (IY+$17),A", 4),
    'FDCB1818': ("RR (IY+$18),B", 4),
    'FDCB1919': ("RR (IY+$19),C", 4),
    'FDCB1A1A': ("RR (IY+$1A),D", 4),
    'FDCB1B1B': ("RR (IY+$1B),E", 4),
    'FDCB1C1C': ("RR (IY+$1C),H", 4),
    'FDCB1D1D': ("RR (IY+$1D),L", 4),
    'FDCB1E1E': ("RR (IY+$1E)", 4),
    'FDCB1F1F': ("RR (IY+$1F),A", 4),
    'FDCB2020': ("SLA (IY+$20),B", 4),
    'FDCB2121': ("SLA (IY+$21),C", 4),
    'FDCB2222': ("SLA (IY+$22),D", 4),
    'FDCB2323': ("SLA (IY+$23),E", 4),
    'FDCB2424': ("SLA (IY+$24),H", 4),
    'FDCB2525': ("SLA (IY+$25),L", 4),
    'FDCB2626': ("SLA (IY+$26)", 4),
    'FDCB2727': ("SLA (IY+$27),A", 4),
    'FDCB2828': ("SRA (IY+$28),B", 4),
    'FDCB2929': ("SRA (IY+$29),C", 4),
    'FDCB2A2A': ("SRA (IY+$2A),D", 4),
    'FDCB2B2B': ("SRA (IY+$2B),E", 4),
    'FDCB2C2C': ("SRA (IY+$2C),H", 4),
    'FDCB2D2D': ("SRA (IY+$2D),L", 4),
    'FDCB2E2E': ("SRA (IY+$2E)", 4),
    'FDCB2F2F': ("SRA (IY+$2F),A", 4),
    'FDCB3030': ("SLL (IY+$30),B", 4),
    'FDCB3131': ("SLL (IY+$31),C", 4),
    'FDCB3232': ("SLL (IY+$32),D", 4),
    'FDCB3333': ("SLL (IY+$33),E", 4),
    'FDCB3434': ("SLL (IY+$34),H", 4),
    'FDCB3535': ("SLL (IY+$35),L", 4),
    'FDCB3636': ("SLL (IY+$36)", 4),
    'FDCB3737': ("SLL (IY+$37),A", 4),
    'FDCB3838': ("SRL (IY+$38),B", 4),
    'FDCB3939': ("SRL (IY+$39),C", 4),
    'FDCB3A3A': ("SRL (IY+$3A),D", 4),
    'FDCB3B3B': ("SRL (IY+$3B),E", 4),
    'FDCB3C3C': ("SRL (IY+$3C),H", 4),
    'FDCB3D3D': ("SRL (IY+$3D),L", 4),
    'FDCB3E3E': ("SRL (IY+$3E)", 4),
    'FDCB3F3F': ("SRL (IY+$3F),A", 4),
    'FDCB4040': ("BIT 0,(IY+$40)", 4),
    'FDCB4141': ("BIT 0,(IY+$41)", 4),
    'FDCB4242': ("BIT 0,(IY+$42)", 4),
    'FDCB4343': ("BIT 0,(IY+$43)", 4),
    'FDCB4444': ("BIT 0,(IY+$44)", 4),
    'FDCB4545': ("BIT 0,(IY+$45)", 4),
    'FDCB4646': ("BIT 0,(IY+$46)", 4),
    'FDCB4747': ("BIT 0,(IY+$47)", 4),
    'FDCB4848': ("BIT 1,(IY+$48)", 4),
    'FDCB4949': ("BIT 1,(IY+$49)", 4),
    'FDCB4A4A': ("BIT 1,(IY+$4A)", 4),
    'FDCB4B4B': ("BIT 1,(IY+$4B)", 4),
    'FDCB4C4C': ("BIT 1,(IY+$4C)", 4),
    'FDCB4D4D': ("BIT 1,(IY+$4D)", 4),
    'FDCB4E4E': ("BIT 1,(IY+$4E)", 4),
    'FDCB4F4F': ("BIT 1,(IY+$4F)", 4),
    'FDCB5050': ("BIT 2,(IY+$50)", 4),
    'FDCB5151': ("BIT 2,(IY+$51)", 4),
    'FDCB5252': ("BIT 2,(IY+$52)", 4),
    'FDCB5353': ("BIT 2,(IY+$53)", 4),
    'FDCB5454': ("BIT 2,(IY+$54)", 4),
    'FDCB5555': ("BIT 2,(IY+$55)", 4),
    'FDCB5656': ("BIT 2,(IY+$56)", 4),
    'FDCB5757': ("BIT 2,(IY+$57)", 4),
    'FDCB5858': ("BIT 3,(IY+$58)", 4),
    'FDCB5959': ("BIT 3,(IY+$59)", 4),
    'FDCB5A5A': ("BIT 3,(IY+$5A)", 4),
    'FDCB5B5B': ("BIT 3,(IY+$5B)", 4),
    'FDCB5C5C': ("BIT 3,(IY+$5C)", 4),
    'FDCB5D5D': ("BIT 3,(IY+$5D)", 4),
    'FDCB5E5E': ("BIT 3,(IY+$5E)", 4),
    'FDCB5F5F': ("BIT 3,(IY+$5F)", 4),
    'FDCB6060': ("BIT 4,(IY+$60)", 4),
    'FDCB6161': ("BIT 4,(IY+$61)", 4),
    'FDCB6262': ("BIT 4,(IY+$62)", 4),
    'FDCB6363': ("BIT 4,(IY+$63)", 4),
    'FDCB6464': ("BIT 4,(IY+$64)", 4),
    'FDCB6565': ("BIT 4,(IY+$65)", 4),
    'FDCB6666': ("BIT 4,(IY+$66)", 4),
    'FDCB6767': ("BIT 4,(IY+$67)", 4),
    'FDCB6868': ("BIT 5,(IY+$68)", 4),
    'FDCB6969': ("BIT 5,(IY+$69)", 4),
    'FDCB6A6A': ("BIT 5,(IY+$6A)", 4),
    'FDCB6B6B': ("BIT 5,(IY+$6B)", 4),
    'FDCB6C6C': ("BIT 5,(IY+$6C)", 4),
    'FDCB6D6D': ("BIT 5,(IY+$6D)", 4),
    'FDCB6E6E': ("BIT 5,(IY+$6E)", 4),
    'FDCB6F6F': ("BIT 5,(IY+$6F)", 4),
    'FDCB7070': ("BIT 6,(IY+$70)", 4),
    'FDCB7171': ("BIT 6,(IY+$71)", 4),
    'FDCB7272': ("BIT 6,(IY+$72)", 4),
    'FDCB7373': ("BIT 6,(IY+$73)", 4),
    'FDCB7474': ("BIT 6,(IY+$74)", 4),
    'FDCB7575': ("BIT 6,(IY+$75)", 4),
    'FDCB7676': ("BIT 6,(IY+$76)", 4),
    'FDCB7777': ("BIT 6,(IY+$77)", 4),
    'FDCB7878': ("BIT 7,(IY+$78)", 4),
    'FDCB7979': ("BIT 7,(IY+$79)", 4),
    'FDCB7A7A': ("BIT 7,(IY+$7A)", 4),
    'FDCB7B7B': ("BIT 7,(IY+$7B)", 4),
    'FDCB7C7C': ("BIT 7,(IY+$7C)", 4),
    'FDCB7D7D': ("BIT 7,(IY+$7D)", 4),
    'FDCB7E7E': ("BIT 7,(IY+$7E)", 4),
    'FDCB7F7F': ("BIT 7,(IY+$7F)", 4),
    'FDCB8080': ("RES 0,(IY-$80),B", 4),
    'FDCB8181': ("RES 0,(IY-$7F),C", 4),
    'FDCB8282': ("RES 0,(IY-$7E),D", 4),
    'FDCB8383': ("RES 0,(IY-$7D),E", 4),
    'FDCB8484': ("RES 0,(IY-$7C),H", 4),
    'FDCB8585': ("RES 0,(IY-$7B),L", 4),
    'FDCB8686': ("RES 0,(IY-$7A)", 4),
    'FDCB8787': ("RES 0,(IY-$79),A", 4),
    'FDCB8888': ("RES 1,(IY-$78),B", 4),
    'FDCB8989': ("RES 1,(IY-$77),C", 4),
    'FDCB8A8A': ("RES 1,(IY-$76),D", 4),
    'FDCB8B8B': ("RES 1,(IY-$75),E", 4),
    'FDCB8C8C': ("RES 1,(IY-$74),H", 4),
    'FDCB8D8D': ("RES 1,(IY-$73),L", 4),
    'FDCB8E8E': ("RES 1,(IY-$72)", 4),
    'FDCB8F8F': ("RES 1,(IY-$71),A", 4),
    'FDCB9090': ("RES 2,(IY-$70),B", 4),
    'FDCB9191': ("RES 2,(IY-$6F),C", 4),
    'FDCB9292': ("RES 2,(IY-$6E),D", 4),
    'FDCB9393': ("RES 2,(IY-$6D),E", 4),
    'FDCB9494': ("RES 2,(IY-$6C),H", 4),
    'FDCB9595': ("RES 2,(IY-$6B),L", 4),
    'FDCB9696': ("RES 2,(IY-$6A)", 4),
    'FDCB9797': ("RES 2,(IY-$69),A", 4),
    'FDCB9898': ("RES 3,(IY-$68),B", 4),
    'FDCB9999': ("RES 3,(IY-$67),C", 4),
    'FDCB9A9A': ("RES 3,(IY-$66),D", 4),
    'FDCB9B9B': ("RES 3,(IY-$65),E", 4),
    'FDCB9C9C': ("RES 3,(IY-$64),H", 4),
    'FDCB9D9D': ("RES 3,(IY-$63),L", 4),
    'FDCB9E9E': ("RES 3,(IY-$62)", 4),
    'FDCB9F9F': ("RES 3,(IY-$61),A", 4),
    'FDCBA0A0': ("RES 4,(IY-$60),B", 4),
    'FDCBA1A1': ("RES 4,(IY-$5F),C", 4),
    'FDCBA2A2': ("RES 4,(IY-$5E),D", 4),
    'FDCBA3A3': ("RES 4,(IY-$5D),E", 4),
    'FDCBA4A4': ("RES 4,(IY-$5C),H", 4),
    'FDCBA5A5': ("RES 4,(IY-$5B),L", 4),
    'FDCBA6A6': ("RES 4,(IY-$5A)", 4),
    'FDCBA7A7': ("RES 4,(IY-$59),A", 4),
    'FDCBA8A8': ("RES 5,(IY-$58),B", 4),
    'FDCBA9A9': ("RES 5,(IY-$57),C", 4),
    'FDCBAAAA': ("RES 5,(IY-$56),D", 4),
    'FDCBABAB': ("RES 5,(IY-$55),E", 4),
    'FDCBACAC': ("RES 5,(IY-$54),H", 4),
    'FDCBADAD': ("RES 5,(IY-$53),L", 4),
    'FDCBAEAE': ("RES 5,(IY-$52)", 4),
    'FDCBAFAF': ("RES 5,(IY-$51),A", 4),
    'FDCBB0B0': ("RES 6,(IY-$50),B", 4),
    'FDCBB1B1': ("RES 6,(IY-$4F),C", 4),
    'FDCBB2B2': ("RES 6,(IY-$4E),D", 4),
    'FDCBB3B3': ("RES 6,(IY-$4D),E", 4),
    'FDCBB4B4': ("RES 6,(IY-$4C),H", 4),
    'FDCBB5B5': ("RES 6,(IY-$4B),L", 4),
    'FDCBB6B6': ("RES 6,(IY-$4A)", 4),
    'FDCBB7B7': ("RES 6,(IY-$49),A", 4),
    'FDCBB8B8': ("RES 7,(IY-$48),B", 4),
    'FDCBB9B9': ("RES 7,(IY-$47),C", 4),
    'FDCBBABA': ("RES 7,(IY-$46),D", 4),
    'FDCBBBBB': ("RES 7,(IY-$45),E", 4),
    'FDCBBCBC': ("RES 7,(IY-$44),H", 4),
    'FDCBBDBD': ("RES 7,(IY-$43),L", 4),
    'FDCBBEBE': ("RES 7,(IY-$42)", 4),
    'FDCBBFBF': ("RES 7,(IY-$41),A", 4),
    'FDCBC0C0': ("SET 0,(IY-$40),B", 4),
    'FDCBC1C1': ("SET 0,(IY-$3F),C", 4),
    'FDCBC2C2': ("SET 0,(IY-$3E),D", 4),
    'FDCBC3C3': ("SET 0,(IY-$3D),E", 4),
    'FDCBC4C4': ("SET 0,(IY-$3C),H", 4),
    'FDCBC5C5': ("SET 0,(IY-$3B),L", 4),
    'FDCBC6C6': ("SET 0,(IY-$3A)", 4),
    'FDCBC7C7': ("SET 0,(IY-$39),A", 4),
    'FDCBC8C8': ("SET 1,(IY-$38),B", 4),
    'FDCBC9C9': ("SET 1,(IY-$37),C", 4),
    'FDCBCACA': ("SET 1,(IY-$36),D", 4),
    'FDCBCBCB': ("SET 1,(IY-$35),E", 4),
    'FDCBCCCC': ("SET 1,(IY-$34),H", 4),
    'FDCBCDCD': ("SET 1,(IY-$33),L", 4),
    'FDCBCECE': ("SET 1,(IY-$32)", 4),
    'FDCBCFCF': ("SET 1,(IY-$31),A", 4),
    'FDCBD0D0': ("SET 2,(IY-$30),B", 4),
    'FDCBD1D1': ("SET 2,(IY-$2F),C", 4),
    'FDCBD2D2': ("SET 2,(IY-$2E),D", 4),
    'FDCBD3D3': ("SET 2,(IY-$2D),E", 4),
    'FDCBD4D4': ("SET 2,(IY-$2C),H", 4),
    'FDCBD5D5': ("SET 2,(IY-$2B),L", 4),
    'FDCBD6D6': ("SET 2,(IY-$2A)", 4),
    'FDCBD7D7': ("SET 2,(IY-$29),A", 4),
    'FDCBD8D8': ("SET 3,(IY-$28),B", 4),
    'FDCBD9D9': ("SET 3,(IY-$27),C", 4),
    'FDCBDADA': ("SET 3,(IY-$26),D", 4),
    'FDCBDBDB': ("SET 3,(IY-$25),E", 4),
    'FDCBDCDC': ("SET 3,(IY-$24),H", 4),
    'FDCBDDDD': ("SET 3,(IY-$23),L", 4),
    'FDCBDEDE': ("SET 3,(IY-$22)", 4),
    'FDCBDFDF': ("SET 3,(IY-$21),A", 4),
    'FDCBE0E0': ("SET 4,(IY-$20),B", 4),
    'FDCBE1E1': ("SET 4,(IY-$1F),C", 4),
    'FDCBE2E2': ("SET 4,(IY-$1E),D", 4),
    'FDCBE3E3': ("SET 4,(IY-$1D),E", 4),
    'FDCBE4E4': ("SET 4,(IY-$1C),H", 4),
    'FDCBE5E5': ("SET 4,(IY-$1B),L", 4),
    'FDCBE6E6': ("SET 4,(IY-$1A)", 4),
    'FDCBE7E7': ("SET 4,(IY-$19),A", 4),
    'FDCBE8E8': ("SET 5,(IY-$18),B", 4),
    'FDCBE9E9': ("SET 5,(IY-$17),C", 4),
    'FDCBEAEA': ("SET 5,(IY-$16),D", 4),
    'FDCBEBEB': ("SET 5,(IY-$15),E", 4),
    'FDCBECEC': ("SET 5,(IY-$14),H", 4),
    'FDCBEDED': ("SET 5,(IY-$13),L", 4),
    'FDCBEEEE': ("SET 5,(IY-$12)", 4),
    'FDCBEFEF': ("SET 5,(IY-$11),A", 4),
    'FDCBF0F0': ("SET 6,(IY-$10),B", 4),
    'FDCBF1F1': ("SET 6,(IY-$0F),C", 4),
    'FDCBF2F2': ("SET 6,(IY-$0E),D", 4),
    'FDCBF3F3': ("SET 6,(IY-$0D),E", 4),
    'FDCBF4F4': ("SET 6,(IY-$0C),H", 4),
    'FDCBF5F5': ("SET 6,(IY-$0B),L", 4),
    'FDCBF6F6': ("SET 6,(IY-$0A)", 4),
    'FDCBF7F7': ("SET 6,(IY-$09),A", 4),
    'FDCBF8F8': ("SET 7,(IY-$08),B", 4),
    'FDCBF9F9': ("SET 7,(IY-$07),C", 4),
    'FDCBFAFA': ("SET 7,(IY-$06),D", 4),
    'FDCBFBFB': ("SET 7,(IY-$05),E", 4),
    'FDCBFCFC': ("SET 7,(IY-$04),H", 4),
    'FDCBFDFD': ("SET 7,(IY-$03),L", 4),
    'FDCBFEFE': ("SET 7,(IY-$02)", 4),
    'FDCBFFFF': ("SET 7,(IY-$01),A", 4),
}

OPCODES_DEC = {
    '00000000': ("NOP", 1),
    '01010101': ("LD BC,257", 3),
    '02020202': ("LD (BC),A", 1),
    '03030303': ("INC BC", 1),
    '04040404': ("INC B", 1),
    '05050505': ("DEC B", 1),
    '06060606': ("LD B,6", 2),
    '07070707': ("RLCA", 1),
    '08080808': ("EX AF,AF'", 1),
    '09090909': ("ADD HL,BC", 1),
    '0A0A0A0A': ("LD A,(BC)", 1),
    '0B0B0B0B': ("DEC BC", 1),
    '0C0C0C0C': ("INC C", 1),
    '0D0D0D0D': ("DEC C", 1),
    '0E0E0E0E': ("LD C,14", 2),
    '0F0F0F0F': ("RRCA", 1),
    '10101010': ("DJNZ 18", 2),
    '11111111': ("LD DE,4369", 3),
    '12121212': ("LD (DE),A", 1),
    '13131313': ("INC DE", 1),
    '14141414': ("INC D", 1),
    '15151515': ("DEC D", 1),
    '16161616': ("LD D,22", 2),
    '17171717': ("RLA", 1),
    '18181818': ("JR 26", 2),
    '19191919': ("ADD HL,DE", 1),
    '1A1A1A1A': ("LD A,(DE)", 1),
    '1B1B1B1B': ("DEC DE", 1),
    '1C1C1C1C': ("INC E", 1),
    '1D1D1D1D': ("DEC E", 1),
    '1E1E1E1E': ("LD E,30", 2),
    '1F1F1F1F': ("RRA", 1),
    '20202020': ("JR NZ,34", 2),
    '21212121': ("LD HL,8481", 3),
    '22222222': ("LD (8738),HL", 3),
    '23232323': ("INC HL", 1),
    '24242424': ("INC H", 1),
    '25252525': ("DEC H", 1),
    '26262626': ("LD H,38", 2),
    '27272727': ("DAA", 1),
    '28282828': ("JR Z,42", 2),
    '29292929': ("ADD HL,HL", 1),
    '2A2A2A2A': ("LD HL,(10794)", 3),
    '2B2B2B2B': ("DEC HL", 1),
    '2C2C2C2C': ("INC L", 1),
    '2D2D2D2D': ("DEC L", 1),
    '2E2E2E2E': ("LD L,46", 2),
    '2F2F2F2F': ("CPL", 1),
    '30303030': ("JR NC,50", 2),
    '31313131': ("LD SP,12593", 3),
    '32323232': ("LD (12850),A", 3),
    '33333333': ("INC SP", 1),
    '34343434': ("INC (HL)", 1),
    '35353535': ("DEC (HL)", 1),
    '36363636': ("LD (HL),54", 2),
    '37373737': ("SCF", 1),
    '38383838': ("JR C,58", 2),
    '39393939': ("ADD HL,SP", 1),
    '3A3A3A3A': ("LD A,(14906)", 3),
    '3B3B3B3B': ("DEC SP", 1),
    '3C3C3C3C': ("INC A", 1),
    '3D3D3D3D': ("DEC A", 1),
    '3E3E3E3E': ("LD A,62", 2),
    '3F3F3F3F': ("CCF", 1),
    '40404040': ("LD B,B", 1),
    '41414141': ("LD B,C", 1),
    '42424242': ("LD B,D", 1),
    '43434343': ("LD B,E", 1),
    '44444444': ("LD B,H", 1),
    '45454545': ("LD B,L", 1),
    '46464646': ("LD B,(HL)", 1),
    '47474747': ("LD B,A", 1),
    '48484848': ("LD C,B", 1),
    '49494949': ("LD C,C", 1),
    '4A4A4A4A': ("LD C,D", 1),
    '4B4B4B4B': ("LD C,E", 1),
    '4C4C4C4C': ("LD C,H", 1),
    '4D4D4D4D': ("LD C,L", 1),
    '4E4E4E4E': ("LD C,(HL)", 1),
    '4F4F4F4F': ("LD C,A", 1),
    '50505050': ("LD D,B", 1),
    '51515151': ("LD D,C", 1),
    '52525252': ("LD D,D", 1),
    '53535353': ("LD D,E", 1),
    '54545454': ("LD D,H", 1),
    '55555555': ("LD D,L", 1),
    '56565656': ("LD D,(HL)", 1),
    '57575757': ("LD D,A", 1),
    '58585858': ("LD E,B", 1),
    '59595959': ("LD E,C", 1),
    '5A5A5A5A': ("LD E,D", 1),
    '5B5B5B5B': ("LD E,E", 1),
    '5C5C5C5C': ("LD E,H", 1),
    '5D5D5D5D': ("LD E,L", 1),
    '5E5E5E5E': ("LD E,(HL)", 1),
    '5F5F5F5F': ("LD E,A", 1),
    '60606060': ("LD H,B", 1),
    '61616161': ("LD H,C", 1),
    '62626262': ("LD H,D", 1),
    '63636363': ("LD H,E", 1),
    '64646464': ("LD H,H", 1),
    '65656565': ("LD H,L", 1),
    '66666666': ("LD H,(HL)", 1),
    '67676767': ("LD H,A", 1),
    '68686868': ("LD L,B", 1),
    '69696969': ("LD L,C", 1),
    '6A6A6A6A': ("LD L,D", 1),
    '6B6B6B6B': ("LD L,E", 1),
    '6C6C6C6C': ("LD L,H", 1),
    '6D6D6D6D': ("LD L,L", 1),
    '6E6E6E6E': ("LD L,(HL)", 1),
    '6F6F6F6F': ("LD L,A", 1),
    '70707070': ("LD (HL),B", 1),
    '71717171': ("LD (HL),C", 1),
    '72727272': ("LD (HL),D", 1),
    '73737373': ("LD (HL),E", 1),
    '74747474': ("LD (HL),H", 1),
    '75757575': ("LD (HL),L", 1),
    '76767676': ("HALT", 1),
    '77777777': ("LD (HL),A", 1),
    '78787878': ("LD A,B", 1),
    '79797979': ("LD A,C", 1),
    '7A7A7A7A': ("LD A,D", 1),
    '7B7B7B7B': ("LD A,E", 1),
    '7C7C7C7C': ("LD A,H", 1),
    '7D7D7D7D': ("LD A,L", 1),
    '7E7E7E7E': ("LD A,(HL)", 1),
    '7F7F7F7F': ("LD A,A", 1),
    '80808080': ("ADD A,B", 1),
    '81818181': ("ADD A,C", 1),
    '82828282': ("ADD A,D", 1),
    '83838383': ("ADD A,E", 1),
    '84848484': ("ADD A,H", 1),
    '85858585': ("ADD A,L", 1),
    '86868686': ("ADD A,(HL)", 1),
    '87878787': ("ADD A,A", 1),
    '88888888': ("ADC A,B", 1),
    '89898989': ("ADC A,C", 1),
    '8A8A8A8A': ("ADC A,D", 1),
    '8B8B8B8B': ("ADC A,E", 1),
    '8C8C8C8C': ("ADC A,H", 1),
    '8D8D8D8D': ("ADC A,L", 1),
    '8E8E8E8E': ("ADC A,(HL)", 1),
    '8F8F8F8F': ("ADC A,A", 1),
    '90909090': ("SUB B", 1),
    '91919191': ("SUB C", 1),
    '92929292': ("SUB D", 1),
    '93939393': ("SUB E", 1),
    '94949494': ("SUB H", 1),
    '95959595': ("SUB L", 1),
    '96969696': ("SUB (HL)", 1),
    '97979797': ("SUB A", 1),
    '98989898': ("SBC A,B", 1),
    '99999999': ("SBC A,C", 1),
    '9A9A9A9A': ("SBC A,D", 1),
    '9B9B9B9B': ("SBC A,E", 1),
    '9C9C9C9C': ("SBC A,H", 1),
    '9D9D9D9D': ("SBC A,L", 1),
    '9E9E9E9E': ("SBC A,(HL)", 1),
    '9F9F9F9F': ("SBC A,A", 1),
    'A0A0A0A0': ("AND B", 1),
    'A1A1A1A1': ("AND C", 1),
    'A2A2A2A2': ("AND D", 1),
    'A3A3A3A3': ("AND E", 1),
    'A4A4A4A4': ("AND H", 1),
    'A5A5A5A5': ("AND L", 1),
    'A6A6A6A6': ("AND (HL)", 1),
    'A7A7A7A7': ("AND A", 1),
    'A8A8A8A8': ("XOR B", 1),
    'A9A9A9A9': ("XOR C", 1),
    'AAAAAAAA': ("XOR D", 1),
    'ABABABAB': ("XOR E", 1),
    'ACACACAC': ("XOR H", 1),
    'ADADADAD': ("XOR L", 1),
    'AEAEAEAE': ("XOR (HL)", 1),
    'AFAFAFAF': ("XOR A", 1),
    'B0B0B0B0': ("OR B", 1),
    'B1B1B1B1': ("OR C", 1),
    'B2B2B2B2': ("OR D", 1),
    'B3B3B3B3': ("OR E", 1),
    'B4B4B4B4': ("OR H", 1),
    'B5B5B5B5': ("OR L", 1),
    'B6B6B6B6': ("OR (HL)", 1),
    'B7B7B7B7': ("OR A", 1),
    'B8B8B8B8': ("CP B", 1),
    'B9B9B9B9': ("CP C", 1),
    'BABABABA': ("CP D", 1),
    'BBBBBBBB': ("CP E", 1),
    'BCBCBCBC': ("CP H", 1),
    'BDBDBDBD': ("CP L", 1),
    'BEBEBEBE': ("CP (HL)", 1),
    'BFBFBFBF': ("CP A", 1),
    'C0C0C0C0': ("RET NZ", 1),
    'C1C1C1C1': ("POP BC", 1),
    'C2C2C2C2': ("JP NZ,49858", 3),
    'C3C3C3C3': ("JP 50115", 3),
    'C4C4C4C4': ("CALL NZ,50372", 3),
    'C5C5C5C5': ("PUSH BC", 1),
    'C6C6C6C6': ("ADD A,198", 2),
    'C7C7C7C7': ("RST 0", 1),
    'C8C8C8C8': ("RET Z", 1),
    'C9C9C9C9': ("RET", 1),
    'CACACACA': ("JP Z,51914", 3),
    'CCCCCCCC': ("CALL Z,52428", 3),
    'CDCDCDCD': ("CALL 52685", 3),
    'CECECECE': ("ADC A,206", 2),
    'CFCFCFCF': ("RST 8", 1),
    'D0D0D0D0': ("RET NC", 1),
    'D1D1D1D1': ("POP DE", 1),
    'D2D2D2D2': ("JP NC,53970", 3),
    'D3D3D3D3': ("OUT (211),A", 2),
    'D4D4D4D4': ("CALL NC,54484", 3),
    'D5D5D5D5': ("PUSH DE", 1),
    'D6D6D6D6': ("SUB 214", 2),
    'D7D7D7D7': ("RST 16", 1),
    'D8D8D8D8': ("RET C", 1),
    'D9D9D9D9': ("EXX", 1),
    'DADADADA': ("JP C,56026", 3),
    'DBDBDBDB': ("IN A,(219)", 2),
    'DCDCDCDC': ("CALL C,56540", 3),
    'DEDEDEDE': ("SBC A,222", 2),
    'DFDFDFDF': ("RST 24", 1),
    'E0E0E0E0': ("RET PO", 1),
    'E1E1E1E1': ("POP HL", 1),
    'E2E2E2E2': ("JP PO,58082", 3),
    'E3E3E3E3': ("EX (SP),HL", 1),
    'E4E4E4E4': ("CALL PO,58596", 3),
    'E5E5E5E5': ("PUSH HL", 1),
    'E6E6E6E6': ("AND 230", 2),
    'E7E7E7E7': ("RST 32", 1),
    'E8E8E8E8': ("RET PE", 1),
    'E9E9E9E9': ("JP (HL)", 1),
    'EAEAEAEA': ("JP PE,60138", 3),
    'EBEBEBEB': ("EX DE,HL", 1),
    'ECECECEC': ("CALL PE,60652", 3),
    'EEEEEEEE': ("XOR 238", 2),
    'EFEFEFEF': ("RST 40", 1),
    'F0F0F0F0': ("RET P", 1),
    'F1F1F1F1': ("POP AF", 1),
    'F2F2F2F2': ("JP P,62194", 3),
    'F3F3F3F3': ("DI", 1),
    'F4F4F4F4': ("CALL P,62708", 3),
    'F5F5F5F5': ("PUSH AF", 1),
    'F6F6F6F6': ("OR 246", 2),
    'F7F7F7F7': ("RST 48", 1),
    'F8F8F8F8': ("RET M", 1),
    'F9F9F9F9': ("LD SP,HL", 1),
    'FAFAFAFA': ("JP M,64250", 3),
    'FBFBFBFB': ("EI", 1),
    'FCFCFCFC': ("CALL M,64764", 3),
    'FEFEFEFE': ("CP 254", 2),
    'FFFFFFFF': ("RST 56", 1),
    'CB000000': ("RLC B", 2),
    'CB010101': ("RLC C", 2),
    'CB020202': ("RLC D", 2),
    'CB030303': ("RLC E", 2),
    'CB040404': ("RLC H", 2),
    'CB050505': ("RLC L", 2),
    'CB060606': ("RLC (HL)", 2),
    'CB070707': ("RLC A", 2),
    'CB080808': ("RRC B", 2),
    'CB090909': ("RRC C", 2),
    'CB0A0A0A': ("RRC D", 2),
    'CB0B0B0B': ("RRC E", 2),
    'CB0C0C0C': ("RRC H", 2),
    'CB0D0D0D': ("RRC L", 2),
    'CB0E0E0E': ("RRC (HL)", 2),
    'CB0F0F0F': ("RRC A", 2),
    'CB101010': ("RL B", 2),
    'CB111111': ("RL C", 2),
    'CB121212': ("RL D", 2),
    'CB131313': ("RL E", 2),
    'CB141414': ("RL H", 2),
    'CB151515': ("RL L", 2),
    'CB161616': ("RL (HL)", 2),
    'CB171717': ("RL A", 2),
    'CB181818': ("RR B", 2),
    'CB191919': ("RR C", 2),
    'CB1A1A1A': ("RR D", 2),
    'CB1B1B1B': ("RR E", 2),
    'CB1C1C1C': ("RR H", 2),
    'CB1D1D1D': ("RR L", 2),
    'CB1E1E1E': ("RR (HL)", 2),
    'CB1F1F1F': ("RR A", 2),
    'CB202020': ("SLA B", 2),
    'CB212121': ("SLA C", 2),
    'CB222222': ("SLA D", 2),
    'CB232323': ("SLA E", 2),
    'CB242424': ("SLA H", 2),
    'CB252525': ("SLA L", 2),
    'CB262626': ("SLA (HL)", 2),
    'CB272727': ("SLA A", 2),
    'CB282828': ("SRA B", 2),
    'CB292929': ("SRA C", 2),
    'CB2A2A2A': ("SRA D", 2),
    'CB2B2B2B': ("SRA E", 2),
    'CB2C2C2C': ("SRA H", 2),
    'CB2D2D2D': ("SRA L", 2),
    'CB2E2E2E': ("SRA (HL)", 2),
    'CB2F2F2F': ("SRA A", 2),
    'CB303030': ("SLL B", 2),
    'CB313131': ("SLL C", 2),
    'CB323232': ("SLL D", 2),
    'CB333333': ("SLL E", 2),
    'CB343434': ("SLL H", 2),
    'CB353535': ("SLL L", 2),
    'CB363636': ("SLL (HL)", 2),
    'CB373737': ("SLL A", 2),
    'CB383838': ("SRL B", 2),
    'CB393939': ("SRL C", 2),
    'CB3A3A3A': ("SRL D", 2),
    'CB3B3B3B': ("SRL E", 2),
    'CB3C3C3C': ("SRL H", 2),
    'CB3D3D3D': ("SRL L", 2),
    'CB3E3E3E': ("SRL (HL)", 2),
    'CB3F3F3F': ("SRL A", 2),
    'CB404040': ("BIT 0,B", 2),
    'CB414141': ("BIT 0,C", 2),
    'CB424242': ("BIT 0,D", 2),
    'CB434343': ("BIT 0,E", 2),
    'CB444444': ("BIT 0,H", 2),
    'CB454545': ("BIT 0,L", 2),
    'CB464646': ("BIT 0,(HL)", 2),
    'CB474747': ("BIT 0,A", 2),
    'CB484848': ("BIT 1,B", 2),
    'CB494949': ("BIT 1,C", 2),
    'CB4A4A4A': ("BIT 1,D", 2),
    'CB4B4B4B': ("BIT 1,E", 2),
    'CB4C4C4C': ("BIT 1,H", 2),
    'CB4D4D4D': ("BIT 1,L", 2),
    'CB4E4E4E': ("BIT 1,(HL)", 2),
    'CB4F4F4F': ("BIT 1,A", 2),
    'CB505050': ("BIT 2,B", 2),
    'CB515151': ("BIT 2,C", 2),
    'CB525252': ("BIT 2,D", 2),
    'CB535353': ("BIT 2,E", 2),
    'CB545454': ("BIT 2,H", 2),
    'CB555555': ("BIT 2,L", 2),
    'CB565656': ("BIT 2,(HL)", 2),
    'CB575757': ("BIT 2,A", 2),
    'CB585858': ("BIT 3,B", 2),
    'CB595959': ("BIT 3,C", 2),
    'CB5A5A5A': ("BIT 3,D", 2),
    'CB5B5B5B': ("BIT 3,E", 2),
    'CB5C5C5C': ("BIT 3,H", 2),
    'CB5D5D5D': ("BIT 3,L", 2),
    'CB5E5E5E': ("BIT 3,(HL)", 2),
    'CB5F5F5F': ("BIT 3,A", 2),
    'CB606060': ("BIT 4,B", 2),
    'CB616161': ("BIT 4,C", 2),
    'CB626262': ("BIT 4,D", 2),
    'CB636363': ("BIT 4,E", 2),
    'CB646464': ("BIT 4,H", 2),
    'CB656565': ("BIT 4,L", 2),
    'CB666666': ("BIT 4,(HL)", 2),
    'CB676767': ("BIT 4,A", 2),
    'CB686868': ("BIT 5,B", 2),
    'CB696969': ("BIT 5,C", 2),
    'CB6A6A6A': ("BIT 5,D", 2),
    'CB6B6B6B': ("BIT 5,E", 2),
    'CB6C6C6C': ("BIT 5,H", 2),
    'CB6D6D6D': ("BIT 5,L", 2),
    'CB6E6E6E': ("BIT 5,(HL)", 2),
    'CB6F6F6F': ("BIT 5,A", 2),
    'CB707070': ("BIT 6,B", 2),
    'CB717171': ("BIT 6,C", 2),
    'CB727272': ("BIT 6,D", 2),
    'CB737373': ("BIT 6,E", 2),
    'CB747474': ("BIT 6,H", 2),
    'CB757575': ("BIT 6,L", 2),
    'CB767676': ("BIT 6,(HL)", 2),
    'CB777777': ("BIT 6,A", 2),
    'CB787878': ("BIT 7,B", 2),
    'CB797979': ("BIT 7,C", 2),
    'CB7A7A7A': ("BIT 7,D", 2),
    'CB7B7B7B': ("BIT 7,E", 2),
    'CB7C7C7C': ("BIT 7,H", 2),
    'CB7D7D7D': ("BIT 7,L", 2),
    'CB7E7E7E': ("BIT 7,(HL)", 2),
    'CB7F7F7F': ("BIT 7,A", 2),
    'CB808080': ("RES 0,B", 2),
    'CB818181': ("RES 0,C", 2),
    'CB828282': ("RES 0,D", 2),
    'CB838383': ("RES 0,E", 2),
    'CB848484': ("RES 0,H", 2),
    'CB858585': ("RES 0,L", 2),
    'CB868686': ("RES 0,(HL)", 2),
    'CB878787': ("RES 0,A", 2),
    'CB888888': ("RES 1,B", 2),
    'CB898989': ("RES 1,C", 2),
    'CB8A8A8A': ("RES 1,D", 2),
    'CB8B8B8B': ("RES 1,E", 2),
    'CB8C8C8C': ("RES 1,H", 2),
    'CB8D8D8D': ("RES 1,L", 2),
    'CB8E8E8E': ("RES 1,(HL)", 2),
    'CB8F8F8F': ("RES 1,A", 2),
    'CB909090': ("RES 2,B", 2),
    'CB919191': ("RES 2,C", 2),
    'CB929292': ("RES 2,D", 2),
    'CB939393': ("RES 2,E", 2),
    'CB949494': ("RES 2,H", 2),
    'CB959595': ("RES 2,L", 2),
    'CB969696': ("RES 2,(HL)", 2),
    'CB979797': ("RES 2,A", 2),
    'CB989898': ("RES 3,B", 2),
    'CB999999': ("RES 3,C", 2),
    'CB9A9A9A': ("RES 3,D", 2),
    'CB9B9B9B': ("RES 3,E", 2),
    'CB9C9C9C': ("RES 3,H", 2),
    'CB9D9D9D': ("RES 3,L", 2),
    'CB9E9E9E': ("RES 3,(HL)", 2),
    'CB9F9F9F': ("RES 3,A", 2),
    'CBA0A0A0': ("RES 4,B", 2),
    'CBA1A1A1': ("RES 4,C", 2),
    'CBA2A2A2': ("RES 4,D", 2),
    'CBA3A3A3': ("RES 4,E", 2),
    'CBA4A4A4': ("RES 4,H", 2),
    'CBA5A5A5': ("RES 4,L", 2),
    'CBA6A6A6': ("RES 4,(HL)", 2),
    'CBA7A7A7': ("RES 4,A", 2),
    'CBA8A8A8': ("RES 5,B", 2),
    'CBA9A9A9': ("RES 5,C", 2),
    'CBAAAAAA': ("RES 5,D", 2),
    'CBABABAB': ("RES 5,E", 2),
    'CBACACAC': ("RES 5,H", 2),
    'CBADADAD': ("RES 5,L", 2),
    'CBAEAEAE': ("RES 5,(HL)", 2),
    'CBAFAFAF': ("RES 5,A", 2),
    'CBB0B0B0': ("RES 6,B", 2),
    'CBB1B1B1': ("RES 6,C", 2),
    'CBB2B2B2': ("RES 6,D", 2),
    'CBB3B3B3': ("RES 6,E", 2),
    'CBB4B4B4': ("RES 6,H", 2),
    'CBB5B5B5': ("RES 6,L", 2),
    'CBB6B6B6': ("RES 6,(HL)", 2),
    'CBB7B7B7': ("RES 6,A", 2),
    'CBB8B8B8': ("RES 7,B", 2),
    'CBB9B9B9': ("RES 7,C", 2),
    'CBBABABA': ("RES 7,D", 2),
    'CBBBBBBB': ("RES 7,E", 2),
    'CBBCBCBC': ("RES 7,H", 2),
    'CBBDBDBD': ("RES 7,L", 2),
    'CBBEBEBE': ("RES 7,(HL)", 2),
    'CBBFBFBF': ("RES 7,A", 2),
    'CBC0C0C0': ("SET 0,B", 2),
    'CBC1C1C1': ("SET 0,C", 2),
    'CBC2C2C2': ("SET 0,D", 2),
    'CBC3C3C3': ("SET 0,E", 2),
    'CBC4C4C4': ("SET 0,H", 2),
    'CBC5C5C5': ("SET 0,L", 2),
    'CBC6C6C6': ("SET 0,(HL)", 2),
    'CBC7C7C7': ("SET 0,A", 2),
    'CBC8C8C8': ("SET 1,B", 2),
    'CBC9C9C9': ("SET 1,C", 2),
    'CBCACACA': ("SET 1,D", 2),
    'CBCBCBCB': ("SET 1,E", 2),
    'CBCCCCCC': ("SET 1,H", 2),
    'CBCDCDCD': ("SET 1,L", 2),
    'CBCECECE': ("SET 1,(HL)", 2),
    'CBCFCFCF': ("SET 1,A", 2),
    'CBD0D0D0': ("SET 2,B", 2),
    'CBD1D1D1': ("SET 2,C", 2),
    'CBD2D2D2': ("SET 2,D", 2),
    'CBD3D3D3': ("SET 2,E", 2),
    'CBD4D4D4': ("SET 2,H", 2),
    'CBD5D5D5': ("SET 2,L", 2),
    'CBD6D6D6': ("SET 2,(HL)", 2),
    'CBD7D7D7': ("SET 2,A", 2),
    'CBD8D8D8': ("SET 3,B", 2),
    'CBD9D9D9': ("SET 3,C", 2),
    'CBDADADA': ("SET 3,D", 2),
    'CBDBDBDB': ("SET 3,E", 2),
    'CBDCDCDC': ("SET 3,H", 2),
    'CBDDDDDD': ("SET 3,L", 2),
    'CBDEDEDE': ("SET 3,(HL)", 2),
    'CBDFDFDF': ("SET 3,A", 2),
    'CBE0E0E0': ("SET 4,B", 2),
    'CBE1E1E1': ("SET 4,C", 2),
    'CBE2E2E2': ("SET 4,D", 2),
    'CBE3E3E3': ("SET 4,E", 2),
    'CBE4E4E4': ("SET 4,H", 2),
    'CBE5E5E5': ("SET 4,L", 2),
    'CBE6E6E6': ("SET 4,(HL)", 2),
    'CBE7E7E7': ("SET 4,A", 2),
    'CBE8E8E8': ("SET 5,B", 2),
    'CBE9E9E9': ("SET 5,C", 2),
    'CBEAEAEA': ("SET 5,D", 2),
    'CBEBEBEB': ("SET 5,E", 2),
    'CBECECEC': ("SET 5,H", 2),
    'CBEDEDED': ("SET 5,L", 2),
    'CBEEEEEE': ("SET 5,(HL)", 2),
    'CBEFEFEF': ("SET 5,A", 2),
    'CBF0F0F0': ("SET 6,B", 2),
    'CBF1F1F1': ("SET 6,C", 2),
    'CBF2F2F2': ("SET 6,D", 2),
    'CBF3F3F3': ("SET 6,E", 2),
    'CBF4F4F4': ("SET 6,H", 2),
    'CBF5F5F5': ("SET 6,L", 2),
    'CBF6F6F6': ("SET 6,(HL)", 2),
    'CBF7F7F7': ("SET 6,A", 2),
    'CBF8F8F8': ("SET 7,B", 2),
    'CBF9F9F9': ("SET 7,C", 2),
    'CBFAFAFA': ("SET 7,D", 2),
    'CBFBFBFB': ("SET 7,E", 2),
    'CBFCFCFC': ("SET 7,H", 2),
    'CBFDFDFD': ("SET 7,L", 2),
    'CBFEFEFE': ("SET 7,(HL)", 2),
    'CBFFFFFF': ("SET 7,A", 2),
    'DD000000': ("DEFB 221", 1),
    'DD010101': ("DEFB 221", 1),
    'DD020202': ("DEFB 221", 1),
    'DD030303': ("DEFB 221", 1),
    'DD040404': ("DEFB 221", 1),
    'DD050505': ("DEFB 221", 1),
    'DD060606': ("DEFB 221", 1),
    'DD070707': ("DEFB 221", 1),
    'DD080808': ("DEFB 221", 1),
    'DD090909': ("ADD IX,BC", 2),
    'DD0A0A0A': ("DEFB 221", 1),
    'DD0B0B0B': ("DEFB 221", 1),
    'DD0C0C0C': ("DEFB 221", 1),
    'DD0D0D0D': ("DEFB 221", 1),
    'DD0E0E0E': ("DEFB 221", 1),
    'DD0F0F0F': ("DEFB 221", 1),
    'DD101010': ("DEFB 221", 1),
    'DD111111': ("DEFB 221", 1),
    'DD121212': ("DEFB 221", 1),
    'DD131313': ("DEFB 221", 1),
    'DD141414': ("DEFB 221", 1),
    'DD151515': ("DEFB 221", 1),
    'DD161616': ("DEFB 221", 1),
    'DD171717': ("DEFB 221", 1),
    'DD181818': ("DEFB 221", 1),
    'DD191919': ("ADD IX,DE", 2),
    'DD1A1A1A': ("DEFB 221", 1),
    'DD1B1B1B': ("DEFB 221", 1),
    'DD1C1C1C': ("DEFB 221", 1),
    'DD1D1D1D': ("DEFB 221", 1),
    'DD1E1E1E': ("DEFB 221", 1),
    'DD1F1F1F': ("DEFB 221", 1),
    'DD202020': ("DEFB 221", 1),
    'DD212121': ("LD IX,8481", 4),
    'DD222222': ("LD (8738),IX", 4),
    'DD232323': ("INC IX", 2),
    'DD242424': ("INC IXh", 2),
    'DD252525': ("DEC IXh", 2),
    'DD262626': ("LD IXh,38", 3),
    'DD272727': ("DEFB 221", 1),
    'DD282828': ("DEFB 221", 1),
    'DD292929': ("ADD IX,IX", 2),
    'DD2A2A2A': ("LD IX,(10794)", 4),
    'DD2B2B2B': ("DEC IX", 2),
    'DD2C2C2C': ("INC IXl", 2),
    'DD2D2D2D': ("DEC IXl", 2),
    'DD2E2E2E': ("LD IXl,46", 3),
    'DD2F2F2F': ("DEFB 221", 1),
    'DD303030': ("DEFB 221", 1),
    'DD313131': ("DEFB 221", 1),
    'DD323232': ("DEFB 221", 1),
    'DD333333': ("DEFB 221", 1),
    'DD343434': ("INC (IX+52)", 3),
    'DD353535': ("DEC (IX+53)", 3),
    'DD363636': ("LD (IX+54),54", 4),
    'DD373737': ("DEFB 221", 1),
    'DD383838': ("DEFB 221", 1),
    'DD393939': ("ADD IX,SP", 2),
    'DD3A3A3A': ("DEFB 221", 1),
    'DD3B3B3B': ("DEFB 221", 1),
    'DD3C3C3C': ("DEFB 221", 1),
    'DD3D3D3D': ("DEFB 221", 1),
    'DD3E3E3E': ("DEFB 221", 1),
    'DD3F3F3F': ("DEFB 221", 1),
    'DD404040': ("DEFB 221", 1),
    'DD414141': ("DEFB 221", 1),
    'DD424242': ("DEFB 221", 1),
    'DD434343': ("DEFB 221", 1),
    'DD444444': ("LD B,IXh", 2),
    'DD454545': ("LD B,IXl", 2),
    'DD464646': ("LD B,(IX+70)", 3),
    'DD474747': ("DEFB 221", 1),
    'DD484848': ("DEFB 221", 1),
    'DD494949': ("DEFB 221", 1),
    'DD4A4A4A': ("DEFB 221", 1),
    'DD4B4B4B': ("DEFB 221", 1),
    'DD4C4C4C': ("LD C,IXh", 2),
    'DD4D4D4D': ("LD C,IXl", 2),
    'DD4E4E4E': ("LD C,(IX+78)", 3),
    'DD4F4F4F': ("DEFB 221", 1),
    'DD505050': ("DEFB 221", 1),
    'DD515151': ("DEFB 221", 1),
    'DD525252': ("DEFB 221", 1),
    'DD535353': ("DEFB 221", 1),
    'DD545454': ("LD D,IXh", 2),
    'DD555555': ("LD D,IXl", 2),
    'DD565656': ("LD D,(IX+86)", 3),
    'DD575757': ("DEFB 221", 1),
    'DD585858': ("DEFB 221", 1),
    'DD595959': ("DEFB 221", 1),
    'DD5A5A5A': ("DEFB 221", 1),
    'DD5B5B5B': ("DEFB 221", 1),
    'DD5C5C5C': ("LD E,IXh", 2),
    'DD5D5D5D': ("LD E,IXl", 2),
    'DD5E5E5E': ("LD E,(IX+94)", 3),
    'DD5F5F5F': ("DEFB 221", 1),
    'DD606060': ("LD IXh,B", 2),
    'DD616161': ("LD IXh,C", 2),
    'DD626262': ("LD IXh,D", 2),
    'DD636363': ("LD IXh,E", 2),
    'DD646464': ("LD IXh,IXh", 2),
    'DD656565': ("LD IXh,IXl", 2),
    'DD666666': ("LD H,(IX+102)", 3),
    'DD676767': ("LD IXh,A", 2),
    'DD686868': ("LD IXl,B", 2),
    'DD696969': ("LD IXl,C", 2),
    'DD6A6A6A': ("LD IXl,D", 2),
    'DD6B6B6B': ("LD IXl,E", 2),
    'DD6C6C6C': ("LD IXl,IXh", 2),
    'DD6D6D6D': ("LD IXl,IXl", 2),
    'DD6E6E6E': ("LD L,(IX+110)", 3),
    'DD6F6F6F': ("LD IXl,A", 2),
    'DD707070': ("LD (IX+112),B", 3),
    'DD717171': ("LD (IX+113),C", 3),
    'DD727272': ("LD (IX+114),D", 3),
    'DD737373': ("LD (IX+115),E", 3),
    'DD747474': ("LD (IX+116),H", 3),
    'DD757575': ("LD (IX+117),L", 3),
    'DD767676': ("DEFB 221", 1),
    'DD777777': ("LD (IX+119),A", 3),
    'DD787878': ("DEFB 221", 1),
    'DD797979': ("DEFB 221", 1),
    'DD7A7A7A': ("DEFB 221", 1),
    'DD7B7B7B': ("DEFB 221", 1),
    'DD7C7C7C': ("LD A,IXh", 2),
    'DD7D7D7D': ("LD A,IXl", 2),
    'DD7E7E7E': ("LD A,(IX+126)", 3),
    'DD7F7F7F': ("DEFB 221", 1),
    'DD808080': ("DEFB 221", 1),
    'DD818181': ("DEFB 221", 1),
    'DD828282': ("DEFB 221", 1),
    'DD838383': ("DEFB 221", 1),
    'DD848484': ("ADD A,IXh", 2),
    'DD858585': ("ADD A,IXl", 2),
    'DD868686': ("ADD A,(IX-122)", 3),
    'DD878787': ("DEFB 221", 1),
    'DD888888': ("DEFB 221", 1),
    'DD898989': ("DEFB 221", 1),
    'DD8A8A8A': ("DEFB 221", 1),
    'DD8B8B8B': ("DEFB 221", 1),
    'DD8C8C8C': ("ADC A,IXh", 2),
    'DD8D8D8D': ("ADC A,IXl", 2),
    'DD8E8E8E': ("ADC A,(IX-114)", 3),
    'DD8F8F8F': ("DEFB 221", 1),
    'DD909090': ("DEFB 221", 1),
    'DD919191': ("DEFB 221", 1),
    'DD929292': ("DEFB 221", 1),
    'DD939393': ("DEFB 221", 1),
    'DD949494': ("SUB IXh", 2),
    'DD959595': ("SUB IXl", 2),
    'DD969696': ("SUB (IX-106)", 3),
    'DD979797': ("DEFB 221", 1),
    'DD989898': ("DEFB 221", 1),
    'DD999999': ("DEFB 221", 1),
    'DD9A9A9A': ("DEFB 221", 1),
    'DD9B9B9B': ("DEFB 221", 1),
    'DD9C9C9C': ("SBC A,IXh", 2),
    'DD9D9D9D': ("SBC A,IXl", 2),
    'DD9E9E9E': ("SBC A,(IX-98)", 3),
    'DD9F9F9F': ("DEFB 221", 1),
    'DDA0A0A0': ("DEFB 221", 1),
    'DDA1A1A1': ("DEFB 221", 1),
    'DDA2A2A2': ("DEFB 221", 1),
    'DDA3A3A3': ("DEFB 221", 1),
    'DDA4A4A4': ("AND IXh", 2),
    'DDA5A5A5': ("AND IXl", 2),
    'DDA6A6A6': ("AND (IX-90)", 3),
    'DDA7A7A7': ("DEFB 221", 1),
    'DDA8A8A8': ("DEFB 221", 1),
    'DDA9A9A9': ("DEFB 221", 1),
    'DDAAAAAA': ("DEFB 221", 1),
    'DDABABAB': ("DEFB 221", 1),
    'DDACACAC': ("XOR IXh", 2),
    'DDADADAD': ("XOR IXl", 2),
    'DDAEAEAE': ("XOR (IX-82)", 3),
    'DDAFAFAF': ("DEFB 221", 1),
    'DDB0B0B0': ("DEFB 221", 1),
    'DDB1B1B1': ("DEFB 221", 1),
    'DDB2B2B2': ("DEFB 221", 1),
    'DDB3B3B3': ("DEFB 221", 1),
    'DDB4B4B4': ("OR IXh", 2),
    'DDB5B5B5': ("OR IXl", 2),
    'DDB6B6B6': ("OR (IX-74)", 3),
    'DDB7B7B7': ("DEFB 221", 1),
    'DDB8B8B8': ("DEFB 221", 1),
    'DDB9B9B9': ("DEFB 221", 1),
    'DDBABABA': ("DEFB 221", 1),
    'DDBBBBBB': ("DEFB 221", 1),
    'DDBCBCBC': ("CP IXh", 2),
    'DDBDBDBD': ("CP IXl", 2),
    'DDBEBEBE': ("CP (IX-66)", 3),
    'DDBFBFBF': ("DEFB 221", 1),
    'DDC0C0C0': ("DEFB 221", 1),
    'DDC1C1C1': ("DEFB 221", 1),
    'DDC2C2C2': ("DEFB 221", 1),
    'DDC3C3C3': ("DEFB 221", 1),
    'DDC4C4C4': ("DEFB 221", 1),
    'DDC5C5C5': ("DEFB 221", 1),
    'DDC6C6C6': ("DEFB 221", 1),
    'DDC7C7C7': ("DEFB 221", 1),
    'DDC8C8C8': ("DEFB 221", 1),
    'DDC9C9C9': ("DEFB 221", 1),
    'DDCACACA': ("DEFB 221", 1),
    'DDCCCCCC': ("DEFB 221", 1),
    'DDCDCDCD': ("DEFB 221", 1),
    'DDCECECE': ("DEFB 221", 1),
    'DDCFCFCF': ("DEFB 221", 1),
    'DDD0D0D0': ("DEFB 221", 1),
    'DDD1D1D1': ("DEFB 221", 1),
    'DDD2D2D2': ("DEFB 221", 1),
    'DDD3D3D3': ("DEFB 221", 1),
    'DDD4D4D4': ("DEFB 221", 1),
    'DDD5D5D5': ("DEFB 221", 1),
    'DDD6D6D6': ("DEFB 221", 1),
    'DDD7D7D7': ("DEFB 221", 1),
    'DDD8D8D8': ("DEFB 221", 1),
    'DDD9D9D9': ("DEFB 221", 1),
    'DDDADADA': ("DEFB 221", 1),
    'DDDBDBDB': ("DEFB 221", 1),
    'DDDCDCDC': ("DEFB 221", 1),
    'DDDDDDDD': ("DEFB 221", 1),
    'DDDEDEDE': ("DEFB 221", 1),
    'DDDFDFDF': ("DEFB 221", 1),
    'DDE0E0E0': ("DEFB 221", 1),
    'DDE1E1E1': ("POP IX", 2),
    'DDE2E2E2': ("DEFB 221", 1),
    'DDE3E3E3': ("EX (SP),IX", 2),
    'DDE4E4E4': ("DEFB 221", 1),
    'DDE5E5E5': ("PUSH IX", 2),
    'DDE6E6E6': ("DEFB 221", 1),
    'DDE7E7E7': ("DEFB 221", 1),
    'DDE8E8E8': ("DEFB 221", 1),
    'DDE9E9E9': ("JP (IX)", 2),
    'DDEAEAEA': ("DEFB 221", 1),
    'DDEBEBEB': ("DEFB 221", 1),
    'DDECECEC': ("DEFB 221", 1),
    'DDEDEDED': ("DEFB 221", 1),
    'DDEEEEEE': ("DEFB 221", 1),
    'DDEFEFEF': ("DEFB 221", 1),
    'DDF0F0F0': ("DEFB 221", 1),
    'DDF1F1F1': ("DEFB 221", 1),
    'DDF2F2F2': ("DEFB 221", 1),
    'DDF3F3F3': ("DEFB 221", 1),
    'DDF4F4F4': ("DEFB 221", 1),
    'DDF5F5F5': ("DEFB 221", 1),
    'DDF6F6F6': ("DEFB 221", 1),
    'DDF7F7F7': ("DEFB 221", 1),
    'DDF8F8F8': ("DEFB 221", 1),
    'DDF9F9F9': ("LD SP,IX", 2),
    'DDFAFAFA': ("DEFB 221", 1),
    'DDFBFBFB': ("DEFB 221", 1),
    'DDFCFCFC': ("DEFB 221", 1),
    'DDFDFDFD': ("DEFB 221", 1),
    'DDFEFEFE': ("DEFB 221", 1),
    'DDFFFFFF': ("DEFB 221", 1),
    'ED000000': ("DEFB 237,0", 2),
    'ED010101': ("DEFB 237,1", 2),
    'ED020202': ("DEFB 237,2", 2),
    'ED030303': ("DEFB 237,3", 2),
    'ED040404': ("DEFB 237,4", 2),
    'ED050505': ("DEFB 237,5", 2),
    'ED060606': ("DEFB 237,6", 2),
    'ED070707': ("DEFB 237,7", 2),
    'ED080808': ("DEFB 237,8", 2),
    'ED090909': ("DEFB 237,9", 2),
    'ED0A0A0A': ("DEFB 237,10", 2),
    'ED0B0B0B': ("DEFB 237,11", 2),
    'ED0C0C0C': ("DEFB 237,12", 2),
    'ED0D0D0D': ("DEFB 237,13", 2),
    'ED0E0E0E': ("DEFB 237,14", 2),
    'ED0F0F0F': ("DEFB 237,15", 2),
    'ED101010': ("DEFB 237,16", 2),
    'ED111111': ("DEFB 237,17", 2),
    'ED121212': ("DEFB 237,18", 2),
    'ED131313': ("DEFB 237,19", 2),
    'ED141414': ("DEFB 237,20", 2),
    'ED151515': ("DEFB 237,21", 2),
    'ED161616': ("DEFB 237,22", 2),
    'ED171717': ("DEFB 237,23", 2),
    'ED181818': ("DEFB 237,24", 2),
    'ED191919': ("DEFB 237,25", 2),
    'ED1A1A1A': ("DEFB 237,26", 2),
    'ED1B1B1B': ("DEFB 237,27", 2),
    'ED1C1C1C': ("DEFB 237,28", 2),
    'ED1D1D1D': ("DEFB 237,29", 2),
    'ED1E1E1E': ("DEFB 237,30", 2),
    'ED1F1F1F': ("DEFB 237,31", 2),
    'ED202020': ("DEFB 237,32", 2),
    'ED212121': ("DEFB 237,33", 2),
    'ED222222': ("DEFB 237,34", 2),
    'ED232323': ("DEFB 237,35", 2),
    'ED242424': ("DEFB 237,36", 2),
    'ED252525': ("DEFB 237,37", 2),
    'ED262626': ("DEFB 237,38", 2),
    'ED272727': ("DEFB 237,39", 2),
    'ED282828': ("DEFB 237,40", 2),
    'ED292929': ("DEFB 237,41", 2),
    'ED2A2A2A': ("DEFB 237,42", 2),
    'ED2B2B2B': ("DEFB 237,43", 2),
    'ED2C2C2C': ("DEFB 237,44", 2),
    'ED2D2D2D': ("DEFB 237,45", 2),
    'ED2E2E2E': ("DEFB 237,46", 2),
    'ED2F2F2F': ("DEFB 237,47", 2),
    'ED303030': ("DEFB 237,48", 2),
    'ED313131': ("DEFB 237,49", 2),
    'ED323232': ("DEFB 237,50", 2),
    'ED333333': ("DEFB 237,51", 2),
    'ED343434': ("DEFB 237,52", 2),
    'ED353535': ("DEFB 237,53", 2),
    'ED363636': ("DEFB 237,54", 2),
    'ED373737': ("DEFB 237,55", 2),
    'ED383838': ("DEFB 237,56", 2),
    'ED393939': ("DEFB 237,57", 2),
    'ED3A3A3A': ("DEFB 237,58", 2),
    'ED3B3B3B': ("DEFB 237,59", 2),
    'ED3C3C3C': ("DEFB 237,60", 2),
    'ED3D3D3D': ("DEFB 237,61", 2),
    'ED3E3E3E': ("DEFB 237,62", 2),
    'ED3F3F3F': ("DEFB 237,63", 2),
    'ED404040': ("IN B,(C)", 2),
    'ED414141': ("OUT (C),B", 2),
    'ED424242': ("SBC HL,BC", 2),
    'ED434343': ("LD (17219),BC", 4),
    'ED444444': ("NEG", 2),
    'ED454545': ("RETN", 2),
    'ED464646': ("IM 0", 2),
    'ED474747': ("LD I,A", 2),
    'ED484848': ("IN C,(C)", 2),
    'ED494949': ("OUT (C),C", 2),
    'ED4A4A4A': ("ADC HL,BC", 2),
    'ED4B4B4B': ("LD BC,(19275)", 4),
    'ED4C4C4C': ("NEG", 2),
    'ED4D4D4D': ("RETI", 2),
    'ED4E4E4E': ("IM 0", 2),
    'ED4F4F4F': ("LD R,A", 2),
    'ED505050': ("IN D,(C)", 2),
    'ED515151': ("OUT (C),D", 2),
    'ED525252': ("SBC HL,DE", 2),
    'ED535353': ("LD (21331),DE", 4),
    'ED545454': ("NEG", 2),
    'ED555555': ("RETN", 2),
    'ED565656': ("IM 1", 2),
    'ED575757': ("LD A,I", 2),
    'ED585858': ("IN E,(C)", 2),
    'ED595959': ("OUT (C),E", 2),
    'ED5A5A5A': ("ADC HL,DE", 2),
    'ED5B5B5B': ("LD DE,(23387)", 4),
    'ED5C5C5C': ("NEG", 2),
    'ED5D5D5D': ("RETN", 2),
    'ED5E5E5E': ("IM 2", 2),
    'ED5F5F5F': ("LD A,R", 2),
    'ED606060': ("IN H,(C)", 2),
    'ED616161': ("OUT (C),H", 2),
    'ED626262': ("SBC HL,HL", 2),
    'ED636363': ("LD (25443),HL", 4),
    'ED646464': ("NEG", 2),
    'ED656565': ("RETN", 2),
    'ED666666': ("IM 0", 2),
    'ED676767': ("RRD", 2),
    'ED686868': ("IN L,(C)", 2),
    'ED696969': ("OUT (C),L", 2),
    'ED6A6A6A': ("ADC HL,HL", 2),
    'ED6B6B6B': ("LD HL,(27499)", 4),
    'ED6C6C6C': ("NEG", 2),
    'ED6D6D6D': ("RETN", 2),
    'ED6E6E6E': ("IM 0", 2),
    'ED6F6F6F': ("RLD", 2),
    'ED707070': ("IN F,(C)", 2),
    'ED717171': ("OUT (C),0", 2),
    'ED727272': ("SBC HL,SP", 2),
    'ED737373': ("LD (29555),SP", 4),
    'ED747474': ("NEG", 2),
    'ED757575': ("RETN", 2),
    'ED767676': ("IM 1", 2),
    'ED777777': ("DEFB 237,119", 2),
    'ED787878': ("IN A,(C)", 2),
    'ED797979': ("OUT (C),A", 2),
    'ED7A7A7A': ("ADC HL,SP", 2),
    'ED7B7B7B': ("LD SP,(31611)", 4),
    'ED7C7C7C': ("NEG", 2),
    'ED7D7D7D': ("RETN", 2),
    'ED7E7E7E': ("IM 2", 2),
    'ED7F7F7F': ("DEFB 237,127", 2),
    'ED808080': ("DEFB 237,128", 2),
    'ED818181': ("DEFB 237,129", 2),
    'ED828282': ("DEFB 237,130", 2),
    'ED838383': ("DEFB 237,131", 2),
    'ED848484': ("DEFB 237,132", 2),
    'ED858585': ("DEFB 237,133", 2),
    'ED868686': ("DEFB 237,134", 2),
    'ED878787': ("DEFB 237,135", 2),
    'ED888888': ("DEFB 237,136", 2),
    'ED898989': ("DEFB 237,137", 2),
    'ED8A8A8A': ("DEFB 237,138", 2),
    'ED8B8B8B': ("DEFB 237,139", 2),
    'ED8C8C8C': ("DEFB 237,140", 2),
    'ED8D8D8D': ("DEFB 237,141", 2),
    'ED8E8E8E': ("DEFB 237,142", 2),
    'ED8F8F8F': ("DEFB 237,143", 2),
    'ED909090': ("DEFB 237,144", 2),
    'ED919191': ("DEFB 237,145", 2),
    'ED929292': ("DEFB 237,146", 2),
    'ED939393': ("DEFB 237,147", 2),
    'ED949494': ("DEFB 237,148", 2),
    'ED959595': ("DEFB 237,149", 2),
    'ED969696': ("DEFB 237,150", 2),
    'ED979797': ("DEFB 237,151", 2),
    'ED989898': ("DEFB 237,152", 2),
    'ED999999': ("DEFB 237,153", 2),
    'ED9A9A9A': ("DEFB 237,154", 2),
    'ED9B9B9B': ("DEFB 237,155", 2),
    'ED9C9C9C': ("DEFB 237,156", 2),
    'ED9D9D9D': ("DEFB 237,157", 2),
    'ED9E9E9E': ("DEFB 237,158", 2),
    'ED9F9F9F': ("DEFB 237,159", 2),
    'EDA0A0A0': ("LDI", 2),
    'EDA1A1A1': ("CPI", 2),
    'EDA2A2A2': ("INI", 2),
    'EDA3A3A3': ("OUTI", 2),
    'EDA4A4A4': ("DEFB 237,164", 2),
    'EDA5A5A5': ("DEFB 237,165", 2),
    'EDA6A6A6': ("DEFB 237,166", 2),
    'EDA7A7A7': ("DEFB 237,167", 2),
    'EDA8A8A8': ("LDD", 2),
    'EDA9A9A9': ("CPD", 2),
    'EDAAAAAA': ("IND", 2),
    'EDABABAB': ("OUTD", 2),
    'EDACACAC': ("DEFB 237,172", 2),
    'EDADADAD': ("DEFB 237,173", 2),
    'EDAEAEAE': ("DEFB 237,174", 2),
    'EDAFAFAF': ("DEFB 237,175", 2),
    'EDB0B0B0': ("LDIR", 2),
    'EDB1B1B1': ("CPIR", 2),
    'EDB2B2B2': ("INIR", 2),
    'EDB3B3B3': ("OTIR", 2),
    'EDB4B4B4': ("DEFB 237,180", 2),
    'EDB5B5B5': ("DEFB 237,181", 2),
    'EDB6B6B6': ("DEFB 237,182", 2),
    'EDB7B7B7': ("DEFB 237,183", 2),
    'EDB8B8B8': ("LDDR", 2),
    'EDB9B9B9': ("CPDR", 2),
    'EDBABABA': ("INDR", 2),
    'EDBBBBBB': ("OTDR", 2),
    'EDBCBCBC': ("DEFB 237,188", 2),
    'EDBDBDBD': ("DEFB 237,189", 2),
    'EDBEBEBE': ("DEFB 237,190", 2),
    'EDBFBFBF': ("DEFB 237,191", 2),
    'EDC0C0C0': ("DEFB 237,192", 2),
    'EDC1C1C1': ("DEFB 237,193", 2),
    'EDC2C2C2': ("DEFB 237,194", 2),
    'EDC3C3C3': ("DEFB 237,195", 2),
    'EDC4C4C4': ("DEFB 237,196", 2),
    'EDC5C5C5': ("DEFB 237,197", 2),
    'EDC6C6C6': ("DEFB 237,198", 2),
    'EDC7C7C7': ("DEFB 237,199", 2),
    'EDC8C8C8': ("DEFB 237,200", 2),
    'EDC9C9C9': ("DEFB 237,201", 2),
    'EDCACACA': ("DEFB 237,202", 2),
    'EDCBCBCB': ("DEFB 237,203", 2),
    'EDCCCCCC': ("DEFB 237,204", 2),
    'EDCDCDCD': ("DEFB 237,205", 2),
    'EDCECECE': ("DEFB 237,206", 2),
    'EDCFCFCF': ("DEFB 237,207", 2),
    'EDD0D0D0': ("DEFB 237,208", 2),
    'EDD1D1D1': ("DEFB 237,209", 2),
    'EDD2D2D2': ("DEFB 237,210", 2),
    'EDD3D3D3': ("DEFB 237,211", 2),
    'EDD4D4D4': ("DEFB 237,212", 2),
    'EDD5D5D5': ("DEFB 237,213", 2),
    'EDD6D6D6': ("DEFB 237,214", 2),
    'EDD7D7D7': ("DEFB 237,215", 2),
    'EDD8D8D8': ("DEFB 237,216", 2),
    'EDD9D9D9': ("DEFB 237,217", 2),
    'EDDADADA': ("DEFB 237,218", 2),
    'EDDBDBDB': ("DEFB 237,219", 2),
    'EDDCDCDC': ("DEFB 237,220", 2),
    'EDDDDDDD': ("DEFB 237,221", 2),
    'EDDEDEDE': ("DEFB 237,222", 2),
    'EDDFDFDF': ("DEFB 237,223", 2),
    'EDE0E0E0': ("DEFB 237,224", 2),
    'EDE1E1E1': ("DEFB 237,225", 2),
    'EDE2E2E2': ("DEFB 237,226", 2),
    'EDE3E3E3': ("DEFB 237,227", 2),
    'EDE4E4E4': ("DEFB 237,228", 2),
    'EDE5E5E5': ("DEFB 237,229", 2),
    'EDE6E6E6': ("DEFB 237,230", 2),
    'EDE7E7E7': ("DEFB 237,231", 2),
    'EDE8E8E8': ("DEFB 237,232", 2),
    'EDE9E9E9': ("DEFB 237,233", 2),
    'EDEAEAEA': ("DEFB 237,234", 2),
    'EDEBEBEB': ("DEFB 237,235", 2),
    'EDECECEC': ("DEFB 237,236", 2),
    'EDEDEDED': ("DEFB 237,237", 2),
    'EDEEEEEE': ("DEFB 237,238", 2),
    'EDEFEFEF': ("DEFB 237,239", 2),
    'EDF0F0F0': ("DEFB 237,240", 2),
    'EDF1F1F1': ("DEFB 237,241", 2),
    'EDF2F2F2': ("DEFB 237,242", 2),
    'EDF3F3F3': ("DEFB 237,243", 2),
    'EDF4F4F4': ("DEFB 237,244", 2),
    'EDF5F5F5': ("DEFB 237,245", 2),
    'EDF6F6F6': ("DEFB 237,246", 2),
    'EDF7F7F7': ("DEFB 237,247", 2),
    'EDF8F8F8': ("DEFB 237,248", 2),
    'EDF9F9F9': ("DEFB 237,249", 2),
    'EDFAFAFA': ("DEFB 237,250", 2),
    'EDFBFBFB': ("DEFB 237,251", 2),
    'EDFCFCFC': ("DEFB 237,252", 2),
    'EDFDFDFD': ("DEFB 237,253", 2),
    'EDFEFEFE': ("DEFB 237,254", 2),
    'EDFFFFFF': ("DEFB 237,255", 2),
    'FD000000': ("DEFB 253", 1),
    'FD010101': ("DEFB 253", 1),
    'FD020202': ("DEFB 253", 1),
    'FD030303': ("DEFB 253", 1),
    'FD040404': ("DEFB 253", 1),
    'FD050505': ("DEFB 253", 1),
    'FD060606': ("DEFB 253", 1),
    'FD070707': ("DEFB 253", 1),
    'FD080808': ("DEFB 253", 1),
    'FD090909': ("ADD IY,BC", 2),
    'FD0A0A0A': ("DEFB 253", 1),
    'FD0B0B0B': ("DEFB 253", 1),
    'FD0C0C0C': ("DEFB 253", 1),
    'FD0D0D0D': ("DEFB 253", 1),
    'FD0E0E0E': ("DEFB 253", 1),
    'FD0F0F0F': ("DEFB 253", 1),
    'FD101010': ("DEFB 253", 1),
    'FD111111': ("DEFB 253", 1),
    'FD121212': ("DEFB 253", 1),
    'FD131313': ("DEFB 253", 1),
    'FD141414': ("DEFB 253", 1),
    'FD151515': ("DEFB 253", 1),
    'FD161616': ("DEFB 253", 1),
    'FD171717': ("DEFB 253", 1),
    'FD181818': ("DEFB 253", 1),
    'FD191919': ("ADD IY,DE", 2),
    'FD1A1A1A': ("DEFB 253", 1),
    'FD1B1B1B': ("DEFB 253", 1),
    'FD1C1C1C': ("DEFB 253", 1),
    'FD1D1D1D': ("DEFB 253", 1),
    'FD1E1E1E': ("DEFB 253", 1),
    'FD1F1F1F': ("DEFB 253", 1),
    'FD202020': ("DEFB 253", 1),
    'FD212121': ("LD IY,8481", 4),
    'FD222222': ("LD (8738),IY", 4),
    'FD232323': ("INC IY", 2),
    'FD242424': ("INC IYh", 2),
    'FD252525': ("DEC IYh", 2),
    'FD262626': ("LD IYh,38", 3),
    'FD272727': ("DEFB 253", 1),
    'FD282828': ("DEFB 253", 1),
    'FD292929': ("ADD IY,IY", 2),
    'FD2A2A2A': ("LD IY,(10794)", 4),
    'FD2B2B2B': ("DEC IY", 2),
    'FD2C2C2C': ("INC IYl", 2),
    'FD2D2D2D': ("DEC IYl", 2),
    'FD2E2E2E': ("LD IYl,46", 3),
    'FD2F2F2F': ("DEFB 253", 1),
    'FD303030': ("DEFB 253", 1),
    'FD313131': ("DEFB 253", 1),
    'FD323232': ("DEFB 253", 1),
    'FD333333': ("DEFB 253", 1),
    'FD343434': ("INC (IY+52)", 3),
    'FD353535': ("DEC (IY+53)", 3),
    'FD363636': ("LD (IY+54),54", 4),
    'FD373737': ("DEFB 253", 1),
    'FD383838': ("DEFB 253", 1),
    'FD393939': ("ADD IY,SP", 2),
    'FD3A3A3A': ("DEFB 253", 1),
    'FD3B3B3B': ("DEFB 253", 1),
    'FD3C3C3C': ("DEFB 253", 1),
    'FD3D3D3D': ("DEFB 253", 1),
    'FD3E3E3E': ("DEFB 253", 1),
    'FD3F3F3F': ("DEFB 253", 1),
    'FD404040': ("DEFB 253", 1),
    'FD414141': ("DEFB 253", 1),
    'FD424242': ("DEFB 253", 1),
    'FD434343': ("DEFB 253", 1),
    'FD444444': ("LD B,IYh", 2),
    'FD454545': ("LD B,IYl", 2),
    'FD464646': ("LD B,(IY+70)", 3),
    'FD474747': ("DEFB 253", 1),
    'FD484848': ("DEFB 253", 1),
    'FD494949': ("DEFB 253", 1),
    'FD4A4A4A': ("DEFB 253", 1),
    'FD4B4B4B': ("DEFB 253", 1),
    'FD4C4C4C': ("LD C,IYh", 2),
    'FD4D4D4D': ("LD C,IYl", 2),
    'FD4E4E4E': ("LD C,(IY+78)", 3),
    'FD4F4F4F': ("DEFB 253", 1),
    'FD505050': ("DEFB 253", 1),
    'FD515151': ("DEFB 253", 1),
    'FD525252': ("DEFB 253", 1),
    'FD535353': ("DEFB 253", 1),
    'FD545454': ("LD D,IYh", 2),
    'FD555555': ("LD D,IYl", 2),
    'FD565656': ("LD D,(IY+86)", 3),
    'FD575757': ("DEFB 253", 1),
    'FD585858': ("DEFB 253", 1),
    'FD595959': ("DEFB 253", 1),
    'FD5A5A5A': ("DEFB 253", 1),
    'FD5B5B5B': ("DEFB 253", 1),
    'FD5C5C5C': ("LD E,IYh", 2),
    'FD5D5D5D': ("LD E,IYl", 2),
    'FD5E5E5E': ("LD E,(IY+94)", 3),
    'FD5F5F5F': ("DEFB 253", 1),
    'FD606060': ("LD IYh,B", 2),
    'FD616161': ("LD IYh,C", 2),
    'FD626262': ("LD IYh,D", 2),
    'FD636363': ("LD IYh,E", 2),
    'FD646464': ("LD IYh,IYh", 2),
    'FD656565': ("LD IYh,IYl", 2),
    'FD666666': ("LD H,(IY+102)", 3),
    'FD676767': ("LD IYh,A", 2),
    'FD686868': ("LD IYl,B", 2),
    'FD696969': ("LD IYl,C", 2),
    'FD6A6A6A': ("LD IYl,D", 2),
    'FD6B6B6B': ("LD IYl,E", 2),
    'FD6C6C6C': ("LD IYl,IYh", 2),
    'FD6D6D6D': ("LD IYl,IYl", 2),
    'FD6E6E6E': ("LD L,(IY+110)", 3),
    'FD6F6F6F': ("LD IYl,A", 2),
    'FD707070': ("LD (IY+112),B", 3),
    'FD717171': ("LD (IY+113),C", 3),
    'FD727272': ("LD (IY+114),D", 3),
    'FD737373': ("LD (IY+115),E", 3),
    'FD747474': ("LD (IY+116),H", 3),
    'FD757575': ("LD (IY+117),L", 3),
    'FD767676': ("DEFB 253", 1),
    'FD777777': ("LD (IY+119),A", 3),
    'FD787878': ("DEFB 253", 1),
    'FD797979': ("DEFB 253", 1),
    'FD7A7A7A': ("DEFB 253", 1),
    'FD7B7B7B': ("DEFB 253", 1),
    'FD7C7C7C': ("LD A,IYh", 2),
    'FD7D7D7D': ("LD A,IYl", 2),
    'FD7E7E7E': ("LD A,(IY+126)", 3),
    'FD7F7F7F': ("DEFB 253", 1),
    'FD808080': ("DEFB 253", 1),
    'FD818181': ("DEFB 253", 1),
    'FD828282': ("DEFB 253", 1),
    'FD838383': ("DEFB 253", 1),
    'FD848484': ("ADD A,IYh", 2),
    'FD858585': ("ADD A,IYl", 2),
    'FD868686': ("ADD A,(IY-122)", 3),
    'FD878787': ("DEFB 253", 1),
    'FD888888': ("DEFB 253", 1),
    'FD898989': ("DEFB 253", 1),
    'FD8A8A8A': ("DEFB 253", 1),
    'FD8B8B8B': ("DEFB 253", 1),
    'FD8C8C8C': ("ADC A,IYh", 2),
    'FD8D8D8D': ("ADC A,IYl", 2),
    'FD8E8E8E': ("ADC A,(IY-114)", 3),
    'FD8F8F8F': ("DEFB 253", 1),
    'FD909090': ("DEFB 253", 1),
    'FD919191': ("DEFB 253", 1),
    'FD929292': ("DEFB 253", 1),
    'FD939393': ("DEFB 253", 1),
    'FD949494': ("SUB IYh", 2),
    'FD959595': ("SUB IYl", 2),
    'FD969696': ("SUB (IY-106)", 3),
    'FD979797': ("DEFB 253", 1),
    'FD989898': ("DEFB 253", 1),
    'FD999999': ("DEFB 253", 1),
    'FD9A9A9A': ("DEFB 253", 1),
    'FD9B9B9B': ("DEFB 253", 1),
    'FD9C9C9C': ("SBC A,IYh", 2),
    'FD9D9D9D': ("SBC A,IYl", 2),
    'FD9E9E9E': ("SBC A,(IY-98)", 3),
    'FD9F9F9F': ("DEFB 253", 1),
    'FDA0A0A0': ("DEFB 253", 1),
    'FDA1A1A1': ("DEFB 253", 1),
    'FDA2A2A2': ("DEFB 253", 1),
    'FDA3A3A3': ("DEFB 253", 1),
    'FDA4A4A4': ("AND IYh", 2),
    'FDA5A5A5': ("AND IYl", 2),
    'FDA6A6A6': ("AND (IY-90)", 3),
    'FDA7A7A7': ("DEFB 253", 1),
    'FDA8A8A8': ("DEFB 253", 1),
    'FDA9A9A9': ("DEFB 253", 1),
    'FDAAAAAA': ("DEFB 253", 1),
    'FDABABAB': ("DEFB 253", 1),
    'FDACACAC': ("XOR IYh", 2),
    'FDADADAD': ("XOR IYl", 2),
    'FDAEAEAE': ("XOR (IY-82)", 3),
    'FDAFAFAF': ("DEFB 253", 1),
    'FDB0B0B0': ("DEFB 253", 1),
    'FDB1B1B1': ("DEFB 253", 1),
    'FDB2B2B2': ("DEFB 253", 1),
    'FDB3B3B3': ("DEFB 253", 1),
    'FDB4B4B4': ("OR IYh", 2),
    'FDB5B5B5': ("OR IYl", 2),
    'FDB6B6B6': ("OR (IY-74)", 3),
    'FDB7B7B7': ("DEFB 253", 1),
    'FDB8B8B8': ("DEFB 253", 1),
    'FDB9B9B9': ("DEFB 253", 1),
    'FDBABABA': ("DEFB 253", 1),
    'FDBBBBBB': ("DEFB 253", 1),
    'FDBCBCBC': ("CP IYh", 2),
    'FDBDBDBD': ("CP IYl", 2),
    'FDBEBEBE': ("CP (IY-66)", 3),
    'FDBFBFBF': ("DEFB 253", 1),
    'FDC0C0C0': ("DEFB 253", 1),
    'FDC1C1C1': ("DEFB 253", 1),
    'FDC2C2C2': ("DEFB 253", 1),
    'FDC3C3C3': ("DEFB 253", 1),
    'FDC4C4C4': ("DEFB 253", 1),
    'FDC5C5C5': ("DEFB 253", 1),
    'FDC6C6C6': ("DEFB 253", 1),
    'FDC7C7C7': ("DEFB 253", 1),
    'FDC8C8C8': ("DEFB 253", 1),
    'FDC9C9C9': ("DEFB 253", 1),
    'FDCACACA': ("DEFB 253", 1),
    'FDCCCCCC': ("DEFB 253", 1),
    'FDCDCDCD': ("DEFB 253", 1),
    'FDCECECE': ("DEFB 253", 1),
    'FDCFCFCF': ("DEFB 253", 1),
    'FDD0D0D0': ("DEFB 253", 1),
    'FDD1D1D1': ("DEFB 253", 1),
    'FDD2D2D2': ("DEFB 253", 1),
    'FDD3D3D3': ("DEFB 253", 1),
    'FDD4D4D4': ("DEFB 253", 1),
    'FDD5D5D5': ("DEFB 253", 1),
    'FDD6D6D6': ("DEFB 253", 1),
    'FDD7D7D7': ("DEFB 253", 1),
    'FDD8D8D8': ("DEFB 253", 1),
    'FDD9D9D9': ("DEFB 253", 1),
    'FDDADADA': ("DEFB 253", 1),
    'FDDBDBDB': ("DEFB 253", 1),
    'FDDCDCDC': ("DEFB 253", 1),
    'FDDDDDDD': ("DEFB 253", 1),
    'FDDEDEDE': ("DEFB 253", 1),
    'FDDFDFDF': ("DEFB 253", 1),
    'FDE0E0E0': ("DEFB 253", 1),
    'FDE1E1E1': ("POP IY", 2),
    'FDE2E2E2': ("DEFB 253", 1),
    'FDE3E3E3': ("EX (SP),IY", 2),
    'FDE4E4E4': ("DEFB 253", 1),
    'FDE5E5E5': ("PUSH IY", 2),
    'FDE6E6E6': ("DEFB 253", 1),
    'FDE7E7E7': ("DEFB 253", 1),
    'FDE8E8E8': ("DEFB 253", 1),
    'FDE9E9E9': ("JP (IY)", 2),
    'FDEAEAEA': ("DEFB 253", 1),
    'FDEBEBEB': ("DEFB 253", 1),
    'FDECECEC': ("DEFB 253", 1),
    'FDEDEDED': ("DEFB 253", 1),
    'FDEEEEEE': ("DEFB 253", 1),
    'FDEFEFEF': ("DEFB 253", 1),
    'FDF0F0F0': ("DEFB 253", 1),
    'FDF1F1F1': ("DEFB 253", 1),
    'FDF2F2F2': ("DEFB 253", 1),
    'FDF3F3F3': ("DEFB 253", 1),
    'FDF4F4F4': ("DEFB 253", 1),
    'FDF5F5F5': ("DEFB 253", 1),
    'FDF6F6F6': ("DEFB 253", 1),
    'FDF7F7F7': ("DEFB 253", 1),
    'FDF8F8F8': ("DEFB 253", 1),
    'FDF9F9F9': ("LD SP,IY", 2),
    'FDFAFAFA': ("DEFB 253", 1),
    'FDFBFBFB': ("DEFB 253", 1),
    'FDFCFCFC': ("DEFB 253", 1),
    'FDFDFDFD': ("DEFB 253", 1),
    'FDFEFEFE': ("DEFB 253", 1),
    'FDFFFFFF': ("DEFB 253", 1),
    'DDCB0000': ("RLC (IX+0),B", 4),
    'DDCB0101': ("RLC (IX+1),C", 4),
    'DDCB0202': ("RLC (IX+2),D", 4),
    'DDCB0303': ("RLC (IX+3),E", 4),
    'DDCB0404': ("RLC (IX+4),H", 4),
    'DDCB0505': ("RLC (IX+5),L", 4),
    'DDCB0606': ("RLC (IX+6)", 4),
    'DDCB0707': ("RLC (IX+7),A", 4),
    'DDCB0808': ("RRC (IX+8),B", 4),
    'DDCB0909': ("RRC (IX+9),C", 4),
    'DDCB0A0A': ("RRC (IX+10),D", 4),
    'DDCB0B0B': ("RRC (IX+11),E", 4),
    'DDCB0C0C': ("RRC (IX+12),H", 4),
    'DDCB0D0D': ("RRC (IX+13),L", 4),
    'DDCB0E0E': ("RRC (IX+14)", 4),
    'DDCB0F0F': ("RRC (IX+15),A", 4),
    'DDCB1010': ("RL (IX+16),B", 4),
    'DDCB1111': ("RL (IX+17),C", 4),
    'DDCB1212': ("RL (IX+18),D", 4),
    'DDCB1313': ("RL (IX+19),E", 4),
    'DDCB1414': ("RL (IX+20),H", 4),
    'DDCB1515': ("RL (IX+21),L", 4),
    'DDCB1616': ("RL (IX+22)", 4),
    'DDCB1717': ("RL (IX+23),A", 4),
    'DDCB1818': ("RR (IX+24),B", 4),
    'DDCB1919': ("RR (IX+25),C", 4),
    'DDCB1A1A': ("RR (IX+26),D", 4),
    'DDCB1B1B': ("RR (IX+27),E", 4),
    'DDCB1C1C': ("RR (IX+28),H", 4),
    'DDCB1D1D': ("RR (IX+29),L", 4),
    'DDCB1E1E': ("RR (IX+30)", 4),
    'DDCB1F1F': ("RR (IX+31),A", 4),
    'DDCB2020': ("SLA (IX+32),B", 4),
    'DDCB2121': ("SLA (IX+33),C", 4),
    'DDCB2222': ("SLA (IX+34),D", 4),
    'DDCB2323': ("SLA (IX+35),E", 4),
    'DDCB2424': ("SLA (IX+36),H", 4),
    'DDCB2525': ("SLA (IX+37),L", 4),
    'DDCB2626': ("SLA (IX+38)", 4),
    'DDCB2727': ("SLA (IX+39),A", 4),
    'DDCB2828': ("SRA (IX+40),B", 4),
    'DDCB2929': ("SRA (IX+41),C", 4),
    'DDCB2A2A': ("SRA (IX+42),D", 4),
    'DDCB2B2B': ("SRA (IX+43),E", 4),
    'DDCB2C2C': ("SRA (IX+44),H", 4),
    'DDCB2D2D': ("SRA (IX+45),L", 4),
    'DDCB2E2E': ("SRA (IX+46)", 4),
    'DDCB2F2F': ("SRA (IX+47),A", 4),
    'DDCB3030': ("SLL (IX+48),B", 4),
    'DDCB3131': ("SLL (IX+49),C", 4),
    'DDCB3232': ("SLL (IX+50),D", 4),
    'DDCB3333': ("SLL (IX+51),E", 4),
    'DDCB3434': ("SLL (IX+52),H", 4),
    'DDCB3535': ("SLL (IX+53),L", 4),
    'DDCB3636': ("SLL (IX+54)", 4),
    'DDCB3737': ("SLL (IX+55),A", 4),
    'DDCB3838': ("SRL (IX+56),B", 4),
    'DDCB3939': ("SRL (IX+57),C", 4),
    'DDCB3A3A': ("SRL (IX+58),D", 4),
    'DDCB3B3B': ("SRL (IX+59),E", 4),
    'DDCB3C3C': ("SRL (IX+60),H", 4),
    'DDCB3D3D': ("SRL (IX+61),L", 4),
    'DDCB3E3E': ("SRL (IX+62)", 4),
    'DDCB3F3F': ("SRL (IX+63),A", 4),
    'DDCB4040': ("BIT 0,(IX+64)", 4),
    'DDCB4141': ("BIT 0,(IX+65)", 4),
    'DDCB4242': ("BIT 0,(IX+66)", 4),
    'DDCB4343': ("BIT 0,(IX+67)", 4),
    'DDCB4444': ("BIT 0,(IX+68)", 4),
    'DDCB4545': ("BIT 0,(IX+69)", 4),
    'DDCB4646': ("BIT 0,(IX+70)", 4),
    'DDCB4747': ("BIT 0,(IX+71)", 4),
    'DDCB4848': ("BIT 1,(IX+72)", 4),
    'DDCB4949': ("BIT 1,(IX+73)", 4),
    'DDCB4A4A': ("BIT 1,(IX+74)", 4),
    'DDCB4B4B': ("BIT 1,(IX+75)", 4),
    'DDCB4C4C': ("BIT 1,(IX+76)", 4),
    'DDCB4D4D': ("BIT 1,(IX+77)", 4),
    'DDCB4E4E': ("BIT 1,(IX+78)", 4),
    'DDCB4F4F': ("BIT 1,(IX+79)", 4),
    'DDCB5050': ("BIT 2,(IX+80)", 4),
    'DDCB5151': ("BIT 2,(IX+81)", 4),
    'DDCB5252': ("BIT 2,(IX+82)", 4),
    'DDCB5353': ("BIT 2,(IX+83)", 4),
    'DDCB5454': ("BIT 2,(IX+84)", 4),
    'DDCB5555': ("BIT 2,(IX+85)", 4),
    'DDCB5656': ("BIT 2,(IX+86)", 4),
    'DDCB5757': ("BIT 2,(IX+87)", 4),
    'DDCB5858': ("BIT 3,(IX+88)", 4),
    'DDCB5959': ("BIT 3,(IX+89)", 4),
    'DDCB5A5A': ("BIT 3,(IX+90)", 4),
    'DDCB5B5B': ("BIT 3,(IX+91)", 4),
    'DDCB5C5C': ("BIT 3,(IX+92)", 4),
    'DDCB5D5D': ("BIT 3,(IX+93)", 4),
    'DDCB5E5E': ("BIT 3,(IX+94)", 4),
    'DDCB5F5F': ("BIT 3,(IX+95)", 4),
    'DDCB6060': ("BIT 4,(IX+96)", 4),
    'DDCB6161': ("BIT 4,(IX+97)", 4),
    'DDCB6262': ("BIT 4,(IX+98)", 4),
    'DDCB6363': ("BIT 4,(IX+99)", 4),
    'DDCB6464': ("BIT 4,(IX+100)", 4),
    'DDCB6565': ("BIT 4,(IX+101)", 4),
    'DDCB6666': ("BIT 4,(IX+102)", 4),
    'DDCB6767': ("BIT 4,(IX+103)", 4),
    'DDCB6868': ("BIT 5,(IX+104)", 4),
    'DDCB6969': ("BIT 5,(IX+105)", 4),
    'DDCB6A6A': ("BIT 5,(IX+106)", 4),
    'DDCB6B6B': ("BIT 5,(IX+107)", 4),
    'DDCB6C6C': ("BIT 5,(IX+108)", 4),
    'DDCB6D6D': ("BIT 5,(IX+109)", 4),
    'DDCB6E6E': ("BIT 5,(IX+110)", 4),
    'DDCB6F6F': ("BIT 5,(IX+111)", 4),
    'DDCB7070': ("BIT 6,(IX+112)", 4),
    'DDCB7171': ("BIT 6,(IX+113)", 4),
    'DDCB7272': ("BIT 6,(IX+114)", 4),
    'DDCB7373': ("BIT 6,(IX+115)", 4),
    'DDCB7474': ("BIT 6,(IX+116)", 4),
    'DDCB7575': ("BIT 6,(IX+117)", 4),
    'DDCB7676': ("BIT 6,(IX+118)", 4),
    'DDCB7777': ("BIT 6,(IX+119)", 4),
    'DDCB7878': ("BIT 7,(IX+120)", 4),
    'DDCB7979': ("BIT 7,(IX+121)", 4),
    'DDCB7A7A': ("BIT 7,(IX+122)", 4),
    'DDCB7B7B': ("BIT 7,(IX+123)", 4),
    'DDCB7C7C': ("BIT 7,(IX+124)", 4),
    'DDCB7D7D': ("BIT 7,(IX+125)", 4),
    'DDCB7E7E': ("BIT 7,(IX+126)", 4),
    'DDCB7F7F': ("BIT 7,(IX+127)", 4),
    'DDCB8080': ("RES 0,(IX-128),B", 4),
    'DDCB8181': ("RES 0,(IX-127),C", 4),
    'DDCB8282': ("RES 0,(IX-126),D", 4),
    'DDCB8383': ("RES 0,(IX-125),E", 4),
    'DDCB8484': ("RES 0,(IX-124),H", 4),
    'DDCB8585': ("RES 0,(IX-123),L", 4),
    'DDCB8686': ("RES 0,(IX-122)", 4),
    'DDCB8787': ("RES 0,(IX-121),A", 4),
    'DDCB8888': ("RES 1,(IX-120),B", 4),
    'DDCB8989': ("RES 1,(IX-119),C", 4),
    'DDCB8A8A': ("RES 1,(IX-118),D", 4),
    'DDCB8B8B': ("RES 1,(IX-117),E", 4),
    'DDCB8C8C': ("RES 1,(IX-116),H", 4),
    'DDCB8D8D': ("RES 1,(IX-115),L", 4),
    'DDCB8E8E': ("RES 1,(IX-114)", 4),
    'DDCB8F8F': ("RES 1,(IX-113),A", 4),
    'DDCB9090': ("RES 2,(IX-112),B", 4),
    'DDCB9191': ("RES 2,(IX-111),C", 4),
    'DDCB9292': ("RES 2,(IX-110),D", 4),
    'DDCB9393': ("RES 2,(IX-109),E", 4),
    'DDCB9494': ("RES 2,(IX-108),H", 4),
    'DDCB9595': ("RES 2,(IX-107),L", 4),
    'DDCB9696': ("RES 2,(IX-106)", 4),
    'DDCB9797': ("RES 2,(IX-105),A", 4),
    'DDCB9898': ("RES 3,(IX-104),B", 4),
    'DDCB9999': ("RES 3,(IX-103),C", 4),
    'DDCB9A9A': ("RES 3,(IX-102),D", 4),
    'DDCB9B9B': ("RES 3,(IX-101),E", 4),
    'DDCB9C9C': ("RES 3,(IX-100),H", 4),
    'DDCB9D9D': ("RES 3,(IX-99),L", 4),
    'DDCB9E9E': ("RES 3,(IX-98)", 4),
    'DDCB9F9F': ("RES 3,(IX-97),A", 4),
    'DDCBA0A0': ("RES 4,(IX-96),B", 4),
    'DDCBA1A1': ("RES 4,(IX-95),C", 4),
    'DDCBA2A2': ("RES 4,(IX-94),D", 4),
    'DDCBA3A3': ("RES 4,(IX-93),E", 4),
    'DDCBA4A4': ("RES 4,(IX-92),H", 4),
    'DDCBA5A5': ("RES 4,(IX-91),L", 4),
    'DDCBA6A6': ("RES 4,(IX-90)", 4),
    'DDCBA7A7': ("RES 4,(IX-89),A", 4),
    'DDCBA8A8': ("RES 5,(IX-88),B", 4),
    'DDCBA9A9': ("RES 5,(IX-87),C", 4),
    'DDCBAAAA': ("RES 5,(IX-86),D", 4),
    'DDCBABAB': ("RES 5,(IX-85),E", 4),
    'DDCBACAC': ("RES 5,(IX-84),H", 4),
    'DDCBADAD': ("RES 5,(IX-83),L", 4),
    'DDCBAEAE': ("RES 5,(IX-82)", 4),
    'DDCBAFAF': ("RES 5,(IX-81),A", 4),
    'DDCBB0B0': ("RES 6,(IX-80),B", 4),
    'DDCBB1B1': ("RES 6,(IX-79),C", 4),
    'DDCBB2B2': ("RES 6,(IX-78),D", 4),
    'DDCBB3B3': ("RES 6,(IX-77),E", 4),
    'DDCBB4B4': ("RES 6,(IX-76),H", 4),
    'DDCBB5B5': ("RES 6,(IX-75),L", 4),
    'DDCBB6B6': ("RES 6,(IX-74)", 4),
    'DDCBB7B7': ("RES 6,(IX-73),A", 4),
    'DDCBB8B8': ("RES 7,(IX-72),B", 4),
    'DDCBB9B9': ("RES 7,(IX-71),C", 4),
    'DDCBBABA': ("RES 7,(IX-70),D", 4),
    'DDCBBBBB': ("RES 7,(IX-69),E", 4),
    'DDCBBCBC': ("RES 7,(IX-68),H", 4),
    'DDCBBDBD': ("RES 7,(IX-67),L", 4),
    'DDCBBEBE': ("RES 7,(IX-66)", 4),
    'DDCBBFBF': ("RES 7,(IX-65),A", 4),
    'DDCBC0C0': ("SET 0,(IX-64),B", 4),
    'DDCBC1C1': ("SET 0,(IX-63),C", 4),
    'DDCBC2C2': ("SET 0,(IX-62),D", 4),
    'DDCBC3C3': ("SET 0,(IX-61),E", 4),
    'DDCBC4C4': ("SET 0,(IX-60),H", 4),
    'DDCBC5C5': ("SET 0,(IX-59),L", 4),
    'DDCBC6C6': ("SET 0,(IX-58)", 4),
    'DDCBC7C7': ("SET 0,(IX-57),A", 4),
    'DDCBC8C8': ("SET 1,(IX-56),B", 4),
    'DDCBC9C9': ("SET 1,(IX-55),C", 4),
    'DDCBCACA': ("SET 1,(IX-54),D", 4),
    'DDCBCBCB': ("SET 1,(IX-53),E", 4),
    'DDCBCCCC': ("SET 1,(IX-52),H", 4),
    'DDCBCDCD': ("SET 1,(IX-51),L", 4),
    'DDCBCECE': ("SET 1,(IX-50)", 4),
    'DDCBCFCF': ("SET 1,(IX-49),A", 4),
    'DDCBD0D0': ("SET 2,(IX-48),B", 4),
    'DDCBD1D1': ("SET 2,(IX-47),C", 4),
    'DDCBD2D2': ("SET 2,(IX-46),D", 4),
    'DDCBD3D3': ("SET 2,(IX-45),E", 4),
    'DDCBD4D4': ("SET 2,(IX-44),H", 4),
    'DDCBD5D5': ("SET 2,(IX-43),L", 4),
    'DDCBD6D6': ("SET 2,(IX-42)", 4),
    'DDCBD7D7': ("SET 2,(IX-41),A", 4),
    'DDCBD8D8': ("SET 3,(IX-40),B", 4),
    'DDCBD9D9': ("SET 3,(IX-39),C", 4),
    'DDCBDADA': ("SET 3,(IX-38),D", 4),
    'DDCBDBDB': ("SET 3,(IX-37),E", 4),
    'DDCBDCDC': ("SET 3,(IX-36),H", 4),
    'DDCBDDDD': ("SET 3,(IX-35),L", 4),
    'DDCBDEDE': ("SET 3,(IX-34)", 4),
    'DDCBDFDF': ("SET 3,(IX-33),A", 4),
    'DDCBE0E0': ("SET 4,(IX-32),B", 4),
    'DDCBE1E1': ("SET 4,(IX-31),C", 4),
    'DDCBE2E2': ("SET 4,(IX-30),D", 4),
    'DDCBE3E3': ("SET 4,(IX-29),E", 4),
    'DDCBE4E4': ("SET 4,(IX-28),H", 4),
    'DDCBE5E5': ("SET 4,(IX-27),L", 4),
    'DDCBE6E6': ("SET 4,(IX-26)", 4),
    'DDCBE7E7': ("SET 4,(IX-25),A", 4),
    'DDCBE8E8': ("SET 5,(IX-24),B", 4),
    'DDCBE9E9': ("SET 5,(IX-23),C", 4),
    'DDCBEAEA': ("SET 5,(IX-22),D", 4),
    'DDCBEBEB': ("SET 5,(IX-21),E", 4),
    'DDCBECEC': ("SET 5,(IX-20),H", 4),
    'DDCBEDED': ("SET 5,(IX-19),L", 4),
    'DDCBEEEE': ("SET 5,(IX-18)", 4),
    'DDCBEFEF': ("SET 5,(IX-17),A", 4),
    'DDCBF0F0': ("SET 6,(IX-16),B", 4),
    'DDCBF1F1': ("SET 6,(IX-15),C", 4),
    'DDCBF2F2': ("SET 6,(IX-14),D", 4),
    'DDCBF3F3': ("SET 6,(IX-13),E", 4),
    'DDCBF4F4': ("SET 6,(IX-12),H", 4),
    'DDCBF5F5': ("SET 6,(IX-11),L", 4),
    'DDCBF6F6': ("SET 6,(IX-10)", 4),
    'DDCBF7F7': ("SET 6,(IX-9),A", 4),
    'DDCBF8F8': ("SET 7,(IX-8),B", 4),
    'DDCBF9F9': ("SET 7,(IX-7),C", 4),
    'DDCBFAFA': ("SET 7,(IX-6),D", 4),
    'DDCBFBFB': ("SET 7,(IX-5),E", 4),
    'DDCBFCFC': ("SET 7,(IX-4),H", 4),
    'DDCBFDFD': ("SET 7,(IX-3),L", 4),
    'DDCBFEFE': ("SET 7,(IX-2)", 4),
    'DDCBFFFF': ("SET 7,(IX-1),A", 4),
    'FDCB0000': ("RLC (IY+0),B", 4),
    'FDCB0101': ("RLC (IY+1),C", 4),
    'FDCB0202': ("RLC (IY+2),D", 4),
    'FDCB0303': ("RLC (IY+3),E", 4),
    'FDCB0404': ("RLC (IY+4),H", 4),
    'FDCB0505': ("RLC (IY+5),L", 4),
    'FDCB0606': ("RLC (IY+6)", 4),
    'FDCB0707': ("RLC (IY+7),A", 4),
    'FDCB0808': ("RRC (IY+8),B", 4),
    'FDCB0909': ("RRC (IY+9),C", 4),
    'FDCB0A0A': ("RRC (IY+10),D", 4),
    'FDCB0B0B': ("RRC (IY+11),E", 4),
    'FDCB0C0C': ("RRC (IY+12),H", 4),
    'FDCB0D0D': ("RRC (IY+13),L", 4),
    'FDCB0E0E': ("RRC (IY+14)", 4),
    'FDCB0F0F': ("RRC (IY+15),A", 4),
    'FDCB1010': ("RL (IY+16),B", 4),
    'FDCB1111': ("RL (IY+17),C", 4),
    'FDCB1212': ("RL (IY+18),D", 4),
    'FDCB1313': ("RL (IY+19),E", 4),
    'FDCB1414': ("RL (IY+20),H", 4),
    'FDCB1515': ("RL (IY+21),L", 4),
    'FDCB1616': ("RL (IY+22)", 4),
    'FDCB1717': ("RL (IY+23),A", 4),
    'FDCB1818': ("RR (IY+24),B", 4),
    'FDCB1919': ("RR (IY+25),C", 4),
    'FDCB1A1A': ("RR (IY+26),D", 4),
    'FDCB1B1B': ("RR (IY+27),E", 4),
    'FDCB1C1C': ("RR (IY+28),H", 4),
    'FDCB1D1D': ("RR (IY+29),L", 4),
    'FDCB1E1E': ("RR (IY+30)", 4),
    'FDCB1F1F': ("RR (IY+31),A", 4),
    'FDCB2020': ("SLA (IY+32),B", 4),
    'FDCB2121': ("SLA (IY+33),C", 4),
    'FDCB2222': ("SLA (IY+34),D", 4),
    'FDCB2323': ("SLA (IY+35),E", 4),
    'FDCB2424': ("SLA (IY+36),H", 4),
    'FDCB2525': ("SLA (IY+37),L", 4),
    'FDCB2626': ("SLA (IY+38)", 4),
    'FDCB2727': ("SLA (IY+39),A", 4),
    'FDCB2828': ("SRA (IY+40),B", 4),
    'FDCB2929': ("SRA (IY+41),C", 4),
    'FDCB2A2A': ("SRA (IY+42),D", 4),
    'FDCB2B2B': ("SRA (IY+43),E", 4),
    'FDCB2C2C': ("SRA (IY+44),H", 4),
    'FDCB2D2D': ("SRA (IY+45),L", 4),
    'FDCB2E2E': ("SRA (IY+46)", 4),
    'FDCB2F2F': ("SRA (IY+47),A", 4),
    'FDCB3030': ("SLL (IY+48),B", 4),
    'FDCB3131': ("SLL (IY+49),C", 4),
    'FDCB3232': ("SLL (IY+50),D", 4),
    'FDCB3333': ("SLL (IY+51),E", 4),
    'FDCB3434': ("SLL (IY+52),H", 4),
    'FDCB3535': ("SLL (IY+53),L", 4),
    'FDCB3636': ("SLL (IY+54)", 4),
    'FDCB3737': ("SLL (IY+55),A", 4),
    'FDCB3838': ("SRL (IY+56),B", 4),
    'FDCB3939': ("SRL (IY+57),C", 4),
    'FDCB3A3A': ("SRL (IY+58),D", 4),
    'FDCB3B3B': ("SRL (IY+59),E", 4),
    'FDCB3C3C': ("SRL (IY+60),H", 4),
    'FDCB3D3D': ("SRL (IY+61),L", 4),
    'FDCB3E3E': ("SRL (IY+62)", 4),
    'FDCB3F3F': ("SRL (IY+63),A", 4),
    'FDCB4040': ("BIT 0,(IY+64)", 4),
    'FDCB4141': ("BIT 0,(IY+65)", 4),
    'FDCB4242': ("BIT 0,(IY+66)", 4),
    'FDCB4343': ("BIT 0,(IY+67)", 4),
    'FDCB4444': ("BIT 0,(IY+68)", 4),
    'FDCB4545': ("BIT 0,(IY+69)", 4),
    'FDCB4646': ("BIT 0,(IY+70)", 4),
    'FDCB4747': ("BIT 0,(IY+71)", 4),
    'FDCB4848': ("BIT 1,(IY+72)", 4),
    'FDCB4949': ("BIT 1,(IY+73)", 4),
    'FDCB4A4A': ("BIT 1,(IY+74)", 4),
    'FDCB4B4B': ("BIT 1,(IY+75)", 4),
    'FDCB4C4C': ("BIT 1,(IY+76)", 4),
    'FDCB4D4D': ("BIT 1,(IY+77)", 4),
    'FDCB4E4E': ("BIT 1,(IY+78)", 4),
    'FDCB4F4F': ("BIT 1,(IY+79)", 4),
    'FDCB5050': ("BIT 2,(IY+80)", 4),
    'FDCB5151': ("BIT 2,(IY+81)", 4),
    'FDCB5252': ("BIT 2,(IY+82)", 4),
    'FDCB5353': ("BIT 2,(IY+83)", 4),
    'FDCB5454': ("BIT 2,(IY+84)", 4),
    'FDCB5555': ("BIT 2,(IY+85)", 4),
    'FDCB5656': ("BIT 2,(IY+86)", 4),
    'FDCB5757': ("BIT 2,(IY+87)", 4),
    'FDCB5858': ("BIT 3,(IY+88)", 4),
    'FDCB5959': ("BIT 3,(IY+89)", 4),
    'FDCB5A5A': ("BIT 3,(IY+90)", 4),
    'FDCB5B5B': ("BIT 3,(IY+91)", 4),
    'FDCB5C5C': ("BIT 3,(IY+92)", 4),
    'FDCB5D5D': ("BIT 3,(IY+93)", 4),
    'FDCB5E5E': ("BIT 3,(IY+94)", 4),
    'FDCB5F5F': ("BIT 3,(IY+95)", 4),
    'FDCB6060': ("BIT 4,(IY+96)", 4),
    'FDCB6161': ("BIT 4,(IY+97)", 4),
    'FDCB6262': ("BIT 4,(IY+98)", 4),
    'FDCB6363': ("BIT 4,(IY+99)", 4),
    'FDCB6464': ("BIT 4,(IY+100)", 4),
    'FDCB6565': ("BIT 4,(IY+101)", 4),
    'FDCB6666': ("BIT 4,(IY+102)", 4),
    'FDCB6767': ("BIT 4,(IY+103)", 4),
    'FDCB6868': ("BIT 5,(IY+104)", 4),
    'FDCB6969': ("BIT 5,(IY+105)", 4),
    'FDCB6A6A': ("BIT 5,(IY+106)", 4),
    'FDCB6B6B': ("BIT 5,(IY+107)", 4),
    'FDCB6C6C': ("BIT 5,(IY+108)", 4),
    'FDCB6D6D': ("BIT 5,(IY+109)", 4),
    'FDCB6E6E': ("BIT 5,(IY+110)", 4),
    'FDCB6F6F': ("BIT 5,(IY+111)", 4),
    'FDCB7070': ("BIT 6,(IY+112)", 4),
    'FDCB7171': ("BIT 6,(IY+113)", 4),
    'FDCB7272': ("BIT 6,(IY+114)", 4),
    'FDCB7373': ("BIT 6,(IY+115)", 4),
    'FDCB7474': ("BIT 6,(IY+116)", 4),
    'FDCB7575': ("BIT 6,(IY+117)", 4),
    'FDCB7676': ("BIT 6,(IY+118)", 4),
    'FDCB7777': ("BIT 6,(IY+119)", 4),
    'FDCB7878': ("BIT 7,(IY+120)", 4),
    'FDCB7979': ("BIT 7,(IY+121)", 4),
    'FDCB7A7A': ("BIT 7,(IY+122)", 4),
    'FDCB7B7B': ("BIT 7,(IY+123)", 4),
    'FDCB7C7C': ("BIT 7,(IY+124)", 4),
    'FDCB7D7D': ("BIT 7,(IY+125)", 4),
    'FDCB7E7E': ("BIT 7,(IY+126)", 4),
    'FDCB7F7F': ("BIT 7,(IY+127)", 4),
    'FDCB8080': ("RES 0,(IY-128),B", 4),
    'FDCB8181': ("RES 0,(IY-127),C", 4),
    'FDCB8282': ("RES 0,(IY-126),D", 4),
    'FDCB8383': ("RES 0,(IY-125),E", 4),
    'FDCB8484': ("RES 0,(IY-124),H", 4),
    'FDCB8585': ("RES 0,(IY-123),L", 4),
    'FDCB8686': ("RES 0,(IY-122)", 4),
    'FDCB8787': ("RES 0,(IY-121),A", 4),
    'FDCB8888': ("RES 1,(IY-120),B", 4),
    'FDCB8989': ("RES 1,(IY-119),C", 4),
    'FDCB8A8A': ("RES 1,(IY-118),D", 4),
    'FDCB8B8B': ("RES 1,(IY-117),E", 4),
    'FDCB8C8C': ("RES 1,(IY-116),H", 4),
    'FDCB8D8D': ("RES 1,(IY-115),L", 4),
    'FDCB8E8E': ("RES 1,(IY-114)", 4),
    'FDCB8F8F': ("RES 1,(IY-113),A", 4),
    'FDCB9090': ("RES 2,(IY-112),B", 4),
    'FDCB9191': ("RES 2,(IY-111),C", 4),
    'FDCB9292': ("RES 2,(IY-110),D", 4),
    'FDCB9393': ("RES 2,(IY-109),E", 4),
    'FDCB9494': ("RES 2,(IY-108),H", 4),
    'FDCB9595': ("RES 2,(IY-107),L", 4),
    'FDCB9696': ("RES 2,(IY-106)", 4),
    'FDCB9797': ("RES 2,(IY-105),A", 4),
    'FDCB9898': ("RES 3,(IY-104),B", 4),
    'FDCB9999': ("RES 3,(IY-103),C", 4),
    'FDCB9A9A': ("RES 3,(IY-102),D", 4),
    'FDCB9B9B': ("RES 3,(IY-101),E", 4),
    'FDCB9C9C': ("RES 3,(IY-100),H", 4),
    'FDCB9D9D': ("RES 3,(IY-99),L", 4),
    'FDCB9E9E': ("RES 3,(IY-98)", 4),
    'FDCB9F9F': ("RES 3,(IY-97),A", 4),
    'FDCBA0A0': ("RES 4,(IY-96),B", 4),
    'FDCBA1A1': ("RES 4,(IY-95),C", 4),
    'FDCBA2A2': ("RES 4,(IY-94),D", 4),
    'FDCBA3A3': ("RES 4,(IY-93),E", 4),
    'FDCBA4A4': ("RES 4,(IY-92),H", 4),
    'FDCBA5A5': ("RES 4,(IY-91),L", 4),
    'FDCBA6A6': ("RES 4,(IY-90)", 4),
    'FDCBA7A7': ("RES 4,(IY-89),A", 4),
    'FDCBA8A8': ("RES 5,(IY-88),B", 4),
    'FDCBA9A9': ("RES 5,(IY-87),C", 4),
    'FDCBAAAA': ("RES 5,(IY-86),D", 4),
    'FDCBABAB': ("RES 5,(IY-85),E", 4),
    'FDCBACAC': ("RES 5,(IY-84),H", 4),
    'FDCBADAD': ("RES 5,(IY-83),L", 4),
    'FDCBAEAE': ("RES 5,(IY-82)", 4),
    'FDCBAFAF': ("RES 5,(IY-81),A", 4),
    'FDCBB0B0': ("RES 6,(IY-80),B", 4),
    'FDCBB1B1': ("RES 6,(IY-79),C", 4),
    'FDCBB2B2': ("RES 6,(IY-78),D", 4),
    'FDCBB3B3': ("RES 6,(IY-77),E", 4),
    'FDCBB4B4': ("RES 6,(IY-76),H", 4),
    'FDCBB5B5': ("RES 6,(IY-75),L", 4),
    'FDCBB6B6': ("RES 6,(IY-74)", 4),
    'FDCBB7B7': ("RES 6,(IY-73),A", 4),
    'FDCBB8B8': ("RES 7,(IY-72),B", 4),
    'FDCBB9B9': ("RES 7,(IY-71),C", 4),
    'FDCBBABA': ("RES 7,(IY-70),D", 4),
    'FDCBBBBB': ("RES 7,(IY-69),E", 4),
    'FDCBBCBC': ("RES 7,(IY-68),H", 4),
    'FDCBBDBD': ("RES 7,(IY-67),L", 4),
    'FDCBBEBE': ("RES 7,(IY-66)", 4),
    'FDCBBFBF': ("RES 7,(IY-65),A", 4),
    'FDCBC0C0': ("SET 0,(IY-64),B", 4),
    'FDCBC1C1': ("SET 0,(IY-63),C", 4),
    'FDCBC2C2': ("SET 0,(IY-62),D", 4),
    'FDCBC3C3': ("SET 0,(IY-61),E", 4),
    'FDCBC4C4': ("SET 0,(IY-60),H", 4),
    'FDCBC5C5': ("SET 0,(IY-59),L", 4),
    'FDCBC6C6': ("SET 0,(IY-58)", 4),
    'FDCBC7C7': ("SET 0,(IY-57),A", 4),
    'FDCBC8C8': ("SET 1,(IY-56),B", 4),
    'FDCBC9C9': ("SET 1,(IY-55),C", 4),
    'FDCBCACA': ("SET 1,(IY-54),D", 4),
    'FDCBCBCB': ("SET 1,(IY-53),E", 4),
    'FDCBCCCC': ("SET 1,(IY-52),H", 4),
    'FDCBCDCD': ("SET 1,(IY-51),L", 4),
    'FDCBCECE': ("SET 1,(IY-50)", 4),
    'FDCBCFCF': ("SET 1,(IY-49),A", 4),
    'FDCBD0D0': ("SET 2,(IY-48),B", 4),
    'FDCBD1D1': ("SET 2,(IY-47),C", 4),
    'FDCBD2D2': ("SET 2,(IY-46),D", 4),
    'FDCBD3D3': ("SET 2,(IY-45),E", 4),
    'FDCBD4D4': ("SET 2,(IY-44),H", 4),
    'FDCBD5D5': ("SET 2,(IY-43),L", 4),
    'FDCBD6D6': ("SET 2,(IY-42)", 4),
    'FDCBD7D7': ("SET 2,(IY-41),A", 4),
    'FDCBD8D8': ("SET 3,(IY-40),B", 4),
    'FDCBD9D9': ("SET 3,(IY-39),C", 4),
    'FDCBDADA': ("SET 3,(IY-38),D", 4),
    'FDCBDBDB': ("SET 3,(IY-37),E", 4),
    'FDCBDCDC': ("SET 3,(IY-36),H", 4),
    'FDCBDDDD': ("SET 3,(IY-35),L", 4),
    'FDCBDEDE': ("SET 3,(IY-34)", 4),
    'FDCBDFDF': ("SET 3,(IY-33),A", 4),
    'FDCBE0E0': ("SET 4,(IY-32),B", 4),
    'FDCBE1E1': ("SET 4,(IY-31),C", 4),
    'FDCBE2E2': ("SET 4,(IY-30),D", 4),
    'FDCBE3E3': ("SET 4,(IY-29),E", 4),
    'FDCBE4E4': ("SET 4,(IY-28),H", 4),
    'FDCBE5E5': ("SET 4,(IY-27),L", 4),
    'FDCBE6E6': ("SET 4,(IY-26)", 4),
    'FDCBE7E7': ("SET 4,(IY-25),A", 4),
    'FDCBE8E8': ("SET 5,(IY-24),B", 4),
    'FDCBE9E9': ("SET 5,(IY-23),C", 4),
    'FDCBEAEA': ("SET 5,(IY-22),D", 4),
    'FDCBEBEB': ("SET 5,(IY-21),E", 4),
    'FDCBECEC': ("SET 5,(IY-20),H", 4),
    'FDCBEDED': ("SET 5,(IY-19),L", 4),
    'FDCBEEEE': ("SET 5,(IY-18)", 4),
    'FDCBEFEF': ("SET 5,(IY-17),A", 4),
    'FDCBF0F0': ("SET 6,(IY-16),B", 4),
    'FDCBF1F1': ("SET 6,(IY-15),C", 4),
    'FDCBF2F2': ("SET 6,(IY-14),D", 4),
    'FDCBF3F3': ("SET 6,(IY-13),E", 4),
    'FDCBF4F4': ("SET 6,(IY-12),H", 4),
    'FDCBF5F5': ("SET 6,(IY-11),L", 4),
    'FDCBF6F6': ("SET 6,(IY-10)", 4),
    'FDCBF7F7': ("SET 6,(IY-9),A", 4),
    'FDCBF8F8': ("SET 7,(IY-8),B", 4),
    'FDCBF9F9': ("SET 7,(IY-7),C", 4),
    'FDCBFAFA': ("SET 7,(IY-6),D", 4),
    'FDCBFBFB': ("SET 7,(IY-5),E", 4),
    'FDCBFCFC': ("SET 7,(IY-4),H", 4),
    'FDCBFDFD': ("SET 7,(IY-3),L", 4),
    'FDCBFEFE': ("SET 7,(IY-2)", 4),
    'FDCBFFFF': ("SET 7,(IY-1),A", 4),
}

OPCODES_FFFF = {
    '01010101': ("LD BC,$0101", 3),
    '06060606': ("LD B,$06", 2),
    '0E0E0E0E': ("LD C,$0E", 2),
    '10101010': ("DJNZ $0011", 2),
    '11111111': ("LD DE,$1111", 3),
    '16161616': ("LD D,$16", 2),
    '18181818': ("JR $0019", 2),
    '1E1E1E1E': ("LD E,$1E", 2),
    '20202020': ("JR NZ,$0021", 2),
    '21212121': ("LD HL,$2121", 3),
    '22222222': ("LD ($2222),HL", 3),
    '26262626': ("LD H,$26", 2),
    '28282828': ("JR Z,$0029", 2),
    '2A2A2A2A': ("LD HL,($2A2A)", 3),
    '2E2E2E2E': ("LD L,$2E", 2),
    '30303030': ("JR NC,$0031", 2),
    '31313131': ("LD SP,$3131", 3),
    '32323232': ("LD ($3232),A", 3),
    '36363636': ("LD (HL),$36", 2),
    '38383838': ("JR C,$0039", 2),
    '3A3A3A3A': ("LD A,($3A3A)", 3),
    '3E3E3E3E': ("LD A,$3E", 2),
    'C2C2C2C2': ("JP NZ,$C2C2", 3),
    'C3C3C3C3': ("JP $C3C3", 3),
    'C4C4C4C4': ("CALL NZ,$C4C4", 3),
    'C6C6C6C6': ("ADD A,$C6", 2),
    'CACACACA': ("JP Z,$CACA", 3),
    'CCCCCCCC': ("CALL Z,$CCCC", 3),
    'CDCDCDCD': ("CALL $CDCD", 3),
    'CECECECE': ("ADC A,$CE", 2),
    'D2D2D2D2': ("JP NC,$D2D2", 3),
    'D3D3D3D3': ("OUT ($D3),A", 2),
    'D4D4D4D4': ("CALL NC,$D4D4", 3),
    'D6D6D6D6': ("SUB $D6", 2),
    'DADADADA': ("JP C,$DADA", 3),
    'DBDBDBDB': ("IN A,($DB)", 2),
    'DCDCDCDC': ("CALL C,$DCDC", 3),
    'DEDEDEDE': ("SBC A,$DE", 2),
    'E2E2E2E2': ("JP PO,$E2E2", 3),
    'E4E4E4E4': ("CALL PO,$E4E4", 3),
    'E6E6E6E6': ("AND $E6", 2),
    'EAEAEAEA': ("JP PE,$EAEA", 3),
    'ECECECEC': ("CALL PE,$ECEC", 3),
    'EEEEEEEE': ("XOR $EE", 2),
    'F2F2F2F2': ("JP P,$F2F2", 3),
    'F4F4F4F4': ("CALL P,$F4F4", 3),
    'F6F6F6F6': ("OR $F6", 2),
    'FAFAFAFA': ("JP M,$FAFA", 3),
    'FCFCFCFC': ("CALL M,$FCFC", 3),
    'FEFEFEFE': ("CP $FE", 2),
    'CB000000': ("RLC B", 2),
    'CB010101': ("RLC C", 2),
    'CB020202': ("RLC D", 2),
    'CB030303': ("RLC E", 2),
    'CB040404': ("RLC H", 2),
    'CB050505': ("RLC L", 2),
    'CB060606': ("RLC (HL)", 2),
    'CB070707': ("RLC A", 2),
    'CB080808': ("RRC B", 2),
    'CB090909': ("RRC C", 2),
    'CB0A0A0A': ("RRC D", 2),
    'CB0B0B0B': ("RRC E", 2),
    'CB0C0C0C': ("RRC H", 2),
    'CB0D0D0D': ("RRC L", 2),
    'CB0E0E0E': ("RRC (HL)", 2),
    'CB0F0F0F': ("RRC A", 2),
    'CB101010': ("RL B", 2),
    'CB111111': ("RL C", 2),
    'CB121212': ("RL D", 2),
    'CB131313': ("RL E", 2),
    'CB141414': ("RL H", 2),
    'CB151515': ("RL L", 2),
    'CB161616': ("RL (HL)", 2),
    'CB171717': ("RL A", 2),
    'CB181818': ("RR B", 2),
    'CB191919': ("RR C", 2),
    'CB1A1A1A': ("RR D", 2),
    'CB1B1B1B': ("RR E", 2),
    'CB1C1C1C': ("RR H", 2),
    'CB1D1D1D': ("RR L", 2),
    'CB1E1E1E': ("RR (HL)", 2),
    'CB1F1F1F': ("RR A", 2),
    'CB202020': ("SLA B", 2),
    'CB212121': ("SLA C", 2),
    'CB222222': ("SLA D", 2),
    'CB232323': ("SLA E", 2),
    'CB242424': ("SLA H", 2),
    'CB252525': ("SLA L", 2),
    'CB262626': ("SLA (HL)", 2),
    'CB272727': ("SLA A", 2),
    'CB282828': ("SRA B", 2),
    'CB292929': ("SRA C", 2),
    'CB2A2A2A': ("SRA D", 2),
    'CB2B2B2B': ("SRA E", 2),
    'CB2C2C2C': ("SRA H", 2),
    'CB2D2D2D': ("SRA L", 2),
    'CB2E2E2E': ("SRA (HL)", 2),
    'CB2F2F2F': ("SRA A", 2),
    'CB303030': ("SLL B", 2),
    'CB313131': ("SLL C", 2),
    'CB323232': ("SLL D", 2),
    'CB333333': ("SLL E", 2),
    'CB343434': ("SLL H", 2),
    'CB353535': ("SLL L", 2),
    'CB363636': ("SLL (HL)", 2),
    'CB373737': ("SLL A", 2),
    'CB383838': ("SRL B", 2),
    'CB393939': ("SRL C", 2),
    'CB3A3A3A': ("SRL D", 2),
    'CB3B3B3B': ("SRL E", 2),
    'CB3C3C3C': ("SRL H", 2),
    'CB3D3D3D': ("SRL L", 2),
    'CB3E3E3E': ("SRL (HL)", 2),
    'CB3F3F3F': ("SRL A", 2),
    'CB404040': ("BIT 0,B", 2),
    'CB414141': ("BIT 0,C", 2),
    'CB424242': ("BIT 0,D", 2),
    'CB434343': ("BIT 0,E", 2),
    'CB444444': ("BIT 0,H", 2),
    'CB454545': ("BIT 0,L", 2),
    'CB464646': ("BIT 0,(HL)", 2),
    'CB474747': ("BIT 0,A", 2),
    'CB484848': ("BIT 1,B", 2),
    'CB494949': ("BIT 1,C", 2),
    'CB4A4A4A': ("BIT 1,D", 2),
    'CB4B4B4B': ("BIT 1,E", 2),
    'CB4C4C4C': ("BIT 1,H", 2),
    'CB4D4D4D': ("BIT 1,L", 2),
    'CB4E4E4E': ("BIT 1,(HL)", 2),
    'CB4F4F4F': ("BIT 1,A", 2),
    'CB505050': ("BIT 2,B", 2),
    'CB515151': ("BIT 2,C", 2),
    'CB525252': ("BIT 2,D", 2),
    'CB535353': ("BIT 2,E", 2),
    'CB545454': ("BIT 2,H", 2),
    'CB555555': ("BIT 2,L", 2),
    'CB565656': ("BIT 2,(HL)", 2),
    'CB575757': ("BIT 2,A", 2),
    'CB585858': ("BIT 3,B", 2),
    'CB595959': ("BIT 3,C", 2),
    'CB5A5A5A': ("BIT 3,D", 2),
    'CB5B5B5B': ("BIT 3,E", 2),
    'CB5C5C5C': ("BIT 3,H", 2),
    'CB5D5D5D': ("BIT 3,L", 2),
    'CB5E5E5E': ("BIT 3,(HL)", 2),
    'CB5F5F5F': ("BIT 3,A", 2),
    'CB606060': ("BIT 4,B", 2),
    'CB616161': ("BIT 4,C", 2),
    'CB626262': ("BIT 4,D", 2),
    'CB636363': ("BIT 4,E", 2),
    'CB646464': ("BIT 4,H", 2),
    'CB656565': ("BIT 4,L", 2),
    'CB666666': ("BIT 4,(HL)", 2),
    'CB676767': ("BIT 4,A", 2),
    'CB686868': ("BIT 5,B", 2),
    'CB696969': ("BIT 5,C", 2),
    'CB6A6A6A': ("BIT 5,D", 2),
    'CB6B6B6B': ("BIT 5,E", 2),
    'CB6C6C6C': ("BIT 5,H", 2),
    'CB6D6D6D': ("BIT 5,L", 2),
    'CB6E6E6E': ("BIT 5,(HL)", 2),
    'CB6F6F6F': ("BIT 5,A", 2),
    'CB707070': ("BIT 6,B", 2),
    'CB717171': ("BIT 6,C", 2),
    'CB727272': ("BIT 6,D", 2),
    'CB737373': ("BIT 6,E", 2),
    'CB747474': ("BIT 6,H", 2),
    'CB757575': ("BIT 6,L", 2),
    'CB767676': ("BIT 6,(HL)", 2),
    'CB777777': ("BIT 6,A", 2),
    'CB787878': ("BIT 7,B", 2),
    'CB797979': ("BIT 7,C", 2),
    'CB7A7A7A': ("BIT 7,D", 2),
    'CB7B7B7B': ("BIT 7,E", 2),
    'CB7C7C7C': ("BIT 7,H", 2),
    'CB7D7D7D': ("BIT 7,L", 2),
    'CB7E7E7E': ("BIT 7,(HL)", 2),
    'CB7F7F7F': ("BIT 7,A", 2),
    'CB808080': ("RES 0,B", 2),
    'CB818181': ("RES 0,C", 2),
    'CB828282': ("RES 0,D", 2),
    'CB838383': ("RES 0,E", 2),
    'CB848484': ("RES 0,H", 2),
    'CB858585': ("RES 0,L", 2),
    'CB868686': ("RES 0,(HL)", 2),
    'CB878787': ("RES 0,A", 2),
    'CB888888': ("RES 1,B", 2),
    'CB898989': ("RES 1,C", 2),
    'CB8A8A8A': ("RES 1,D", 2),
    'CB8B8B8B': ("RES 1,E", 2),
    'CB8C8C8C': ("RES 1,H", 2),
    'CB8D8D8D': ("RES 1,L", 2),
    'CB8E8E8E': ("RES 1,(HL)", 2),
    'CB8F8F8F': ("RES 1,A", 2),
    'CB909090': ("RES 2,B", 2),
    'CB919191': ("RES 2,C", 2),
    'CB929292': ("RES 2,D", 2),
    'CB939393': ("RES 2,E", 2),
    'CB949494': ("RES 2,H", 2),
    'CB959595': ("RES 2,L", 2),
    'CB969696': ("RES 2,(HL)", 2),
    'CB979797': ("RES 2,A", 2),
    'CB989898': ("RES 3,B", 2),
    'CB999999': ("RES 3,C", 2),
    'CB9A9A9A': ("RES 3,D", 2),
    'CB9B9B9B': ("RES 3,E", 2),
    'CB9C9C9C': ("RES 3,H", 2),
    'CB9D9D9D': ("RES 3,L", 2),
    'CB9E9E9E': ("RES 3,(HL)", 2),
    'CB9F9F9F': ("RES 3,A", 2),
    'CBA0A0A0': ("RES 4,B", 2),
    'CBA1A1A1': ("RES 4,C", 2),
    'CBA2A2A2': ("RES 4,D", 2),
    'CBA3A3A3': ("RES 4,E", 2),
    'CBA4A4A4': ("RES 4,H", 2),
    'CBA5A5A5': ("RES 4,L", 2),
    'CBA6A6A6': ("RES 4,(HL)", 2),
    'CBA7A7A7': ("RES 4,A", 2),
    'CBA8A8A8': ("RES 5,B", 2),
    'CBA9A9A9': ("RES 5,C", 2),
    'CBAAAAAA': ("RES 5,D", 2),
    'CBABABAB': ("RES 5,E", 2),
    'CBACACAC': ("RES 5,H", 2),
    'CBADADAD': ("RES 5,L", 2),
    'CBAEAEAE': ("RES 5,(HL)", 2),
    'CBAFAFAF': ("RES 5,A", 2),
    'CBB0B0B0': ("RES 6,B", 2),
    'CBB1B1B1': ("RES 6,C", 2),
    'CBB2B2B2': ("RES 6,D", 2),
    'CBB3B3B3': ("RES 6,E", 2),
    'CBB4B4B4': ("RES 6,H", 2),
    'CBB5B5B5': ("RES 6,L", 2),
    'CBB6B6B6': ("RES 6,(HL)", 2),
    'CBB7B7B7': ("RES 6,A", 2),
    'CBB8B8B8': ("RES 7,B", 2),
    'CBB9B9B9': ("RES 7,C", 2),
    'CBBABABA': ("RES 7,D", 2),
    'CBBBBBBB': ("RES 7,E", 2),
    'CBBCBCBC': ("RES 7,H", 2),
    'CBBDBDBD': ("RES 7,L", 2),
    'CBBEBEBE': ("RES 7,(HL)", 2),
    'CBBFBFBF': ("RES 7,A", 2),
    'CBC0C0C0': ("SET 0,B", 2),
    'CBC1C1C1': ("SET 0,C", 2),
    'CBC2C2C2': ("SET 0,D", 2),
    'CBC3C3C3': ("SET 0,E", 2),
    'CBC4C4C4': ("SET 0,H", 2),
    'CBC5C5C5': ("SET 0,L", 2),
    'CBC6C6C6': ("SET 0,(HL)", 2),
    'CBC7C7C7': ("SET 0,A", 2),
    'CBC8C8C8': ("SET 1,B", 2),
    'CBC9C9C9': ("SET 1,C", 2),
    'CBCACACA': ("SET 1,D", 2),
    'CBCBCBCB': ("SET 1,E", 2),
    'CBCCCCCC': ("SET 1,H", 2),
    'CBCDCDCD': ("SET 1,L", 2),
    'CBCECECE': ("SET 1,(HL)", 2),
    'CBCFCFCF': ("SET 1,A", 2),
    'CBD0D0D0': ("SET 2,B", 2),
    'CBD1D1D1': ("SET 2,C", 2),
    'CBD2D2D2': ("SET 2,D", 2),
    'CBD3D3D3': ("SET 2,E", 2),
    'CBD4D4D4': ("SET 2,H", 2),
    'CBD5D5D5': ("SET 2,L", 2),
    'CBD6D6D6': ("SET 2,(HL)", 2),
    'CBD7D7D7': ("SET 2,A", 2),
    'CBD8D8D8': ("SET 3,B", 2),
    'CBD9D9D9': ("SET 3,C", 2),
    'CBDADADA': ("SET 3,D", 2),
    'CBDBDBDB': ("SET 3,E", 2),
    'CBDCDCDC': ("SET 3,H", 2),
    'CBDDDDDD': ("SET 3,L", 2),
    'CBDEDEDE': ("SET 3,(HL)", 2),
    'CBDFDFDF': ("SET 3,A", 2),
    'CBE0E0E0': ("SET 4,B", 2),
    'CBE1E1E1': ("SET 4,C", 2),
    'CBE2E2E2': ("SET 4,D", 2),
    'CBE3E3E3': ("SET 4,E", 2),
    'CBE4E4E4': ("SET 4,H", 2),
    'CBE5E5E5': ("SET 4,L", 2),
    'CBE6E6E6': ("SET 4,(HL)", 2),
    'CBE7E7E7': ("SET 4,A", 2),
    'CBE8E8E8': ("SET 5,B", 2),
    'CBE9E9E9': ("SET 5,C", 2),
    'CBEAEAEA': ("SET 5,D", 2),
    'CBEBEBEB': ("SET 5,E", 2),
    'CBECECEC': ("SET 5,H", 2),
    'CBEDEDED': ("SET 5,L", 2),
    'CBEEEEEE': ("SET 5,(HL)", 2),
    'CBEFEFEF': ("SET 5,A", 2),
    'CBF0F0F0': ("SET 6,B", 2),
    'CBF1F1F1': ("SET 6,C", 2),
    'CBF2F2F2': ("SET 6,D", 2),
    'CBF3F3F3': ("SET 6,E", 2),
    'CBF4F4F4': ("SET 6,H", 2),
    'CBF5F5F5': ("SET 6,L", 2),
    'CBF6F6F6': ("SET 6,(HL)", 2),
    'CBF7F7F7': ("SET 6,A", 2),
    'CBF8F8F8': ("SET 7,B", 2),
    'CBF9F9F9': ("SET 7,C", 2),
    'CBFAFAFA': ("SET 7,D", 2),
    'CBFBFBFB': ("SET 7,E", 2),
    'CBFCFCFC': ("SET 7,H", 2),
    'CBFDFDFD': ("SET 7,L", 2),
    'CBFEFEFE': ("SET 7,(HL)", 2),
    'CBFFFFFF': ("SET 7,A", 2),
    'DD090909': ("ADD IX,BC", 2),
    'DD191919': ("ADD IX,DE", 2),
    'DD212121': ("LD IX,$2121", 4),
    'DD222222': ("LD ($2222),IX", 4),
    'DD232323': ("INC IX", 2),
    'DD242424': ("INC IXh", 2),
    'DD252525': ("DEC IXh", 2),
    'DD262626': ("LD IXh,$26", 3),
    'DD292929': ("ADD IX,IX", 2),
    'DD2A2A2A': ("LD IX,($2A2A)", 4),
    'DD2B2B2B': ("DEC IX", 2),
    'DD2C2C2C': ("INC IXl", 2),
    'DD2D2D2D': ("DEC IXl", 2),
    'DD2E2E2E': ("LD IXl,$2E", 3),
    'DD343434': ("INC (IX+$34)", 3),
    'DD353535': ("DEC (IX+$35)", 3),
    'DD363636': ("LD (IX+$36),$36", 4),
    'DD393939': ("ADD IX,SP", 2),
    'DD444444': ("LD B,IXh", 2),
    'DD454545': ("LD B,IXl", 2),
    'DD464646': ("LD B,(IX+$46)", 3),
    'DD4C4C4C': ("LD C,IXh", 2),
    'DD4D4D4D': ("LD C,IXl", 2),
    'DD4E4E4E': ("LD C,(IX+$4E)", 3),
    'DD545454': ("LD D,IXh", 2),
    'DD555555': ("LD D,IXl", 2),
    'DD565656': ("LD D,(IX+$56)", 3),
    'DD5C5C5C': ("LD E,IXh", 2),
    'DD5D5D5D': ("LD E,IXl", 2),
    'DD5E5E5E': ("LD E,(IX+$5E)", 3),
    'DD606060': ("LD IXh,B", 2),
    'DD616161': ("LD IXh,C", 2),
    'DD626262': ("LD IXh,D", 2),
    'DD636363': ("LD IXh,E", 2),
    'DD646464': ("LD IXh,IXh", 2),
    'DD656565': ("LD IXh,IXl", 2),
    'DD666666': ("LD H,(IX+$66)", 3),
    'DD676767': ("LD IXh,A", 2),
    'DD686868': ("LD IXl,B", 2),
    'DD696969': ("LD IXl,C", 2),
    'DD6A6A6A': ("LD IXl,D", 2),
    'DD6B6B6B': ("LD IXl,E", 2),
    'DD6C6C6C': ("LD IXl,IXh", 2),
    'DD6D6D6D': ("LD IXl,IXl", 2),
    'DD6E6E6E': ("LD L,(IX+$6E)", 3),
    'DD6F6F6F': ("LD IXl,A", 2),
    'DD707070': ("LD (IX+$70),B", 3),
    'DD717171': ("LD (IX+$71),C", 3),
    'DD727272': ("LD (IX+$72),D", 3),
    'DD737373': ("LD (IX+$73),E", 3),
    'DD747474': ("LD (IX+$74),H", 3),
    'DD757575': ("LD (IX+$75),L", 3),
    'DD777777': ("LD (IX+$77),A", 3),
    'DD7C7C7C': ("LD A,IXh", 2),
    'DD7D7D7D': ("LD A,IXl", 2),
    'DD7E7E7E': ("LD A,(IX+$7E)", 3),
    'DD848484': ("ADD A,IXh", 2),
    'DD858585': ("ADD A,IXl", 2),
    'DD868686': ("ADD A,(IX-$7A)", 3),
    'DD8C8C8C': ("ADC A,IXh", 2),
    'DD8D8D8D': ("ADC A,IXl", 2),
    'DD8E8E8E': ("ADC A,(IX-$72)", 3),
    'DD949494': ("SUB IXh", 2),
    'DD959595': ("SUB IXl", 2),
    'DD969696': ("SUB (IX-$6A)", 3),
    'DD9C9C9C': ("SBC A,IXh", 2),
    'DD9D9D9D': ("SBC A,IXl", 2),
    'DD9E9E9E': ("SBC A,(IX-$62)", 3),
    'DDA4A4A4': ("AND IXh", 2),
    'DDA5A5A5': ("AND IXl", 2),
    'DDA6A6A6': ("AND (IX-$5A)", 3),
    'DDACACAC': ("XOR IXh", 2),
    'DDADADAD': ("XOR IXl", 2),
    'DDAEAEAE': ("XOR (IX-$52)", 3),
    'DDB4B4B4': ("OR IXh", 2),
    'DDB5B5B5': ("OR IXl", 2),
    'DDB6B6B6': ("OR (IX-$4A)", 3),
    'DDBCBCBC': ("CP IXh", 2),
    'DDBDBDBD': ("CP IXl", 2),
    'DDBEBEBE': ("CP (IX-$42)", 3),
    'DDE1E1E1': ("POP IX", 2),
    'DDE3E3E3': ("EX (SP),IX", 2),
    'DDE5E5E5': ("PUSH IX", 2),
    'DDE9E9E9': ("JP (IX)", 2),
    'DDF9F9F9': ("LD SP,IX", 2),
    'ED000000': ("DEFB $ED,$00", 2),
    'ED010101': ("DEFB $ED,$01", 2),
    'ED020202': ("DEFB $ED,$02", 2),
    'ED030303': ("DEFB $ED,$03", 2),
    'ED040404': ("DEFB $ED,$04", 2),
    'ED050505': ("DEFB $ED,$05", 2),
    'ED060606': ("DEFB $ED,$06", 2),
    'ED070707': ("DEFB $ED,$07", 2),
    'ED080808': ("DEFB $ED,$08", 2),
    'ED090909': ("DEFB $ED,$09", 2),
    'ED0A0A0A': ("DEFB $ED,$0A", 2),
    'ED0B0B0B': ("DEFB $ED,$0B", 2),
    'ED0C0C0C': ("DEFB $ED,$0C", 2),
    'ED0D0D0D': ("DEFB $ED,$0D", 2),
    'ED0E0E0E': ("DEFB $ED,$0E", 2),
    'ED0F0F0F': ("DEFB $ED,$0F", 2),
    'ED101010': ("DEFB $ED,$10", 2),
    'ED111111': ("DEFB $ED,$11", 2),
    'ED121212': ("DEFB $ED,$12", 2),
    'ED131313': ("DEFB $ED,$13", 2),
    'ED141414': ("DEFB $ED,$14", 2),
    'ED151515': ("DEFB $ED,$15", 2),
    'ED161616': ("DEFB $ED,$16", 2),
    'ED171717': ("DEFB $ED,$17", 2),
    'ED181818': ("DEFB $ED,$18", 2),
    'ED191919': ("DEFB $ED,$19", 2),
    'ED1A1A1A': ("DEFB $ED,$1A", 2),
    'ED1B1B1B': ("DEFB $ED,$1B", 2),
    'ED1C1C1C': ("DEFB $ED,$1C", 2),
    'ED1D1D1D': ("DEFB $ED,$1D", 2),
    'ED1E1E1E': ("DEFB $ED,$1E", 2),
    'ED1F1F1F': ("DEFB $ED,$1F", 2),
    'ED202020': ("DEFB $ED,$20", 2),
    'ED212121': ("DEFB $ED,$21", 2),
    'ED222222': ("DEFB $ED,$22", 2),
    'ED232323': ("DEFB $ED,$23", 2),
    'ED242424': ("DEFB $ED,$24", 2),
    'ED252525': ("DEFB $ED,$25", 2),
    'ED262626': ("DEFB $ED,$26", 2),
    'ED272727': ("DEFB $ED,$27", 2),
    'ED282828': ("DEFB $ED,$28", 2),
    'ED292929': ("DEFB $ED,$29", 2),
    'ED2A2A2A': ("DEFB $ED,$2A", 2),
    'ED2B2B2B': ("DEFB $ED,$2B", 2),
    'ED2C2C2C': ("DEFB $ED,$2C", 2),
    'ED2D2D2D': ("DEFB $ED,$2D", 2),
    'ED2E2E2E': ("DEFB $ED,$2E", 2),
    'ED2F2F2F': ("DEFB $ED,$2F", 2),
    'ED303030': ("DEFB $ED,$30", 2),
    'ED313131': ("DEFB $ED,$31", 2),
    'ED323232': ("DEFB $ED,$32", 2),
    'ED333333': ("DEFB $ED,$33", 2),
    'ED343434': ("DEFB $ED,$34", 2),
    'ED353535': ("DEFB $ED,$35", 2),
    'ED363636': ("DEFB $ED,$36", 2),
    'ED373737': ("DEFB $ED,$37", 2),
    'ED383838': ("DEFB $ED,$38", 2),
    'ED393939': ("DEFB $ED,$39", 2),
    'ED3A3A3A': ("DEFB $ED,$3A", 2),
    'ED3B3B3B': ("DEFB $ED,$3B", 2),
    'ED3C3C3C': ("DEFB $ED,$3C", 2),
    'ED3D3D3D': ("DEFB $ED,$3D", 2),
    'ED3E3E3E': ("DEFB $ED,$3E", 2),
    'ED3F3F3F': ("DEFB $ED,$3F", 2),
    'ED404040': ("IN B,(C)", 2),
    'ED414141': ("OUT (C),B", 2),
    'ED424242': ("SBC HL,BC", 2),
    'ED434343': ("LD ($4343),BC", 4),
    'ED444444': ("NEG", 2),
    'ED454545': ("RETN", 2),
    'ED464646': ("IM 0", 2),
    'ED474747': ("LD I,A", 2),
    'ED484848': ("IN C,(C)", 2),
    'ED494949': ("OUT (C),C", 2),
    'ED4A4A4A': ("ADC HL,BC", 2),
    'ED4B4B4B': ("LD BC,($4B4B)", 4),
    'ED4C4C4C': ("NEG", 2),
    'ED4D4D4D': ("RETI", 2),
    'ED4E4E4E': ("IM 0", 2),
    'ED4F4F4F': ("LD R,A", 2),
    'ED505050': ("IN D,(C)", 2),
    'ED515151': ("OUT (C),D", 2),
    'ED525252': ("SBC HL,DE", 2),
    'ED535353': ("LD ($5353),DE", 4),
    'ED545454': ("NEG", 2),
    'ED555555': ("RETN", 2),
    'ED565656': ("IM 1", 2),
    'ED575757': ("LD A,I", 2),
    'ED585858': ("IN E,(C)", 2),
    'ED595959': ("OUT (C),E", 2),
    'ED5A5A5A': ("ADC HL,DE", 2),
    'ED5B5B5B': ("LD DE,($5B5B)", 4),
    'ED5C5C5C': ("NEG", 2),
    'ED5D5D5D': ("RETN", 2),
    'ED5E5E5E': ("IM 2", 2),
    'ED5F5F5F': ("LD A,R", 2),
    'ED606060': ("IN H,(C)", 2),
    'ED616161': ("OUT (C),H", 2),
    'ED626262': ("SBC HL,HL", 2),
    'ED636363': ("LD ($6363),HL", 4),
    'ED646464': ("NEG", 2),
    'ED656565': ("RETN", 2),
    'ED666666': ("IM 0", 2),
    'ED676767': ("RRD", 2),
    'ED686868': ("IN L,(C)", 2),
    'ED696969': ("OUT (C),L", 2),
    'ED6A6A6A': ("ADC HL,HL", 2),
    'ED6B6B6B': ("LD HL,($6B6B)", 4),
    'ED6C6C6C': ("NEG", 2),
    'ED6D6D6D': ("RETN", 2),
    'ED6E6E6E': ("IM 0", 2),
    'ED6F6F6F': ("RLD", 2),
    'ED707070': ("IN F,(C)", 2),
    'ED717171': ("OUT (C),0", 2),
    'ED727272': ("SBC HL,SP", 2),
    'ED737373': ("LD ($7373),SP", 4),
    'ED747474': ("NEG", 2),
    'ED757575': ("RETN", 2),
    'ED767676': ("IM 1", 2),
    'ED777777': ("DEFB $ED,$77", 2),
    'ED787878': ("IN A,(C)", 2),
    'ED797979': ("OUT (C),A", 2),
    'ED7A7A7A': ("ADC HL,SP", 2),
    'ED7B7B7B': ("LD SP,($7B7B)", 4),
    'ED7C7C7C': ("NEG", 2),
    'ED7D7D7D': ("RETN", 2),
    'ED7E7E7E': ("IM 2", 2),
    'ED7F7F7F': ("DEFB $ED,$7F", 2),
    'ED808080': ("DEFB $ED,$80", 2),
    'ED818181': ("DEFB $ED,$81", 2),
    'ED828282': ("DEFB $ED,$82", 2),
    'ED838383': ("DEFB $ED,$83", 2),
    'ED848484': ("DEFB $ED,$84", 2),
    'ED858585': ("DEFB $ED,$85", 2),
    'ED868686': ("DEFB $ED,$86", 2),
    'ED878787': ("DEFB $ED,$87", 2),
    'ED888888': ("DEFB $ED,$88", 2),
    'ED898989': ("DEFB $ED,$89", 2),
    'ED8A8A8A': ("DEFB $ED,$8A", 2),
    'ED8B8B8B': ("DEFB $ED,$8B", 2),
    'ED8C8C8C': ("DEFB $ED,$8C", 2),
    'ED8D8D8D': ("DEFB $ED,$8D", 2),
    'ED8E8E8E': ("DEFB $ED,$8E", 2),
    'ED8F8F8F': ("DEFB $ED,$8F", 2),
    'ED909090': ("DEFB $ED,$90", 2),
    'ED919191': ("DEFB $ED,$91", 2),
    'ED929292': ("DEFB $ED,$92", 2),
    'ED939393': ("DEFB $ED,$93", 2),
    'ED949494': ("DEFB $ED,$94", 2),
    'ED959595': ("DEFB $ED,$95", 2),
    'ED969696': ("DEFB $ED,$96", 2),
    'ED979797': ("DEFB $ED,$97", 2),
    'ED989898': ("DEFB $ED,$98", 2),
    'ED999999': ("DEFB $ED,$99", 2),
    'ED9A9A9A': ("DEFB $ED,$9A", 2),
    'ED9B9B9B': ("DEFB $ED,$9B", 2),
    'ED9C9C9C': ("DEFB $ED,$9C", 2),
    'ED9D9D9D': ("DEFB $ED,$9D", 2),
    'ED9E9E9E': ("DEFB $ED,$9E", 2),
    'ED9F9F9F': ("DEFB $ED,$9F", 2),
    'EDA0A0A0': ("LDI", 2),
    'EDA1A1A1': ("CPI", 2),
    'EDA2A2A2': ("INI", 2),
    'EDA3A3A3': ("OUTI", 2),
    'EDA4A4A4': ("DEFB $ED,$A4", 2),
    'EDA5A5A5': ("DEFB $ED,$A5", 2),
    'EDA6A6A6': ("DEFB $ED,$A6", 2),
    'EDA7A7A7': ("DEFB $ED,$A7", 2),
    'EDA8A8A8': ("LDD", 2),
    'EDA9A9A9': ("CPD", 2),
    'EDAAAAAA': ("IND", 2),
    'EDABABAB': ("OUTD", 2),
    'EDACACAC': ("DEFB $ED,$AC", 2),
    'EDADADAD': ("DEFB $ED,$AD", 2),
    'EDAEAEAE': ("DEFB $ED,$AE", 2),
    'EDAFAFAF': ("DEFB $ED,$AF", 2),
    'EDB0B0B0': ("LDIR", 2),
    'EDB1B1B1': ("CPIR", 2),
    'EDB2B2B2': ("INIR", 2),
    'EDB3B3B3': ("OTIR", 2),
    'EDB4B4B4': ("DEFB $ED,$B4", 2),
    'EDB5B5B5': ("DEFB $ED,$B5", 2),
    'EDB6B6B6': ("DEFB $ED,$B6", 2),
    'EDB7B7B7': ("DEFB $ED,$B7", 2),
    'EDB8B8B8': ("LDDR", 2),
    'EDB9B9B9': ("CPDR", 2),
    'EDBABABA': ("INDR", 2),
    'EDBBBBBB': ("OTDR", 2),
    'EDBCBCBC': ("DEFB $ED,$BC", 2),
    'EDBDBDBD': ("DEFB $ED,$BD", 2),
    'EDBEBEBE': ("DEFB $ED,$BE", 2),
    'EDBFBFBF': ("DEFB $ED,$BF", 2),
    'EDC0C0C0': ("DEFB $ED,$C0", 2),
    'EDC1C1C1': ("DEFB $ED,$C1", 2),
    'EDC2C2C2': ("DEFB $ED,$C2", 2),
    'EDC3C3C3': ("DEFB $ED,$C3", 2),
    'EDC4C4C4': ("DEFB $ED,$C4", 2),
    'EDC5C5C5': ("DEFB $ED,$C5", 2),
    'EDC6C6C6': ("DEFB $ED,$C6", 2),
    'EDC7C7C7': ("DEFB $ED,$C7", 2),
    'EDC8C8C8': ("DEFB $ED,$C8", 2),
    'EDC9C9C9': ("DEFB $ED,$C9", 2),
    'EDCACACA': ("DEFB $ED,$CA", 2),
    'EDCBCBCB': ("DEFB $ED,$CB", 2),
    'EDCCCCCC': ("DEFB $ED,$CC", 2),
    'EDCDCDCD': ("DEFB $ED,$CD", 2),
    'EDCECECE': ("DEFB $ED,$CE", 2),
    'EDCFCFCF': ("DEFB $ED,$CF", 2),
    'EDD0D0D0': ("DEFB $ED,$D0", 2),
    'EDD1D1D1': ("DEFB $ED,$D1", 2),
    'EDD2D2D2': ("DEFB $ED,$D2", 2),
    'EDD3D3D3': ("DEFB $ED,$D3", 2),
    'EDD4D4D4': ("DEFB $ED,$D4", 2),
    'EDD5D5D5': ("DEFB $ED,$D5", 2),
    'EDD6D6D6': ("DEFB $ED,$D6", 2),
    'EDD7D7D7': ("DEFB $ED,$D7", 2),
    'EDD8D8D8': ("DEFB $ED,$D8", 2),
    'EDD9D9D9': ("DEFB $ED,$D9", 2),
    'EDDADADA': ("DEFB $ED,$DA", 2),
    'EDDBDBDB': ("DEFB $ED,$DB", 2),
    'EDDCDCDC': ("DEFB $ED,$DC", 2),
    'EDDDDDDD': ("DEFB $ED,$DD", 2),
    'EDDEDEDE': ("DEFB $ED,$DE", 2),
    'EDDFDFDF': ("DEFB $ED,$DF", 2),
    'EDE0E0E0': ("DEFB $ED,$E0", 2),
    'EDE1E1E1': ("DEFB $ED,$E1", 2),
    'EDE2E2E2': ("DEFB $ED,$E2", 2),
    'EDE3E3E3': ("DEFB $ED,$E3", 2),
    'EDE4E4E4': ("DEFB $ED,$E4", 2),
    'EDE5E5E5': ("DEFB $ED,$E5", 2),
    'EDE6E6E6': ("DEFB $ED,$E6", 2),
    'EDE7E7E7': ("DEFB $ED,$E7", 2),
    'EDE8E8E8': ("DEFB $ED,$E8", 2),
    'EDE9E9E9': ("DEFB $ED,$E9", 2),
    'EDEAEAEA': ("DEFB $ED,$EA", 2),
    'EDEBEBEB': ("DEFB $ED,$EB", 2),
    'EDECECEC': ("DEFB $ED,$EC", 2),
    'EDEDEDED': ("DEFB $ED,$ED", 2),
    'EDEEEEEE': ("DEFB $ED,$EE", 2),
    'EDEFEFEF': ("DEFB $ED,$EF", 2),
    'EDF0F0F0': ("DEFB $ED,$F0", 2),
    'EDF1F1F1': ("DEFB $ED,$F1", 2),
    'EDF2F2F2': ("DEFB $ED,$F2", 2),
    'EDF3F3F3': ("DEFB $ED,$F3", 2),
    'EDF4F4F4': ("DEFB $ED,$F4", 2),
    'EDF5F5F5': ("DEFB $ED,$F5", 2),
    'EDF6F6F6': ("DEFB $ED,$F6", 2),
    'EDF7F7F7': ("DEFB $ED,$F7", 2),
    'EDF8F8F8': ("DEFB $ED,$F8", 2),
    'EDF9F9F9': ("DEFB $ED,$F9", 2),
    'EDFAFAFA': ("DEFB $ED,$FA", 2),
    'EDFBFBFB': ("DEFB $ED,$FB", 2),
    'EDFCFCFC': ("DEFB $ED,$FC", 2),
    'EDFDFDFD': ("DEFB $ED,$FD", 2),
    'EDFEFEFE': ("DEFB $ED,$FE", 2),
    'EDFFFFFF': ("DEFB $ED,$FF", 2),
    'FD090909': ("ADD IY,BC", 2),
    'FD191919': ("ADD IY,DE", 2),
    'FD212121': ("LD IY,$2121", 4),
    'FD222222': ("LD ($2222),IY", 4),
    'FD232323': ("INC IY", 2),
    'FD242424': ("INC IYh", 2),
    'FD252525': ("DEC IYh", 2),
    'FD262626': ("LD IYh,$26", 3),
    'FD292929': ("ADD IY,IY", 2),
    'FD2A2A2A': ("LD IY,($2A2A)", 4),
    'FD2B2B2B': ("DEC IY", 2),
    'FD2C2C2C': ("INC IYl", 2),
    'FD2D2D2D': ("DEC IYl", 2),
    'FD2E2E2E': ("LD IYl,$2E", 3),
    'FD343434': ("INC (IY+$34)", 3),
    'FD353535': ("DEC (IY+$35)", 3),
    'FD363636': ("LD (IY+$36),$36", 4),
    'FD393939': ("ADD IY,SP", 2),
    'FD444444': ("LD B,IYh", 2),
    'FD454545': ("LD B,IYl", 2),
    'FD464646': ("LD B,(IY+$46)", 3),
    'FD4C4C4C': ("LD C,IYh", 2),
    'FD4D4D4D': ("LD C,IYl", 2),
    'FD4E4E4E': ("LD C,(IY+$4E)", 3),
    'FD545454': ("LD D,IYh", 2),
    'FD555555': ("LD D,IYl", 2),
    'FD565656': ("LD D,(IY+$56)", 3),
    'FD5C5C5C': ("LD E,IYh", 2),
    'FD5D5D5D': ("LD E,IYl", 2),
    'FD5E5E5E': ("LD E,(IY+$5E)", 3),
    'FD606060': ("LD IYh,B", 2),
    'FD616161': ("LD IYh,C", 2),
    'FD626262': ("LD IYh,D", 2),
    'FD636363': ("LD IYh,E", 2),
    'FD646464': ("LD IYh,IYh", 2),
    'FD656565': ("LD IYh,IYl", 2),
    'FD666666': ("LD H,(IY+$66)", 3),
    'FD676767': ("LD IYh,A", 2),
    'FD686868': ("LD IYl,B", 2),
    'FD696969': ("LD IYl,C", 2),
    'FD6A6A6A': ("LD IYl,D", 2),
    'FD6B6B6B': ("LD IYl,E", 2),
    'FD6C6C6C': ("LD IYl,IYh", 2),
    'FD6D6D6D': ("LD IYl,IYl", 2),
    'FD6E6E6E': ("LD L,(IY+$6E)", 3),
    'FD6F6F6F': ("LD IYl,A", 2),
    'FD707070': ("LD (IY+$70),B", 3),
    'FD717171': ("LD (IY+$71),C", 3),
    'FD727272': ("LD (IY+$72),D", 3),
    'FD737373': ("LD (IY+$73),E", 3),
    'FD747474': ("LD (IY+$74),H", 3),
    'FD757575': ("LD (IY+$75),L", 3),
    'FD777777': ("LD (IY+$77),A", 3),
    'FD7C7C7C': ("LD A,IYh", 2),
    'FD7D7D7D': ("LD A,IYl", 2),
    'FD7E7E7E': ("LD A,(IY+$7E)", 3),
    'FD848484': ("ADD A,IYh", 2),
    'FD858585': ("ADD A,IYl", 2),
    'FD868686': ("ADD A,(IY-$7A)", 3),
    'FD8C8C8C': ("ADC A,IYh", 2),
    'FD8D8D8D': ("ADC A,IYl", 2),
    'FD8E8E8E': ("ADC A,(IY-$72)", 3),
    'FD949494': ("SUB IYh", 2),
    'FD959595': ("SUB IYl", 2),
    'FD969696': ("SUB (IY-$6A)", 3),
    'FD9C9C9C': ("SBC A,IYh", 2),
    'FD9D9D9D': ("SBC A,IYl", 2),
    'FD9E9E9E': ("SBC A,(IY-$62)", 3),
    'FDA4A4A4': ("AND IYh", 2),
    'FDA5A5A5': ("AND IYl", 2),
    'FDA6A6A6': ("AND (IY-$5A)", 3),
    'FDACACAC': ("XOR IYh", 2),
    'FDADADAD': ("XOR IYl", 2),
    'FDAEAEAE': ("XOR (IY-$52)", 3),
    'FDB4B4B4': ("OR IYh", 2),
    'FDB5B5B5': ("OR IYl", 2),
    'FDB6B6B6': ("OR (IY-$4A)", 3),
    'FDBCBCBC': ("CP IYh", 2),
    'FDBDBDBD': ("CP IYl", 2),
    'FDBEBEBE': ("CP (IY-$42)", 3),
    'FDE1E1E1': ("POP IY", 2),
    'FDE3E3E3': ("EX (SP),IY", 2),
    'FDE5E5E5': ("PUSH IY", 2),
    'FDE9E9E9': ("JP (IY)", 2),
    'FDF9F9F9': ("LD SP,IY", 2),
    'DDCB0000': ("RLC (IX+$00),B", 4),
    'DDCB0101': ("RLC (IX+$01),C", 4),
    'DDCB0202': ("RLC (IX+$02),D", 4),
    'DDCB0303': ("RLC (IX+$03),E", 4),
    'DDCB0404': ("RLC (IX+$04),H", 4),
    'DDCB0505': ("RLC (IX+$05),L", 4),
    'DDCB0606': ("RLC (IX+$06)", 4),
    'DDCB0707': ("RLC (IX+$07),A", 4),
    'DDCB0808': ("RRC (IX+$08),B", 4),
    'DDCB0909': ("RRC (IX+$09),C", 4),
    'DDCB0A0A': ("RRC (IX+$0A),D", 4),
    'DDCB0B0B': ("RRC (IX+$0B),E", 4),
    'DDCB0C0C': ("RRC (IX+$0C),H", 4),
    'DDCB0D0D': ("RRC (IX+$0D),L", 4),
    'DDCB0E0E': ("RRC (IX+$0E)", 4),
    'DDCB0F0F': ("RRC (IX+$0F),A", 4),
    'DDCB1010': ("RL (IX+$10),B", 4),
    'DDCB1111': ("RL (IX+$11),C", 4),
    'DDCB1212': ("RL (IX+$12),D", 4),
    'DDCB1313': ("RL (IX+$13),E", 4),
    'DDCB1414': ("RL (IX+$14),H", 4),
    'DDCB1515': ("RL (IX+$15),L", 4),
    'DDCB1616': ("RL (IX+$16)", 4),
    'DDCB1717': ("RL (IX+$17),A", 4),
    'DDCB1818': ("RR (IX+$18),B", 4),
    'DDCB1919': ("RR (IX+$19),C", 4),
    'DDCB1A1A': ("RR (IX+$1A),D", 4),
    'DDCB1B1B': ("RR (IX+$1B),E", 4),
    'DDCB1C1C': ("RR (IX+$1C),H", 4),
    'DDCB1D1D': ("RR (IX+$1D),L", 4),
    'DDCB1E1E': ("RR (IX+$1E)", 4),
    'DDCB1F1F': ("RR (IX+$1F),A", 4),
    'DDCB2020': ("SLA (IX+$20),B", 4),
    'DDCB2121': ("SLA (IX+$21),C", 4),
    'DDCB2222': ("SLA (IX+$22),D", 4),
    'DDCB2323': ("SLA (IX+$23),E", 4),
    'DDCB2424': ("SLA (IX+$24),H", 4),
    'DDCB2525': ("SLA (IX+$25),L", 4),
    'DDCB2626': ("SLA (IX+$26)", 4),
    'DDCB2727': ("SLA (IX+$27),A", 4),
    'DDCB2828': ("SRA (IX+$28),B", 4),
    'DDCB2929': ("SRA (IX+$29),C", 4),
    'DDCB2A2A': ("SRA (IX+$2A),D", 4),
    'DDCB2B2B': ("SRA (IX+$2B),E", 4),
    'DDCB2C2C': ("SRA (IX+$2C),H", 4),
    'DDCB2D2D': ("SRA (IX+$2D),L", 4),
    'DDCB2E2E': ("SRA (IX+$2E)", 4),
    'DDCB2F2F': ("SRA (IX+$2F),A", 4),
    'DDCB3030': ("SLL (IX+$30),B", 4),
    'DDCB3131': ("SLL (IX+$31),C", 4),
    'DDCB3232': ("SLL (IX+$32),D", 4),
    'DDCB3333': ("SLL (IX+$33),E", 4),
    'DDCB3434': ("SLL (IX+$34),H", 4),
    'DDCB3535': ("SLL (IX+$35),L", 4),
    'DDCB3636': ("SLL (IX+$36)", 4),
    'DDCB3737': ("SLL (IX+$37),A", 4),
    'DDCB3838': ("SRL (IX+$38),B", 4),
    'DDCB3939': ("SRL (IX+$39),C", 4),
    'DDCB3A3A': ("SRL (IX+$3A),D", 4),
    'DDCB3B3B': ("SRL (IX+$3B),E", 4),
    'DDCB3C3C': ("SRL (IX+$3C),H", 4),
    'DDCB3D3D': ("SRL (IX+$3D),L", 4),
    'DDCB3E3E': ("SRL (IX+$3E)", 4),
    'DDCB3F3F': ("SRL (IX+$3F),A", 4),
    'DDCB4040': ("BIT 0,(IX+$40)", 4),
    'DDCB4141': ("BIT 0,(IX+$41)", 4),
    'DDCB4242': ("BIT 0,(IX+$42)", 4),
    'DDCB4343': ("BIT 0,(IX+$43)", 4),
    'DDCB4444': ("BIT 0,(IX+$44)", 4),
    'DDCB4545': ("BIT 0,(IX+$45)", 4),
    'DDCB4646': ("BIT 0,(IX+$46)", 4),
    'DDCB4747': ("BIT 0,(IX+$47)", 4),
    'DDCB4848': ("BIT 1,(IX+$48)", 4),
    'DDCB4949': ("BIT 1,(IX+$49)", 4),
    'DDCB4A4A': ("BIT 1,(IX+$4A)", 4),
    'DDCB4B4B': ("BIT 1,(IX+$4B)", 4),
    'DDCB4C4C': ("BIT 1,(IX+$4C)", 4),
    'DDCB4D4D': ("BIT 1,(IX+$4D)", 4),
    'DDCB4E4E': ("BIT 1,(IX+$4E)", 4),
    'DDCB4F4F': ("BIT 1,(IX+$4F)", 4),
    'DDCB5050': ("BIT 2,(IX+$50)", 4),
    'DDCB5151': ("BIT 2,(IX+$51)", 4),
    'DDCB5252': ("BIT 2,(IX+$52)", 4),
    'DDCB5353': ("BIT 2,(IX+$53)", 4),
    'DDCB5454': ("BIT 2,(IX+$54)", 4),
    'DDCB5555': ("BIT 2,(IX+$55)", 4),
    'DDCB5656': ("BIT 2,(IX+$56)", 4),
    'DDCB5757': ("BIT 2,(IX+$57)", 4),
    'DDCB5858': ("BIT 3,(IX+$58)", 4),
    'DDCB5959': ("BIT 3,(IX+$59)", 4),
    'DDCB5A5A': ("BIT 3,(IX+$5A)", 4),
    'DDCB5B5B': ("BIT 3,(IX+$5B)", 4),
    'DDCB5C5C': ("BIT 3,(IX+$5C)", 4),
    'DDCB5D5D': ("BIT 3,(IX+$5D)", 4),
    'DDCB5E5E': ("BIT 3,(IX+$5E)", 4),
    'DDCB5F5F': ("BIT 3,(IX+$5F)", 4),
    'DDCB6060': ("BIT 4,(IX+$60)", 4),
    'DDCB6161': ("BIT 4,(IX+$61)", 4),
    'DDCB6262': ("BIT 4,(IX+$62)", 4),
    'DDCB6363': ("BIT 4,(IX+$63)", 4),
    'DDCB6464': ("BIT 4,(IX+$64)", 4),
    'DDCB6565': ("BIT 4,(IX+$65)", 4),
    'DDCB6666': ("BIT 4,(IX+$66)", 4),
    'DDCB6767': ("BIT 4,(IX+$67)", 4),
    'DDCB6868': ("BIT 5,(IX+$68)", 4),
    'DDCB6969': ("BIT 5,(IX+$69)", 4),
    'DDCB6A6A': ("BIT 5,(IX+$6A)", 4),
    'DDCB6B6B': ("BIT 5,(IX+$6B)", 4),
    'DDCB6C6C': ("BIT 5,(IX+$6C)", 4),
    'DDCB6D6D': ("BIT 5,(IX+$6D)", 4),
    'DDCB6E6E': ("BIT 5,(IX+$6E)", 4),
    'DDCB6F6F': ("BIT 5,(IX+$6F)", 4),
    'DDCB7070': ("BIT 6,(IX+$70)", 4),
    'DDCB7171': ("BIT 6,(IX+$71)", 4),
    'DDCB7272': ("BIT 6,(IX+$72)", 4),
    'DDCB7373': ("BIT 6,(IX+$73)", 4),
    'DDCB7474': ("BIT 6,(IX+$74)", 4),
    'DDCB7575': ("BIT 6,(IX+$75)", 4),
    'DDCB7676': ("BIT 6,(IX+$76)", 4),
    'DDCB7777': ("BIT 6,(IX+$77)", 4),
    'DDCB7878': ("BIT 7,(IX+$78)", 4),
    'DDCB7979': ("BIT 7,(IX+$79)", 4),
    'DDCB7A7A': ("BIT 7,(IX+$7A)", 4),
    'DDCB7B7B': ("BIT 7,(IX+$7B)", 4),
    'DDCB7C7C': ("BIT 7,(IX+$7C)", 4),
    'DDCB7D7D': ("BIT 7,(IX+$7D)", 4),
    'DDCB7E7E': ("BIT 7,(IX+$7E)", 4),
    'DDCB7F7F': ("BIT 7,(IX+$7F)", 4),
    'DDCB8080': ("RES 0,(IX-$80),B", 4),
    'DDCB8181': ("RES 0,(IX-$7F),C", 4),
    'DDCB8282': ("RES 0,(IX-$7E),D", 4),
    'DDCB8383': ("RES 0,(IX-$7D),E", 4),
    'DDCB8484': ("RES 0,(IX-$7C),H", 4),
    'DDCB8585': ("RES 0,(IX-$7B),L", 4),
    'DDCB8686': ("RES 0,(IX-$7A)", 4),
    'DDCB8787': ("RES 0,(IX-$79),A", 4),
    'DDCB8888': ("RES 1,(IX-$78),B", 4),
    'DDCB8989': ("RES 1,(IX-$77),C", 4),
    'DDCB8A8A': ("RES 1,(IX-$76),D", 4),
    'DDCB8B8B': ("RES 1,(IX-$75),E", 4),
    'DDCB8C8C': ("RES 1,(IX-$74),H", 4),
    'DDCB8D8D': ("RES 1,(IX-$73),L", 4),
    'DDCB8E8E': ("RES 1,(IX-$72)", 4),
    'DDCB8F8F': ("RES 1,(IX-$71),A", 4),
    'DDCB9090': ("RES 2,(IX-$70),B", 4),
    'DDCB9191': ("RES 2,(IX-$6F),C", 4),
    'DDCB9292': ("RES 2,(IX-$6E),D", 4),
    'DDCB9393': ("RES 2,(IX-$6D),E", 4),
    'DDCB9494': ("RES 2,(IX-$6C),H", 4),
    'DDCB9595': ("RES 2,(IX-$6B),L", 4),
    'DDCB9696': ("RES 2,(IX-$6A)", 4),
    'DDCB9797': ("RES 2,(IX-$69),A", 4),
    'DDCB9898': ("RES 3,(IX-$68),B", 4),
    'DDCB9999': ("RES 3,(IX-$67),C", 4),
    'DDCB9A9A': ("RES 3,(IX-$66),D", 4),
    'DDCB9B9B': ("RES 3,(IX-$65),E", 4),
    'DDCB9C9C': ("RES 3,(IX-$64),H", 4),
    'DDCB9D9D': ("RES 3,(IX-$63),L", 4),
    'DDCB9E9E': ("RES 3,(IX-$62)", 4),
    'DDCB9F9F': ("RES 3,(IX-$61),A", 4),
    'DDCBA0A0': ("RES 4,(IX-$60),B", 4),
    'DDCBA1A1': ("RES 4,(IX-$5F),C", 4),
    'DDCBA2A2': ("RES 4,(IX-$5E),D", 4),
    'DDCBA3A3': ("RES 4,(IX-$5D),E", 4),
    'DDCBA4A4': ("RES 4,(IX-$5C),H", 4),
    'DDCBA5A5': ("RES 4,(IX-$5B),L", 4),
    'DDCBA6A6': ("RES 4,(IX-$5A)", 4),
    'DDCBA7A7': ("RES 4,(IX-$59),A", 4),
    'DDCBA8A8': ("RES 5,(IX-$58),B", 4),
    'DDCBA9A9': ("RES 5,(IX-$57),C", 4),
    'DDCBAAAA': ("RES 5,(IX-$56),D", 4),
    'DDCBABAB': ("RES 5,(IX-$55),E", 4),
    'DDCBACAC': ("RES 5,(IX-$54),H", 4),
    'DDCBADAD': ("RES 5,(IX-$53),L", 4),
    'DDCBAEAE': ("RES 5,(IX-$52)", 4),
    'DDCBAFAF': ("RES 5,(IX-$51),A", 4),
    'DDCBB0B0': ("RES 6,(IX-$50),B", 4),
    'DDCBB1B1': ("RES 6,(IX-$4F),C", 4),
    'DDCBB2B2': ("RES 6,(IX-$4E),D", 4),
    'DDCBB3B3': ("RES 6,(IX-$4D),E", 4),
    'DDCBB4B4': ("RES 6,(IX-$4C),H", 4),
    'DDCBB5B5': ("RES 6,(IX-$4B),L", 4),
    'DDCBB6B6': ("RES 6,(IX-$4A)", 4),
    'DDCBB7B7': ("RES 6,(IX-$49),A", 4),
    'DDCBB8B8': ("RES 7,(IX-$48),B", 4),
    'DDCBB9B9': ("RES 7,(IX-$47),C", 4),
    'DDCBBABA': ("RES 7,(IX-$46),D", 4),
    'DDCBBBBB': ("RES 7,(IX-$45),E", 4),
    'DDCBBCBC': ("RES 7,(IX-$44),H", 4),
    'DDCBBDBD': ("RES 7,(IX-$43),L", 4),
    'DDCBBEBE': ("RES 7,(IX-$42)", 4),
    'DDCBBFBF': ("RES 7,(IX-$41),A", 4),
    'DDCBC0C0': ("SET 0,(IX-$40),B", 4),
    'DDCBC1C1': ("SET 0,(IX-$3F),C", 4),
    'DDCBC2C2': ("SET 0,(IX-$3E),D", 4),
    'DDCBC3C3': ("SET 0,(IX-$3D),E", 4),
    'DDCBC4C4': ("SET 0,(IX-$3C),H", 4),
    'DDCBC5C5': ("SET 0,(IX-$3B),L", 4),
    'DDCBC6C6': ("SET 0,(IX-$3A)", 4),
    'DDCBC7C7': ("SET 0,(IX-$39),A", 4),
    'DDCBC8C8': ("SET 1,(IX-$38),B", 4),
    'DDCBC9C9': ("SET 1,(IX-$37),C", 4),
    'DDCBCACA': ("SET 1,(IX-$36),D", 4),
    'DDCBCBCB': ("SET 1,(IX-$35),E", 4),
    'DDCBCCCC': ("SET 1,(IX-$34),H", 4),
    'DDCBCDCD': ("SET 1,(IX-$33),L", 4),
    'DDCBCECE': ("SET 1,(IX-$32)", 4),
    'DDCBCFCF': ("SET 1,(IX-$31),A", 4),
    'DDCBD0D0': ("SET 2,(IX-$30),B", 4),
    'DDCBD1D1': ("SET 2,(IX-$2F),C", 4),
    'DDCBD2D2': ("SET 2,(IX-$2E),D", 4),
    'DDCBD3D3': ("SET 2,(IX-$2D),E", 4),
    'DDCBD4D4': ("SET 2,(IX-$2C),H", 4),
    'DDCBD5D5': ("SET 2,(IX-$2B),L", 4),
    'DDCBD6D6': ("SET 2,(IX-$2A)", 4),
    'DDCBD7D7': ("SET 2,(IX-$29),A", 4),
    'DDCBD8D8': ("SET 3,(IX-$28),B", 4),
    'DDCBD9D9': ("SET 3,(IX-$27),C", 4),
    'DDCBDADA': ("SET 3,(IX-$26),D", 4),
    'DDCBDBDB': ("SET 3,(IX-$25),E", 4),
    'DDCBDCDC': ("SET 3,(IX-$24),H", 4),
    'DDCBDDDD': ("SET 3,(IX-$23),L", 4),
    'DDCBDEDE': ("SET 3,(IX-$22)", 4),
    'DDCBDFDF': ("SET 3,(IX-$21),A", 4),
    'DDCBE0E0': ("SET 4,(IX-$20),B", 4),
    'DDCBE1E1': ("SET 4,(IX-$1F),C", 4),
    'DDCBE2E2': ("SET 4,(IX-$1E),D", 4),
    'DDCBE3E3': ("SET 4,(IX-$1D),E", 4),
    'DDCBE4E4': ("SET 4,(IX-$1C),H", 4),
    'DDCBE5E5': ("SET 4,(IX-$1B),L", 4),
    'DDCBE6E6': ("SET 4,(IX-$1A)", 4),
    'DDCBE7E7': ("SET 4,(IX-$19),A", 4),
    'DDCBE8E8': ("SET 5,(IX-$18),B", 4),
    'DDCBE9E9': ("SET 5,(IX-$17),C", 4),
    'DDCBEAEA': ("SET 5,(IX-$16),D", 4),
    'DDCBEBEB': ("SET 5,(IX-$15),E", 4),
    'DDCBECEC': ("SET 5,(IX-$14),H", 4),
    'DDCBEDED': ("SET 5,(IX-$13),L", 4),
    'DDCBEEEE': ("SET 5,(IX-$12)", 4),
    'DDCBEFEF': ("SET 5,(IX-$11),A", 4),
    'DDCBF0F0': ("SET 6,(IX-$10),B", 4),
    'DDCBF1F1': ("SET 6,(IX-$0F),C", 4),
    'DDCBF2F2': ("SET 6,(IX-$0E),D", 4),
    'DDCBF3F3': ("SET 6,(IX-$0D),E", 4),
    'DDCBF4F4': ("SET 6,(IX-$0C),H", 4),
    'DDCBF5F5': ("SET 6,(IX-$0B),L", 4),
    'DDCBF6F6': ("SET 6,(IX-$0A)", 4),
    'DDCBF7F7': ("SET 6,(IX-$09),A", 4),
    'DDCBF8F8': ("SET 7,(IX-$08),B", 4),
    'DDCBF9F9': ("SET 7,(IX-$07),C", 4),
    'DDCBFAFA': ("SET 7,(IX-$06),D", 4),
    'DDCBFBFB': ("SET 7,(IX-$05),E", 4),
    'DDCBFCFC': ("SET 7,(IX-$04),H", 4),
    'DDCBFDFD': ("SET 7,(IX-$03),L", 4),
    'DDCBFEFE': ("SET 7,(IX-$02)", 4),
    'DDCBFFFF': ("SET 7,(IX-$01),A", 4),
    'FDCB0000': ("RLC (IY+$00),B", 4),
    'FDCB0101': ("RLC (IY+$01),C", 4),
    'FDCB0202': ("RLC (IY+$02),D", 4),
    'FDCB0303': ("RLC (IY+$03),E", 4),
    'FDCB0404': ("RLC (IY+$04),H", 4),
    'FDCB0505': ("RLC (IY+$05),L", 4),
    'FDCB0606': ("RLC (IY+$06)", 4),
    'FDCB0707': ("RLC (IY+$07),A", 4),
    'FDCB0808': ("RRC (IY+$08),B", 4),
    'FDCB0909': ("RRC (IY+$09),C", 4),
    'FDCB0A0A': ("RRC (IY+$0A),D", 4),
    'FDCB0B0B': ("RRC (IY+$0B),E", 4),
    'FDCB0C0C': ("RRC (IY+$0C),H", 4),
    'FDCB0D0D': ("RRC (IY+$0D),L", 4),
    'FDCB0E0E': ("RRC (IY+$0E)", 4),
    'FDCB0F0F': ("RRC (IY+$0F),A", 4),
    'FDCB1010': ("RL (IY+$10),B", 4),
    'FDCB1111': ("RL (IY+$11),C", 4),
    'FDCB1212': ("RL (IY+$12),D", 4),
    'FDCB1313': ("RL (IY+$13),E", 4),
    'FDCB1414': ("RL (IY+$14),H", 4),
    'FDCB1515': ("RL (IY+$15),L", 4),
    'FDCB1616': ("RL (IY+$16)", 4),
    'FDCB1717': ("RL (IY+$17),A", 4),
    'FDCB1818': ("RR (IY+$18),B", 4),
    'FDCB1919': ("RR (IY+$19),C", 4),
    'FDCB1A1A': ("RR (IY+$1A),D", 4),
    'FDCB1B1B': ("RR (IY+$1B),E", 4),
    'FDCB1C1C': ("RR (IY+$1C),H", 4),
    'FDCB1D1D': ("RR (IY+$1D),L", 4),
    'FDCB1E1E': ("RR (IY+$1E)", 4),
    'FDCB1F1F': ("RR (IY+$1F),A", 4),
    'FDCB2020': ("SLA (IY+$20),B", 4),
    'FDCB2121': ("SLA (IY+$21),C", 4),
    'FDCB2222': ("SLA (IY+$22),D", 4),
    'FDCB2323': ("SLA (IY+$23),E", 4),
    'FDCB2424': ("SLA (IY+$24),H", 4),
    'FDCB2525': ("SLA (IY+$25),L", 4),
    'FDCB2626': ("SLA (IY+$26)", 4),
    'FDCB2727': ("SLA (IY+$27),A", 4),
    'FDCB2828': ("SRA (IY+$28),B", 4),
    'FDCB2929': ("SRA (IY+$29),C", 4),
    'FDCB2A2A': ("SRA (IY+$2A),D", 4),
    'FDCB2B2B': ("SRA (IY+$2B),E", 4),
    'FDCB2C2C': ("SRA (IY+$2C),H", 4),
    'FDCB2D2D': ("SRA (IY+$2D),L", 4),
    'FDCB2E2E': ("SRA (IY+$2E)", 4),
    'FDCB2F2F': ("SRA (IY+$2F),A", 4),
    'FDCB3030': ("SLL (IY+$30),B", 4),
    'FDCB3131': ("SLL (IY+$31),C", 4),
    'FDCB3232': ("SLL (IY+$32),D", 4),
    'FDCB3333': ("SLL (IY+$33),E", 4),
    'FDCB3434': ("SLL (IY+$34),H", 4),
    'FDCB3535': ("SLL (IY+$35),L", 4),
    'FDCB3636': ("SLL (IY+$36)", 4),
    'FDCB3737': ("SLL (IY+$37),A", 4),
    'FDCB3838': ("SRL (IY+$38),B", 4),
    'FDCB3939': ("SRL (IY+$39),C", 4),
    'FDCB3A3A': ("SRL (IY+$3A),D", 4),
    'FDCB3B3B': ("SRL (IY+$3B),E", 4),
    'FDCB3C3C': ("SRL (IY+$3C),H", 4),
    'FDCB3D3D': ("SRL (IY+$3D),L", 4),
    'FDCB3E3E': ("SRL (IY+$3E)", 4),
    'FDCB3F3F': ("SRL (IY+$3F),A", 4),
    'FDCB4040': ("BIT 0,(IY+$40)", 4),
    'FDCB4141': ("BIT 0,(IY+$41)", 4),
    'FDCB4242': ("BIT 0,(IY+$42)", 4),
    'FDCB4343': ("BIT 0,(IY+$43)", 4),
    'FDCB4444': ("BIT 0,(IY+$44)", 4),
    'FDCB4545': ("BIT 0,(IY+$45)", 4),
    'FDCB4646': ("BIT 0,(IY+$46)", 4),
    'FDCB4747': ("BIT 0,(IY+$47)", 4),
    'FDCB4848': ("BIT 1,(IY+$48)", 4),
    'FDCB4949': ("BIT 1,(IY+$49)", 4),
    'FDCB4A4A': ("BIT 1,(IY+$4A)", 4),
    'FDCB4B4B': ("BIT 1,(IY+$4B)", 4),
    'FDCB4C4C': ("BIT 1,(IY+$4C)", 4),
    'FDCB4D4D': ("BIT 1,(IY+$4D)", 4),
    'FDCB4E4E': ("BIT 1,(IY+$4E)", 4),
    'FDCB4F4F': ("BIT 1,(IY+$4F)", 4),
    'FDCB5050': ("BIT 2,(IY+$50)", 4),
    'FDCB5151': ("BIT 2,(IY+$51)", 4),
    'FDCB5252': ("BIT 2,(IY+$52)", 4),
    'FDCB5353': ("BIT 2,(IY+$53)", 4),
    'FDCB5454': ("BIT 2,(IY+$54)", 4),
    'FDCB5555': ("BIT 2,(IY+$55)", 4),
    'FDCB5656': ("BIT 2,(IY+$56)", 4),
    'FDCB5757': ("BIT 2,(IY+$57)", 4),
    'FDCB5858': ("BIT 3,(IY+$58)", 4),
    'FDCB5959': ("BIT 3,(IY+$59)", 4),
    'FDCB5A5A': ("BIT 3,(IY+$5A)", 4),
    'FDCB5B5B': ("BIT 3,(IY+$5B)", 4),
    'FDCB5C5C': ("BIT 3,(IY+$5C)", 4),
    'FDCB5D5D': ("BIT 3,(IY+$5D)", 4),
    'FDCB5E5E': ("BIT 3,(IY+$5E)", 4),
    'FDCB5F5F': ("BIT 3,(IY+$5F)", 4),
    'FDCB6060': ("BIT 4,(IY+$60)", 4),
    'FDCB6161': ("BIT 4,(IY+$61)", 4),
    'FDCB6262': ("BIT 4,(IY+$62)", 4),
    'FDCB6363': ("BIT 4,(IY+$63)", 4),
    'FDCB6464': ("BIT 4,(IY+$64)", 4),
    'FDCB6565': ("BIT 4,(IY+$65)", 4),
    'FDCB6666': ("BIT 4,(IY+$66)", 4),
    'FDCB6767': ("BIT 4,(IY+$67)", 4),
    'FDCB6868': ("BIT 5,(IY+$68)", 4),
    'FDCB6969': ("BIT 5,(IY+$69)", 4),
    'FDCB6A6A': ("BIT 5,(IY+$6A)", 4),
    'FDCB6B6B': ("BIT 5,(IY+$6B)", 4),
    'FDCB6C6C': ("BIT 5,(IY+$6C)", 4),
    'FDCB6D6D': ("BIT 5,(IY+$6D)", 4),
    'FDCB6E6E': ("BIT 5,(IY+$6E)", 4),
    'FDCB6F6F': ("BIT 5,(IY+$6F)", 4),
    'FDCB7070': ("BIT 6,(IY+$70)", 4),
    'FDCB7171': ("BIT 6,(IY+$71)", 4),
    'FDCB7272': ("BIT 6,(IY+$72)", 4),
    'FDCB7373': ("BIT 6,(IY+$73)", 4),
    'FDCB7474': ("BIT 6,(IY+$74)", 4),
    'FDCB7575': ("BIT 6,(IY+$75)", 4),
    'FDCB7676': ("BIT 6,(IY+$76)", 4),
    'FDCB7777': ("BIT 6,(IY+$77)", 4),
    'FDCB7878': ("BIT 7,(IY+$78)", 4),
    'FDCB7979': ("BIT 7,(IY+$79)", 4),
    'FDCB7A7A': ("BIT 7,(IY+$7A)", 4),
    'FDCB7B7B': ("BIT 7,(IY+$7B)", 4),
    'FDCB7C7C': ("BIT 7,(IY+$7C)", 4),
    'FDCB7D7D': ("BIT 7,(IY+$7D)", 4),
    'FDCB7E7E': ("BIT 7,(IY+$7E)", 4),
    'FDCB7F7F': ("BIT 7,(IY+$7F)", 4),
    'FDCB8080': ("RES 0,(IY-$80),B", 4),
    'FDCB8181': ("RES 0,(IY-$7F),C", 4),
    'FDCB8282': ("RES 0,(IY-$7E),D", 4),
    'FDCB8383': ("RES 0,(IY-$7D),E", 4),
    'FDCB8484': ("RES 0,(IY-$7C),H", 4),
    'FDCB8585': ("RES 0,(IY-$7B),L", 4),
    'FDCB8686': ("RES 0,(IY-$7A)", 4),
    'FDCB8787': ("RES 0,(IY-$79),A", 4),
    'FDCB8888': ("RES 1,(IY-$78),B", 4),
    'FDCB8989': ("RES 1,(IY-$77),C", 4),
    'FDCB8A8A': ("RES 1,(IY-$76),D", 4),
    'FDCB8B8B': ("RES 1,(IY-$75),E", 4),
    'FDCB8C8C': ("RES 1,(IY-$74),H", 4),
    'FDCB8D8D': ("RES 1,(IY-$73),L", 4),
    'FDCB8E8E': ("RES 1,(IY-$72)", 4),
    'FDCB8F8F': ("RES 1,(IY-$71),A", 4),
    'FDCB9090': ("RES 2,(IY-$70),B", 4),
    'FDCB9191': ("RES 2,(IY-$6F),C", 4),
    'FDCB9292': ("RES 2,(IY-$6E),D", 4),
    'FDCB9393': ("RES 2,(IY-$6D),E", 4),
    'FDCB9494': ("RES 2,(IY-$6C),H", 4),
    'FDCB9595': ("RES 2,(IY-$6B),L", 4),
    'FDCB9696': ("RES 2,(IY-$6A)", 4),
    'FDCB9797': ("RES 2,(IY-$69),A", 4),
    'FDCB9898': ("RES 3,(IY-$68),B", 4),
    'FDCB9999': ("RES 3,(IY-$67),C", 4),
    'FDCB9A9A': ("RES 3,(IY-$66),D", 4),
    'FDCB9B9B': ("RES 3,(IY-$65),E", 4),
    'FDCB9C9C': ("RES 3,(IY-$64),H", 4),
    'FDCB9D9D': ("RES 3,(IY-$63),L", 4),
    'FDCB9E9E': ("RES 3,(IY-$62)", 4),
    'FDCB9F9F': ("RES 3,(IY-$61),A", 4),
    'FDCBA0A0': ("RES 4,(IY-$60),B", 4),
    'FDCBA1A1': ("RES 4,(IY-$5F),C", 4),
    'FDCBA2A2': ("RES 4,(IY-$5E),D", 4),
    'FDCBA3A3': ("RES 4,(IY-$5D),E", 4),
    'FDCBA4A4': ("RES 4,(IY-$5C),H", 4),
    'FDCBA5A5': ("RES 4,(IY-$5B),L", 4),
    'FDCBA6A6': ("RES 4,(IY-$5A)", 4),
    'FDCBA7A7': ("RES 4,(IY-$59),A", 4),
    'FDCBA8A8': ("RES 5,(IY-$58),B", 4),
    'FDCBA9A9': ("RES 5,(IY-$57),C", 4),
    'FDCBAAAA': ("RES 5,(IY-$56),D", 4),
    'FDCBABAB': ("RES 5,(IY-$55),E", 4),
    'FDCBACAC': ("RES 5,(IY-$54),H", 4),
    'FDCBADAD': ("RES 5,(IY-$53),L", 4),
    'FDCBAEAE': ("RES 5,(IY-$52)", 4),
    'FDCBAFAF': ("RES 5,(IY-$51),A", 4),
    'FDCBB0B0': ("RES 6,(IY-$50),B", 4),
    'FDCBB1B1': ("RES 6,(IY-$4F),C", 4),
    'FDCBB2B2': ("RES 6,(IY-$4E),D", 4),
    'FDCBB3B3': ("RES 6,(IY-$4D),E", 4),
    'FDCBB4B4': ("RES 6,(IY-$4C),H", 4),
    'FDCBB5B5': ("RES 6,(IY-$4B),L", 4),
    'FDCBB6B6': ("RES 6,(IY-$4A)", 4),
    'FDCBB7B7': ("RES 6,(IY-$49),A", 4),
    'FDCBB8B8': ("RES 7,(IY-$48),B", 4),
    'FDCBB9B9': ("RES 7,(IY-$47),C", 4),
    'FDCBBABA': ("RES 7,(IY-$46),D", 4),
    'FDCBBBBB': ("RES 7,(IY-$45),E", 4),
    'FDCBBCBC': ("RES 7,(IY-$44),H", 4),
    'FDCBBDBD': ("RES 7,(IY-$43),L", 4),
    'FDCBBEBE': ("RES 7,(IY-$42)", 4),
    'FDCBBFBF': ("RES 7,(IY-$41),A", 4),
    'FDCBC0C0': ("SET 0,(IY-$40),B", 4),
    'FDCBC1C1': ("SET 0,(IY-$3F),C", 4),
    'FDCBC2C2': ("SET 0,(IY-$3E),D", 4),
    'FDCBC3C3': ("SET 0,(IY-$3D),E", 4),
    'FDCBC4C4': ("SET 0,(IY-$3C),H", 4),
    'FDCBC5C5': ("SET 0,(IY-$3B),L", 4),
    'FDCBC6C6': ("SET 0,(IY-$3A)", 4),
    'FDCBC7C7': ("SET 0,(IY-$39),A", 4),
    'FDCBC8C8': ("SET 1,(IY-$38),B", 4),
    'FDCBC9C9': ("SET 1,(IY-$37),C", 4),
    'FDCBCACA': ("SET 1,(IY-$36),D", 4),
    'FDCBCBCB': ("SET 1,(IY-$35),E", 4),
    'FDCBCCCC': ("SET 1,(IY-$34),H", 4),
    'FDCBCDCD': ("SET 1,(IY-$33),L", 4),
    'FDCBCECE': ("SET 1,(IY-$32)", 4),
    'FDCBCFCF': ("SET 1,(IY-$31),A", 4),
    'FDCBD0D0': ("SET 2,(IY-$30),B", 4),
    'FDCBD1D1': ("SET 2,(IY-$2F),C", 4),
    'FDCBD2D2': ("SET 2,(IY-$2E),D", 4),
    'FDCBD3D3': ("SET 2,(IY-$2D),E", 4),
    'FDCBD4D4': ("SET 2,(IY-$2C),H", 4),
    'FDCBD5D5': ("SET 2,(IY-$2B),L", 4),
    'FDCBD6D6': ("SET 2,(IY-$2A)", 4),
    'FDCBD7D7': ("SET 2,(IY-$29),A", 4),
    'FDCBD8D8': ("SET 3,(IY-$28),B", 4),
    'FDCBD9D9': ("SET 3,(IY-$27),C", 4),
    'FDCBDADA': ("SET 3,(IY-$26),D", 4),
    'FDCBDBDB': ("SET 3,(IY-$25),E", 4),
    'FDCBDCDC': ("SET 3,(IY-$24),H", 4),
    'FDCBDDDD': ("SET 3,(IY-$23),L", 4),
    'FDCBDEDE': ("SET 3,(IY-$22)", 4),
    'FDCBDFDF': ("SET 3,(IY-$21),A", 4),
    'FDCBE0E0': ("SET 4,(IY-$20),B", 4),
    'FDCBE1E1': ("SET 4,(IY-$1F),C", 4),
    'FDCBE2E2': ("SET 4,(IY-$1E),D", 4),
    'FDCBE3E3': ("SET 4,(IY-$1D),E", 4),
    'FDCBE4E4': ("SET 4,(IY-$1C),H", 4),
    'FDCBE5E5': ("SET 4,(IY-$1B),L", 4),
    'FDCBE6E6': ("SET 4,(IY-$1A)", 4),
    'FDCBE7E7': ("SET 4,(IY-$19),A", 4),
    'FDCBE8E8': ("SET 5,(IY-$18),B", 4),
    'FDCBE9E9': ("SET 5,(IY-$17),C", 4),
    'FDCBEAEA': ("SET 5,(IY-$16),D", 4),
    'FDCBEBEB': ("SET 5,(IY-$15),E", 4),
    'FDCBECEC': ("SET 5,(IY-$14),H", 4),
    'FDCBEDED': ("SET 5,(IY-$13),L", 4),
    'FDCBEEEE': ("SET 5,(IY-$12)", 4),
    'FDCBEFEF': ("SET 5,(IY-$11),A", 4),
    'FDCBF0F0': ("SET 6,(IY-$10),B", 4),
    'FDCBF1F1': ("SET 6,(IY-$0F),C", 4),
    'FDCBF2F2': ("SET 6,(IY-$0E),D", 4),
    'FDCBF3F3': ("SET 6,(IY-$0D),E", 4),
    'FDCBF4F4': ("SET 6,(IY-$0C),H", 4),
    'FDCBF5F5': ("SET 6,(IY-$0B),L", 4),
    'FDCBF6F6': ("SET 6,(IY-$0A)", 4),
    'FDCBF7F7': ("SET 6,(IY-$09),A", 4),
    'FDCBF8F8': ("SET 7,(IY-$08),B", 4),
    'FDCBF9F9': ("SET 7,(IY-$07),C", 4),
    'FDCBFAFA': ("SET 7,(IY-$06),D", 4),
    'FDCBFBFB': ("SET 7,(IY-$05),E", 4),
    'FDCBFCFC': ("SET 7,(IY-$04),H", 4),
    'FDCBFDFD': ("SET 7,(IY-$03),L", 4),
    'FDCBFEFE': ("SET 7,(IY-$02)", 4),
    'FDCBFFFF': ("SET 7,(IY-$01),A", 4),
}

class DisassembleTest(SkoolKitTestCase):
    def _test_instructions(self, opcodes, addr, base=16):
        if base == 10:
            p = b = w = ''
        else:
            p, b, w = '$', '02X', '04X'
        memory = [0] * 65536
        for h, (exp_operation, exp_size) in opcodes.items():
            a = addr
            for i in range(0, len(h), 2):
                memory[a] = int(h[i:i + 2], 16)
                a = (a + 1) % 65536
            operation, size = disassemble(memory, addr, p, b, w)
            self.assertEqual(operation, exp_operation, f'Operation mismatch for {h}')
            self.assertEqual(size, exp_size, f'Size mismatch for {h} ({operation})')

    def test_all_instructions_hex(self):
        self._test_instructions(OPCODES_HEX, 0)

    def test_all_instructions_decimal(self):
        self._test_instructions(OPCODES_DEC, 0, 10)

    def test_instructions_at_65535(self):
        opcodes = {h: (op, size) for h, (op, size) in OPCODES_HEX.items() if size > 1}
        opcodes.update({
            '10FE1010': ("DJNZ $FFFF", 2),
            '18181818': ("JR $0019", 2),
            '20202020': ("JR NZ,$0021", 2),
            '28282828': ("JR Z,$0029", 2),
            '30303030': ("JR NC,$0031", 2),
            '38383838': ("JR C,$0039", 2),
        })
        self._test_instructions(opcodes, 65535)

    def test_instructions_at_65534(self):
        opcodes = {h: (op, size) for h, (op, size) in OPCODES_HEX.items() if size > 2}
        self._test_instructions(opcodes, 65534)

    def test_instructions_at_65533(self):
        opcodes = {h: (op, size) for h, (op, size) in OPCODES_HEX.items() if size > 3}
        self._test_instructions(opcodes, 65533)
