from typing import NamedTuple, Optional, Union, List


class KafkaConfig(NamedTuple):
    """
    Конфигурация для работы с apache kafka.
    input_topic - топик из которого consumer забирает данные для работы

    group_id - идентификатор, по которому будет отслеживаться offset (сдвиг).
    По нему будет отслеживаться история обработки данных и предотвращаться повторённая обработка.
    **Общий для всех экземпляров** приложения

    bootstrap_servers - перечень адресов для подключения к apache kafka.
    Как правило, запускается как минимум 3 ноды. Ваше приложение будет работать даже если
     вы укажете только 1 адрес для подключения, однако это может привести к дисбалансу в работе

    output_topic - топик, в который будут передаваться обработнные producer'ом данные
    """
    input_topic: Optional[str]
    group_id: Optional[str]
    bootstrap_servers: Union[List[str], str]
    output_topic: Optional[str] = None
