# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['schemathesis',
 'schemathesis.cli',
 'schemathesis.cli.output',
 'schemathesis.extra',
 'schemathesis.fixups',
 'schemathesis.runner',
 'schemathesis.runner.impl',
 'schemathesis.specs',
 'schemathesis.specs.graphql',
 'schemathesis.specs.openapi',
 'schemathesis.specs.openapi.expressions']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=19.1,<20.0',
 'click>=7.0,<8.0',
 'hypothesis>=5.15,<6.0',
 'hypothesis_graphql>=0.3',
 'hypothesis_jsonschema>=0.17.0,<1.0',
 'jsonschema>=3.0.0,<4.0.0',
 'junit-xml>=1.9,<2.0',
 'pytest-subtests>=0.2.1,<1.0',
 'pytest>4.6.4',
 'pyyaml>=5.1,<6.0',
 'requests>=2.22,<3.0',
 'starlette>=0.13.2,<0.14.0',
 'werkzeug>0.16.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.1,<2.0']}

entry_points = \
{'console_scripts': ['schemathesis = schemathesis.cli:schemathesis'],
 'pytest11': ['schemathesis = schemathesis.extra.pytest_plugin']}

setup_kwargs = {
    'name': 'schemathesis',
    'version': '2.5.1',
    'description': 'Property-based testing framework for Open API and GraphQL based apps',
    'long_description': 'Schemathesis\n============\n\n|Build| |Coverage| |Version| |Python versions| |Docs| |Chat| |License|\n\nSchemathesis is a modern API testing tool for web applications built with Open API and GraphQL specifications.\n\nIt reads the application schema and generates test cases, which will ensure that your application is compliant with its schema.\n\nSimple to use and yet powerful to uncover hard-to-find errors thanks to the property-based testing approach backed by state-of-the-art `Hypothesis <http://hypothesis.works/>`_ library.\n\nThe application under test could be written in any language; the only thing you need is a valid API schema in a supported format.\n\nFeatures\n--------\n\n- Content-Type, schema, and status code conformance checks for Open API;\n- Testing of explicit examples from the input schema;\n- Stateful testing via Open API links;\n- Concurrent test execution;\n- Targeted testing;\n- Storing and replaying network requests;\n- Built-in ASGI / WSGI application support;\n- Ready-to-go Docker image;\n- Configurable with user-defined checks, string formats, hooks, and targets.\n\nInstallation\n------------\n\nTo install Schemathesis via ``pip`` run the following command:\n\n.. code:: bash\n\n    pip install schemathesis\n\nUsage\n-----\n\nYou can use Schemathesis in the command line:\n\n.. code:: bash\n\n  schemathesis run --stateful=links --checks all http://0.0.0.0:8081/schema.yaml\n\n.. image:: https://github.com/schemathesis/schemathesis/blob/master/img/schemathesis.gif\n\nOr in your Python tests:\n\n.. code:: python\n\n    import schemathesis\n\n    schema = schemathesis.from_uri("http://example.com/swagger.json")\n\n    @schema.parametrize()\n    def test_api(case):\n        response = case.call()\n        case.validate_response(response)\n\nCLI is pretty simple to use and requires no coding; the in-code approach gives more flexibility.\n\nContributing\n------------\n\nAny contribution to development, testing, or any other area is highly appreciated and useful to the project.\nFor guidance on how to contribute to Schemathesis, see the `contributing guidelines <https://github.com/schemathesis/schemathesis/blob/master/CONTRIBUTING.rst>`_.\n\n**Please, help us to improve!**\n\nWe\'d kindly ask you to share your experience with Schemathesis. It will help me to make improvements to it and prioritize new features!\nIt will take 5 minutes. The results are anonymous.\n\n**Survey**: https://forms.gle/dv4s5SXAYWzvuwFWA\n\nSupport\n-------\n\nHi, my name is Dmitry! I started this project during my work at `Kiwi.com <https://kiwi.com/>`_. I am grateful to them for all the support they\nprovided to this project during its early days and for the opportunity to evolve Schemathesis independently.\n\nIn order to grow the community of contributors and users, and allow me to devote more time to this project, please `donate today <https://github.com/sponsors/Stranger6667>`_.\n\nAlso, I occasionally write posts about Schemathesis in `my blog <https://dygalo.dev/>`_ and offer consulting services for businesses.\n\nLinks\n-----\n\n- **Documentation**: https://schemathesis.readthedocs.io/en/stable/\n- **Releases**: https://pypi.org/project/schemathesis/\n- **Code**: https://github.com/schemathesis/schemathesis\n- **Issue tracker**: https://github.com/schemathesis/schemathesis/issues\n- **Chat**: https://gitter.im/kiwicom/schemathesis\n\nAdditional content:\n\n- `An article <https://dygalo.dev/blog/schemathesis-property-based-testing-for-api-schemas/>`_ about Schemathesis by **@Stranger6667**\n- `A video <https://youtu.be/1lo7idI7uq8>`_ from FlaskCon 2020 by **@hultner**\n\nLicense\n-------\n\nThe code in this project is licensed under `MIT license`_.\nBy contributing to Schemathesis, you agree that your contributions will be licensed under its MIT license.\n\n.. |Build| image:: https://github.com/schemathesis/schemathesis/workflows/build/badge.svg\n   :target: https://github.com/schemathesis/schemathesis/actions\n.. |Coverage| image:: https://codecov.io/gh/schemathesis/schemathesis/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/schemathesis/schemathesis/branch/master\n   :alt: codecov.io status for master branch\n.. |Version| image:: https://img.shields.io/pypi/v/schemathesis.svg\n   :target: https://pypi.org/project/schemathesis/\n.. |Python versions| image:: https://img.shields.io/pypi/pyversions/schemathesis.svg\n   :target: https://pypi.org/project/schemathesis/\n.. |License| image:: https://img.shields.io/pypi/l/schemathesis.svg\n   :target: https://opensource.org/licenses/MIT\n.. |Chat| image:: https://img.shields.io/gitter/room/kiwicom/schemathesis.svg\n   :target: https://gitter.im/kiwicom/schemathesis\n   :alt: Gitter\n.. |Docs| image:: https://readthedocs.org/projects/schemathesis/badge/?version=stable\n   :target: https://schemathesis.readthedocs.io/en/stable/?badge=stable\n   :alt: Documentation Status\n\n.. _MIT license: https://opensource.org/licenses/MIT\n',
    'author': 'Dmitry Dygalo',
    'author_email': 'dadygalo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/schemathesis/schemathesis',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
