# coding: utf-8

"""
    DLRN API

    DLRN API client

    OpenAPI spec version: 1.0.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import


# python 2 and python 3 compatibility library
from six import iteritems

from dlrnapi_client.api_client import ApiClient
from dlrnapi_client.configuration import Configuration


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def api_last_tested_repo_get(self, params, **kwargs):
        """Get the last tested repo since a specific time.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_last_tested_repo_get(params,
                                                  callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params params: The JSON params to post (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_last_tested_repo_get_with_http_info(params,
                                                                **kwargs)
        else:
            (data) = self.api_last_tested_repo_get_with_http_info(params,
                                                                  **kwargs)
            return data

    def api_last_tested_repo_get_with_http_info(self, params, **kwargs):
        """Get the last tested repo since a specific time.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_last_tested_repo_get_with_http_info(params,
                                                                 callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params params: The JSON params to post (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_last_tested_repo_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_last_tested_repo_get`")

        collection_formats = {}

        resource_path = '/api/last_tested_repo'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            # FIXME(jpena): we should deprecate in-body params in the future
            body_params = params['params']
            # Use in-URL params, too
            query_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Repo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_last_tested_repo_post(self, params, **kwargs):
        """Get the last tested repo since a specific time

        (optionally for a CI job), and add an \"in progress\" entry in the CI
        job table for this.

        If a job_id is specified, the order of precedence for the repo returned
        is:

        - The last tested repo within that timeframe for that CI job.
        - The last tested repo within that timeframe for any CI job, so we can
          have several CIs converge on a single repo.
        - The last \"consistent\" repo, if no repo has been tested in the
          timeframe.

        If ``sequential_mode`` is set to true, a different algorithm is used.
        Another parameter ``previous_job_id`` needs to be specified, and the
        order of precedence for the repo returned is:
        - The last tested repo within that timeframe for the CI job described
          by ``previous_job_id``.
        - If no repo for ``previous_job_id`` is found, an error will be
          returned
        The sequential mode is meant to be used by CI pipelines, where a CI (n)
        job needs to use the same repo tested by CI (n-1).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_last_tested_repo_post(params,
                                                   callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params1 params: The JSON params to post (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_last_tested_repo_post_with_http_info(params,
                                                                 **kwargs)
        else:
            (data) = self.api_last_tested_repo_post_with_http_info(params,
                                                                   **kwargs)
            return data

    def api_last_tested_repo_post_with_http_info(self, params, **kwargs):
        """Get the last tested repo since a specific time

        (optionally for a CI job), and add an \"in progress\" entry in the CI
        job table for this.

        If a job_id is specified, the order of precedence for the repo returned
        is:

        - The last tested repo within that timeframe for that CI job.
        - The last tested repo within that timeframe for any CI job, so we can
          have several CIs converge on a single repo.
        - The last \"consistent\" repo, if no repo has been tested in the
          timeframe.

        If ``sequential_mode`` is set to true, a different algorithm is used.
        Another parameter ``previous_job_id`` needs to be specified, and the
        order of precedence for the repo returned is:
        - The last tested repo within that timeframe for the CI job described
          by ``previous_job_id``.
        - If no repo for ``previous_job_id`` is found, an error will be
          returned
        The sequential mode is meant to be used by CI pipelines, where a CI (n)
        job needs to use the same repo tested by CI (n-1).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_last_tested_repo_post_with_http_info(params,
                                                    callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params1 params: The JSON params to post (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_last_tested_repo_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_last_tested_repo_post`")

        collection_formats = {}

        resource_path = '/api/last_tested_repo'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Repo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_promote_post(self, params, **kwargs):
        """Promote a repository.

        This can be implemented as a local symlink creation in the DLRN worker,
        or any other form in the future.  Note the API will refuse to promote
        using promote_name=\"consistent\" or \"current\", since those are
        reserved keywords for DLRN.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promote_post(params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Promotion params: The JSON params to post (required)
        :return: Promotion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_promote_post_with_http_info(params, **kwargs)
        else:
            (data) = self.api_promote_post_with_http_info(params, **kwargs)
            return data

    def api_promote_post_with_http_info(self, params, **kwargs):
        """Promote a repository.

        This can be implemented as a local symlink creation in the DLRN worker,
        or any other form in the future.  Note the API will refuse to promote
        using promote_name=\"consistent\" or \"current\", since those are
        reserved keywords for DLRN.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promote_post_with_http_info(params,
                                                     callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Promotion params: The JSON params to post (required)
        :return: Promotion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_promote_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_promote_post`")

        collection_formats = {}

        resource_path = '/api/promote'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Promotion',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_promote_batch_post(self, params, **kwargs):
        """Atomically promote a list of repositories.

        This is the equivalent of calling api_promote_post multiple times, one
        with each commit/distro_hash combination. The only difference is that
        the call is atomic, and when components are enabled, the aggregated
        repo files are only updated once.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promote_batch_post(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param  list[Promotion] params: The JSON params to post (required)
        :return: Promotion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_promote_batch_post_with_http_info(params, **kwargs)
        else:
            (data) = self.api_promote_batch_post_with_http_info(params,
                                                                **kwargs)
            return data

    def api_promote_batch_post_with_http_info(self, params, **kwargs):
        """Atomically promote a list of repositories.

        This is the equivalent of calling api_promote_post multiple times, one
        with each commit/distro_hash combination. The only difference is that
        the call is atomic, and when components are enabled, the aggregated
        repo files are only updated once.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promote_batch_post_with_http_info(params,
                                                               callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param  list[Promotion] params: The JSON params to post (required)
        :return: Promotion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_promote_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_promote_post`")

        collection_formats = {}

        resource_path = '/api/promote-batch'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Promotion',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_remote_import_post(self, params, **kwargs):
        """Import a commit built by another instance.

        This API call mimics the behavior of the ``dlrn-remote`` command,
        with the only exception of not being able to specify a custom
        rdoinfo location.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_remote_import_post(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ModelImport params: The JSON params to post (required)
        :return: ModelImport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_remote_import_post_with_http_info(params, **kwargs)
        else:
            (data) = self.api_remote_import_post_with_http_info(params,
                                                                **kwargs)
            return data

    def api_remote_import_post_with_http_info(self, params, **kwargs):
        """Import a commit built by another instance.

        This API call mimics the behavior of the ``dlrn-remote`` command,
        with the only exception of not being able to specify a custom
        rdoinfo location.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_remote_import_post_with_http_info(params,
                                                   callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ModelImport params: The JSON params to post (required)
        :return: ModelImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_remote_import_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_remote_import_post`")

        collection_formats = {}

        resource_path = '/api/remote/import'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ModelImport',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_repo_status_get(self, params, **kwargs):
        """Get all the CI reports for a specific repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_repo_status_get(params,
                                             callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params2 params: The JSON params to post (required)
        :return: list[CIVote]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_repo_status_get_with_http_info(params, **kwargs)
        else:
            (data) = self.api_repo_status_get_with_http_info(params, **kwargs)
            return data

    def api_repo_status_get_with_http_info(self, params, **kwargs):
        """Get all the CI reports for a specific repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_repo_status_get_with_http_info(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params2 params: The JSON params to post (required)
        :return: list[CIVote]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_repo_status_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_repo_status_get`")

        collection_formats = {}

        resource_path = '/api/repo_status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            # FIXME(jpena): we should deprecate in-body params in the future
            body_params = params['params']
            # Use in-URL params, too
            query_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[CIVote]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_agg_status_get(self, params, **kwargs):
        """Get all the CI reports for a specific aggregated repo.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_agg_status_get(params,
                                             callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AggQuery params: The JSON params to post (required)
        :return: list[CIAggVote]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_agg_status_get_with_http_info(params, **kwargs)
        else:
            (data) = self.api_agg_status_get_with_http_info(params, **kwargs)
            return data

    def api_agg_status_get_with_http_info(self, params, **kwargs):
        """Get all the CI reports for a specific aggregated repo.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_agg_status_get_with_http_info(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AggQuery params: The JSON params to post (required)
        :return: list[CIAggVote]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_agg_status_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_agg_status_get`")

        collection_formats = {}

        resource_path = '/api/agg_status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            # FIXME(jpena): we should deprecate in-body params in the future
            body_params = params['params']
            # Use in-URL params, too
            query_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[CIAggVote]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_report_result_post(self, params, **kwargs):
        """Report the result of a CI job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_report_result_post(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params3 params: The JSON params to post (required)
        :return: CIVote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_report_result_post_with_http_info(params, **kwargs)
        else:
            (data) = self.api_report_result_post_with_http_info(params,
                                                                **kwargs)
            return data

    def api_report_result_post_with_http_info(self, params, **kwargs):
        """Report the result of a CI job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_report_result_post_with_http_info(params,
                                                    callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Params3 params: The JSON params to post (required)
        :return: CIVote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_report_result_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_report_result_post`")

        collection_formats = {}

        resource_path = '/api/report_result'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CIVote',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_promotions_get(self, params, **kwargs):
        """Get promotions, optionally for a specific repository or promotion
        name.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promotions_get(params,
                                             callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Promotion params: The JSON params to post (required)
        :return: list[Promotion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_promotions_get_with_http_info(params, **kwargs)
        else:
            (data) = self.api_promotions_get_with_http_info(params, **kwargs)
            return data

    def api_promotions_get_with_http_info(self, params, **kwargs):
        """Get all the CI reports for a specific repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promotions_get_with_http_info(params,
                                                callback=callback_function)


        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Promotion params: The JSON params to post (required)
        :return: list[Promotion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_promotions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_promotions_get`")

        collection_formats = {}

        resource_path = '/api/promotions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            # FIXME(jpena): we should deprecate in-body params in the future
            body_params = params['params']
            # Use in-URL params, too
            query_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Promotion]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)

    def api_build_metrics_get(self, params, **kwargs):
        """Get build metrics, optionally for a specific package name.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_build_metrics_get(params,
                                               callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MetricRequest params: The JSON params to post (required)
        :return: Metrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.api_build_metrics_get_with_http_info(params, **kwargs)
        else:
            (data) = self.api_build_metrics_get_with_http_info(params,
                                                               **kwargs)
            return data

    def api_build_metrics_get_with_http_info(self, params, **kwargs):
        """Get build metrics, optionally for a specific package name.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.api_promotions_get_with_http_info(params,
                                                callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MetricRequest params: The JSON params to post (required)
        :return: Metrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_build_metrics_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params) or (params['params'] is None):
            raise ValueError("Missing the required parameter `params` when "
                             "calling `api_build_metrics_get`")

        collection_formats = {}

        resource_path = '/api/metrics/builds'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'params' in params:
            # FIXME(jpena): we should deprecate in-body params in the future
            body_params = params['params']
            # Use in-URL params, too
            query_params = params['params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Metrics',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get(
                                            '_return_http_data_only'),
                                        _preload_content=params.get(
                                            '_preload_content', True),
                                        _request_timeout=params.get(
                                            '_request_timeout'),
                                        collection_formats=collection_formats)
