import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

from .. import (
    Component as _Component_2b0ad27f,
    Project as _Project_57d89203,
    Task as _Task_9fa875b6,
)
from ..github import GitIdentity as _GitIdentity_6effc3de
from ..github.workflows import (
    ContainerOptions as _ContainerOptions_f50907af,
    Job as _Job_20ffcf45,
    JobDefaults as _JobDefaults_965f0d10,
    JobPermissions as _JobPermissions_3b5b53dc,
    JobStep as _JobStep_c3287c05,
    JobStepOutput as _JobStepOutput_acebe827,
    JobStrategy as _JobStrategy_15089712,
    Tools as _Tools_75b93a2a,
)


class BuildWorkflow(
    _Component_2b0ad27f,
    metaclass=jsii.JSIIMeta,
    jsii_type="projen.build.BuildWorkflow",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        project: _Project_57d89203,
        *,
        artifacts_directory: builtins.str,
        build_task: _Task_9fa875b6,
        antitamper: typing.Optional[builtins.bool] = None,
        container_image: typing.Optional[builtins.str] = None,
        env: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        git_identity: typing.Optional[_GitIdentity_6effc3de] = None,
        mutable_build: typing.Optional[builtins.bool] = None,
        post_build_steps: typing.Optional[typing.Sequence[_JobStep_c3287c05]] = None,
        pre_build_steps: typing.Optional[typing.Sequence[_JobStep_c3287c05]] = None,
    ) -> None:
        '''
        :param project: -
        :param artifacts_directory: (experimental) A name of a directory that includes build artifacts.
        :param build_task: (experimental) The task to execute in order to build the project.
        :param antitamper: (experimental) Enable anti-tamper check. Default: true
        :param container_image: (experimental) The container image to use for builds. Default: - the default workflow container
        :param env: (experimental) Build environment variables. Default: {}
        :param git_identity: (experimental) Git identity to use for the workflow. Default: - default identity
        :param mutable_build: (experimental) Automatically update files modified during builds to pull-request branches. This means that any files synthesized by projen or e.g. test snapshots will always be up-to-date before a PR is merged. Implies that PR builds do not have anti-tamper checks. Default: true
        :param post_build_steps: (experimental) Steps to execute after build. Default: []
        :param pre_build_steps: (experimental) Steps to execute before the build. Default: []

        :stability: experimental
        '''
        options = BuildWorkflowOptions(
            artifacts_directory=artifacts_directory,
            build_task=build_task,
            antitamper=antitamper,
            container_image=container_image,
            env=env,
            git_identity=git_identity,
            mutable_build=mutable_build,
            post_build_steps=post_build_steps,
            pre_build_steps=pre_build_steps,
        )

        jsii.create(self.__class__, self, [project, options])

    @jsii.member(jsii_name="addPostBuildJob")
    def add_post_build_job(
        self,
        id: builtins.str,
        *,
        permissions: _JobPermissions_3b5b53dc,
        runs_on: typing.Sequence[builtins.str],
        steps: typing.Sequence[_JobStep_c3287c05],
        concurrency: typing.Any = None,
        container: typing.Optional[_ContainerOptions_f50907af] = None,
        continue_on_error: typing.Optional[builtins.bool] = None,
        defaults: typing.Optional[_JobDefaults_965f0d10] = None,
        env: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        environment: typing.Any = None,
        if_: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        needs: typing.Optional[typing.Sequence[builtins.str]] = None,
        outputs: typing.Optional[typing.Mapping[builtins.str, _JobStepOutput_acebe827]] = None,
        services: typing.Optional[typing.Mapping[builtins.str, _ContainerOptions_f50907af]] = None,
        strategy: typing.Optional[_JobStrategy_15089712] = None,
        timeout_minutes: typing.Optional[jsii.Number] = None,
        tools: typing.Optional[_Tools_75b93a2a] = None,
    ) -> None:
        '''(experimental) Adds another job to the build workflow which is executed after the build job succeeded.

        :param id: The id of the new job.
        :param permissions: (experimental) You can modify the default permissions granted to the GITHUB_TOKEN, adding or removing access as required, so that you only allow the minimum required access. Use ``{ contents: READ }`` if your job only needs to clone code. This is intentionally a required field since it is required in order to allow workflows to run in GitHub repositories with restricted default access.
        :param runs_on: (experimental) The type of machine to run the job on. The machine can be either a GitHub-hosted runner or a self-hosted runner.
        :param steps: (experimental) A job contains a sequence of tasks called steps. Steps can run commands, run setup tasks, or run an action in your repository, a public repository, or an action published in a Docker registry. Not all steps run actions, but all actions run as a step. Each step runs in its own process in the runner environment and has access to the workspace and filesystem. Because steps run in their own process, changes to environment variables are not preserved between steps. GitHub provides built-in steps to set up and complete a job.
        :param concurrency: (experimental) Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time. A concurrency group can be any string or expression. The expression can use any context except for the secrets context.
        :param container: (experimental) A container to run any steps in a job that don't already specify a container. If you have steps that use both script and container actions, the container actions will run as sibling containers on the same network with the same volume mounts.
        :param continue_on_error: (experimental) Prevents a workflow run from failing when a job fails. Set to true to allow a workflow run to pass when this job fails.
        :param defaults: (experimental) A map of default settings that will apply to all steps in the job. You can also set default settings for the entire workflow.
        :param env: (experimental) A map of environment variables that are available to all steps in the job. You can also set environment variables for the entire workflow or an individual step.
        :param environment: (experimental) The environment that the job references. All environment protection rules must pass before a job referencing the environment is sent to a runner.
        :param if_: (experimental) You can use the if conditional to prevent a job from running unless a condition is met. You can use any supported context and expression to create a conditional.
        :param name: (experimental) The name of the job displayed on GitHub.
        :param needs: (experimental) Identifies any jobs that must complete successfully before this job will run. It can be a string or array of strings. If a job fails, all jobs that need it are skipped unless the jobs use a conditional expression that causes the job to continue.
        :param outputs: (experimental) A map of outputs for a job. Job outputs are available to all downstream jobs that depend on this job.
        :param services: (experimental) Used to host service containers for a job in a workflow. Service containers are useful for creating databases or cache services like Redis. The runner automatically creates a Docker network and manages the life cycle of the service containers.
        :param strategy: (experimental) A strategy creates a build matrix for your jobs. You can define different variations to run each job in.
        :param timeout_minutes: (experimental) The maximum number of minutes to let a job run before GitHub automatically cancels it. Default: 360
        :param tools: (experimental) Tools required for this job. Traslates into ``actions/setup-xxx`` steps at the beginning of the job.

        :stability: experimental
        '''
        job = _Job_20ffcf45(
            permissions=permissions,
            runs_on=runs_on,
            steps=steps,
            concurrency=concurrency,
            container=container,
            continue_on_error=continue_on_error,
            defaults=defaults,
            env=env,
            environment=environment,
            if_=if_,
            name=name,
            needs=needs,
            outputs=outputs,
            services=services,
            strategy=strategy,
            timeout_minutes=timeout_minutes,
            tools=tools,
        )

        return typing.cast(None, jsii.invoke(self, "addPostBuildJob", [id, job]))

    @jsii.member(jsii_name="addPostBuildSteps")
    def add_post_build_steps(self, *steps: _JobStep_c3287c05) -> None:
        '''(experimental) Adds steps that are executed after the build.

        :param steps: The job steps.

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "addPostBuildSteps", [*steps]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="buildJobIds")
    def build_job_ids(self) -> typing.List[builtins.str]:
        '''(experimental) Returns a list of job IDs that are part of the build.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "buildJobIds"))


@jsii.data_type(
    jsii_type="projen.build.BuildWorkflowOptions",
    jsii_struct_bases=[],
    name_mapping={
        "artifacts_directory": "artifactsDirectory",
        "build_task": "buildTask",
        "antitamper": "antitamper",
        "container_image": "containerImage",
        "env": "env",
        "git_identity": "gitIdentity",
        "mutable_build": "mutableBuild",
        "post_build_steps": "postBuildSteps",
        "pre_build_steps": "preBuildSteps",
    },
)
class BuildWorkflowOptions:
    def __init__(
        self,
        *,
        artifacts_directory: builtins.str,
        build_task: _Task_9fa875b6,
        antitamper: typing.Optional[builtins.bool] = None,
        container_image: typing.Optional[builtins.str] = None,
        env: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        git_identity: typing.Optional[_GitIdentity_6effc3de] = None,
        mutable_build: typing.Optional[builtins.bool] = None,
        post_build_steps: typing.Optional[typing.Sequence[_JobStep_c3287c05]] = None,
        pre_build_steps: typing.Optional[typing.Sequence[_JobStep_c3287c05]] = None,
    ) -> None:
        '''
        :param artifacts_directory: (experimental) A name of a directory that includes build artifacts.
        :param build_task: (experimental) The task to execute in order to build the project.
        :param antitamper: (experimental) Enable anti-tamper check. Default: true
        :param container_image: (experimental) The container image to use for builds. Default: - the default workflow container
        :param env: (experimental) Build environment variables. Default: {}
        :param git_identity: (experimental) Git identity to use for the workflow. Default: - default identity
        :param mutable_build: (experimental) Automatically update files modified during builds to pull-request branches. This means that any files synthesized by projen or e.g. test snapshots will always be up-to-date before a PR is merged. Implies that PR builds do not have anti-tamper checks. Default: true
        :param post_build_steps: (experimental) Steps to execute after build. Default: []
        :param pre_build_steps: (experimental) Steps to execute before the build. Default: []

        :stability: experimental
        '''
        if isinstance(git_identity, dict):
            git_identity = _GitIdentity_6effc3de(**git_identity)
        self._values: typing.Dict[str, typing.Any] = {
            "artifacts_directory": artifacts_directory,
            "build_task": build_task,
        }
        if antitamper is not None:
            self._values["antitamper"] = antitamper
        if container_image is not None:
            self._values["container_image"] = container_image
        if env is not None:
            self._values["env"] = env
        if git_identity is not None:
            self._values["git_identity"] = git_identity
        if mutable_build is not None:
            self._values["mutable_build"] = mutable_build
        if post_build_steps is not None:
            self._values["post_build_steps"] = post_build_steps
        if pre_build_steps is not None:
            self._values["pre_build_steps"] = pre_build_steps

    @builtins.property
    def artifacts_directory(self) -> builtins.str:
        '''(experimental) A name of a directory that includes build artifacts.

        :stability: experimental
        '''
        result = self._values.get("artifacts_directory")
        assert result is not None, "Required property 'artifacts_directory' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def build_task(self) -> _Task_9fa875b6:
        '''(experimental) The task to execute in order to build the project.

        :stability: experimental
        '''
        result = self._values.get("build_task")
        assert result is not None, "Required property 'build_task' is missing"
        return typing.cast(_Task_9fa875b6, result)

    @builtins.property
    def antitamper(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enable anti-tamper check.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("antitamper")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def container_image(self) -> typing.Optional[builtins.str]:
        '''(experimental) The container image to use for builds.

        :default: - the default workflow container

        :stability: experimental
        '''
        result = self._values.get("container_image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) Build environment variables.

        :default: {}

        :stability: experimental
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def git_identity(self) -> typing.Optional[_GitIdentity_6effc3de]:
        '''(experimental) Git identity to use for the workflow.

        :default: - default identity

        :stability: experimental
        '''
        result = self._values.get("git_identity")
        return typing.cast(typing.Optional[_GitIdentity_6effc3de], result)

    @builtins.property
    def mutable_build(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Automatically update files modified during builds to pull-request branches.

        This means
        that any files synthesized by projen or e.g. test snapshots will always be up-to-date
        before a PR is merged.

        Implies that PR builds do not have anti-tamper checks.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("mutable_build")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def post_build_steps(self) -> typing.Optional[typing.List[_JobStep_c3287c05]]:
        '''(experimental) Steps to execute after build.

        :default: []

        :stability: experimental
        '''
        result = self._values.get("post_build_steps")
        return typing.cast(typing.Optional[typing.List[_JobStep_c3287c05]], result)

    @builtins.property
    def pre_build_steps(self) -> typing.Optional[typing.List[_JobStep_c3287c05]]:
        '''(experimental) Steps to execute before the build.

        :default: []

        :stability: experimental
        '''
        result = self._values.get("pre_build_steps")
        return typing.cast(typing.Optional[typing.List[_JobStep_c3287c05]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BuildWorkflowOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "BuildWorkflow",
    "BuildWorkflowOptions",
]

publication.publish()
