"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const component_1 = require("../component");
const file_1 = require("../file");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const source_code_1 = require("../source-code");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
/**
 * (experimental) React project without TypeScript.
 *
 * @experimental
 * @pjid react
 */
class ReactProject extends javascript_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f;
        super({
            jest: false,
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        new ReactComponent(this, { typescript: false, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_f = options.sampleCode) !== null && _f !== void 0 ? _f : true) {
            new ReactSampleCode(this, {
                fileExt: 'jsx',
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, 'public', { sourceDir: path.join(__dirname, '..', '..', 'assets', 'web', 'react') });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.46.3" };
/**
 * (experimental) React project with TypeScript.
 *
 * @experimental
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g;
        const defaultOptions = {
            srcdir: 'src',
            eslint: false,
            jest: false,
            tsconfig: {
                include: ['src'],
                compilerOptions: {
                    target: 'es5',
                    lib: [
                        'dom',
                        'dom.iterable',
                        'esnext',
                    ],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: 'esnext',
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: javascript_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: (_e = options.typescriptVersion) !== null && _e !== void 0 ? _e : '^4.0.3',
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_f = options.srcdir) !== null && _f !== void 0 ? _f : 'src';
        new ReactComponent(this, { typescript: true, rewire: options.rewire });
        this.reactTypeDef = new ReactTypeDef(this, 'react-app-env.d.ts');
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new ReactSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, 'public', { sourceDir: path.join(__dirname, '..', '..', 'assets', 'web', 'react') });
        }
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.46.3" };
/**
 * @experimental
 */
class ReactComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f, _g;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps('react', 'react-dom', 'react-scripts@^5', 'web-vitals');
        project.addDevDeps('@testing-library/jest-dom', '@testing-library/react', '@testing-library/user-event');
        if (this.typescript) {
            project.addDevDeps('@types/jest', '@types/react', '@types/react-dom');
        }
        const rewire = (_f = options.rewire) !== null && _f !== void 0 ? _f : false;
        if (rewire) {
            const overridesPath = '.projen/react-config-overrides.js';
            project.addDevDeps('react-app-rewired');
            project.addFields({ 'config-overrides-path': overridesPath });
            const configOverrides = new source_code_1.SourceCode(this.project, overridesPath);
            configOverrides.line(`// ${file_1.FileBase.PROJEN_MARKER}`);
            configOverrides.line('/**');
            configOverrides.line(' * Override CRA configuration without needing to eject.');
            configOverrides.line(' *');
            configOverrides.line(' * @see https://www.npmjs.com/package/react-app-rewired');
            configOverrides.line(' */');
            configOverrides.open('module.exports = function override(config, env) {');
            for (const [key, value] of Object.entries(rewire)) {
                configOverrides.line(`config.${key} = ${JSON.stringify(value)};`);
            }
            configOverrides.line('return config;');
            configOverrides.close('};');
        }
        const reactScripts = rewire ? 'react-app-rewired' : 'react-scripts';
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask('dev', {
            description: 'Starts the react application',
            exec: `${reactScripts} start`,
        });
        project.compileTask.exec(`${reactScripts} build`);
        project.addTask('eject', {
            description: 'Ejects your React application from react-scripts',
            // eject is not necessary to rewire
            exec: 'react-scripts eject',
        });
        project.testTask.exec(`${reactScripts} test --watchAll=false`);
        const testWatch = project.tasks.tryFind('test:watch');
        testWatch === null || testWatch === void 0 ? void 0 : testWatch.reset(`${reactScripts} test`);
        (_g = project.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('# Build', '/build/');
        project.gitignore.exclude('# Build', '/build/');
        project.package.addField('eslintConfig', {
            extends: [
                'react-app',
                'react-app/jest',
            ],
        });
        project.package.addField('browserslist', {
            production: [
                '>0.2%',
                'not dead',
                'not op_mini all',
            ],
            development: [
                'last 1 chrome version',
                'last 1 firefox version',
                'last 1 safari version',
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.46.3" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'jsx';
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            '    </g>',
            '</svg>',
            '',
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            '',
            'function App() {',
            '  return (',
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            '        <p>',
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            '        </p>',
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Learn React',
            '        </a>',
            '      </header>',
            '    </div>',
            '  );',
            '}',
            '',
            'export default App;',
            '',
        ];
        const appCss = [
            '.App {',
            '  text-align: center;',
            '}',
            '',
            '.App-logo {',
            '  height: 40vmin;',
            '  pointer-events: none;',
            '}',
            '',
            '@media (prefers-reduced-motion: no-preference) {',
            '  .App-logo {',
            '    animation: App-logo-spin infinite 20s linear;',
            '  }',
            '}',
            '',
            '.App-header {',
            '  background-color: #282c34;',
            '  min-height: 100vh;',
            '  display: flex;',
            '  flex-direction: column;',
            '  align-items: center;',
            '  justify-content: center;',
            '  font-size: calc(10px + 2vmin);',
            '  color: white;',
            '}',
            '',
            '.App-link {',
            '  color: #61dafb;',
            '}',
            '',
            '@keyframes App-logo-spin {',
            '  from {',
            '    transform: rotate(0deg);',
            '  }',
            '  to {',
            '    transform: rotate(360deg);',
            '  }',
            '}',
            '',
        ];
        const appTestJsx = [
            "import React from 'react';",
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            '',
            "test('renders learn react link', () => {",
            '  render(<App />);',
            '  const linkElement = screen.getByText(/learn react/i);',
            '  expect(linkElement).toBeInTheDocument();',
            '});',
            '',
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            '',
            'ReactDOM.render(',
            '  <React.StrictMode>',
            '    <App />',
            '  </React.StrictMode>,',
            "  document.getElementById('root')",
            ');',
            '',
            '// If you want to start measuring performance in your app, pass a function',
            '// to log results (for example: reportWebVitals(console.log))',
            '// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals',
            'reportWebVitals();',
            '',
        ];
        const indexCss = [
            'body {',
            '  margin: 0;',
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            '    sans-serif;',
            '  -webkit-font-smoothing: antialiased;',
            '  -moz-osx-font-smoothing: grayscale;',
            '}',
            '',
            'code {',
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            '    monospace;',
            '}',
            '',
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            '',
            'const reportWebVitals = (onPerfEntry?: ReportHandler) => {',
            '  if (onPerfEntry && onPerfEntry instanceof Function) {',
            "    import('web-vitals').then(({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            '      getCLS(onPerfEntry);',
            '      getFID(onPerfEntry);',
            '      getFCP(onPerfEntry);',
            '      getLCP(onPerfEntry);',
            '      getTTFB(onPerfEntry);',
            '    });',
            '  }',
            '}',
            '',
            'export default reportWebVitals;',
        ];
        const setupTestsJs = [
            '// jest-dom adds custom jest matchers for asserting on DOM nodes.',
            '// allows you to do things like:',
            '// expect(element).toHaveTextContent(/react/i)',
            '// learn more: https://github.com/testing-library/jest-dom',
            "import '@testing-library/jest-dom';",
            '',
        ];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace('x', '');
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                'logo.svg': logoSvg.join('\n'),
                ['App.' + this.fileExt]: appJsx.join('\n'),
                ['App.test.' + this.fileExt]: appTestJsx.join('\n'),
                'App.css': appCss.join('\n'),
                ['index.' + this.fileExt]: indexJsx.join('\n'),
                'index.css': indexCss.join('\n'),
                ['reportWebVitals.' + fileExtWithoutX]: reportWebVitalsJs.join('\n'),
                ['setupTests.' + fileExtWithoutX]: setupTestsJs.join('\n'),
            },
        });
    }
}
/**
 * @experimental
 */
class ReactTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="react-scripts" />',
        ].join('\n');
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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