"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
  * Relative path of devcontainer file to generate
  */
const DEVCONTAINER_FILE = '.devcontainer.json';
/**
 * (experimental) A development environment running VSCode in a container;
 *
 * used by GitHub
 * codespaces.
 *
 * @experimental
 */
class DevContainer extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        this.postCreateTasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.ports) {
            this.addPorts(...options.ports);
        }
        if (options === null || options === void 0 ? void 0 : options.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        this.config = {
            image: () => { var _b; return (_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image; },
            build: {
                dockerfile: () => { var _b; return (_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.dockerFile; },
            },
            postCreateCommand: () => this.renderTasks(),
            forwardPorts: this.ports,
            extensions: this.vscodeExtensions,
        };
        new json_1.JsonFile(this.project, DEVCONTAINER_FILE, { obj: this.config, omitEmpty: true });
    }
    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     *
     * @experimental
     */
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error('dockerImage cannot be redefined.');
        }
        this.dockerImage = image;
    }
    /**
     * (experimental) Adds tasks to run when the container starts.
     *
     * Tasks will be run in sequence.
     *
     * @param tasks The new tasks.
     * @experimental
     */
    addTasks(...tasks) {
        this.postCreateTasks.push(...tasks);
    }
    /**
     * (experimental) Adds ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports.
     * @experimental
     */
    addPorts(...ports) {
        this.ports.push(...ports);
    }
    /**
     * (experimental) Adds a list of VSCode extensions that should be automatically installed in the container.
     *
     * @param extensions The extension IDs.
     * @experimental
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderTasks() {
        if (this.postCreateTasks.length !== 0) {
            return this.postCreateTasks.map(task => `( npx projen ${task.name} )`).join(' && ');
        }
        else {
            return undefined;
        }
    }
}
exports.DevContainer = DevContainer;
_a = JSII_RTTI_SYMBOL_1;
DevContainer[_a] = { fqn: "projen.vscode.DevContainer", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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