import { Project } from '../project';
export interface SynthOutput {
    [filePath: string]: any;
}
/**
 * Creates a snapshot of the files generated by a project. Ignores any non-text
 * files so that the snapshots are human readable.
 */
export declare function synthSnapshot(project: Project): SynthOutput;
export interface DirectorySnapshotOptions {
    /**
     * Globs of files to exclude.
     * @default [] include all files
     */
    readonly excludeGlobs?: string[];
    /**
     * Only snapshot the names of files and not their contents.
     * The value for a path will be `true` if it exists.
     *
     * @default false include file content
     */
    readonly onlyFileNames?: boolean;
}
export declare function directorySnapshot(root: string, options?: DirectorySnapshotOptions): SynthOutput;
