"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const common_1 = require("../common");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const textfile_1 = require("../textfile");
const typescript_1 = require("../typescript");
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
class TypeScriptProject extends javascript_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : 'lib';
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : 'docs/';
        this.compileTask.exec('tsc --build');
        this.watchTask = this.addTask('watch', {
            description: 'Watch & compile in the background',
            exec: 'tsc --build -w',
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : 'test';
        this.gitignore.include(`/${this.testdir}/`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}/`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        if (options.entrypointTypes || this.entrypoint !== '') {
            const entrypointTypes = (_k = options.entrypointTypes) !== null && _k !== void 0 ? _k : `${path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, '.js')).replace(/\\/g, '/')}.d.ts`;
            this.package.addField('types', entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            esModuleInterop: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ['es2019'],
            module: 'CommonJS',
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: 'ES2019',
        };
        if (!options.disableTsconfig) {
            this.tsconfig = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                include: [`${this.srcdir}/**/*.ts`],
                // exclude: ['node_modules'], // TODO: shouldn't we exclude node_modules?
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            }, options.tsconfig));
        }
        const tsconfigDevFile = (_l = options.tsconfigDevFile) !== null && _l !== void 0 ? _l : 'tsconfig.dev.json';
        this.tsconfigDev = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
            fileName: tsconfigDevFile,
            include: [
                common_1.PROJEN_RC,
                `${this.srcdir}/**/*.ts`,
                `${this.testdir}/**/*.ts`,
            ],
            exclude: ['node_modules'],
            compilerOptions: compilerOptionDefaults,
        }, options.tsconfig, options.tsconfigDev));
        this.gitignore.include(`/${this.srcdir}/`);
        (_m = this.npmignore) === null || _m === void 0 ? void 0 : _m.exclude(`/${this.srcdir}/`);
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
        }
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(`/${this.libdir}/`);
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include(`/${this.libdir}/**/*.js`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude('/dist/');
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.exclude('dist'); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude('/tsconfig.json');
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude('/.github/');
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude('/.vscode/');
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude('/.idea/');
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude('/.projenrc.js');
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('tsconfig.tsbuildinfo');
        // tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them for us.
        // just run them directly from javascript.
        if (this.jest && compiledTests) {
            this.addDevDeps('@types/jest');
            const testout = path.posix.relative(this.srcdir, this.testdir);
            const libtest = path.posix.join(this.libdir, testout);
            const srctest = this.testdir;
            (_y = this.npmignore) === null || _y === void 0 ? void 0 : _y.exclude(`/${libtest}/`);
            this.jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
            this.jest.addWatchIgnorePattern(`/${this.srcdir}/`);
            const resolveSnapshotPath = (test, ext) => {
                const fullpath = test.replace(libtest, srctest);
                return path.join(path.dirname(fullpath), '__snapshots__', path.basename(fullpath, '.js') + '.ts' + ext);
            };
            const resolveTestPath = (snap, ext) => {
                const filename = path.basename(snap, '.ts' + ext) + '.js';
                const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
                return path.join(dir, filename);
            };
            const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, 'jest-snapshot-resolver.js'));
            resolver.addLine(`// ${textfile_1.TextFile.PROJEN_MARKER}`);
            resolver.addLine('const path = require("path");');
            resolver.addLine(`const libtest = "${libtest}";`);
            resolver.addLine(`const srctest= "${srctest}";`);
            resolver.addLine('module.exports = {');
            resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
            resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
            resolver.addLine('  testPathForConsistencyCheck: path.join(\'some\', \'__tests__\', \'example.test.js\')');
            resolver.addLine('};');
            this.jest.addSnapshotResolver(`./${resolver.path}`);
        }
        if (this.jest && !compiledTests) {
            this.jest.addTestMatch('**\/__tests__/**\/*.ts?(x)');
            this.jest.addTestMatch('**\/?(*.)+(spec|test).ts?(x)');
            // create a tsconfig for jest that does NOT include outDir and rootDir and
            // includes both "src" and "test" as inputs.
            this.jest.addTypeScriptSupport(this.tsconfigDev);
        }
        if ((_z = options.eslint) !== null && _z !== void 0 ? _z : true) {
            this.eslint = new javascript_1.Eslint(this, {
                tsconfigPath: `./${this.tsconfigDev.fileName}`,
                dirs: [this.srcdir],
                devdirs: [this.testdir, 'build-tools'],
                fileExtensions: ['.ts', '.tsx'],
                ...options.eslintOptions,
            });
            this.tsconfigEslint = this.tsconfigDev;
        }
        const tsver = options.typescriptVersion ? `@${options.typescriptVersion}` : '';
        this.addDevDeps(`typescript${tsver}`, 
        // @types/node versions numbers match the node runtime versions' major.minor, however, new
        // releases are only created when API changes are included in a node release... We might for
        // example have dependencies that require `node >= 12.22`, but as 12.21 and 12.22 did not
        // include API changes, `@types/node@12.20.x` is the "correct" version to use. As it is not
        // possible to easily determine the correct version to use, we pick up the latest version.
        //
        // Additionally, we default to tracking the 12.x line, as the current earliest LTS release of
        // node is 12.x, so this is what corresponds to the broadest compatibility with supported node
        // runtimes.
        `@types/node@^${semver.major((_0 = this.package.minNodeVersion) !== null && _0 !== void 0 ? _0 : '12.0.0')}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_1 = options.sampleCode) !== null && _1 !== void 0 ? _1 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_2 = options.projenrcTs) !== null && _2 !== void 0 ? _2 : false;
        if (projenrcTypeScript) {
            new typescript_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.typescript.TypeScriptProject", version: "0.46.3" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            'export class Hello {',
            '  public sayHello() {',
            '    return \'hello, world!\';',
            '  }',
            '}',
        ].join('\n');
        const testCode = [
            "import { Hello } from '../src';",
            '',
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            '});',
        ].join('\n');
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                'index.ts': srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                'hello.test.ts': testCode,
            },
        });
    }
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: '',
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.typescript.TypeScriptAppProject", version: "0.46.3" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.typescript.TypeScriptLibraryProject", version: "0.46.3" };
;
/**
 * @internal
 */
function mergeTsconfigOptions(...options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [
                ...(_d = previous.include) !== null && _d !== void 0 ? _d : [],
                ...(_e = current.include) !== null && _e !== void 0 ? _e : [],
            ],
            exclude: [
                ...(_f = previous.exclude) !== null && _f !== void 0 ? _f : [],
                ...(_g = current.exclude) !== null && _g !== void 0 ? _g : [],
            ],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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