"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) A task that can be performed on the project.
 *
 * Modeled as a series of shell
 * commands and subtasks.
 *
 * @experimental
 */
class Task {
    /**
     * @experimental
     */
    constructor(name, props = {}) {
        var _b;
        this.name = name;
        this._description = props.description;
        this.condition = props.condition;
        this.cwd = props.cwd;
        this._locked = false;
        this._env = (_b = props.env) !== null && _b !== void 0 ? _b : {};
        this._steps = [];
        this.requiredEnv = props.requiredEnv;
        if (props.exec) {
            this.exec(props.exec);
        }
    }
    /**
     * (experimental) Forbid additional changes to this task.
     *
     * @experimental
     */
    lock() {
        this._locked = true;
    }
    /**
     * (experimental) Returns the description of this task.
     *
     * Sets the description of this task.
     *
     * @experimental
     */
    get description() {
        return this._description;
    }
    /**
     * (experimental) Returns the description of this task.
     *
     * Sets the description of this task.
     *
     * @experimental
     */
    set description(desc) {
        this._description = desc;
    }
    /**
     * (experimental) Reset the task so it no longer has any commands.
     *
     * @param command the first command to add to the task after it was cleared.
     * @experimental
     */
    reset(command, options = {}) {
        this.assertUnlocked();
        while (this._steps.length) {
            this._steps.shift();
        }
        if (command) {
            this.exec(command, options);
        }
    }
    /**
     * (experimental) Executes a shell command.
     *
     * @param command Shell command.
     * @param options Options.
     * @experimental
     */
    exec(command, options = {}) {
        this.assertUnlocked();
        this._steps.push({ exec: command, ...options });
    }
    /**
     * (experimental) Execute a builtin task.
     *
     * Builtin tasks are programs bundled as part of projen itself and used as
     * helpers for various components.
     *
     * In the future we should support built-in tasks from external modules.
     *
     * @param name The name of the builtin task to execute (e.g. `release/resolve-version`).
     * @experimental
     */
    builtin(name) {
        this.assertUnlocked();
        this._steps.push({ builtin: name });
    }
    /**
     * (experimental) Say something.
     *
     * @param message Your message.
     * @param options Options.
     * @experimental
     */
    say(message, options = {}) {
        this.assertUnlocked();
        this._steps.push({ say: message, ...options });
    }
    /**
     * (deprecated) Adds a command at the beginning of the task.
     *
     * @param shell The command to add.
     * @deprecated use `prependExec()`
     */
    prepend(shell, options = {}) {
        this.assertUnlocked();
        this.prependExec(shell, options);
    }
    /**
     * (experimental) Spawns a sub-task.
     *
     * @param subtask The subtask to execute.
     * @experimental
     */
    spawn(subtask, options = {}) {
        this.assertUnlocked();
        this._steps.push({ spawn: subtask.name, ...options });
    }
    /**
     * (experimental) Adds a command at the beginning of the task.
     *
     * @param shell The command to add.
     * @experimental
     */
    prependExec(shell, options = {}) {
        this.assertUnlocked();
        this._steps.unshift({
            exec: shell,
            ...options,
        });
    }
    /**
     * (experimental) Adds a spawn instruction at the beginning of the task.
     *
     * @param subtask The subtask to execute.
     * @experimental
     */
    prependSpawn(subtask, options = {}) {
        this.assertUnlocked();
        this._steps.unshift({
            spawn: subtask.name,
            ...options,
        });
    }
    /**
     * (experimental) Says something at the beginning of the task.
     *
     * @param message Your message.
     * @experimental
     */
    prependSay(message, options = {}) {
        this.assertUnlocked();
        this._steps.unshift({
            say: message,
            ...options,
        });
    }
    /**
     * (experimental) Adds an environment variable to this task.
     *
     * @param name The name of the variable.
     * @param value The value.
     * @experimental
     */
    env(name, value) {
        this.assertUnlocked();
        this._env[name] = value;
    }
    /**
     * (experimental) Returns an immutable copy of all the step specifications of the task.
     *
     * @experimental
     */
    get steps() {
        return [...this._steps];
    }
    /**
     * Renders a task spec into the manifest.
     *
     * @internal
     */
    _renderSpec() {
        return {
            name: this.name,
            description: this.description,
            env: this._env,
            requiredEnv: this.requiredEnv,
            steps: this._steps,
            condition: this.condition,
            cwd: this.cwd,
        };
    }
    assertUnlocked() {
        if (this._locked) {
            throw new Error(`Task "${this.name}" is locked for changes`);
        }
    }
}
exports.Task = Task;
_a = JSII_RTTI_SYMBOL_1;
Task[_a] = { fqn: "projen.Task", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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