"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SampleDir = exports.SampleFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const glob = require("glob");
const component_1 = require("./component");
const util_1 = require("./util");
/**
 * (experimental) Produces a file with the given contents but only once, if the file doesn't already exist.
 *
 * Use this for creating example code files or other resources.
 *
 * @experimental
 */
class SampleFile extends component_1.Component {
    /**
     * (experimental) Creates a new SampleFile object.
     *
     * @param project - the project to tie this file to.
     * @param filePath - the relative path in the project to put the file.
     * @param options - the options for the file.
     * @experimental
     */
    constructor(project, filePath, options) {
        super(project);
        if (options.contents && options.sourcePath) {
            throw new Error('Cannot specify both \'contents\' and \'source\' fields.');
        }
        if (!options.contents && !options.sourcePath) {
            throw new Error('Must specify at least one of \'contents\' or \'source\'.');
        }
        this.filePath = filePath;
        this.options = options;
    }
    /**
     * (experimental) Synthesizes files to the project output directory.
     *
     * @experimental
     */
    synthesize() {
        let contents;
        if (this.options.contents) {
            contents = this.options.contents;
        }
        else if (this.options.sourcePath) {
            contents = fs.readFileSync(this.options.sourcePath);
        }
        this.writeOnceFileContents(this.project.outdir, this.filePath, contents !== null && contents !== void 0 ? contents : '');
    }
    /**
     * A helper function that will write the file once and return if it was written or not.
     * @param dir - the directory for the new file
     * @param filename - the filename for the new file
     * @param contents - the contents of the file to write
     * @return boolean - whether a new file was written or not.
     * @private
     */
    writeOnceFileContents(dir, filename, contents) {
        const fullFilename = path.join(dir, filename);
        if (fs.existsSync(fullFilename)) {
            return;
        }
        util_1.writeFile(fullFilename, contents, { readonly: false });
    }
}
exports.SampleFile = SampleFile;
_a = JSII_RTTI_SYMBOL_1;
SampleFile[_a] = { fqn: "projen.SampleFile", version: "0.46.3" };
/**
 * (experimental) Renders the given files into the directory if the directory does not exist.
 *
 * Use this to create sample code files
 *
 * @experimental
 */
class SampleDir extends component_1.Component {
    /**
     * (experimental) Create sample files in the given directory if the given directory does not exist.
     *
     * @param project Parent project to add files to.
     * @param dir directory to add files to.
     * @param options options for which files to create.
     * @experimental
     */
    constructor(project, dir, options) {
        super(project);
        if (!options.files && !options.sourceDir) {
            throw new Error('Must specify at least one of \'files\' or \'source\'.');
        }
        this.dir = dir;
        this.options = options;
    }
    /**
     * (experimental) Synthesizes files to the project output directory.
     *
     * @experimental
     */
    synthesize() {
        const fullOutdir = path.join(this.project.outdir, this.dir);
        if (fs.pathExistsSync(fullOutdir)) {
            return;
        }
        if (this.options.sourceDir) {
            const basedir = this.options.sourceDir;
            const files = glob.sync('**', {
                cwd: basedir,
                nodir: true,
                dot: true,
            }); // returns relative file paths with POSIX separators
            for (const file of files) {
                const sourcePath = path.join(basedir, file);
                const targetPath = path.join(fullOutdir, file);
                fs.mkdirpSync(path.dirname(targetPath));
                fs.copyFileSync(sourcePath, targetPath);
                fs.chmodSync(targetPath, util_1.getFilePermissions({ readonly: false, executable: false }));
            }
        }
        for (const filename in this.options.files) {
            util_1.writeFile(path.join(fullOutdir, filename), this.options.files[filename]);
        }
    }
}
exports.SampleDir = SampleDir;
_b = JSII_RTTI_SYMBOL_1;
SampleDir[_b] = { fqn: "projen.SampleDir", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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