"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAwsCodeArtifactRegistry = exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const consts_1 = require("../cdk/consts");
const component_1 = require("../component");
const constants_1 = require("../github/constants");
const workflows_model_1 = require("../github/workflows-model");
const node_package_1 = require("../javascript/node-package");
const JSII_RELEASE_VERSION = 'latest';
const GITHUB_PACKAGES_REGISTRY = 'npm.pkg.github.com';
const GITHUB_PACKAGES_MAVEN_REPOSITORY = 'https://maven.pkg.github.com';
const ARTIFACTS_DOWNLOAD_DIR = 'dist';
const AWS_CODEARTIFACT_REGISTRY_REGEX = /.codeartifact.*.amazonaws.com/;
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d, _e, _f, _g;
        super(project);
        // functions that create jobs associated with a specific branch
        this._jobFactories = [];
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
        this.condition = options.condition;
        this.dryRun = (_c = options.dryRun) !== null && _c !== void 0 ? _c : false;
        this.failureIssue = (_d = options.failureIssue) !== null && _d !== void 0 ? _d : false;
        this.failureIssueLabel = (_e = options.failureIssueLabel) !== null && _e !== void 0 ? _e : 'failed-release';
        this.runsOn = (_f = options.workflowRunsOn) !== null && _f !== void 0 ? _f : ['ubuntu-latest'];
        this.publishTasks = (_g = options.publishTasks) !== null && _g !== void 0 ? _g : false;
    }
    /**
     * Called by `Release` to add the publishing jobs to a release workflow
     * associated with a specific branch.
     * @param branch The branch name
     * @param options Branch options
     *
     * @internal
     */
    _renderJobsForBranch(branch, options) {
        let jobs = {};
        for (const factory of this._jobFactories) {
            jobs = {
                ...jobs,
                ...factory(branch, options),
            };
        }
        return jobs;
    }
    /**
     * (experimental) Publish to git.
     *
     * This includes generating a project-level changelog and release tags.
     *
     * @param options Options.
     * @experimental
     */
    publishToGit(options) {
        var _b;
        const releaseTagFile = options.releaseTagFile;
        const versionFile = options.versionFile;
        const changelog = options.changelogFile;
        const projectChangelogFile = options.projectChangelogFile;
        const gitBranch = (_b = options.gitBranch) !== null && _b !== void 0 ? _b : 'main';
        const taskName = (gitBranch === 'main' || gitBranch === 'master') ? 'publish:git' : `publish:git:${gitBranch}`;
        const publishTask = this.project.addTask(taskName, {
            description: 'Prepends the release changelog onto the project changelog, creates a release commit, and tags the release',
            env: {
                CHANGELOG: changelog,
                RELEASE_TAG_FILE: releaseTagFile,
                PROJECT_CHANGELOG_FILE: projectChangelogFile !== null && projectChangelogFile !== void 0 ? projectChangelogFile : '',
                VERSION_FILE: versionFile,
            },
        });
        if (projectChangelogFile) {
            publishTask.builtin('release/update-changelog');
        }
        publishTask.builtin('release/tag-version');
        if (options.gitPushCommand !== '') {
            const gitPushCommand = options.gitPushCommand || `git push --follow-tags origin ${gitBranch}`;
            publishTask.exec(gitPushCommand);
        }
        return publishTask;
    }
    /**
     * (experimental) Creates a GitHub Release.
     *
     * @param options Options.
     * @experimental
     */
    publishToGitHubReleases(options) {
        const changelogFile = options.changelogFile;
        const releaseTagFile = options.releaseTagFile;
        // create a github release
        const releaseTag = `$(cat ${releaseTagFile})`;
        const ghRelease = [
            `gh release create ${releaseTag}`,
            '-R $GITHUB_REPOSITORY',
            `-F ${changelogFile}`,
            `-t ${releaseTag}`,
            '--target $GITHUB_REF',
        ].join(' ');
        // release script that does not error when re-releasing a given version
        const idempotentRelease = [
            'errout=$(mktemp);',
            `${ghRelease} 2> $errout && true;`,
            'exitcode=$?;',
            'if [ $exitcode -ne 0 ] && ! grep -q "Release.tag_name already exists" $errout; then',
            'cat $errout;',
            'exit $exitcode;',
            'fi',
        ].join(' ');
        this.addPublishJob(() => {
            var _b;
            return {
                name: 'github',
                registryName: 'GitHub Releases',
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                publishTools: options.publishTools,
                permissions: {
                    contents: workflows_model_1.JobPermission.WRITE,
                },
                workflowEnv: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                    GITHUB_REPOSITORY: '${{ github.repository }}',
                    GITHUB_REF: '${{ github.ref }}',
                },
                run: idempotentRelease,
            };
        });
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options = {}) {
        var _b;
        const isGitHubPackages = (_b = options.registry) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_REGISTRY);
        const isAwsCodeArtifact = isAwsCodeArtifactRegistry(options.registry);
        const npmToken = node_package_1.defaultNpmToken(options.npmTokenSecret, options.registry);
        if (options.distTag) {
            this.project.logger.warn('The `distTag` option is deprecated. Use the npmDistTag option instead.');
        }
        this.addPublishJob((_branch, branchOptions) => {
            var _b, _c, _d, _e, _f, _g, _h, _j;
            if (branchOptions.npmDistTag && options.distTag) {
                throw new Error('cannot set branch-level npmDistTag and npmDistTag in publishToNpm()');
            }
            return {
                name: 'npm',
                publishTools: consts_1.JSII_TOOLCHAIN.js,
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                run: this.jsiiReleaseCommand('jsii-release-npm'),
                registryName: 'npm',
                env: {
                    NPM_DIST_TAG: (_d = (_c = branchOptions.npmDistTag) !== null && _c !== void 0 ? _c : options.distTag) !== null && _d !== void 0 ? _d : 'latest',
                    NPM_REGISTRY: options.registry,
                },
                permissions: {
                    contents: workflows_model_1.JobPermission.READ,
                    packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
                },
                workflowEnv: {
                    NPM_TOKEN: npmToken ? secret(npmToken) : undefined,
                    // if we are publishing to AWS CodeArtifact, pass AWS access keys that will be used to generate NPM_TOKEN using AWS CLI.
                    AWS_ACCESS_KEY_ID: isAwsCodeArtifact ? secret((_f = (_e = options.codeArtifactOptions) === null || _e === void 0 ? void 0 : _e.accessKeyIdSecret) !== null && _f !== void 0 ? _f : 'AWS_ACCESS_KEY_ID') : undefined,
                    AWS_SECRET_ACCESS_KEY: isAwsCodeArtifact ? secret((_h = (_g = options.codeArtifactOptions) === null || _g === void 0 ? void 0 : _g.secretAccessKeySecret) !== null && _h !== void 0 ? _h : 'AWS_SECRET_ACCESS_KEY') : undefined,
                    AWS_ROLE_TO_ASSUME: isAwsCodeArtifact ? (_j = options.codeArtifactOptions) === null || _j === void 0 ? void 0 : _j.roleToAssume : undefined,
                },
            };
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c;
            return ({
                name: 'nuget',
                publishTools: consts_1.JSII_TOOLCHAIN.dotnet,
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                run: this.jsiiReleaseCommand('jsii-release-nuget'),
                registryName: 'NuGet Gallery',
                workflowEnv: {
                    NUGET_API_KEY: secret((_c = options.nugetApiKeySecret) !== null && _c !== void 0 ? _c : 'NUGET_API_KEY'),
                },
            });
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options = {}) {
        var _b, _c;
        const isGitHubPackages = (_b = options.mavenRepositoryUrl) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_MAVEN_REPOSITORY);
        const isGitHubActor = isGitHubPackages && options.mavenUsername == undefined;
        const mavenServerId = (_c = options.mavenServerId) !== null && _c !== void 0 ? _c : (isGitHubPackages ? 'github' : undefined);
        if (isGitHubPackages && mavenServerId != 'github') {
            throw new Error('publishing to GitHub Packages requires the "mavenServerId" to be "github"');
        }
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c, _d, _e, _f, _g;
            return ({
                name: 'maven',
                registryName: 'Maven Central',
                publishTools: consts_1.JSII_TOOLCHAIN.java,
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                run: this.jsiiReleaseCommand('jsii-release-maven'),
                env: {
                    MAVEN_ENDPOINT: options.mavenEndpoint,
                    MAVEN_SERVER_ID: mavenServerId,
                    MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
                },
                workflowEnv: {
                    MAVEN_GPG_PRIVATE_KEY: isGitHubPackages ? undefined : secret((_c = options.mavenGpgPrivateKeySecret) !== null && _c !== void 0 ? _c : 'MAVEN_GPG_PRIVATE_KEY'),
                    MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: isGitHubPackages ? undefined : secret((_d = options.mavenGpgPrivateKeyPassphrase) !== null && _d !== void 0 ? _d : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE'),
                    MAVEN_PASSWORD: secret((_e = options.mavenPassword) !== null && _e !== void 0 ? _e : (isGitHubPackages ? 'GITHUB_TOKEN' : 'MAVEN_PASSWORD')),
                    MAVEN_USERNAME: isGitHubActor ? '${{ github.actor }}' : secret((_f = options.mavenUsername) !== null && _f !== void 0 ? _f : 'MAVEN_USERNAME'),
                    MAVEN_STAGING_PROFILE_ID: isGitHubPackages ? undefined : secret((_g = options.mavenStagingProfileId) !== null && _g !== void 0 ? _g : 'MAVEN_STAGING_PROFILE_ID'),
                },
                permissions: {
                    contents: workflows_model_1.JobPermission.READ,
                    packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
                },
            });
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c, _d;
            return ({
                name: 'pypi',
                registryName: 'PyPI',
                publishTools: consts_1.JSII_TOOLCHAIN.python,
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                run: this.jsiiReleaseCommand('jsii-release-pypi'),
                env: {
                    TWINE_REPOSITORY_URL: options.twineRegistryUrl,
                },
                workflowEnv: {
                    TWINE_USERNAME: secret((_c = options.twineUsernameSecret) !== null && _c !== void 0 ? _c : 'TWINE_USERNAME'),
                    TWINE_PASSWORD: secret((_d = options.twinePasswordSecret) !== null && _d !== void 0 ? _d : 'TWINE_PASSWORD'),
                },
            });
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options = {}) {
        this.addPublishJob((_branch, _branchOptions) => {
            var _b, _c, _d, _e;
            return ({
                name: 'golang',
                publishTools: consts_1.JSII_TOOLCHAIN.go,
                prePublishSteps: (_b = options.prePublishSteps) !== null && _b !== void 0 ? _b : [],
                run: this.jsiiReleaseCommand('jsii-release-golang'),
                registryName: 'GitHub Go Module Repository',
                env: {
                    GITHUB_REPO: options.githubRepo,
                    GIT_BRANCH: options.gitBranch,
                    GIT_USER_NAME: (_c = options.gitUserName) !== null && _c !== void 0 ? _c : constants_1.DEFAULT_GITHUB_ACTIONS_USER.name,
                    GIT_USER_EMAIL: (_d = options.gitUserEmail) !== null && _d !== void 0 ? _d : constants_1.DEFAULT_GITHUB_ACTIONS_USER.email,
                    GIT_COMMIT_MESSAGE: options.gitCommitMessage,
                },
                workflowEnv: {
                    GITHUB_TOKEN: secret((_e = options.githubTokenSecret) !== null && _e !== void 0 ? _e : 'GO_GITHUB_TOKEN'),
                },
            });
        });
    }
    addPublishJob(factory) {
        this._jobFactories.push((branch, branchOptions) => {
            var _b, _c;
            const opts = factory(branch, branchOptions);
            const jobname = `release_${opts.name}`;
            if (jobname in this._jobFactories) {
                throw new Error(`Duplicate job with name "${jobname}"`);
            }
            const commandToRun = this.dryRun ? `echo "DRY RUN: ${opts.run}"` : opts.run;
            ;
            const requiredEnv = new Array();
            // jobEnv is the env we pass to the github job (task environment + secrets/expressions).
            const jobEnv = { ...opts.env };
            const workflowEnvEntries = Object.entries((_b = opts.workflowEnv) !== null && _b !== void 0 ? _b : {})
                .filter(([_, value]) => value != undefined);
            for (const [name, expression] of workflowEnvEntries) {
                requiredEnv.push(name);
                jobEnv[name] = expression;
            }
            if (this.publishTasks) {
                const branchSuffix = (branch === 'main' || branch === 'master') ? '' : `:${branch}`;
                // define a task which can be used through `projen publish:xxx`.
                const task = this.project.addTask(`publish:${opts.name.toLocaleLowerCase()}${branchSuffix}`, {
                    description: `Publish this package to ${opts.registryName}`,
                    env: opts.env,
                    requiredEnv: requiredEnv,
                });
                // first verify that we are on the correct branch
                task.exec(`test "$(git branch --show-current)" = "${branch}"`);
                // run commands
                task.exec(commandToRun);
            }
            const steps = [
                {
                    name: 'Download build artifacts',
                    uses: 'actions/download-artifact@v2',
                    with: {
                        name: this.artifactName,
                        path: ARTIFACTS_DOWNLOAD_DIR,
                    },
                },
                ...opts.prePublishSteps,
                {
                    name: 'Release',
                    // it would have been nice if we could just run "projen publish:xxx" here but that is not possible because this job does not checkout sources
                    run: commandToRun,
                    env: jobEnv,
                },
            ];
            const perms = (_c = opts.permissions) !== null && _c !== void 0 ? _c : { contents: workflows_model_1.JobPermission.READ };
            if (this.failureIssue) {
                steps.push(...[
                    {
                        name: 'Extract Version',
                        if: '${{ failure() }}',
                        id: 'extract-version',
                        run: 'echo "::set-output name=VERSION::$(cat dist/version.txt)"',
                    },
                    {
                        name: 'Create Issue',
                        if: '${{ failure() }}',
                        uses: 'imjohnbo/issue-bot@v3',
                        with: {
                            labels: this.failureIssueLabel,
                            title: `Publishing v\${{ steps.extract-version.outputs.VERSION }} to ${opts.registryName} failed`,
                            body: 'See https://github.com/${{ github.repository }}/actions/runs/${{ github.run_id }}',
                        },
                        env: {
                            GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                        },
                    },
                ]);
                Object.assign(perms, { issues: workflows_model_1.JobPermission.WRITE });
            }
            return {
                [jobname]: {
                    tools: {
                        node: { version: '14.x' },
                        ...opts.publishTools,
                    },
                    name: `Publish to ${opts.registryName}`,
                    permissions: perms,
                    if: this.condition,
                    needs: [this.buildJobId],
                    runsOn: this.runsOn,
                    steps,
                },
            };
        });
    }
    jsiiReleaseCommand(command) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${command}`;
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.release.Publisher", version: "0.46.3" };
function secret(secretName) {
    return `\${{ secrets.${secretName} }}`;
}
/**
 * Evaluates if the `registryUrl` is a AWS CodeArtifact registry.
 * @param registryUrl url of registry
 * @returns true for AWS CodeArtifact
 */
function isAwsCodeArtifactRegistry(registryUrl) {
    return registryUrl && AWS_CODEARTIFACT_REGISTRY_REGEX.test(registryUrl);
}
exports.isAwsCodeArtifactRegistry = isAwsCodeArtifactRegistry;
//# sourceMappingURL=data:application/json;base64,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