"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Resolves the latest version from git tags and uses `standard-version` to bump
 * to the next version based on commits.
 *
 * This expects `standard-version` to be installed in the path.
 *
 * Environment variables:
 *
 * - OUTFILE: (required) the name of the JSON output file (the "version" field
 *   will be updated with the latest version)
 * - PRERELEASE: (optional) a prerelease tag to use (e.g. "beta")
 * - MAJOR: major version number NN to filter (tags are filtered by "vNN."
 *   prefix). if not specified, the last major version is selected
 * - CHANGELOG: name of changelog file to create
 * - RELEASE_TAG_PREFIX: (optional) a prefix to apply to the release tag
 *
 */
const bump_version_1 = require("./bump-version");
const versionFile = process.env.OUTFILE;
const prerelease = process.env.PRERELEASE;
const major = process.env.MAJOR;
const changelog = process.env.CHANGELOG;
const bumpFile = process.env.BUMPFILE;
const releaseTagFile = process.env.RELEASETAG;
const prefix = process.env.RELEASE_TAG_PREFIX;
const versionrcOptions = process.env.VERSIONRCOPTIONS;
if (!versionFile) {
    throw new Error('OUTFILE is required');
}
if (!changelog) {
    throw new Error('CHANGELOG is required');
}
if (!bumpFile) {
    throw new Error('BUMPFILE is required');
}
if (!releaseTagFile) {
    throw new Error('RELEASETAG is required');
}
const majorVersion = (major == null || major === '') ? undefined : parseInt(major);
if (majorVersion === NaN) {
    throw new Error(`MAJOR must be a number: ${majorVersion}`);
}
const opts = {
    versionFile: versionFile,
    changelog: changelog,
    majorVersion: majorVersion,
    prerelease: prerelease,
    bumpFile: bumpFile,
    releaseTagFile: releaseTagFile,
    tagPrefix: prefix,
    // doesn't work with long customization
    versionrcOptions: JSON.parse(versionrcOptions !== null && versionrcOptions !== void 0 ? versionrcOptions : '{}'),
};
bump_version_1.bump(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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