"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Venv = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("../component");
const util_1 = require("../util");
/**
 * (experimental) Manages a virtual environment through the Python venv module.
 *
 * @experimental
 */
class Venv extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        this.envdir = (_b = options.envdir) !== null && _b !== void 0 ? _b : '.env';
        this.project.addGitIgnore(`/${this.envdir}`);
        this.project.tasks.addEnvironment('VIRTUAL_ENV', `$(echo $PWD/${this.envdir})`);
        this.project.tasks.addEnvironment('PATH', `$(echo $PWD/${this.envdir}/bin:$PATH)`);
    }
    /**
     * (experimental) Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     *
     * @experimental
     */
    setupEnvironment() {
        const absoluteEnvdir = path.join(this.project.outdir, this.envdir);
        if (!fs.pathExistsSync(absoluteEnvdir)) {
            this.project.logger.info('Setting up a virtual environment...');
            util_1.exec(`python -m venv ${this.envdir}`, { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ./${this.envdir}).`);
        }
    }
}
exports.Venv = Venv;
_a = JSII_RTTI_SYMBOL_1;
Venv[_a] = { fqn: "projen.python.Venv", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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