"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Setuptools = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const setuppy_1 = require("./setuppy");
/**
 * (experimental) Manages packaging through setuptools with a setup.py script.
 *
 * @experimental
 */
class Setuptools extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        project.addDevDependency('wheel@0.36.2');
        project.addDevDependency('twine@3.3.0');
        project.packageTask.exec('python setup.py sdist bdist_wheel');
        this.publishTestTask = project.addTask('publish:test', {
            description: 'Uploads the package against a test PyPI endpoint.',
            exec: 'twine upload --repository-url https://test.pypi.org/legacy/ dist/*',
        });
        this.publishTask = project.addTask('publish', {
            description: 'Uploads the package against a test PyPI endpoint.',
            exec: 'twine upload dist/*',
        });
        new setuppy_1.SetupPy(project, {
            name: project.name,
            packages: [project.moduleName],
            authorName: options.authorName,
            authorEmail: options.authorEmail,
            version: options.version,
            description: options.description,
            license: options.license,
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.setupConfig,
        });
    }
}
exports.Setuptools = Setuptools;
_a = JSII_RTTI_SYMBOL_1;
Setuptools[_a] = { fqn: "projen.python.Setuptools", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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