"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("../github");
const project_1 = require("../project");
const pip_1 = require("./pip");
const poetry_1 = require("./poetry");
const projenrc_1 = require("./projenrc");
const pytest_1 = require("./pytest");
const python_sample_1 = require("./python-sample");
const setuptools_1 = require("./setuptools");
const venv_1 = require("./venv");
/** Allowed characters in python project names */
const PYTHON_PROJECT_NAME_REGEX = /^[A-Za-z0-9-_\.]+$/;
/**
 * (experimental) Python project.
 *
 * @experimental
 * @pjid python
 */
class PythonProject extends github_1.GitHubProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        super(options);
        if (!PYTHON_PROJECT_NAME_REGEX.test(options.name)) {
            throw new Error('Python projects must only consist of alphanumeric characters, hyphens, and underscores.');
        }
        this.moduleName = options.moduleName;
        this.version = options.version;
        if ((_b = options.projenrcPython) !== null && _b !== void 0 ? _b : true) {
            new projenrc_1.Projenrc(this, options.projenrcPythonOptions);
        }
        if ((_c = options.venv) !== null && _c !== void 0 ? _c : true) {
            this.envManager = new venv_1.Venv(this, options.venvOptions);
        }
        if ((_d = options.pip) !== null && _d !== void 0 ? _d : true) {
            this.depsManager = new pip_1.Pip(this);
        }
        if ((_e = options.setuptools) !== null && _e !== void 0 ? _e : (this.projectType === project_1.ProjectType.LIB)) {
            this.packagingManager = new setuptools_1.Setuptools(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                setupConfig: options.setupConfig,
            });
        }
        // if (options.conda ?? false) {
        //   this.depsManager = new Conda(this, options);
        //   this.envManager = this.depsManager;
        // }
        // if (options.pipenv ?? false) {
        //   this.depsManager = new Pipenv(this, options);
        //   this.envManager = this.depsManager;
        // }
        if ((_f = options.poetry) !== null && _f !== void 0 ? _f : false) {
            const poetry = new poetry_1.Poetry(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                poetryOptions: {
                    readme: (_h = (_g = options.readme) === null || _g === void 0 ? void 0 : _g.filename) !== null && _h !== void 0 ? _h : 'README.md',
                    ...options.poetryOptions,
                },
            });
            this.depsManager = poetry;
            this.envManager = poetry;
            this.packagingManager = poetry;
        }
        if (!this.envManager) {
            throw new Error('At least one tool must be chosen for managing the environment (venv, conda, pipenv, or poetry).');
        }
        if (!this.depsManager) {
            throw new Error('At least one tool must be chosen for managing dependencies (pip, conda, pipenv, or poetry).');
        }
        if (!this.packagingManager && this.projectType === project_1.ProjectType.LIB) {
            throw new Error('At least one tool must be chosen for managing packaging (setuptools or poetry).');
        }
        if (Number((_j = options.venv) !== null && _j !== void 0 ? _j : true) + Number((_k = options.poetry) !== null && _k !== void 0 ? _k : false) > 1) {
            throw new Error('More than one component has been chosen for managing the environment (venv, conda, pipenv, or poetry)');
        }
        if (Number((_l = options.pip) !== null && _l !== void 0 ? _l : true) + Number((_m = options.poetry) !== null && _m !== void 0 ? _m : false) > 1) {
            throw new Error('More than one component has been chosen for managing dependencies (pip, conda, pipenv, or poetry)');
        }
        if (Number((_o = options.setuptools) !== null && _o !== void 0 ? _o : true) + Number((_p = options.poetry) !== null && _p !== void 0 ? _p : false) > 1) {
            throw new Error('More than one component has been chosen for managing packaging (setuptools or poetry)');
        }
        if ((_q = options.pytest) !== null && _q !== void 0 ? _q : true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
        }
        if ((_r = options.sample) !== null && _r !== void 0 ? _r : true) {
            new python_sample_1.PythonSample(this, {});
        }
        for (const dep of (_s = options.deps) !== null && _s !== void 0 ? _s : []) {
            this.addDependency(dep);
        }
        for (const dep of (_t = options.devDeps) !== null && _t !== void 0 ? _t : []) {
            this.addDevDependency(dep);
        }
        this.addDefaultGitIgnore();
    }
    /**
     * Adds default gitignore options for a Python project based on
     * https://github.com/github/gitignore/blob/master/Python.gitignore
     */
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Byte-compiled / optimized / DLL files', '__pycache__/', '*.py[cod]', '*$py.class', '', '# C extensions', '*.so', '', '# Distribution / packaging', '.Python', 'build/', 'develop-eggs/', 'dist/', 'downloads/', 'eggs/', '.eggs/', 'lib/', 'lib64/', 'parts/', 'sdist/', 'var/', 'wheels/', 'share/python-wheels/', '*.egg-info/', '.installed.cfg', '*.egg', 'MANIFEST', '', '# PyInstaller', '#  Usually these files are written by a python script from a template', '#  before PyInstaller builds the exe, so as to inject date/other infos into it.', '*.manifest', '*.spec', '', '# Installer logs', 'pip-log.txt', 'pip-delete-this-directory.txt', '', '# Unit test / coverage reports', 'htmlcov/', '.tox/', '.nox/', '.coverage', '.coverage.*', '.cache', 'nosetests.xml', 'coverage.xml', '*.cover', '*.py,cover', '.hypothesis/', '.pytest_cache/', 'cover/', '', '# Translations', '*.mo', '*.pot', '', '# Django stuff:', '*.log', 'local_settings.py', 'db.sqlite3', 'db.sqlite3-journal', '', '# Flask stuff:', 'instance/', '.webassets-cache', '', '# Scrapy stuff:', '.scrapy', '', '# Sphinx documentation', 'docs/_build/', '', '# PyBuilder', '.pybuilder/', 'target/', '', '# Jupyter Notebook', '.ipynb_checkpoints', '', '# IPython', 'profile_default/', 'ipython_config.py', '', '# PEP 582; used by e.g. github.com/David-OConnor/pyflow', '__pypackages__/', '', '# Celery stuff', 'celerybeat-schedule', 'celerybeat.pid', '', '# SageMath parsed files', '*.sage.py', '', '# Environments', '.env', '.venv', 'env/', 'venv/', 'ENV/', 'env.bak/', 'venv.bak/', '', '# Spyder project settings', '.spyderproject', '.spyproject', '', '# Rope project settings', '.ropeproject', '', '# mkdocs documentation', '/site', '', '# mypy', '.mypy_cache/', '.dmypy.json', 'dmypy.json', '', '# Pyre type checker', '.pyre/', '', '# pytype static type analyzer', '.pytype/', '', '# Cython debug symbols', 'cython_debug/');
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.depsManager.addDependency(spec);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        return this.depsManager.addDevDependency(spec);
    }
    /**
     * (experimental) Called after all components are synthesized.
     *
     * Order is *not* guaranteed.
     *
     * @experimental
     */
    postSynthesize() {
        super.postSynthesize();
        this.envManager.setupEnvironment();
        this.depsManager.installDependencies();
    }
}
exports.PythonProject = PythonProject;
_a = JSII_RTTI_SYMBOL_1;
PythonProject[_a] = { fqn: "projen.python.PythonProject", version: "0.46.3" };
//# sourceMappingURL=data:application/json;base64,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