"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pip = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const task_runtime_1 = require("../task-runtime");
const requirements_file_1 = require("./requirements-file");
/**
 * (experimental) Manages dependencies using a requirements.txt file and the pip CLI tool.
 *
 * @experimental
 */
class Pip extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, _options = {}) {
        super(project);
        new requirements_file_1.RequirementsFile(project, 'requirements.txt', { packageProvider: new RuntimeDependencyProvider(project) });
        new requirements_file_1.RequirementsFile(project, 'requirements-dev.txt', { packageProvider: new DevDependencyProvider(project) });
        this.installTask = project.addTask('install', {
            description: 'Install and upgrade dependencies',
        });
        this.installTask.exec('pip install --upgrade pip');
        this.installTask.exec('pip install -r requirements.txt');
        this.installTask.exec('pip install -r requirements-dev.txt');
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.DEVENV);
    }
    /**
     * (experimental) Installs dependencies (called during post-synthesis).
     *
     * @experimental
     */
    installDependencies() {
        this.project.logger.info('Installing dependencies...');
        const runtime = new task_runtime_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Pip = Pip;
_a = JSII_RTTI_SYMBOL_1;
Pip[_a] = { fqn: "projen.python.Pip", version: "0.46.3" };
class RuntimeDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter(dep => dep.type === dependencies_1.DependencyType.RUNTIME);
    }
}
class DevDependencyProvider {
    constructor(pythonProject) {
        this.pythonProject = pythonProject;
    }
    get packages() {
        return this.pythonProject.deps.all.filter(dep => dep.type === dependencies_1.DependencyType.DEVENV);
    }
}
//# sourceMappingURL=data:application/json;base64,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