"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const vm = require("vm");
const inventory_1 = require("./inventory");
const render_options_1 = require("./javascript/render-options");
const option_hints_1 = require("./option-hints");
/**
 * (experimental) Programmatic API for projen.
 *
 * @experimental
 */
class Projects {
    constructor() { }
    /**
     * (experimental) Creates a new project with defaults.
     *
     * This function creates the project type in-process (with in VM) and calls
     * `.synth()` on it (if `options.synth` is not `false`).
     *
     * At the moment, it also generates a `.projenrc.js` file with the same code
     * that was just executed. In the future, this will also be done by the project
     * type, so we can easily support multiple languages of projenrc.
     *
     * @experimental
     */
    static createProject(options) {
        createProject(options);
    }
}
exports.Projects = Projects;
_a = JSII_RTTI_SYMBOL_1;
Projects[_a] = { fqn: "projen.Projects", version: "0.46.3" };
function createProject(opts) {
    var _b, _c, _d;
    const projectType = inventory_1.resolveProjectType(opts.projectFqn);
    // Default project resolution location
    let mod = './index';
    // External projects need to load the module from the modules directory
    if (projectType.moduleName !== 'projen') {
        try {
            mod = path.dirname(require.resolve(path.join(projectType.moduleName, 'package.json'), { paths: [process.cwd()] }));
        }
        catch (err) {
            throw new Error(`External project module '${projectType.moduleName}' could not be resolved.`);
        }
    }
    // "dir" is exposed as a top-level option to require users to specify a value for it
    opts.projectOptions.outdir = opts.dir;
    // pass the FQN of the project type to the project initializer so it can
    // generate the projenrc file.
    const { renderedOptions } = render_options_1.renderJavaScriptOptions({
        bootstrap: true,
        comments: (_b = opts.optionHints) !== null && _b !== void 0 ? _b : option_hints_1.InitProjectOptionHints.FEATURED,
        type: projectType,
        args: opts.projectOptions,
        omitFromBootstrap: ['outdir'],
    });
    // generate a random variable name because jest tests appear to share
    // VM contexts, causing
    //
    // > SyntaxError: Identifier 'project' has already been declared
    //
    // errors if this isn't unique
    const varName = 'project' + Math.random().toString(36).slice(2);
    const initProjectCode = `const ${varName} = new ${projectType.typename}(${renderedOptions});`;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const module = require(mod);
    const ctx = vm.createContext(module);
    const synth = (_c = opts.synth) !== null && _c !== void 0 ? _c : true;
    const postSynth = (_d = opts.post) !== null && _d !== void 0 ? _d : true;
    process.env.PROJEN_DISABLE_POST = (!postSynth).toString();
    vm.runInContext([
        initProjectCode,
        synth ? `${varName}.synth();` : '',
    ].join('\n'), ctx);
}
//# sourceMappingURL=data:application/json;base64,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