import { InitProjectOptionHints } from './option-hints';
/**
 * @experimental
 */
export interface CreateProjectOptions {
    /**
     * (experimental) Directory that the project will be generated in.
     *
     * @experimental
     */
    readonly dir: string;
    /**
     * (experimental) Fully-qualified name of the project type (usually formatted as `module.ProjectType`).
     *
     * @experimental
     * @example
     *
     * `projen.TypescriptProject`
     */
    readonly projectFqn: string;
    /**
     * (experimental) Project options.
     *
     * Only JSON-like values can be passed in (strings,
     * booleans, numbers, enums, arrays, and objects that are not
     * derived from classes).
     *
     * Consult the API reference of the project type you are generating for
     * information about what fields and types are available.
     *
     * @experimental
     */
    readonly projectOptions: Record<string, any>;
    /**
     * (experimental) Should we render commented-out default options in the projenrc file?
     *
     * Does not apply to projenrc.json files.
     *
     * @default InitProjectOptionHints.FEATURED
     * @experimental
     */
    readonly optionHints?: InitProjectOptionHints;
    /**
     * (experimental) Should we call `project.synth()` or instantiate the project (could still have side-effects) and render the .projenrc file.
     *
     * @default true
     * @experimental
     */
    readonly synth?: boolean;
    /**
     * (experimental) Should we execute post synthesis hooks?
     *
     * (usually package manager install).
     *
     * @default true
     * @experimental
     */
    readonly post?: boolean;
}
/**
 * (experimental) Programmatic API for projen.
 *
 * @experimental
 */
export declare class Projects {
    /**
     * (experimental) Creates a new project with defaults.
     *
     * This function creates the project type in-process (with in VM) and calls
     * `.synth()` on it (if `options.synth` is not `false`).
     *
     * At the moment, it also generates a `.projenrc.js` file with the same code
     * that was just executed. In the future, this will also be done by the project
     * type, so we can easily support multiple languages of projenrc.
     *
     * @experimental
     */
    static createProject(options: CreateProjectOptions): void;
    private constructor();
}
