import { Component } from './component';
import { Dependencies } from './dependencies';
import { FileBase } from './file';
import { GitAttributesFile } from './gitattributes';
import { IgnoreFile } from './ignore-file';
import * as inventory from './inventory';
import { JsonFile } from './json';
import { Logger, LoggerOptions } from './logger';
import { ObjectFile } from './object-file';
import { InitProjectOptionHints } from './option-hints';
import { ProjectBuild as ProjectBuild } from './project-build';
import { ProjenrcOptions } from './projenrc-json';
import { Task, TaskOptions } from './task';
import { Tasks } from './tasks';
/**
 * (experimental) Options for `Project`.
 *
 * @experimental
 */
export interface ProjectOptions {
    /**
     * (experimental) This is the name of your project.
     *
     * @default $BASEDIR
     * @experimental
     * @featured true
     */
    readonly name: string;
    /**
     * (experimental) The parent project, if this project is part of a bigger project.
     *
     * @experimental
     */
    readonly parent?: Project;
    /**
     * (experimental) The root directory of the project.
     *
     * Relative to this directory, all files are synthesized.
     *
     * If this project has a parent, this directory is relative to the parent
     * directory and it cannot be the same as the parent or any of it's other
     * sub-projects.
     *
     * @default "."
     * @experimental
     */
    readonly outdir?: string;
    /**
     * (experimental) Configure logging options such as verbosity.
     *
     * @default {}
     * @experimental
     */
    readonly logging?: LoggerOptions;
    /**
     * (experimental) Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.
     *
     * @default false
     * @experimental
     */
    readonly projenrcJson?: boolean;
    /**
     * (experimental) Options for .projenrc.json.
     *
     * @default - default options
     * @experimental
     */
    readonly projenrcJsonOptions?: ProjenrcOptions;
    /**
     * (experimental) The shell command to use in order to run the projen CLI.
     *
     * Can be used to customize in special environments.
     *
     * @default "npx projen"
     * @experimental
     */
    readonly projenCommand?: string;
}
/**
 * (experimental) Base project.
 *
 * @experimental
 */
export declare class Project {
    /**
     * (experimental) The name of the default task (the task executed when `projen` is run without arguments).
     *
     * Normally
     * this task should synthesize the project files.
     *
     * @experimental
     */
    static readonly DEFAULT_TASK = "default";
    /**
     * (experimental) Project name.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) .gitignore.
     *
     * @experimental
     */
    readonly gitignore: IgnoreFile;
    /**
     * (experimental) The .gitattributes file for this repository.
     *
     * @experimental
     */
    readonly gitattributes: GitAttributesFile;
    /**
     * (experimental) A parent project.
     *
     * If undefined, this is the root project.
     *
     * @experimental
     */
    readonly parent?: Project;
    /**
     * (experimental) Absolute output directory of this project.
     *
     * @experimental
     */
    readonly outdir: string;
    /**
     * (experimental) The root project.
     *
     * @experimental
     */
    readonly root: Project;
    /**
     * (experimental) Project tasks.
     *
     * @experimental
     */
    readonly tasks: Tasks;
    /**
     * (experimental) Project dependencies.
     *
     * @experimental
     */
    readonly deps: Dependencies;
    /**
     * (experimental) Logging utilities.
     *
     * @experimental
     */
    readonly logger: Logger;
    /**
     * (experimental) The options used when this project is bootstrapped via `projen new`.
     *
     * It
     * includes the original set of options passed to the CLI and also the JSII
     * FQN of the project type.
     *
     * @experimental
     */
    readonly initProject?: InitProject;
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    readonly projenCommand: string;
    /**
     * (experimental) This is the "default" task, the one that executes "projen".
     *
     * @experimental
     */
    readonly defaultTask: Task;
    /**
     * (experimental) Manages the build process of the project.
     *
     * @experimental
     */
    readonly projectBuild: ProjectBuild;
    private readonly _components;
    private readonly subprojects;
    private readonly tips;
    private readonly excludeFromCleanup;
    /**
     * @experimental
     */
    constructor(options: ProjectOptions);
    /**
     * (experimental) Returns all the components within this project.
     *
     * @experimental
     */
    get components(): Component[];
    /**
     * (experimental) All files in this project.
     *
     * @experimental
     */
    get files(): FileBase[];
    /**
     * (experimental) Adds a new task to this project.
     *
     * This will fail if the project already has
     * a task with this name.
     *
     * @param name The task name to add.
     * @param props Task properties.
     * @experimental
     */
    addTask(name: string, props?: TaskOptions): Task;
    /**
     * (experimental) Removes a task from a project.
     *
     * @param name The name of the task to remove.
     * @returns The `Task` that was removed, otherwise `undefined`.
     * @experimental
     */
    removeTask(name: string): Task | undefined;
    /**
     * @experimental
     */
    get buildTask(): Task;
    /**
     * @experimental
     */
    get compileTask(): Task;
    /**
     * @experimental
     */
    get testTask(): Task;
    /**
     * @experimental
     */
    get preCompileTask(): Task;
    /**
     * @experimental
     */
    get postCompileTask(): Task;
    /**
     * @experimental
     */
    get packageTask(): Task;
    /**
     * (experimental) Finds a file at the specified relative path within this project and all its subprojects.
     *
     * @param filePath The file path.
     * @returns a `FileBase` or undefined if there is no file in that path
     * @experimental
     */
    tryFindFile(filePath: string): FileBase | undefined;
    /**
     * (deprecated) Finds a json file by name.
     *
     * @param filePath The file path.
     * @deprecated use `tryFindObjectFile`
     */
    tryFindJsonFile(filePath: string): JsonFile | undefined;
    /**
     * (experimental) Finds an object file (like JsonFile, YamlFile, etc.) by name.
     *
     * @param filePath The file path.
     * @experimental
     */
    tryFindObjectFile(filePath: string): ObjectFile | undefined;
    /**
     * (deprecated) Prints a "tip" message during synthesis.
     *
     * @param message The message.
     * @deprecated - use `project.logger.info(message)` to show messages during synthesis
     */
    addTip(message: string): void;
    /**
     * (experimental) Exclude the matching files from pre-synth cleanup.
     *
     * Can be used when, for example, some
     * source files include the projen marker and we don't want them to be erased during synth.
     *
     * @param globs The glob patterns to match.
     * @experimental
     */
    addExcludeFromCleanup(...globs: string[]): void;
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * By default, this is `npx projen@<version> <task>`
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task: Task): string;
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @param _pattern The glob pattern to exclude.
     * @experimental
     */
    addPackageIgnore(_pattern: string): void;
    /**
     * (experimental) Adds a .gitignore pattern.
     *
     * @param pattern The glob pattern to ignore.
     * @experimental
     */
    addGitIgnore(pattern: string): void;
    /**
     * (experimental) Consider a set of files as "generated".
     *
     * This method is implemented by
     * derived classes and used for example, to add git attributes to tell GitHub
     * that certain files are generated.
     *
     * @param _glob the glob pattern to match (could be a file path).
     * @experimental
     */
    annotateGenerated(_glob: string): void;
    /**
     * (experimental) Synthesize all project files into `outdir`.
     *
     * 1. Call "this.preSynthesize()"
     * 2. Delete all generated files
     * 3. Synthesize all sub-projects
     * 4. Synthesize all components of this project
     * 5. Call "postSynthesize()" for all components of this project
     * 6. Call "this.postSynthesize()"
     *
     * @experimental
     */
    synth(): void;
    /**
     * (experimental) Called before all components are synthesized.
     *
     * @experimental
     */
    preSynthesize(): void;
    /**
     * (experimental) Called after all components are synthesized.
     *
     * Order is *not* guaranteed.
     *
     * @experimental
     */
    postSynthesize(): void;
    /**
     * Adds a component to the project.
     * @internal
     */
    _addComponent(component: Component): void;
    /**
     * Adds a sub-project to this project.
     *
     * This is automatically called when a new project is created with `parent`
     * pointing to this project, so there is no real need to call this manually.
     *
     * @param sub-project The child project to add.
     * @internal
     */
    _addSubProject(subproject: Project): void;
    /**
     * Resolves the project's output directory.
     */
    private determineOutdir;
}
/**
 * (deprecated) Which type of project this is.
 *
 * @deprecated no longer supported at the base project level
 */
export declare enum ProjectType {
    /**
     * (deprecated) This module may be a either a library or an app.
     *
     * @deprecated
     */
    UNKNOWN = "unknown",
    /**
     * (deprecated) This is a library, intended to be published to a package manager and consumed by other projects.
     *
     * @deprecated
     */
    LIB = "lib",
    /**
     * (deprecated) This is an app (service, tool, website, etc).
     *
     * Its artifacts are intended to
     * be deployed or published for end-user consumption.
     *
     * @deprecated
     */
    APP = "app"
}
/**
 * (experimental) Information passed from `projen new` to the project object when the project is first created.
 *
 * It is used to generate projenrc files in various languages.
 *
 * @experimental
 */
export interface InitProject {
    /**
     * (experimental) The JSII FQN of the project type.
     *
     * @experimental
     */
    readonly fqn: string;
    /**
     * (experimental) Initial arguments passed to `projen new`.
     *
     * @experimental
     */
    readonly args: Record<string, any>;
    /**
     * (experimental) Project metadata.
     *
     * @experimental
     */
    readonly type: inventory.ProjectType;
    /**
     * (experimental) Include commented out options.
     *
     * Does not apply to projenrc.json files.
     *
     * @default InitProjectOptionHints.FEATURED
     * @experimental
     */
    readonly comments: InitProjectOptionHints;
}
